/*
 * Decompiled with CFR 0.152.
 */
package com.ornate;

import com.ornate.Client;
import com.ornate.sign.SignLink;
import com.ornate.util.Unzip;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;

public class CacheDownloader {
    private static final String CACHE_DOWNLOAD_LINK = "http://176.97.213.38/client/.OrnatePs.zip";
    private static final String CACHE_VERSION_DOWNLOAD_LINK = "http://176.97.213.38/client/version.txt";
    private static final String CACHE_NAME = ".OrnatePs";

    public static void init(boolean force) {
        String current = CacheDownloader.getCurrentCacheVersion();
        String latest = CacheDownloader.getLatestCacheVersion();
        System.out.println("Current: " + current + " latest: " + latest);
        if (!latest.equals(current) || force) {
            try {
                File folderOsrs;
                File folderOSRSData;
                CacheDownloader.download();
                File folder = new File(SignLink.findCacheDir() + CACHE_NAME);
                if (!folder.exists()) {
                    folder.mkdir();
                }
                if (!(folderOSRSData = new File(SignLink.findCacheDir() + ".OrnatePs./data")).exists()) {
                    folderOSRSData.mkdir();
                }
                if (!(folderOsrs = new File(SignLink.findCacheDir() + ".OrnatePs./data/osrs")).exists()) {
                    folderOsrs.mkdir();
                }
                Unzip.unZipIt(SignLink.findCacheDir() + CACHE_NAME, SignLink.findCacheDir(), true);
                File version = new File(SignLink.findDataDir() + "cacheversion.txt");
                try (FileWriter f = new FileWriter(version);){
                    f.write(latest);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cache could not be downloaded.\nPlease try again later.");
            }
        }
    }

    private static void download() {
        try {
            int length;
            URL url = new URL(CACHE_DOWNLOAD_LINK);
            URLConnection conn = url.openConnection();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            FileOutputStream out = new FileOutputStream(SignLink.findCacheDir() + File.separator + CACHE_NAME);
            long downloaded = 0L;
            int total = conn.getContentLength();
            byte[] bytes = new byte[1024];
            long startTime = System.currentTimeMillis();
            while ((length = in.read(bytes)) != -1) {
                out.write(bytes, 0, length);
                int percentage = (int)((double)(downloaded += (long)length) / (double)total * 100.0);
                int downloadSpeed = (int)(downloaded / 1024L / (1L + (System.currentTimeMillis() - startTime) / 1000L));
                Client.singleton.draw_loadup(percentage, "Downloading cache " + percentage + "% @ " + downloadSpeed + "Kb/s");
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getCurrentCacheVersion() {
        String version = "";
        try {
            File file = new File(SignLink.findDataDir() + "cacheversion.txt");
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                version = br.readLine();
                br.close();
            } else {
                file.createNewFile();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return version;
    }

    private static String getLatestCacheVersion() {
        String version = "";
        try {
            URL url = new URL(CACHE_VERSION_DOWNLOAD_LINK);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            version = br.readLine();
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return version;
    }
}

