/*
 * Decompiled with CFR 0.152.
 */
package com.ornate;

import com.ornate.Client;
import com.ornate.RSApplet;
import com.ornate.util.Assets;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public final class GameFrame
extends Frame {
    private final RSApplet applet;
    public Toolkit toolkit = Toolkit.getDefaultToolkit();
    public Dimension screenSize = this.toolkit.getScreenSize();
    public int screenWidth = (int)this.screenSize.getWidth();
    public int screenHeight = (int)this.screenSize.getHeight();
    private static final long serialVersionUID = 1L;

    public GameFrame(RSApplet applet, int width, int height, boolean resizable, boolean fullscreen) {
        this.applet = applet;
        this.setTitle("Atlas");
        this.setResizable(resizable);
        this.setUndecorated(fullscreen);
        this.setFocusTraversalKeysEnabled(false);
        this.setBackground(Color.BLACK);
        URL url = Assets.getResource("assets", "icon.png");
        if (url != null) {
            try {
                this.setIconImage(ImageIO.read(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Unable to find resource: [icon.png]");
        }
        this.setVisible(true);
        Insets insets = this.getInsets();
        if (resizable) {
            int padding = 6;
            this.setMinimumSize(new Dimension(760 + padding + insets.left + insets.right, 553 + padding + insets.top + insets.bottom));
        }
        this.setSize(width + insets.left + insets.right, height + insets.top + insets.bottom);
        this.setWindowPosition();
        while (this.getSize().getWidth() < (double)width) {
            this.setSize(width + insets.left + insets.right, height + insets.top + insets.bottom);
            this.setWindowPosition();
        }
        this.requestFocus();
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                Client.isShiftPressed = false;
                Client.isCtrlPressed = false;
            }
        });
        this.toFront();
    }

    private void setWindowPosition() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int topLeftX = device.getDefaultConfiguration().getBounds().x;
        int topLeftY = device.getDefaultConfiguration().getBounds().y;
        int screenX = device.getDefaultConfiguration().getBounds().width;
        int screenY = device.getDefaultConfiguration().getBounds().height;
        int windowPosX = (screenX - this.getWidth()) / 2 + topLeftX;
        int windowPosY = (screenY - this.getHeight()) / 2 + topLeftY;
        this.setLocation(windowPosX, windowPosY);
    }

    public void setIcon(Image image) {
        if (image != null) {
            this.setIconImage(image);
        }
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        Insets insets = this.getInsets();
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.translate(insets != null ? insets.left : 0, insets != null ? insets.top : 0);
        return graphics;
    }

    public int getFrameWidth() {
        Insets insets = this.getInsets();
        return this.getWidth() - (insets.left + insets.right);
    }

    public int getFrameHeight() {
        Insets insets = this.getInsets();
        return this.getHeight() - (insets.top + insets.bottom);
    }

    @Override
    public void update(Graphics graphics) {
        this.applet.update(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        this.applet.paint(graphics);
    }
}

