/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache;

import com.ornate.cache.bzip.BZip2Decompressor;
import com.ornate.io.Buffer;

public final class Archive {
    private final byte[] buffer;
    private final int entries;
    private final int[] identifiers;
    private final int[] extractedSizes;
    private final int[] sizes;
    private final int[] indices;
    private final boolean extracted;

    public Archive(byte[] data) {
        Buffer buffer = new Buffer(data);
        int decompressedLength = buffer.readTriByte();
        int compressedLength = buffer.readTriByte();
        if (compressedLength != decompressedLength) {
            byte[] output = new byte[decompressedLength];
            BZip2Decompressor.decompress(output, decompressedLength, data, compressedLength, 6);
            this.buffer = output;
            buffer = new Buffer(this.buffer);
            this.extracted = true;
        } else {
            this.buffer = data;
            this.extracted = false;
        }
        this.entries = buffer.readUShort();
        this.identifiers = new int[this.entries];
        this.extractedSizes = new int[this.entries];
        this.sizes = new int[this.entries];
        this.indices = new int[this.entries];
        int offset = buffer.pos + this.entries * 10;
        for (int file = 0; file < this.entries; ++file) {
            this.identifiers[file] = buffer.readInt();
            this.extractedSizes[file] = buffer.readTriByte();
            this.sizes[file] = buffer.readTriByte();
            this.indices[file] = offset;
            offset += this.sizes[file];
        }
    }

    public int getHash(String name) {
        int hash = 0;
        name = name.toUpperCase();
        for (int index = 0; index < name.length(); ++index) {
            hash = hash * 61 + name.charAt(index) - 32;
        }
        for (int file = 0; file < this.entries; ++file) {
            if (this.identifiers[file] != hash) continue;
            return hash;
        }
        return -1;
    }

    public byte[] get(String name) {
        byte[] output = null;
        int hash = 0;
        name = name.toUpperCase();
        for (int index = 0; index < name.length(); ++index) {
            hash = hash * 61 + name.charAt(index) - 32;
        }
        for (int file = 0; file < this.entries; ++file) {
            if (this.identifiers[file] != hash) continue;
            if (output == null) {
                output = new byte[this.extractedSizes[file]];
            }
            if (!this.extracted) {
                BZip2Decompressor.decompress(output, this.extractedSizes[file], this.buffer, this.sizes[file], this.indices[file]);
            } else {
                System.arraycopy(this.buffer, this.indices[file], output, 0, this.extractedSizes[file]);
            }
            return output;
        }
        return null;
    }
}

