/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache;

import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileStore {
    private static final byte[] buffer = new byte[520];
    private final RandomAccessFile dataFile;
    private final RandomAccessFile indexFile;
    private final int storeIndex;

    public FileStore(RandomAccessFile data, RandomAccessFile index, int storeIndex) {
        this.storeIndex = storeIndex;
        this.dataFile = data;
        this.indexFile = index;
    }

    public synchronized byte[] decompress(int id) {
        try {
            this.seek(this.indexFile, id * 6);
            int in = 0;
            for (int read = 0; read < 6; read += in) {
                in = this.indexFile.read(buffer, read, 6 - read);
                if (in != -1) continue;
                return null;
            }
            int size = ((buffer[0] & 0xFF) << 16) + ((buffer[1] & 0xFF) << 8) + (buffer[2] & 0xFF);
            int sector = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
            if (sector <= 0 || (long)sector > this.dataFile.length() / 520L) {
                return null;
            }
            byte[] buf = new byte[size];
            int totalRead = 0;
            int chunkLength = id <= 65535 ? 512 : 510;
            int headerLength = id <= 65535 ? 8 : 10;
            int part = 0;
            while (totalRead < size) {
                int currentFile;
                int nextSector;
                int currentPart;
                int currentIndex;
                if (sector == 0) {
                    return null;
                }
                this.seek(this.dataFile, sector * 520);
                int unread = size - totalRead;
                if (unread > chunkLength) {
                    unread = chunkLength;
                }
                int in2 = 0;
                for (int read = 0; read < unread + headerLength; read += in2) {
                    in2 = this.dataFile.read(buffer, read, unread + headerLength - read);
                    if (in2 != -1) continue;
                    return null;
                }
                if (id <= 65535) {
                    currentIndex = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                    currentPart = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                    nextSector = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                    currentFile = buffer[7] & 0xFF;
                } else {
                    currentIndex = ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                    currentPart = ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                    nextSector = ((buffer[6] & 0xFF) << 16) + ((buffer[7] & 0xFF) << 8) + (buffer[8] & 0xFF);
                    currentFile = buffer[9] & 0xFF;
                }
                if (currentIndex != id || currentPart != part || currentFile != this.storeIndex) {
                    return null;
                }
                if (nextSector < 0 || (long)nextSector > this.dataFile.length() / 520L) {
                    return null;
                }
                for (int i = 0; i < unread; ++i) {
                    buf[totalRead++] = buffer[i + headerLength];
                }
                sector = nextSector;
                ++part;
            }
            return buf;
        }
        catch (IOException _ex) {
            return null;
        }
    }

    public synchronized boolean writeFile(int length, byte[] data, int index) {
        return this.writeFile(data, index, length, true) || this.writeFile(data, index, length, false);
    }

    private synchronized boolean writeFile(byte[] bytes, int position, int length, boolean exists) {
        try {
            int sector;
            if (exists) {
                this.seek(this.indexFile, position * 6);
                int in = 0;
                for (int read = 0; read < 6; read += in) {
                    in = this.indexFile.read(buffer, read, 6 - read);
                    if (in != -1) continue;
                    return false;
                }
                sector = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                if (sector <= 0 || (long)sector > this.dataFile.length() / 520L) {
                    return false;
                }
            } else {
                sector = (int)((this.dataFile.length() + 519L) / 520L);
                if (sector == 0) {
                    sector = 1;
                }
            }
            FileStore.buffer[0] = (byte)(length >> 16);
            FileStore.buffer[1] = (byte)(length >> 8);
            FileStore.buffer[2] = (byte)length;
            FileStore.buffer[3] = (byte)(sector >> 16);
            FileStore.buffer[4] = (byte)(sector >> 8);
            FileStore.buffer[5] = (byte)sector;
            this.seek(this.indexFile, position * 6);
            this.indexFile.write(buffer, 0, 6);
            int chunkLength = position <= 65535 ? 512 : 510;
            int headerLength = position <= 65535 ? 8 : 10;
            int part = 0;
            int written = 0;
            while (written < length) {
                int nextSector = 0;
                if (exists) {
                    int read;
                    this.seek(this.dataFile, sector * 520);
                    int in = 0;
                    for (read = 0; read < headerLength && (in = this.dataFile.read(buffer, read, headerLength - read)) != -1; read += in) {
                    }
                    if (read == headerLength) {
                        int currentFile;
                        int currentPart;
                        int currentIndex;
                        if (position <= 65535) {
                            currentIndex = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                            currentPart = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                            nextSector = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                            currentFile = buffer[7] & 0xFF;
                        } else {
                            currentIndex = ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                            currentPart = ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                            nextSector = ((buffer[6] & 0xFF) << 16) + ((buffer[7] & 0xFF) << 8) + (buffer[8] & 0xFF);
                            currentFile = buffer[9] & 0xFF;
                        }
                        if (currentIndex != position || currentPart != part || currentFile != this.storeIndex) {
                            return false;
                        }
                        if (nextSector < 0 || (long)nextSector > this.dataFile.length() / 520L) {
                            return false;
                        }
                    }
                }
                if (nextSector == 0) {
                    exists = false;
                    nextSector = (int)((this.dataFile.length() + 519L) / 520L);
                    if (nextSector == 0) {
                        ++nextSector;
                    }
                    if (nextSector == sector) {
                        ++nextSector;
                    }
                }
                if (length - written <= chunkLength) {
                    nextSector = 0;
                }
                if (position <= 65535) {
                    FileStore.buffer[0] = (byte)(position >> 8);
                    FileStore.buffer[1] = (byte)position;
                    FileStore.buffer[2] = (byte)(part >> 8);
                    FileStore.buffer[3] = (byte)part;
                    FileStore.buffer[4] = (byte)(nextSector >> 16);
                    FileStore.buffer[5] = (byte)(nextSector >> 8);
                    FileStore.buffer[6] = (byte)nextSector;
                    FileStore.buffer[7] = (byte)this.storeIndex;
                } else {
                    FileStore.buffer[0] = (byte)(position >> 24);
                    FileStore.buffer[1] = (byte)(position >> 16);
                    FileStore.buffer[2] = (byte)(position >> 8);
                    FileStore.buffer[3] = (byte)position;
                    FileStore.buffer[4] = (byte)(part >> 8);
                    FileStore.buffer[5] = (byte)part;
                    FileStore.buffer[6] = (byte)(nextSector >> 16);
                    FileStore.buffer[7] = (byte)(nextSector >> 8);
                    FileStore.buffer[8] = (byte)nextSector;
                    FileStore.buffer[9] = (byte)this.storeIndex;
                }
                this.seek(this.dataFile, sector * 520);
                this.dataFile.write(buffer, 0, headerLength);
                int unwritten = length - written;
                if (unwritten > chunkLength) {
                    unwritten = chunkLength;
                }
                this.dataFile.write(bytes, written, unwritten);
                written += unwritten;
                sector = nextSector;
                ++part;
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private synchronized void seek(RandomAccessFile file, int position) throws IOException {
        try {
            file.seek(position);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getFileCount() {
        try {
            if (this.indexFile != null) {
                return this.indexFile.length() / 6L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public static enum Store {
        ARCHIVE(0),
        MODEL(1),
        ANIMATION(2),
        MUSIC(3),
        MAP(4);

        private int index;

        private Store(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

