/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.ornate.cache.Archive;
import com.ornate.cache.def.SpriteDefinition;
import com.ornate.cache.def.loaders.SpriteLoader;
import com.ornate.cache.def.provider.SpriteProvider;
import java.io.IOException;

public class SpriteManager
implements SpriteProvider {
    private final Archive fileArchive;
    private final Multimap<Integer, SpriteDefinition> sprites = LinkedListMultimap.create();

    public SpriteManager(Archive fileArchive) {
        this.fileArchive = fileArchive;
    }

    public void load() throws IOException {
        SpriteDefinition[] defs;
        SpriteLoader loader = new SpriteLoader();
        for (SpriteDefinition sprite : defs = loader.load(317, this.fileArchive.get("mapscene.dat"))) {
            this.sprites.put(sprite.getId(), sprite);
        }
    }

    @Override
    public SpriteDefinition provide(int spriteId, int frameId) {
        return this.findSprite(spriteId, frameId);
    }

    private SpriteDefinition findSprite(int spriteId, int frameId) {
        for (SpriteDefinition sprite : this.sprites.get(spriteId)) {
            if (sprite.getFrame() != frameId) continue;
            return sprite;
        }
        return null;
    }
}

