/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.anim;

import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.cache.anim.Animation;
import com.ornate.cache.anim.curses.CurseAnimations;
import com.ornate.cache.anim.hand_cannon.HandCannonAnimations;
import com.ornate.cache.anim.korasi.KorasiAnimations;
import com.ornate.io.Buffer;
import com.ornate.util.FileUtils;
import java.util.Arrays;

public final class Sequence {
    public static Sequence[] cache;
    public int frames;
    public int[] primary_frame;
    public int[] chatFrameIds;
    public int[] frameLenghts;
    public int[] frameSounds;
    public int[] secondaryFrames;
    public int frameStep = -1;
    public int[] interleaveOrder;
    public boolean stretches = false;
    public int forcedPriority = 5;
    public int leftHandItem = -1;
    public int rightHandItem = -1;
    public int maxLoops = 99;
    public int precedenceAnimating = -1;
    public int priority = -1;
    public int replyMode = 2;

    public static void init(Archive archive) {
        int animation;
        Buffer buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/anims/seq.dat") : archive.get("seq.dat"));
        int animation_size = buffer.readUShort();
        System.out.printf("Loaded %d animations loading OSRS version %d and SUB version %d%n", animation_size, 204, 2);
        if (cache == null) {
            cache = new Sequence[animation_size + 15000];
        }
        for (animation = 0; animation < animation_size; ++animation) {
            if (cache[animation] == null) {
                Sequence.cache[animation] = new Sequence();
            }
            cache[animation].decode(buffer);
            if (animation != 2851) continue;
            Sequence.cache[animation] = new Sequence();
            Sequence.cache[animation].frames = 6;
            Sequence.cache[animation].frameLenghts = new int[]{5, 5, 3, 6, 4, 3};
            Sequence.cache[animation].primary_frame = new int[]{983040, 983041, 983042, 983043, 983044, 983045};
            Sequence.cache[animation].forcedPriority = 5;
            Sequence.cache[animation].replyMode = 1;
        }
        while (animation < cache.length) {
            if (animation == 11900) {
                Sequence.cache[animation] = new Sequence();
                Sequence.cache[animation].frames = 14;
                Sequence.cache[animation].primary_frame = new int[]{188285009, 188284950, 188284989, 188285162, 188284987, 188285107, 188285131, 188285085, 188285159, 188285041, 188285071, 188285204, 188285174, 188285152};
                Sequence.cache[animation].secondaryFrames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                Sequence.cache[animation].frameLenghts = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
                Sequence.cache[animation].precedenceAnimating = 3;
                Sequence.cache[animation].priority = 1;
            }
            if (animation == 11901) {
                Sequence.cache[animation] = new Sequence();
                Sequence.cache[animation].frames = 13;
                Sequence.cache[animation].primary_frame = new int[]{19267601, 19267602, 19267603, 19267604, 19267605, 19267606, 19267607, 19267606, 19267605, 19267604, 19267603, 19267602, 19267601};
                Sequence.cache[animation].frameLenghts = new int[]{4, 3, 3, 4, 10, 10, 15, 10, 10, 4, 3, 3, 4};
                Sequence.cache[animation].secondaryFrames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                Sequence.cache[animation].interleaveOrder = new int[]{1, 2, 9, 11, 13, 15, 17, 19, 37, 39, 41, 43, 45, 164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 183, 185, 191, 192, 9999999};
                Sequence.cache[animation].forcedPriority = 6;
                Sequence.cache[animation].precedenceAnimating = 2;
                Sequence.cache[animation].priority = 2;
                Sequence.cache[animation].replyMode = 1;
            }
            if (animation == 11902) {
                Sequence.cache[animation] = new Sequence();
                Sequence.cache[animation].frames = 31;
                Sequence.cache[animation].primary_frame = new int[]{114295000, 114294953, 114295281, 114295193, 114295189, 114295249, 114295182, 114295061, 114295124, 114295007, 114295337, 114295102, 114294995, 114295283, 114295025, 114294899, 114295233, 114294879, 114295175, 114295169, 114294903, 114295091, 114295059, 114295267, 114295003, 114294981, 114294951, 114295031, 114294986, 114294820, 114295226};
                Sequence.cache[animation].frameLenghts = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
                Sequence.cache[animation].secondaryFrames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                Sequence.cache[animation].interleaveOrder = new int[]{164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 183, 185, 193, 194, 196, 197, 198, 200, 202, 203, 204, 9999999};
                Sequence.cache[animation].stretches = true;
                Sequence.cache[animation].forcedPriority = 6;
                Sequence.cache[animation].precedenceAnimating = 2;
                Sequence.cache[animation].priority = 2;
            }
            if (animation == 11903) {
                Sequence.cache[animation] = new Sequence();
                Sequence.cache[animation].frames = 34;
                Sequence.cache[animation].primary_frame = new int[]{114294842, 114295149, 114294915, 114295287, 114295192, 114294999, 114295163, 114295180, 114295126, 0x6D000D0, 114294876, 114295139, 114295229, 114294823, 114295087, 114295020, 114295040, 114294866, 114294805, 114294847, 114294863, 114294791, 114295088, 114294830, 114295188, 114294973, 114295009, 114295158, 114295093, 114295064, 114294816, 114294838, 114294824, 114294842};
                Sequence.cache[animation].frameLenghts = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
                Sequence.cache[animation].secondaryFrames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                Sequence.cache[animation].interleaveOrder = new int[]{164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 183, 185, 193, 194, 196, 197, 198, 200, 202, 203, 204, 9999999};
                Sequence.cache[animation].stretches = true;
                Sequence.cache[animation].forcedPriority = 6;
                Sequence.cache[animation].precedenceAnimating = 2;
                Sequence.cache[animation].priority = 2;
            }
            CurseAnimations.unpack(animation);
            HandCannonAnimations.unpack(animation);
            KorasiAnimations.unpack(animation);
            ++animation;
        }
        Sequence.cache[7322].frameStep = 10;
    }

    public static int findAnimFileId(int animId) {
        return Animation.getFileId(Sequence.cache[animId].primary_frame[0]);
    }

    public int get_length(int id) {
        Animation frame;
        int duration = this.frameLenghts[id];
        if (duration == 0 && (frame = Animation.get(this.primary_frame[id])) != null) {
            duration = this.frameLenghts[id] = frame.duration;
        }
        if (duration == 0) {
            duration = 1;
        }
        return duration;
    }

    private void decode(Buffer buffer) {
        int opcode;
        while ((opcode = buffer.readUByte()) != 0) {
            int i;
            int len;
            if (opcode == 1) {
                int i2;
                this.frames = buffer.readUShort();
                this.primary_frame = new int[this.frames];
                this.secondaryFrames = new int[this.frames];
                this.frameLenghts = new int[this.frames];
                for (i2 = 0; i2 < this.frames; ++i2) {
                    this.frameLenghts[i2] = buffer.readUShort();
                }
                for (i2 = 0; i2 < this.frames; ++i2) {
                    this.primary_frame[i2] = buffer.readUShort();
                    this.secondaryFrames[i2] = -1;
                }
                i2 = 0;
                while (i2 < this.frames) {
                    int n = i2++;
                    this.primary_frame[n] = this.primary_frame[n] + (buffer.readUShort() << 16);
                }
                continue;
            }
            if (opcode == 2) {
                this.frameStep = buffer.readUShort();
                continue;
            }
            if (opcode == 3) {
                int index = buffer.readUByte();
                this.interleaveOrder = new int[1 + index];
                for (int id = 0; id < index; ++id) {
                    this.interleaveOrder[id] = buffer.readUByte();
                }
                this.interleaveOrder[index] = 9999999;
                continue;
            }
            if (opcode == 4) {
                this.stretches = true;
                continue;
            }
            if (opcode == 5) {
                this.forcedPriority = buffer.readUByte();
                continue;
            }
            if (opcode == 6) {
                this.leftHandItem = buffer.readUShort();
                continue;
            }
            if (opcode == 7) {
                this.rightHandItem = buffer.readUShort();
                continue;
            }
            if (opcode == 8) {
                this.maxLoops = buffer.readUByte();
                continue;
            }
            if (opcode == 9) {
                this.precedenceAnimating = buffer.readUByte();
                continue;
            }
            if (opcode == 10) {
                this.priority = buffer.readUByte();
                continue;
            }
            if (opcode == 11) {
                this.replyMode = buffer.readUByte();
                continue;
            }
            if (opcode == 12) {
                len = buffer.readUnsignedByte();
                this.chatFrameIds = new int[len];
                for (i = 0; i < len; ++i) {
                    this.chatFrameIds[i] = buffer.readUShort();
                }
                i = 0;
                while (i < len) {
                    int n = i++;
                    this.chatFrameIds[n] = this.chatFrameIds[n] + (buffer.readUShort() << 16);
                }
                continue;
            }
            if (opcode != 13) continue;
            len = buffer.readUnsignedByte();
            this.frameSounds = new int[len];
            for (i = 0; i < len; ++i) {
                this.frameSounds[i] = buffer.read24Int();
            }
        }
        if (this.frames == 0) {
            this.frames = 1;
            this.primary_frame = new int[1];
            this.primary_frame[0] = -1;
            this.secondaryFrames = new int[1];
            this.secondaryFrames[0] = -1;
            this.frameLenghts = new int[1];
            this.frameLenghts[0] = -1;
        }
        if (this.precedenceAnimating == -1) {
            int n = this.precedenceAnimating = this.interleaveOrder == null ? 0 : 2;
        }
        if (this.priority == -1) {
            this.priority = this.interleaveOrder == null ? 0 : 2;
        }
    }

    public String toString() {
        return "Sequence{frameCount=" + this.frames + ", frameIDs=" + Arrays.toString(this.primary_frame) + ", chatFrameIds=" + Arrays.toString(this.chatFrameIds) + ", frameLenghts=" + Arrays.toString(this.frameLenghts) + ", frameSounds=" + Arrays.toString(this.frameSounds) + ", secondaryFrames=" + Arrays.toString(this.secondaryFrames) + ", frameStep=" + this.frameStep + ", interleaveOrder=" + Arrays.toString(this.interleaveOrder) + ", stretches=" + this.stretches + ", forcedPriority=" + this.forcedPriority + ", leftHandItem=" + this.leftHandItem + ", rightHandItem=" + this.rightHandItem + ", maxLoops=" + this.maxLoops + ", precedenceAnimating=" + this.precedenceAnimating + ", priority=" + this.priority + ", replyMode=" + this.replyMode + "}";
    }
}

