/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.anim;

import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.cache.anim.Sequence;
import com.ornate.cache.anim.curses.CurseGraphics;
import com.ornate.cache.anim.korasi.KorasiGraphics;
import com.ornate.cache.anim.osrs.OSRSGraphics;
import com.ornate.cache.anim.zaryte_bow.ZaryteBowGraphics;
import com.ornate.collection.ReferenceCache;
import com.ornate.entity.model.Model;
import com.ornate.io.Buffer;
import com.ornate.util.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public final class SpotAnimation {
    public static SpotAnimation[] cache;
    public int id;
    public int model_id;
    public int animation_id = -1;
    public Sequence seq;
    public short[] src_color = new short[6];
    public short[] dst_color = new short[6];
    public short[] src_texture;
    public short[] dst_texture;
    public int model_scale_x = 128;
    public int model_scale_y = 128;
    public int rotation = 0;
    public int ambient = 0;
    public int contrast = 0;
    public static ReferenceCache model_cache;

    public static void init(Archive archive) {
        int graphic;
        Buffer buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/gfx/spotanim.dat") : archive.get("spotanim.dat"));
        int amount = buffer.readUShort();
        System.out.printf("Loaded %d graphics loading OSRS version %d and SUB version %d%n", amount, 204, 2);
        if (cache == null) {
            cache = new SpotAnimation[amount + 5000];
        }
        for (graphic = 0; graphic < amount; ++graphic) {
            if (cache[graphic] == null) {
                SpotAnimation.cache[graphic] = new SpotAnimation();
            }
            SpotAnimation.cache[graphic].id = graphic;
            cache[graphic].decode(buffer);
        }
        while (graphic < cache.length) {
            OSRSGraphics.unpack(graphic);
            CurseGraphics.unpack(graphic);
            KorasiGraphics.unpack(graphic);
            ZaryteBowGraphics.unpack(graphic);
            ++graphic;
        }
    }

    public static void dump(int amount) {
        File f = new File(System.getProperty("user.home") + "/Desktop/graphics.txt");
        try {
            f.createNewFile();
            BufferedWriter bf = new BufferedWriter(new FileWriter(f));
            for (int id = 0; id < amount; ++id) {
                bf.write("case " + id + ":");
                bf.write(System.getProperty("line.separator"));
                if (SpotAnimation.cache[id].model_id > 0) {
                    bf.write("graphics[graphic].model_id = " + SpotAnimation.cache[id].model_id + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].animation_id > 0) {
                    bf.write("graphics[graphic].animation_id = " + SpotAnimation.cache[id].animation_id + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].rotation != 0) {
                    bf.write("graphics[graphic].rotation = " + SpotAnimation.cache[id].rotation + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].model_scale_x != 128) {
                    bf.write("graphics[graphic].model_scale_x = " + SpotAnimation.cache[id].model_scale_x + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].model_scale_y != 128) {
                    bf.write("graphics[graphic].model_scale_y = " + SpotAnimation.cache[id].model_scale_y + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].ambient != 0) {
                    bf.write("graphics[graphic].ambient = " + SpotAnimation.cache[id].ambient + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].contrast != 0) {
                    bf.write("graphics[graphic].contrast = " + SpotAnimation.cache[id].contrast + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].src_color != null) {
                    bf.write("graphics[graphic].src_color = new int[] " + Arrays.toString(SpotAnimation.cache[id].src_color).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (SpotAnimation.cache[id].dst_color != null) {
                    bf.write("graphics[graphic].dst_color = new int[] " + Arrays.toString(SpotAnimation.cache[id].dst_color).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                bf.write("break;");
                bf.write(System.getProperty("line.separator"));
                bf.write(System.getProperty("line.separator"));
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decode(Buffer buffer) {
        int opcode;
        block0: while ((opcode = buffer.readUByte()) != 0) {
            int index;
            int length;
            if (opcode == 1) {
                this.model_id = buffer.readUShort();
                continue;
            }
            if (opcode == 2) {
                this.animation_id = buffer.readUShort();
                if (Sequence.cache == null) continue;
                this.seq = Sequence.cache[this.animation_id];
                continue;
            }
            if (opcode == 4) {
                this.model_scale_x = buffer.readUShort();
                continue;
            }
            if (opcode == 5) {
                this.model_scale_y = buffer.readUShort();
                continue;
            }
            if (opcode == 6) {
                this.rotation = buffer.readUShort();
                continue;
            }
            if (opcode == 7) {
                this.ambient = buffer.readUByte();
                continue;
            }
            if (opcode == 8) {
                this.contrast = buffer.readUByte();
                continue;
            }
            if (opcode == 40) {
                length = buffer.readUByte();
                this.src_color = new short[length];
                this.dst_color = new short[length];
                index = 0;
                while (true) {
                    if (index >= length) continue block0;
                    this.src_color[index] = (short)buffer.readUShort();
                    this.dst_color[index] = (short)buffer.readUShort();
                    ++index;
                }
            }
            if (opcode == 41) {
                length = buffer.readUByte();
                this.src_texture = new short[length];
                this.dst_texture = new short[length];
                index = 0;
                while (true) {
                    if (index >= length) continue block0;
                    this.src_texture[index] = (short)buffer.readUShort();
                    this.dst_texture[index] = (short)buffer.readUShort();
                    ++index;
                }
            }
            System.out.println("Error unrecognised spotanim config code: " + opcode);
        }
        return;
    }

    public Model get_model() {
        int index;
        Model model = (Model)model_cache.get(this.id);
        if (model != null) {
            return model;
        }
        model = Model.get(this.model_id);
        if (model == null) {
            return null;
        }
        if (this.src_color != null) {
            for (index = 0; index < this.src_color.length; ++index) {
                if (this.src_color[0] == 0) continue;
                model.recolor(this.src_color[index], this.dst_color[index]);
            }
        }
        if (this.src_texture != null) {
            for (index = 0; index < this.src_texture.length; ++index) {
                if (this.src_texture[0] == 0) continue;
                model.retexture(this.src_texture[index], this.dst_texture[index]);
            }
        }
        model_cache.put(model, this.id);
        return model;
    }

    static {
        model_cache = new ReferenceCache(30);
    }
}

