/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.config;

import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.cache.config.VariableParameter;
import com.ornate.io.Buffer;
import com.ornate.util.FileUtils;

public final class VariableBits {
    public static VariableBits[] cache;
    public int configId;
    public int leastSignificantBit;
    public int mostSignificantBit;
    private final boolean aBoolean651;

    public static void init(Archive archive) {
        Buffer stream = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/varbits/varbit.dat") : archive.get("varbit.dat"));
        int size = stream.readUShort();
        if (cache == null) {
            cache = new VariableBits[size];
        }
        System.out.printf("Loaded %d varbits loading OSRS version %d and SUB version %d%n", size, 204, 2);
        for (int index = 0; index < size; ++index) {
            if (cache[index] == null) {
                VariableBits.cache[index] = new VariableBits();
            }
            cache[index].decode(stream);
            if (!VariableBits.cache[index].aBoolean651) continue;
            VariableParameter.values[VariableBits.cache[index].configId].aBoolean713 = true;
        }
        if (stream.pos != stream.payload.length) {
            System.err.println("varbit load mismatch");
        }
    }

    private void decode(Buffer buffer) {
        int opcode = buffer.readUByte();
        if (opcode == 0) {
            return;
        }
        if (opcode == 1) {
            this.configId = buffer.readUShort();
            this.leastSignificantBit = buffer.readUByte();
            this.mostSignificantBit = buffer.readUByte();
        } else {
            System.out.println(opcode);
        }
    }

    private VariableBits() {
        this.aBoolean651 = false;
    }
}

