/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.def;

import com.ornate.Client;
import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.cache.graphics.SimpleImage;
import com.ornate.io.Buffer;
import com.ornate.util.FileUtils;
import java.util.HashMap;

public final class AreaDefinition {
    public static int size;
    public static int mapFunctionsSize;
    public static AreaDefinition[] cache;
    public static HashMap<Integer, SimpleImage> sprites;
    public static HashMap<Integer, SimpleImage> sprites_small;
    private static int cacheIndex;
    private static Buffer area_data;
    private static int[] indices;
    public int id = -1;
    public int spriteId = -1;
    public int field3294 = -1;
    public String name = "";
    public int field3296 = -1;
    public int field3297 = -1;
    public String[] actions;
    public int field3310 = -1;

    private AreaDefinition() {
    }

    public static void clear() {
        indices = null;
        cache = null;
        area_data = null;
    }

    public static void init(Archive archive) {
        int _ctr;
        area_data = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "areas/areas.dat") : archive.get("areas.dat"));
        Buffer stream = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "areas/areas.idx") : archive.get("areas.idx"));
        size = stream.readUShort();
        mapFunctionsSize = stream.readUShort();
        indices = new int[size];
        int offset = 2;
        for (_ctr = 0; _ctr < size; ++_ctr) {
            AreaDefinition.indices[_ctr] = offset;
            offset += stream.readUShort();
        }
        cache = new AreaDefinition[10];
        for (_ctr = 0; _ctr < 10; ++_ctr) {
            AreaDefinition.cache[_ctr] = new AreaDefinition();
        }
        System.out.println("Areas read -> " + size);
    }

    public static SimpleImage getImage(int sprite, boolean small) {
        return small ? sprites_small.get(sprite) : sprites.get(sprite);
    }

    public static AreaDefinition lookup(int area) {
        for (int count = 0; count < 10; ++count) {
            if (AreaDefinition.cache[count].id != area) continue;
            return cache[count];
        }
        cacheIndex = (cacheIndex + 1) % 10;
        AreaDefinition data = cache[cacheIndex];
        try {
            if (area >= 0) {
                AreaDefinition.area_data.pos = indices[area];
                data.readValues(area_data);
                if (!sprites.containsKey(data.spriteId)) {
                    try {
                        sprites.put(data.spriteId, new SimpleImage(Client.singleton.mediaStreamLoader, "mapfunction", data.spriteId));
                        sprites_small.put(data.spriteId, new SimpleImage(sprites.get(data.spriteId).convertToImage(), 10, 10));
                    }
                    catch (Exception e) {
                        System.out.println("Missing Sprite: " + data.spriteId + " Using Shop Icon");
                        sprites.put(data.spriteId, new SimpleImage(Client.singleton.mediaStreamLoader, "mapfunction", 0));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    private void readValues(Buffer buffer) {
        int opCode;
        while ((opCode = buffer.readUnsignedByte()) != 0) {
            if (opCode == 1) {
                this.spriteId = buffer.readInt();
                continue;
            }
            if (opCode == 2) {
                this.field3294 = buffer.readInt();
                continue;
            }
            if (opCode == 3) {
                this.name = buffer.readNewString();
                continue;
            }
            if (opCode == 4) {
                this.field3296 = buffer.readInt();
                continue;
            }
            if (opCode == 5) {
                this.field3297 = buffer.readInt();
                continue;
            }
            if (opCode == 6) {
                this.field3296 = buffer.readInt();
                continue;
            }
            if (opCode >= 6 && opCode < 11) {
                if (this.actions == null) {
                    this.actions = new String[5];
                }
                this.actions[opCode - 6] = buffer.readNewString();
                continue;
            }
            if (opCode != 12) continue;
            this.field3310 = buffer.readInt();
        }
        return;
    }

    static {
        sprites = new HashMap();
        sprites_small = new HashMap();
    }
}

