/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.def;

import com.ornate.Client;
import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.util.FileUtils;
import java.nio.ByteBuffer;

public class FloDefinition {
    public static int underlay_length;
    public static int overlay_length;
    public static FloDefinition[] overlay;
    public static FloDefinition[] underlay;
    public int texture = -1;
    public int minimap_underlay;
    public boolean hidden = true;
    public int minimap_overlay;
    public int underlay_hue;
    public int underlay_saturation;
    public int underlay_luminance;
    public int overlay_hue;
    public int overlay_saturation;
    public int overlay_luminance;
    public int weighted_hue;
    public int chroma;
    public int color;

    public static void init(Archive archive) {
        int index;
        ByteBuffer buffer = ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? ByteBuffer.wrap(FileUtils.read(ClientConstants.DATA_DIR + "/floors/flo.dat")) : ByteBuffer.wrap(archive.get("flo.dat"));
        underlay_length = buffer.getShort();
        underlay = new FloDefinition[underlay_length];
        for (index = 0; index < underlay_length; ++index) {
            if (underlay[index] == null) {
                FloDefinition.underlay[index] = new FloDefinition();
            }
            underlay[index].decode(buffer, 0);
            underlay[index].generate();
        }
        overlay_length = buffer.getShort();
        overlay = new FloDefinition[overlay_length];
        for (index = 0; index < overlay_length; ++index) {
            if (overlay[index] == null) {
                FloDefinition.overlay[index] = new FloDefinition();
            }
            overlay[index].decode(buffer, 1);
            overlay[index].generate();
        }
        System.out.println("Flo read -> (" + underlay_length + " underlays) | (" + overlay_length + " overlays)");
    }

    public void decode(ByteBuffer buffer, int flag) {
        byte opcode;
        if (flag == 0) {
            while ((opcode = buffer.get()) != 0) {
                if (opcode == 1) {
                    this.minimap_underlay = ((buffer.get() & 0xFF) << 16) + ((buffer.get() & 0xFF) << 8) + (buffer.get() & 0xFF);
                    continue;
                }
                System.out.println("Error unrecognised {FLO-underlay} opcode: " + opcode);
            }
        }
        if (flag == 1) {
            while ((opcode = buffer.get()) != 0) {
                if (opcode == 1) {
                    this.minimap_underlay = ((buffer.get() & 0xFF) << 16) + ((buffer.get() & 0xFF) << 8) + (buffer.get() & 0xFF);
                    continue;
                }
                if (opcode == 2) {
                    this.texture = buffer.get() & 0xFF;
                    continue;
                }
                if (opcode == 5) {
                    this.hidden = false;
                    continue;
                }
                if (opcode == 7) {
                    this.minimap_overlay = ((buffer.get() & 0xFF) << 16) + ((buffer.get() & 0xFF) << 8) + (buffer.get() & 0xFF);
                    continue;
                }
                System.out.println("Error unrecognised {FLO-overlay} opcode: " + opcode);
            }
        }
    }

    private void generate() {
        if (this.minimap_overlay != -1) {
            this.convert(this.minimap_overlay);
            this.overlay_hue = this.underlay_hue;
            this.overlay_saturation = this.underlay_saturation;
            this.overlay_luminance = this.underlay_luminance;
        }
        if (Client.singleton.setting.ground_snow) {
            if (this.minimap_underlay == 3502602 || this.minimap_underlay == 5793803 || this.minimap_underlay == 7890955 || this.minimap_underlay == 7121936 || this.minimap_underlay == 8492337 || this.minimap_underlay == 3692079 || this.minimap_underlay == 2583847 || this.minimap_underlay == 3760661 || this.minimap_underlay == 3362846 || this.minimap_underlay == 6601589 || this.minimap_underlay == 4008715 || this.minimap_underlay == 11309144 || this.minimap_underlay == 14269331 || this.minimap_underlay == 11571288 || this.minimap_underlay == 0x302020 || this.minimap_underlay == 0x604040 || this.minimap_underlay == 9463856 || this.minimap_underlay == 3362846 || this.minimap_underlay == 6601589 || this.minimap_underlay == 0x604040 || this.minimap_underlay == 8417352 || this.minimap_underlay == 5523496 || this.minimap_underlay == 11571288 || this.minimap_underlay == 7890955 || this.minimap_underlay == 8749584 || this.minimap_underlay == 6638859 || this.minimap_underlay == 4931092 || this.minimap_underlay == 6050876 || this.minimap_underlay == 9726723 || this.minimap_underlay == 12615752) {
                this.minimap_underlay = 0xEDEDED;
            }
            if (this.minimap_underlay == 3502602 || this.minimap_underlay == 5793803 || this.minimap_underlay == 7121936 || this.minimap_underlay == 3692079 || this.minimap_underlay == 2583847 || this.minimap_underlay == 3760661 || this.minimap_underlay == 3362846 || this.minimap_underlay == 6601589) {
                this.minimap_underlay = 0xD9D9D9;
            }
            if (this.minimap_underlay == 6573598 || this.minimap_underlay == 3502602 || this.minimap_underlay == 5269515 || this.minimap_underlay == 7890955 || this.minimap_underlay == 7121936 || this.minimap_underlay == 8492337) {
                this.minimap_underlay = 0xD9D9D9;
            }
            if (this.minimap_underlay == 8026240 || this.minimap_underlay == 0x383830 || this.minimap_underlay == 0x282820 || this.minimap_underlay == 2629656 || this.minimap_underlay == 5261376 || this.minimap_underlay == 4735032 || this.minimap_underlay == 0x383828 || this.minimap_underlay == 14392 || this.minimap_underlay == 3159333 || this.minimap_underlay == 0x282848 || this.minimap_underlay == 1585176 || this.minimap_underlay == 0x4D4D4D || this.minimap_underlay == 0x2E2E2E || this.minimap_underlay == 4008715 || this.minimap_underlay == 197379 || this.minimap_underlay == 4603956 || this.minimap_underlay == 4931092 || this.minimap_underlay == 3091231 || this.minimap_underlay == 0x111E1A || this.minimap_underlay == 0x333333 || this.minimap_underlay == 2829869 || this.minimap_underlay == 0x300000 || this.minimap_underlay == 3942435 || this.minimap_underlay == 0x404040 || this.minimap_underlay == 0x383838 || this.minimap_underlay == 0x303030 || this.minimap_underlay == 0x282828 || this.minimap_underlay == 0x202020 || this.minimap_underlay == 0x181818) {
                this.minimap_underlay = 0xD9D9D9;
            }
        }
        this.convert(this.minimap_underlay);
    }

    private void convert(int rgb) {
        double max;
        double r = (double)(rgb >> 16 & 0xFF) / 256.0;
        double g = (double)(rgb >> 8 & 0xFF) / 256.0;
        double b = (double)(rgb & 0xFF) / 256.0;
        double min = r;
        if (g < min) {
            min = g;
        }
        if (b < min) {
            min = b;
        }
        if (g > (max = r)) {
            max = g;
        }
        if (b > max) {
            max = b;
        }
        double h = 0.0;
        double s = 0.0;
        double l = (min + max) / 2.0;
        if (min != max) {
            if (l < 0.5) {
                s = (max - min) / (max + min);
            }
            if (l >= 0.5) {
                s = (max - min) / (2.0 - max - min);
            }
            if (r == max) {
                h = (g - b) / (max - min);
            } else if (g == max) {
                h = 2.0 + (b - r) / (max - min);
            } else if (b == max) {
                h = 4.0 + (r - g) / (max - min);
            }
        }
        this.underlay_hue = (int)((h /= 6.0) * 256.0);
        this.underlay_saturation = (int)(s * 256.0);
        this.underlay_luminance = (int)(l * 256.0);
        if (this.underlay_saturation < 0) {
            this.underlay_saturation = 0;
        } else if (this.underlay_saturation > 255) {
            this.underlay_saturation = 255;
        }
        if (this.underlay_luminance < 0) {
            this.underlay_luminance = 0;
        } else if (this.underlay_luminance > 255) {
            this.underlay_luminance = 255;
        }
        this.chroma = l > 0.5 ? (int)((1.0 - l) * s * 512.0) : (int)(l * s * 512.0);
        if (this.chroma < 1) {
            this.chroma = 1;
        }
        this.weighted_hue = (int)(h * (double)this.chroma);
        this.color = FloDefinition.convert24to16(this.underlay_hue, this.underlay_saturation, this.underlay_luminance);
    }

    private static final int convert24to16(int h, int s, int l) {
        if (l > 179) {
            s /= 2;
        }
        if (l > 192) {
            s /= 2;
        }
        if (l > 217) {
            s /= 2;
        }
        if (l > 243) {
            s /= 2;
        }
        return (h / 4 << 10) + (s / 32 << 7) + l / 2;
    }

    private FloDefinition() {
    }
}

