/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.def;

import com.google.common.base.Preconditions;
import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.cache.def.impl.items.CustomItems;
import com.ornate.cache.def.impl.items.HigherRevRSItems;
import com.ornate.cache.def.impl.items.SummerItems;
import com.ornate.cache.def.impl.items.WinterItems;
import com.ornate.cache.factory.ItemSpriteFactory;
import com.ornate.collection.ReferenceCache;
import com.ornate.entity.model.Model;
import com.ornate.io.Buffer;
import com.ornate.util.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ItemDefinition {
    public byte[] customSpriteLocation;
    public byte[] customSmallSpriteLocation;
    public static int length;
    private static int cache_index;
    private static Buffer data_buffer;
    private static ItemDefinition[] cache;
    private static int[] pos;
    public static ReferenceCache model_cache;
    public int cost;
    public int id = -1;
    public int team;
    public int zoom2d;
    public int yan2d;
    public int xan2d;
    public int zan2d;
    public int inventoryModel;
    public int maleModel;
    public int maleModel1;
    public int maleModel2;
    public int femaleModel;
    public int femaleModel1;
    public int femaleModel2;
    public int maleHeadModel;
    private int maleHeadModel2;
    public int maleOffset;
    public int femaleHeadModel;
    private int femaleHeadModel2;
    public int femaleOffset;
    public int xOffset2d;
    public int yOffset2d;
    private int resizeX;
    private int resizeY;
    private int resizeZ;
    public int notedTemplate;
    public int note;
    public int ambient;
    public int contrast;
    public int[] countobj;
    public int[] countco;
    public short[] recolorFrom;
    public short[] recolorTo;
    public short[] retextureFrom;
    public short[] retextureTo;
    public String[] inventoryActions;
    public String[] groundActions;
    public String name;
    public String description;
    public static boolean members;
    public int stackable;
    public boolean animateInventory;
    public boolean hideTextOnGround;
    public boolean animate_inv_sprite;
    public boolean isTradable;
    public int category;
    public int bought_id;
    public int bought_template_id;
    public int shiftClickIndex;
    public int placeholder;
    public int placeholderTemplate;
    public String unknown1;
    public Map<Integer, Object> params = null;
    public int modelCustomColor = 0;
    public int modelCustomColor2 = 0;
    public int modelCustomColor3 = 0;
    public int modelCustomColor4 = 0;
    public int modelSetColor = 0;

    private byte[] getCustomSprite(String img) {
        String location = (ClientConstants.DATA_DIR + "item_sprites/" + img).toLowerCase();
        byte[] spriteData = FileUtils.readFile(location);
        Preconditions.checkState(spriteData != null, "No sprite: " + location);
        return spriteData;
    }

    public void createCustomSprite(String img) {
        this.customSpriteLocation = this.getCustomSprite(img);
    }

    public void createSmallCustomSprite(String img) {
        this.customSmallSpriteLocation = this.getCustomSprite(img);
    }

    public static void init(Archive archive) {
        int index;
        data_buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "items/obj.dat") : archive.get("obj.dat"));
        Buffer index_buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "items/obj.idx") : archive.get("obj.idx"));
        length = index_buffer.readUShort();
        System.out.printf("Loaded %d items loading OSRS version %d and SUB version %d%n", length, 204, 2);
        pos = new int[length + 30000];
        int offset = 2;
        for (index = 0; index < length; ++index) {
            ItemDefinition.pos[index] = offset;
            offset += index_buffer.readUShort();
        }
        cache = new ItemDefinition[10];
        for (index = 0; index < 10; ++index) {
            ItemDefinition.cache[index] = new ItemDefinition();
        }
    }

    private void decode(Buffer buffer) {
        int opcode;
        block0: while ((opcode = buffer.readUnsignedByte()) != 0) {
            int index;
            int length;
            if (opcode == 1) {
                this.inventoryModel = buffer.readUShort();
                continue;
            }
            if (opcode == 2) {
                this.name = buffer.readString();
                continue;
            }
            if (opcode == 3) {
                this.description = buffer.readString();
                continue;
            }
            if (opcode == 4) {
                this.zoom2d = buffer.readUShort();
                continue;
            }
            if (opcode == 5) {
                this.xan2d = buffer.readUShort();
                continue;
            }
            if (opcode == 6) {
                this.yan2d = buffer.readUShort();
                continue;
            }
            if (opcode == 7) {
                this.xOffset2d = buffer.readUShort();
                if (this.xOffset2d <= Short.MAX_VALUE) continue;
                this.xOffset2d -= 65536;
                continue;
            }
            if (opcode == 8) {
                this.yOffset2d = buffer.readUShort();
                if (this.yOffset2d <= Short.MAX_VALUE) continue;
                this.yOffset2d -= 65536;
                continue;
            }
            if (opcode == 9) {
                this.unknown1 = buffer.readString();
                continue;
            }
            if (opcode == 11) {
                this.stackable = 1;
                continue;
            }
            if (opcode == 12) {
                this.cost = buffer.readInt();
                continue;
            }
            if (opcode == 16) {
                members = true;
                continue;
            }
            if (opcode == 23) {
                this.maleModel = buffer.readUShort();
                this.maleOffset = buffer.readSignedByte();
                continue;
            }
            if (opcode == 24) {
                this.maleModel1 = buffer.readUShort();
                continue;
            }
            if (opcode == 25) {
                this.femaleModel = buffer.readUShort();
                this.femaleOffset = buffer.readSignedByte();
                continue;
            }
            if (opcode == 26) {
                this.femaleModel1 = buffer.readUShort();
                continue;
            }
            if (opcode >= 30 && opcode < 35) {
                if (this.groundActions == null) {
                    this.groundActions = new String[5];
                }
                this.groundActions[opcode - 30] = buffer.readString();
                if (!this.groundActions[opcode - 30].equalsIgnoreCase("hidden")) continue;
                this.groundActions[opcode - 30] = null;
                continue;
            }
            if (opcode >= 35 && opcode < 40) {
                if (this.inventoryActions == null) {
                    this.inventoryActions = new String[5];
                }
                this.inventoryActions[opcode - 35] = buffer.readString();
                continue;
            }
            if (opcode == 40) {
                length = buffer.readUnsignedByte();
                this.recolorFrom = new short[length];
                this.recolorTo = new short[length];
                index = 0;
                while (true) {
                    if (index >= length) continue block0;
                    this.recolorTo[index] = (short)buffer.readUShort();
                    this.recolorFrom[index] = (short)buffer.readUShort();
                    ++index;
                }
            }
            if (opcode == 41) {
                length = buffer.readUnsignedByte();
                this.retextureFrom = new short[length];
                this.retextureTo = new short[length];
                index = 0;
                while (true) {
                    if (index >= length) continue block0;
                    this.retextureFrom[index] = (short)buffer.readUShort();
                    this.retextureTo[index] = (short)buffer.readUShort();
                    ++index;
                }
            }
            if (opcode == 42) {
                this.shiftClickIndex = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 65) {
                this.isTradable = true;
                continue;
            }
            if (opcode == 78) {
                this.maleModel2 = buffer.readUShort();
                continue;
            }
            if (opcode == 79) {
                this.femaleModel2 = buffer.readUShort();
                continue;
            }
            if (opcode == 90) {
                this.maleHeadModel = buffer.readUShort();
                continue;
            }
            if (opcode == 91) {
                this.femaleHeadModel = buffer.readUShort();
                continue;
            }
            if (opcode == 92) {
                this.maleHeadModel2 = buffer.readUShort();
                continue;
            }
            if (opcode == 93) {
                this.femaleHeadModel2 = buffer.readUShort();
                continue;
            }
            if (opcode == 94) {
                this.category = buffer.readUShort();
                continue;
            }
            if (opcode == 95) {
                this.zan2d = buffer.readUShort();
                continue;
            }
            if (opcode == 97) {
                this.note = buffer.readUShort();
                continue;
            }
            if (opcode == 98) {
                this.notedTemplate = buffer.readUShort();
                continue;
            }
            if (opcode >= 100 && opcode < 110) {
                if (this.countobj == null) {
                    this.countobj = new int[10];
                    this.countco = new int[10];
                }
                this.countobj[opcode - 100] = buffer.readUShort();
                this.countco[opcode - 100] = buffer.readUShort();
                continue;
            }
            if (opcode == 110) {
                this.resizeX = buffer.readUShort();
                continue;
            }
            if (opcode == 111) {
                this.resizeY = buffer.readUShort();
                continue;
            }
            if (opcode == 112) {
                this.resizeZ = buffer.readUShort();
                continue;
            }
            if (opcode == 113) {
                this.ambient = buffer.readSignedByte();
                continue;
            }
            if (opcode == 114) {
                this.contrast = buffer.readSignedByte();
                continue;
            }
            if (opcode == 115) {
                this.team = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 139) {
                this.bought_id = buffer.readUShort();
                continue;
            }
            if (opcode == 140) {
                this.bought_template_id = buffer.readUShort();
                continue;
            }
            if (opcode == 148) {
                this.placeholder = buffer.readUShort();
                continue;
            }
            if (opcode == 149) {
                this.placeholderTemplate = buffer.readUShort();
                continue;
            }
            if (opcode == 249) {
                length = buffer.readUnsignedByte();
                this.params = new HashMap<Integer, Object>(length);
                int i = 0;
                while (true) {
                    if (i >= length) continue block0;
                    boolean isString = buffer.readUnsignedByte() == 1;
                    int key = buffer.read24Int();
                    Object value = isString ? buffer.readString() : Integer.valueOf(buffer.readInt());
                    this.params.put(key, value);
                    ++i;
                }
            }
            System.err.printf("Error unrecognised {Items} opcode: %d%n%n", opcode);
        }
        return;
    }

    public static void copyInventory(ItemDefinition itemDef, int id) {
        ItemDefinition copy = ItemDefinition.get(id);
        itemDef.inventoryModel = copy.inventoryModel;
        itemDef.zoom2d = copy.zoom2d;
        itemDef.xan2d = copy.xan2d;
        itemDef.yan2d = copy.yan2d;
        itemDef.zan2d = copy.zan2d;
        itemDef.resizeX = copy.resizeX;
        itemDef.resizeY = copy.resizeY;
        itemDef.resizeZ = copy.resizeZ;
        itemDef.xOffset2d = copy.xOffset2d;
        itemDef.yOffset2d = copy.yOffset2d;
        itemDef.inventoryActions = copy.inventoryActions;
        itemDef.cost = copy.cost;
        itemDef.stackable = copy.stackable;
        itemDef.countobj = copy.countobj;
        itemDef.countco = copy.countco;
    }

    public static void copyEquipment(ItemDefinition itemDef, int id) {
        ItemDefinition copy = ItemDefinition.get(id);
        itemDef.maleModel = copy.maleModel;
        itemDef.maleModel1 = copy.maleModel1;
        itemDef.femaleModel = copy.femaleModel;
        itemDef.femaleModel1 = copy.femaleModel1;
        itemDef.maleOffset = copy.maleOffset;
        itemDef.femaleOffset = copy.femaleOffset;
    }

    public static void printStatement(String text) {
        System.out.println(text + ";");
    }

    public static void printDefinitions(ItemDefinition definition) {
        ItemDefinition.printStatement("definition.name = \"" + definition.name + "\"");
        ItemDefinition.printStatement("definition.model_zoom = " + definition.zoom2d);
        ItemDefinition.printStatement("definition.rotation_y = " + definition.xan2d);
        ItemDefinition.printStatement("definition.rotation_x = " + definition.yan2d);
        ItemDefinition.printStatement("definition.translate_x = " + definition.xOffset2d);
        ItemDefinition.printStatement("definition.translate_y = " + definition.yOffset2d);
        ItemDefinition.printStatement("definition.inventory_model = " + definition.inventoryModel);
        ItemDefinition.printStatement("definition.male_equip_main = " + definition.maleModel);
        ItemDefinition.printStatement("definition.female_equip_main = " + definition.femaleModel);
        ItemDefinition.printStatement("definition.recolorFrom = " + Arrays.toString(definition.recolorFrom));
        ItemDefinition.printStatement("definition.recolorTo = " + Arrays.toString(definition.recolorTo));
    }

    public static void dump() {
        File f = new File(System.getProperty("user.home") + "/Desktop/items.txt");
        try {
            f.createNewFile();
            BufferedWriter bf = new BufferedWriter(new FileWriter(f));
            for (int id = 0; id < length; ++id) {
                ItemDefinition definition = ItemDefinition.get(id);
                bf.write("case " + id + ":");
                bf.write(System.getProperty("line.separator"));
                if (definition.name == null || definition.name.equals("null") || definition.name.isEmpty()) continue;
                bf.write("definition[id].name = " + definition.name + ";");
                bf.write(System.getProperty("line.separator"));
                if (definition.inventoryModel != 0) {
                    bf.write("definition[id].inventory_model = " + definition.inventoryModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.recolorFrom != null) {
                    bf.write("definition[id].recolorFrom = new int[] " + Arrays.toString(definition.recolorFrom).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.recolorTo != null) {
                    bf.write("definition[id].recolorTo = new int[] " + Arrays.toString(definition.recolorTo).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.retextureFrom != null) {
                    bf.write("definition[id].retextureFrom = new int[] " + Arrays.toString(definition.retextureFrom).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.retextureTo != null) {
                    bf.write("definition[id].retextureTo = new int[] " + Arrays.toString(definition.retextureTo).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.zoom2d != 2000) {
                    bf.write("definition[id].model_zoom = " + definition.zoom2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.xan2d != 0) {
                    bf.write("definition[id].rotation_y = " + definition.xan2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.yan2d != 0) {
                    bf.write("definition[id].rotation_x = " + definition.yan2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.zan2d != 0) {
                    bf.write("definition[id].rotation_z = " + definition.zan2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.xOffset2d != -1) {
                    bf.write("definition[id].translate_x = " + definition.xOffset2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.yOffset2d != -1) {
                    bf.write("definition[id].translate_y = " + definition.yOffset2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                bf.write("definition[id].stackable = " + definition.stackable + ";");
                bf.write(System.getProperty("line.separator"));
                if (definition.groundActions != null) {
                    bf.write("definition[id].scene_actions = new int[] " + Arrays.toString(definition.groundActions).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.inventoryActions != null) {
                    bf.write("definition[id].widget_actions = new int[] " + Arrays.toString(definition.inventoryActions).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleModel != -1) {
                    bf.write("definition[id].male_equip_main = " + definition.maleModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleModel1 != -1) {
                    bf.write("definition[id].male_equip_attachment = " + definition.maleModel1 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleOffset != 0) {
                    bf.write("definition[id].male_equip_translate_y = " + definition.maleOffset + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleModel != -1) {
                    bf.write("definition[id].female_equip_main = " + definition.femaleModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleModel1 != -1) {
                    bf.write("definition[id].female_equip_attachment = " + definition.femaleModel1 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleOffset != 0) {
                    bf.write("definition[id].female_equip_translate_y = " + definition.femaleOffset + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleModel2 != -1) {
                    bf.write("definition[id].male_equip_emblem = " + definition.maleModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleModel2 != -1) {
                    bf.write("definition[id].female_equip_emblem = " + definition.femaleModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleHeadModel != -1) {
                    bf.write("definition[id].male_dialogue_head = " + definition.maleHeadModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleHeadModel2 != -1) {
                    bf.write("definition[id].male_dialogue_headgear = " + definition.maleHeadModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleHeadModel != -1) {
                    bf.write("definition[id].female_dialogue_head = " + definition.femaleHeadModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleHeadModel2 != -1) {
                    bf.write("definition[id].female_dialogue_headgear = " + definition.femaleHeadModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.countobj != null) {
                    bf.write("definition[id].stack_variant_id = new int[] " + Arrays.toString(definition.countobj).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.countco != null) {
                    bf.write("definition[id].stack_variant_size = new int[] " + Arrays.toString(definition.countco).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.note != -1) {
                    bf.write("definition[id].unnoted_item_id = " + definition.note + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.notedTemplate != -1) {
                    bf.write("definition[id].model_scale_xy = " + definition.notedTemplate + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.resizeX != 128) {
                    bf.write("definition[id].model_scale_x = " + definition.resizeX + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.resizeY != 128) {
                    bf.write("definition[id].model_scale_y = " + definition.resizeY + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.resizeZ != 128) {
                    bf.write("definition[id].model_scale_z = " + definition.resizeZ + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.ambient != 0) {
                    bf.write("definition[id].ambient = " + definition.ambient + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.contrast != 0) {
                    bf.write("definition[id].contrast = " + definition.contrast + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                bf.write("break;");
                bf.write(System.getProperty("line.separator"));
                bf.write(System.getProperty("line.separator"));
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemDefinition get(int id) {
        for (int index = 0; index < 10; ++index) {
            if (ItemDefinition.cache[index].id != id) continue;
            return cache[index];
        }
        cache_index = (cache_index + 1) % 10;
        ItemDefinition def = cache[cache_index];
        ItemDefinition.data_buffer.pos = pos[id];
        def.id = id;
        def.set_defaults();
        def.decode(data_buffer);
        if (id == 20368 || id == 20370 || id == 20372 || id == 20374 || id == 12848 || id == 13188) {
            def.inventoryActions = new String[]{null, "Wield", null, null, "Drop"};
        }
        if (id == 10556 || id == 10557 || id == 10558 || id == 10559 || id == 19722 || id == 22234 || id == 12436 || id == 19720 || id == 22249 || id == 20366 || id == 23240 || id == 23444 || id == 26467 || id == 26465 || id == 26463 || id == 26477 || id == 26475 || id == 26473 || id == 26469 || id == 26471) {
            def.inventoryActions = new String[]{null, "Wear", null, null, "Destroy"};
        }
        if (def.name != null && def.name.toLowerCase().contains("ardougne cloak")) {
            def.inventoryActions = new String[]{null, "Wear", "Teleport", null, "Drop"};
        }
        if (def.name != null && (def.name.contains("Max cape") || def.name.contains("max cape"))) {
            def.inventoryActions = new String[]{null, "Wear", "Features", null, "Drop"};
        }
        if (def.name != null && (def.name.contains("slayer helmet") || def.name.contains("Slayer helmet"))) {
            def.inventoryActions = new String[]{null, "Wear", "Check", "Disassemble", "Drop"};
        }
        if (id == 24225 || def.name != null && def.name.contains("crystal bow") || def.name.contains("crystal shield") || def.name.contains("crystal halberd")) {
            def.inventoryActions = new String[]{null, "Wield", null, null, null};
        }
        if (def.name != null && def.name.contains("Blade of saeldor (c)")) {
            def.inventoryActions = new String[]{null, "Wield", null, null, "Dismantle"};
        }
        if (def.name != null && def.name.contains("Bow of faerdhinen (c)")) {
            def.inventoryActions = new String[]{null, "Wield", null, null, "Dismantle"};
        }
        CustomItems.unpack(id);
        WinterItems.unpack(id);
        SummerItems.unpack(id);
        HigherRevRSItems.unpack(id);
        if (id == 21295 || id == 21287 || id == 21297 || id == 23622 || id == 24224 || id == 21289 || id == 21285 || id == 24133) {
            def.retextureFrom = new short[]{112};
            def.retextureTo = new short[]{59};
        }
        if (def.notedTemplate != -1) {
            def.updateNote();
        }
        int[] items = new int[]{23330, 23332, 23334, 534, 536, 6812, 6729, 6666, 4084, 7534, 7535, 11020, 11022, 11019, 11021, 9005, 1506, 3057, 6188, 7053, 9921, 9922, 9925, 9923, 9924, 7053, 5608, 5609, 7918, 5607, 4566, 1037};
        if (def.name != null) {
            if (!def.name.startsWith("<col=65280>")) {
                for (int item_id : items) {
                    if (id != item_id) continue;
                    def.name = "<col=65280>" + def.name;
                    break;
                }
            }
            if (!def.name.startsWith("<col=65280>")) {
                if (def.name.toLowerCase().contains("pet") || def.name.toLowerCase().contains("3rd") || def.name.toLowerCase().contains("toxic") || def.name.toLowerCase().contains("occult") || def.name.toLowerCase().contains("anguish") || def.name.toLowerCase().contains("torture") || def.name.toLowerCase().contains("avernic") || def.name.toLowerCase().contains("serpentine") || def.name.toLowerCase().contains("tanzanite") || def.name.toLowerCase().contains("magma") || def.name.toLowerCase().contains("ancestral") || def.name.toLowerCase().contains("armadyl") || def.name.toLowerCase().contains("void") || def.name.toLowerCase().contains("bandos") || def.name.toLowerCase().contains("pegasian") || def.name.toLowerCase().contains("primordial") || def.name.toLowerCase().contains("eternal") || def.name.toLowerCase().contains("partyhat") || def.name.toLowerCase().contains("staff of light") || def.name.toLowerCase().contains("infernal") || def.name.toLowerCase().contains("black mask") || def.name.toLowerCase().contains("slayer helm") || def.name.toLowerCase().contains("dragon hunter") || def.name.toLowerCase().contains("spectral") || def.name.toLowerCase().contains("ballista") || def.name.toLowerCase().contains("justiciar") || def.name.toLowerCase().contains("dragon claws") || def.name.toLowerCase().contains("bulwark") || def.name.toLowerCase().contains("dragon warhammer") || def.name.toLowerCase().contains("blessed sword") || def.name.toLowerCase().contains("godsword") || def.name.toLowerCase().contains("ward") || def.name.toLowerCase().contains("wyvern shield") || def.name.toLowerCase().contains("morrigan") || def.name.toLowerCase().contains("vesta") || def.name.toLowerCase().contains("zuriel") || def.name.toLowerCase().contains("statius") || def.name.toLowerCase().contains("dragon crossbow") || def.name.toLowerCase().contains("abyssal dagger") || def.name.toLowerCase().contains("ghrazi") || def.name.toLowerCase().contains("elder maul") || def.name.toLowerCase().contains("tormented") || def.name.toLowerCase().contains("infinity") || def.name.toLowerCase().contains("dragonfire") || def.name.toLowerCase().contains("blessed spirit shield") || def.name.toLowerCase().contains("of the dead") || def.name.toLowerCase().contains("ice arrow") || def.name.toLowerCase().contains("dragon javelin") || def.name.toLowerCase().contains("dragon knife") || def.name.toLowerCase().contains("dragon thrownaxe") || def.name.toLowerCase().contains("abyssal tentacle") || def.name.toLowerCase().contains("dark bow") || def.name.toLowerCase().contains("fremennik kilt") || def.name.toLowerCase().contains("spiked manacles") || def.name.toLowerCase().contains("fury") || def.name.toLowerCase().contains("dragon boots") || def.name.toLowerCase().contains("ranger boots") || def.name.toLowerCase().contains("mage's book") || def.name.toLowerCase().contains("master wand") || def.name.toLowerCase().contains("granite maul") || def.name.toLowerCase().contains("tome of fire") || def.name.toLowerCase().contains("recoil") || def.name.toLowerCase().contains("dharok") || def.name.toLowerCase().contains("karil") || def.name.toLowerCase().contains("guthan") || def.name.toLowerCase().contains("torag") || def.name.toLowerCase().contains("verac") || def.name.toLowerCase().contains("ahrim") || def.name.toLowerCase().contains("fire cape") || def.name.toLowerCase().contains("max cape") || def.name.toLowerCase().contains("blighted") || def.name.toLowerCase().contains("dragon defender") || def.name.toLowerCase().contains("healer hat") || def.name.toLowerCase().contains("fighter hat") || def.name.toLowerCase().contains("runner hat") || def.name.toLowerCase().contains("ranger hat") || def.name.toLowerCase().contains("fighter torso") || def.name.toLowerCase().contains("runner boots") || def.name.toLowerCase().contains("penance skirt") || def.name.toLowerCase().contains("looting bag") || def.name.toLowerCase().contains("rune pouch") || def.name.toLowerCase().contains("stamina") || def.name.toLowerCase().contains("anti-venom") || def.name.toLowerCase().contains("zamorakian") || def.name.toLowerCase().contains("hydra") || def.name.toLowerCase().contains("ferocious") || def.name.toLowerCase().contains("jar of") || def.name.toLowerCase().contains("brimstone") || def.name.toLowerCase().contains("crystal") || def.name.toLowerCase().contains("dagon") || def.name.toLowerCase().contains("dragon pickaxe") || def.name.toLowerCase().contains("tyrannical") || def.name.toLowerCase().contains("dragon 2h") || def.name.toLowerCase().contains("elysian") || def.name.toLowerCase().contains("holy elixer") || def.name.toLowerCase().contains("odium") || def.name.toLowerCase().contains("malediction") || def.name.toLowerCase().contains("fedora") || def.name.toLowerCase().contains("suffering") || def.name.toLowerCase().contains("mole") || def.name.toLowerCase().contains("vampyre dust") || def.name.toLowerCase().contains("bludgeon") || def.name.toLowerCase().contains("kbd heads") || def.name.toLowerCase().contains("trident") || def.name.toLowerCase().contains("nightmare") || def.name.toLowerCase().contains("kodai wand") || def.name.toLowerCase().contains("dragon sword") || def.name.toLowerCase().contains("dragon harpoon") || def.name.toLowerCase().contains("mystery box") || def.name.toLowerCase().contains("crystal key") || def.name.toLowerCase().contains("volatile") || def.name.toLowerCase().contains("eldritch") || def.name.toLowerCase().contains("harmonised") || def.name.toLowerCase().contains("inquisitor") || def.name.toLowerCase().contains("treasonous") || def.name.toLowerCase().contains("ring of the gods") || def.name.toLowerCase().contains("vorkath") || def.name.toLowerCase().contains("dragonbone") || def.name.toLowerCase().contains("uncut onyx") || def.name.toLowerCase().contains("zulrah") || def.name.toLowerCase().contains("zul-andra") || def.name.toLowerCase().contains("sanguinesti") || def.name.toLowerCase().contains("blade of saeldor") || def.name.toLowerCase().contains("barrelchest anchor") || def.name.toLowerCase().contains("staff of balance") || def.name.toLowerCase().contains("twisted bow") || def.name.toLowerCase().contains("facegaurd") || def.name.toLowerCase().contains("guardian") || def.name.toLowerCase().contains("twisted buckler") || def.name.toLowerCase().contains("dragon dart") || def.name.toLowerCase().contains("guthix rest") || def.name.toLowerCase().contains("obsidian") || def.name.toLowerCase().contains("regen bracelet") || def.name.toLowerCase().contains("rangers'") || def.name.toLowerCase().contains("dragon scimitar (or)") || def.name.toLowerCase().contains("OrnatePs coins") || def.name.toLowerCase().contains("divine") || def.name.toLowerCase().contains("super antifire") || def.name.toLowerCase().contains("robin hood hat") || def.name.toLowerCase().contains("ankou") || def.name.toLowerCase().contains("santa") || def.name.toLowerCase().contains("halloween") || def.name.toLowerCase().contains("dye") || def.name.toLowerCase().contains("cooking gauntlets") || def.name.toLowerCase().contains("magic secateurs") || def.name.toLowerCase().contains("explorer's ring") || def.name.toLowerCase().contains("blessing") || def.name.toLowerCase().contains("charos") || def.name.toLowerCase().contains("ardougne cloak") || def.name.toLowerCase().contains("bonecrusher") || def.name.toLowerCase().contains("ornament kit") || def.name.toLowerCase().contains("coal bag") || def.name.toLowerCase().contains("imcando hammer") || def.name.toLowerCase().contains("goldsmith gauntlets") || def.name.toLowerCase().contains("graceful") || def.name.toLowerCase().contains("dark totem") || def.name.toLowerCase().contains("prospector") || def.name.toLowerCase().contains("angler") || def.name.toLowerCase().contains("nexling") || def.name.toLowerCase().contains("ancient hilt") || def.name.toLowerCase().contains("ancient godsword") || def.name.toLowerCase().contains("nihil horn") || def.name.toLowerCase().contains("torva") || def.name.toLowerCase().contains("nihil shard") || def.name.toLowerCase().contains("vorki") || def.name.toLowerCase().contains("vet'ion") || def.name.toLowerCase().contains("venenatis") || def.name.toLowerCase().contains("tzrek") || def.name.toLowerCase().contains("dragon chainbody") || def.name.toLowerCase().contains("zik") || def.name.toLowerCase().contains("skotos") || def.name.toLowerCase().contains("ancient shard") || def.name.toLowerCase().contains("scorpia") || def.name.toLowerCase().contains("sraracha") || def.name.toLowerCase().contains("giant egg sac") || def.name.toLowerCase().contains("sarachnis cudgel") || def.name.toLowerCase().contains("kraken tentacle") || def.name.toLowerCase().contains("abyssal whip") || def.name.toLowerCase().contains("draconic vissage") || def.name.toLowerCase().contains("smouldering stone") || def.name.toLowerCase().contains("kq head") || def.name.toLowerCase().contains("dragon axe") || def.name.toLowerCase().contains("seercull") || def.name.toLowerCase().contains("mud battlestaff") || def.name.toLowerCase().contains("light frame") || def.name.toLowerCase().contains("heavy frame") || def.name.toLowerCase().contains("monkey tail") || def.name.toLowerCase().contains("holy elixir") || def.name.toLowerCase().contains("spirit shield") || def.name.toLowerCase().contains("saradomin hilt") || def.name.toLowerCase().contains("saradomin sword") || def.name.toLowerCase().contains("saradomin's light") || def.name.toLowerCase().contains("olmlet") || def.name.toLowerCase().contains("metamorphic dust") || def.name.toLowerCase().contains("kodai insignia") || def.name.toLowerCase().contains("dexterous prayer scroll") || def.name.toLowerCase().contains("torn prayer scroll") || def.name.toLowerCase().contains("dark relic") || def.name.toLowerCase().contains("onyx") || def.name.toLowerCase().contains("hellpuppy") || def.name.toLowerCase().contains("key master teleport") || def.name.toLowerCase().contains("callisto") || def.name.toLowerCase().contains("bryophyta's essence") || def.name.toLowerCase().contains("bolt rack") || def.name.toLowerCase().contains("abyssal orphan") || def.name.toLowerCase().contains("unsired") || def.name.toLowerCase().contains("zaryte") || def.name.toLowerCase().contains("ancient cere") || def.name.toLowerCase().contains("mining gloves") || def.name.toLowerCase().contains("bag full of") || def.name.toLowerCase().contains("snow imp") || def.name.toLowerCase().contains("bow of faerdhinen") || def.name.toLowerCase().contains("tektiny") || def.name.toLowerCase().contains("vespina") || def.name.toLowerCase().contains("puppadile") || def.name.toLowerCase().contains("vasa minirio") || def.name.toLowerCase().contains("assembler") || def.name.toLowerCase().contains("rock cake") || def.name.toLowerCase().contains("maiden") || def.name.toLowerCase().contains("bloat") || def.name.toLowerCase().contains("nylo") || def.name.toLowerCase().contains("sot") || def.name.toLowerCase().contains("xarp") || def.name.toLowerCase().contains("shattered ") || def.name.toLowerCase().contains("(or)") || def.name.toLowerCase().contains("larran") || def.name.toLowerCase().contains("shattered")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("berserker ring") || def.name.toLowerCase().contains("seers") || def.name.toLowerCase().contains("archers") || def.name.toLowerCase().contains("warrior ring")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("scythe")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("gilded")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("bunny")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("zanik")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("ele'")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("prince")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("zombie")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("mithril seeds")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("tribal")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("broodoo")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("scarf") || def.name.toLowerCase().contains("woolly") || def.name.toLowerCase().contains("bobble")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("cane")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("jester")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("(g)")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("(t)") && !def.name.toLowerCase().endsWith("cape(t)")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("camo") || def.name.toLowerCase().contains("boxing glove")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("dharok")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("dragon spear")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("phoenix neck")) {
                    def.name = "<col=65280>" + def.name;
                }
                if (def.name.toLowerCase().contains("dragon bolts (e)")) {
                    def.name = "<col=65280>" + def.name;
                }
            }
        }
        return def;
    }

    private void set_defaults() {
        this.name = "null";
        this.zoom2d = 2000;
        this.xan2d = 0;
        this.yan2d = 0;
        this.zan2d = 0;
        this.xOffset2d = 0;
        this.yOffset2d = 0;
        this.stackable = 0;
        this.cost = 1;
        members = false;
        this.groundActions = new String[]{null, null, "Take", null, null};
        this.inventoryActions = new String[]{null, null, null, null, "Drop"};
        this.hideTextOnGround = false;
        this.shiftClickIndex = -2;
        this.maleModel = -1;
        this.maleModel1 = -1;
        this.maleOffset = 0;
        this.femaleModel = -1;
        this.femaleModel1 = -1;
        this.femaleOffset = 0;
        this.maleModel2 = -1;
        this.femaleModel2 = -1;
        this.maleHeadModel = -1;
        this.maleHeadModel2 = -1;
        this.femaleHeadModel = -1;
        this.femaleHeadModel2 = -1;
        this.note = -1;
        this.notedTemplate = -1;
        this.resizeX = 128;
        this.resizeY = 128;
        this.resizeZ = 128;
        this.ambient = 0;
        this.contrast = 0;
        this.team = 0;
        this.isTradable = false;
        this.bought_id = -1;
        this.bought_template_id = -1;
        this.placeholder = -1;
        this.placeholderTemplate = -1;
        this.inventoryModel = 0;
        this.countobj = null;
        this.countco = null;
        this.animate_inv_sprite = false;
        this.modelCustomColor = 0;
        this.modelCustomColor2 = 0;
        this.modelCustomColor3 = 0;
        this.modelCustomColor4 = 0;
        this.modelSetColor = 0;
        this.recolorFrom = null;
        this.recolorTo = null;
    }

    private void updateNote() {
        ItemDefinition noted = ItemDefinition.get(this.notedTemplate);
        this.inventoryModel = noted.inventoryModel;
        this.zoom2d = noted.zoom2d;
        this.xan2d = noted.xan2d;
        this.yan2d = noted.yan2d;
        this.zan2d = noted.zan2d;
        this.xOffset2d = noted.xOffset2d;
        this.yOffset2d = noted.yOffset2d;
        this.recolorFrom = noted.recolorFrom;
        this.recolorTo = noted.recolorTo;
        this.retextureFrom = noted.retextureFrom;
        this.retextureTo = noted.retextureTo;
        ItemDefinition unnotedItem = ItemDefinition.get(this.note);
        this.name = unnotedItem.name;
        this.cost = unnotedItem.cost;
        this.stackable = 1;
        String consonant_or_vowel_lead = "a";
        String character = unnotedItem.name;
        if (character.equals("A") || character.equals("E") || character.equals("I") || character.equals("O") || character.equals("U")) {
            consonant_or_vowel_lead = "an";
        }
        this.description = "Swap this note at any bank for " + consonant_or_vowel_lead + " " + unnotedItem.name + ".";
    }

    public Model get_model(int stack_size) {
        Model model;
        int index;
        if (this.countobj != null && stack_size > 1) {
            int stack_item_id = -1;
            for (index = 0; index < 10; ++index) {
                if (stack_size < this.countco[index] || this.countco[index] == 0) continue;
                stack_item_id = this.countobj[index];
            }
            if (stack_item_id != -1) {
                return ItemDefinition.get(stack_item_id).get_model(1);
            }
        }
        if ((model = (Model)model_cache.get(this.id)) != null) {
            return model;
        }
        model = Model.get(this.inventoryModel);
        if (model == null) {
            return null;
        }
        if (this.resizeX != 128 || this.resizeY != 128 || this.resizeZ != 128) {
            model.scale(this.resizeX, this.resizeZ, this.resizeY);
        }
        if (this.recolorFrom != null) {
            for (index = 0; index < this.recolorFrom.length; ++index) {
                model.recolor(this.recolorFrom[index], this.recolorTo[index]);
            }
        }
        if (this.retextureFrom != null) {
            for (index = 0; index < this.retextureFrom.length; ++index) {
                model.retexture(this.retextureFrom[index], this.retextureTo[index]);
            }
        }
        if (this.modelCustomColor > 0) {
            model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            model.shadingRecolor3(this.modelSetColor);
        }
        model.light(64 + this.ambient, 768 + this.contrast, -50, -10, -50, true);
        model.within_tile = true;
        model_cache.put(model, this.id);
        return model;
    }

    public Model get_widget_model(int stack_size) {
        Model widget_model;
        int index;
        if (this.countobj != null && stack_size > 1) {
            int stack_item_id = -1;
            for (index = 0; index < 10; ++index) {
                if (stack_size < this.countco[index] || this.countco[index] == 0) continue;
                stack_item_id = this.countobj[index];
            }
            if (stack_item_id != -1) {
                return ItemDefinition.get(stack_item_id).get_widget_model(1);
            }
        }
        if ((widget_model = Model.get(this.inventoryModel)) == null) {
            return null;
        }
        if (this.recolorFrom != null) {
            for (index = 0; index < this.recolorFrom.length; ++index) {
                widget_model.recolor(this.recolorFrom[index], this.recolorTo[index]);
            }
        }
        if (this.retextureFrom != null) {
            for (index = 0; index < this.retextureFrom.length; ++index) {
                widget_model.retexture(this.retextureFrom[index], this.retextureTo[index]);
            }
        }
        if (this.modelCustomColor > 0) {
            widget_model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            widget_model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            widget_model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            widget_model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            widget_model.shadingRecolor3(this.modelSetColor);
        }
        return widget_model;
    }

    public Model get_equipped_model(int gender) {
        int main = this.maleModel;
        int attatchment = this.maleModel1;
        int emblem = this.maleModel2;
        if (gender == 1) {
            main = this.femaleModel;
            attatchment = this.femaleModel1;
            emblem = this.femaleModel2;
        }
        if (main == -1) {
            return null;
        }
        Model equipped_model = Model.get(main);
        if (equipped_model == null) {
            return null;
        }
        if (attatchment != -1) {
            Model attachment_model;
            if (emblem != -1) {
                attachment_model = Model.get(attatchment);
                Model emblem_model = Model.get(emblem);
                Model[] list = new Model[]{equipped_model, attachment_model, emblem_model};
                equipped_model = new Model(3, list, true);
            } else {
                attachment_model = Model.get(attatchment);
                Model[] list = new Model[]{equipped_model, attachment_model};
                equipped_model = new Model(2, list, true);
            }
        }
        if (gender == 0 && this.maleOffset != 0) {
            equipped_model.translate(0, this.maleOffset, 0);
        }
        if (gender == 1 && this.femaleOffset != 0) {
            equipped_model.translate(0, this.femaleOffset, 0);
        }
        if (this.recolorFrom != null) {
            for (int index = 0; index < this.recolorFrom.length; ++index) {
                equipped_model.recolor(this.recolorFrom[index], this.recolorTo[index]);
            }
        }
        if (this.retextureFrom != null) {
            for (int index = 0; index < this.retextureFrom.length; ++index) {
                equipped_model.retexture(this.retextureFrom[index], this.retextureTo[index]);
            }
        }
        if (this.modelCustomColor > 0) {
            equipped_model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            equipped_model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            equipped_model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            equipped_model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            equipped_model.shadingRecolor3(this.modelSetColor);
        }
        return equipped_model;
    }

    public boolean equipped_model_cached(int gender) {
        int main = this.maleModel;
        int attachment = this.maleModel1;
        int emblem = this.maleModel2;
        if (gender == 1) {
            main = this.femaleModel;
            attachment = this.femaleModel1;
            emblem = this.femaleModel2;
        }
        if (main == -1) {
            return true;
        }
        boolean cached = true;
        if (!Model.cached(main)) {
            cached = false;
        }
        if (attachment != -1 && !Model.cached(attachment)) {
            cached = false;
        }
        if (emblem != -1 && !Model.cached(emblem)) {
            cached = false;
        }
        return cached;
    }

    public Model get_equipped_dialogue_model(int gender) {
        int head_model = this.maleHeadModel;
        int equipped_headgear = this.maleHeadModel2;
        if (gender == 1) {
            head_model = this.femaleHeadModel;
            equipped_headgear = this.femaleHeadModel2;
        }
        if (head_model == -1) {
            return null;
        }
        Model dialogue_model = Model.get(head_model);
        if (equipped_headgear != -1) {
            Model headgear = Model.get(equipped_headgear);
            Model[] list = new Model[]{dialogue_model, headgear};
            dialogue_model = new Model(2, list, true);
        }
        if (this.recolorFrom != null) {
            for (int index = 0; index < this.recolorFrom.length; ++index) {
                dialogue_model.recolor(this.recolorFrom[index], this.recolorTo[index]);
            }
        }
        if (this.retextureFrom != null) {
            for (int index = 0; index < this.retextureFrom.length; ++index) {
                dialogue_model.retexture(this.retextureFrom[index], this.retextureTo[index]);
            }
        }
        return dialogue_model;
    }

    public boolean dialogue_model_cached(int gender) {
        int head_model = this.maleHeadModel;
        int equipped_headgear = this.maleHeadModel2;
        if (gender == 1) {
            head_model = this.femaleHeadModel;
            equipped_headgear = this.femaleHeadModel2;
        }
        if (head_model == -1) {
            return true;
        }
        boolean cached = true;
        if (!Model.cached(head_model)) {
            cached = false;
        }
        if (equipped_headgear != -1 && !Model.cached(equipped_headgear)) {
            cached = false;
        }
        return cached;
    }

    public static void release() {
        model_cache = null;
        ItemSpriteFactory.sprites_cache = null;
        ItemSpriteFactory.scaled_cache = null;
        pos = null;
        cache = null;
        data_buffer = null;
    }

    private ItemDefinition() {
    }

    public static int setInventoryModel(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.inventoryModel;
    }

    public static String setItemName(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.name;
    }

    public static int setMaleEquipmentId(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.maleModel;
    }

    public static int setFemaleEquipmentId(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.femaleModel;
    }

    public static int setModelZoom(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.zoom2d;
    }

    public static int setRotationX(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.yan2d;
    }

    public static int setRotationY(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.xan2d;
    }

    public static int setTranslateX(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.xOffset2d;
    }

    public static int setTranslateY(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.yOffset2d;
    }

    public String toStringBig() {
        return "ItemDefinition{cost=" + this.cost + ", id=" + this.id + ", team=" + this.team + ", zoom2d=" + this.zoom2d + ", yan2d=" + this.yan2d + ", xan2d=" + this.xan2d + ", zan2d=" + this.zan2d + ", inventoryModel=" + this.inventoryModel + ", maleModel=" + this.maleModel + ", maleModel1=" + this.maleModel1 + ", maleModel2=" + this.maleModel2 + ", femaleModel=" + this.femaleModel + ", femaleModel1=" + this.femaleModel1 + ", femaleModel2=" + this.femaleModel2 + ", maleHeadModel=" + this.maleHeadModel + ", maleHeadModel2=" + this.maleHeadModel2 + ", maleOffset=" + this.maleOffset + ", femaleHeadModel=" + this.femaleHeadModel + ", femaleHeadModel2=" + this.femaleHeadModel2 + ", femaleOffset=" + this.femaleOffset + ", xOffset2d=" + this.xOffset2d + ", yOffset2d=" + this.yOffset2d + ", resizeX=" + this.resizeX + ", resizeY=" + this.resizeY + ", resizeZ=" + this.resizeZ + ", notedTemplate=" + this.notedTemplate + ", note=" + this.note + ", ambient=" + this.ambient + ", contrast=" + this.contrast + ", countobj=" + Arrays.toString(this.countobj) + ", countco=" + Arrays.toString(this.countco) + ", recolorFrom=" + Arrays.toString(this.recolorFrom) + ", recolorTo=" + Arrays.toString(this.recolorTo) + ", retextureFrom=" + Arrays.toString(this.retextureFrom) + ", retextureTo=" + Arrays.toString(this.retextureTo) + ", inventoryActions=" + Arrays.toString(this.inventoryActions) + ", groundActions=" + Arrays.toString(this.groundActions) + ", name='" + this.name + "', description='" + this.description + "', stackable=" + this.stackable + ", animateInventory=" + this.animateInventory + ", hideTextOnGround=" + this.hideTextOnGround + ", animate_inv_sprite=" + this.animate_inv_sprite + ", isTradable=" + this.isTradable + ", category=" + this.category + ", bought_id=" + this.bought_id + ", bought_template_id=" + this.bought_template_id + ", shiftClickIndex=" + this.shiftClickIndex + ", placeholder=" + this.placeholder + ", placeholderTemplate=" + this.placeholderTemplate + ", unknown1='" + this.unknown1 + "', params=" + String.valueOf(this.params) + ", modelCustomColor=" + this.modelCustomColor + ", modelCustomColor2=" + this.modelCustomColor2 + ", modelCustomColor3=" + this.modelCustomColor3 + ", modelCustomColor4=" + this.modelCustomColor4 + ", modelSetColor=" + this.modelSetColor + "}";
    }

    static {
        model_cache = new ReferenceCache(50);
    }
}

