/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.def;

import com.ornate.Client;
import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.cache.anim.Animation;
import com.ornate.cache.config.VariableBits;
import com.ornate.cache.def.impl.NpcManager;
import com.ornate.cache.def.impl.npcs.CustomBosses;
import com.ornate.cache.def.impl.npcs.CustomPets;
import com.ornate.cache.def.impl.npcs.MemberNpcs;
import com.ornate.collection.ReferenceCache;
import com.ornate.entity.model.Model;
import com.ornate.io.Buffer;
import com.ornate.util.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class NpcDefinition {
    public static int totalNPCs;
    private static final boolean dump = false;
    public int modelCustomColor = 0;
    public int modelCustomColor2 = 0;
    public int modelCustomColor3 = 0;
    public int modelCustomColor4 = 0;
    public int modelSetColor = 0;
    public int rotate90RightAnimation = -1;
    public static int cache_index;
    public int transformVarbit = -1;
    public int rotate180Animation = -1;
    public int transformVarp = -1;
    public static Buffer buffer;
    public int combatLevel = -1;
    public boolean largeHpBar;
    public final int anInt64;
    public String name = "null";
    public String[] actions = new String[5];
    public int category;
    public int walkingAnimation = -1;
    public int turnLeftSequence = -1;
    public int turnRightSequence = -1;
    public int size = 1;
    public short[] recolorTo;
    public static int[] offsets;
    public int[] additionalModels;
    public int headIconPrayer = -1;
    public short[] retextureFrom;
    public short[] retextureTo;
    public short[] recolorFrom;
    public int standingAnimation = -1;
    public long interfaceType = -1L;
    public int rotation = 32;
    public static NpcDefinition[] cache;
    public static Client clientInstance;
    public int rotate90LeftAnimation = -1;
    public boolean isClickable = true;
    public boolean isInteractable = true;
    public boolean isFollower = false;
    public int ambient = 0;
    public int heightScale = 128;
    public boolean drawMapDot = true;
    public int[] transforms;
    public String description;
    public int widthScale = 128;
    public int contrast = 0;
    public boolean hasRenderPriority = false;
    public int[] modelId;
    public Map<Integer, Object> params = null;
    public int interfaceZoom = 0;
    public int id;
    public static ReferenceCache model_cache;

    public static void init(Archive archive) {
        int i;
        buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/npcs/npc.dat") : archive.get("npc.dat"));
        Buffer metaBuf = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/npcs/npc.idx") : archive.get("npc.idx"));
        totalNPCs = metaBuf.readUShort();
        System.out.printf("Loaded %d npcs loading OSRS version %d and SUB version %d%n", totalNPCs, 204, 2);
        offsets = new int[totalNPCs + 30000];
        int metaOffset = 2;
        for (i = 0; i < totalNPCs; ++i) {
            NpcDefinition.offsets[i] = metaOffset;
            metaOffset += metaBuf.readUShort();
        }
        cache = new NpcDefinition[20];
        for (i = 0; i < 20; ++i) {
            NpcDefinition.cache[i] = new NpcDefinition();
        }
    }

    public static int getModelIds(int id, int models) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.modelId[models];
    }

    public static int getadditionalModels(int id, int models) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.additionalModels[models];
    }

    public static int getModelColorIds(int id, int color) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.recolorFrom[color];
    }

    public static int getStandAnim(int id) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.standingAnimation;
    }

    public static int getWalkAnim(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.walkingAnimation;
    }

    public static int getHalfTurnAnimation(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.rotate180Animation;
    }

    public static int getQuarterClockwiseTurnAnimation(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.rotate90LeftAnimation;
    }

    public static int getQuarterAnticlockwiseTurnAnimation(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.rotate90RightAnimation;
    }

    public static int getHeightScale(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.heightScale;
    }

    public static int getWidthScale(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.widthScale;
    }

    public static NpcDefinition get(int id) {
        for (int i = 0; i < 20; ++i) {
            if (NpcDefinition.cache[i].interfaceType != (long)id) continue;
            return cache[i];
        }
        cache_index = (cache_index + 1) % 20;
        NpcDefinition npcDefinition = NpcDefinition.cache[NpcDefinition.cache_index] = new NpcDefinition();
        NpcDefinition.buffer.pos = offsets[id];
        npcDefinition.id = id;
        npcDefinition.interfaceType = id;
        npcDefinition.decode(buffer);
        if (npcDefinition.name.toLowerCase().contains("banker")) {
            npcDefinition.actions = new String[]{"Bank", null, "Talk-to", null, null};
        }
        if (id == 1612) {
            npcDefinition.name = "Battle mage";
            npcDefinition.actions = new String[]{null, "Attack", null, null, null};
            npcDefinition.recolorFrom = new short[]{22426, 926};
            npcDefinition.recolorTo = new short[]{8090, 22426};
            npcDefinition.combatLevel = 54;
            npcDefinition.modelId = new int[]{2909, 2898, 2920};
            npcDefinition.standingAnimation = 195;
            npcDefinition.walkingAnimation = 189;
        }
        NpcManager.unpack(id);
        CustomPets.unpack(id);
        CustomBosses.unpack(id);
        MemberNpcs.unpack(id);
        return npcDefinition;
    }

    public static void dumpNpcList() {
        File f = new File(System.getProperty("user.home") + "/Desktop/npclist.txt");
        try {
            f.createNewFile();
            BufferedWriter bf = new BufferedWriter(new FileWriter(f));
            for (int id = 0; id < totalNPCs; ++id) {
                NpcDefinition definition = NpcDefinition.get(id);
                if (definition.name == null || definition.name.equals("null") || definition.name.isEmpty()) continue;
                bf.write(id + " - " + definition.name);
                bf.write(System.getProperty("line.separator"));
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dump() {
        File f = new File(System.getProperty("user.home") + "/Desktop/npcs.txt");
        try {
            f.createNewFile();
            BufferedWriter bf = new BufferedWriter(new FileWriter(f));
            for (int id = 0; id < totalNPCs; ++id) {
                NpcDefinition definition = NpcDefinition.get(id);
                bf.write("case " + id + ":");
                bf.write(System.getProperty("line.separator"));
                if (definition.name == null || definition.name.equals("null") || definition.name.isEmpty()) continue;
                bf.write("definition[id].name = " + definition.name + ";");
                bf.write(System.getProperty("line.separator"));
                if (definition.modelId != null) {
                    bf.write("definition[id].model_id = new int[] " + Arrays.toString(definition.modelId).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.size != 1) {
                    bf.write("definition[id].occupied_tiles = " + definition.size + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.standingAnimation != -1) {
                    bf.write("definition[id].standingAnimation = " + definition.standingAnimation + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.walkingAnimation != -1) {
                    bf.write("definition[id].walkingAnimation = " + definition.walkingAnimation + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.rotate180Animation != -1) {
                    bf.write("definition[id].halfTurnAnimation = " + definition.rotate180Animation + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.rotate90LeftAnimation != -1) {
                    bf.write("definition[id].quarterClockwiseTurnAnimation = " + definition.rotate90LeftAnimation + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.rotate90RightAnimation != -1) {
                    bf.write("definition[id].quarterAnticlockwiseTurnAnimation = " + definition.rotate90RightAnimation + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.actions != null) {
                    bf.write("definition[id].actions = new int[] " + Arrays.toString(definition.actions).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.recolorFrom != null) {
                    bf.write("definition[id].src_color = new int[] " + Arrays.toString(definition.recolorFrom).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.recolorTo != null) {
                    bf.write("definition[id].dst_color = new int[] " + Arrays.toString(definition.recolorTo).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.retextureFrom != null) {
                    bf.write("definition[id].src_texture = new int[] " + Arrays.toString(definition.retextureFrom).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.retextureTo != null) {
                    bf.write("definition[id].dst_texture = new int[] " + Arrays.toString(definition.retextureTo).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.additionalModels != null) {
                    bf.write("definition[id].additionalModels = new int[] " + Arrays.toString(definition.additionalModels).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.combatLevel != -1) {
                    bf.write("definition[id].cmb_level = " + definition.combatLevel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.widthScale != 128) {
                    bf.write("definition[id].model_scale_xy = " + definition.widthScale + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.heightScale != 128) {
                    bf.write("definition[id].model_scale_z = " + definition.heightScale + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (!definition.hasRenderPriority) {
                    bf.write("definition[id].render_priority = " + definition.hasRenderPriority + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.ambient != -1) {
                    bf.write("definition[id].ambient = " + definition.ambient + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.contrast != -1) {
                    bf.write("definition[id].contrast = " + definition.contrast + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.headIconPrayer != -1) {
                    bf.write("definition[id].headIcon = " + definition.headIconPrayer + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.rotation != 32) {
                    bf.write("definition[id].rotation = " + definition.rotation + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.transformVarbit != -1) {
                    bf.write("definition[id].varbit = " + definition.transformVarbit + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.transformVarp != -1) {
                    bf.write("definition[id].varp = " + definition.transformVarp + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.transforms != null) {
                    bf.write("definition[id].configs = new int[] " + Arrays.toString(definition.transforms).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                bf.write("break;");
                bf.write(System.getProperty("line.separator"));
                bf.write(System.getProperty("line.separator"));
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copy(NpcDefinition definition, int id) {
        NpcDefinition copy = NpcDefinition.get(id);
        definition.size = copy.size;
        definition.rotation = copy.rotation;
        definition.standingAnimation = copy.standingAnimation;
        definition.walkingAnimation = copy.walkingAnimation;
        definition.rotate180Animation = copy.rotate180Animation;
        definition.rotate90LeftAnimation = copy.rotate90LeftAnimation;
        definition.rotate90RightAnimation = copy.rotate90RightAnimation;
        definition.transformVarbit = copy.transformVarbit;
        definition.transformVarp = copy.transformVarp;
        definition.combatLevel = copy.combatLevel;
        definition.name = copy.name;
        definition.description = copy.description;
        definition.headIconPrayer = copy.headIconPrayer;
        definition.isClickable = copy.isClickable;
        definition.ambient = copy.ambient;
        definition.heightScale = copy.heightScale;
        definition.widthScale = copy.widthScale;
        definition.drawMapDot = copy.drawMapDot;
        definition.contrast = copy.contrast;
        definition.actions = new String[copy.actions.length];
        System.arraycopy(copy.actions, 0, definition.actions, 0, definition.actions.length);
        definition.modelId = new int[copy.modelId.length];
        System.arraycopy(copy.modelId, 0, definition.modelId, 0, definition.modelId.length);
        definition.hasRenderPriority = copy.hasRenderPriority;
    }

    public Model get_dialogue_model() {
        if (this.transforms != null) {
            NpcDefinition entityDef = this.get_configs();
            if (entityDef == null) {
                return null;
            }
            return entityDef.get_dialogue_model();
        }
        if (this.additionalModels == null) {
            return null;
        }
        boolean cached = false;
        for (int index = 0; index < this.additionalModels.length; ++index) {
            if (Model.cached(this.additionalModels[index])) continue;
            cached = true;
        }
        if (cached) {
            return null;
        }
        Model[] head_model = new Model[this.additionalModels.length];
        for (int index = 0; index < this.additionalModels.length; ++index) {
            head_model[index] = Model.get(this.additionalModels[index]);
        }
        Model dialogue_model = head_model.length == 1 ? head_model[0] : new Model(head_model.length, head_model, true);
        if (this.modelCustomColor > 0) {
            dialogue_model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            dialogue_model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            dialogue_model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            dialogue_model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            dialogue_model.shadingRecolor3(this.modelSetColor);
        }
        if (this.recolorFrom != null) {
            for (int k = 0; k < this.recolorFrom.length; ++k) {
                dialogue_model.recolor(this.recolorFrom[k], this.recolorTo[k]);
            }
        }
        if (this.retextureFrom != null) {
            for (int index = 0; index < this.retextureFrom.length; ++index) {
                dialogue_model.retexture(this.retextureFrom[index], this.retextureTo[index]);
            }
        }
        return dialogue_model;
    }

    public NpcDefinition get_configs() {
        try {
            int j = -1;
            if (this.transformVarbit != -1) {
                VariableBits varBit = VariableBits.cache[this.transformVarbit];
                int k = varBit.configId;
                int l = varBit.leastSignificantBit;
                int i1 = varBit.mostSignificantBit;
                int j1 = Client.BIT_MASKS[i1 - l];
                j = NpcDefinition.clientInstance.settings[k] >> l & j1;
            } else if (this.transformVarp != -1) {
                j = NpcDefinition.clientInstance.settings[this.transformVarp];
            }
            if (j < 0 || j >= this.transforms.length || this.transforms[j] == -1) {
                return null;
            }
            return NpcDefinition.get(this.transforms[j]);
        }
        catch (Exception e) {
            System.err.println("There was an error getting configs for NPC " + this.id);
            e.printStackTrace();
            return null;
        }
    }

    public static void clear() {
        model_cache = null;
        offsets = null;
        cache = null;
        buffer = null;
    }

    public Model get_animated_model(int animation, int current, int[] label) {
        if (this.transforms != null) {
            NpcDefinition def = this.get_configs();
            if (def == null) {
                return null;
            }
            return def.get_animated_model(animation, current, label);
        }
        Model model = (Model)model_cache.get(this.interfaceType);
        if (model == null) {
            boolean cached = false;
            if (this.modelId == null) {
                return null;
            }
            for (int i : this.modelId) {
                if (Model.cached(i)) continue;
                cached = true;
            }
            if (cached) {
                return null;
            }
            Model[] models = new Model[this.modelId.length];
            for (int index = 0; index < this.modelId.length; ++index) {
                models[index] = Model.get(this.modelId[index]);
            }
            model = models.length == 1 ? models[0] : new Model(models.length, models, true);
            if (this.recolorFrom != null) {
                for (int k1 = 0; k1 < this.recolorFrom.length; ++k1) {
                    model.recolor(this.recolorFrom[k1], this.recolorTo[k1]);
                }
            }
            if (this.modelCustomColor > 0) {
                model.completelyRecolor(this.modelCustomColor);
            }
            if (this.modelCustomColor2 != 0) {
                model.shadingRecolor(this.modelCustomColor2);
            }
            if (this.modelCustomColor3 != 0) {
                model.shadingRecolor2(this.modelCustomColor3);
            }
            if (this.modelCustomColor4 != 0) {
                model.shadingRecolor4(this.modelCustomColor4);
            }
            if (this.modelSetColor != 0) {
                model.shadingRecolor3(this.modelSetColor);
            }
            model.skin();
            model.light(84 + this.ambient, 1000 + this.contrast, -90, -580, -90, true);
            model_cache.put(model, this.interfaceType);
        }
        Model animated_model = Model.EMPTY_MODEL;
        animated_model.replace(model, Animation.validate(current) & Animation.validate(animation));
        if (current != -1 && animation != -1) {
            animated_model.mix(label, animation, current);
        } else if (current != -1) {
            animated_model.interpolate(current);
        }
        if (this.widthScale != 128 || this.heightScale != 128) {
            animated_model.scale(this.widthScale, this.heightScale, this.widthScale);
        }
        animated_model.calc_diagonals();
        animated_model.face_skin = null;
        animated_model.vertex_skin = null;
        if (this.size == 1) {
            animated_model.within_tile = true;
        }
        return animated_model;
    }

    /*
     * Unable to fully structure code
     */
    private void decode(Buffer buffer) {
        block0: while (true) {
            if ((opcode = buffer.readUnsignedByte()) == 0) {
                return;
            }
            if (opcode == 1) {
                j = buffer.readUnsignedByte();
                this.modelId = new int[j];
                j1 = 0;
                while (true) {
                    if (j1 >= j) continue block0;
                    this.modelId[j1] = buffer.readUShort();
                    ++j1;
                }
            }
            if (opcode == 2) {
                this.name = buffer.readString();
                continue;
            }
            if (opcode == 3) {
                this.description = buffer.readString();
                continue;
            }
            if (opcode == 12) {
                this.size = buffer.readSignedByte();
                continue;
            }
            if (opcode == 13) {
                this.standingAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 14) {
                this.walkingAnimation = buffer.readUShort();
                continue;
            }
            if (opcode == 15) {
                this.turnLeftSequence = buffer.readUShort();
                continue;
            }
            if (opcode == 16) {
                this.turnRightSequence = buffer.readUShort();
                continue;
            }
            if (opcode == 17) {
                this.walkingAnimation = buffer.readUShort();
                this.rotate180Animation = buffer.readUShort();
                this.rotate90LeftAnimation = buffer.readUShort();
                this.rotate90RightAnimation = buffer.readUShort();
                if (this.rotate180Animation == 65535) {
                    this.rotate180Animation = -1;
                }
                if (this.rotate90LeftAnimation == 65535) {
                    this.rotate90LeftAnimation = -1;
                }
                if (this.rotate90RightAnimation != 65535) continue;
                this.rotate90RightAnimation = -1;
                continue;
            }
            if (opcode == 18) {
                this.category = buffer.readUShort();
                continue;
            }
            if (opcode >= 30 && opcode < 40) {
                if (this.actions == null) {
                    this.actions = new String[10];
                }
                this.actions[opcode - 30] = buffer.readString();
                if (!this.actions[opcode - 30].equalsIgnoreCase("hidden")) continue;
                this.actions[opcode - 30] = null;
                continue;
            }
            if (opcode == 40) {
                k = buffer.readUnsignedByte();
                this.recolorFrom = new short[k];
                this.recolorTo = new short[k];
                k1 = 0;
                while (true) {
                    if (k1 >= k) continue block0;
                    this.recolorFrom[k1] = (short)buffer.readUShort();
                    this.recolorTo[k1] = (short)buffer.readUShort();
                    ++k1;
                }
            }
            if (opcode == 41) {
                length = buffer.readUnsignedByte();
                this.retextureFrom = new short[length];
                this.retextureTo = new short[length];
                index = 0;
                while (true) {
                    if (index >= length) continue block0;
                    this.retextureFrom[index] = (short)buffer.readUShort();
                    this.retextureTo[index] = (short)buffer.readUShort();
                    ++index;
                }
            }
            if (opcode == 60) {
                l = buffer.readUnsignedByte();
                this.additionalModels = new int[l];
                l1 = 0;
                while (true) {
                    if (l1 >= l) continue block0;
                    this.additionalModels[l1] = buffer.readUShort();
                    ++l1;
                }
            }
            if (opcode == 93) {
                this.drawMapDot = false;
                continue;
            }
            if (opcode == 95) {
                this.combatLevel = buffer.readUShort();
                continue;
            }
            if (opcode == 97) {
                this.widthScale = buffer.readUShort();
                continue;
            }
            if (opcode == 98) {
                this.heightScale = buffer.readUShort();
                continue;
            }
            if (opcode == 99) {
                this.hasRenderPriority = true;
                continue;
            }
            if (opcode == 100) {
                this.ambient = buffer.readSignedByte();
                continue;
            }
            if (opcode == 101) {
                this.contrast = buffer.readSignedByte();
                continue;
            }
            if (opcode == 102) {
                this.headIconPrayer = buffer.readUShort();
                continue;
            }
            if (opcode == 103) {
                this.rotation = buffer.readUShort();
                continue;
            }
            if (opcode == 109) {
                this.isClickable = false;
                continue;
            }
            if (opcode == 111) {
                this.isFollower = true;
                continue;
            }
            if (opcode == 106 || opcode == 118) {
                this.transformVarbit = buffer.readUShort();
                if (this.transformVarbit == 65535) {
                    this.transformVarbit = -1;
                }
                this.transformVarp = buffer.readUShort();
                if (this.transformVarp == 65535) {
                    this.transformVarp = -1;
                }
                var3 = -1;
                if (opcode == 118) {
                    var3 = buffer.readUShort();
                }
                i1 = buffer.readUnsignedByte();
                this.transforms = new int[i1 + 2];
                for (i2 = 0; i2 <= i1; ++i2) {
                    this.transforms[i2] = buffer.readUShort();
                    if (this.transforms[i2] != 65535) continue;
                    this.transforms[i2] = -1;
                }
                this.transforms[i1 + 1] = var3;
                continue;
            }
            if (opcode == 107) {
                this.isInteractable = false;
                continue;
            }
            if (opcode != 249) continue;
            length = buffer.readUnsignedByte();
            this.params = new HashMap<Integer, Object>(length);
            i = 0;
            while (true) {
                if (i < length) ** break;
                continue block0;
                isString = buffer.readUnsignedByte() == 1;
                key = buffer.read24Int();
                value = isString != false ? buffer.readString() : Integer.valueOf(buffer.readInt());
                this.params.put(key, value);
                ++i;
            }
            break;
        }
    }

    public NpcDefinition() {
        this.anInt64 = 1834;
    }

    static {
        model_cache = new ReferenceCache(30);
    }
}

