/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.def;

import com.ornate.Client;
import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.cache.anim.Animation;
import com.ornate.cache.config.VariableBits;
import com.ornate.cache.def.impl.ObjectManager;
import com.ornate.collection.ReferenceCache;
import com.ornate.entity.model.Model;
import com.ornate.io.Buffer;
import com.ornate.net.requester.ResourceProvider;
import com.ornate.util.FileUtils;
import java.util.HashMap;
import java.util.Map;

public final class ObjectDefinition {
    private int category;
    private int ambientSoundId;
    private int int2083;
    private int anInt2112;
    private int anInt2113;
    private int anInt2083;
    public int[] ambientSoundIds;
    private boolean randomAnimStart;
    private Map<Integer, Object> params = null;
    private boolean blocksProjectile;
    public static int length;
    public static int cache_index;
    public static boolean low_detail;
    public static Buffer data_buffer;
    public static ObjectDefinition[] cache;
    public static int[] stream_indices;
    public static final Model[] models;
    public static ReferenceCache model_cache;
    public static ReferenceCache animated_model_cache;
    public int id = -1;
    public int width;
    public int height;
    public int animation;
    public int orientation;
    public int model_scale_x;
    public int model_scale_y;
    public int model_scale_z;
    public int translate_x;
    public int translate_y;
    public int translate_z;
    public int minimap_function_id;
    public int map_scene_id;
    public int interact_state;
    public int decor_offset;
    public int merge_interact_state;
    public int varp_id;
    public int varbit_id;
    public int[] model_ids;
    public int[] configs;
    public int[] model_group;
    public int[] src_color;
    public int[] dst_color;
    public short[] src_texture;
    public short[] dst_texture;
    public String name;
    public String description;
    public String[] scene_actions;
    public int contrast;
    public byte ambient;
    public boolean rotated;
    public boolean walkable;
    public boolean contour_to_tile;
    public boolean occlude;
    public boolean unwalkable;
    public boolean solid;
    public boolean cast_shadow;
    public boolean gouraud_shading;
    public boolean obstructs_ground;
    int opcode_78_1 = 2019882883;
    int opcode_79_1 = 0;
    int opcode_79_2 = 0;
    int opcode_78_and_79 = 0;
    int[] opcode_79_3;

    public static void init(Archive archive) {
        int index;
        data_buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/objects/loc.dat") : archive.get("loc.dat"));
        Buffer index_buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/objects/loc.idx") : archive.get("loc.idx"));
        length = index_buffer.readUShort();
        System.out.printf("Loaded %d objects loading OSRS version %d and SUB version %d%n", length, 204, 2);
        stream_indices = new int[length];
        int offset = 2;
        for (index = 0; index < length; ++index) {
            ObjectDefinition.stream_indices[index] = offset;
            offset += index_buffer.readUShort();
        }
        cache = new ObjectDefinition[20];
        for (index = 0; index < 20; ++index) {
            ObjectDefinition.cache[index] = new ObjectDefinition();
        }
    }

    public void decode(Buffer buffer) {
        int opcode;
        while ((opcode = buffer.readUByte()) != 0) {
            int var;
            int length;
            if (opcode == 1) {
                length = buffer.readUByte();
                if (length <= 0) continue;
                if (this.model_ids == null || low_detail) {
                    this.model_group = new int[length];
                    this.model_ids = new int[length];
                    for (int index = 0; index < length; ++index) {
                        this.model_ids[index] = buffer.readUShort();
                        this.model_group[index] = buffer.readUByte();
                    }
                    continue;
                }
                buffer.pos += length * 3;
                continue;
            }
            if (opcode == 2) {
                this.name = buffer.readStrings();
                continue;
            }
            if (opcode == 3) {
                this.description = buffer.readStrings();
                continue;
            }
            if (opcode == 5) {
                length = buffer.readUByte();
                if (length <= 0) continue;
                if (this.model_ids == null || low_detail) {
                    this.model_group = null;
                    this.model_ids = new int[length];
                    for (int index = 0; index < length; ++index) {
                        this.model_ids[index] = buffer.readUShort();
                    }
                    continue;
                }
                buffer.pos += length * 2;
                continue;
            }
            if (opcode == 14) {
                this.width = buffer.readUByte();
                continue;
            }
            if (opcode == 15) {
                this.height = buffer.readUByte();
                continue;
            }
            if (opcode == 17) {
                this.solid = false;
                continue;
            }
            if (opcode == 18) {
                this.walkable = false;
                continue;
            }
            if (opcode == 19) {
                this.interact_state = buffer.readUByte();
                continue;
            }
            if (opcode == 21) {
                this.contour_to_tile = true;
                continue;
            }
            if (opcode == 22) {
                this.gouraud_shading = false;
                continue;
            }
            if (opcode == 23) {
                this.occlude = true;
                continue;
            }
            if (opcode == 24) {
                this.animation = buffer.readUShort();
                if (this.animation != 65535) continue;
                this.animation = -1;
                continue;
            }
            if (opcode == 27) {
                this.solid = true;
                continue;
            }
            if (opcode == 28) {
                this.decor_offset = buffer.readUByte();
                continue;
            }
            if (opcode == 29) {
                this.ambient = buffer.readSignedByte();
                continue;
            }
            if (opcode == 39) {
                this.contrast = buffer.readSignedByte() * 25;
                continue;
            }
            if (opcode >= 30 && opcode < 35) {
                if (this.scene_actions == null) {
                    this.scene_actions = new String[5];
                }
                this.scene_actions[opcode - 30] = buffer.readStrings();
                if (!this.scene_actions[opcode - 30].equalsIgnoreCase("hidden")) continue;
                this.scene_actions[opcode - 30] = null;
                continue;
            }
            if (opcode == 40) {
                length = buffer.readUByte();
                this.src_color = new int[length];
                this.dst_color = new int[length];
                for (int index = 0; index < length; ++index) {
                    this.src_color[index] = buffer.readUShort();
                    this.dst_color[index] = buffer.readUShort();
                }
                continue;
            }
            if (opcode == 41) {
                length = buffer.readUByte();
                this.src_texture = new short[length];
                this.dst_texture = new short[length];
                for (int index = 0; index < length; ++index) {
                    this.src_texture[index] = (short)buffer.readUShort();
                    this.dst_texture[index] = (short)buffer.readUShort();
                }
                continue;
            }
            if (opcode == 82) {
                this.minimap_function_id = buffer.readUShort();
                continue;
            }
            if (opcode == 61) {
                this.category = buffer.readUShort();
                continue;
            }
            if (opcode == 62) {
                this.rotated = true;
                continue;
            }
            if (opcode == 64) {
                this.cast_shadow = false;
                continue;
            }
            if (opcode == 65) {
                this.model_scale_x = buffer.readUShort();
                continue;
            }
            if (opcode == 66) {
                this.model_scale_y = buffer.readUShort();
                continue;
            }
            if (opcode == 67) {
                this.model_scale_z = buffer.readUShort();
                continue;
            }
            if (opcode == 68) {
                this.map_scene_id = buffer.readUShort();
                continue;
            }
            if (opcode == 69) {
                this.orientation = buffer.readUByte();
                continue;
            }
            if (opcode == 70) {
                this.translate_x = buffer.readSignedShort();
                continue;
            }
            if (opcode == 71) {
                this.translate_y = buffer.readSignedShort();
                continue;
            }
            if (opcode == 72) {
                this.translate_z = buffer.readSignedShort();
                continue;
            }
            if (opcode == 73) {
                this.obstructs_ground = true;
                continue;
            }
            if (opcode == 74) {
                this.unwalkable = true;
                continue;
            }
            if (opcode == 75) {
                this.merge_interact_state = buffer.readUByte();
                continue;
            }
            if (opcode == 77) {
                this.varbit_id = buffer.readUShort();
                if (this.varbit_id == 65535) {
                    this.varbit_id = -1;
                }
                this.varp_id = buffer.readUShort();
                if (this.varp_id == 65535) {
                    this.varp_id = -1;
                }
                length = buffer.readUByte();
                this.configs = new int[length + 2];
                for (int index = 0; index <= length; ++index) {
                    this.configs[index] = buffer.readUShort();
                    if (this.configs[index] != 65535) continue;
                    this.configs[index] = -1;
                }
                this.configs[length + 1] = -1;
                continue;
            }
            if (opcode == 78) {
                this.opcode_78_1 = buffer.readUShort();
                this.opcode_78_and_79 = buffer.readUByte();
                continue;
            }
            if (opcode == 79) {
                this.opcode_79_1 = buffer.readUShort();
                this.opcode_79_2 = buffer.readUShort();
                this.opcode_78_and_79 = buffer.readUByte();
                length = buffer.readUByte();
                this.opcode_79_3 = new int[length];
                for (int index = 0; index < length; ++index) {
                    this.opcode_79_3[index] = buffer.readUShort();
                }
                continue;
            }
            if (opcode == 81) {
                this.contour_to_tile = buffer.readUnsignedByte() >= 0;
                continue;
            }
            if (opcode == 82) {
                buffer.readUShort();
                continue;
            }
            if (opcode == 89) {
                this.randomAnimStart = false;
                continue;
            }
            if (opcode == 249) {
                length = buffer.readUnsignedByte();
                HashMap<Integer, Object> params = new HashMap<Integer, Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object value;
                    boolean isString = buffer.readUnsignedByte() == 1;
                    int key = buffer.read24Int();
                    if (isString) {
                        value = buffer.readString();
                        System.out.println(value);
                    } else {
                        value = buffer.readInt();
                    }
                    params.put(key, value);
                }
                this.params = params;
                continue;
            }
            if (opcode != 92) continue;
            this.varbit_id = buffer.readUShort();
            if (this.varbit_id == 65535) {
                this.varbit_id = -1;
            }
            this.varp_id = buffer.readUShort();
            if (this.varp_id == 65535) {
                this.varp_id = -1;
            }
            if ((var = buffer.readUShort()) == 65535) {
                var = -1;
            }
            int length2 = buffer.readUByte();
            this.configs = new int[length2 + 2];
            for (int index = 0; index <= length2; ++index) {
                this.configs[index] = buffer.readUShort();
                if (this.configs[index] != 65535) continue;
                this.configs[index] = -1;
            }
            this.configs[length2 + 1] = var;
        }
        this.post_decode();
    }

    public void post_decode() {
        if (this.interact_state == -1) {
            this.interact_state = 0;
            if (this.name != null && !this.name.equalsIgnoreCase("null")) {
                if (this.model_ids != null && (this.model_group == null || this.model_group[0] == 10)) {
                    this.interact_state = 1;
                }
                if (this.scene_actions != null) {
                    this.interact_state = 1;
                }
            }
        }
        if (this.unwalkable) {
            this.solid = false;
            this.walkable = false;
        }
        if (this.merge_interact_state == -1) {
            this.merge_interact_state = this.solid ? 1 : 0;
        }
    }

    public static ObjectDefinition get(int id) {
        if (id > stream_indices.length) {
            id = stream_indices.length - 1;
        }
        if (id == 25913) {
            id = 15552;
        }
        if (id == 25916 || id == 25926) {
            id = 15553;
        }
        if (id == 25917) {
            id = 15554;
        }
        for (int index = 0; index < 20; ++index) {
            if (ObjectDefinition.cache[index].id != id) continue;
            return cache[index];
        }
        cache_index = (cache_index + 1) % 20;
        ObjectDefinition def = cache[cache_index];
        ObjectDefinition.data_buffer.pos = stream_indices[id];
        def.id = id;
        def.set_defaults();
        def.decode(data_buffer);
        if (def.id == 29308) {
            def.gouraud_shading = false;
        }
        if (def.id == 14924) {
            def.width = 1;
        }
        ObjectManager.get(id);
        return def;
    }

    public void set_defaults() {
        this.model_ids = null;
        this.model_group = null;
        this.name = null;
        this.description = null;
        this.src_color = null;
        this.dst_color = null;
        this.dst_texture = null;
        this.src_texture = null;
        this.width = 1;
        this.height = 1;
        this.solid = true;
        this.walkable = true;
        this.interact_state = -1;
        this.contour_to_tile = false;
        this.gouraud_shading = false;
        this.occlude = false;
        this.animation = -1;
        this.decor_offset = 16;
        this.ambient = 0;
        this.contrast = 0;
        this.scene_actions = null;
        this.minimap_function_id = -1;
        this.map_scene_id = -1;
        this.rotated = false;
        this.cast_shadow = true;
        this.model_scale_x = 128;
        this.model_scale_y = 128;
        this.model_scale_z = 128;
        this.orientation = 0;
        this.translate_x = 0;
        this.translate_y = 0;
        this.translate_z = 0;
        this.obstructs_ground = false;
        this.unwalkable = false;
        this.merge_interact_state = -1;
        this.varbit_id = -1;
        this.varp_id = -1;
        this.configs = null;
    }

    public void passive_request_load(ResourceProvider provider) {
        if (this.model_ids == null) {
            return;
        }
        for (int index = 0; index < this.model_ids.length; ++index) {
            provider.passive_request(this.model_ids[index] & 0xFFFF, 0);
        }
    }

    public Model get_object(int type, int orientation, int cosine_y, int sine_y, int cosine_x, int sine_x, int animation_id) {
        Model model = this.get_animated_model(type, animation_id, orientation);
        if (model == null) {
            return null;
        }
        if (this.contour_to_tile || this.gouraud_shading) {
            model = new Model(this.contour_to_tile, this.gouraud_shading, model);
        }
        if (this.contour_to_tile) {
            int height = (cosine_y + sine_y + cosine_x + sine_x) / 4;
            int vertex = 0;
            while (vertex < model.vertices) {
                int start_x = model.vertex_x[vertex];
                int start_y = model.vertex_z[vertex];
                int y = cosine_y + (sine_y - cosine_y) * (start_x + 64) / 128;
                int x = sine_x + (cosine_x - sine_x) * (start_x + 64) / 128;
                int undulation_offset = y + (x - y) * (start_y + 64) / 128;
                int n = vertex++;
                model.vertex_y[n] = model.vertex_y[n] + (undulation_offset - height);
            }
            model.computeSphericalBounds();
        }
        return model;
    }

    public boolean group_cached(int type) {
        if (this.model_group == null) {
            if (this.model_ids == null) {
                return true;
            }
            if (type != 10) {
                return true;
            }
            boolean cached = true;
            for (int index = 0; index < this.model_ids.length; ++index) {
                cached &= Model.cached(this.model_ids[index]);
            }
            return cached;
        }
        for (int index = 0; index < this.model_group.length; ++index) {
            if (this.model_group[index] != type) continue;
            return Model.cached(this.model_ids[index]);
        }
        return true;
    }

    public boolean cached() {
        if (this.model_ids == null) {
            return true;
        }
        boolean cached = true;
        for (int model_id : this.model_ids) {
            cached &= Model.cached(model_id);
        }
        return cached;
    }

    public ObjectDefinition get_configs() {
        int setting_id = -1;
        if (this.varbit_id != -1) {
            VariableBits bit = VariableBits.cache[this.varbit_id];
            int setting = bit.configId;
            int low = bit.leastSignificantBit;
            int high = bit.mostSignificantBit;
            int mask = Client.BIT_MASKS[high - low];
            setting_id = Client.singleton.settings[setting] >> low & mask;
        } else if (this.varp_id != -1) {
            setting_id = Client.singleton.settings[this.varp_id];
        }
        if (setting_id < 0 || setting_id >= this.configs.length || this.configs[setting_id] == -1) {
            return null;
        }
        return ObjectDefinition.get(this.configs[setting_id]);
    }

    public Model get_animated_model(int type, int animation_id, int orientation) {
        int index;
        long key;
        Model model = null;
        if (this.model_group == null) {
            if (type != 10) {
                return null;
            }
            key = (long)((this.id << 6) + orientation) + ((long)(animation_id + 1) << 32);
            Model cached = (Model)model_cache.get(key);
            if (cached != null) {
                return cached;
            }
            if (this.model_ids == null) {
                return null;
            }
            boolean invert = this.rotated ^ orientation > 3;
            int length = this.model_ids.length;
            for (index = 0; index < length; ++index) {
                int invert_id = this.model_ids[index];
                if (invert) {
                    invert_id += 65536;
                }
                if ((model = (Model)animated_model_cache.get(invert_id)) == null) {
                    model = Model.get(invert_id & 0xFFFF);
                    if (model == null) {
                        return null;
                    }
                    if (invert) {
                        model.invert();
                    }
                    animated_model_cache.put(model, invert_id);
                }
                if (length <= 1) continue;
                ObjectDefinition.models[index] = model;
            }
            if (length > 1) {
                model = new Model(length, models, true);
            }
        } else {
            int model_id = -1;
            for (int index2 = 0; index2 < this.model_group.length; ++index2) {
                if (this.model_group[index2] != type) continue;
                model_id = index2;
                break;
            }
            if (model_id == -1) {
                return null;
            }
            key = (long)((this.id << 8) + (model_id << 3) + orientation) + ((long)(animation_id + 1) << 32);
            Model cached = (Model)model_cache.get(key);
            if (cached != null) {
                return cached;
            }
            model_id = this.model_ids[model_id];
            boolean invert = this.rotated ^ orientation > 3;
            if (invert) {
                model_id += 65536;
            }
            if ((model = (Model)animated_model_cache.get(model_id)) == null) {
                model = Model.get(model_id & 0xFFFF);
                if (model == null) {
                    return null;
                }
                if (invert) {
                    model.invert();
                }
                animated_model_cache.put(model, model_id);
            }
        }
        boolean scale = this.model_scale_x != 128 || this.model_scale_y != 128 || this.model_scale_z != 128;
        boolean translate = this.translate_x != 0 || this.translate_y != 0 || this.translate_z != 0;
        Model animated_model = new Model(this.src_color == null, Animation.validate(animation_id), orientation == 0 && animation_id == -1 && !scale && !translate, this.src_texture == null, model);
        if (animation_id != -1) {
            animated_model.skin();
            animated_model.interpolate(animation_id);
            animated_model.face_skin = null;
            animated_model.vertex_skin = null;
        }
        while (orientation-- > 0) {
            animated_model.rotate_90();
        }
        if (this.src_color != null) {
            for (index = 0; index < this.src_color.length; ++index) {
                animated_model.recolor(this.src_color[index], this.dst_color[index]);
            }
        }
        if (this.src_texture != null) {
            for (index = 0; index < this.src_texture.length; ++index) {
                animated_model.retexture(this.src_texture[index], this.dst_texture[index]);
            }
        }
        if (scale) {
            animated_model.scale(this.model_scale_x, this.model_scale_z, this.model_scale_y);
        }
        if (translate) {
            animated_model.translate(this.translate_x, this.translate_y, this.translate_z);
        }
        animated_model.light(60 + this.ambient, 768 + this.contrast, -50, -10, -50, !this.gouraud_shading);
        if (this.merge_interact_state == 1) {
            animated_model.obj_height = animated_model.modelHeight;
        }
        animated_model_cache.put(animated_model, key);
        return animated_model;
    }

    public static void release() {
        model_cache = null;
        animated_model_cache = null;
        stream_indices = null;
        cache = null;
        data_buffer = null;
    }

    static {
        low_detail = false;
        models = new Model[4];
        model_cache = new ReferenceCache(500);
        animated_model_cache = new ReferenceCache(30);
    }
}

