/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.def;

import com.ornate.cache.def.SpriteDefinition;
import com.ornate.cache.def.provider.SpriteProvider;
import com.ornate.draw.Rasterizer3D;

public class TextureDefinition {
    private int id;
    private int[] fileIds;
    public transient int[] pixels;
    public int[] field1780;
    public int[] field1781;
    public int[] field1786;
    public boolean renderHQ;
    public int averageRGBColor;
    public int field1782;
    public int field1783;

    public void rasterize(int brightness, int width, SpriteProvider spriteProvider) {
        int pixelCount = width * width;
        this.pixels = new int[pixelCount];
        for (int fileId = 0; fileId < this.fileIds.length; ++fileId) {
            int y;
            int x;
            int var12;
            int var11;
            SpriteDefinition spriteDefinition = spriteProvider.provide(this.fileIds[fileId], 0);
            spriteDefinition.normalize();
            byte[] pixelIdx = spriteDefinition.pixelIdx;
            int[] texturePalette = spriteDefinition.palette;
            int var10 = this.field1786[fileId];
            if ((var10 & 0xFF000000) == 0x3000000) {
                var11 = var10 & 0xFF00FF;
                var12 = var10 >> 8 & 0xFF;
                for (x = 0; x < texturePalette.length; ++x) {
                    y = texturePalette[x];
                    if (y >> 8 != (y & 0xFFFF)) continue;
                    texturePalette[x] = var11 * (y &= 0xFF) >> 8 & 0xFF00FF | var12 * y & 0xFF00;
                }
            }
            for (var11 = 0; var11 < texturePalette.length; ++var11) {
                texturePalette[var11] = Rasterizer3D.adjust_brightness(texturePalette[var11], brightness);
            }
            var11 = fileId == 0 ? 0 : this.field1780[fileId - 1];
            if (var11 != 0) continue;
            if (width == spriteDefinition.getMaxWidth()) {
                for (var12 = 0; var12 < pixelCount; ++var12) {
                    this.pixels[var12] = texturePalette[pixelIdx[var12] & 0xFF];
                }
                continue;
            }
            if (spriteDefinition.getMaxWidth() == 64 && width == 128) {
                var12 = 0;
                for (x = 0; x < width; ++x) {
                    for (y = 0; y < width; ++y) {
                        this.pixels[var12++] = texturePalette[pixelIdx[(x >> 1 << 6) + (y >> 1)] & 0xFF];
                    }
                }
                continue;
            }
            if (spriteDefinition.getMaxWidth() != 128 || width != 64) {
                throw new RuntimeException();
            }
            var12 = 0;
            for (x = 0; x < width; ++x) {
                for (y = 0; y < width; ++y) {
                    this.pixels[var12++] = texturePalette[pixelIdx[(y << 1) + (x << 1 << 7)] & 0xFF];
                }
            }
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setFileIds(int[] files) {
        this.fileIds = files;
    }
}

