/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.def.loaders;

import com.ornate.cache.def.SpriteDefinition;
import com.ornate.io.InputStream;

public class SpriteLoader {
    public static final int FLAG_VERTICAL = 1;
    public static final int FLAG_ALPHA = 2;

    public SpriteDefinition[] load(int id, byte[] b) {
        int i;
        int i2;
        InputStream is = new InputStream(b);
        is.setOffset(is.getLength() - 2);
        int spriteCount = is.readUnsignedShort();
        SpriteDefinition[] sprites = new SpriteDefinition[spriteCount];
        is.setOffset(is.getLength() - 7 - spriteCount * 8);
        int width = is.readUnsignedShort();
        int height = is.readUnsignedShort();
        int paletteLength = is.readUnsignedByte() + 1;
        for (i2 = 0; i2 < spriteCount; ++i2) {
            sprites[i2] = new SpriteDefinition();
            sprites[i2].setId(id);
            sprites[i2].setFrame(i2);
            sprites[i2].setMaxWidth(width);
            sprites[i2].setMaxHeight(height);
        }
        for (i2 = 0; i2 < spriteCount; ++i2) {
            sprites[i2].setOffsetX(is.readUnsignedShort());
        }
        for (i2 = 0; i2 < spriteCount; ++i2) {
            sprites[i2].setOffsetY(is.readUnsignedShort());
        }
        for (i2 = 0; i2 < spriteCount; ++i2) {
            sprites[i2].setWidth(is.readUnsignedShort());
        }
        for (i2 = 0; i2 < spriteCount; ++i2) {
            sprites[i2].setHeight(is.readUnsignedShort());
        }
        is.setOffset(is.getLength() - 7 - spriteCount * 8 - (paletteLength - 1) * 3);
        int[] palette = new int[paletteLength];
        for (i = 1; i < paletteLength; ++i) {
            palette[i] = is.read24BitInt();
            if (palette[i] != 0) continue;
            palette[i] = 1;
        }
        is.setOffset(0);
        for (i = 0; i < spriteCount; ++i) {
            int k;
            int j;
            SpriteDefinition def = sprites[i];
            int spriteWidth = def.getWidth();
            int spriteHeight = def.getHeight();
            int dimension = spriteWidth * spriteHeight;
            byte[] pixelPaletteIndicies = new byte[dimension];
            byte[] pixelAlphas = new byte[dimension];
            def.pixelIdx = pixelPaletteIndicies;
            def.palette = palette;
            int flags = is.readUnsignedByte();
            if ((flags & 1) == 0) {
                for (j = 0; j < dimension; ++j) {
                    pixelPaletteIndicies[j] = is.readByte();
                }
            } else {
                for (j = 0; j < spriteWidth; ++j) {
                    for (k = 0; k < spriteHeight; ++k) {
                        pixelPaletteIndicies[spriteWidth * k + j] = is.readByte();
                    }
                }
            }
            if ((flags & 2) != 0) {
                if ((flags & 1) == 0) {
                    for (j = 0; j < dimension; ++j) {
                        pixelAlphas[j] = is.readByte();
                    }
                } else {
                    for (j = 0; j < spriteWidth; ++j) {
                        for (k = 0; k < spriteHeight; ++k) {
                            pixelAlphas[spriteWidth * k + j] = is.readByte();
                        }
                    }
                }
            } else {
                for (j = 0; j < dimension; ++j) {
                    byte index = pixelPaletteIndicies[j];
                    if (index == 0) continue;
                    pixelAlphas[j] = -1;
                }
            }
            int[] pixels = new int[dimension];
            for (int j2 = 0; j2 < dimension; ++j2) {
                int index = pixelPaletteIndicies[j2] & 0xFF;
                pixels[j2] = palette[index] | pixelAlphas[j2] << 24;
            }
            def.setPixels(pixels);
        }
        return sprites;
    }
}

