/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.factory;

import com.ornate.cache.def.ItemDefinition;
import com.ornate.cache.graphics.SimpleImage;
import com.ornate.collection.ReferenceCache;
import com.ornate.draw.Rasterizer2D;
import com.ornate.draw.Rasterizer3D;
import com.ornate.entity.model.Model;

public class ItemSpriteFactory {
    public static ReferenceCache sprites_cache = new ReferenceCache(100);
    public static ReferenceCache scaled_cache = new ReferenceCache(100);

    public static SimpleImage getSmallSprite(int itemId, int amount) {
        return ItemSpriteFactory.get_sized_item_sprite(itemId, amount, 0, 18, 18, false);
    }

    public static SimpleImage get_sized_item_sprite(int id, int stack_size, int border, int w, int h, boolean dumpImages) {
        try {
            Model model;
            ItemDefinition def;
            SimpleImage cached;
            if (border == 0) {
                cached = (SimpleImage)sprites_cache.get(id);
                if (cached != null && cached.max_height != stack_size && cached.max_height != -1) {
                    cached.unlink();
                    cached = null;
                }
                if (cached != null && cached.width != 32) {
                    return cached;
                }
            }
            if (border == 1) {
                cached = (SimpleImage)scaled_cache.get(id);
                if (cached != null && cached.max_height != stack_size && cached.max_height != -1) {
                    cached.unlink();
                    cached = null;
                }
                if (cached != null) {
                    return cached;
                }
            }
            if ((def = ItemDefinition.get(id)) == null) {
                // empty if block
            }
            if (def.countobj == null) {
                stack_size = -1;
            }
            if (stack_size > 1) {
                int stack_item_id = -1;
                for (int index = 0; index < 10; ++index) {
                    if (stack_size < def.countco[index] || def.countco[index] == 0) continue;
                    stack_item_id = def.countobj[index];
                }
                if (stack_item_id != -1) {
                    def = ItemDefinition.get(stack_item_id);
                }
            }
            if ((model = def.get_model(1)) == null) {
                return null;
            }
            SimpleImage noted_sprite = null;
            if (def.notedTemplate != -1 && (noted_sprite = ItemSpriteFactory.get_item_sprite(def.note, 10, -1)) == null) {
                return null;
            }
            SimpleImage item = new SimpleImage(w, h);
            int center_x = Rasterizer3D.textureInt1;
            int center_y = Rasterizer3D.textureInt2;
            int[] line_offsets = Rasterizer3D.line_offsets;
            int[] pixels = Rasterizer2D.pixels;
            float[] depthBuffer = Rasterizer2D.depth_buffer;
            int width = Rasterizer2D.width;
            int height = Rasterizer2D.height;
            int viewport_left = Rasterizer2D.topX;
            int viewport_right = Rasterizer2D.bottomX;
            int viewport_top = Rasterizer2D.topY;
            int viewport_bottom = Rasterizer2D.bottomY;
            Rasterizer3D.mapped = false;
            Rasterizer2D.init(item.pixels, w, h, new float[w * h]);
            Rasterizer2D.draw_filled_rect(0, 0, w, h, 0);
            Rasterizer3D.set_clip();
            int zoom2d = def.zoom2d;
            if (border == -1) {
                zoom2d = (int)((double)zoom2d * 1.5);
            }
            if (border > 0) {
                zoom2d = (int)((double)zoom2d * 1.04);
            }
            zoom2d = dumpImages ? (zoom2d /= 4) : (int)((double)zoom2d * 1.5);
            int sine = Rasterizer3D.SINE[def.xan2d] * zoom2d >> 16;
            int cosine = Rasterizer3D.COSINE[def.xan2d] * zoom2d >> 16;
            model.render_2D(def.yan2d, def.zan2d, def.xan2d, def.xOffset2d, sine + model.modelHeight / 2 + def.yOffset2d, cosine + def.yOffset2d);
            item.highlight(1);
            if (border == 0xFFFFFF) {
                item.highlight(0xFFFFFF);
            } else if (border < 1 && border != -1) {
                item.shadow(0x302020);
            }
            Rasterizer2D.init(item.pixels, w, h, new float[w * h]);
            if (def.notedTemplate != -1) {
                int old_w = noted_sprite.max_width;
                int old_h = noted_sprite.max_height;
                noted_sprite.max_width = w;
                noted_sprite.max_height = h;
                noted_sprite.drawSprite(0, 0);
                noted_sprite.max_width = old_w;
                noted_sprite.max_height = old_h;
            }
            if (border == 0 && !def.animateInventory) {
                sprites_cache.put(item, id);
            }
            if (border == 1 && !def.animateInventory) {
                scaled_cache.put(item, id);
            }
            Rasterizer2D.init(pixels, width, height, depthBuffer);
            Rasterizer2D.set_clip(viewport_left, viewport_top, viewport_right, viewport_bottom);
            Rasterizer3D.textureInt1 = center_x;
            Rasterizer3D.textureInt2 = center_y;
            Rasterizer3D.line_offsets = line_offsets;
            Rasterizer3D.mapped = true;
            item.max_width = def.stackable == 1 ? w + 1 : w;
            item.max_height = stack_size;
            return item;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new NullPointerException("Error generating item sprite! [ItemSpriteFactory -> get_item_sprite()]");
        }
    }

    public static SimpleImage get_item_sprite(int id, int stack_size, int highlight) {
        try {
            Model model;
            ItemDefinition def;
            SimpleImage cached;
            if (highlight == 0) {
                cached = (SimpleImage)sprites_cache.get(id);
                if (cached != null && cached.max_height != stack_size && cached.max_height != -1) {
                    cached.unlink();
                    cached = null;
                }
                if (cached != null) {
                    return cached;
                }
            }
            if (highlight == 1) {
                cached = (SimpleImage)scaled_cache.get(id);
                if (cached != null && cached.max_height != stack_size && cached.max_height != -1) {
                    cached.unlink();
                    cached = null;
                }
                if (cached != null) {
                    return cached;
                }
            }
            if ((def = ItemDefinition.get(id)) == null) {
                System.out.println("[ERROR] ItemSpriteFactory get_item_sprite - def == null! " + id);
            }
            if (def.countobj == null) {
                stack_size = -1;
            }
            if (stack_size > 1) {
                int stack_item_id = -1;
                for (int index = 0; index < 10; ++index) {
                    if (stack_size < def.countco[index] || def.countco[index] == 0) continue;
                    stack_item_id = def.countobj[index];
                }
                if (stack_item_id != -1) {
                    def = ItemDefinition.get(stack_item_id);
                }
            }
            if ((model = def.get_model(1)) == null) {
                return null;
            }
            SimpleImage noted_sprite = null;
            if (def.notedTemplate != -1 && (noted_sprite = ItemSpriteFactory.get_item_sprite(def.note, 10, -1)) == null) {
                return null;
            }
            SimpleImage item = new SimpleImage(32, 32);
            int center_x = Rasterizer3D.textureInt1;
            int center_y = Rasterizer3D.textureInt2;
            int[] line_offsets = Rasterizer3D.line_offsets;
            int[] pixels = Rasterizer2D.pixels;
            float[] depth = Rasterizer2D.depth_buffer;
            int width = Rasterizer2D.width;
            int height = Rasterizer2D.height;
            int viewport_left = Rasterizer2D.topX;
            int viewport_right = Rasterizer2D.bottomX;
            int viewport_top = Rasterizer2D.topY;
            int viewport_bottom = Rasterizer2D.bottomY;
            Rasterizer3D.mapped = false;
            Rasterizer2D.init(item.pixels, 32, 32, new float[1024]);
            Rasterizer2D.draw_filled_rect(0, 0, 32, 32, 0);
            Rasterizer3D.set_clip();
            int zoom = def.zoom2d;
            if (highlight == -1) {
                zoom = (int)((double)zoom * 1.5);
            }
            if (highlight > 0) {
                zoom = (int)((double)zoom * 1.04);
            }
            int sine = Rasterizer3D.SINE[def.xan2d] * zoom >> 16;
            int cosine = Rasterizer3D.COSINE[def.xan2d] * zoom >> 16;
            model.render_2D(def.yan2d, def.zan2d, def.xan2d, def.xOffset2d, sine + model.modelHeight / 2 + def.yOffset2d, cosine + def.yOffset2d);
            item.highlight(1);
            if (highlight == 0xFFFFFF) {
                item.highlight(0xFFFFFF);
            } else if (highlight < 1 && highlight != -1) {
                item.shadow(0x302020);
            }
            Rasterizer2D.init(item.pixels, 32, 32, new float[1024]);
            if (def.notedTemplate != -1) {
                int old_w = noted_sprite.max_width;
                int old_h = noted_sprite.max_height;
                noted_sprite.max_width = 32;
                noted_sprite.max_height = 32;
                noted_sprite.drawSprite(0, 0);
                noted_sprite.max_width = old_w;
                noted_sprite.max_height = old_h;
            }
            if (highlight == 0 && !def.animateInventory) {
                sprites_cache.put(item, id);
            }
            if (highlight == 1 && !def.animateInventory) {
                scaled_cache.put(item, id);
            }
            Rasterizer2D.init(pixels, width, height, depth);
            Rasterizer2D.set_clip(viewport_left, viewport_top, viewport_right, viewport_bottom);
            Rasterizer3D.textureInt1 = center_x;
            Rasterizer3D.textureInt2 = center_y;
            Rasterizer3D.line_offsets = line_offsets;
            Rasterizer3D.mapped = true;
            item.max_width = def.stackable == 1 ? 33 : 32;
            item.max_height = stack_size;
            return item;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new NullPointerException("Error generating item sprite! [ItemSpriteFactory -> get_item_sprite()]");
        }
    }
}

