/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.graphics;

import com.ornate.cache.Archive;
import com.ornate.draw.Rasterizer2D;
import com.ornate.io.Buffer;
import com.ornate.sign.SignLink;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import javax.swing.ImageIcon;

public final class SimpleImage
extends Rasterizer2D {
    private Image image;
    public int[] pixels;
    public int width;
    public int height;
    public int x_offset;
    public int y_offset;
    public int max_width;
    public int max_height;
    public int drawX;
    public int drawY;
    public String path;

    public Image getImage() {
        return this.image;
    }

    public static Image downScaleImage(Image image, int width, int height) {
        return image.getScaledInstance(width, height, 8);
    }

    public boolean isInBounds(int x, int y) {
        return x >= this.drawX && x <= this.drawX + this.width && y >= this.drawY && y <= this.drawY + this.height;
    }

    public SimpleImage(String img, int length, int height) {
        try {
            this.path = img;
            this.image = Toolkit.getDefaultToolkit().getImage(SignLink.findCacheDir() + "client_sprites/" + img + ".png");
            Image resize = SimpleImage.downScaleImage(this.image, length, height);
            ImageIcon sprite = new ImageIcon(resize);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.pixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(resize, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            pixelgrabber.grabPixels();
            this.image = null;
            this.set_transparent_pixels(255, 0, 255);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public SimpleImage(int width, int height) {
        this.pixels = new int[width * height];
        this.width = this.max_width = width;
        this.height = this.max_height = height;
        this.y_offset = 0;
        this.x_offset = 0;
    }

    public SimpleImage(Archive archive, String name, int id) {
        int index;
        Buffer buffer = new Buffer(archive.get(name + ".dat"));
        Buffer data = new Buffer(archive.get("index.dat"));
        data.pos = buffer.readUShort();
        this.max_width = data.readUShort();
        this.max_height = data.readUShort();
        int length = data.readUByte();
        int[] pixels = new int[length];
        for (index = 0; index < length - 1; ++index) {
            pixels[index + 1] = data.readTriByte();
            if (pixels[index + 1] != 0) continue;
            pixels[index + 1] = 1;
        }
        for (index = 0; index < id; ++index) {
            data.pos += 2;
            buffer.pos += data.readUShort() * data.readUShort();
            ++data.pos;
        }
        this.x_offset = data.readUByte();
        this.y_offset = data.readUByte();
        this.width = data.readUShort();
        this.height = data.readUShort();
        int opcode = data.readUByte();
        int size = this.width * this.height;
        this.pixels = new int[size];
        if (opcode == 0) {
            for (int pixel = 0; pixel < size; ++pixel) {
                this.pixels[pixel] = pixels[buffer.readUByte()];
            }
            this.set_transparent_pixels(255, 0, 255);
            return;
        }
        if (opcode == 1) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.pixels[x + y * this.width] = pixels[buffer.readUByte()];
                }
            }
        }
        this.set_transparent_pixels(255, 0, 255);
    }

    public SimpleImage(Image url, int width, int height) {
        try {
            if (url == null) {
                return;
            }
            Image image = url.getScaledInstance(width, height, 4);
            this.width = width;
            this.height = height;
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.pixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            pixelgrabber.grabPixels();
            image = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SimpleImage(Image image) {
        ImageIcon imageicon = new ImageIcon(image);
        imageicon.getIconHeight();
        imageicon.getIconWidth();
        try {
            this.width = imageicon.getIconWidth();
            this.height = imageicon.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.pixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            pixelgrabber.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SimpleImage(byte[] spriteData, float width, int height) {
        try {
            this.image = Toolkit.getDefaultToolkit().createImage(spriteData);
            ImageIcon sprite = new ImageIcon(this.image);
            this.width = (int)width;
            this.height = height;
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.pixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(this.image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            pixelgrabber.grabPixels();
            this.image = null;
            this.set_transparent_pixels(255, 0, 255);
        }
        catch (Exception _ex) {
            System.err.println(_ex);
        }
    }

    public SimpleImage(String img) {
        try {
            this.path = img;
            this.image = Toolkit.getDefaultToolkit().getImage(SignLink.findCacheDir() + "client_sprites/" + img + ".png");
            ImageIcon sprite = new ImageIcon(this.image);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.pixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(this.image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            pixelgrabber.grabPixels();
            this.image = null;
            this.set_transparent_pixels(255, 0, 255);
        }
        catch (Exception _ex) {
            System.err.println(_ex);
        }
    }

    public void drawAdvancedTransparentSprite(int x, int y, int opacity) {
        int alpha = (int)((double)opacity * 2.56);
        if (alpha > 256 || alpha < 0) {
            alpha = 256;
        }
        int dst_pos = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int src_pos = 0;
        int height = this.height;
        int width = this.width;
        int dst_width = Rasterizer2D.width - width;
        int dst_height = 0;
        if (y < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - y;
            height -= k2;
            y = Rasterizer2D.topY;
            src_pos += k2 * width;
            dst_pos += k2 * Rasterizer2D.width;
        }
        if (y + height > bottomY) {
            height -= y + height - bottomY;
        }
        if (x < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - x;
            width -= l2;
            x = Rasterizer2D.topX;
            src_pos += l2;
            dst_pos += l2;
            dst_height += l2;
            dst_width += l2;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int i3 = x + width - Rasterizer2D.bottomX;
            width -= i3;
            dst_height += i3;
            dst_width += i3;
        }
        if (width > 0 && height > 0) {
            this.render_transparent(src_pos, width, Rasterizer2D.pixels, this.pixels, dst_height, height, dst_width, alpha, dst_pos);
        }
    }

    public void draw_transparent(int x, int y, int alpha) {
        int dst_pos = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int src_pos = 0;
        int height = this.height;
        int width = this.width;
        int dst_width = Rasterizer2D.width - width;
        int dst_height = 0;
        if (y < Rasterizer2D.topY) {
            int size = Rasterizer2D.topY - y;
            height -= size;
            y = Rasterizer2D.topY;
            src_pos += size * width;
            dst_pos += size * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - x;
            width -= l2;
            x = Rasterizer2D.topX;
            src_pos += l2;
            dst_pos += l2;
            dst_height += l2;
            dst_width += l2;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int i3 = x + width - Rasterizer2D.bottomX;
            width -= i3;
            dst_height += i3;
            dst_width += i3;
        }
        if (width > 0 && height > 0) {
            this.render_transparent(src_pos, width, Rasterizer2D.pixels, this.pixels, dst_height, height, dst_width, alpha, dst_pos);
        }
    }

    public void set_transparent_pixels(int r, int g, int b) {
        for (int index = 0; index < this.pixels.length; ++index) {
            if ((this.pixels[index] >> 16 & 0xFF) != r || (this.pixels[index] >> 8 & 0xFF) != g || (this.pixels[index] & 0xFF) != b) continue;
            this.pixels[index] = 0;
        }
    }

    public void init() {
        Rasterizer2D.init(this.pixels, this.width, this.height, depth_buffer);
    }

    public void blend(int red, int green, int blue) {
        for (int index = 0; index < this.pixels.length; ++index) {
            int color = this.pixels[index];
            if (color == 0) continue;
            int r = color >> 16 & 0xFF;
            if ((r += red) < 1) {
                r = 1;
            } else if (r > 255) {
                r = 255;
            }
            int g = color >> 8 & 0xFF;
            if ((g += green) < 1) {
                g = 1;
            } else if (g > 255) {
                g = 255;
            }
            int b = color & 0xFF;
            if ((b += blue) < 1) {
                b = 1;
            } else if (b > 255) {
                b = 255;
            }
            this.pixels[index] = (r << 16) + (g << 8) + b;
        }
    }

    public void trim() {
        int[] pixels = new int[this.max_width * this.max_height];
        for (int y = 0; y < this.height; ++y) {
            System.arraycopy(this.pixels, y * this.width, pixels, y + this.y_offset * this.max_width + this.x_offset, this.width);
        }
        this.pixels = pixels;
        this.width = this.max_width;
        this.height = this.max_height;
        this.x_offset = 0;
        this.y_offset = 0;
    }

    public void draw_inverse(int x, int y) {
        int size;
        int dst_pos = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int src_pos = 0;
        int height = this.height;
        int width = this.width;
        int dst_width = Rasterizer2D.width - width;
        int src_width = 0;
        if (y < Rasterizer2D.topY) {
            size = Rasterizer2D.topY - y;
            height -= size;
            y = Rasterizer2D.topY;
            src_pos += size * width;
            dst_pos += size * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.topX) {
            size = Rasterizer2D.topX - x;
            width -= size;
            x = Rasterizer2D.topX;
            src_pos += size;
            dst_pos += size;
            src_width += size;
            dst_width += size;
        }
        if (x + width > Rasterizer2D.bottomX) {
            size = x + width - Rasterizer2D.bottomX;
            width -= size;
            src_width += size;
            dst_width += size;
        }
        if (width > 0 && height > 0) {
            this.copy(dst_pos, width, height, src_width, src_pos, dst_width, this.pixels, Rasterizer2D.pixels);
        }
    }

    private void copy(int dst_pos, int width, int height, int src_width, int src_pos, int dst_width, int[] src, int[] pixels) {
        int length = -(width >> 2);
        width = -(width & 3);
        for (int column = -height; column < 0; ++column) {
            for (int row = length; row < 0; ++row) {
                pixels[dst_pos++] = src[src_pos++];
                pixels[dst_pos++] = src[src_pos++];
                pixels[dst_pos++] = src[src_pos++];
                pixels[dst_pos++] = src[src_pos++];
            }
            for (int step = width; step < 0; ++step) {
                pixels[dst_pos++] = src[src_pos++];
            }
            dst_pos += dst_width;
            src_pos += src_width;
        }
    }

    public void drawSprite1(int i, int j) {
        this.drawSprite1(i, j, 128);
    }

    public void drawSprite1(int i, int j, int k, boolean overrideCanvas) {
        this.drawX = i += this.x_offset;
        this.drawY = j += this.y_offset;
        int i1 = i + j * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (!(overrideCanvas && j > 0 || j >= Rasterizer2D.topY)) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (!overrideCanvas && i < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - i;
            l1 -= l2;
            i = Rasterizer2D.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.render_transparent(j1, l1, Rasterizer2D.pixels, this.pixels, j2, k1, i2, k, i1);
        }
    }

    public void drawShadedSpriteWithoutBounds(int i, int j, int k, boolean overrideCanvas) {
        int i1 = (i += this.x_offset) + (j += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (!(overrideCanvas && j > 0 || j >= Rasterizer2D.topY)) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (!overrideCanvas && i < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - i;
            l1 -= l2;
            i = Rasterizer2D.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.renderShadedARGBPixelsWithoutBounds(j1, l1, Rasterizer2D.pixels, this.pixels, j2, k1, i2, k, i1);
        }
        this.drawTransparentSpriteWithoutBounds(i, j, k, overrideCanvas);
    }

    private void renderShadedARGBPixelsWithoutBounds(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int j2 = 256 - k1;
        for (int k2 = -i1; k2 < 0; ++k2) {
            for (int l2 = -j; l2 < 0; ++l2) {
                int k;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    ai[l1++] = 0;
                    continue;
                }
                ++l1;
            }
            l1 += j1;
            i += l;
        }
    }

    public void drawTransparentSpriteWithoutBounds(int i, int j, int k, boolean overrideCanvas) {
        int i1 = (i += this.x_offset) + (j += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (!(overrideCanvas && j > 0 || j >= Rasterizer2D.topY)) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (!overrideCanvas && i < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - i;
            l1 -= l2;
            i = Rasterizer2D.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.render_transparent(j1, l1, Rasterizer2D.pixels, this.pixels, j2, k1, i2, k, i1);
        }
    }

    public void drawSpriteWithOutline(int i, int k, int color, boolean overrideCanvas) {
        int y;
        int x;
        int tempWidth = this.width + 2;
        int tempHeight = this.height + 2;
        int[] tempArray = new int[tempWidth * tempHeight];
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (this.pixels[x + y * this.width] == 0) continue;
                tempArray[x + 1 + (y + 1) * tempWidth] = this.pixels[x + y * this.width];
            }
        }
        for (x = 0; x < tempWidth; ++x) {
            for (y = 0; y < tempHeight; ++y) {
                if (tempArray[x + y * tempWidth] != 0) continue;
                if (x < tempWidth - 1 && tempArray[x + 1 + y * tempWidth] != 0 && tempArray[x + 1 + y * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (x != 0 && tempArray[x - 1 + y * tempWidth] != 0 && tempArray[x - 1 + y * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (y < tempHeight - 1 && tempArray[x + (y + 1) * tempWidth] != 0 && tempArray[x + (y + 1) * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (y == 0 || tempArray[x + (y - 1) * tempWidth] == 0 || tempArray[x + (y - 1) * tempWidth] == 0xFFFFFF) continue;
                tempArray[x + y * tempWidth] = color;
            }
        }
        --i;
        --k;
        int l = (i += this.x_offset) + (k += this.y_offset) * Rasterizer2D.width;
        int i1 = 0;
        int j1 = tempHeight;
        int k1 = tempWidth;
        int l1 = Rasterizer2D.width - k1;
        int i2 = 0;
        if (!(overrideCanvas && k > 0 || k >= Rasterizer2D.topY)) {
            int j2 = Rasterizer2D.topY - k;
            j1 -= j2;
            k = Rasterizer2D.topY;
            i1 += j2 * k1;
            l += j2 * Rasterizer2D.width;
        }
        if (k + j1 > Rasterizer2D.bottomY) {
            j1 -= k + j1 - Rasterizer2D.bottomY;
        }
        if (!overrideCanvas && i < Rasterizer2D.topX) {
            int k2 = Rasterizer2D.topX - i;
            k1 -= k2;
            i = Rasterizer2D.topX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (!overrideCanvas && i + k1 > Rasterizer2D.bottomX) {
            int l2 = i + k1 - Rasterizer2D.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.render(Rasterizer2D.pixels, tempArray, i1, l, k1, j1, l1, i2);
        }
    }

    public void draw_highlighted(int x, int y, int color) {
        int size;
        int highlight_width = this.width + 2;
        int highlight_height = this.height + 2;
        int[] pixels = new int[highlight_width * highlight_height];
        for (int _x = 0; _x < this.width; ++_x) {
            for (int _y = 0; _y < this.height; ++_y) {
                if (this.pixels[_x + _y * this.width] == 0) continue;
                pixels[_x + 1 + (_y + 1) * highlight_width] = this.pixels[_x + _y * this.width];
            }
        }
        for (int x_ = 0; x_ < highlight_width; ++x_) {
            for (int y_ = 0; y_ < highlight_height; ++y_) {
                if (pixels[x_ + y_ * highlight_width] != 0) continue;
                if (x_ < highlight_width - 1 && pixels[x_ + 1 + y_ * highlight_width] != 0 && pixels[x_ + 1 + y_ * highlight_width] != 0xFFFFFF) {
                    pixels[x_ + y_ * highlight_width] = color;
                }
                if (x_ != 0 && pixels[x_ - 1 + y_ * highlight_width] != 0 && pixels[x_ - 1 + y_ * highlight_width] != 0xFFFFFF) {
                    pixels[x_ + y_ * highlight_width] = color;
                }
                if (y_ < highlight_height - 1 && pixels[x_ + (y_ + 1) * highlight_width] != 0 && pixels[x_ + (y_ + 1) * highlight_width] != 0xFFFFFF) {
                    pixels[x_ + y_ * highlight_width] = color;
                }
                if (y_ == 0 || pixels[x_ + (y_ - 1) * highlight_width] == 0 || pixels[x_ + (y_ - 1) * highlight_width] == 0xFFFFFF) continue;
                pixels[x_ + y_ * highlight_width] = color;
            }
        }
        --x;
        --y;
        int dst_pos = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int src_pos = 0;
        int height = highlight_height;
        int width = highlight_width;
        int dst_width = Rasterizer2D.width - width;
        int src_width = 0;
        if (y < Rasterizer2D.topY) {
            size = Rasterizer2D.topY - y;
            height -= size;
            y = Rasterizer2D.topY;
            src_pos += size * width;
            dst_pos += size * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.topX) {
            size = Rasterizer2D.topX - x;
            width -= size;
            x = Rasterizer2D.topX;
            src_pos += size;
            dst_pos += size;
            src_width += size;
            dst_width += size;
        }
        if (x + width > Rasterizer2D.bottomX) {
            size = x + width - Rasterizer2D.bottomX;
            width -= size;
            src_width += size;
            dst_width += size;
        }
        if (width > 0 && height > 0) {
            this.render(Rasterizer2D.pixels, pixels, src_pos, dst_pos, width, height, dst_width, src_width);
        }
    }

    public void drawSprite1(int i, int j, int k) {
        int i1 = (i += this.x_offset) + (j += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (j < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - i;
            l1 -= l2;
            i = Rasterizer2D.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.render_transparent(j1, l1, Rasterizer2D.pixels, this.pixels, j2, k1, i2, k, i1);
        }
    }

    public void drawSprite(int x, int y) {
        int dx;
        this.drawX = x += this.x_offset;
        this.drawY = y += this.y_offset;
        int rasterClip = x + y * Rasterizer2D.width;
        int imageClip = 0;
        int height = this.height;
        int width = this.width;
        int rasterOffset = Rasterizer2D.width - width;
        int imageOffset = 0;
        if (y < Rasterizer2D.topY) {
            int dy = Rasterizer2D.topY - y;
            height -= dy;
            y = Rasterizer2D.topY;
            imageClip += dy * width;
            rasterClip += dy * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.topX) {
            dx = Rasterizer2D.topX - x;
            width -= dx;
            x = Rasterizer2D.topX;
            imageClip += dx;
            rasterClip += dx;
            imageOffset += dx;
            rasterOffset += dx;
        }
        if (x + width > Rasterizer2D.bottomX) {
            dx = x + width - Rasterizer2D.bottomX;
            width -= dx;
            imageOffset += dx;
            rasterOffset += dx;
        }
        if (width > 0 && height > 0) {
            this.render(Rasterizer2D.pixels, this.pixels, imageClip, rasterClip, width, height, rasterOffset, imageOffset);
        }
    }

    public void drawSprite(int i, int k, int color) {
        int y;
        int x;
        int tempWidth = this.width + 2;
        int tempHeight = this.height + 2;
        this.drawX = i;
        this.drawY = k;
        int[] tempArray = new int[tempWidth * tempHeight];
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (this.pixels[x + y * this.width] == 0) continue;
                tempArray[x + 1 + (y + 1) * tempWidth] = this.pixels[x + y * this.width];
            }
        }
        for (x = 0; x < tempWidth; ++x) {
            for (y = 0; y < tempHeight; ++y) {
                if (tempArray[x + y * tempWidth] != 0) continue;
                if (x < tempWidth - 1 && tempArray[x + 1 + y * tempWidth] > 0 && tempArray[x + 1 + y * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (x > 0 && tempArray[x - 1 + y * tempWidth] > 0 && tempArray[x - 1 + y * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (y < tempHeight - 1 && tempArray[x + (y + 1) * tempWidth] > 0 && tempArray[x + (y + 1) * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (y <= 0 || tempArray[x + (y - 1) * tempWidth] <= 0 || tempArray[x + (y - 1) * tempWidth] == 0xFFFFFF) continue;
                tempArray[x + y * tempWidth] = color;
            }
        }
        --i;
        --k;
        int l = (i += this.x_offset) + (k += this.y_offset) * Rasterizer2D.width;
        int i1 = 0;
        int j1 = tempHeight;
        int k1 = tempWidth;
        int l1 = Rasterizer2D.width - k1;
        int i2 = 0;
        if (k < Rasterizer2D.topY) {
            int j2 = Rasterizer2D.topY - k;
            j1 -= j2;
            k = Rasterizer2D.topY;
            i1 += j2 * k1;
            l += j2 * Rasterizer2D.width;
        }
        if (k + j1 > Rasterizer2D.bottomY) {
            j1 -= k + j1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.topX) {
            int k2 = Rasterizer2D.topX - i;
            k1 -= k2;
            i = Rasterizer2D.topX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > Rasterizer2D.bottomX) {
            int l2 = i + k1 - Rasterizer2D.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.render(Rasterizer2D.pixels, tempArray, i1, l, k1, j1, l1, i2);
        }
    }

    private void render(int[] pixels, int[] src, int src_pos, int dst_pos, int width, int height, int dst_width, int src_width) {
        int length = -(width >> 2);
        width = -(width & 3);
        for (int column = -height; column < 0; ++column) {
            int index;
            for (int row = length; row < 0; ++row) {
                if ((index = src[src_pos++]) != 0 && index != -1) {
                    pixels[dst_pos++] = index;
                } else {
                    ++dst_pos;
                }
                index = src[src_pos++];
                if (index != 0 && index != -1) {
                    pixels[dst_pos++] = index;
                } else {
                    ++dst_pos;
                }
                index = src[src_pos++];
                if (index != 0 && index != -1) {
                    pixels[dst_pos++] = index;
                } else {
                    ++dst_pos;
                }
                index = src[src_pos++];
                if (index != 0 && index != -1) {
                    pixels[dst_pos++] = index;
                    continue;
                }
                ++dst_pos;
            }
            for (int step = width; step < 0; ++step) {
                if ((index = src[src_pos++]) != 0 && index != -1) {
                    pixels[dst_pos++] = index;
                    continue;
                }
                ++dst_pos;
            }
            dst_pos += dst_width;
            src_pos += src_width;
        }
    }

    private void render_transparent(int src_pos, int width, int[] pixels, int[] raster, int src_width, int height, int dst_width, int alpha, int dst_pos) {
        int opacity = 256 - alpha;
        for (int column = -height; column < 0; ++column) {
            for (int row = -width; row < 0; ++row) {
                int color;
                if ((color = raster[src_pos++]) != 0) {
                    int src = pixels[dst_pos];
                    pixels[dst_pos++] = ((color & 0xFF00FF) * alpha + (src & 0xFF00FF) * opacity & 0xFF00FF00) + ((color & 0xFF00) * alpha + (src & 0xFF00) * opacity & 0xFF0000) >> 8;
                    continue;
                }
                ++dst_pos;
            }
            dst_pos += dst_width;
            src_pos += src_width;
        }
    }

    public void rotate_raster(int height, int rotation, int[] dst_width, int hinge_size, int[] raster_height, int centerY, int y, int x, int width, int centerX) {
        try {
            int location_x = -width / 2;
            int location_y = -height / 2;
            int sin = (int)(Math.sin((double)rotation / 326.11) * 65536.0);
            int cos = (int)(Math.cos((double)rotation / 326.11) * 65536.0);
            sin = sin * hinge_size >> 8;
            cos = cos * hinge_size >> 8;
            int rot_x = (centerX << 16) + (location_y * sin + location_x * cos);
            int rot_b = (centerY << 16) + (location_y * cos - location_x * sin);
            int dst_pos = x + y * Rasterizer2D.width;
            for (y = 0; y < height; ++y) {
                int step = raster_height[y];
                int index = dst_pos + step;
                int a = rot_x + cos * step;
                int b = rot_b - sin * step;
                for (x = -dst_width[y]; x < 0; ++x) {
                    int top = this.pixels[(a >> 16) + (b >> 16) * this.width];
                    int right = this.pixels[(a >> 16) + 1 + (b >> 16) * this.width];
                    int left = this.pixels[(a >> 16) + ((b >> 16) + 1) * this.width];
                    int bottom = this.pixels[(a >> 16) + 1 + ((b >> 16) + 1) * this.width];
                    int u1 = (a >> 8) - (a >> 16 << 8);
                    int v1 = (b >> 8) - (b >> 16 << 8);
                    int u2 = ((a >> 16) + 1 << 8) - (a >> 8);
                    int v2 = ((b >> 16) + 1 << 8) - (b >> 8);
                    int top_a = u2 * v2;
                    int right_a = u1 * v2;
                    int left_a = u2 * v1;
                    int bottom_a = u1 * v1;
                    int red = (top >> 16 & 0xFF) * top_a + (right >> 16 & 0xFF) * right_a + (left >> 16 & 0xFF) * left_a + (bottom >> 16 & 0xFF) * bottom_a & 0xFF0000;
                    int green = (top >> 8 & 0xFF) * top_a + (right >> 8 & 0xFF) * right_a + (left >> 8 & 0xFF) * left_a + (bottom >> 8 & 0xFF) * bottom_a >> 8 & 0xFF00;
                    int blue = (top & 0xFF) * top_a + (right & 0xFF) * right_a + (left & 0xFF) * left_a + (bottom & 0xFF) * bottom_a >> 16;
                    Rasterizer2D.pixels[index++] = red | green | blue;
                    a += cos;
                    b -= sin;
                }
                rot_x += sin;
                rot_b += cos;
                dst_pos += Rasterizer2D.width;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public SimpleImage(byte[] data) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(data);
            ImageIcon sprite = new ImageIcon(image);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.pixels = new int[this.width * this.height];
            PixelGrabber grab = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            grab.grabPixels();
            image = null;
            this.set_transparent_pixels(255, 0, 255);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public SimpleImage(int width, int height, int offsetX, int offsetY, int[] pixels) {
        this.width = width;
        this.height = height;
        this.x_offset = offsetX;
        this.y_offset = offsetY;
        this.pixels = pixels;
        Color color = Color.MAGENTA;
        this.set_transparent_pixels(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Image create(byte[] spriteData) {
        return Toolkit.getDefaultToolkit().createImage(spriteData);
    }

    public void drawAdvancedSprite(int xPos, int yPos) {
        this.drawAdvancedSprite(xPos, yPos, 256);
    }

    public void drawAdvancedSprite(int xPos, int yPos, int alpha) {
        int alphaValue = alpha;
        this.drawX = xPos;
        this.drawY = yPos;
        int i1 = (xPos += this.x_offset) + (yPos += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int spriteHeight = this.height;
        int spriteWidth = this.width;
        int i2 = Rasterizer2D.width - spriteWidth;
        int j2 = 0;
        if (yPos < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - yPos;
            spriteHeight -= k2;
            yPos = Rasterizer2D.topY;
            j1 += k2 * spriteWidth;
            i1 += k2 * Rasterizer2D.width;
        }
        if (yPos + spriteHeight > Rasterizer2D.bottomY) {
            spriteHeight -= yPos + spriteHeight - Rasterizer2D.bottomY;
        }
        if (xPos < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - xPos;
            spriteWidth -= l2;
            xPos = Rasterizer2D.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + spriteWidth > Rasterizer2D.bottomX) {
            int i3 = xPos + spriteWidth - Rasterizer2D.bottomX;
            spriteWidth -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            this.renderARGBPixels(spriteWidth, spriteHeight, this.pixels, Rasterizer2D.pixels, i1, alphaValue, j1, j2, i2);
        }
    }

    public void drawShadedSprite(int xPos, int yPos, int shade) {
        int shadeValue = shade;
        int i1 = (xPos += this.x_offset) + (yPos += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int spriteHeight = this.height;
        int spriteWidth = this.width;
        int i2 = Rasterizer2D.width - spriteWidth;
        int j2 = 0;
        if (yPos < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - yPos;
            spriteHeight -= k2;
            yPos = Rasterizer2D.topY;
            j1 += k2 * spriteWidth;
            i1 += k2 * Rasterizer2D.width;
        }
        if (yPos + spriteHeight > Rasterizer2D.bottomY) {
            spriteHeight -= yPos + spriteHeight - Rasterizer2D.bottomY;
        }
        if (xPos < Rasterizer2D.topX) {
            int l2 = Rasterizer2D.topX - xPos;
            spriteWidth -= l2;
            xPos = Rasterizer2D.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + spriteWidth > Rasterizer2D.bottomX) {
            int i3 = xPos + spriteWidth - Rasterizer2D.bottomX;
            spriteWidth -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            this.renderShadedARGBPixels(spriteWidth, spriteHeight, this.pixels, Rasterizer2D.pixels, i1, shadeValue, j1, j2, i2);
        }
        this.drawAdvancedSprite(xPos, yPos, shade);
    }

    private void renderShadedARGBPixels(int spriteWidth, int spriteHeight, int[] spritePixels, int[] renderAreaPixels, int pixel, int alphaValue, int i, int l, int j1) {
        int alpha = alphaValue;
        for (int height = -spriteHeight; height < 0; ++height) {
            for (int width = -spriteWidth; width < 0; ++width) {
                int pixelColor;
                alphaValue = this.pixels[i] >> 24 & alpha - 1;
                int alphaLevel = 256 - alphaValue;
                if (alphaLevel > 256) {
                    alphaValue = 0;
                }
                if (alpha == 0) {
                    alphaLevel = 256;
                    alphaValue = 0;
                }
                if ((pixelColor = spritePixels[i++]) != 0) {
                    int pixelValue = renderAreaPixels[pixel];
                    renderAreaPixels[pixel++] = 0;
                    continue;
                }
                ++pixel;
            }
            pixel += j1;
            i += l;
        }
    }

    private void renderARGBPixels(int spriteWidth, int spriteHeight, int[] spritePixels, int[] renderAreaPixels, int pixel, int alphaValue, int i, int l, int j1) {
        int alpha = alphaValue;
        for (int height = -spriteHeight; height < 0; ++height) {
            for (int width = -spriteWidth; width < 0; ++width) {
                int pixelColor;
                alphaValue = this.pixels[i] >> 24 & alpha - 1;
                int alphaLevel = 256 - alphaValue;
                if (alphaLevel > 256) {
                    alphaValue = 0;
                }
                if (alpha == 0) {
                    alphaLevel = 256;
                    alphaValue = 0;
                }
                if ((pixelColor = spritePixels[i++]) != 0) {
                    int pixelValue = renderAreaPixels[pixel];
                    renderAreaPixels[pixel++] = ((pixelColor & 0xFF00FF) * alphaValue + (pixelValue & 0xFF00FF) * alphaLevel & 0xFF00FF00) + ((pixelColor & 0xFF00) * alphaValue + (pixelValue & 0xFF00) * alphaLevel & 0xFF0000) >> 8;
                    continue;
                }
                ++pixel;
            }
            pixel += j1;
            i += l;
        }
    }

    public void highlight(int color) {
        int[] pixels = new int[this.width * this.height];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int src = this.pixels[index];
                if (src == 0) {
                    if (x > 0 && this.pixels[index - 1] != 0) {
                        src = color;
                    } else if (y > 0 && this.pixels[index - this.width] != 0) {
                        src = color;
                    } else if (x < this.width - 1 && this.pixels[index + 1] != 0) {
                        src = color;
                    } else if (y < this.height - 1 && this.pixels[index + this.width] != 0) {
                        src = color;
                    }
                }
                pixels[index++] = src;
            }
        }
        this.pixels = pixels;
    }

    public void shadow(int color) {
        for (int y = this.height - 1; y > 0; --y) {
            int pos = y * this.width;
            for (int x = this.width - 1; x > 0; --x) {
                if (this.pixels[x + pos] != 0 || this.pixels[x + pos - 1 - this.width] == 0) continue;
                this.pixels[x + pos] = color;
            }
        }
    }

    public Image convertToImage() {
        BufferedImage bufferedimage = new BufferedImage(this.width, this.height, 1);
        bufferedimage.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB = Color.BLACK.getRGB() | 0xFF000000;

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(bufferedimage.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }
}

