/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.graphics;

import com.ornate.cache.graphics.SimpleImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import javax.imageio.ImageIO;

public final class SpriteCache
implements Closeable {
    public static SimpleImage[] cache;
    private FileChannel dataChannel;
    private FileChannel metaChannel;

    public void init(File dataFile, File metaFile) throws IOException {
        if (!dataFile.exists()) {
            throw new IOException(String.format("Could not find data file=%s", dataFile.getName()));
        }
        if (!metaFile.exists()) {
            throw new IOException(String.format("Could not find meta file=%s", metaFile.getName()));
        }
        this.dataChannel = FileChannel.open(dataFile.toPath(), StandardOpenOption.READ);
        this.metaChannel = FileChannel.open(metaFile.toPath(), StandardOpenOption.READ);
        int spriteCount = (int)(this.metaChannel.size() / 10L);
        cache = new SimpleImage[spriteCount];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SimpleImage get(int id) {
        try {
            if (this.contains(id)) {
                return cache[id];
            }
            if (!this.dataChannel.isOpen() || !this.metaChannel.isOpen()) {
                System.err.println("Sprite channels are closed!");
                return null;
            }
            int entries = (int)(this.metaChannel.size() / 10L);
            if (id > entries) {
                System.err.printf("id=%d > size=%d%n", id, entries);
                return null;
            }
            this.metaChannel.position((long)id * 10L);
            ByteBuffer metaBuf = ByteBuffer.allocate(10);
            this.metaChannel.read(metaBuf);
            metaBuf.flip();
            int pos = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int len = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int offsetX = metaBuf.getShort() & 0xFF;
            int offsetY = metaBuf.getShort() & 0xFF;
            ByteBuffer dataBuf = ByteBuffer.allocate(len);
            this.dataChannel.position(pos);
            this.dataChannel.read(dataBuf);
            dataBuf.flip();
            try (ByteArrayInputStream is = new ByteArrayInputStream(dataBuf.array());){
                SimpleImage sprite;
                BufferedImage bimage = ImageIO.read(is);
                if (bimage == null) {
                    System.err.printf("Could not read image at %d%n", id);
                    SimpleImage simpleImage = null;
                    return simpleImage;
                }
                if (bimage.getType() != 2) {
                    bimage = SpriteCache.convert(bimage);
                }
                int[] pixels = ((DataBufferInt)bimage.getRaster().getDataBuffer()).getData();
                SpriteCache.cache[id] = sprite = new SimpleImage(bimage.getWidth(), bimage.getHeight(), offsetX, offsetY, pixels);
                SimpleImage simpleImage = sprite;
                return simpleImage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.printf("No sprite found for id=%d%n", id);
            return null;
        }
    }

    public void draw(int id, int x, int y) {
        this.draw(id, x, y, false);
    }

    public void draw(int id, int x, int y, int alpha, boolean advanced) {
        SimpleImage sprite = this.get(id);
        if (sprite != null) {
            if (advanced) {
                sprite.drawAdvancedSprite(x, y, alpha);
            } else {
                sprite.drawSprite(x, y, alpha);
            }
        }
    }

    public void draw(int id, int x, int y, boolean advanced) {
        SimpleImage sprite = this.get(id);
        if (sprite != null) {
            if (advanced) {
                sprite.drawAdvancedSprite(x, y);
            } else {
                sprite.drawSprite(x, y);
            }
        }
    }

    public boolean contains(int id) {
        return id < cache.length && cache[id] != null;
    }

    public void set(int id, SimpleImage sprite) {
        if (!this.contains(id)) {
            return;
        }
        SpriteCache.cache[id] = sprite;
    }

    public void clear() {
        Arrays.fill(cache, null);
    }

    private static BufferedImage convert(BufferedImage bimage) {
        BufferedImage converted = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
        converted.getGraphics().drawImage(bimage, 0, 0, null);
        return converted;
    }

    @Override
    public void close() throws IOException {
        if (this.dataChannel != null) {
            this.dataChannel.close();
        }
        if (this.metaChannel != null) {
            this.metaChannel.close();
        }
    }
}

