/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.graphics.fading_screen;

import com.ornate.cache.graphics.fading_screen.FadingScreen;
import com.ornate.cache.graphics.font.AdvancedFont;
import com.ornate.draw.Rasterizer2D;

public class BlackFadingScreen
extends FadingScreen {
    private final int width;
    private final int height;

    public BlackFadingScreen(AdvancedFont font, String text, byte state, byte seconds, int x, int y, int width, int height, int characterWrap) {
        super(font, text, state, seconds, x, y, characterWrap);
        this.width = width;
        this.height = height;
    }

    @Override
    public void draw() {
        if (this.state == 0) {
            return;
        }
        long end = this.watch.getStartTime() + 1000L * (long)this.seconds;
        long increment = (end - this.watch.getStartTime()) / 100L;
        if (increment > 0L) {
            long percentile = this.watch.getTime() / increment;
            int opacity = (int)(percentile * 1L * 2L);
            if (this.state < 0) {
                opacity = 255 - opacity;
            }
            if (percentile > -1L && percentile <= 100L) {
                Rasterizer2D.set_clip(this.x, this.y, this.x + this.width, this.y + this.height);
                Rasterizer2D.drawAlphaBox(this.x, this.y, this.width, this.height, 0, opacity);
                if (percentile > 0L && this.state == 1 || percentile < 100L && this.state == -1) {
                    int textYOffset = 0;
                    for (String sentence : this.wrapped) {
                        this.font.draw_centered(sentence, this.x + this.width / 2, this.y + this.height / 4 + textYOffset, 0xFFFFFF, 0, opacity);
                        textYOffset += 20;
                    }
                } else if (percentile == 100L) {
                    this.watch.stop();
                    this.state = 0;
                }
            }
        }
    }
}

