/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.graphics.font;

import com.ornate.Client;
import com.ornate.cache.Archive;
import com.ornate.cache.graphics.SimpleImage;
import com.ornate.draw.Rasterizer2D;
import com.ornate.io.Buffer;
import java.awt.Color;
import java.util.ArrayList;

public class AdvancedFont
extends Rasterizer2D {
    public double pcOpacity;
    public boolean maxOpacity;
    public int base_char_height = 0;
    public int anInt4142;
    public int anInt4144;
    public int[] kerning_y;
    public int[] glyph_height;
    public int[] kerning_x;
    public int[] glyph_width;
    public byte[] byte_unknown;
    public byte[][] glyph_pixels = new byte[256][];
    public int[] glyph_display_width;
    public static SimpleImage[] chat_emblems;
    public static SimpleImage[] clan_emblems;
    public static String nbsp_string;
    public static String set_transparency;
    public static String set_default_shadow;
    public static String close_shadow;
    public static String gt_string;
    public static String close_strikethrough;
    public static String euro_string;
    public static String set_color;
    public static String line_break;
    public static String set_strikethrough;
    public static String close_color;
    public static String set_image;
    public static String set_clan;
    public static String close_underline;
    public static String set_default_strikethrough;
    public static String set_shadow;
    public static String lt_string;
    public static String shy_string;
    public static String copy_string;
    public static String close_transparency;
    public static String times_string;
    public static String set_underline;
    public static String set_default_underline;
    public static String reg_string;
    public static int default_color;
    public static int shadow_color;
    public static int strikethrough_color;
    public static int default_trans;
    public static int anInt4175;
    public static int underline_color;
    public static int default_shad;
    public static int anInt4178;
    public static int opacity;
    public static int font_color;

    public AdvancedFont(boolean monospace, String name, Archive archive) {
        this.glyph_width = new int[256];
        this.glyph_height = new int[256];
        this.kerning_x = new int[256];
        this.kerning_y = new int[256];
        this.glyph_display_width = new int[256];
        Buffer data = new Buffer(archive.get(name + ".dat"));
        Buffer idx = new Buffer(archive.get("index.dat"));
        idx.pos = data.readUShort() + 4;
        int pos = idx.readUByte();
        if (pos > 0) {
            idx.pos += 3 * (pos - 1);
        }
        for (int index = 0; index < 256; ++index) {
            int y;
            int pixels;
            this.kerning_x[index] = idx.readUByte();
            this.kerning_y[index] = idx.readUByte();
            int width = this.glyph_width[index] = idx.readUShort();
            int height = this.glyph_height[index] = idx.readUShort();
            int opcode = idx.readUByte();
            int area = width * height;
            this.glyph_pixels[index] = new byte[area];
            if (opcode == 0) {
                for (pixels = 0; pixels < area; ++pixels) {
                    this.glyph_pixels[index][pixels] = data.readSignedByte();
                }
            } else if (opcode == 1) {
                for (int x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        this.glyph_pixels[index][x + y * width] = data.readSignedByte();
                    }
                }
            }
            if (height > this.base_char_height && index < 128) {
                this.base_char_height = height;
            }
            this.kerning_x[index] = 1;
            this.glyph_display_width[index] = width + 2;
            pixels = 0;
            for (y = height / 7; y < height; ++y) {
                pixels += this.glyph_pixels[index][y * width];
            }
            if (pixels <= height / 7) {
                int n = index;
                this.glyph_display_width[n] = this.glyph_display_width[n] - 1;
                this.kerning_x[index] = 0;
            }
            pixels = 0;
            for (y = height / 7; y < height; ++y) {
                pixels += this.glyph_pixels[index][width - 1 + y * width];
            }
            if (pixels > height / 7) continue;
            int n = index;
            this.glyph_display_width[n] = this.glyph_display_width[n] - 1;
        }
        this.glyph_display_width[32] = monospace ? this.glyph_display_width[73] : this.glyph_display_width[105];
    }

    public static void init_sprites(SimpleImage[] chat, SimpleImage[] clan, SimpleImage[] tag) {
        chat_emblems = chat;
        clan_emblems = clan;
    }

    public int get_glyph_width(int index) {
        return this.glyph_display_width[index & 0xFF];
    }

    public void set_defaults(int color, int shadow) {
        strikethrough_color = -1;
        underline_color = -1;
        shadow_color = default_shad = shadow;
        font_color = default_color = color;
        default_trans = 256;
        opacity = 256;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    public void set_defaults(int shadow, int color, int trans) {
        shadow_color = default_shad = shadow;
        font_color = default_color = color;
        opacity = default_trans = trans;
    }

    public void set_adv_defaults(int color, int shadow, int trans) {
        strikethrough_color = -1;
        underline_color = -1;
        shadow_color = default_shad = shadow;
        font_color = default_color = color;
        opacity = default_trans = trans;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    public String[] wrap(String text, int maximumWidth) {
        String[] words = text.split(" ");
        if (words.length == 0) {
            return new String[]{text};
        }
        ArrayList<String> lines = new ArrayList<String>();
        String line = new String();
        int lineWidth = 0;
        int spaceWidth = this.get_width(" ");
        for (String word : words) {
            if (word.isEmpty()) continue;
            int wordWidth = this.get_width(word);
            boolean isLastWord = word.equals(words[words.length - 1]);
            if (wordWidth + lineWidth >= maximumWidth && !isLastWord) {
                lines.add(line.trim());
                line = new String(word.concat(" "));
                lineWidth = wordWidth + spaceWidth;
                continue;
            }
            if (isLastWord) {
                if (wordWidth + lineWidth > maximumWidth) {
                    lines.add(line.trim());
                    lines.add(word);
                    continue;
                }
                lines.add(line.concat(word));
                continue;
            }
            line = line.concat(word).concat(" ");
            lineWidth += wordWidth + spaceWidth;
        }
        return lines.toArray(new String[lines.size()]);
    }

    public void draw_centered(String string, int width, int height) {
        if (string != null) {
            this.draw(string, width - this.get_width(string) / 2, height);
        }
    }

    public void drawRAString(String string, int x, int y, int color, int shadow) {
        if (string != null) {
            this.set_defaults(color, shadow);
            this.draw(string, x - this.get_width(string), y);
        }
    }

    public void draw(String string, int x, int y) {
        y -= this.base_char_height;
        int index = -1;
        int unknown = -1;
        for (int current = 0; current < string.length(); ++current) {
            if (string.charAt(current) == '@' && current + 4 < string.length() && string.charAt(current + 4) == '@') {
                int rgb = this.get_color(string.substring(current + 1, current + 4));
                if (rgb != -1) {
                    font_color = rgb;
                }
                current += 4;
                continue;
            }
            int character = string.charAt(current);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                index = current;
                continue;
            }
            if (character == 62 && index != -1) {
                String effect = string.substring(index + 1, current);
                index = -1;
                if (effect.equals(lt_string)) {
                    character = 60;
                } else if (effect.equals(gt_string)) {
                    character = 62;
                } else if (effect.equals(nbsp_string)) {
                    character = 160;
                } else if (effect.equals(shy_string)) {
                    character = 173;
                } else if (effect.equals(times_string)) {
                    character = 215;
                } else if (effect.equals(euro_string)) {
                    character = 128;
                } else if (effect.equals(copy_string)) {
                    character = 169;
                } else if (effect.equals(reg_string)) {
                    character = 174;
                } else {
                    int height_offset;
                    if (effect.startsWith(set_image)) {
                        try {
                            int id = Integer.parseInt(effect.substring(4));
                            SimpleImage icon = null;
                            if (id != -1) {
                                icon = Client.spriteCache.get(id);
                            }
                            if (icon == null) {
                                return;
                            }
                            height_offset = icon.height;
                            if (opacity == 256) {
                                icon.drawSprite(x, y + this.base_char_height - height_offset);
                            } else {
                                icon.draw_highlighted(x, y + this.base_char_height - height_offset, opacity);
                            }
                            x += icon.width;
                            unknown = -1;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    if (effect.startsWith(set_clan)) {
                        try {
                            int id = Integer.parseInt(effect.substring(5));
                            SimpleImage icon = null;
                            if (id != -1) {
                                icon = Client.spriteCache.get(id);
                            }
                            if (icon == null) {
                                return;
                            }
                            height_offset = icon.height + icon.y_offset + 1;
                            if (opacity == 256) {
                                icon.drawSprite(x, y + this.base_char_height - height_offset);
                            } else {
                                icon.draw_highlighted(x, y + this.base_char_height - height_offset, opacity);
                            }
                            x += 11;
                            unknown = -1;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    this.set_effects(effect);
                    continue;
                }
            }
            if (index != -1) continue;
            if (this.byte_unknown != null && unknown != -1) {
                x += this.byte_unknown[(unknown << 8) + character];
            }
            int width = this.glyph_width[character];
            int height = this.glyph_height[character];
            if (character != 32) {
                if (opacity == 256) {
                    if (shadow_color != -1) {
                        this.draw_glyph(character, x + this.kerning_x[character] + 1, y + this.kerning_y[character] + 1, width, height, shadow_color, true);
                    }
                    this.draw_glyph(character, x + this.kerning_x[character], y + this.kerning_y[character], width, height, font_color, false);
                } else {
                    if (shadow_color != -1) {
                        this.draw_transparent_glyph(character, x + this.kerning_x[character] + 1, y + this.kerning_y[character] + 1, width, height, shadow_color, opacity, true);
                    }
                    this.draw_transparent_glyph(character, x + this.kerning_x[character], y + this.kerning_y[character], width, height, font_color, opacity, false);
                }
            } else if (anInt4178 > 0) {
                x += (anInt4175 += anInt4178) >> 8;
                anInt4175 &= 0xFF;
            }
            int final_width = this.glyph_display_width[character];
            if (strikethrough_color != -1) {
                AdvancedFont.draw_line(y + (int)((double)this.base_char_height * 0.7), strikethrough_color, final_width, x);
            }
            if (underline_color != -1) {
                AdvancedFont.draw_line(y + this.base_char_height, underline_color, final_width, x);
            }
            x += final_width;
            unknown = character;
        }
    }

    public void draw_shake(String string, int x, int y, int color, int shadow, int cycle, int tick) {
        if (string != null) {
            this.set_defaults(color, shadow);
            double amp = 7.0 - (double)tick / 8.0;
            if (amp < 0.0) {
                amp = 0.0;
            }
            int[] glyph_y = new int[string.length()];
            for (int index = 0; index < string.length(); ++index) {
                glyph_y[index] = (int)(Math.sin((double)index / 1.5 + (double)cycle) * amp);
            }
            this.draw_translated(string, x - this.get_width(string) / 2, y, null, glyph_y);
        }
    }

    public void draw_wave(String string, int x, int y, int color, int shadow, int cycle) {
        if (string != null) {
            this.set_defaults(color, shadow);
            int[] glyph_x = new int[string.length()];
            int[] glyph_y = new int[string.length()];
            for (int index = 0; index < string.length(); ++index) {
                glyph_x[index] = (int)(Math.sin((double)index / 5.0 + (double)cycle / 5.0) * 5.0);
                glyph_y[index] = (int)(Math.sin((double)index / 3.0 + (double)cycle / 5.0) * 5.0);
            }
            this.draw_translated(string, x - this.get_width(string) / 2, y, glyph_x, glyph_y);
        }
    }

    public void draw_wave2(String string, int x, int y, int color, int shadow, int cycle) {
        if (string != null) {
            this.set_defaults(color, shadow);
            int[] glyph_y = new int[string.length()];
            for (int index = 0; index < string.length(); ++index) {
                glyph_y[index] = (int)(Math.sin((double)index / 2.0 + (double)cycle / 5.0) * 5.0);
            }
            this.draw_translated(string, x - this.get_width(string) / 2, y, null, glyph_y);
        }
    }

    public void draw_translated(String string, int x, int y, int[] x_translate, int[] y_translate) {
        y -= this.base_char_height;
        int index = -1;
        int unknown = -1;
        int translate_offset = 0;
        for (int current = 0; current < string.length(); ++current) {
            int character = string.charAt(current);
            if (character == 60) {
                index = current;
                continue;
            }
            if (character == 62 && index != -1) {
                String effect = string.substring(index + 1, current);
                index = -1;
                if (effect.equals(lt_string)) {
                    character = 60;
                } else if (effect.equals(gt_string)) {
                    character = 62;
                } else if (effect.equals(nbsp_string)) {
                    character = 160;
                } else if (effect.equals(shy_string)) {
                    character = 173;
                } else if (effect.equals(times_string)) {
                    character = 215;
                } else if (effect.equals(euro_string)) {
                    character = 128;
                } else if (effect.equals(copy_string)) {
                    character = 169;
                } else if (effect.equals(reg_string)) {
                    character = 174;
                } else {
                    if (effect.startsWith(set_image)) {
                        try {
                            int x_translate_offset = x_translate != null ? x_translate[translate_offset] : 0;
                            int y_translate_offset = y_translate != null ? y_translate[translate_offset] : 0;
                            ++translate_offset;
                            int id = Integer.parseInt(effect.substring(4));
                            SimpleImage chat = chat_emblems[id];
                            int icon_offset_y = chat.height;
                            if (opacity == 256) {
                                chat.drawSprite(x + x_translate_offset, y + this.base_char_height - icon_offset_y + y_translate_offset);
                            } else {
                                chat.draw_highlighted(x + x_translate_offset, y + this.base_char_height - icon_offset_y + y_translate_offset, opacity);
                            }
                            x += chat.width;
                            unknown = -1;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    this.set_effects(effect);
                    continue;
                }
            }
            if (index != -1) continue;
            if (this.byte_unknown != null && unknown != -1) {
                x += this.byte_unknown[(unknown << 8) + character];
            }
            int width = this.glyph_width[character];
            int height = this.glyph_height[character];
            int x_translate_offset = x_translate != null ? x_translate[translate_offset] : 0;
            int y_translate_offset = y_translate != null ? y_translate[translate_offset] : 0;
            ++translate_offset;
            if (character != 32) {
                if (opacity == 256) {
                    if (shadow_color != -1) {
                        this.draw_glyph(character, x + this.kerning_x[character] + 1 + x_translate_offset, y + this.kerning_y[character] + 1 + y_translate_offset, width, height, shadow_color, true);
                    }
                    this.draw_glyph(character, x + this.kerning_x[character] + x_translate_offset, y + this.kerning_y[character] + y_translate_offset, width, height, font_color, false);
                } else {
                    if (shadow_color != -1) {
                        this.draw_transparent_glyph(character, x + this.kerning_x[character] + 1 + x_translate_offset, y + this.kerning_y[character] + 1 + y_translate_offset, width, height, shadow_color, opacity, true);
                    }
                    this.draw_transparent_glyph(character, x + this.kerning_x[character] + x_translate_offset, y + this.kerning_y[character] + y_translate_offset, width, height, font_color, opacity, false);
                }
            } else if (anInt4178 > 0) {
                x += (anInt4175 += anInt4178) >> 8;
                anInt4175 &= 0xFF;
            }
            int final_width = this.glyph_display_width[character];
            if (strikethrough_color != -1) {
                AdvancedFont.draw_line(y + (int)((double)this.base_char_height * 0.7), strikethrough_color, final_width, x);
            }
            if (underline_color != -1) {
                AdvancedFont.draw_line(y + this.base_char_height, underline_color, final_width, x);
            }
            x += final_width;
            unknown = character;
        }
    }

    public void set_effects(String string) {
        try {
            if (string.startsWith(set_color)) {
                String color = string.substring(4);
                font_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(close_color)) {
                font_color = default_color;
            } else if (string.startsWith(set_transparency)) {
                opacity = Integer.valueOf(string.substring(6));
            } else if (string.equals(close_transparency)) {
                opacity = default_trans;
            } else if (string.startsWith(set_strikethrough)) {
                String color = string.substring(4);
                strikethrough_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(set_default_strikethrough)) {
                strikethrough_color = 0x800000;
            } else if (string.equals(close_strikethrough)) {
                strikethrough_color = -1;
            } else if (string.startsWith(set_underline)) {
                String color = string.substring(2);
                underline_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(set_default_underline)) {
                underline_color = 0;
            } else if (string.equals(close_underline)) {
                underline_color = -1;
            } else if (string.startsWith(set_shadow)) {
                String color = string.substring(5);
                shadow_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(set_default_shadow)) {
                shadow_color = 0;
            } else if (string.equals(close_shadow)) {
                shadow_color = default_shad;
            } else if (string.equals(line_break)) {
                this.set_adv_defaults(default_color, default_shad, default_trans);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int get_width(String string) {
        if (string == null) {
            return 0;
        }
        int startIndex = -1;
        int unknown = -1;
        int final_width = 0;
        for (int current = 0; current < string.length(); ++current) {
            int character = string.charAt(current);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                startIndex = current;
                continue;
            }
            if (character == 62 && startIndex != -1) {
                String effect = string.substring(startIndex + 1, current);
                startIndex = -1;
                if (effect.equals(lt_string)) {
                    character = 60;
                } else if (effect.equals(gt_string)) {
                    character = 62;
                } else if (effect.equals(nbsp_string)) {
                    character = 160;
                } else if (effect.equals(shy_string)) {
                    character = 173;
                } else if (effect.equals(times_string)) {
                    character = 215;
                } else if (effect.equals(euro_string)) {
                    character = 128;
                } else if (effect.equals(copy_string)) {
                    character = 169;
                } else if (effect.equals(reg_string)) {
                    character = 174;
                } else {
                    if (!effect.startsWith(set_image)) continue;
                    try {
                        int id = Integer.parseInt(effect.substring(4));
                        if (chat_emblems != null && chat_emblems[id] != null) {
                            final_width += AdvancedFont.chat_emblems[id].width;
                        } else if (Client.spriteCache.get(id) != null) {
                            final_width += Client.spriteCache.get((int)id).width;
                        }
                        unknown = -1;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
            }
            if (startIndex != -1) continue;
            final_width += this.glyph_display_width[character];
            if (this.byte_unknown != null && unknown != -1) {
                final_width += this.byte_unknown[(unknown << 8) + character];
            }
            unknown = character;
        }
        return final_width;
    }

    public void draw(String string, int x, int y, int color, boolean shadow) {
        if (string != null) {
            int shad_color = !shadow ? -1 : 0;
            this.set_defaults(color, shad_color);
            this.draw(string, x, y);
        }
    }

    public void draw_centered(String string, int x, int y, int color, boolean shadow) {
        if (string != null) {
            int shad_color = !shadow ? -1 : 0;
            this.set_defaults(color, shad_color);
            this.draw(string, x - this.get_width(string) / 2, y);
        }
    }

    public void draw(String string, int x, int y, int color, int shadow) {
        if (string != null) {
            this.set_defaults(color, shadow);
            this.draw(string, x, y);
        }
    }

    public void draw_centered(String string, int x, int y, int color, int shadow) {
        if (string != null) {
            this.set_defaults(color, shadow);
            this.draw(string, x - this.get_width(string) / 2, y);
        }
    }

    public void draw(String string, int x, int y, int color, int shadow, int trans) {
        if (string != null) {
            this.set_defaults(color, shadow);
            opacity = default_trans = trans;
            this.draw(string, x, y);
        }
    }

    public void draw_centered(String s, int x, int y, int col, int shad, int trans) {
        if (s != null) {
            this.set_defaults(col, shad);
            opacity = default_trans = trans;
            this.draw(s, x - this.get_width(s) / 2, y);
        }
    }

    public void drawGlowingString(String string, int x, int y, int color, int startOpacity, double speed) {
        if (this.pcOpacity < (double)startOpacity) {
            this.pcOpacity = startOpacity;
            this.maxOpacity = false;
        }
        if (this.pcOpacity > 255.0) {
            this.pcOpacity = 255.0;
            this.maxOpacity = true;
        }
        if (this.pcOpacity >= (double)startOpacity && !this.maxOpacity) {
            this.pcOpacity += speed;
            if (this.pcOpacity == 255.0) {
                this.maxOpacity = true;
            }
        }
        if (this.pcOpacity <= 255.0 && this.maxOpacity) {
            this.pcOpacity -= speed;
            if (this.pcOpacity == (double)startOpacity) {
                this.maxOpacity = false;
            }
        }
        this.setTransLeaveShadow((int)this.pcOpacity);
        this.draw_centered(string, x + 19, y, color, false);
    }

    public void setTransLeaveShadow(int alpha) {
        opacity = default_trans = alpha;
    }

    public void draw_left(String string, int x, int color, int y, int trans, int shadow) {
        if (string != null) {
            this.set_defaults(color, shadow);
            opacity = default_trans = trans;
            this.draw(string, x - this.get_glyph_length(string), y);
        }
    }

    public int get_glyph_length(String string) {
        if (string == null) {
            return 0;
        }
        int length = 0;
        for (int index = 0; index < string.length(); ++index) {
            length += this.glyph_display_width[string.charAt(index)];
        }
        return length;
    }

    public void draw_glyph(int glyph, int x, int y, int width, int height, int color, boolean bool) {
        int size;
        int dst_pos = x + y * Rasterizer2D.width;
        int dst_width = Rasterizer2D.width - width;
        int src_width = 0;
        int src_pos = 0;
        if (y < Rasterizer2D.topY) {
            size = Rasterizer2D.topY - y;
            height -= size;
            y = Rasterizer2D.topY;
            src_pos += size * width;
            dst_pos += size * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.topX) {
            size = Rasterizer2D.topX - x;
            width -= size;
            x = Rasterizer2D.topX;
            src_pos += size;
            dst_pos += size;
            src_width += size;
            dst_width += size;
        }
        if (x + width > Rasterizer2D.bottomX) {
            size = x + width - Rasterizer2D.bottomX;
            width -= size;
            src_width += size;
            dst_width += size;
        }
        if (width > 0 && height > 0) {
            AdvancedFont.render(Rasterizer2D.pixels, this.glyph_pixels[glyph], color, src_pos, dst_pos, width, height, dst_width, src_width);
        }
    }

    public void draw_transparent_glyph(int glyph, int x, int y, int width, int height, int color, int alpha, boolean bool) {
        int size;
        int dst_pos = x + y * Rasterizer2D.width;
        int dst_width = Rasterizer2D.width - width;
        int src_width = 0;
        int src_pos = 0;
        if (y < Rasterizer2D.topY) {
            size = Rasterizer2D.topY - y;
            height -= size;
            y = Rasterizer2D.topY;
            src_pos += size * width;
            dst_pos += size * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.topX) {
            size = Rasterizer2D.topX - x;
            width -= size;
            x = Rasterizer2D.topX;
            src_pos += size;
            dst_pos += size;
            src_width += size;
            dst_width += size;
        }
        if (x + width > Rasterizer2D.bottomX) {
            size = x + width - Rasterizer2D.bottomX;
            width -= size;
            src_width += size;
            dst_width += size;
        }
        if (width > 0 && height > 0) {
            AdvancedFont.render_transparent(Rasterizer2D.pixels, this.glyph_pixels[glyph], color, src_pos, dst_pos, width, height, dst_width, src_width, alpha);
        }
    }

    public static void render(int[] pixels, byte[] glyph_pixels, int color, int src_pos, int dst_pos, int width, int height, int dst_width, int src_width) {
        int length = -(width >> 2);
        width = -(width & 3);
        for (int column = -height; column < 0; ++column) {
            for (int row = length; row < 0; ++row) {
                if (glyph_pixels[src_pos++] != 0) {
                    pixels[dst_pos++] = color;
                } else {
                    ++dst_pos;
                }
                if (glyph_pixels[src_pos++] != 0) {
                    pixels[dst_pos++] = color;
                } else {
                    ++dst_pos;
                }
                if (glyph_pixels[src_pos++] != 0) {
                    pixels[dst_pos++] = color;
                } else {
                    ++dst_pos;
                }
                if (glyph_pixels[src_pos++] != 0) {
                    pixels[dst_pos++] = color;
                    continue;
                }
                ++dst_pos;
            }
            for (int index = width; index < 0; ++index) {
                if (glyph_pixels[src_pos++] != 0) {
                    pixels[dst_pos++] = color;
                    continue;
                }
                ++dst_pos;
            }
            dst_pos += dst_width;
            src_pos += src_width;
        }
    }

    public static void render_transparent(int[] pixels, byte[] glyph_pixels, int color, int src_pos, int dst_pos, int width, int height, int dst_width, int src_width, int alpha) {
        color = ((color & 0xFF00FF) * alpha & 0xFF00FF00) + ((color & 0xFF00) * alpha & 0xFF0000) >> 8;
        alpha = 256 - alpha;
        for (int column = -height; column < 0; ++column) {
            for (int row = -width; row < 0; ++row) {
                if (glyph_pixels[src_pos++] != 0) {
                    int src = pixels[dst_pos];
                    pixels[dst_pos++] = (((src & 0xFF00FF) * alpha & 0xFF00FF00) + ((src & 0xFF00) * alpha & 0xFF0000) >> 8) + color;
                    continue;
                }
                ++dst_pos;
            }
            dst_pos += dst_width;
            src_pos += src_width;
        }
    }

    public int get_color(String s) {
        switch (s) {
            case "red": {
                return 0xFF0000;
            }
            case "gre": {
                return 65280;
            }
            case "blu": {
                return 255;
            }
            case "yel": {
                return 0xFFFF00;
            }
            case "cya": {
                return 65535;
            }
            case "mag": {
                return 0xFF00FF;
            }
            case "whi": {
                return 0xFFFFFF;
            }
            case "bla": {
                return 0;
            }
            case "lre": {
                return 16748608;
            }
            case "dre": {
                return 0x800000;
            }
            case "dbl": {
                return 128;
            }
            case "or1": {
                return 0xFFB000;
            }
            case "or2": {
                return 0xFF7000;
            }
            case "or3": {
                return 0xFF3000;
            }
            case "gr1": {
                return 0xC0FF00;
            }
            case "gr2": {
                return 0x80FF00;
            }
            case "gr3": {
                return 0x40FF00;
            }
        }
        return -1;
    }

    public static void release() {
        lt_string = null;
        gt_string = null;
        nbsp_string = null;
        shy_string = null;
        times_string = null;
        euro_string = null;
        copy_string = null;
        reg_string = null;
        set_image = null;
        line_break = null;
        set_color = null;
        close_color = null;
        set_transparency = null;
        close_transparency = null;
        set_underline = null;
        set_default_underline = null;
        close_underline = null;
        set_shadow = null;
        set_default_shadow = null;
        close_shadow = null;
        set_strikethrough = null;
        set_default_strikethrough = null;
        close_strikethrough = null;
    }

    static {
        set_transparency = "trans=";
        set_strikethrough = "str=";
        set_default_shadow = "shad";
        set_color = "col=";
        line_break = "br";
        set_default_strikethrough = "str";
        close_underline = "/u";
        set_image = "img=";
        set_clan = "clan=";
        set_shadow = "shad=";
        set_underline = "u=";
        close_color = "/col";
        set_default_underline = "u";
        close_transparency = "/trans";
        nbsp_string = "nbsp";
        reg_string = "reg";
        times_string = "times";
        shy_string = "shy";
        copy_string = "copy";
        gt_string = "gt";
        euro_string = "euro";
        lt_string = "lt";
        default_trans = 256;
        default_shad = -1;
        anInt4175 = 0;
        shadow_color = -1;
        font_color = 0;
        default_color = 0;
        strikethrough_color = -1;
        underline_color = -1;
        anInt4178 = 0;
        opacity = 256;
        close_shadow = "/shad";
        close_strikethrough = "/str";
    }
}

