/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.graphics.widget;

import com.ornate.cache.graphics.widget.Widget;

public abstract class InterfaceBuilder
extends Widget {
    private final int baseInterfaceId;
    private final Widget root;
    private int nextChildId;
    private int nextInterfaceId;

    public abstract void build();

    public InterfaceBuilder(int baseInterfaceId) {
        this.baseInterfaceId = baseInterfaceId;
        this.root = Widget.addInterface(baseInterfaceId);
        this.root.totalChildren(0);
        this.init();
    }

    public void init() {
        this.nextChildId = 0;
        this.nextInterfaceId = this.baseInterfaceId + 1;
    }

    public void child(int x, int y) {
        this.root.child(this.nextChild(), this.nextInterfaceId - 1, x, y);
    }

    @Override
    public void child(int interfaceId, int x, int y) {
        this.root.child(this.nextChild(), interfaceId, x, y);
    }

    public int getBaseInterfaceId() {
        return this.baseInterfaceId;
    }

    public int nextChild() {
        Widget.expandChildren(1, this.root);
        return this.nextChildId++;
    }

    public int lastInterface() {
        return this.nextInterfaceId - 1;
    }

    public int nextInterface() {
        return this.nextInterfaceId++;
    }

    public int getCurrentInterfaceId() {
        return this.nextInterfaceId;
    }

    public void setNextInterfaceId(int nextInterfaceId) {
        this.nextInterfaceId = nextInterfaceId;
    }

    public Widget getLastChild() {
        return Widget.get(this.nextInterfaceId - 1);
    }

    public Widget getRoot() {
        return this.root;
    }
}

