/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.graphics.widget;

import com.ornate.cache.anim.Sequence;
import com.ornate.cache.def.NpcDefinition;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PetSystem {
    private final int[] modelArray;
    private final int modelArrayLength;
    private final int primaryModel;
    private final String name;
    private final String description;
    private static int animation;
    private static int animationDelay;
    public static int animationFrame;
    public static boolean updatePetAnimations;
    public static boolean isPetAnimationRunning;
    public static int petSelected;

    public PetSystem(NpcDefinition entity) {
        this.modelArray = entity.modelId;
        this.modelArrayLength = entity.modelId.length;
        this.primaryModel = entity.modelId[0];
        this.name = entity.name;
        this.description = entity.description;
        animation = entity.walkingAnimation;
        animationDelay = Sequence.cache[PetSystem.animation].primary_frame[animationFrame];
    }

    public static void petAnimationStep() {
        if (updatePetAnimations) {
            return;
        }
        if (++animationFrame >= Sequence.cache[PetSystem.animation].primary_frame.length) {
            animationFrame = 0;
        }
    }

    public static void updateAnimations() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(() -> {
            isPetAnimationRunning = true;
            PetSystem.petAnimationStep();
        }, 0L, animationDelay == 0 ? 100L : (long)animationDelay * 100L, TimeUnit.MILLISECONDS);
    }

    public int getAnimationDelay() {
        return animationDelay;
    }

    public int getPrimaryModel() {
        return this.primaryModel;
    }

    public int getAnimation() {
        return animation;
    }

    public String getName() {
        return this.name;
    }

    public int getAnimationFrame() {
        return animationFrame;
    }

    public String getDescription() {
        return this.description;
    }

    public int getModelArrayLength() {
        return this.modelArrayLength;
    }

    public int[] getModelArray() {
        return this.modelArray;
    }

    public int getPetSelected() {
        return petSelected;
    }

    public void setPetSelected(int petID) {
        petSelected = petID;
    }

    static {
        updatePetAnimations = false;
        isPetAnimationRunning = false;
        petSelected = 239;
    }
}

