/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.cache.graphics.widget;

import com.google.common.base.Preconditions;
import com.ornate.Client;
import com.ornate.cache.Archive;
import com.ornate.cache.anim.Animation;
import com.ornate.cache.def.ItemDefinition;
import com.ornate.cache.def.NpcDefinition;
import com.ornate.cache.graphics.SimpleImage;
import com.ornate.cache.graphics.dropdown.Dropdown;
import com.ornate.cache.graphics.dropdown.DropdownMenu;
import com.ornate.cache.graphics.font.AdvancedFont;
import com.ornate.cache.graphics.widget.CombinationRunes;
import com.ornate.cache.graphics.widget.Interfaces;
import com.ornate.cache.graphics.widget.Slider;
import com.ornate.collection.ReferenceCache;
import com.ornate.entity.model.Model;
import com.ornate.io.Buffer;
import com.ornate.util.StringUtils;
import com.ornate.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Widget {
    public static final int DEFAULT_TEXT_COLOR = 0xFF9933;
    public static final int GREEN_COLOR = 3650836;
    public static final int YELLOW_COLOR = 0xFFFF00;
    public static final int WHITE_COLOR = 0xFFFFFF;
    public static final int RED_COLOR = 0xE11010;
    public static final int OPTION_OK = 1;
    public static final int OPTION_USABLE = 2;
    public static final int OPTION_CLOSE = 3;
    public static final int OPTION_TOGGLE_SETTING = 4;
    public static final int OPTION_RESET_SETTING = 5;
    public static final int OPTION_CONTINUE = 6;
    public static final int OPTION_DROPDOWN = 7;
    public static final int TYPE_CONTAINER = 0;
    public static final int TYPE_MODEL_LIST = 1;
    public static final int TYPE_INVENTORY = 2;
    public static final int TYPE_RECTANGLE = 3;
    public static final int TYPE_TEXT = 4;
    public static final int TYPE_SPRITE = 5;
    public static final int TYPE_MODEL = 6;
    public static final int TYPE_ITEM_LIST = 7;
    public static final int TYPE_OTHER = 8;
    public static final int TYPE_HOVER = 9;
    public static final int TYPE_CONFIG = 10;
    public static final int TYPE_CONFIG_HOVER = 11;
    public static final int TYPE_SLIDER = 12;
    public static final int TYPE_DROPDOWN = 13;
    public static final int TYPE_ROTATING = 14;
    public static final int TYPE_KEYBINDS_DROPDOWN = 15;
    public static final int TYPE_INPUT_FIELD = 16;
    public static final int TYPE_ADJUSTABLE_CONFIG = 17;
    public static final int TYPE_BOX = 18;
    public static final int CLICKABLE_SPRITES = 20;
    public static final int TYPE_SPELL_SPRITE = 21;
    public static final int DARKEN = 22;
    public static final int OUTLINE = 23;
    public static final int LINE = 24;
    public static final int TYPE_CONFIG_BUTTON_HOVERED_SPRITE_OUTLINE = 25;
    public static final int COLOR = 26;
    public static final int DRAW_LINE = 27;
    public static final int TYPE_RADIO_BUTTON = 28;
    public static final int OPTION_MENU = 29;
    public boolean hide;
    public boolean isHidden;
    public static Archive interfaceLoader;
    public Widget dropdownOpen;
    public static Widget[] cache;
    public SimpleImage textSpriteClicked;
    public SimpleImage spriteWithOutline;
    public SimpleImage enabledAltSprite;
    public SimpleImage disabledAltSprite;
    public SimpleImage disabledSprite;
    public SimpleImage enabledSprite;
    public SimpleImage disabledHover;
    public SimpleImage[] sprites;
    public SimpleImage spriteClicked;
    public DropdownMenu dropdown;
    public Slider slider;
    public AdvancedFont text_type;
    public static AdvancedFont[] fonts;
    private static ReferenceCache spriteCache;
    private static final ReferenceCache models;
    public byte opacity;
    public int[] buttonsToDisable;
    public int[] dropdownColours;
    public int[] itemOpacity;
    public int id;
    public int[] inventoryAmounts;
    public int[] inventoryItemId;
    public int dropdownHover = -1;
    public int transparency = 255;
    public int hoverXOffset = 0;
    public int hoverYOffset = 0;
    public int spriteXOffset = 0;
    public int spriteYOffset = 0;
    public int lastFrameTime;
    public int clickSprite1 = 0;
    public static int parentchilds;
    public static final int BEGIN_READING_PRAYER_INTERFACE = 6;
    public static final int CUSTOM_PRAYER_HOVERS = 3;
    public static final int PRAYER_INTERFACE_CHILDREN = 89;
    private static final int LUNAR_RUNE_SPRITES_START = 232;
    private static final int LUNAR_OFF_SPRITES_START = 246;
    private static final int LUNAR_ON_SPRITES_START = 285;
    private static final int LUNAR_HOVER_BOX_SPRITES_START = 324;
    public int modelType;
    public int modelFileId;
    public int itemId;
    static int achievementChild;
    static int achievementY;
    public int childToIntersect = 0;
    public int positionX;
    public int positionY;
    public int radioID = 0;
    public static ArrayList<Integer> radioButtons;
    public int clickSprite2 = 0;
    public static int currentInputFieldId;
    public int hoveredOutlineSpriteXOffset;
    public int hoveredOutlineSpriteYOffset;
    public int modelZoom;
    public int modelRotation1;
    public int modelRotation2;
    public int[] child_y;
    public int spriteOpacity;
    public int msgX;
    public int msgY;
    public int y;
    public int height;
    public int scrollMax;
    public int type;
    public int x;
    private int enabled_model_type;
    private int enabled_model_id;
    public int defaultAnimationId;
    public int secondaryAnimationId;
    public int secondaryHoverColor;
    public int[] children;
    public int[] child_x;
    public int inventoryMarginY;
    public int[] valueCompareType;
    public int currentFrame;
    public int[] inventoryOffsetY;
    public int hoverType;
    public int inventoryMarginX;
    public int textColour;
    public int opacity2;
    public int model_type;
    public int model_id;
    public int parent;
    public int selectedTargetMask;
    public int[] requiredValues;
    public int contentType;
    public int[] inventoryOffsetX;
    public int alpha;
    public int defaultHoverColor;
    public int optionType;
    public int secondaryColor;
    public int width;
    public int scrollPosition;
    public int[][] valueIndexArray;
    public int pauseTicks = 20;
    public int color;
    public int textClickedX;
    public int textClickedY;
    public int characterLimit;
    public int[] buttons;
    public boolean isClicked;
    public boolean hoverHasText;
    public boolean hoverScrollBar;
    public boolean isInFocus;
    public boolean displayAsterisks;
    public boolean updatesEveryInput;
    public boolean updateConfig = true;
    public boolean textIsClicked;
    public boolean endReached = false;
    public boolean inventoryHover;
    public boolean replaceItems;
    public boolean usableItems;
    public boolean hasActions;
    public boolean collection = false;
    public boolean displayAmount = true;
    public boolean displayExamine = true;
    public boolean allowSwapItems;
    public boolean invisible;
    public boolean drawingDisabled;
    public boolean textShadow;
    public boolean toggled = false;
    public boolean active;
    public boolean busy;
    public boolean hovered = false;
    public boolean inverted;
    public boolean isAchievementHover = false;
    public boolean isHovered = false;
    public boolean fullCint = false;
    public boolean drawNumber = false;
    public boolean geSearchButton = false;
    public boolean isRadioButton = false;
    public boolean filled;
    public boolean centerText;
    public boolean rightText;
    public boolean serverCheck = false;
    public boolean regularHoverBox;
    public boolean clickable = false;
    public boolean drawsTransparent;
    public boolean fancy = false;
    public boolean hightDetail;
    public boolean ignoreConfigClicking;
    public boolean smallInvSprites;
    public boolean hideInvStackSizes;
    public boolean forceInvStackSizes;
    public String hoverText;
    public String defaultInputFieldText = "";
    public String spellName;
    public String tooltip;
    public String selectedActionName;
    public String[] actions;
    public String defaultText;
    public String secondaryText;
    public String inputRegex = "";
    public int currentPercent;
    private static List<Integer> foundIDS;
    private static List<Integer> foundChildren;
    private int childCount = 0;
    public SimpleImage[] backgroundSprites;
    public String[] tooltips;
    public boolean newScroller;
    public boolean drawInfinity;
    public int[] spritesToDraw;
    public String[] textToDraw;
    public int spritesPerRow;
    public static int[] displayedTeleportSprites;
    public int fillColor;

    public void swapInventoryItems(int itemId, int itemAmount) {
        int id = this.inventoryItemId[itemId];
        this.inventoryItemId[itemId] = this.inventoryItemId[itemAmount];
        this.inventoryItemId[itemAmount] = id;
        id = this.inventoryAmounts[itemId];
        this.inventoryAmounts[itemId] = this.inventoryAmounts[itemAmount];
        this.inventoryAmounts[itemAmount] = id;
    }

    public static Widget get(int interfaceId) {
        Preconditions.checkArgument(interfaceId >= 0 && interfaceId < cache.length);
        Preconditions.checkArgument(cache[interfaceId] != null);
        return cache[interfaceId];
    }

    public static int expandChildren(int amount, Widget i) {
        int writeIndex = i.children == null ? 0 : i.children.length;
        int[] newChildren = new int[writeIndex + amount];
        int[] newChildX = new int[writeIndex + amount];
        int[] newChildY = new int[writeIndex + amount];
        if (i.children != null) {
            System.arraycopy(i.children, 0, newChildren, 0, i.children.length);
            System.arraycopy(i.child_x, 0, newChildX, 0, i.child_x.length);
            System.arraycopy(i.child_y, 0, newChildY, 0, i.child_y.length);
        }
        i.children = newChildren;
        i.child_x = newChildX;
        i.child_y = newChildY;
        return writeIndex;
    }

    public static void addToItemGroup(int id, int w, int h, int x, int y, boolean hasActions, boolean displayAmount, String[] actions) {
        Widget widget = Widget.addInterface(id);
        widget.width = w;
        widget.height = h;
        widget.inventoryItemId = new int[w * h];
        widget.inventoryAmounts = new int[w * h];
        widget.usableItems = false;
        widget.displayAmount = displayAmount;
        widget.inventoryMarginX = x;
        widget.inventoryMarginY = y;
        widget.inventoryOffsetX = new int[20];
        widget.inventoryOffsetY = new int[20];
        widget.sprites = new SimpleImage[20];
        if (hasActions) {
            widget.actions = actions;
        }
        widget.type = 2;
    }

    public void setHidden(boolean hide) {
        this.hide = hide;
    }

    private static void printDuplicates() {
        ArrayList ids = new ArrayList();
        for (int i2 = 0; i2 < cache.length; ++i2) {
            if (cache[i2] != null && Widget.cache[i2].id != 23995) continue;
        }
        ids.stream().filter(i -> Collections.frequency(ids, i) > 1).collect(Collectors.toSet()).forEach(System.out::println);
    }

    public static void load(Archive interfaces, AdvancedFont[] font, Archive graphics) {
        spriteCache = new ReferenceCache(50000);
        fonts = font;
        Buffer buffer = new Buffer(interfaces.get("data"));
        int defaultParentId = -1;
        buffer.readUShort();
        cache = new Widget[80000];
        while (buffer.pos < buffer.payload.length) {
            int index;
            int scripts;
            int interfaceId = buffer.readUShort();
            if (interfaceId == 65535) {
                defaultParentId = buffer.readUShort();
                interfaceId = buffer.readUShort();
            }
            Widget widget = Widget.cache[interfaceId] = new Widget();
            widget.id = interfaceId;
            widget.parent = defaultParentId;
            widget.type = buffer.readUByte();
            widget.optionType = buffer.readUByte();
            widget.contentType = buffer.readUShort();
            widget.width = buffer.readUShort();
            widget.height = buffer.readUShort();
            widget.opacity = (byte)buffer.readUByte();
            widget.hoverType = buffer.readUByte();
            widget.hoverType = widget.hoverType != 0 ? (widget.hoverType - 1 << 8) + buffer.readUByte() : -1;
            int operators = buffer.readUByte();
            if (operators > 0) {
                widget.valueCompareType = new int[operators];
                widget.requiredValues = new int[operators];
                for (int index2 = 0; index2 < operators; ++index2) {
                    widget.valueCompareType[index2] = buffer.readUByte();
                    widget.requiredValues[index2] = buffer.readUShort();
                }
            }
            if ((scripts = buffer.readUByte()) > 0) {
                widget.valueIndexArray = new int[scripts][];
                for (int script = 0; script < scripts; ++script) {
                    int instructions = buffer.readUShort();
                    widget.valueIndexArray[script] = new int[instructions];
                    for (int instruction = 0; instruction < instructions; ++instruction) {
                        widget.valueIndexArray[script][instruction] = buffer.readUShort();
                    }
                }
            }
            if (widget.type == 0) {
                widget.drawsTransparent = false;
                widget.scrollMax = buffer.readUShort();
                widget.invisible = buffer.readUByte() == 1;
                int length = buffer.readUShort();
                if (widget.id == 5608) {
                    widget.children = new int[89];
                    widget.child_x = new int[89];
                    widget.child_y = new int[89];
                    for (index = 0; index < length; ++index) {
                        widget.children[6 + index] = buffer.readUShort();
                        widget.child_x[6 + index] = buffer.readShort();
                        widget.child_y[6 + index] = buffer.readShort();
                    }
                } else {
                    widget.children = new int[length];
                    widget.child_x = new int[length];
                    widget.child_y = new int[length];
                    for (index = 0; index < length; ++index) {
                        widget.children[index] = buffer.readUShort();
                        widget.child_x[index] = buffer.readShort();
                        widget.child_y[index] = buffer.readShort();
                    }
                }
            }
            if (widget.type == 1) {
                buffer.readUShort();
                buffer.readUByte();
            }
            if (widget.type == 2) {
                widget.inventoryItemId = new int[widget.width * widget.height];
                widget.inventoryAmounts = new int[widget.width * widget.height];
                widget.itemOpacity = new int[widget.width * widget.height];
                widget.allowSwapItems = buffer.readUByte() == 1;
                widget.hasActions = buffer.readUByte() == 1;
                widget.usableItems = buffer.readUByte() == 1;
                widget.replaceItems = buffer.readUByte() == 1;
                widget.inventoryMarginX = buffer.readUByte();
                widget.inventoryMarginY = buffer.readUByte();
                widget.inventoryOffsetX = new int[20];
                widget.inventoryOffsetY = new int[20];
                widget.sprites = new SimpleImage[20];
                for (int j2 = 0; j2 < 20; ++j2) {
                    int k3 = buffer.readUByte();
                    if (k3 != 1) continue;
                    widget.inventoryOffsetX[j2] = buffer.readShort();
                    widget.inventoryOffsetY[j2] = buffer.readShort();
                    String s1 = buffer.readString();
                    if (graphics == null || s1.length() <= 0) continue;
                    int i5 = s1.lastIndexOf(",");
                    int index3 = Integer.parseInt(s1.substring(i5 + 1));
                    String name = s1.substring(0, i5);
                    widget.sprites[j2] = Widget.getSprite(index3, graphics, name);
                }
                widget.actions = new String[5];
                for (int actionIndex = 0; actionIndex < 5; ++actionIndex) {
                    widget.actions[actionIndex] = buffer.readString();
                    if (widget.actions[actionIndex].length() == 0) {
                        widget.actions[actionIndex] = null;
                    }
                    if (widget.parent == 1644) {
                        widget.actions[2] = "Operate";
                    }
                    if (widget.parent == 3824) {
                        widget.actions[4] = "Buy X";
                    }
                    if (widget.parent != 3822) continue;
                    widget.actions[4] = "Sell X";
                }
            }
            if (widget.type == 3) {
                boolean bl = widget.filled = buffer.readUByte() == 1;
            }
            if (widget.type == 4 || widget.type == 1) {
                widget.centerText = buffer.readUByte() == 1;
                int k2 = buffer.readUByte();
                if (font != null) {
                    widget.text_type = font[k2];
                }
                boolean bl = widget.textShadow = buffer.readUByte() == 1;
            }
            if (widget.type == 4) {
                widget.defaultText = buffer.readString().replaceAll("RuneScape", "Atlas");
                widget.secondaryText = buffer.readString();
            }
            if (widget.type == 1 || widget.type == 3 || widget.type == 4) {
                widget.textColour = buffer.readInt();
            }
            if (widget.type == 3 || widget.type == 4) {
                widget.secondaryColor = buffer.readInt();
                widget.defaultHoverColor = buffer.readInt();
                widget.secondaryHoverColor = buffer.readInt();
                if (widget.id == 15234) {
                    widget.secondaryColor = 65280;
                }
            }
            if (widget.type == 5) {
                widget.drawsTransparent = false;
                String name = buffer.readString();
                if (graphics != null && name.length() > 0) {
                    index = name.lastIndexOf(",");
                    widget.enabledSprite = Widget.getSprite(Integer.parseInt(name.substring(index + 1)), graphics, name.substring(0, index));
                }
                name = buffer.readString();
                if (graphics != null && name.length() > 0) {
                    index = name.lastIndexOf(",");
                    widget.disabledSprite = Widget.getSprite(Integer.parseInt(name.substring(index + 1)), graphics, name.substring(0, index));
                }
            }
            if (widget.type == 6) {
                int content = buffer.readUByte();
                if (content != 0) {
                    widget.model_type = 1;
                    widget.model_id = (content - 1 << 8) + buffer.readUByte();
                }
                if ((content = buffer.readUByte()) != 0) {
                    widget.enabled_model_type = 1;
                    widget.enabled_model_id = (content - 1 << 8) + buffer.readUByte();
                }
                widget.defaultAnimationId = (content = buffer.readUByte()) != 0 ? (content - 1 << 8) + buffer.readUByte() : -1;
                content = buffer.readUByte();
                widget.secondaryAnimationId = content != 0 ? (content - 1 << 8) + buffer.readUByte() : -1;
                widget.modelZoom = buffer.readUShort();
                widget.modelRotation1 = buffer.readUShort();
                widget.modelRotation2 = buffer.readUShort();
            }
            if (widget.type == 7) {
                widget.inventoryItemId = new int[widget.width * widget.height];
                widget.inventoryAmounts = new int[widget.width * widget.height];
                widget.centerText = buffer.readUByte() == 1;
                int l2 = buffer.readUByte();
                if (font != null) {
                    widget.text_type = font[l2];
                }
                widget.textShadow = buffer.readUByte() == 1;
                widget.textColour = buffer.readInt();
                widget.inventoryMarginX = buffer.readShort();
                widget.inventoryMarginY = buffer.readShort();
                widget.hasActions = buffer.readUByte() == 1;
                widget.actions = new String[5];
                for (int actionCount = 0; actionCount < 5; ++actionCount) {
                    widget.actions[actionCount] = buffer.readString();
                    if (widget.actions[actionCount].length() != 0) continue;
                    widget.actions[actionCount] = null;
                }
            }
            if (widget.optionType == 2 || widget.type == 2) {
                widget.selectedActionName = buffer.readString();
                widget.spellName = buffer.readString();
                widget.selectedTargetMask = buffer.readUShort();
            }
            if (widget.type == 8) {
                widget.defaultText = buffer.readString();
            }
            if (widget.optionType != 1 && widget.optionType != 4 && widget.optionType != 5 && widget.optionType != 6) continue;
            widget.tooltip = buffer.readString().replaceAll("Auto Retaliate", "Auto retaliate");
            if (widget.id == 24111 || widget.id == 349) {
                widget.tooltip = "Choose spell";
            }
            if (widget.tooltip.length() != 0) continue;
            if (widget.optionType == 1) {
                widget.tooltip = "Ok";
            }
            if (widget.optionType == 4) {
                widget.tooltip = "Select";
            }
            if (widget.optionType == 5) {
                widget.tooltip = "Select";
            }
            if (widget.optionType != 6) continue;
            widget.tooltip = "Continue";
        }
        interfaceLoader = interfaces;
        Interfaces.unpackAll(font);
        spriteCache = null;
    }

    public static void setSpriteClicked(int id, int spriteClickedId) {
        Widget.cache[id].spriteClicked = Widget.imageLoaderNew(spriteClickedId);
    }

    public static void hoverHasText(int id) {
        Widget.cache[id].hoverHasText = true;
    }

    public static void textClicked(int interfaceId, int spriteId, int xOffset, int yOffset) {
        Widget.cache[interfaceId].textSpriteClicked = Client.spriteCache.get(spriteId);
        Widget.cache[interfaceId].textClickedX = xOffset;
        Widget.cache[interfaceId].textClickedY = yOffset;
    }

    public static void createSkillHover(int id, int x, int width) {
        Widget hover = Widget.addInterface(id);
        hover.inventoryHover = true;
        hover.type = 8;
        hover.defaultText = "ct$" + x;
        hover.contentType = x;
        hover.width = width;
        hover.height = 32;
    }

    public static void createTooltip(int id, String text, int width, int height) {
        Widget widget = Widget.addInterface(id);
        widget.inventoryHover = true;
        widget.type = 8;
        widget.defaultText = text;
        widget.width = width;
        widget.height = height;
    }

    public static void drawProgressBar(int id, int width, int height, int currentPercent) {
        Widget rsi = Widget.addInterface(id);
        rsi.type = 287;
        rsi.width = width;
        rsi.height = height;
        rsi.currentPercent = currentPercent;
    }

    public static void addButtonWithoutSprite(int id, String tooltip, int height, int width) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.id = id;
        widget.parent = id;
        widget.type = 5;
        widget.optionType = 1;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = 52;
        widget.enabledSprite = null;
        widget.disabledSprite = null;
        widget.width = width;
        widget.height = height;
        widget.tooltip = tooltip;
    }

    public static void addSpellSprite(int id, int spriteId) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.id = id;
        widget.parent = id;
        widget.type = 21;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = 0;
        if (spriteId != -1) {
            widget.enabledSprite = Client.spriteCache.get(spriteId);
            widget.disabledSprite = Client.spriteCache.get(spriteId);
        }
        widget.width = 0;
        widget.height = 0;
    }

    public static void checkUnusedInterfaces() {
        int freeIdCount = 0;
        int longestRunCount = 0;
        int longestRunStart = -1;
        int curRunStart = 0;
        int curRunCount = 0;
        int sandwichId = -1;
        int lastId = 0;
        for (int i = 0; i < cache.length; ++i) {
            if (cache[i] == null) {
                ++freeIdCount;
                if (curRunStart == -1) {
                    curRunStart = i;
                }
                ++curRunCount;
                continue;
            }
            if (curRunCount == 1 && sandwichId < 0) {
                sandwichId = i - 1;
            }
            if (curRunCount > longestRunCount) {
                longestRunCount = curRunCount;
                longestRunStart = curRunStart;
            }
            curRunStart = -1;
            curRunCount = 0;
            lastId = i;
        }
        System.out.println(freeIdCount + " unused interface ids");
        System.out.println(longestRunStart + " onwards has " + longestRunCount + " unused interface ids in a row");
        System.out.println(sandwichId + " is a single unused interface id surrounded by used ones.");
        System.out.println(lastId + " is the last used interface, cache.length should be set to " + (lastId + 1));
        System.out.println(cache.length + " is the size of the interfaces array");
    }

    public static void closeButton(int id, int enabledSprite, int disabledSprite, boolean serverActionRequired) {
        Widget widget = Widget.addInterface(id);
        widget.optionType = serverActionRequired ? 1 : 3;
        widget.type = 9;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height;
        widget.toggled = false;
        widget.spriteOpacity = 255;
        widget.tooltip = "Close";
    }

    public static void closeButton(int id, int enabledSprite, int disabledSprite) {
        Widget.closeButton(id, enabledSprite, disabledSprite, false);
    }

    public static void hoverButton(int id, String tooltip, int enabledSprite, int disabledSprite, String buttonText, AdvancedFont[] font, int idx, int colour, int hoveredColour, boolean centerText) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 9;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height;
        widget.msgX = widget.width / 2;
        widget.msgY = widget.height / 2 + 4;
        widget.defaultText = buttonText;
        widget.toggled = false;
        widget.text_type = font[idx];
        widget.textColour = colour;
        widget.defaultHoverColor = hoveredColour;
        widget.centerText = centerText;
        widget.spriteOpacity = 255;
    }

    public static void hoverButton(int id, String tooltip, int enabledSprite, int disabledSprite, int opacity) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 9;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height;
        widget.toggled = false;
        widget.spriteOpacity = opacity;
    }

    public static void hoverButton(int id, String tooltip, int enabledSprite, int disabledSprite) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 9;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height;
        widget.toggled = false;
        widget.spriteOpacity = 255;
    }

    public static void hoverButton(int id, String tooltip, int enabledSprite, int disabledSprite, int width, int height) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 9;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = width;
        widget.height = height;
        widget.toggled = false;
        widget.spriteOpacity = 255;
    }

    public static void configButton(int id, String tooltip, int enabledSprite, int disabledSprite) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 10;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height;
        widget.active = false;
    }

    public static void addButton(int id, int parent, int width, int height, int config, int configFrame, int sprite1, int sprite2, int hoverOver, String tooltip) {
        Widget widget = Widget.addInterface(id);
        widget.parent = parent;
        widget.type = 5;
        widget.optionType = 1;
        widget.width = width;
        widget.height = height;
        widget.requiredValues = new int[1];
        widget.valueCompareType = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = config;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = configFrame;
        widget.valueIndexArray[0][2] = 0;
        widget.tooltip = tooltip;
        widget.defaultText = tooltip;
        widget.hoverType = hoverOver;
        widget.enabledSprite = Client.spriteCache.get(sprite1);
        widget.disabledSprite = Client.spriteCache.get(sprite2);
    }

    public static void addButton(int id, int parent, int width, int height, int sprite1, int sprite2, int hoverOver, String tooltip) {
        Widget widget = Widget.addInterface(id);
        widget.parent = parent;
        widget.type = 5;
        widget.optionType = 1;
        widget.width = width;
        widget.height = height;
        widget.tooltip = tooltip;
        widget.defaultText = tooltip;
        widget.hoverType = hoverOver;
        widget.enabledSprite = Client.spriteCache.get(sprite1);
        widget.disabledSprite = Client.spriteCache.get(sprite2);
    }

    public static void addButton(int id, int parent, int width, int height, SimpleImage sprite1, SimpleImage sprite2, int hoverOver, String tooltip) {
        Widget widget = Widget.addInterface(id);
        widget.parent = parent;
        widget.type = 5;
        widget.optionType = 1;
        widget.width = width;
        widget.height = height;
        widget.tooltip = tooltip;
        widget.defaultText = tooltip;
        widget.hoverType = hoverOver;
        widget.enabledSprite = sprite1;
        widget.disabledSprite = sprite2;
    }

    public static void addPrayer(int id, String tooltip, int width, int height, int glowSprite, int glowX, int glowY, int disabledSprite, int enabledSprite, int config, int configFrame, int hover) {
        Widget widget = Widget.addTabInterface(id);
        widget.parent = 5608;
        widget.type = 5;
        widget.optionType = 4;
        widget.width = width;
        widget.height = height;
        widget.requiredValues = new int[1];
        widget.valueCompareType = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = config;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = configFrame;
        widget.valueIndexArray[0][2] = 0;
        widget.tooltip = tooltip;
        widget.defaultText = tooltip;
        widget.hoverType = 52;
        widget.disabledSprite = Client.spriteCache.get(glowSprite);
        widget.spriteXOffset = glowX;
        widget.spriteYOffset = glowY;
        widget = Widget.addTabInterface(id + 1);
        widget.parent = 5608;
        widget.type = 5;
        widget.optionType = 0;
        widget.width = width;
        widget.height = height;
        widget.requiredValues = new int[1];
        widget.valueCompareType = new int[1];
        widget.valueCompareType[0] = 2;
        widget.requiredValues[0] = 1;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = configFrame + 1;
        widget.valueIndexArray[0][2] = 0;
        widget.tooltip = tooltip;
        widget.defaultText = tooltip;
        widget.disabledSprite = Client.spriteCache.get(disabledSprite);
        widget.enabledSprite = Client.spriteCache.get(enabledSprite);
        widget.hoverType = hover;
    }

    public static void addPrayer(int id, int configState, int configFrame, int requiredValues, int disabledSprite, int enabledSprite, String prayerName, int hover, int glowX, int glowY) {
        Widget widget = Widget.addTabInterface(id);
        widget.id = id;
        widget.parent = 22500;
        widget.type = 5;
        widget.optionType = 4;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = hover;
        widget.enabledSprite = Client.spriteCache.get(150);
        widget.width = 34;
        widget.height = 34;
        widget.spriteXOffset = glowX;
        widget.spriteYOffset = glowY;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = configState;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = configFrame;
        widget.valueIndexArray[0][2] = 0;
        widget.tooltip = "Activate <col=ffb000>" + prayerName;
        widget = Widget.addTabInterface(id + 1);
        widget.id = id + 1;
        widget.parent = 22500;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.disabledSprite = Client.spriteCache.get(disabledSprite);
        widget.enabledSprite = Client.spriteCache.get(enabledSprite);
        widget.width = 34;
        widget.height = 34;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 2;
        widget.requiredValues[0] = requiredValues + 1;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 2;
        widget.valueIndexArray[0][1] = 5;
        widget.valueIndexArray[0][2] = 0;
    }

    public static void addPrayer(int id, int configState, int configFrame, int requiredValues, int disabledSprite, int enabledSprite, String prayerName, int hover) {
        Widget widget = Widget.addTabInterface(id);
        widget.id = id;
        widget.parent = 22500;
        widget.type = 5;
        widget.optionType = 4;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = hover;
        widget.enabledSprite = Client.spriteCache.get(150);
        widget.width = 34;
        widget.height = 34;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = configState;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = configFrame;
        widget.valueIndexArray[0][2] = 0;
        widget.tooltip = "Activate <col=ffb000>" + prayerName;
        widget = Widget.addTabInterface(id + 1);
        widget.id = id + 1;
        widget.parent = 22500;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.disabledSprite = Client.spriteCache.get(disabledSprite);
        widget.enabledSprite = Client.spriteCache.get(enabledSprite);
        widget.width = 34;
        widget.height = 34;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 2;
        widget.requiredValues[0] = requiredValues + 1;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 2;
        widget.valueIndexArray[0][1] = 5;
        widget.valueIndexArray[0][2] = 0;
    }

    public static void addPrayerHover(int id, String hover, int xOffset, int yOffset) {
        Widget widget = Widget.addTabInterface(id);
        widget.parent = 5608;
        widget.type = 8;
        widget.width = 40;
        widget.height = 32;
        widget.hoverText = widget.defaultText = hover;
        widget.hoverXOffset = xOffset;
        widget.hoverYOffset = yOffset;
        widget.regularHoverBox = true;
    }

    public static void addSettingsSprite(int childId, int spriteId) {
        Widget widget = Widget.cache[childId] = new Widget();
        widget.id = childId;
        widget.parent = childId;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.enabledSprite = Client.spriteCache.get(spriteId);
        widget.disabledSprite = Client.spriteCache.get(spriteId);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height - 2;
    }

    public static void configHoverButton(int id, String tooltip, int enabledSprite, int disabledSprite, int enabledAltSprite, int disabledAltSprite, boolean active, int ... buttonsToDisable) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 11;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height;
        widget.enabledAltSprite = Client.spriteCache.get(enabledAltSprite);
        widget.disabledAltSprite = Client.spriteCache.get(disabledAltSprite);
        widget.buttonsToDisable = buttonsToDisable;
        widget.active = active;
        widget.spriteOpacity = 255;
    }

    public static void addHoverButtonWithDisable(int id, String tooltip, int enabledSprite, int disabledSprite, int enabledAltSprite, int disabledAltSprite, boolean active, int ... buttonsToDisable) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 11;
        widget.disabledSprite = Client.spriteCache.get(enabledSprite);
        widget.enabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height;
        widget.enabledAltSprite = Client.spriteCache.get(enabledAltSprite);
        widget.disabledAltSprite = Client.spriteCache.get(disabledAltSprite);
        widget.buttonsToDisable = buttonsToDisable;
        widget.active = active;
        widget.spriteOpacity = 255;
    }

    public static void addConfigSprite(int id, int spriteId, int spriteId2, int state, int config, String tooltip) {
        Widget widget = Widget.addTabInterface(id);
        widget.id = id;
        widget.parent = id;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.width = 512;
        widget.height = 334;
        widget.opacity = 0;
        widget.hoverType = -1;
        widget.tooltip = tooltip;
        widget.defaultText = tooltip;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = state;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = config;
        widget.valueIndexArray[0][2] = 0;
        widget.disabledSprite = spriteId < 0 ? null : Client.spriteCache.get(spriteId);
        widget.enabledSprite = spriteId2 < 0 ? null : Client.spriteCache.get(spriteId2);
    }

    public static void addConfigSprite(int id, int spriteId, int spriteId2, int state, int config) {
        Widget widget = Widget.addTabInterface(id);
        widget.id = id;
        widget.parent = id;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.width = 512;
        widget.height = 334;
        widget.opacity = 0;
        widget.hoverType = -1;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = state;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = config;
        widget.valueIndexArray[0][2] = 0;
        widget.disabledSprite = spriteId < 0 ? null : Client.spriteCache.get(spriteId);
        widget.enabledSprite = spriteId2 < 0 ? null : Client.spriteCache.get(spriteId2);
    }

    public static Widget addSprite(int i, SimpleImage sprite) {
        Widget rsinterface = Widget.cache[i] = new Widget();
        rsinterface.id = i;
        rsinterface.parent = i;
        rsinterface.type = 5;
        rsinterface.optionType = 0;
        rsinterface.contentType = 0;
        rsinterface.width = sprite.width;
        rsinterface.height = sprite.height;
        rsinterface.opacity = 0;
        rsinterface.hoverType = 52;
        rsinterface.enabledSprite = sprite;
        rsinterface.disabledSprite = sprite;
        return rsinterface;
    }

    public static void addSprite(int id, int spriteId) {
        Widget rsint = Widget.cache[id] = new Widget();
        rsint.id = id;
        rsint.parent = id;
        rsint.type = 5;
        rsint.optionType = 0;
        rsint.contentType = 0;
        rsint.opacity = 0;
        rsint.hoverType = 0;
        if (spriteId != -1) {
            rsint.enabledSprite = Client.spriteCache.get(spriteId);
            rsint.disabledSprite = Client.spriteCache.get(spriteId);
        }
        rsint.width = 0;
        rsint.height = 0;
    }

    public static void addTransparantSprite(int id, int spriteId, int opacity) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.id = id;
        widget.parent = id;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = 0;
        widget.drawsTransparent = true;
        widget.transparency = opacity;
        if (spriteId != -1) {
            widget.enabledSprite = Client.spriteCache.get(spriteId);
            widget.disabledSprite = Client.spriteCache.get(spriteId);
        }
        widget.width = 0;
        widget.height = 0;
    }

    public static Widget addText(int id, int fontIdx, int color, boolean centered, String text) {
        return Widget.addText(id, text, fonts, fontIdx, color, centered);
    }

    public static void addText(int id, String text, AdvancedFont[] wid, int idx, int color) {
        Widget rsinterface = Widget.addTabInterface(id);
        rsinterface.id = id;
        rsinterface.parent = id;
        rsinterface.type = 4;
        rsinterface.optionType = 0;
        rsinterface.width = 174;
        rsinterface.height = 11;
        rsinterface.contentType = 0;
        rsinterface.opacity = 0;
        rsinterface.centerText = false;
        rsinterface.textShadow = true;
        rsinterface.text_type = wid[idx];
        rsinterface.defaultText = text;
        rsinterface.secondaryText = "";
        rsinterface.textColour = color;
        rsinterface.secondaryColor = 0;
        rsinterface.defaultHoverColor = 0;
        rsinterface.secondaryHoverColor = 0;
    }

    public static void addQuestWidgetText(int id, String text, AdvancedFont[] tda, int idx, int color, boolean center, boolean shadow) {
        Widget tab = Widget.addTabInterface(id);
        tab.parent = id;
        tab.id = id;
        tab.type = 4;
        tab.optionType = 0;
        tab.width = 331;
        tab.height = 11;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.textShadow = shadow;
        tab.text_type = tda[idx];
        tab.defaultText = text;
        tab.secondaryText = "";
        tab.textColour = color;
        tab.secondaryColor = 0;
        tab.defaultHoverColor = 0;
        tab.secondaryHoverColor = 0;
    }

    public static void removeConfig(int id) {
        Widget rsi = Widget.cache[id] = new Widget();
    }

    public static void addBackgroundImage(int id, int width, int height, boolean divider) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = tab.disabledSprite = Widget.buildBackground(width, height, divider);
        tab.width = width;
        tab.height = height;
    }

    public static SimpleImage buildBackground(int width, int height, boolean divider) {
        int[][] pixels = new int[height][width];
        Widget.fillPixels(pixels, Client.autoBackgroundSprites[0], 0, 0, width, height);
        Widget.fillPixels(pixels, Client.autoBackgroundSprites[5], 25, 0, width - 25, 6);
        Widget.fillPixels(pixels, Client.autoBackgroundSprites[7], 0, 30, 6, height - 30);
        Widget.fillPixels(pixels, Client.autoBackgroundSprites[6], width - 6, 30, width, height - 30);
        Widget.fillPixels(pixels, Client.autoBackgroundSprites[8], 25, height - 6, width - 25, height);
        Widget.insertPixels(pixels, Client.autoBackgroundSprites[1], 0, 0, true);
        Widget.insertPixels(pixels, Client.autoBackgroundSprites[2], width - 25, 0, true);
        Widget.insertPixels(pixels, Client.autoBackgroundSprites[3], 0, height - 30, true);
        Widget.insertPixels(pixels, Client.autoBackgroundSprites[4], width - 25, height - 30, true);
        if (divider) {
            Widget.fillPixels(pixels, Client.autoBackgroundSprites[5], 6, 29, width - 6, 35);
        }
        return new SimpleImage(width, height, 0, 0, Utils.d2Tod1(pixels));
    }

    public static void insertPixels(int[][] pixels, SimpleImage image, int x, int y, boolean ignoreTransparency) {
        int[][] imagePixels = Utils.d1Tod2(image.pixels, image.width);
        for (int j = y; j < y + image.height; ++j) {
            for (int i = x; i < x + image.width; ++i) {
                if (ignoreTransparency && imagePixels[j - y][i - x] == 0) continue;
                pixels[j][i] = imagePixels[j - y][i - x];
            }
        }
    }

    public static void fillPixels(int[][] pixels, SimpleImage image, int startX, int startY, int endX, int endY) {
        int[][] imagePixels = Utils.d1Tod2(image.pixels, image.width);
        for (int j = startY; j < endY; ++j) {
            for (int i = startX; i < endX; ++i) {
                pixels[j][i] = imagePixels[(j - startY) % image.height][(i - startX) % image.width];
            }
        }
    }

    public static void addItem(int id, boolean showAmount, boolean upgradeStation) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.actions = upgradeStation ? new String[]{"Reclaim", null, null, null, null} : new String[5];
        widget.inventoryOffsetX = new int[20];
        widget.inventoryItemId = new int[30];
        widget.inventoryAmounts = new int[30];
        widget.itemOpacity = new int[30];
        widget.inventoryOffsetY = new int[20];
        widget.children = new int[0];
        widget.child_x = new int[0];
        widget.child_y = new int[0];
        widget.hasActions = false;
        widget.displayAmount = showAmount;
        widget.inventoryMarginX = 24;
        widget.inventoryMarginY = 24;
        widget.height = 5;
        widget.width = 6;
        widget.parent = 5292;
        widget.id = id;
        widget.type = 2;
    }

    public static void addItemUpgradeStation(int id) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.actions = new String[]{"Reclaim", null, null, null, null};
        widget.inventoryOffsetX = new int[20];
        widget.inventoryItemId = new int[30];
        widget.inventoryAmounts = new int[30];
        widget.itemOpacity = new int[30];
        widget.inventoryOffsetY = new int[20];
        widget.children = new int[0];
        widget.child_x = new int[0];
        widget.child_y = new int[0];
        widget.hasActions = false;
        widget.inventoryMarginX = 24;
        widget.inventoryMarginY = 24;
        widget.height = 5;
        widget.width = 6;
        widget.parent = 5292;
        widget.id = id;
        widget.type = 2;
    }

    public static void addItem(int id, boolean showAmount) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.actions = new String[5];
        widget.inventoryOffsetX = new int[1];
        widget.inventoryOffsetY = new int[1];
        widget.inventoryItemId = new int[1];
        widget.inventoryAmounts = new int[1];
        widget.itemOpacity = new int[1];
        widget.children = new int[0];
        widget.child_x = new int[0];
        widget.child_y = new int[0];
        widget.hasActions = false;
        widget.displayAmount = showAmount;
        widget.inventoryMarginX = 1;
        widget.inventoryMarginY = 1;
        widget.height = 5;
        widget.width = 9;
        widget.parent = 27400;
        widget.id = id;
        widget.type = 2;
    }

    public static void addItem(int id) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.inventoryOffsetX = new int[1];
        widget.inventoryOffsetY = new int[1];
        widget.inventoryItemId = new int[1];
        widget.inventoryAmounts = new int[1];
        widget.itemOpacity = new int[1];
        widget.children = new int[0];
        widget.child_x = new int[0];
        widget.child_y = new int[0];
        widget.displayAmount = false;
        widget.inventoryMarginX = 1;
        widget.inventoryMarginY = 1;
        widget.height = 5;
        widget.width = 9;
        widget.parent = 66310;
        widget.id = id;
        widget.type = 2;
    }

    public static void addCharacterToInterface(int id, int zoom) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.id = id;
        widget.parent = id;
        widget.type = 6;
        widget.optionType = 0;
        widget.contentType = 328;
        widget.width = 136;
        widget.height = 168;
        widget.opacity = 0;
        widget.hoverType = 0;
        widget.modelZoom = zoom;
        widget.modelRotation1 = 150;
        widget.modelRotation2 = 0;
        widget.defaultAnimationId = -1;
        widget.secondaryAnimationId = -1;
    }

    public static void addNPCWidget(int id) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.id = id;
        widget.parent = id;
        widget.type = 6;
        widget.optionType = 0;
        widget.contentType = 3292;
        widget.width = 136;
        widget.height = 168;
        widget.opacity = 0;
        widget.hoverType = 0;
        widget.modelZoom = 560;
        widget.modelRotation1 = 150;
        widget.modelRotation2 = 0;
        widget.defaultAnimationId = -1;
        widget.secondaryAnimationId = -1;
    }

    public static void addButton(int id, int sprite) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 1;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = Client.spriteCache.get(sprite);
        tab.disabledSprite = Client.spriteCache.get(sprite);
        tab.width = tab.enabledSprite.width;
        tab.height = tab.disabledSprite.height;
        tab.tooltip = "";
    }

    public static void addButton(int id, int sprite, String tooltip) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 1;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = Client.spriteCache.get(sprite);
        tab.disabledSprite = Client.spriteCache.get(sprite);
        tab.width = tab.enabledSprite.width;
        tab.height = tab.disabledSprite.height;
        tab.tooltip = tooltip;
    }

    public static void addButtonWithMenu(int id, int sprite, String[] menu) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 1;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 17;
        if (Client.spriteCache.get(sprite) != null) {
            tab.enabledSprite = Client.spriteCache.get(sprite);
            tab.disabledSprite = Client.spriteCache.get(sprite);
        }
        tab.width = tab.enabledSprite.width;
        tab.height = tab.disabledSprite.height;
        tab.actions = menu;
    }

    public static void addTooltipBox(int id, String text) {
        Widget rsi = Widget.addInterface(id);
        rsi.id = id;
        rsi.parent = id;
        rsi.type = 8;
        rsi.defaultText = text;
    }

    public static void addTooltipBox(AdvancedFont[] tda, int idx, int ID, String hover, int xOffset, int yOffset, int width, int height) {
        Widget p = Widget.addTabInterface(ID);
        p.inventoryHover = true;
        p.parent = 5608;
        p.type = 8;
        p.width = width;
        p.height = height;
        p.defaultText = hover;
        p.text_type = tda[idx];
        p.hoverXOffset = xOffset;
        p.hoverYOffset = yOffset;
        p.regularHoverBox = true;
    }

    public static void addTooltip(int id, String text) {
        Widget rsi = Widget.addInterface(id);
        rsi.id = id;
        rsi.type = 0;
        rsi.invisible = true;
        rsi.hoverType = -1;
        Widget.addTooltipBox(id + 1, text);
        rsi.totalChildren(1);
        rsi.child(0, id + 1, 0, 0);
    }

    public static void drawTooltip(int id, String text) {
        Widget widget = Widget.addTabInterface(id);
        widget.parent = id;
        widget.type = 0;
        widget.invisible = true;
        widget.hoverType = -1;
        Widget.addTooltipBox(id + 1, text);
        widget.totalChildren(1);
        widget.child(0, id + 1, 0, 0);
    }

    public static Widget addInterface(int id) {
        Widget rsi = Widget.cache[id] = new Widget();
        foundIDS.add(id);
        rsi.id = id;
        rsi.parent = id;
        rsi.width = 512;
        rsi.height = 334;
        return rsi;
    }

    public static void addSpriteComplete(int interfaceId, int child, int spriteId, int x, int y, Widget interfaces, boolean add) {
        if (add) {
            Widget.addSprite(interfaceId, spriteId);
        }
        Widget.setBounds(interfaceId, x, y, child, interfaces);
    }

    public static void addHoverButtonComplete(int interfaceId, int child, int x, int y, int normalSprite, int hoverSprite, int buttonWidth, int buttonHeight, String buttonHoverText, Widget interfaces, boolean add) {
        if (add) {
            Widget.addHoverButtonLatest(interfaceId, interfaceId + 1, interfaceId + 2, normalSprite, hoverSprite, buttonWidth, buttonHeight, buttonHoverText);
        }
        Widget.setBounds(interfaceId, x, y, child, interfaces);
        Widget.setBounds(interfaceId + 1, x, y, child + 1, interfaces);
    }

    public static void addHoverButtonLatest(int buttonId1, int buttonId2, int buttonId3, int spriteId1, int spriteId2, int buttonWidth, int buttonHeight, String buttonHoverText) {
        Widget.addHoverButton(buttonId1, spriteId1, buttonWidth, buttonHeight, buttonHoverText, -1, buttonId2, 1);
        Widget.addHoveredButton(buttonId2, spriteId2, buttonWidth, buttonHeight, buttonId3);
    }

    public static Widget addText(int id, String text, AdvancedFont[] tda, int idx, int color, boolean centered) {
        Widget rsi = Widget.cache[id] = new Widget();
        if (centered) {
            rsi.centerText = true;
        }
        rsi.textShadow = true;
        rsi.text_type = tda[idx];
        rsi.defaultText = text;
        rsi.textColour = color;
        rsi.id = id;
        rsi.type = 4;
        return rsi;
    }

    public static void textColour(int id, int color) {
        Widget rsi = cache[id];
        rsi.textColour = color;
    }

    public static void textSize(int id, AdvancedFont[] tda, int idx) {
        Widget rsi = cache[id];
        rsi.text_type = tda[idx];
    }

    public static void addCacheSprite(int id, int sprite1, int sprite2, String sprites) {
        Widget rsi = Widget.cache[id] = new Widget();
        rsi.enabledSprite = Widget.getSprite(sprite1, interfaceLoader, sprites);
        rsi.disabledSprite = Widget.getSprite(sprite2, interfaceLoader, sprites);
        rsi.parent = id;
        rsi.id = id;
        rsi.type = 5;
    }

    public static void sprite1(int id, int sprite) {
        Widget class9 = cache[id];
        class9.enabledSprite = Client.spriteCache.get(sprite);
    }

    public static void addActionButton(int id, int sprite, int sprite2, int width, int height, String s) {
        Widget rsi = Widget.cache[id] = new Widget();
        rsi.enabledSprite = Client.spriteCache.get(sprite);
        rsi.disabledSprite = sprite2 == sprite ? Client.spriteCache.get(sprite) : Client.spriteCache.get(sprite2);
        rsi.tooltip = s;
        rsi.contentType = 0;
        rsi.optionType = 1;
        rsi.width = width;
        rsi.hoverType = 52;
        rsi.parent = id;
        rsi.id = id;
        rsi.type = 5;
        rsi.height = height;
    }

    public static void addToggleButton(int id, int sprite, int setconfig, int width, int height, String s) {
        Widget rsi = Widget.addInterface(id);
        rsi.enabledSprite = Client.spriteCache.get(sprite);
        rsi.disabledSprite = Client.spriteCache.get(sprite);
        rsi.requiredValues = new int[1];
        rsi.requiredValues[0] = 1;
        rsi.valueCompareType = new int[1];
        rsi.valueCompareType[0] = 1;
        rsi.valueIndexArray = new int[1][3];
        rsi.valueIndexArray[0][0] = 5;
        rsi.valueIndexArray[0][1] = setconfig;
        rsi.valueIndexArray[0][2] = 0;
        rsi.optionType = 4;
        rsi.width = width;
        rsi.hoverType = -1;
        rsi.parent = id;
        rsi.id = id;
        rsi.type = 5;
        rsi.height = height;
        rsi.tooltip = s;
    }

    public void totalChildren(int id, int x, int y) {
        this.children = new int[id];
        this.child_x = new int[x];
        this.child_y = new int[y];
    }

    public static void removeSomething(int id) {
        Widget rsi = Widget.cache[id] = new Widget();
    }

    protected static void addTransparentSprite(int id, int spriteId, int transparency) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.transparency = transparency;
        tab.hoverType = 52;
        tab.enabledSprite = Client.spriteCache.get(spriteId);
        tab.disabledSprite = Client.spriteCache.get(spriteId);
        tab.width = 512;
        tab.height = 334;
        tab.drawsTransparent = true;
    }

    public static void addItemOnInterface(int childId, int interfaceId, String[] options, int invSpritePadX, int invSpritePadY, int height, int width) {
        Widget rsi = Widget.cache[childId] = new Widget();
        rsi.actions = options == null ? null : new String[10];
        rsi.inventoryOffsetX = new int[20];
        rsi.inventoryAmounts = new int[height * width];
        rsi.inventoryItemId = new int[height * width];
        rsi.itemOpacity = new int[height * width];
        rsi.inventoryOffsetY = new int[20];
        rsi.children = new int[0];
        rsi.child_x = new int[0];
        rsi.child_y = new int[0];
        if (rsi.actions != null) {
            for (int i = 0; i < rsi.actions.length; ++i) {
                if (i >= options.length || options[i] == null) continue;
                rsi.actions[i] = options[i];
            }
        }
        rsi.centerText = true;
        rsi.filled = false;
        rsi.replaceItems = false;
        rsi.usableItems = false;
        rsi.allowSwapItems = false;
        rsi.textShadow = false;
        rsi.inventoryMarginX = invSpritePadX;
        rsi.inventoryMarginY = invSpritePadY;
        rsi.height = height;
        rsi.width = width;
        rsi.parent = childId;
        rsi.id = interfaceId;
        rsi.type = 2;
    }

    public static void addItemOnInterface(int childId, int interfaceId, String[] options, boolean displayExamine) {
        Widget rsi = Widget.cache[childId] = new Widget();
        rsi.actions = new String[5];
        rsi.inventoryOffsetX = new int[20];
        rsi.inventoryItemId = new int[30];
        rsi.inventoryAmounts = new int[30];
        rsi.itemOpacity = new int[30];
        rsi.inventoryOffsetY = new int[20];
        rsi.children = new int[0];
        rsi.child_x = new int[0];
        rsi.child_y = new int[0];
        for (int i = 0; i < rsi.actions.length; ++i) {
            if (i >= options.length || options[i] == null) continue;
            rsi.actions[i] = options[i];
        }
        rsi.centerText = true;
        rsi.filled = false;
        rsi.replaceItems = false;
        rsi.usableItems = false;
        rsi.displayExamine = displayExamine;
        rsi.allowSwapItems = false;
        rsi.inventoryMarginX = 4;
        rsi.inventoryMarginY = 5;
        rsi.height = 1;
        rsi.width = 1;
        rsi.parent = interfaceId;
        rsi.id = childId;
        rsi.type = 2;
    }

    public static void addText(int id, String text, AdvancedFont[] tda, int idx, int color, boolean center, boolean shadow, int hoverColour, String tooltip, int widthHover) {
        Widget tab = Widget.addTabInterface(id);
        tab.parent = id;
        tab.id = id;
        tab.tooltip = tooltip;
        tab.type = 4;
        tab.optionType = 4;
        tab.width = widthHover;
        tab.height = 15;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.textShadow = shadow;
        tab.text_type = tda[idx];
        tab.defaultText = text;
        tab.secondaryText = "";
        tab.textColour = color;
        tab.secondaryColor = 0;
        tab.defaultHoverColor = hoverColour;
        tab.secondaryHoverColor = 0;
    }

    public static void addClickableText(int id, String text, String tooltip, AdvancedFont[] tda, int idx, int color, boolean center, boolean shadow, int width) {
        Widget tab = Widget.addTabInterface(id);
        tab.parent = id;
        tab.id = id;
        tab.type = 4;
        tab.optionType = 1;
        tab.width = width;
        tab.height = 11;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.textShadow = shadow;
        tab.text_type = tda[idx];
        tab.defaultText = text;
        tab.secondaryText = "";
        tab.textColour = color;
        tab.secondaryColor = 0;
        tab.defaultHoverColor = 0xFFFFFF;
        tab.secondaryHoverColor = 0;
        tab.tooltip = tooltip;
    }

    public static void addClickableText(int id, String text, String tooltip, AdvancedFont[] tda, int idx, int color, boolean center, boolean shadow, int width, int height) {
        Widget tab = Widget.addTabInterface(id);
        tab.parent = id;
        tab.id = id;
        tab.type = 4;
        tab.optionType = 1;
        tab.width = width;
        tab.height = height;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.textShadow = shadow;
        tab.text_type = tda[idx];
        tab.defaultText = text;
        tab.secondaryText = "";
        tab.textColour = color;
        tab.secondaryColor = 0;
        tab.defaultHoverColor = 0xFFFFFF;
        tab.secondaryHoverColor = 0;
        tab.tooltip = tooltip;
    }

    public static void addCustomClickableText(int id, String text, String tooltip, AdvancedFont[] tda, int idx, int color, boolean center, boolean shadow, int width, int height) {
        Widget tab = Widget.addTabInterface(id);
        tab.parent = id;
        tab.id = id;
        tab.type = 4;
        tab.optionType = 1;
        tab.width = width;
        tab.height = height;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.textShadow = shadow;
        tab.text_type = tda[idx];
        tab.defaultText = text;
        tab.secondaryText = "";
        tab.textColour = color;
        tab.secondaryColor = 0;
        tab.defaultHoverColor = 0xFFFFFF;
        tab.secondaryHoverColor = 0;
        tab.tooltip = tooltip;
    }

    public static void addHoverText3(int id, String text, String tooltip, AdvancedFont[] tda, int idx, int color, boolean center, boolean textShadow, int width, int hoverColor) {
        Widget rsinterface = Widget.addInterface(id);
        rsinterface.id = id;
        rsinterface.parent = id;
        rsinterface.type = 4;
        rsinterface.optionType = 1;
        rsinterface.width = width;
        rsinterface.height = 11;
        rsinterface.contentType = 0;
        rsinterface.opacity = 0;
        rsinterface.hoverType = -1;
        rsinterface.centerText = center;
        rsinterface.textShadow = textShadow;
        rsinterface.text_type = tda[idx];
        rsinterface.defaultText = text;
        rsinterface.secondaryText = "";
        rsinterface.tooltip = tooltip;
        rsinterface.textColour = color;
        rsinterface.secondaryColor = 0;
        rsinterface.defaultHoverColor = hoverColor;
        rsinterface.secondaryHoverColor = 0;
    }

    public static void addText(int id, String text, AdvancedFont[] tda, int idx, int color, boolean center, boolean shadow) {
        Widget tab = Widget.addTabInterface(id);
        tab.parent = id;
        tab.id = id;
        tab.type = 4;
        tab.optionType = 0;
        tab.width = 0;
        tab.height = 11;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.textShadow = shadow;
        tab.text_type = tda[idx];
        tab.defaultText = text;
        tab.secondaryText = "";
        tab.textColour = color;
        tab.secondaryColor = 0;
        tab.defaultHoverColor = 0;
        tab.secondaryHoverColor = 0;
    }

    public static void addText(int id, String text, int textColour, boolean center, boolean shadow, int hoverType, AdvancedFont[] font, int fontIndex) {
        Widget widget = Widget.addInterface(id);
        widget.parent = id;
        widget.id = id;
        widget.type = 4;
        widget.optionType = 0;
        widget.width = 0;
        widget.height = 0;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = hoverType;
        widget.centerText = center;
        widget.textShadow = shadow;
        widget.text_type = font[fontIndex];
        widget.defaultText = text;
        widget.secondaryText = "";
        widget.textColour = textColour;
    }

    public static Widget addConfigButton(int ID, SimpleImage sprite1, SimpleImage sprite2, String tT, int configValueToActivate, int configId, int atActionType) {
        Widget Tab = Widget.addTabInterface(ID);
        Tab.id = ID;
        Tab.type = 5;
        Tab.optionType = atActionType;
        Tab.contentType = 0;
        Tab.width = sprite1.width;
        Tab.height = sprite1.height;
        Tab.opacity = 0;
        Tab.hoverType = -1;
        Tab.valueCompareType = new int[1];
        Tab.requiredValues = new int[1];
        Tab.valueCompareType[0] = 1;
        Tab.requiredValues[0] = configValueToActivate;
        Tab.valueIndexArray = new int[1][3];
        Tab.valueIndexArray[0][0] = 5;
        Tab.valueIndexArray[0][1] = configId;
        Tab.valueIndexArray[0][2] = 0;
        Tab.disabledSprite = sprite1;
        Tab.enabledSprite = sprite2;
        Tab.tooltip = tT;
        return Tab;
    }

    public static Widget addItemContainer(int childId, int width, int height, int invSpritePadX, int invSpritePadY, boolean addPlaceholderItems, boolean smallInvSprites, String ... options) {
        int index;
        Widget rsi = Widget.addInterface(childId);
        rsi.smallInvSprites = smallInvSprites;
        rsi.hideInvStackSizes = false;
        rsi.actions = new String[10];
        rsi.inventoryOffsetX = new int[width * height];
        rsi.inventoryItemId = new int[width * height];
        rsi.inventoryAmounts = new int[width * height];
        rsi.itemOpacity = new int[width * height];
        rsi.inventoryOffsetY = new int[width * height];
        rsi.height = height;
        rsi.width = width;
        rsi.usableItems = false;
        rsi.hasActions = false;
        rsi.type = 2;
        rsi.id = childId;
        rsi.inventoryMarginX = invSpritePadX;
        rsi.inventoryMarginY = invSpritePadY;
        for (index = 0; index < options.length; ++index) {
            rsi.actions[index] = options[index];
        }
        if (addPlaceholderItems) {
            for (index = 0; index < rsi.inventoryItemId.length; ++index) {
                rsi.inventoryItemId[index] = 4152 + index * 2;
                rsi.inventoryAmounts[index] = index + 1;
            }
        }
        return rsi;
    }

    public static void addConfigButton(int ID, int pID, int bID, int bID2, int width, int height, String tT, int configID, int aT, int configFrame) {
        Widget Tab = Widget.addTabInterface(ID);
        Tab.parent = pID;
        Tab.id = ID;
        Tab.type = 5;
        Tab.optionType = aT;
        Tab.contentType = 0;
        Tab.width = width;
        Tab.height = height;
        Tab.opacity = 0;
        Tab.hoverType = -1;
        Tab.valueCompareType = new int[1];
        Tab.requiredValues = new int[1];
        Tab.valueCompareType[0] = 1;
        Tab.requiredValues[0] = configID;
        Tab.valueIndexArray = new int[1][3];
        Tab.valueIndexArray[0][0] = 5;
        Tab.valueIndexArray[0][1] = configFrame;
        Tab.valueIndexArray[0][2] = 0;
        Tab.disabledSprite = Client.spriteCache.get(bID);
        Tab.enabledSprite = Client.spriteCache.get(bID2);
        Tab.tooltip = tT;
    }

    public static void addConfigButton(int id, int parent, int disabledSprite, int enabledSprite, String tooltip, int configId, int configState, int actionType) {
        Widget widget = Widget.addTabInterface(id);
        widget.parent = parent;
        widget.id = id;
        widget.type = 5;
        widget.optionType = actionType;
        widget.contentType = 0;
        widget.disabledSprite = disabledSprite < 0 ? null : Client.spriteCache.get(disabledSprite);
        SimpleImage simpleImage = widget.enabledSprite = enabledSprite < 0 ? null : Client.spriteCache.get(enabledSprite);
        if (disabledSprite > 0 && widget.disabledSprite != null) {
            widget.width = widget.disabledSprite.width;
        }
        if (enabledSprite > 0 && widget.enabledSprite != null) {
            widget.height = widget.enabledSprite.height;
        }
        widget.opacity = 0;
        widget.hoverType = -1;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = configState;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = configId;
        widget.valueIndexArray[0][2] = 0;
        widget.tooltip = tooltip;
    }

    public static void addConfigButton(int identification, int parentIdentification, int disabledSprite, int enabledSprite, int width, int height, String tooltip, int configIdentification, int actionType, int configFrame, boolean updateConfig) {
        Widget widget = Widget.addTabInterface(identification);
        widget.parent = parentIdentification;
        widget.id = identification;
        widget.type = 5;
        widget.optionType = actionType;
        widget.contentType = 0;
        widget.width = width;
        widget.height = height;
        widget.opacity = 0;
        widget.hoverType = -1;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 1;
        widget.requiredValues[0] = configIdentification;
        widget.valueIndexArray = new int[1][3];
        widget.valueIndexArray[0][0] = 5;
        widget.valueIndexArray[0][1] = configFrame;
        widget.valueIndexArray[0][2] = 0;
        widget.disabledSprite = Client.spriteCache.get(disabledSprite);
        widget.enabledSprite = Client.spriteCache.get(enabledSprite);
        widget.tooltip = tooltip;
        widget.updateConfig = updateConfig;
    }

    public static void addSprite(int id, int spriteId, String spriteName) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = Widget.imageLoader(spriteId, spriteName);
        tab.disabledSprite = Widget.imageLoader(spriteId, spriteName);
        tab.width = 512;
        tab.height = 334;
    }

    public static void addHoverText(int id, String text, String tooltip, AdvancedFont[] advancedFonts, int idx, int color, boolean centerText, boolean textShadowed, int width) {
        Widget widget = Widget.addInterface(id);
        widget.id = id;
        widget.parent = id;
        widget.type = 4;
        widget.optionType = 1;
        widget.width = width;
        widget.height = 11;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = -1;
        widget.centerText = centerText;
        widget.textShadow = textShadowed;
        widget.text_type = advancedFonts[idx];
        widget.defaultText = text;
        if (text.contains("<br>")) {
            widget.height += 11;
        }
        widget.secondaryText = "";
        widget.tooltip = tooltip;
        widget.textColour = color;
        widget.secondaryColor = 0;
        widget.defaultHoverColor = 0xFFFFFF;
        widget.secondaryHoverColor = 0;
    }

    public static void addTransButtonHover(int id, int sid, String tooltip, int transparency, boolean selected) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 1;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.disabledSprite = Client.spriteCache.get(sid);
        tab.enabledSprite = Client.spriteCache.get(sid);
        tab.width = tab.disabledSprite.width;
        tab.height = tab.enabledSprite.height;
        tab.drawsTransparent = true;
        tab.transparency = transparency;
        tab.tooltip = tooltip;
    }

    public static void addHoverText(int id, String text, String tooltip, AdvancedFont[] tda, int idx, int color, boolean center, boolean textShadow, int width, int height, int hoveredColor) {
        Widget rsinterface = Widget.addInterface(id);
        rsinterface.id = id;
        rsinterface.parent = id;
        rsinterface.type = 4;
        rsinterface.optionType = 1;
        rsinterface.width = width;
        rsinterface.height = height;
        rsinterface.contentType = 0;
        rsinterface.opacity = 0;
        rsinterface.hoverType = -1;
        rsinterface.centerText = center;
        rsinterface.textShadow = textShadow;
        rsinterface.text_type = tda[idx];
        rsinterface.defaultText = text;
        rsinterface.secondaryText = "";
        rsinterface.textColour = color;
        rsinterface.secondaryColor = 0;
        rsinterface.defaultHoverColor = hoveredColor;
        rsinterface.secondaryHoverColor = 0;
        rsinterface.tooltip = tooltip;
    }

    public static void addHoverText(int id, String text, String tooltip, AdvancedFont[] font, int idx, int color, int hoverColor, boolean centerText, boolean textShadowed, int width) {
        Widget rsinterface = Widget.addInterface(id);
        rsinterface.id = id;
        rsinterface.parent = id;
        rsinterface.type = 4;
        rsinterface.optionType = 1;
        rsinterface.width = width;
        rsinterface.height = 11;
        rsinterface.contentType = 0;
        rsinterface.opacity = 0;
        rsinterface.hoverType = -1;
        rsinterface.centerText = centerText;
        rsinterface.textShadow = textShadowed;
        rsinterface.text_type = font[idx];
        rsinterface.defaultText = text;
        rsinterface.secondaryText = "";
        rsinterface.tooltip = tooltip;
        rsinterface.textColour = color;
        rsinterface.secondaryColor = 0;
        rsinterface.defaultHoverColor = hoverColor;
        rsinterface.secondaryHoverColor = 0;
    }

    public static void addHoverText(int id, String text, String tooltip, AdvancedFont[] font, int idx, int color, boolean center, boolean textShadow, int width, int hoveredColor) {
        Widget rsinterface = Widget.addInterface(id);
        rsinterface.id = id;
        rsinterface.parent = id;
        rsinterface.type = 4;
        rsinterface.optionType = 1;
        rsinterface.width = width;
        rsinterface.height = 13;
        rsinterface.contentType = 0;
        rsinterface.opacity = 0;
        rsinterface.hoverType = -1;
        rsinterface.centerText = center;
        rsinterface.textShadow = textShadow;
        rsinterface.text_type = font[idx];
        rsinterface.defaultText = text;
        rsinterface.secondaryText = "";
        rsinterface.textColour = color;
        rsinterface.secondaryColor = 0;
        rsinterface.defaultHoverColor = 0xFFFFFF;
        rsinterface.secondaryHoverColor = 0;
        rsinterface.tooltip = tooltip;
    }

    public static void addHoveredConfigButton(Widget original, int ID, int IMAGEID, int disabledID, int enabledID) {
        Widget rsint = Widget.addTabInterface(ID);
        rsint.parent = original.id;
        rsint.id = ID;
        rsint.type = 0;
        rsint.optionType = 0;
        rsint.contentType = 0;
        rsint.width = original.width;
        rsint.height = original.height;
        rsint.opacity = 0;
        rsint.hoverType = -1;
        Widget hover = Widget.addInterface(IMAGEID);
        hover.type = 5;
        hover.width = original.width;
        hover.height = original.height;
        hover.valueCompareType = original.valueCompareType;
        hover.requiredValues = original.requiredValues;
        hover.valueIndexArray = original.valueIndexArray;
        if (disabledID != -1) {
            hover.enabledSprite = Client.spriteCache.get(disabledID);
        }
        if (enabledID != -1) {
            hover.disabledSprite = Client.spriteCache.get(enabledID);
        }
        rsint.totalChildren(1);
        Widget.setBounds(IMAGEID, 0, 0, 0, rsint);
        rsint.tooltip = original.tooltip;
        rsint.invisible = true;
    }

    public static void addHoverConfigButton(int id, int hoverOver, int disabledID, int enabledID, int width, int height, String tooltip, int[] valueCompareType, int[] requiredValues, int[][] valueIndexArray) {
        Widget rsint = Widget.addTabInterface(id);
        rsint.parent = id;
        rsint.id = id;
        rsint.type = 5;
        rsint.optionType = 5;
        rsint.contentType = 206;
        rsint.width = width;
        rsint.height = height;
        rsint.opacity = 0;
        rsint.hoverType = hoverOver;
        rsint.valueCompareType = valueCompareType;
        rsint.requiredValues = requiredValues;
        rsint.valueIndexArray = valueIndexArray;
        if (disabledID != -1) {
            rsint.enabledSprite = Client.spriteCache.get(disabledID);
        }
        if (enabledID != -1) {
            rsint.disabledSprite = Client.spriteCache.get(enabledID);
        }
        rsint.tooltip = tooltip;
    }

    public static void addButton(int i, int parent, int sprite1, int sprite2, int hoverOver, String tooltip) {
        Widget p = Widget.addInterface(i);
        p.parent = parent;
        p.type = 5;
        p.type = 1;
        p.width = Client.spriteCache.get((int)sprite1).width;
        p.height = Client.spriteCache.get((int)sprite1).height;
        p.tooltip = tooltip;
        p.defaultText = tooltip;
        p.hoverType = hoverOver;
        p.disabledSprite = Client.spriteCache.get(sprite1);
        p.enabledSprite = Client.spriteCache.get(sprite1);
    }

    public static void addButton(int id, SimpleImage enabled, SimpleImage disabled, String tooltip, int w, int h) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 1;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = disabled;
        tab.disabledSprite = enabled;
        tab.width = w;
        tab.height = h;
        tab.tooltip = tooltip;
    }

    public static void addSpriteLoader(int childId, int spriteId) {
        Widget rsi = Widget.cache[childId] = new Widget();
        rsi.id = childId;
        rsi.parent = childId;
        rsi.type = 5;
        rsi.optionType = 0;
        rsi.contentType = 0;
        rsi.enabledSprite = Client.spriteCache.get(spriteId);
        rsi.disabledSprite = Client.spriteCache.get(spriteId);
        rsi.width = rsi.enabledSprite.width;
        rsi.height = rsi.disabledSprite.height - 2;
    }

    public static void handleConfigSpriteHover(Widget widget) {
        widget.active = !widget.active;
        Widget.configHoverButtonSwitch(widget);
        Widget.disableOtherButtons(widget);
    }

    public static void adjustableConfig(int id, String tooltip, int sprite, int opacity, int enabledSpriteBehind, int disabledSpriteBehind) {
        Widget tab = Widget.addInterface(id);
        tab.tooltip = tooltip;
        tab.optionType = 1;
        tab.type = 17;
        tab.disabledSprite = Client.spriteCache.get(sprite);
        tab.enabledAltSprite = Client.spriteCache.get(enabledSpriteBehind);
        tab.disabledAltSprite = Client.spriteCache.get(disabledSpriteBehind);
        tab.width = tab.enabledAltSprite.width;
        tab.height = tab.disabledAltSprite.height;
        tab.spriteOpacity = opacity;
    }

    public static void addSprite(int childId, SimpleImage sprite1, SimpleImage sprite2) {
        Widget rsi = Widget.cache[childId] = new Widget();
        rsi.id = childId;
        rsi.parent = childId;
        rsi.type = 5;
        rsi.optionType = 0;
        rsi.contentType = 0;
        rsi.enabledSprite = sprite1;
        rsi.disabledSprite = sprite2;
        rsi.width = rsi.enabledSprite.width;
        rsi.height = rsi.disabledSprite.height - 2;
    }

    public static void addHoverButton(int id, String imageName, int spriteId, int width, int height, String text, int contentType, int hoverType, int optionType) {
        Widget tab = Widget.addTabInterface(id);
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = optionType;
        tab.contentType = contentType;
        tab.opacity = 0;
        tab.hoverType = hoverType;
        tab.enabledSprite = Widget.imageLoader(spriteId, imageName);
        tab.disabledSprite = Widget.imageLoader(spriteId, imageName);
        tab.width = width;
        tab.height = height;
        tab.tooltip = text;
    }

    private static int getFreeIndex() {
        for (int i = 0; i < cache.length; ++i) {
            if (cache[i] != null) continue;
            return i;
        }
        return -1;
    }

    public static SimpleImage fetchSprite(String name, Archive graphics) {
        int index = name.lastIndexOf(",");
        return Widget.getSprite(Integer.parseInt(name.substring(index + 1)), graphics, name.substring(0, index));
    }

    public static SimpleImage fetchSprite(String name) {
        return Widget.fetchSprite(name, interfaceLoader);
    }

    public static int getIndexOfChild(int parent, int child) {
        Widget rsi = cache[parent];
        for (int i = 0; i < rsi.children.length; ++i) {
            if (rsi.children[i] != child) continue;
            return i;
        }
        return -1;
    }

    public static void addChild(int parentIndex, int childIndex, int x, int y, int index) {
        Widget parent = cache[parentIndex];
        int[] childX = new int[parent.child_x.length + 1];
        int[] childY = new int[parent.child_y.length + 1];
        int[] children = new int[parent.children.length + 1];
        System.arraycopy(parent.child_x, 0, childX, 0, index);
        System.arraycopy(parent.child_x, index, childX, index + 1, parent.child_x.length - index);
        System.arraycopy(parent.child_y, 0, childY, 0, parent.child_y.length);
        System.arraycopy(parent.child_y, index, childY, index + 1, parent.child_y.length - index);
        System.arraycopy(parent.children, 0, children, 0, index);
        System.arraycopy(parent.children, index, children, index + 1, parent.children.length - index);
        childX[index] = x;
        childY[index] = y;
        children[index] = childIndex;
        parent.child_x = childX;
        parent.child_y = childY;
        parent.children = children;
    }

    private static void addChild(int x, int y, int child, Widget parent) {
        int[] childX = new int[parent.child_x.length + 1];
        int[] childZ = new int[parent.child_y.length + 1];
        int[] children = new int[parent.children.length + 1];
        System.arraycopy(parent.child_x, 0, childX, 0, parent.child_x.length);
        System.arraycopy(parent.child_y, 0, childZ, 0, parent.child_y.length);
        System.arraycopy(parent.children, 0, children, 0, parent.children.length);
        childX[childX.length - 1] = x;
        childZ[childZ.length - 1] = y;
        children[children.length - 1] = child;
        parent.child_x = childX;
        parent.child_y = childZ;
        parent.children = children;
    }

    public static void addChild(int x, int y, Widget parent, Widget child) {
        Widget.addChild(x, y, child.id, parent);
    }

    public static Widget createSprite(int parentIndex, int index, int disabled, int enabled) {
        SimpleImage spriteDisabled = Client.spriteCache.get(disabled);
        SimpleImage spriteEnabled = Client.spriteCache.get(enabled);
        Widget sprite = Widget.cache[index] = new Widget();
        sprite.id = index;
        sprite.parent = parentIndex;
        sprite.type = 5;
        sprite.width = spriteDisabled.width;
        sprite.height = spriteDisabled.height;
        sprite.enabledSprite = spriteDisabled;
        sprite.disabledSprite = spriteEnabled;
        return sprite;
    }

    public static Widget createSprite(int parentIndex, int disabled, int enabled) {
        int index = Widget.getFreeIndex();
        if (index < 0) {
            throw new IllegalStateException("Interface cache full; expand the size of the array before attempting to create a component");
        }
        return Widget.createSprite(parentIndex, index, disabled, enabled);
    }

    public static List<Widget> createContainerlessHoverButton(int x, int y, int parentIndex, int unhovered, int hovered, String tooltip) {
        Widget unhoveredButton = Widget.createSprite(parentIndex, unhovered, unhovered);
        Widget hoveredButton = Widget.createSprite(parentIndex, hovered, hovered);
        unhoveredButton.optionType = 1;
        unhoveredButton.tooltip = tooltip;
        unhoveredButton.hoverType = hoveredButton.id;
        hoveredButton.hoverType = hoveredButton.id;
        hoveredButton.drawsTransparent = true;
        Widget.addChild(x, y, cache[parentIndex], unhoveredButton);
        Widget.addChild(x, y, cache[parentIndex], hoveredButton);
        return Stream.of(unhoveredButton, hoveredButton).collect(Collectors.toList());
    }

    public static void addHoverButton(int id, int spriteId, int width, int height, String text, int contentType, int hoverType, int action) {
        Widget tab = Widget.addTabInterface(id);
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = action;
        tab.contentType = contentType;
        tab.opacity = 0;
        tab.hoverType = hoverType;
        tab.enabledSprite = Widget.imageLoaderNew(spriteId);
        tab.disabledSprite = Widget.imageLoaderNew(spriteId);
        tab.width = width;
        tab.height = height;
        tab.tooltip = text;
    }

    public static void addHoveredButton(int id, int spriteId, int width, int height, int imageId) {
        Widget tab = Widget.addTabInterface(id);
        tab.parent = id;
        tab.id = id;
        tab.type = 0;
        tab.optionType = 0;
        tab.width = width;
        tab.height = height;
        tab.invisible = true;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.scrollMax = 0;
        Widget.addHoverImage(imageId, spriteId);
        tab.totalChildren(1);
        tab.child(0, imageId, 0, 0);
    }

    public static void addHDHoverButton_sprite_loader(int i, int spriteId, int width, int height, String text, int contentType, int hoverOver, int aT) {
        Widget tab = Widget.addTabInterface(i);
        tab.id = i;
        tab.parent = i;
        tab.type = 5;
        tab.optionType = aT;
        tab.contentType = contentType;
        tab.opacity = 0;
        tab.hoverType = hoverOver;
        tab.disabledSprite = Client.spriteCache.get(spriteId);
        tab.enabledSprite = Client.spriteCache.get(spriteId);
        tab.width = width;
        tab.height = height;
        tab.tooltip = text;
        tab.hightDetail = true;
    }

    public static void addHDHoveredButton_sprite_loader(int i, int spriteId, int w, int h, int IMAGEID) {
        Widget tab = Widget.addTabInterface(i);
        tab.parent = i;
        tab.id = i;
        tab.type = 0;
        tab.optionType = 0;
        tab.width = w;
        tab.height = h;
        tab.invisible = true;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.scrollMax = 0;
        Widget.addHDHoverImage_sprite_loader(IMAGEID, spriteId);
        tab.totalChildren(1);
        tab.child(0, IMAGEID, 0, 0);
    }

    public static void addHDHoverImage_sprite_loader(int i, int spriteId) {
        Widget tab = Widget.addTabInterface(i);
        tab.id = i;
        tab.parent = i;
        tab.type = 5;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.width = 512;
        tab.height = 334;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.hightDetail = true;
        tab.disabledSprite = Client.spriteCache.get(spriteId);
        tab.enabledSprite = Client.spriteCache.get(spriteId);
    }

    public static void addHoverImage_sprite_loader(int id, int spriteId) {
        Widget tab = Widget.addTabInterface(id);
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.width = 512;
        tab.height = 334;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = Client.spriteCache.get(spriteId);
        tab.disabledSprite = Client.spriteCache.get(spriteId);
    }

    public static void addHDSprites(int id, int spriteId) {
        Widget widget = Widget.addInterface(id);
        widget.id = id;
        widget.parent = id;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.hoverType = 52;
        widget.enabledSprite = Client.spriteCache.get(spriteId);
        widget.disabledSprite = Client.spriteCache.get(spriteId);
        widget.hightDetail = true;
        widget.opacity = (byte)64;
        widget.width = 512;
        widget.height = 334;
    }

    public static void addHoverImage(int i, int spriteId) {
        Widget tab = Widget.addTabInterface(i);
        tab.id = i;
        tab.parent = i;
        tab.type = 5;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.width = 512;
        tab.hoverScrollBar = true;
        tab.height = 334;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = Widget.imageLoaderNew(spriteId);
        tab.disabledSprite = Widget.imageLoaderNew(spriteId);
    }

    private static Widget createInterface(int id) {
        Widget widget;
        Widget.cache[id] = widget = new Widget();
        return widget;
    }

    public static Widget addFullScreenInterface(int id) {
        Widget rsi = Widget.createInterface(id);
        rsi.id = id;
        rsi.parent = id;
        rsi.width = 765;
        rsi.height = 503;
        return rsi;
    }

    protected static Widget createWidget(int id, int width, int height) {
        Widget widget = Widget.cache[id] = new Widget();
        widget.id = id;
        widget.parent = id;
        widget.type = 0;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.width = width;
        widget.height = height;
        widget.opacity = 0;
        widget.hoverType = -1;
        return widget;
    }

    public static Widget addTabInterface(int id) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 0;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.width = 512;
        tab.height = 700;
        tab.opacity = 0;
        tab.hoverType = -1;
        return tab;
    }

    public static Widget addTabInterface(int id, Widget toClone) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = toClone.parent;
        tab.type = toClone.type;
        tab.optionType = toClone.optionType;
        tab.contentType = toClone.contentType;
        tab.width = toClone.width;
        tab.height = toClone.height;
        tab.opacity = toClone.opacity;
        tab.hoverType = toClone.hoverType;
        return tab;
    }

    public void copyAndAddChildren(int amount) {
        int[] newChildren = new int[this.children.length + amount];
        for (int i = 0; i < this.children.length; ++i) {
            newChildren[i] = this.children[i];
        }
        this.children = newChildren;
        int[] newX = new int[this.child_x.length + amount];
        for (int i = 0; i < this.child_x.length; ++i) {
            newX[i] = this.child_x[i];
        }
        this.child_x = newX;
        int[] newY = new int[this.child_y.length + amount];
        for (int i = 0; i < this.child_y.length; ++i) {
            newY[i] = this.child_y[i];
        }
        this.child_y = newY;
    }

    protected static SimpleImage imageLoader(int id, String root) {
        long l = (StringUtils.hashSpriteName(root) << 8) + (long)id;
        SimpleImage sprite = (SimpleImage)spriteCache.get(l);
        if (sprite != null) {
            return sprite;
        }
        try {
            sprite = new SimpleImage(root + " " + id);
            spriteCache.put(sprite, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return sprite;
    }

    protected static SimpleImage imageLoaderNew(int spriteId) {
        SimpleImage sprite;
        try {
            if (spriteId == -1) {
                return null;
            }
            sprite = Client.spriteCache.get(spriteId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return sprite;
    }

    public void child(int id, int widgetId, int x, int y) {
        this.children[id] = widgetId;
        foundChildren.add(widgetId);
        this.child_x[id] = x;
        this.child_y[id] = y;
        ++this.childCount;
    }

    public void child(int widgetId, int x, int y) {
        this.children[this.childCount] = widgetId;
        foundChildren.add(widgetId);
        this.child_x[this.childCount] = x;
        this.child_y[this.childCount] = y;
        ++this.childCount;
    }

    public void totalChildren(int children) {
        this.children = new int[children];
        this.child_x = new int[children];
        this.child_y = new int[children];
    }

    private Model get_model(int opcode, int id) {
        Model model = (Model)models.get((opcode << 16) + id);
        if (model != null) {
            return model;
        }
        if (opcode == 1) {
            model = Model.get(id);
        }
        if (opcode == 2) {
            model = NpcDefinition.get(id).get_dialogue_model();
        }
        if (opcode == 3) {
            model = Client.localPlayer.get_dialogue_model();
        }
        if (opcode == 4) {
            model = ItemDefinition.get(id).get_widget_model(50);
        }
        if (opcode == 5) {
            model = null;
        }
        if (model != null) {
            models.put(model, (opcode << 16) + id);
        }
        return model;
    }

    public static SimpleImage getSprite(int i, Archive streamLoader, String s) {
        long l = (StringUtils.hashSpriteName(s) << 8) + (long)i;
        SimpleImage sprite = (SimpleImage)spriteCache.get(l);
        if (sprite != null) {
            return sprite;
        }
        try {
            sprite = new SimpleImage(streamLoader, s, i);
            spriteCache.put(sprite, l);
        }
        catch (Exception _ex) {
            return null;
        }
        return sprite;
    }

    public void set_model(boolean flag, Model model) {
        int id = 0;
        int opcode = 5;
        if (flag) {
            return;
        }
        models.clear();
        if (model != null && opcode != 4) {
            models.put(model, (opcode << 16) + id);
        }
    }

    public Model get_animated_model(int j, int k, boolean enabled) {
        Model model = enabled ? this.get_model(this.enabled_model_type, this.enabled_model_id) : this.get_model(this.model_type, this.model_id);
        if (model == null) {
            return null;
        }
        if (k == -1 && j == -1 && model.face_color == null) {
            return model;
        }
        Model model_1 = new Model(true, Animation.validate(k) & Animation.validate(j), false, model);
        if (k != -1 || j != -1) {
            model_1.skin();
        }
        if (k != -1) {
            model_1.interpolate(k);
        }
        if (j != -1) {
            model_1.interpolate(j);
        }
        model_1.light(64, 768, -50, -10, -50, true, true);
        return model_1;
    }

    public Widget() {
    }

    public Widget(int identifier, int width, int height, int type, int optionType) {
        this.id = identifier;
        this.width = width;
        this.height = height;
        this.type = type;
        this.optionType = optionType;
        Widget.cache[identifier] = this;
    }

    public static void addLunarHoverBox(int interface_id, int spriteOffset) {
        Widget RSInterface = Widget.addInterface(interface_id);
        RSInterface.id = interface_id;
        RSInterface.parent = interface_id;
        RSInterface.type = 5;
        RSInterface.optionType = 0;
        RSInterface.contentType = 0;
        RSInterface.opacity = 0;
        RSInterface.hoverType = 52;
        RSInterface.enabledSprite = Client.spriteCache.get(324 + spriteOffset);
        RSInterface.width = 500;
        RSInterface.height = 500;
        RSInterface.tooltip = "";
    }

    public static void addLunarRune(int i, int spriteOffset, String runeName) {
        Widget RSInterface = Widget.addInterface(i);
        RSInterface.type = 5;
        RSInterface.optionType = 0;
        RSInterface.contentType = 0;
        RSInterface.opacity = 0;
        RSInterface.hoverType = 52;
        RSInterface.enabledSprite = Client.spriteCache.get(232 + spriteOffset);
        RSInterface.width = 500;
        RSInterface.height = 500;
    }

    public static void addLunarText(int ID, int runeAmount, int RuneID, AdvancedFont[] font) {
        Widget rsInterface = Widget.addInterface(ID);
        rsInterface.id = ID;
        rsInterface.parent = 1151;
        rsInterface.type = 4;
        rsInterface.optionType = 0;
        rsInterface.contentType = 0;
        rsInterface.width = 0;
        rsInterface.height = 14;
        rsInterface.opacity = 0;
        rsInterface.hoverType = -1;
        rsInterface.valueCompareType = new int[1];
        rsInterface.requiredValues = new int[1];
        rsInterface.valueCompareType[0] = 3;
        rsInterface.requiredValues[0] = runeAmount;
        rsInterface.valueIndexArray = new int[1][4];
        rsInterface.valueIndexArray[0][0] = 4;
        rsInterface.valueIndexArray[0][1] = 3214;
        rsInterface.valueIndexArray[0][2] = RuneID;
        rsInterface.valueIndexArray[0][3] = 0;
        rsInterface.centerText = true;
        rsInterface.text_type = font[0];
        rsInterface.textShadow = true;
        rsInterface.defaultText = "%1/" + runeAmount;
        rsInterface.secondaryText = "";
        rsInterface.textColour = 0xC00000;
        rsInterface.secondaryColor = 49152;
    }

    public static void addLunar2RunesSmallBox(int ID, int r1, int r2, int ra1, int ra2, int rune1, int lvl, String name, String descr, AdvancedFont[] TDA, int spriteOffset, int suo, int type) {
        Widget rsInterface = Widget.addInterface(ID);
        rsInterface.id = ID;
        rsInterface.parent = 1151;
        rsInterface.type = 5;
        rsInterface.optionType = type;
        rsInterface.contentType = 0;
        rsInterface.hoverType = ID + 1;
        rsInterface.selectedTargetMask = suo;
        rsInterface.selectedActionName = "Cast On";
        rsInterface.width = 20;
        rsInterface.height = 20;
        rsInterface.tooltip = "Cast <col=65280>" + name;
        rsInterface.spellName = name;
        rsInterface.valueCompareType = new int[3];
        rsInterface.requiredValues = new int[3];
        rsInterface.valueCompareType[0] = 3;
        rsInterface.requiredValues[0] = ra1;
        rsInterface.valueCompareType[1] = 3;
        rsInterface.requiredValues[1] = ra2;
        rsInterface.valueCompareType[2] = 3;
        rsInterface.requiredValues[2] = lvl;
        rsInterface.valueIndexArray = new int[3][];
        rsInterface.valueIndexArray[0] = new int[4];
        rsInterface.valueIndexArray[0][0] = 4;
        rsInterface.valueIndexArray[0][1] = 3214;
        rsInterface.valueIndexArray[0][2] = r1;
        rsInterface.valueIndexArray[0][3] = 0;
        rsInterface.valueIndexArray[1] = new int[4];
        rsInterface.valueIndexArray[1][0] = 4;
        rsInterface.valueIndexArray[1][1] = 3214;
        rsInterface.valueIndexArray[1][2] = r2;
        rsInterface.valueIndexArray[1][3] = 0;
        rsInterface.valueIndexArray[2] = new int[3];
        rsInterface.valueIndexArray[2][0] = 1;
        rsInterface.valueIndexArray[2][1] = 6;
        rsInterface.valueIndexArray[2][2] = 0;
        rsInterface.disabledSprite = Client.spriteCache.get(285 + spriteOffset);
        rsInterface.enabledSprite = Client.spriteCache.get(246 + spriteOffset);
        Widget hover = Widget.addInterface(ID + 1);
        hover.parent = ID;
        hover.hoverType = -1;
        hover.type = 0;
        hover.opacity = 0;
        hover.scrollMax = 0;
        hover.invisible = true;
        Widget.setChildren(7, hover);
        Widget.addLunarHoverBox(ID + 2, 0);
        Widget.setBounds(ID + 2, 0, 0, 0, hover);
        Widget.addText(ID + 3, "Level " + (lvl + 1) + ": " + name, 16750623, true, true, 52, TDA, 1);
        Widget.setBounds(ID + 3, 90, 4, 1, hover);
        Widget.addText(ID + 4, descr, 11495962, true, true, 52, TDA, 0);
        Widget.setBounds(ID + 4, 90, 19, 2, hover);
        Widget.setBounds(30016, 37, 35, 3, hover);
        Widget.setBounds(rune1, 112, 35, 4, hover);
        Widget.addLunarText(ID + 5, ra1 + 1, r1, TDA);
        Widget.setBounds(ID + 5, 50, 66, 5, hover);
        Widget.addLunarText(ID + 6, ra2 + 1, r2, TDA);
        Widget.setBounds(ID + 6, 123, 66, 6, hover);
    }

    public static void addLunar3RunesSmallBox(int ID, int r1, int r2, int r3, int ra1, int ra2, int ra3, int rune1, int rune2, int lvl, String name, String descr, AdvancedFont[] TDA, int spriteOffset, int suo, int type) {
        Widget rsInterface = Widget.addInterface(ID);
        rsInterface.id = ID;
        rsInterface.parent = 1151;
        rsInterface.type = 5;
        rsInterface.optionType = type;
        rsInterface.contentType = 0;
        rsInterface.hoverType = ID + 1;
        rsInterface.selectedTargetMask = suo;
        rsInterface.selectedActionName = "Cast on";
        rsInterface.width = 20;
        rsInterface.height = 20;
        rsInterface.tooltip = "Cast <col=65280>" + name;
        rsInterface.spellName = name;
        rsInterface.valueCompareType = new int[4];
        rsInterface.requiredValues = new int[4];
        rsInterface.valueCompareType[0] = 3;
        rsInterface.requiredValues[0] = ra1;
        rsInterface.valueCompareType[1] = 3;
        rsInterface.requiredValues[1] = ra2;
        rsInterface.valueCompareType[2] = 3;
        rsInterface.requiredValues[2] = ra3;
        rsInterface.valueCompareType[3] = 3;
        rsInterface.requiredValues[3] = lvl;
        rsInterface.valueIndexArray = new int[4][];
        rsInterface.valueIndexArray[0] = new int[4];
        rsInterface.valueIndexArray[0][0] = 4;
        rsInterface.valueIndexArray[0][1] = 3214;
        rsInterface.valueIndexArray[0][2] = r1;
        rsInterface.valueIndexArray[0][3] = 0;
        rsInterface.valueIndexArray[1] = new int[4];
        rsInterface.valueIndexArray[1][0] = 4;
        rsInterface.valueIndexArray[1][1] = 3214;
        rsInterface.valueIndexArray[1][2] = r2;
        rsInterface.valueIndexArray[1][3] = 0;
        rsInterface.valueIndexArray[2] = new int[4];
        rsInterface.valueIndexArray[2][0] = 4;
        rsInterface.valueIndexArray[2][1] = 3214;
        rsInterface.valueIndexArray[2][2] = r3;
        rsInterface.valueIndexArray[2][3] = 0;
        rsInterface.valueIndexArray[3] = new int[3];
        rsInterface.valueIndexArray[3][0] = 1;
        rsInterface.valueIndexArray[3][1] = 6;
        rsInterface.valueIndexArray[3][2] = 0;
        rsInterface.disabledSprite = Client.spriteCache.get(285 + spriteOffset);
        rsInterface.enabledSprite = Client.spriteCache.get(246 + spriteOffset);
        Widget hover = Widget.addInterface(ID + 1);
        hover.parent = ID;
        hover.hoverType = -1;
        hover.type = 0;
        hover.opacity = 0;
        hover.scrollMax = 0;
        hover.invisible = true;
        Widget.setChildren(9, hover);
        Widget.addLunarHoverBox(ID + 2, 0);
        Widget.setBounds(ID + 2, 0, 0, 0, hover);
        Widget.addText(ID + 3, "Level " + (lvl + 1) + ": " + name, 16750623, true, true, 52, TDA, 1);
        Widget.setBounds(ID + 3, 90, 4, 1, hover);
        Widget.addText(ID + 4, descr, 11495962, true, true, 52, TDA, 0);
        Widget.setBounds(ID + 4, 90, 19, 2, hover);
        Widget.setBounds(30016, 14, 35, 3, hover);
        Widget.setBounds(rune1, 74, 35, 4, hover);
        Widget.setBounds(rune2, 130, 35, 5, hover);
        Widget.addLunarText(ID + 5, ra1 + 1, r1, TDA);
        Widget.setBounds(ID + 5, 26, 66, 6, hover);
        Widget.addLunarText(ID + 6, ra2 + 1, r2, TDA);
        Widget.setBounds(ID + 6, 87, 66, 7, hover);
        Widget.addLunarText(ID + 7, ra3 + 1, r3, TDA);
        Widget.setBounds(ID + 7, 142, 66, 8, hover);
    }

    public static void runesBox3(int id, String spellName, String desc, int level, int rune1, int rune1amt, int rune2, int rune2amt, int rune3, int rune3amt) {
        Widget.cache[id] = new Widget();
        Widget.cache[id].id = id;
        Widget.cache[id].height = 76;
        Widget.cache[id].width = 182;
        Widget.cache[id].contentType = 0;
        Widget.cache[id].optionType = 0;
        Widget.cache[id].hoverType = -1;
        Widget.cache[id].type = 0;
        Widget.cache[id].invisible = true;
        Widget.addText(id + 1, "Level " + level + " " + spellName, fonts, 1, 16685087, true, true);
        Widget.addText(id + 2, desc, fonts, 0, 11495962, true, true);
        Widget.addText(id + 6, "%1/" + (rune1amt + 1), fonts, 0, 0xC00000, true, true);
        Widget.cache[id + 6].textColour = 49152;
        Widget.cache[id + 6].defaultText = "%1/" + (rune1amt + 1);
        Widget.cache[id + 6].contentType = 0;
        Widget.cache[id + 6].valueCompareType = new int[]{rune1amt};
        Widget.cache[id + 6].requiredValues = new int[]{3};
        Widget.cache[id + 6].valueIndexArray = new int[][]{{4, 3214, rune1, 0}};
        Widget.addText(id + 7, "%1/" + (rune2amt + 1), fonts, 0, 0xC00000, true, true);
        Widget.cache[id + 7].textColour = 49152;
        Widget.cache[id + 7].defaultText = "%1/" + (rune2amt + 1);
        Widget.cache[id + 7].contentType = 0;
        Widget.cache[id + 7].valueCompareType = new int[]{rune2amt};
        Widget.cache[id + 7].requiredValues = new int[]{3};
        Widget.cache[id + 7].valueIndexArray = new int[][]{{4, 3214, rune2, 0}};
        Widget.addText(id + 8, "%1/" + (rune3amt + 1), fonts, 0, 0xC00000, true, true);
        Widget.cache[id + 8].textColour = 49152;
        Widget.cache[id + 8].defaultText = "%1/" + (rune3amt + 1);
        Widget.cache[id + 8].contentType = 0;
        Widget.cache[id + 8].valueCompareType = new int[]{rune3amt};
        Widget.cache[id + 8].requiredValues = new int[]{3};
        Widget.cache[id + 8].valueIndexArray = new int[][]{{4, 3214, rune3, 0}};
        Widget.addText(id + 10, "%1/1", fonts, 0, 0xC00000, true, true);
        Widget.cache[id + 10].textColour = 49152;
        Widget.cache[id + 10].defaultText = "%1/1";
        Widget.cache[id + 10].contentType = 0;
        Widget.cache[id + 10].valueCompareType = new int[]{1};
        Widget.cache[id + 10].requiredValues = new int[]{3};
        Widget.cache[id + 10].valueIndexArray = new int[][]{{10, 1688, 13867, 10, 1688, 13869, 10, 1688, 13941, 10, 1688, 13943, 0}};
        Widget.setChildren(11, cache[id]);
        Widget.setBounds(id, 0, 0, 0, cache[id]);
        Widget.setBounds(id + 1, 91, 5, 1, cache[id]);
        Widget.setBounds(id + 2, 91, 18, 2, cache[id]);
        Widget.setBounds(id + 3, 9, 36, 3, cache[id]);
        Widget.setBounds(id + 4, 49, 36, 4, cache[id]);
        Widget.setBounds(id + 5, 88, 36, 5, cache[id]);
        Widget.setBounds(id + 6, 24, 63, 6, cache[id]);
        Widget.setBounds(id + 7, 64, 63, 7, cache[id]);
        Widget.setBounds(id + 8, 105, 63, 8, cache[id]);
        Widget.setBounds(id + 9, 130, 30, 9, cache[id]);
        Widget.setBounds(id + 10, 145, 63, 10, cache[id]);
    }

    public static void addLunar3RunesBigBox(int ID, int r1, int r2, int r3, int ra1, int ra2, int ra3, int rune1, int rune2, int lvl, String name, String descr, AdvancedFont[] TDA, int spriteOffset, int suo, int type) {
        Widget rsInterface = Widget.addInterface(ID);
        rsInterface.id = ID;
        rsInterface.parent = 1151;
        rsInterface.type = 5;
        rsInterface.optionType = type;
        rsInterface.contentType = 0;
        rsInterface.hoverType = ID + 1;
        rsInterface.selectedTargetMask = suo;
        rsInterface.selectedActionName = "Cast on";
        rsInterface.width = 20;
        rsInterface.height = 20;
        rsInterface.tooltip = "Cast <col=65280>" + name;
        rsInterface.spellName = name;
        rsInterface.valueCompareType = new int[4];
        rsInterface.requiredValues = new int[4];
        rsInterface.valueCompareType[0] = 3;
        rsInterface.requiredValues[0] = ra1;
        rsInterface.valueCompareType[1] = 3;
        rsInterface.requiredValues[1] = ra2;
        rsInterface.valueCompareType[2] = 3;
        rsInterface.requiredValues[2] = ra3;
        rsInterface.valueCompareType[3] = 3;
        rsInterface.requiredValues[3] = lvl;
        rsInterface.valueIndexArray = new int[4][];
        rsInterface.valueIndexArray[0] = new int[4];
        rsInterface.valueIndexArray[0][0] = 4;
        rsInterface.valueIndexArray[0][1] = 3214;
        rsInterface.valueIndexArray[0][2] = r1;
        rsInterface.valueIndexArray[0][3] = 0;
        rsInterface.valueIndexArray[1] = new int[4];
        rsInterface.valueIndexArray[1][0] = 4;
        rsInterface.valueIndexArray[1][1] = 3214;
        rsInterface.valueIndexArray[1][2] = r2;
        rsInterface.valueIndexArray[1][3] = 0;
        rsInterface.valueIndexArray[2] = new int[4];
        rsInterface.valueIndexArray[2][0] = 4;
        rsInterface.valueIndexArray[2][1] = 3214;
        rsInterface.valueIndexArray[2][2] = r3;
        rsInterface.valueIndexArray[2][3] = 0;
        rsInterface.valueIndexArray[3] = new int[3];
        rsInterface.valueIndexArray[3][0] = 1;
        rsInterface.valueIndexArray[3][1] = 6;
        rsInterface.valueIndexArray[3][2] = 0;
        rsInterface.disabledSprite = Client.spriteCache.get(285 + spriteOffset);
        rsInterface.enabledSprite = Client.spriteCache.get(246 + spriteOffset);
        Widget hover = Widget.addInterface(ID + 1);
        hover.parent = ID;
        hover.hoverType = -1;
        hover.type = 0;
        hover.opacity = 0;
        hover.scrollMax = 0;
        hover.invisible = true;
        Widget.setChildren(9, hover);
        Widget.addLunarHoverBox(ID + 2, 1);
        Widget.setBounds(ID + 2, 0, 0, 0, hover);
        Widget.addText(ID + 3, "Level " + (lvl + 1) + ": " + name, 16750623, true, true, 52, TDA, 1);
        Widget.setBounds(ID + 3, 90, 4, 1, hover);
        Widget.addText(ID + 4, descr, 11495962, true, true, 52, TDA, 0);
        Widget.setBounds(ID + 4, 90, 21, 2, hover);
        Widget.setBounds(30016, 14, 48, 3, hover);
        Widget.setBounds(rune1, 74, 48, 4, hover);
        Widget.setBounds(rune2, 130, 48, 5, hover);
        Widget.addLunarText(ID + 5, ra1 + 1, r1, TDA);
        Widget.setBounds(ID + 5, 26, 79, 6, hover);
        Widget.addLunarText(ID + 6, ra2 + 1, r2, TDA);
        Widget.setBounds(ID + 6, 87, 79, 7, hover);
        Widget.addLunarText(ID + 7, ra3 + 1, r3, TDA);
        Widget.setBounds(ID + 7, 142, 79, 8, hover);
    }

    public static void addLunar3RunesLargeBox(int ID, int r1, int r2, int r3, int ra1, int ra2, int ra3, int rune1, int rune2, int lvl, String name, String descr, AdvancedFont[] TDA, int spriteOffset, int suo, int type) {
        Widget rsInterface = Widget.addInterface(ID);
        rsInterface.id = ID;
        rsInterface.parent = 1151;
        rsInterface.type = 5;
        rsInterface.optionType = type;
        rsInterface.contentType = 0;
        rsInterface.hoverType = ID + 1;
        rsInterface.selectedTargetMask = suo;
        rsInterface.selectedActionName = "Cast on";
        rsInterface.width = 20;
        rsInterface.height = 20;
        rsInterface.tooltip = "Cast <col=65280>" + name;
        rsInterface.spellName = name;
        rsInterface.valueCompareType = new int[4];
        rsInterface.requiredValues = new int[4];
        rsInterface.valueCompareType[0] = 3;
        rsInterface.requiredValues[0] = ra1;
        rsInterface.valueCompareType[1] = 3;
        rsInterface.requiredValues[1] = ra2;
        rsInterface.valueCompareType[2] = 3;
        rsInterface.requiredValues[2] = ra3;
        rsInterface.valueCompareType[3] = 3;
        rsInterface.requiredValues[3] = lvl;
        rsInterface.valueIndexArray = new int[4][];
        rsInterface.valueIndexArray[0] = new int[4];
        rsInterface.valueIndexArray[0][0] = 4;
        rsInterface.valueIndexArray[0][1] = 3214;
        rsInterface.valueIndexArray[0][2] = r1;
        rsInterface.valueIndexArray[0][3] = 0;
        rsInterface.valueIndexArray[1] = new int[4];
        rsInterface.valueIndexArray[1][0] = 4;
        rsInterface.valueIndexArray[1][1] = 3214;
        rsInterface.valueIndexArray[1][2] = r2;
        rsInterface.valueIndexArray[1][3] = 0;
        rsInterface.valueIndexArray[2] = new int[4];
        rsInterface.valueIndexArray[2][0] = 4;
        rsInterface.valueIndexArray[2][1] = 3214;
        rsInterface.valueIndexArray[2][2] = r3;
        rsInterface.valueIndexArray[2][3] = 0;
        rsInterface.valueIndexArray[3] = new int[3];
        rsInterface.valueIndexArray[3][0] = 1;
        rsInterface.valueIndexArray[3][1] = 6;
        rsInterface.valueIndexArray[3][2] = 0;
        rsInterface.disabledSprite = Client.spriteCache.get(285 + spriteOffset);
        rsInterface.enabledSprite = Client.spriteCache.get(246 + spriteOffset);
        Widget hover = Widget.addInterface(ID + 1);
        hover.parent = ID;
        hover.hoverType = -1;
        hover.type = 0;
        hover.opacity = 0;
        hover.scrollMax = 0;
        hover.invisible = true;
        Widget.setChildren(9, hover);
        Widget.addLunarHoverBox(ID + 2, 2);
        Widget.setBounds(ID + 2, 0, 0, 0, hover);
        Widget.addText(ID + 3, "Level " + (lvl + 1) + ": " + name, 16750623, true, true, 52, TDA, 1);
        Widget.setBounds(ID + 3, 90, 4, 1, hover);
        Widget.addText(ID + 4, descr, 11495962, true, true, 52, TDA, 0);
        Widget.setBounds(ID + 4, 90, 34, 2, hover);
        Widget.setBounds(30016, 14, 61, 3, hover);
        Widget.setBounds(rune1, 74, 61, 4, hover);
        Widget.setBounds(rune2, 130, 61, 5, hover);
        Widget.addLunarText(ID + 5, ra1 + 1, r1, TDA);
        Widget.setBounds(ID + 5, 26, 92, 6, hover);
        Widget.addLunarText(ID + 6, ra2 + 1, r2, TDA);
        Widget.setBounds(ID + 6, 87, 92, 7, hover);
        Widget.addLunarText(ID + 7, ra3 + 1, r3, TDA);
        Widget.setBounds(ID + 7, 142, 92, 8, hover);
    }

    public static void addSlayerItems(int childId, int interfaceId, String[] options, int invSpritePadX, int invSpritePadY, int height, int width) {
        Widget rsi = Widget.cache[childId] = new Widget();
        rsi.actions = options == null ? null : new String[10];
        rsi.inventoryOffsetX = new int[20];
        rsi.inventoryAmounts = new int[height * width];
        rsi.inventoryItemId = new int[height * width];
        rsi.itemOpacity = new int[height * width];
        rsi.inventoryOffsetY = new int[20];
        rsi.children = new int[0];
        rsi.child_x = new int[0];
        rsi.child_y = new int[0];
        if (rsi.actions != null) {
            for (int i = 0; i < rsi.actions.length; ++i) {
                if (i >= options.length || options[i] == null) continue;
                rsi.actions[i] = options[i];
            }
        }
        rsi.centerText = true;
        rsi.filled = false;
        rsi.replaceItems = false;
        rsi.usableItems = false;
        rsi.allowSwapItems = false;
        rsi.textShadow = false;
        rsi.inventoryMarginX = invSpritePadX;
        rsi.inventoryMarginY = invSpritePadY;
        rsi.height = height;
        rsi.width = width;
        rsi.parent = childId;
        rsi.id = interfaceId;
        rsi.type = 2;
    }

    public static void addHoverButtonWConfig(int i, int spriteId, int spriteId2, int width, int height, String text, int contentType, int hoverOver, int aT, int configId, int configFrame) {
        Widget tab = Widget.addTabInterface(i);
        tab.id = i;
        tab.parent = i;
        tab.type = 5;
        tab.optionType = aT;
        tab.contentType = contentType;
        tab.opacity = 0;
        tab.hoverType = hoverOver;
        tab.width = width;
        tab.height = height;
        tab.tooltip = text;
        tab.valueCompareType = new int[1];
        tab.requiredValues = new int[1];
        tab.valueCompareType[0] = 1;
        tab.requiredValues[0] = configId;
        tab.valueIndexArray = new int[1][3];
        tab.valueIndexArray[0][0] = 5;
        tab.valueIndexArray[0][1] = configFrame;
        tab.valueIndexArray[0][2] = 0;
        if (spriteId != -1) {
            tab.disabledSprite = Client.spriteCache.get(spriteId);
        }
        if (spriteId2 != -1) {
            tab.enabledSprite = Client.spriteCache.get(spriteId2);
        }
    }

    public static void setChildren(int total, Widget widget) {
        widget.children = new int[total];
        widget.child_x = new int[total];
        widget.child_y = new int[total];
    }

    public static void setBounds(int id, int x, int y, int frame, Widget widget) {
        widget.children[frame] = id;
        widget.child_x[frame] = x;
        widget.child_y[frame] = y;
    }

    public static void configHoverButtonSpriteOutline(int id, String tooltip, int enabledSprite, int disabledSprite, int sprite, boolean active, int spriteIndex, int outlineSpriteXOffset, int outlineSpriteYOffset, int ... buttonsToDisable) {
        Widget tab = Widget.addInterface(id);
        tab.tooltip = tooltip;
        tab.optionType = 1;
        tab.type = 25;
        tab.hoveredOutlineSpriteXOffset = outlineSpriteXOffset;
        tab.hoveredOutlineSpriteYOffset = outlineSpriteYOffset;
        tab.disabledSprite = Client.spriteCache.get(enabledSprite);
        tab.enabledSprite = Client.spriteCache.get(enabledSprite);
        tab.spriteWithOutline = Client.spriteCache.get(sprite);
        tab.width = tab.disabledSprite.width;
        tab.height = tab.enabledSprite.height;
        tab.enabledAltSprite = Client.spriteCache.get(disabledSprite);
        tab.disabledAltSprite = Client.spriteCache.get(disabledSprite);
        tab.buttonsToDisable = buttonsToDisable;
        tab.active = active;
        tab.spriteOpacity = 255;
    }

    public static void addButton(int id, int sid, String spriteName, String tooltip) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 1;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = Widget.imageLoader(sid, spriteName);
        tab.disabledSprite = Widget.imageLoader(sid, spriteName);
        tab.width = tab.enabledSprite.width;
        tab.height = tab.disabledSprite.height;
        tab.tooltip = tooltip;
    }

    public static void addButton(int i, int j, String name, int W, int H, String S, int AT) {
        Widget RSInterface = Widget.addInterface(i);
        RSInterface.id = i;
        RSInterface.parent = i;
        RSInterface.type = 5;
        RSInterface.optionType = AT;
        RSInterface.contentType = 0;
        RSInterface.opacity = 0;
        RSInterface.hoverType = 52;
        RSInterface.enabledSprite = Widget.imageLoader(j, name);
        RSInterface.disabledSprite = Widget.imageLoader(j, name);
        RSInterface.width = W;
        RSInterface.height = H;
        RSInterface.tooltip = S;
    }

    public static void addRectangle(int id, int opacity, int color, boolean filled, int width, int height) {
        Widget RSInterface = Widget.addInterface(id);
        RSInterface.textColour = color;
        RSInterface.filled = filled;
        RSInterface.id = id;
        RSInterface.parent = id;
        RSInterface.type = 3;
        RSInterface.optionType = 0;
        RSInterface.contentType = 0;
        RSInterface.opacity = (byte)opacity;
        RSInterface.width = width;
        RSInterface.height = height;
    }

    public static void addSprites(int ID, int i, int i2, String name, int configId, int configFrame) {
        Widget Tab = Widget.addTabInterface(ID);
        Tab.id = ID;
        Tab.parent = ID;
        Tab.type = 5;
        Tab.optionType = 0;
        Tab.contentType = 0;
        Tab.width = 512;
        Tab.height = 334;
        Tab.opacity = 0;
        Tab.hoverType = -1;
        Tab.valueCompareType = new int[1];
        Tab.requiredValues = new int[1];
        Tab.valueCompareType[0] = 1;
        Tab.requiredValues[0] = configId;
        Tab.valueIndexArray = new int[1][3];
        Tab.valueIndexArray[0][0] = 5;
        Tab.valueIndexArray[0][1] = configFrame;
        Tab.valueIndexArray[0][2] = 0;
        Tab.enabledSprite = Widget.imageLoader(i, name);
        Tab.disabledSprite = Widget.imageLoader(i2, name);
    }

    public static void addSprites(int id, int ... spriteIds) {
        if (spriteIds.length < 2) {
            throw new IllegalStateException("Error adding sprites, not enough sprite id's provided.");
        }
        Widget component = Widget.addInterface(id);
        component.id = id;
        component.type = 20;
        component.backgroundSprites = new SimpleImage[spriteIds.length];
        for (int i = 0; i < spriteIds.length; ++i) {
            component.backgroundSprites[i] = Client.spriteCache.get(spriteIds[i]);
            if (component.backgroundSprites[i] != null) continue;
            throw new IllegalStateException("Error adding sprites, unable to find one of the images.");
        }
        component.enabledSprite = component.backgroundSprites[0];
    }

    public static void addClickableSprites(int id, String tooltip, int ... spriteIds) {
        Widget.addSprites(id, spriteIds);
        Widget component = cache[id];
        component.optionType = 4;
        component.tooltip = tooltip;
        component.width = component.backgroundSprites[0].width;
        component.height = component.backgroundSprites[0].height;
    }

    public static void handleConfigHover(Widget widget) {
        if (widget.active) {
            return;
        }
        widget.active = true;
        Widget.configHoverButtonSwitch(widget);
        Widget.disableOtherButtons(widget);
    }

    public static void configHoverButtonSwitch(Widget widget) {
        SimpleImage[] backup = new SimpleImage[]{widget.disabledSprite, widget.enabledSprite};
        widget.disabledSprite = widget.enabledAltSprite;
        widget.enabledSprite = widget.disabledAltSprite;
        widget.enabledAltSprite = backup[0];
        widget.disabledAltSprite = backup[1];
    }

    public static void disableOtherButtons(Widget widget) {
        if (widget.buttonsToDisable == null) {
            return;
        }
        for (int btn : widget.buttonsToDisable) {
            Widget btnWidget = cache[btn];
            if (!btnWidget.active) continue;
            btnWidget.active = false;
            Widget.configHoverButtonSwitch(btnWidget);
        }
    }

    public static void slider(int id, double min, double max, int icon, int background) {
        Widget widget = Widget.addInterface(id);
        widget.slider = new Slider(Client.spriteCache.get(icon), Client.spriteCache.get(background), min, max);
        widget.type = 12;
    }

    public static void keybindingDropdown(int id, int width, int defaultOption, String[] options, Dropdown d, boolean inverted) {
        Widget widget = Widget.addInterface(id);
        widget.type = 15;
        widget.dropdown = new DropdownMenu(width, true, defaultOption, options, d);
        widget.optionType = 7;
        widget.inverted = inverted;
    }

    public static void dropdownMenu(int id, int width, int defaultOption, String[] options, Dropdown d, AdvancedFont[] tda, int idx) {
        Widget.dropdownMenu(id, width, defaultOption, options, d, new int[]{855307, 0x464644, 4668722, 5326908, 7893353}, false, tda, idx);
    }

    public static void dropdownMenu(int id, int width, int defaultOption, String[] options, Dropdown d, int[] dropdownColours, boolean centerText, AdvancedFont[] tda, int idx) {
        Widget menu = Widget.addInterface(id);
        menu.type = 13;
        menu.text_type = tda[idx];
        menu.dropdown = new DropdownMenu(width, false, defaultOption, options, d);
        menu.optionType = 7;
        menu.dropdownColours = dropdownColours;
        menu.centerText = centerText;
    }

    protected static Widget addContainer(int id, int contentType, int maxItemsOnSingleRow, int rows, int xPad, int yPad, int opacity, boolean move, boolean displayAmount, boolean displayExamine, String ... actions) {
        Widget container = Widget.addTabInterface(id);
        container.parent = id;
        container.type = 2;
        container.contentType = contentType;
        container.width = maxItemsOnSingleRow;
        container.height = rows;
        container.sprites = new SimpleImage[20];
        container.inventoryOffsetX = new int[20];
        container.inventoryOffsetY = new int[20];
        container.inventoryMarginX = xPad;
        container.inventoryMarginY = yPad;
        container.inventoryItemId = new int[maxItemsOnSingleRow * rows];
        container.inventoryAmounts = new int[maxItemsOnSingleRow * rows];
        container.itemOpacity = new int[rows * maxItemsOnSingleRow];
        container.actions = actions;
        container.allowSwapItems = move;
        container.alpha = opacity;
        container.displayAmount = displayAmount;
        container.displayExamine = displayExamine;
        return container;
    }

    public static Widget addContainer(int id, int contentType, int maxItemsOnSingleRow, int rows, String ... actions) {
        Widget container = Widget.addInterface(id);
        container.parent = id;
        container.type = 2;
        container.contentType = contentType;
        container.width = maxItemsOnSingleRow;
        container.height = rows;
        container.sprites = new SimpleImage[20];
        container.inventoryOffsetX = new int[20];
        container.inventoryOffsetY = new int[20];
        container.inventoryMarginX = 17;
        container.inventoryMarginY = 4;
        container.inventoryItemId = new int[maxItemsOnSingleRow * rows];
        container.inventoryAmounts = new int[maxItemsOnSingleRow * rows];
        container.itemOpacity = new int[rows * maxItemsOnSingleRow];
        container.allowSwapItems = true;
        container.actions = actions;
        return container;
    }

    public static Widget addContainer(int id, int contentType, int width, int height, boolean collection, String ... actions) {
        Widget container = Widget.addInterface(id);
        container.parent = id;
        container.type = 2;
        container.contentType = contentType;
        container.width = width;
        container.height = height;
        container.sprites = new SimpleImage[20];
        container.inventoryOffsetX = new int[20];
        container.inventoryOffsetY = new int[20];
        container.inventoryMarginX = 13;
        container.inventoryMarginY = 5;
        container.inventoryItemId = new int[width * height];
        container.inventoryAmounts = new int[width * height];
        container.itemOpacity = new int[height * width];
        container.collection = collection;
        container.usableItems = false;
        container.centerText = true;
        container.filled = false;
        container.actions = actions;
        return container;
    }

    protected static Widget addContainer(int id, int width, int height, int xPad, int yPad, boolean move, boolean displayAmount, boolean displayExamine, String ... actions) {
        return Widget.addContainer(id, 0, width, height, xPad, yPad, 0, move, displayAmount, displayExamine, actions);
    }

    protected static Widget addContainer(int id, int width, int height, int xPad, int yPad, boolean move, String ... actions) {
        return Widget.addContainer(id, 0, width, height, xPad, yPad, 0, move, true, true, actions);
    }

    public static void itemGroup(int id, int w, int h, int x, int y) {
        Widget widget = Widget.addInterface(id);
        widget.width = w;
        widget.height = h;
        widget.inventoryItemId = new int[5000];
        widget.inventoryAmounts = new int[5000];
        widget.usableItems = false;
        widget.hasActions = false;
        widget.inventoryMarginX = x;
        widget.inventoryMarginY = y;
        widget.inventoryOffsetX = new int[20];
        widget.inventoryOffsetY = new int[20];
        widget.sprites = new SimpleImage[20];
        widget.type = 2;
    }

    public static void setScrollableItems(Widget tab, int[][] rewards) {
        Widget parent = cache[tab.parent];
        tab.contentType = 1430;
        tab.scrollMax = rewards.length * 32 + rewards.length * tab.inventoryMarginX - parent.width;
        for (int i = 0; i < rewards.length; ++i) {
            tab.inventoryItemId[i] = rewards[i][0] + 1;
            tab.inventoryAmounts[i] = rewards[i][1];
        }
    }

    public static void addOutlinedColorBox(int id, int color, int width, int height, int transparency) {
        Widget widget = Widget.addInterface(id);
        widget.width = width;
        widget.height = height;
        widget.color = color;
        widget.type = 23;
        widget.transparency = transparency;
        widget.contentType = 0;
    }

    public static void addColorBox(int id, int color, int width, int height, int transparency) {
        Widget widget = Widget.addInterface(id);
        widget.width = width;
        widget.height = height;
        widget.color = color;
        widget.type = 26;
        widget.transparency = transparency;
        widget.contentType = 0;
    }

    public static void addLine(int id, int color, int width) {
        Widget widget = Widget.addInterface(id);
        widget.width = width;
        widget.color = color;
        widget.type = 24;
        widget.contentType = 0;
    }

    public static void addSpriteArray(int startID, int[] sprites, String tooltip, int spritesPerRow, int padX, int padY) {
        Widget rsi = Widget.cache[startID] = new Widget();
        rsi.id = startID;
        rsi.parent = startID;
        rsi.type = 279;
        rsi.optionType = 1;
        rsi.contentType = 0;
        rsi.spritesToDraw = sprites;
        rsi.width = 80;
        rsi.height = 66;
        rsi.tooltip = tooltip;
        rsi.spritesPerRow = spritesPerRow;
        rsi.inventoryMarginX = padX;
        rsi.inventoryMarginY = padY;
    }

    public static void addSpellSmall2_3(int interfaceId, int rune, int secondaryRune, int thirdRune, int fourthRune, int runeAmount1, int runeAmount2, int runeAmount3, int runeAmount4, int runeChild, int secondaryRuneChild, int thirdRuneChild, int fourthRuneChild, int levelRequired, String spellName, String spellDescription, AdvancedFont[] TDA, int spellOffSprite, int spellOnSprite, int selectedMask, int type) {
        Widget widget = Widget.addInterface(interfaceId);
        widget.id = interfaceId;
        widget.parent = 1151;
        widget.type = 5;
        widget.optionType = type;
        widget.contentType = 0;
        widget.hoverType = interfaceId + 1;
        widget.selectedTargetMask = selectedMask;
        widget.selectedActionName = "Cast on";
        widget.width = 20;
        widget.height = 20;
        widget.tooltip = "Cast <col=65280>" + spellName;
        widget.spellName = spellName;
        widget.valueCompareType = new int[5];
        widget.requiredValues = new int[5];
        widget.valueCompareType[0] = 3;
        widget.requiredValues[0] = runeAmount1;
        widget.valueCompareType[1] = 3;
        widget.requiredValues[1] = runeAmount2;
        widget.valueCompareType[2] = 3;
        widget.requiredValues[2] = runeAmount3;
        widget.valueCompareType[3] = 3;
        widget.requiredValues[3] = runeAmount4;
        widget.valueCompareType[4] = 3;
        widget.requiredValues[4] = levelRequired;
        widget.valueIndexArray = new int[5][];
        widget.valueIndexArray[0] = new int[5];
        widget.valueIndexArray[0][0] = 4;
        widget.valueIndexArray[0][1] = 3214;
        widget.valueIndexArray[0][2] = rune;
        widget.valueIndexArray[0][3] = 0;
        widget.valueIndexArray[1] = new int[4];
        widget.valueIndexArray[1][0] = 4;
        widget.valueIndexArray[1][1] = 3214;
        widget.valueIndexArray[1][2] = secondaryRune;
        widget.valueIndexArray[1][3] = 0;
        widget.valueIndexArray[2] = new int[4];
        widget.valueIndexArray[2][0] = 4;
        widget.valueIndexArray[2][1] = 3214;
        widget.valueIndexArray[2][2] = thirdRune;
        widget.valueIndexArray[2][3] = 0;
        widget.valueIndexArray[3] = new int[4];
        widget.valueIndexArray[3][0] = 4;
        widget.valueIndexArray[3][1] = 3214;
        widget.valueIndexArray[3][2] = fourthRune;
        widget.valueIndexArray[3][3] = 0;
        widget.valueIndexArray[4] = new int[4];
        widget.valueIndexArray[4][0] = 1;
        widget.valueIndexArray[4][1] = 0;
        widget.valueIndexArray[4][2] = 0;
        widget.valueIndexArray[4][3] = 0;
        widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
        widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
        Widget subWidget = Widget.addInterface(interfaceId + 1);
        subWidget.invisible = true;
        subWidget.hoverType = -1;
        Widget.setChildren(11, subWidget);
        Widget.addLunarHoverBox(interfaceId + 2, 0);
        Widget.setBounds(interfaceId + 2, 0, 0, 0, subWidget);
        Widget.addText(interfaceId + 3, "Level " + (levelRequired + 1) + ": " + spellName, 16750623, true, true, 52, TDA, 1);
        Widget.setBounds(interfaceId + 3, 90, 4, 1, subWidget);
        Widget.addText(interfaceId + 4, spellDescription, 11495962, true, true, 52, TDA, 0);
        Widget.setBounds(interfaceId + 4, 90, 19, 2, subWidget);
        Widget.setBounds(runeChild, 15, 35, 3, subWidget);
        Widget.setBounds(secondaryRuneChild, 55, 35, 4, subWidget);
        Widget.setBounds(thirdRuneChild, 95, 35, 5, subWidget);
        Widget.setBounds(fourthRuneChild, 135, 35, 6, subWidget);
        Widget.addRuneText(interfaceId + 5, runeAmount1, rune, TDA);
        Widget.setBounds(interfaceId + 5, 29, 66, 7, subWidget);
        Widget.addRuneText(interfaceId + 6, runeAmount2, secondaryRune, TDA);
        Widget.setBounds(interfaceId + 6, 69, 66, 8, subWidget);
        Widget.addRuneText(interfaceId + 7, runeAmount3, thirdRune, TDA);
        Widget.setBounds(interfaceId + 7, 109, 66, 9, subWidget);
        Widget.addRuneText(interfaceId + 8, runeAmount4, fourthRune, TDA);
        Widget.setBounds(interfaceId + 8, 149, 66, 10, subWidget);
    }

    public static void addSpellLarge2(int interfaceId, int rune, int secondaryRune, int thirdRune, int runeAmount1, int runeAmount2, int runeAmount3, int runeChild, int secondaryRuneChild, int thirdRuneChild, int lvl, String spellName, String spellDescription, AdvancedFont[] font, int spellOffSprite, int spellOnSprite, int selectedMask, int type) {
        Widget widget = Widget.addInterface(interfaceId);
        widget.id = interfaceId;
        widget.parent = 1151;
        widget.type = 5;
        widget.optionType = type;
        widget.contentType = 0;
        widget.hoverType = interfaceId + 1;
        widget.selectedTargetMask = selectedMask;
        widget.selectedActionName = "Cast on";
        widget.width = 20;
        widget.height = 20;
        widget.tooltip = spellName.contains("Bounty") ? "Cast <col=65280>Teleport to Bounty Target" : "Cast <col=65280>" + spellName;
        widget.spellName = spellName;
        widget.valueCompareType = new int[4];
        widget.requiredValues = new int[4];
        widget.valueCompareType[0] = 3;
        widget.requiredValues[0] = runeAmount1;
        widget.valueCompareType[1] = 3;
        widget.requiredValues[1] = runeAmount2;
        widget.valueCompareType[2] = 3;
        widget.requiredValues[2] = runeAmount3;
        widget.valueCompareType[3] = 3;
        widget.requiredValues[3] = lvl;
        widget.valueIndexArray = new int[4][];
        widget.valueIndexArray[0] = new int[4];
        widget.valueIndexArray[0][0] = 4;
        widget.valueIndexArray[0][1] = 3214;
        widget.valueIndexArray[0][2] = rune;
        widget.valueIndexArray[0][3] = 0;
        widget.valueIndexArray[1] = new int[4];
        widget.valueIndexArray[1][0] = 4;
        widget.valueIndexArray[1][1] = 3214;
        widget.valueIndexArray[1][2] = secondaryRune;
        widget.valueIndexArray[1][3] = 0;
        widget.valueIndexArray[2] = new int[4];
        widget.valueIndexArray[2][0] = 4;
        widget.valueIndexArray[2][1] = 3214;
        widget.valueIndexArray[2][2] = thirdRune;
        widget.valueIndexArray[2][3] = 0;
        widget.valueIndexArray[3] = new int[3];
        widget.valueIndexArray[3][0] = 1;
        widget.valueIndexArray[3][1] = 0;
        widget.valueIndexArray[3][2] = 0;
        widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
        widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
        Widget subWidget = Widget.addInterface(interfaceId + 1);
        subWidget.invisible = true;
        subWidget.hoverType = -1;
        Widget.setChildren(9, subWidget);
        Widget.addLunarHoverBox(interfaceId + 2, 2);
        Widget.setBounds(interfaceId + 2, 0, 0, 0, subWidget);
        Widget.addText(interfaceId + 3, "Level " + (lvl + 1) + ": " + spellName, 16750623, true, true, 52, font, 1);
        Widget.setBounds(interfaceId + 3, 90, 4, 1, subWidget);
        Widget.addText(interfaceId + 4, spellDescription, 11495962, true, true, 52, font, 0);
        Widget.setBounds(interfaceId + 4, 90, 34, 2, subWidget);
        Widget.setBounds(runeChild, 14, 61, 3, subWidget);
        Widget.setBounds(secondaryRuneChild, 74, 61, 4, subWidget);
        Widget.setBounds(thirdRuneChild, 130, 61, 5, subWidget);
        Widget.addRuneText(interfaceId + 5, runeAmount1, rune, font);
        Widget.setBounds(interfaceId + 5, 26, 92, 6, subWidget);
        Widget.addRuneText(interfaceId + 6, runeAmount2, secondaryRune, font);
        Widget.setBounds(interfaceId + 6, 87, 92, 7, subWidget);
        Widget.addRuneText(interfaceId + 7, runeAmount3, thirdRune, font);
        Widget.setBounds(interfaceId + 7, 142, 92, 8, subWidget);
    }

    public static void addSpellSmall2(int interfaceId, int rune, int secondaryRune, int thirdRune, int runeAmount, int runeAmount2, int runeAmount3, int runeChild, int secondaryRuneChild, int thirdRuneChild, int levelRequirement, String spellName, String spellDescription, AdvancedFont[] font, int spellOffSprite, int spellOnSprite, int selectedMask, int optionType) {
        Widget widget = Widget.addInterface(interfaceId);
        widget.id = interfaceId;
        widget.parent = 1151;
        widget.type = 5;
        widget.optionType = optionType;
        widget.contentType = 0;
        widget.hoverType = interfaceId + 1;
        widget.selectedTargetMask = selectedMask;
        widget.selectedActionName = "Cast on";
        widget.width = 20;
        widget.height = 20;
        widget.tooltip = "Cast <col=65280>" + spellName;
        widget.spellName = spellName;
        widget.valueCompareType = new int[4];
        widget.requiredValues = new int[4];
        widget.valueCompareType[0] = 3;
        widget.requiredValues[0] = runeAmount;
        widget.valueCompareType[1] = 3;
        widget.requiredValues[1] = runeAmount2;
        widget.valueCompareType[2] = 3;
        widget.requiredValues[2] = runeAmount3;
        widget.valueCompareType[3] = 3;
        widget.requiredValues[3] = levelRequirement;
        widget.valueIndexArray = new int[4][];
        widget.valueIndexArray[0] = new int[4];
        widget.valueIndexArray[0][0] = 4;
        widget.valueIndexArray[0][1] = 3214;
        widget.valueIndexArray[0][2] = rune;
        widget.valueIndexArray[0][3] = 0;
        widget.valueIndexArray[1] = new int[4];
        widget.valueIndexArray[1][0] = 4;
        widget.valueIndexArray[1][1] = 3214;
        widget.valueIndexArray[1][2] = secondaryRune;
        widget.valueIndexArray[1][3] = 0;
        widget.valueIndexArray[2] = new int[4];
        widget.valueIndexArray[2][0] = 4;
        widget.valueIndexArray[2][1] = 3214;
        widget.valueIndexArray[2][2] = thirdRune;
        widget.valueIndexArray[2][3] = 0;
        widget.valueIndexArray[3] = new int[3];
        widget.valueIndexArray[3][0] = 1;
        widget.valueIndexArray[3][1] = 6;
        widget.valueIndexArray[3][2] = 0;
        widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
        widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
        Widget subWidget = Widget.addInterface(interfaceId + 1);
        subWidget.invisible = true;
        subWidget.hoverType = -1;
        Widget.setChildren(9, subWidget);
        Widget.addLunarHoverBox(interfaceId + 2, 0);
        Widget.setBounds(interfaceId + 2, 0, 0, 0, subWidget);
        Widget.addText(interfaceId + 3, "Level " + (levelRequirement + 1) + ": " + spellName, 16750623, true, true, 52, font, 1);
        Widget.setBounds(interfaceId + 3, 90, 4, 1, subWidget);
        Widget.addText(interfaceId + 4, spellDescription, 11495962, true, true, 52, font, 0);
        Widget.setBounds(interfaceId + 4, 90, 19, 2, subWidget);
        Widget.setBounds(runeChild, 14, 35, 3, subWidget);
        Widget.setBounds(secondaryRuneChild, 74, 35, 4, subWidget);
        Widget.setBounds(thirdRuneChild, 130, 35, 5, subWidget);
        Widget.addRuneText(interfaceId + 5, runeAmount, rune, font);
        Widget.setBounds(interfaceId + 5, 26, 66, 6, subWidget);
        Widget.addRuneText(interfaceId + 6, runeAmount2, secondaryRune, font);
        Widget.setBounds(interfaceId + 6, 87, 66, 7, subWidget);
        Widget.addRuneText(interfaceId + 7, runeAmount3, thirdRune, font);
        Widget.setBounds(interfaceId + 7, 142, 66, 8, subWidget);
    }

    public static void addSpellSmaller(int interfaceId, int rune, int secondaryRune, int runeAmount, int secondaryRuneAmount, int runeChild, int secondaryRuneChild, int levelRequirement, String spellName, String spellDescription, AdvancedFont[] font, int spellOffSprite, int spellOnSprite, int targetMask, int type, boolean spell) {
        Widget widget = Widget.addInterface(interfaceId);
        widget.id = interfaceId;
        widget.valueIndexArray = new int[3][];
        int index = 0;
        widget.valueIndexArray[0] = new int[4 + 3 * CombinationRunes.getTotalCombinationRunes(rune)];
        widget.valueIndexArray[0][index++] = 4;
        widget.valueIndexArray[0][index++] = 3214;
        widget.valueIndexArray[0][index++] = rune;
        for (CombinationRunes combinationRunes : CombinationRunes.values()) {
            if (combinationRunes.getCombinationRunesId()[0] != rune && combinationRunes.getCombinationRunesId()[1] != rune) continue;
            widget.valueIndexArray[0][index++] = 4;
            widget.valueIndexArray[0][index++] = 3214;
            widget.valueIndexArray[0][index++] = combinationRunes.getRuneItemId();
        }
        widget.valueIndexArray[0][index++] = 0;
        index = 0;
        widget.valueIndexArray[1] = new int[4 + 3 * CombinationRunes.getTotalCombinationRunes(secondaryRune)];
        widget.valueIndexArray[1][index++] = 4;
        widget.valueIndexArray[1][index++] = 3214;
        widget.valueIndexArray[1][index++] = secondaryRune;
        for (CombinationRunes combinationRunes : CombinationRunes.values()) {
            if (combinationRunes.getCombinationRunesId()[0] != secondaryRune && combinationRunes.getCombinationRunesId()[1] != secondaryRune) continue;
            widget.valueIndexArray[1][index++] = 4;
            widget.valueIndexArray[1][index++] = 3214;
            widget.valueIndexArray[1][index++] = combinationRunes.getRuneItemId();
        }
        widget.valueIndexArray[1][index++] = 0;
        widget.valueIndexArray[2] = new int[3];
        widget.valueIndexArray[2][0] = 1;
        widget.valueIndexArray[2][1] = 6;
        widget.valueIndexArray[2][2] = 0;
        if (spell) {
            widget.parent = 1151;
            widget.type = 5;
            widget.optionType = type;
            widget.contentType = 0;
            widget.hoverType = interfaceId + 1;
            widget.selectedTargetMask = targetMask;
            widget.selectedActionName = "Cast on";
            widget.width = 20;
            widget.height = 20;
            widget.tooltip = "Cast <col=65280>" + spellName;
            widget.spellName = spellName;
            widget.valueCompareType = new int[3];
            widget.requiredValues = new int[3];
            widget.valueCompareType[0] = 3;
            widget.requiredValues[0] = runeAmount - 1;
            widget.valueCompareType[1] = 3;
            widget.requiredValues[1] = secondaryRuneAmount - 1;
            widget.valueCompareType[2] = 3;
            widget.requiredValues[2] = levelRequirement;
            widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
            widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
        } else {
            widget.parent = interfaceId;
            widget.type = 5;
            widget.optionType = 1;
            widget.contentType = 0;
            widget.opacity = 0;
            widget.hoverType = 52;
            widget.valueCompareType = new int[3];
            widget.requiredValues = new int[3];
            widget.valueCompareType[0] = 3;
            widget.requiredValues[0] = runeAmount - 1;
            widget.valueCompareType[1] = 3;
            widget.requiredValues[1] = secondaryRuneAmount - 1;
            widget.valueCompareType[2] = 3;
            widget.requiredValues[2] = levelRequirement;
            widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
            widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
            widget.width = 20;
            widget.height = 20;
            widget.tooltip = "Select";
            widget.hoverType = interfaceId + 1;
        }
        Widget subWidget = Widget.addInterface(interfaceId + 1);
        subWidget.invisible = true;
        subWidget.hoverType = -1;
        Widget.setChildren(7, subWidget);
        Widget.addLunarHoverBox(interfaceId + 2, 0);
        Widget.setBounds(interfaceId + 2, 0, 0, 0, subWidget);
        Widget.addText(interfaceId + 3, "Level " + (levelRequirement + 1) + ": " + spellName, 16750623, true, true, 52, font, 1);
        Widget.setBounds(interfaceId + 3, 90, 4, 1, subWidget);
        Widget.addText(interfaceId + 4, spellDescription, 11495962, true, true, 52, font, 0);
        Widget.setBounds(interfaceId + 4, 90, 19, 2, subWidget);
        Widget.setBounds(runeChild, 40, 35, 3, subWidget);
        Widget.setBounds(secondaryRuneChild, 110, 35, 4, subWidget);
        Widget.addRuneText(interfaceId + 5, runeAmount, rune, font);
        Widget.setBounds(interfaceId + 5, 53, 66, 5, subWidget);
        Widget.addRuneText(interfaceId + 6, secondaryRuneAmount, secondaryRune, font);
        Widget.setBounds(interfaceId + 6, 124, 66, 6, subWidget);
    }

    public static void addSpellSmall(int interfaceId, int rune, int secondaryRune, int thirdRune, int runeAmount, int secondaryRuneAmount, int thirdRuneAmount, int runeChild, int secondaryRuneChild, int thirdRuneChild, int levelRequirement, String spellName, String spellDescription, AdvancedFont[] font, int spellOffSprite, int spellOnSprite, int selectedMask, int type, boolean spell) {
        Widget widget = Widget.addInterface(interfaceId);
        widget.id = interfaceId;
        widget.valueIndexArray = new int[4][];
        int index = 0;
        widget.valueIndexArray[0] = new int[4 + 3 * CombinationRunes.getTotalCombinationRunes(rune)];
        widget.valueIndexArray[0][index++] = 4;
        widget.valueIndexArray[0][index++] = 3214;
        widget.valueIndexArray[0][index++] = rune;
        for (CombinationRunes combinationRunes : CombinationRunes.values()) {
            if (combinationRunes.getCombinationRunesId()[0] != rune && combinationRunes.getCombinationRunesId()[1] != rune) continue;
            widget.valueIndexArray[0][index++] = 4;
            widget.valueIndexArray[0][index++] = 3214;
            widget.valueIndexArray[0][index++] = combinationRunes.getRuneItemId();
        }
        widget.valueIndexArray[0][index++] = 0;
        index = 0;
        widget.valueIndexArray[1] = new int[4 + 3 * CombinationRunes.getTotalCombinationRunes(secondaryRune)];
        widget.valueIndexArray[1][index++] = 4;
        widget.valueIndexArray[1][index++] = 3214;
        widget.valueIndexArray[1][index++] = secondaryRune;
        for (CombinationRunes combinationRunes : CombinationRunes.values()) {
            if (combinationRunes.getCombinationRunesId()[0] != secondaryRune && combinationRunes.getCombinationRunesId()[1] != secondaryRune) continue;
            widget.valueIndexArray[1][index++] = 4;
            widget.valueIndexArray[1][index++] = 3214;
            widget.valueIndexArray[1][index++] = combinationRunes.getRuneItemId();
        }
        widget.valueIndexArray[1][index++] = 0;
        index = 0;
        widget.valueIndexArray[2] = new int[4 + 3 * CombinationRunes.getTotalCombinationRunes(thirdRune)];
        widget.valueIndexArray[2][index++] = 4;
        widget.valueIndexArray[2][index++] = 3214;
        widget.valueIndexArray[2][index++] = thirdRune;
        for (CombinationRunes combinationRunes : CombinationRunes.values()) {
            if (combinationRunes.getCombinationRunesId()[0] != thirdRune && combinationRunes.getCombinationRunesId()[1] != thirdRune) continue;
            widget.valueIndexArray[2][index++] = 4;
            widget.valueIndexArray[2][index++] = 3214;
            widget.valueIndexArray[2][index++] = combinationRunes.getRuneItemId();
        }
        widget.valueIndexArray[2][index++] = 0;
        widget.valueIndexArray[3] = new int[3];
        widget.valueIndexArray[3][0] = 1;
        widget.valueIndexArray[3][1] = 6;
        widget.valueIndexArray[3][2] = 0;
        if (spell) {
            widget.parent = 1151;
            widget.type = 5;
            widget.optionType = type;
            widget.contentType = 0;
            widget.hoverType = interfaceId + 1;
            widget.selectedTargetMask = selectedMask;
            widget.selectedActionName = "Cast on";
            widget.width = 20;
            widget.height = 20;
            widget.tooltip = "Cast <col=65280>" + spellName;
            widget.spellName = spellName;
            widget.valueCompareType = new int[4];
            widget.requiredValues = new int[4];
            widget.valueCompareType[0] = 3;
            widget.requiredValues[0] = runeAmount - 1;
            widget.valueCompareType[1] = 3;
            widget.requiredValues[1] = secondaryRuneAmount - 1;
            widget.valueCompareType[2] = 3;
            widget.requiredValues[2] = thirdRuneAmount - 1;
            widget.valueCompareType[3] = 3;
            widget.requiredValues[3] = levelRequirement;
            widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
            widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
        } else {
            widget.parent = interfaceId;
            widget.type = 5;
            widget.optionType = 1;
            widget.contentType = 0;
            widget.opacity = 0;
            widget.hoverType = 52;
            widget.valueCompareType = new int[4];
            widget.requiredValues = new int[4];
            widget.valueCompareType[0] = 3;
            widget.requiredValues[0] = runeAmount - 1;
            widget.valueCompareType[1] = 3;
            widget.requiredValues[1] = secondaryRuneAmount - 1;
            widget.valueCompareType[2] = 3;
            widget.requiredValues[2] = thirdRuneAmount - 1;
            widget.valueCompareType[3] = 3;
            widget.requiredValues[3] = levelRequirement;
            widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
            widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
            widget.width = 20;
            widget.height = 20;
            widget.tooltip = "Select";
            widget.hoverType = interfaceId + 1;
        }
        Widget subWidget = Widget.addInterface(interfaceId + 1);
        subWidget.invisible = true;
        subWidget.hoverType = -1;
        Widget.setChildren(9, subWidget);
        Widget.addLunarHoverBox(interfaceId + 2, 0);
        Widget.setBounds(interfaceId + 2, 0, 0, 0, subWidget);
        Widget.addText(interfaceId + 3, "Level " + (levelRequirement + 1) + ": " + spellName, 16750623, true, true, 52, font, 1);
        Widget.setBounds(interfaceId + 3, 90, 4, 1, subWidget);
        Widget.addText(interfaceId + 4, spellDescription, 11495962, true, true, 52, font, 0);
        Widget.setBounds(interfaceId + 4, 90, 19, 2, subWidget);
        Widget.setBounds(runeChild, 14, 35, 3, subWidget);
        Widget.setBounds(secondaryRuneChild, 74, 35, 4, subWidget);
        Widget.setBounds(thirdRuneChild, 130, 35, 5, subWidget);
        Widget.addRuneText(interfaceId + 5, runeAmount, rune, font);
        Widget.setBounds(interfaceId + 5, 26, 66, 6, subWidget);
        Widget.addRuneText(interfaceId + 6, secondaryRuneAmount, secondaryRune, font);
        Widget.setBounds(interfaceId + 6, 87, 66, 7, subWidget);
        Widget.addRuneText(interfaceId + 7, thirdRuneAmount, thirdRune, font);
        Widget.setBounds(interfaceId + 7, 145, 66, 8, subWidget);
    }

    public static void addSpellBig2(int interfaceId, int rune, int secondaryRune, int thirdRune, int runeAmount, int secondaryRuneAmount, int thirdRuneAmount, int runeChild, int secondaryRuneChild, int thirdRuneChild, int levelRequirement, String spellName, String spellDescription, AdvancedFont[] font, int spellOffSprite, int spellOnSprite, int selectedMask, int type) {
        Widget widget = Widget.addInterface(interfaceId);
        widget.id = interfaceId;
        widget.parent = 1151;
        widget.type = 5;
        widget.optionType = type;
        widget.contentType = 0;
        widget.hoverType = interfaceId + 1;
        widget.selectedTargetMask = selectedMask;
        widget.selectedActionName = "Cast on";
        widget.width = 20;
        widget.height = 20;
        widget.tooltip = "Cast <col=65280>" + spellName;
        widget.spellName = spellName;
        widget.valueCompareType = new int[4];
        widget.requiredValues = new int[4];
        widget.valueCompareType[0] = 3;
        widget.requiredValues[0] = runeAmount;
        widget.valueCompareType[1] = 3;
        widget.requiredValues[1] = secondaryRuneAmount;
        widget.valueCompareType[2] = 3;
        widget.requiredValues[2] = thirdRuneAmount;
        widget.valueCompareType[3] = 3;
        widget.requiredValues[3] = levelRequirement;
        widget.valueIndexArray = new int[4][];
        widget.valueIndexArray[0] = new int[4];
        widget.valueIndexArray[0][0] = 4;
        widget.valueIndexArray[0][1] = 3214;
        widget.valueIndexArray[0][2] = rune;
        widget.valueIndexArray[0][3] = 0;
        widget.valueIndexArray[1] = new int[4];
        widget.valueIndexArray[1][0] = 4;
        widget.valueIndexArray[1][1] = 3214;
        widget.valueIndexArray[1][2] = secondaryRune;
        widget.valueIndexArray[1][3] = 0;
        widget.valueIndexArray[2] = new int[4];
        widget.valueIndexArray[2][0] = 4;
        widget.valueIndexArray[2][1] = 3214;
        widget.valueIndexArray[2][2] = thirdRune;
        widget.valueIndexArray[2][3] = 0;
        widget.valueIndexArray[3] = new int[3];
        widget.valueIndexArray[3][0] = 1;
        widget.valueIndexArray[3][1] = 6;
        widget.valueIndexArray[3][2] = 0;
        widget.enabledSprite = Client.spriteCache.get(spellOffSprite);
        widget.disabledSprite = Client.spriteCache.get(spellOnSprite);
        Widget subWidget = Widget.addInterface(interfaceId + 1);
        subWidget.invisible = true;
        subWidget.hoverType = -1;
        Widget.setChildren(9, subWidget);
        Widget.addLunarHoverBox(interfaceId + 2, 1);
        Widget.setBounds(interfaceId + 2, 0, 0, 0, subWidget);
        Widget.addText(interfaceId + 3, "Level " + levelRequirement + ": " + spellName, 16750623, true, true, 52, font, 1);
        Widget.setBounds(interfaceId + 3, 90, 4, 1, subWidget);
        Widget.addText(interfaceId + 4, spellDescription, 11495962, true, true, 52, font, 0);
        Widget.setBounds(interfaceId + 4, 90, 21, 2, subWidget);
        Widget.setBounds(runeChild, 14, 48, 3, subWidget);
        Widget.setBounds(secondaryRuneChild, 74, 48, 4, subWidget);
        Widget.setBounds(thirdRuneChild, 130, 48, 5, subWidget);
        Widget.addRuneText(interfaceId + 5, runeAmount, rune, font);
        Widget.setBounds(interfaceId + 5, 26, 79, 6, subWidget);
        Widget.addRuneText(interfaceId + 6, secondaryRuneAmount, secondaryRune, font);
        Widget.setBounds(interfaceId + 6, 87, 79, 7, subWidget);
        Widget.addRuneText(interfaceId + 7, thirdRuneAmount, thirdRune, font);
        Widget.setBounds(interfaceId + 7, 142, 79, 8, subWidget);
    }

    public static void addRuneText(int interfaceId, int runeAmount, int runeId, AdvancedFont[] font) {
        Widget widget = Widget.addInterface(interfaceId);
        widget.id = interfaceId;
        widget.parent = 1151;
        widget.type = 4;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.width = 0;
        widget.height = 14;
        widget.opacity = 0;
        widget.hoverType = -1;
        widget.valueCompareType = new int[1];
        widget.requiredValues = new int[1];
        widget.valueCompareType[0] = 3;
        widget.requiredValues[0] = runeAmount;
        widget.valueIndexArray = new int[1][4];
        widget.valueIndexArray[0][0] = 4;
        widget.valueIndexArray[0][1] = 3214;
        widget.valueIndexArray[0][2] = runeId;
        widget.valueIndexArray[0][3] = 0;
        widget.centerText = true;
        widget.text_type = font[0];
        widget.textShadow = true;
        widget.defaultText = "%1/" + runeAmount;
        widget.secondaryText = "";
        widget.textColour = 0xC00000;
        widget.secondaryColor = 49152;
    }

    protected static void addInputField(int identity, int characterLimit, int color, String text, int width, int height, boolean asterisks, boolean updatesEveryInput, String regex) {
        Widget field = Widget.addFullScreenInterface(identity);
        field.id = identity;
        field.type = 16;
        field.optionType = 8;
        field.defaultText = text;
        field.width = width;
        field.height = height;
        field.characterLimit = characterLimit;
        field.textColour = color;
        field.displayAsterisks = asterisks;
        field.tooltip = text;
        field.defaultInputFieldText = text;
        field.updatesEveryInput = updatesEveryInput;
        field.inputRegex = regex;
    }

    public static void addInputField(int identity, int characterLimit, int color, String text, int width, int height, boolean asterisks, boolean updatesEveryInput) {
        Widget field = Widget.addFullScreenInterface(identity);
        field.id = identity;
        field.type = 16;
        field.optionType = 8;
        field.defaultText = text;
        field.width = width;
        field.height = height;
        field.characterLimit = characterLimit;
        field.textColour = color;
        field.displayAsterisks = asterisks;
        field.defaultInputFieldText = text;
        field.tooltips = new String[]{"Clear", "Edit"};
        field.updatesEveryInput = updatesEveryInput;
    }

    public static void addInputField(int identity, int characterLimit, int color, String text, int width, int height, boolean asterisks) {
        Widget field = Widget.addFullScreenInterface(identity);
        field.id = identity;
        field.type = 16;
        field.optionType = 8;
        field.defaultText = text;
        field.width = width;
        field.height = height;
        field.characterLimit = characterLimit;
        field.textColour = color;
        field.displayAsterisks = asterisks;
        field.defaultInputFieldText = text;
        field.tooltips = new String[]{"Clear", "Edit"};
    }

    public static void addCloseButton(int child, int hoverChild, int hoverImageChild) {
        Widget.addHoverButtonWSpriteLoader(child, 68, 16, 16, "Close", 250, hoverChild, 3);
        Widget.addHoveredImageWSpriteLoader(hoverChild, 69, 16, 16, hoverImageChild);
    }

    public static void addHoverButtonWSpriteLoader(int interfaceId, int spriteId, int width, int height, String text, int contentType, int hoverOver, int aT) {
        Widget tab = Widget.addTabInterface(interfaceId);
        tab.id = interfaceId;
        tab.parent = interfaceId;
        tab.type = 5;
        tab.optionType = aT;
        tab.contentType = contentType;
        tab.opacity = 0;
        tab.hoverType = hoverOver;
        tab.enabledSprite = Client.spriteCache.get(spriteId);
        tab.disabledSprite = Client.spriteCache.get(spriteId);
        tab.width = width;
        tab.height = height;
        tab.tooltip = text;
    }

    public static void addHoveredImageWSpriteLoader(int interfaceId, int spriteId, int w, int h, int imgInterface) {
        Widget tab = Widget.addTabInterface(interfaceId);
        tab.id = interfaceId;
        tab.parent = interfaceId;
        tab.type = 0;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.scrollMax = 0;
        tab.invisible = true;
        tab.width = w;
        tab.height = h;
        Widget.addHoverImageWSpriteLoader(imgInterface, spriteId);
        tab.totalChildren(1);
        tab.child(0, imgInterface, 0, 0);
    }

    public static void addHoverImageWSpriteLoader(int interfaceId, int spriteId) {
        Widget tab = Widget.addTabInterface(interfaceId);
        tab.id = interfaceId;
        tab.parent = interfaceId;
        tab.type = 5;
        tab.optionType = 0;
        tab.contentType = 0;
        tab.width = 512;
        tab.height = 334;
        tab.opacity = 0;
        tab.hoverType = 52;
        tab.enabledSprite = Client.spriteCache.get(spriteId);
        tab.disabledSprite = Client.spriteCache.get(spriteId);
    }

    public static void addButtonWSpriteLoader(int id, int sprite, String tooltip, int w, int h) {
        Widget tab = Widget.cache[id] = new Widget();
        tab.id = id;
        tab.parent = id;
        tab.type = 5;
        tab.optionType = 1;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = 52;
        if (sprite != -1) {
            tab.disabledSprite = Client.spriteCache.get(sprite);
            tab.enabledSprite = Client.spriteCache.get(sprite);
        }
        tab.width = w;
        tab.height = h;
        tab.tooltip = tooltip;
    }

    public static void darken(int identity, int width, int height, int color, byte transparency) {
        Widget component = Widget.addInterface(identity);
        component.id = identity;
        component.type = 22;
        component.width = width;
        component.height = height;
        component.fillColor = color;
        component.opacity = transparency;
    }

    public void children(int id, int child, int x, int y) {
        this.children[id] = child;
        this.child_x[id] = x;
        this.child_y[id] = y;
    }

    public static void addBankItem(int index) {
        Widget widget = Widget.cache[index] = new Widget();
        widget.actions = new String[5];
        widget.inventoryOffsetX = new int[20];
        widget.inventoryAmounts = new int[30];
        widget.inventoryItemId = new int[30];
        widget.itemOpacity = new int[30];
        widget.inventoryOffsetY = new int[20];
        widget.children = new int[0];
        widget.child_x = new int[0];
        widget.child_y = new int[0];
        widget.inventoryMarginX = 24;
        widget.inventoryMarginY = 24;
        widget.height = 5;
        widget.width = 6;
        widget.parent = 5292;
        widget.id = index;
        widget.type = 2;
    }

    protected static void addFamiliarHead(int interfaceID, int width, int height, int zoom) {
        Widget widget = Widget.addTabInterface(interfaceID);
        widget.type = 6;
        widget.model_type = 2;
        widget.model_id = 2449;
        widget.modelZoom = zoom;
        widget.modelRotation1 = 40;
        widget.modelRotation2 = 1800;
        widget.height = height;
        widget.width = width;
    }

    public static void addButton1(int i, int parent, int w, int h, int sprite1, int sprite2, int hoverOver, String tooltip, int itemId, boolean geSearch) {
        Widget p = Widget.addInterface(i);
        p.parent = parent;
        p.type = 5;
        p.optionType = 1;
        p.width = w;
        p.height = h;
        p.tooltip = tooltip;
        p.defaultText = tooltip;
        p.hoverType = hoverOver;
        p.isHovered = true;
        p.disabledSprite = Client.spriteCache.get(sprite1);
        p.enabledSprite = Client.spriteCache.get(sprite2);
        p.itemId = itemId;
        p.geSearchButton = geSearch;
    }

    public static void addSelection(int id, AdvancedFont[] font, Widget parent, int x, int y, int menuId) {
        Widget.addButton1(id + 1, 41002, 161, 32, 1262, 1262, id + 2, "", menuId, true);
        Widget.addText(id + 3, "Item name", font, 1, 0, false, false);
        Widget.addText(id + 2, "", font, 1, 0, false, false);
        parent.child(parentchilds++, id + 1, x, y);
        parent.child(parentchilds++, id + 2, x + 40, y + 8);
        parent.child(parentchilds++, id + 3, x + 40, y + 8);
    }

    public static void addPet(int ID) {
        Widget petCanvas = Widget.cache[ID] = new Widget();
        petCanvas.id = ID;
        petCanvas.parent = ID;
        petCanvas.type = 6;
        petCanvas.optionType = 0;
        petCanvas.contentType = 3291;
        petCanvas.width = 136;
        petCanvas.height = 168;
        petCanvas.hoverType = 0;
        petCanvas.modelZoom = 1500;
        petCanvas.modelRotation1 = 150;
        petCanvas.modelRotation2 = 0;
    }

    public static void drawHoverableRectangle(int identity, int width, int height, int color, byte transparency) {
        Widget component = Widget.addInterface(identity);
        component.id = identity;
        component.type = 9;
        component.width = width;
        component.height = height;
        component.fillColor = color;
        component.opacity = transparency;
        component.optionType = 1;
    }

    public static void radioButton(int id, String tooltip, int enabledSprite, int disabledSprite, int ... relatedButtons) {
        Widget widget = Widget.addInterface(id);
        widget.tooltip = tooltip;
        widget.optionType = 1;
        widget.type = 28;
        widget.enabledSprite = Client.spriteCache.get(enabledSprite);
        widget.disabledSprite = Client.spriteCache.get(disabledSprite);
        widget.width = widget.enabledSprite.width;
        widget.height = widget.disabledSprite.height;
        widget.active = false;
        widget.buttons = relatedButtons;
    }

    public static void addHoverClickText(int id, String text, String tooltip, AdvancedFont[] font, int idx, int color, boolean center, boolean textShadow, int width) {
        Widget widget = Widget.addInterface(id);
        widget.id = id;
        widget.parent = id;
        widget.type = 4;
        widget.optionType = 1;
        widget.width = width;
        widget.height = 11;
        widget.contentType = 0;
        widget.opacity = 0;
        widget.hoverType = -1;
        widget.centerText = center;
        widget.textShadow = textShadow;
        widget.text_type = font[idx];
        widget.defaultText = text;
        widget.secondaryText = "";
        widget.tooltip = tooltip;
        widget.textColour = color;
        widget.secondaryColor = 0;
        widget.defaultHoverColor = 0xFFFFFF;
        widget.secondaryHoverColor = 0;
    }

    public static void addHDSpriteLoader(int childId, int spriteId) {
        Widget widget = Widget.cache[childId] = new Widget();
        widget.id = childId;
        widget.parent = childId;
        widget.type = 5;
        widget.optionType = 0;
        widget.contentType = 0;
        widget.disabledSprite = Client.spriteCache.get(spriteId);
        widget.enabledSprite = Client.spriteCache.get(spriteId);
        widget.width = widget.disabledSprite.width;
        widget.height = widget.enabledSprite.height - 2;
        widget.hightDetail = true;
    }

    public static void addItemModel(int interfaceId, int itemId, int w, int h, int zoom) {
        Widget widget = Widget.cache[interfaceId] = new Widget();
        ItemDefinition itemDef = ItemDefinition.get(itemId);
        widget.modelRotation1 = itemDef.xan2d;
        widget.modelRotation2 = itemDef.yan2d;
        widget.type = 6;
        widget.model_type = 4;
        widget.model_id = itemId;
        widget.modelZoom = zoom;
        widget.height = h;
        widget.width = w;
    }

    static {
        models = new ReferenceCache(30);
        parentchilds = 0;
        achievementChild = 0;
        achievementY = 0;
        radioButtons = new ArrayList();
        foundIDS = new ArrayList<Integer>();
        foundChildren = new ArrayList<Integer>();
        displayedTeleportSprites = new int[0];
    }
}

