/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.client_content.content;

import com.ornate.Client;
import com.ornate.draw.Rasterizer3D;

public class SnowFlake {
    private boolean touched;
    private boolean melting;
    private boolean moving;
    private int x;
    private int y;
    private int cycle;
    private int radius;
    private int alpha;
    private int lifespan;
    private static SnowFlake[] snowflakes;
    private static boolean snowing;

    private SnowFlake(int x, int y, int radius) {
        this(x, y);
        this.radius = radius;
        this.alpha = 100 + SnowFlake.random(100);
    }

    private SnowFlake(int x, int y) {
        this.x = x;
        this.y = y;
        this.moving = true;
        this.lifespan = Client.currentScreenMode == Client.ScreenMode.FIXED ? 250 + SnowFlake.random(350) : 150 + SnowFlake.random(250);
    }

    private void draw(int x, int y) {
        Rasterizer3D.drawFilledCircle(this.x + x - this.radius / 2, this.y + y - this.radius / 2, this.radius, 0xFFFFFF, this.alpha);
    }

    private void reset() {
        this.x = SnowFlake.random(Client.currentScreenMode == Client.ScreenMode.FIXED ? 765 : Client.currentGameWidth);
        this.y = -10;
        this.cycle = 0;
        this.moving = true;
        this.touched = false;
        this.lifespan = Client.currentScreenMode == Client.ScreenMode.FIXED ? 250 + SnowFlake.random(250) : 150 + SnowFlake.random(250);
        this.radius = 4 + SnowFlake.random(2);
        this.alpha = 100 + SnowFlake.random(100);
    }

    private static int random(int range) {
        return (int)(Math.random() * (double)(range + 1));
    }

    private void adjustX(int x) {
        this.x += x;
    }

    private void adjustY(int y) {
        this.y += y;
    }

    private int getX() {
        return this.x;
    }

    private int getY() {
        return this.y;
    }

    private int getCycle() {
        return this.cycle;
    }

    private void resetCycle() {
        this.cycle = 0;
    }

    private void cycle() {
        ++this.cycle;
    }

    private int getRadius() {
        return this.radius;
    }

    private boolean isMoving() {
        return this.moving;
    }

    private void adjustAlpha(int alpha) {
        this.alpha += alpha;
        if (this.alpha < 0) {
            this.alpha = 0;
        }
        if (this.alpha > 256) {
            this.alpha = 256;
        }
    }

    private int getAlpha() {
        return this.alpha;
    }

    private boolean isMelted() {
        return this.alpha == 0 && !this.moving;
    }

    private int getLifespan() {
        return this.lifespan;
    }

    private boolean isMelting() {
        return this.melting;
    }

    private void setMelting(boolean melting) {
        this.melting = melting;
    }

    private boolean touched() {
        return Client.inCircle(this.x - (this.radius * 2 - this.radius / 2), this.y - (this.radius * 2 - this.radius / 2), Client.singleton.cursor_x, Client.singleton.cursor_y, this.radius);
    }

    private boolean wasTouched() {
        return this.touched;
    }

    private void setTouched(boolean touched) {
        this.touched = touched;
    }

    public static void createSnow() {
        snowflakes = new SnowFlake[30 + SnowFlake.random(20)];
        for (int index = 0; index < snowflakes.length; ++index) {
            int x = SnowFlake.random(Client.currentScreenMode == Client.ScreenMode.FIXED ? 765 : Client.currentGameWidth);
            int y_offset = 100 + SnowFlake.random(300) + index * 5;
            if (SnowFlake.random(100) < 25) {
                SnowFlake.snowflakes[index] = new SnowFlake(x, -(11 + y_offset));
                continue;
            }
            int radius = 4 + SnowFlake.random(2);
            SnowFlake.snowflakes[index] = new SnowFlake(x, -(radius + y_offset), radius);
        }
        snowing = true;
    }

    public static void processSnowflakes() {
        int melted = 0;
        for (int index = 0; index < snowflakes.length; ++index) {
            int x_adjust;
            SnowFlake flake = snowflakes[index];
            if (flake.isMelted()) {
                ++melted;
                continue;
            }
            if (!snowing) {
                if (flake.getY() + flake.getRadius() < 0) {
                    ++melted;
                    continue;
                }
                flake.setMelting(true);
                flake.setTouched(true);
            }
            flake.cycle();
            if (!flake.isMelting() && flake.getX() >= 15 && flake.getX() <= 70 && flake.getY() >= 100 && flake.getY() <= 300) {
                flake.setMelting(true);
                flake.setTouched(true);
            }
            if (flake.touched()) {
                flake.setMelting(true);
                flake.setTouched(true);
            }
            if (flake.isMelting() && (flake.getCycle() >= flake.getLifespan() && flake.getAlpha() > 0 || flake.wasTouched())) {
                flake.adjustAlpha(-4);
            }
            if (!flake.isMoving()) continue;
            int n = x_adjust = flake.getCycle() > 30 ? SnowFlake.random(2) : 0;
            if (x_adjust > 0) {
                flake.resetCycle();
            }
            int y_adjust = SnowFlake.random(2);
            flake.adjustX(SnowFlake.random(100) >= 50 ? -x_adjust : x_adjust);
            flake.adjustY(y_adjust);
            int height = flake.getRadius();
            if ((Client.currentScreenMode != Client.ScreenMode.RESIZABLE || flake.getY() < Client.gamescreen_height - SnowFlake.random(Client.gamescreen_height / 3) + height) && flake.getY() < Client.gamescreen_height + height) continue;
            flake.reset();
        }
        if (melted == snowflakes.length) {
            snowing = false;
        }
    }

    public static void drawSnowflakes(int x, int y) {
        if (snowflakes != null) {
            for (int index = 0; index < snowflakes.length; ++index) {
                SnowFlake flake = snowflakes[index];
                if (flake.isMelted()) continue;
                flake.draw(x, y);
            }
        }
    }

    static {
        snowing = Client.singleton.setting.sky_snow;
    }
}

