/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.client_content.content;

import com.ornate.Client;
import com.ornate.draw.Rasterizer2D;
import java.util.HashMap;
import java.util.Map;

public class StatusBars {
    public Restore restore = Restore.NONE;

    public void drawStatusBars(int xOffset, int yOffset) {
        if (!Client.singleton.setting.status_bars) {
            return;
        }
        int hpColor = 0;
        int prayerColor = BarType.PRAYER.getNormal();
        if (Client.singleton.poisonType == 0) {
            hpColor = BarType.HP.getNormal();
        } else if (Client.singleton.poisonType == 1) {
            hpColor = BarType.HP.getPoisoned();
        } else if (Client.singleton.poisonType == 2) {
            hpColor = BarType.HP.getVenom();
        }
        this.renderStatusBars(xOffset, yOffset, BarType.HP, hpColor);
        this.renderStatusBars(xOffset, yOffset, BarType.PRAYER, prayerColor);
    }

    public void renderStatusBars(int xOffset, int yOffset, BarType type, int backgroundColor) {
        int hitpoints = Client.singleton.currentLevels[3];
        int prayer = Client.singleton.currentLevels[5];
        int percent = StatusBars.getPercent(this.getPercent(type, 0), 250);
        Rasterizer2D.draw_rectangle_outline(xOffset + 11 + this.getBarOffsetX(type), 42 + yOffset, 20, 250, 0);
        Rasterizer2D.draw_filled_rect(xOffset + 11 + this.getBarOffsetX(type), 42 + yOffset, 20, 250, 0, 130);
        Rasterizer2D.draw_filled_rect(xOffset + 12 + this.getBarOffsetX(type), 242 - percent + 50 + yOffset, 18, percent, backgroundColor, 135);
        if (this.restore.type == type && this.restore != Restore.NONE) {
            Rasterizer2D.draw_filled_rect(xOffset + 12 + this.getBarOffsetX(type), 242 - StatusBars.getPercent(this.getPercent(type, this.restore.restore), 250) + 50 + yOffset, 18, StatusBars.getPercent(this.getPercent(type, this.restore.restore), 250), type.getHeal(), 140);
        }
        if (this.getPercent(type, 0) < 20) {
            if (Client.game_tick % 20 < 10) {
                if (type.icon == 9) {
                    Client.spriteCache.get(type.getIcon()).drawSprite(xOffset + 13 + this.getBarOffsetX(type), 50 + yOffset);
                } else if (type.icon == 10) {
                    Client.spriteCache.get(type.getIcon()).drawSprite(xOffset + 12 + this.getBarOffsetX(type), 50 + yOffset);
                }
            }
        } else if (type.icon == 9) {
            Client.spriteCache.get(type.getIcon()).drawSprite(xOffset + 13 + this.getBarOffsetX(type), 50 + yOffset);
        } else if (type.icon == 10) {
            Client.spriteCache.get(type.getIcon()).drawSprite(xOffset + 12 + this.getBarOffsetX(type), 50 + yOffset);
        }
        Client.adv_font_small.draw_centered(type == BarType.HP ? "" + hitpoints : "" + prayer, xOffset + 21 + this.getBarOffsetX(type), 80 + yOffset, 0xFFFFFF, 1);
    }

    public int getBarOffsetX(BarType type) {
        if (type == BarType.HP) {
            return Client.currentScreenMode == Client.ScreenMode.RESIZABLE ? -5 : 0;
        }
        if (type == BarType.PRAYER) {
            return Client.currentScreenMode == Client.ScreenMode.RESIZABLE ? 204 : 210;
        }
        return 0;
    }

    public static int getPercent(int current, int pixels) {
        return (int)((double)pixels * 0.01 * (double)current);
    }

    public int getPercent(BarType type, int extra) {
        if (type == BarType.HP) {
            int level = Client.singleton.currentLevels[3] + extra;
            int max = Client.singleton.maximumLevels[3];
            double percent = (double)level / (double)max;
            return level > 99 ? 100 : (int)(percent * 100.0);
        }
        if (type == BarType.PRAYER) {
            int level = Client.singleton.currentLevels[5] + extra;
            int max = Client.singleton.maximumLevels[5];
            double percent = (double)level / (double)max;
            return level > 99 ? 100 : (int)(percent * 100.0);
        }
        return 0;
    }

    public void setConsume(Restore restore) {
        this.restore = restore;
    }

    public static enum BarType {
        HP(8332046, 16740358, 37120, 16640, 9),
        PRAYER(2987153, 3764410, 10);

        private final int normal;
        private final int heal;
        private int poisoned;
        private int venom;
        private final int icon;

        public int getNormal() {
            return this.normal;
        }

        public int getHeal() {
            return this.heal;
        }

        public int getPoisoned() {
            return this.poisoned;
        }

        public int getVenom() {
            return this.venom;
        }

        public int getIcon() {
            return this.icon;
        }

        private BarType(int normal, int heal, int icon) {
            this.normal = normal;
            this.heal = heal;
            this.icon = icon;
        }

        private BarType(int normal, int heal, int poisoned, int venom, int icon) {
            this.normal = normal;
            this.heal = heal;
            this.poisoned = poisoned;
            this.venom = venom;
            this.icon = icon;
        }
    }

    public static enum Restore {
        NONE(0, 0, BarType.PRAYER),
        PRAYER_3(139, 40, BarType.PRAYER);

        private final int item;
        private final int restore;
        private final BarType type;
        private static final Map<Integer, Restore> restoreMap;

        public int getItem() {
            return this.item;
        }

        public int getRestore() {
            return this.restore;
        }

        public BarType getType() {
            return this.type;
        }

        private Restore(int item, int restore, BarType type) {
            this.item = item;
            this.restore = restore;
            this.type = type;
        }

        public static Restore get(int item) {
            return restoreMap.getOrDefault(item, NONE);
        }

        static {
            restoreMap = new HashMap<Integer, Restore>();
            for (Restore restore : Restore.values()) {
                restoreMap.put(restore.item, restore);
            }
        }
    }
}

