/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.client_content.content.account;

import com.ornate.Client;
import com.ornate.cache.graphics.SimpleImage;
import com.ornate.client_content.content.account.Account;
import com.ornate.io.Buffer;
import com.ornate.sign.SignLink;
import com.ornate.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class AccountManager {
    private static final int MAXIMUM_ACCOUNTS = 5;
    private static final Path ACCOUNTS_FILE = Paths.get(SignLink.findDataDir(), "accounts.dat");
    private final Collection<Account> accountList = new ArrayList<Account>(5);
    private final SimpleImage backgroundSprite;
    private final Client client;

    public AccountManager(Client client, SimpleImage backgroundSprite) {
        this.client = client;
        this.backgroundSprite = backgroundSprite;
    }

    public void addAccount(String userName, String userPassword) throws IOException {
        if (this.accountList.size() == 5) {
            this.client.firstLoginMessage = "Account list full!";
            this.client.secondLoginMessage = "Delete an account to create space for a new one.";
            return;
        }
        if (userName.length() == 0 || userPassword.length() == 0) {
            this.client.firstLoginMessage = "Username & Password";
            this.client.secondLoginMessage = "Must be more than 1 character";
            return;
        }
        Account accountToAdd = new Account(userName, userPassword);
        for (Account account : this.accountList) {
            if (!accountToAdd.getUserName().equals(account.getUserName())) continue;
            this.client.firstLoginMessage = "There is already an account";
            this.client.secondLoginMessage = "saved with that username.";
            return;
        }
        this.accountList.add(accountToAdd);
        this.saveAccounts();
    }

    public void processAccountDrawing() {
        int xPosition = Client.currentGameWidth / 2;
        int yPosition = Client.currentGameHeight / 2 + 145;
        xPosition -= -3 + this.accountList.size() * (this.backgroundSprite.width / 2 + (this.accountList.size() > 1 ? 10 : 0));
        for (Account account : this.accountList) {
            if (this.accountList.size() > 1) {
                xPosition += 10;
            }
            account.setXPosition(xPosition);
            account.setYPosition(yPosition);
            this.draw(account);
            xPosition += this.backgroundSprite.width + 10;
        }
    }

    public void processAccountInput() throws IOException {
        ArrayList<Account> accountsToRemove = new ArrayList<Account>();
        for (Account account : this.accountList) {
            if (this.client.click_type != 1) continue;
            if (this.client.cursor_x >= account.getXPosition() + 14 && this.client.cursor_x <= account.getXPosition() + this.backgroundSprite.width - 14 && this.client.cursor_y >= account.getYPosition() + 23 && this.client.cursor_y <= account.getYPosition() + 40) {
                accountsToRemove.add(account);
                this.client.firstLoginMessage = "Deleted Account:";
                this.client.secondLoginMessage = account.getUserName();
                continue;
            }
            if (this.client.cursor_x < account.getXPosition() || this.client.cursor_x > account.getXPosition() + this.backgroundSprite.width || this.client.cursor_y < account.getYPosition() || this.client.cursor_y > account.getYPosition() + 23) continue;
            this.client.myUsername = account.getUserName();
            this.client.setPassword(account.getUserPassword());
            this.client.login(this.client.myUsername, this.client.getPassword(), false);
        }
        if (!accountsToRemove.isEmpty()) {
            this.accountList.removeAll(accountsToRemove);
            this.saveAccounts();
        }
    }

    private void draw(Account account) {
        this.backgroundSprite.drawSprite(account.getXPosition(), account.getYPosition());
        Client.adv_font_regular.draw_centered(account.getUserName(), account.getXPosition() + this.backgroundSprite.width / 2, account.getYPosition() + 16, 0xFFFFFF, 0);
    }

    public void saveAccounts() throws IOException {
        if (this.accountList.isEmpty()) {
            Files.deleteIfExists(ACCOUNTS_FILE);
            return;
        }
        Files.deleteIfExists(ACCOUNTS_FILE);
        Files.createFile(ACCOUNTS_FILE, new FileAttribute[0]);
        Buffer buffer = Buffer.create(30000, null);
        buffer.writeByte(this.accountList.size());
        for (Account account : this.accountList) {
            buffer.writeString(account.getUserName());
            buffer.writeString(account.getUserPassword());
        }
        FileUtils.writeFile(ACCOUNTS_FILE.toString(), Arrays.copyOf(buffer.payload, buffer.pos));
    }

    public void loadAccounts() throws IOException {
        File file = ACCOUNTS_FILE.toFile();
        if (!file.exists()) {
            return;
        }
        byte[] fileData = FileUtils.read(file);
        Buffer buffer = new Buffer(fileData);
        try {
            int size = buffer.readUnsignedByte();
            for (int index = 0; index < size; ++index) {
                String userName = buffer.readString();
                String userPassword = buffer.readString();
                this.accountList.add(new Account(userName, userPassword));
            }
        }
        catch (Exception e) {
            file.delete();
            e.printStackTrace();
        }
    }
}

