/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.client_content.content.particle;

import com.ornate.client_content.content.particle.ParticleDefinition;
import com.ornate.client_content.content.particle.Vector;

public class Particle {
    private int age = 0;
    private int color;
    private float size;
    private Vector velocity;
    private float alpha;
    private float oldAlpha;
    private boolean dead = false;
    private int particleDepth;
    private ParticleDefinition def = null;
    private Vector position;

    public final void tick() {
        if (this.def != null) {
            ++this.age;
            if (this.age >= this.def.getLifeSpan()) {
                this.dead = true;
            } else {
                this.color += this.def.getColorStep();
                this.size += this.def.getSizeStep();
                this.position.addLocal(this.velocity);
                this.velocity.addLocal(this.def.getVelocityStep());
                this.alpha += this.def.getAlphaStep();
                if (this.def.getGravity() != null) {
                    this.position.addLocal(this.def.getGravity());
                }
                if (this.alpha <= 0.0f) {
                    this.alpha = 0.025f;
                }
            }
        }
    }

    public Particle(ParticleDefinition def, Vector position, int definitionID) {
        this(def.getStartColor(), def.getStartSize(), def.getStartVelocity(definitionID).clone(), def.getSpawnedShape().getPoint(ParticleDefinition.RANDOM).addLocal(position), def.getStartAlpha());
        this.def = def;
    }

    public Particle(int color, float size, Vector velocity, Vector position, float alpha) {
        this.color = color;
        this.size = size;
        this.velocity = velocity;
        this.position = position;
        this.alpha = alpha;
        this.oldAlpha = alpha;
    }

    public final int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public final float getOldAlpha() {
        return this.oldAlpha;
    }

    public final int getDepth() {
        return this.particleDepth;
    }

    public void setDepth(int particleDepth) {
        this.particleDepth = particleDepth;
    }

    public final int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public final float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public final boolean isDead() {
        return this.dead;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public final ParticleDefinition getDefinition() {
        return this.def;
    }

    public final Vector getPosition() {
        return this.position;
    }
}

