/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.client_content.settings;

import com.ornate.Client;
import com.ornate.client_content.content.Keybinding;
import com.ornate.client_content.settings.SettingData;
import com.ornate.sign.SignLink;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public class Settings {
    public static final boolean SOUNDS_ENABLED = false;
    public static final boolean MUSIC_ENABLED = false;
    public boolean enableTweening;
    public boolean status_bars = true;
    public boolean draw_fps;
    public boolean draw_special_orb = true;
    public boolean draw_orb_arc = true;
    public boolean draw_health_overlay = true;
    public boolean draw_timers = true;
    public boolean toggle_overhead_names;
    public boolean toggle_overhead_hp;
    public boolean toggle_npc_overhead_names;
    public boolean toggle_npc_overhead_hp;
    public boolean toggle_item_pile_names = true;
    public boolean moving_prayers = true;
    public boolean ground_snow;
    public boolean shift_pet_options = true;
    public boolean sky_snow;
    public int drag_item_value = 10;
    public boolean incinerator;
    public boolean hide_equipment_button;
    public boolean hide_inventory_button;
    public int player_attack_priority = 0;
    public int npc_attack_priority = 2;
    public boolean show_hit_predictor;
    public boolean show_exp_counter;
    public int counter_size = 1;
    public int counter_color = 0xFFFFFF;
    public float counter_speed = 1.0f;
    public int counter_position;
    public boolean counter_group;
    public boolean showHitPredictor;
    public boolean hidePrivateChat;
    public boolean loginLogoutNotification;
    public boolean profanityFilter;
    public boolean cameraMovement = true;
    public boolean shiftClick = true;
    public boolean esc_close = true;
    public boolean mouseButtons;
    public boolean acceptAid;
    public int brightness = 3;
    public boolean zoomToggle;
    public boolean chatEffects;
    public boolean privateChat = true;
    public boolean transparentSidePanel;
    public boolean transparentChatbox;
    public boolean sideStonesArrangement;
    public boolean roofs = false;
    public boolean orbs = true;
    public boolean sounds;
    public int sound_state = 0;
    public boolean music;
    public int music_state = 0;
    public boolean clan_indicator = false;
    private String fileLine = "";
    public String location;
    public static final int MUSIC_BUTTON_OFF = 43533;
    public static final int MUSIC_BUTTON_STATE_ONE = 43534;
    public static final int MUSIC_BUTTON_STATE_TWO = 43535;
    public static final int MUSIC_BUTTON_STATE_THREE = 43536;
    public static final int MUSIC_BUTTON_STATE_FOUR = 43537;
    public static final int SOUND_BUTTON_OFF = 43538;
    public static final int SOUND_BUTTON_STATE_ONE = 43539;
    public static final int SOUND_BUTTON_STATE_TWO = 43540;
    public static final int SOUND_BUTTON_STATE_THREE = 43541;
    public static final int SOUND_BUTTON_STATE_FOUR = 43542;
    public static final int WELCOME_SCREEN_PLAY_BUTTON = 44420;
    public static final int ADVANCED_OPTIONS_BUTTON = 42524;
    public static final int ESCAPE_CONFIG_BUTTON = 53003;
    public static final int BRIGHTNESS_STATE_ONE = 906;
    public static final int BRIGHTNESS_STATE_TWO = 908;
    public static final int BRIGHTNESS_STATE_THREE = 910;
    public static final int BRIGHTNESS_STATE_FOUR = 912;
    public static final int ZOOM_TOGGLE_BUTTON = 44151;
    public static final int RESTORE_ZOOM_BUTTON = 42521;
    public static final int FIXED_MODE_BUTTON = 42522;
    public static final int RESIZABLE_MODE_BUTTON = 42523;
    public static final int ACCEPT_AID_BUTTON = 42506;
    public static final int HOUSE_OPTIONS_BUTTON = 42508;
    public static final int BOND_POUCH_BUTTON = 42509;
    public static final int CHAT_EFFECTS_BUTTON = 42541;
    public static final int SPLIT_PRIVATE_CHAT_BUTTON = 42542;
    public static final int HIDE_PRIVATE_CHAT_BUTTON = 42543;
    public static final int MOUSE_BUTTONS_BUTTON = 42551;
    public static final int FOLLOWER_OPTIONS_BUTTON = 42553;
    public static final int PROFANITY_FILTER_BUTTON = 41541;
    public static final int NOTIFICATIONS_BUTTON = 41542;
    public static final int LOGIN_LOGOUT_NOTIFICATION_TIMEOUT_BUTTON = 41543;
    public static final int DISPLAY_NAME_BUTTON = 42544;
    public static final int KEYBINDING_BUTTON = 42552;
    public static final int MOUSE_CAMERA_BUTTON = 41551;
    public static final int SHIFT_CLICK_DROP_BUTTON = 41552;
    public static final int TRANSPARENT_SIDE_PANEL = 43007;
    public static final int TRANSPARENT_CHATBOX = 43025;
    public static final int SIDE_STONES_ARRANGEMENT = 43032;
    public static final int ROOF_REMOVAL = 43019;
    public static final int ORBS = 43022;

    public void toggleVarbits() {
        Client.singleton.toggleConfig(168, this.music_state);
        Client.singleton.toggleConfig(169, this.sound_state);
        Client.singleton.toggleConfig(166, this.brightness);
        Client.singleton.toggleConfig(289, this.profanityFilter ? 1 : 0);
        Client.singleton.toggleConfig(207, this.cameraMovement ? 1 : 0);
        Client.singleton.toggleConfig(290, this.loginLogoutNotification ? 1 : 0);
        Client.singleton.toggleConfig(288, this.hidePrivateChat ? 1 : 0);
        Client.singleton.toggleConfig(594, this.esc_close ? 1 : 0);
        Client.singleton.toggleConfig(293, this.shiftClick ? 1 : 0);
        Client.singleton.toggleConfig(427, this.acceptAid ? 1 : 0);
        Client.singleton.toggleConfig(291, this.shift_pet_options ? 1 : 0);
        Client.singleton.toggleConfig(170, this.mouseButtons ? 1 : 0);
        Client.singleton.toggleConfig(294, this.zoomToggle ? 1 : 0);
        Client.singleton.toggleConfig(171, this.chatEffects ? 1 : 0);
        Client.singleton.toggleConfig(287, this.privateChat ? 1 : 0);
        Client.singleton.toggleConfig(295, this.transparentSidePanel ? 1 : 0);
        Client.singleton.toggleConfig(296, this.transparentChatbox ? 1 : 0);
        Client.singleton.toggleConfig(297, this.sideStonesArrangement ? 1 : 0);
        Client.singleton.toggleConfig(298, this.roofs ? 1 : 0);
        Client.singleton.toggleConfig(299, this.orbs ? 1 : 0);
    }

    private void createSettingsFile(String location1) {
        File location = new File(location1);
        if (location.exists()) {
            return;
        }
        try {
            this.save();
            location.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean contains(String match) {
        String string = this.fileLine.substring(0, this.fileLine.indexOf(" = "));
        return string.equals(match);
    }

    private boolean readBoolean() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return this.fileLine.equals("true");
    }

    private String readString() {
        this.fileLine = this.fileLine.substring(this.fileLine.indexOf("=") + 2);
        return this.fileLine;
    }

    private int readInt() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return Integer.parseInt(this.fileLine);
    }

    private int readFloat() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return (int)Float.parseFloat(this.fileLine);
    }

    private Double readDouble() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return Double.parseDouble(this.fileLine);
    }

    private void writeLine(String line, String line1, BufferedWriter bw) {
        try {
            bw.write(line + " = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(String line, Boolean line1, BufferedWriter bw) {
        try {
            bw.write(line + " = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(Double line1, BufferedWriter bw) {
        try {
            bw.write("counter_speed = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(String line, int line1, BufferedWriter bw) {
        try {
            bw.write(line + " = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (this.location == null) {
            return;
        }
        try {
            FileOutputStream writer = new FileOutputStream(this.location);
            writer.write("".getBytes());
            writer.close();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.location, true));
            this.writeLine("enableTweening", this.enableTweening, bw);
            this.writeLine("status_bars", this.status_bars, bw);
            this.writeLine("draw_fps", this.draw_fps, bw);
            this.writeLine("draw_special_orb", this.draw_special_orb, bw);
            this.writeLine("draw_orb_arc", this.draw_orb_arc, bw);
            this.writeLine("draw_health_overlay", this.draw_health_overlay, bw);
            this.writeLine("draw_timers", this.draw_timers, bw);
            this.writeLine("toggle_overhead_names", this.toggle_overhead_names, bw);
            this.writeLine("toggle_overhead_hp", this.toggle_overhead_hp, bw);
            this.writeLine("toggle_npc_overhead_names", this.toggle_npc_overhead_names, bw);
            this.writeLine("toggle_npc_overhead_hp", this.toggle_npc_overhead_hp, bw);
            this.writeLine("toggle_item_pile_names", this.toggle_item_pile_names, bw);
            this.writeLine("moving_prayers", this.moving_prayers, bw);
            this.writeLine("ground_snow", this.ground_snow, bw);
            this.writeLine("shift_pet_options", this.shift_pet_options, bw);
            this.writeLine("sky_snow", this.sky_snow, bw);
            this.writeLine("drag_item_value", this.drag_item_value, bw);
            this.writeLine("incinerator", this.incinerator, bw);
            this.writeLine("hide_equipment_button", this.hide_equipment_button, bw);
            this.writeLine("hide_inventory_button", this.hide_inventory_button, bw);
            this.writeLine("player_attack_priority", this.player_attack_priority, bw);
            this.writeLine("npc_attack_priority", this.npc_attack_priority, bw);
            this.writeLine("show_hit_predictor", this.show_hit_predictor, bw);
            this.writeLine("show_exp_counter", this.show_exp_counter, bw);
            this.writeLine("counter_size", this.counter_size, bw);
            this.writeLine("counter_color", this.counter_color, bw);
            this.writeLine("counter_speed", (int)this.counter_speed, bw);
            this.writeLine("counter_position", this.counter_position, bw);
            this.writeLine("counter_group", this.counter_group, bw);
            this.writeLine("showHitPredictor", this.showHitPredictor, bw);
            this.writeLine("hidePrivateChat", this.hidePrivateChat, bw);
            this.writeLine("loginLogoutNotification", this.loginLogoutNotification, bw);
            this.writeLine("profanityFilter", this.profanityFilter, bw);
            this.writeLine("cameraMovement", this.cameraMovement, bw);
            this.writeLine("shiftClick", this.shiftClick, bw);
            this.writeLine("esc_close", this.esc_close, bw);
            this.writeLine("mouseButtons", this.mouseButtons, bw);
            this.writeLine("acceptAid", this.acceptAid, bw);
            this.writeLine("brightness", this.brightness, bw);
            this.writeLine("zoomToggle", this.zoomToggle, bw);
            this.writeLine("chatEffects", this.chatEffects, bw);
            this.writeLine("privateChat", this.privateChat, bw);
            this.writeLine("transparentSidePanel", this.transparentSidePanel, bw);
            this.writeLine("transparentChatbox", this.transparentChatbox, bw);
            this.writeLine("sideStonesArrangement", this.sideStonesArrangement, bw);
            this.writeLine("roofs", this.roofs, bw);
            this.writeLine("orbs", this.orbs, bw);
            this.writeLine("sounds", this.sounds, bw);
            this.writeLine("sound_state", this.sound_state, bw);
            this.writeLine("music", this.music, bw);
            this.writeLine("music_state", this.music_state, bw);
            this.writeLine("cameraSpeed", Client.cameraSpeed, bw);
            this.writeLine("keybinds", Arrays.toString(Keybinding.KEYBINDINGS), bw);
            this.writeLine("zoom_distance", Client.zoom_distance, bw);
            this.writeLine("clan_indicator", this.clan_indicator, bw);
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void load() {
        this.location = SignLink.findDataDir() + "/settings.txt";
        this.createSettingsFile(this.location);
        try {
            String line;
            BufferedReader file = new BufferedReader(new FileReader(this.location));
            while ((line = file.readLine()) != null) {
                this.fileLine = line;
                if (this.contains("enableTweening")) {
                    this.enableTweening = this.readBoolean();
                    continue;
                }
                if (this.contains("status_bars")) {
                    this.status_bars = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_fps")) {
                    this.draw_fps = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_special_orb")) {
                    this.draw_special_orb = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_orb_arc")) {
                    this.draw_orb_arc = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_health_overlay")) {
                    this.draw_health_overlay = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_timers")) {
                    this.draw_timers = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_overhead_names")) {
                    this.toggle_overhead_names = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_overhead_hp")) {
                    this.toggle_overhead_hp = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_npc_overhead_names")) {
                    this.toggle_npc_overhead_names = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_npc_overhead_hp")) {
                    this.toggle_npc_overhead_hp = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_item_pile_names")) {
                    this.toggle_item_pile_names = this.readBoolean();
                    continue;
                }
                if (this.contains("moving_prayers")) {
                    this.moving_prayers = this.readBoolean();
                    continue;
                }
                if (this.contains("ground_snow")) {
                    this.ground_snow = this.readBoolean();
                    continue;
                }
                if (this.contains("shift_pet_options")) {
                    this.shift_pet_options = this.readBoolean();
                    continue;
                }
                if (this.contains("sky_snow")) {
                    this.sky_snow = this.readBoolean();
                    continue;
                }
                if (this.contains("drag_item_value")) {
                    this.drag_item_value = this.readInt();
                    continue;
                }
                if (this.contains("incinerator")) {
                    this.incinerator = this.readBoolean();
                    continue;
                }
                if (this.contains("hide_equipment_button")) {
                    this.hide_equipment_button = this.readBoolean();
                    continue;
                }
                if (this.contains("hide_inventory_button")) {
                    this.hide_inventory_button = this.readBoolean();
                    continue;
                }
                if (this.contains("player_attack_priority")) {
                    this.player_attack_priority = this.readInt();
                    continue;
                }
                if (this.contains("npc_attack_priority")) {
                    this.npc_attack_priority = this.readInt();
                    continue;
                }
                if (this.contains("show_hit_predictor")) {
                    this.show_hit_predictor = this.readBoolean();
                    continue;
                }
                if (this.contains("show_exp_counter")) {
                    this.show_exp_counter = this.readBoolean();
                    continue;
                }
                if (this.contains("counter_size")) {
                    this.counter_size = this.readInt();
                    continue;
                }
                if (this.contains("counter_color")) {
                    this.counter_color = this.readInt();
                    continue;
                }
                if (this.contains("counter_speed")) {
                    this.counter_speed = this.readFloat();
                    continue;
                }
                if (this.contains("counter_position")) {
                    this.counter_position = this.readInt();
                    continue;
                }
                if (this.contains("counter_group")) {
                    this.counter_group = this.readBoolean();
                    continue;
                }
                if (this.contains("hidePrivateChat")) {
                    this.hidePrivateChat = this.readBoolean();
                    continue;
                }
                if (this.contains("loginLogoutNotification")) {
                    this.loginLogoutNotification = this.readBoolean();
                    continue;
                }
                if (this.contains("profanityFilter")) {
                    this.profanityFilter = this.readBoolean();
                    continue;
                }
                if (this.contains("cameraMovement")) {
                    this.cameraMovement = this.readBoolean();
                    continue;
                }
                if (this.contains("shiftClick")) {
                    this.shiftClick = this.readBoolean();
                    continue;
                }
                if (this.contains("esc_close")) {
                    this.esc_close = this.readBoolean();
                    continue;
                }
                if (this.contains("mouseButtons")) {
                    this.mouseButtons = this.readBoolean();
                    continue;
                }
                if (this.contains("acceptAid")) {
                    this.acceptAid = this.readBoolean();
                    continue;
                }
                if (this.contains("brightness")) {
                    this.brightness = this.readInt();
                    continue;
                }
                if (this.contains("zoomToggle")) {
                    this.zoomToggle = this.readBoolean();
                    continue;
                }
                if (this.contains("chatEffects")) {
                    this.chatEffects = this.readBoolean();
                    continue;
                }
                if (this.contains("privateChat")) {
                    this.privateChat = this.readBoolean();
                    continue;
                }
                if (this.contains("transparentSidePanel")) {
                    this.transparentSidePanel = this.readBoolean();
                    continue;
                }
                if (this.contains("transparentChatbox")) {
                    this.transparentChatbox = this.readBoolean();
                    continue;
                }
                if (this.contains("sideStonesArrangement")) {
                    this.sideStonesArrangement = this.readBoolean();
                    continue;
                }
                if (this.contains("roofs")) {
                    this.roofs = this.readBoolean();
                    continue;
                }
                if (this.contains("orbs")) {
                    this.orbs = this.readBoolean();
                    continue;
                }
                if (this.contains("sounds")) {
                    this.sounds = this.readBoolean();
                    continue;
                }
                if (this.contains("sound_state")) {
                    this.sound_state = this.readInt();
                    continue;
                }
                if (this.contains("music")) {
                    this.music = this.readBoolean();
                    continue;
                }
                if (this.contains("music_state")) {
                    this.music_state = this.readInt();
                    continue;
                }
                if (this.contains("cameraSpeed")) {
                    Client.cameraSpeed = this.readString();
                    continue;
                }
                if (this.contains("keybinds")) {
                    String array = this.readString();
                    array = array.substring(1, array.length() - 1);
                    String[] entries = array.split(",");
                    for (int index = 0; index < Keybinding.KEYBINDINGS.length; ++index) {
                        Keybinding.KEYBINDINGS[index] = Integer.parseInt(entries[index].trim());
                    }
                    continue;
                }
                if (this.contains("zoom_distance")) {
                    Client.zoom_distance = this.readInt();
                    continue;
                }
                if (!this.contains("clan_indicator")) continue;
                this.clan_indicator = this.readBoolean();
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        int length = SettingData.values().length;
        for (int index = 0; index < length; ++index) {
            SettingData setting = SettingData.forOrdinal(index);
            if (setting == null) {
                return;
            }
            Client.singleton.updateString(setting.setting, 50301 + index);
            Client.singleton.toggleConfig(900 + index, setting.status() ? 1 : 0);
        }
        this.save();
    }

    public boolean click(Client client, int button) {
        int base_button = 50301;
        int index = button - base_button;
        SettingData settingData = SettingData.forOrdinal(index);
        if (index < SettingData.values().length && settingData != null) {
            settingData.handle(client);
            this.update();
            return true;
        }
        base_button = 50350;
        index = button - base_button;
        settingData = SettingData.forOrdinal(index);
        if (index < SettingData.values().length && settingData != null) {
            settingData.handle(client);
            this.update();
            return true;
        }
        return false;
    }

    public boolean settingButtons(int button) {
        switch (button) {
            case 53003: {
                this.esc_close = !this.esc_close;
                Client.singleton.toggleConfig(594, this.esc_close ? 1 : 0);
                return true;
            }
            case 912: {
                Client.singleton.toggleConfig(505, 0);
                Client.singleton.toggleConfig(506, 0);
                Client.singleton.toggleConfig(507, 0);
                Client.singleton.toggleConfig(508, 1);
                Client.singleton.toggleConfig(166, 4);
                this.brightness = 4;
                return true;
            }
            case 910: {
                Client.singleton.toggleConfig(505, 0);
                Client.singleton.toggleConfig(506, 0);
                Client.singleton.toggleConfig(507, 1);
                Client.singleton.toggleConfig(508, 0);
                Client.singleton.toggleConfig(166, 3);
                this.brightness = 3;
                return true;
            }
            case 908: {
                Client.singleton.toggleConfig(505, 0);
                Client.singleton.toggleConfig(506, 1);
                Client.singleton.toggleConfig(507, 0);
                Client.singleton.toggleConfig(508, 0);
                Client.singleton.toggleConfig(166, 2);
                this.brightness = 2;
                return true;
            }
            case 906: {
                Client.singleton.toggleConfig(505, 1);
                Client.singleton.toggleConfig(506, 0);
                Client.singleton.toggleConfig(507, 0);
                Client.singleton.toggleConfig(508, 0);
                Client.singleton.toggleConfig(166, 1);
                this.brightness = 1;
                return true;
            }
            case 42553: {
                this.shift_pet_options = !this.shift_pet_options;
                Client.singleton.toggleConfig(291, this.shift_pet_options ? 1 : 0);
                return true;
            }
            case 42551: {
                this.mouseButtons = !this.mouseButtons;
                Client.singleton.toggleConfig(170, this.mouseButtons ? 1 : 0);
                return true;
            }
            case 42506: {
                this.acceptAid = !this.acceptAid;
                Client.singleton.toggleConfig(427, this.acceptAid ? 1 : 0);
                return true;
            }
            case 42522: {
                Client.singleton.frameMode(765, 503);
                return true;
            }
            case 42523: {
                Client.singleton.frameMode(766, 559);
                return true;
            }
            case 42508: {
                return true;
            }
            case 42509: {
                return true;
            }
            case 42521: {
                return true;
            }
            case 44151: {
                this.zoomToggle = !this.zoomToggle;
                Client.singleton.toggleConfig(294, this.zoomToggle ? 1 : 0);
                return true;
            }
            case 42541: {
                this.chatEffects = !this.chatEffects;
                Client.singleton.toggleConfig(171, this.chatEffects ? 1 : 0);
                return true;
            }
            case 42542: {
                this.privateChat = !this.privateChat;
                Client.singleton.toggleConfig(287, this.privateChat ? 1 : 0);
                return true;
            }
            case 42543: {
                this.hidePrivateChat = !this.hidePrivateChat;
                Client.singleton.toggleConfig(288, this.hidePrivateChat ? 1 : 0);
                return true;
            }
            case 41541: {
                this.profanityFilter = !this.profanityFilter;
                Client.singleton.toggleConfig(289, this.profanityFilter ? 1 : 0);
                return true;
            }
            case 41542: 
            case 42544: {
                return true;
            }
            case 41543: {
                this.loginLogoutNotification = !this.loginLogoutNotification;
                Client.singleton.toggleConfig(290, this.loginLogoutNotification ? 1 : 0);
                return true;
            }
            case 41551: {
                this.cameraMovement = !this.cameraMovement;
                Client.singleton.toggleConfig(207, this.cameraMovement ? 1 : 0);
                return true;
            }
            case 41552: {
                this.shiftClick = !this.shiftClick;
                Client.singleton.toggleConfig(293, this.shiftClick ? 1 : 0);
                return true;
            }
            case 43022: {
                this.orbs = !this.orbs;
                Client.singleton.toggleConfig(299, this.orbs ? 1 : 0);
                String data_orbs = this.orbs ? "on" : "off";
                Client.singleton.sendString("Data orbs (currently " + data_orbs + ")", 43024);
                return true;
            }
            case 43007: {
                this.transparentSidePanel = !this.transparentSidePanel;
                Client.singleton.toggleConfig(295, this.transparentSidePanel ? 1 : 0);
                break;
            }
            case 43025: {
                this.transparentChatbox = !this.transparentChatbox;
                Client.singleton.toggleConfig(296, this.transparentChatbox ? 1 : 0);
                return true;
            }
            case 43032: {
                this.sideStonesArrangement = !this.sideStonesArrangement;
                Client.singleton.toggleConfig(297, this.sideStonesArrangement ? 1 : 0);
                return true;
            }
            case 43019: {
                this.roofs = !this.roofs;
                Client.singleton.toggleConfig(298, this.roofs ? 1 : 0);
                String roof_removal = this.roofs ? "on" : "off";
                Client.singleton.sendString("Always hide roofs (currently " + roof_removal + ")", 43021);
                return true;
            }
            case 43039: {
                Client.tabInterfaceIDs[11] = 50290;
                Client.update_tab_producer = true;
                return true;
            }
            case 50293: {
                Client.tabInterfaceIDs[11] = 42500;
                Client.update_tab_producer = true;
                return true;
            }
            case 43533: {
                Client.singleton.toggleConfig(168, 0);
                this.music_state = 0;
                return true;
            }
            case 43534: {
                Client.singleton.sendMessage("Music is currently disabled.", 0, "");
                return true;
            }
            case 43535: {
                Client.singleton.sendMessage("Music is currently disabled.", 0, "");
                return true;
            }
            case 43536: {
                Client.singleton.sendMessage("Music is currently disabled.", 0, "");
                return true;
            }
            case 43537: {
                Client.singleton.sendMessage("Music is currently disabled.", 0, "");
                return true;
            }
            case 43538: {
                Client.singleton.toggleConfig(169, 0);
                this.sound_state = 0;
                return true;
            }
            case 43539: {
                Client.singleton.sendMessage("Sounds are currently disabled.", 0, "");
                return true;
            }
            case 43540: {
                Client.singleton.sendMessage("Sounds are currently disabled.", 0, "");
                return true;
            }
            case 43541: {
                Client.singleton.sendMessage("Sounds are currently disabled.", 0, "");
                return true;
            }
            case 43542: {
                Client.singleton.sendMessage("Sounds are currently disabled.", 0, "");
                return true;
            }
        }
        return false;
    }
}

