/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.collection;

import com.ornate.collection.Linkable;

public final class HashTable {
    private final int size;
    private final Linkable[] cache;

    public HashTable() {
        this.size = 1024;
        this.cache = new Linkable[this.size];
        for (int index = 0; index < this.size; ++index) {
            Linkable node;
            node.previous = node = (this.cache[index] = new Linkable());
            node.next = node;
        }
    }

    public Linkable get(long key) {
        Linkable bucket = this.cache[(int)(key & (long)(this.size - 1))];
        Linkable node = bucket.previous;
        while (node != bucket) {
            if (node.key == key) {
                return node;
            }
            node = node.previous;
        }
        return null;
    }

    public void clear() {
        for (int id = 0; id < this.size; ++id) {
            Linkable next;
            Linkable link = this.cache[id];
            while (link != (next = link.next)) {
                next.unlink();
            }
        }
    }

    public void put(Linkable node, long key) {
        if (node.next != null) {
            node.unlink();
        }
        Linkable bucket = this.cache[(int)(key & (long)(this.size - 1))];
        node.next = bucket.next;
        node.previous = bucket;
        node.next.previous = node;
        node.previous.next = node;
        node.key = key;
    }
}

