/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.collection;

import com.ornate.collection.Linkable;

public class RSDeque {
    private final Linkable head;
    private Linkable current;

    public RSDeque() {
        this.head.previous = this.head = new Linkable();
        this.head.next = this.head;
    }

    public void insertHead(Linkable linkable) {
        if (linkable.next != null) {
            linkable.unlink();
        }
        linkable.next = this.head.next;
        linkable.previous = this.head;
        linkable.next.previous = linkable;
        linkable.previous.next = linkable;
    }

    public void insertTail(Linkable linkable) {
        if (linkable.next != null) {
            linkable.unlink();
        }
        linkable.next = this.head;
        linkable.previous = this.head.previous;
        linkable.next.previous = linkable;
        linkable.previous.next = linkable;
    }

    public Linkable popHead() {
        Linkable node = this.head.previous;
        if (node == this.head) {
            return null;
        }
        node.unlink();
        return node;
    }

    public Linkable reverseGetFirst() {
        Linkable node = this.head.previous;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.previous;
        return node;
    }

    public Linkable getFirst() {
        Linkable node = this.head.next;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    public Linkable reverseGetNext() {
        Linkable node = this.current;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.previous;
        return node;
    }

    public Linkable getNext() {
        Linkable node = this.current;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    public void clear() {
        if (this.head.previous == this.head) {
            return;
        }
        Linkable node;
        while ((node = this.head.previous) != this.head) {
            node.unlink();
        }
        return;
    }
}

