/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.draw;

import com.ornate.draw.Rasterizer2D;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public final class ProducingGraphicsBuffer {
    public final int[] canvasRaster;
    public final int canvasWidth;
    public final int canvasHeight;
    private float[] depthbuffer;
    private final BufferedImage bufferedImage;

    public ProducingGraphicsBuffer(int canvasWidth, int canvasHeight) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.depthbuffer = new float[canvasWidth * canvasHeight];
        this.bufferedImage = new BufferedImage(canvasWidth, canvasHeight, 1);
        this.canvasRaster = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        this.init();
    }

    public void drawGraphics(int x, Graphics graphics, int y) {
        graphics.drawImage(this.bufferedImage, x, y, null);
    }

    public void init() {
        Rasterizer2D.init(this.canvasRaster, this.canvasWidth, this.canvasHeight, this.depthbuffer);
    }
}

