/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.draw;

import com.ornate.cache.graphics.SimpleImage;
import com.ornate.collection.Cacheable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Hashtable;

public class Rasterizer2D
extends Cacheable {
    private static final ColorModel COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);
    public static int[] pixels;
    public static int width;
    public static int height;
    public static int topY;
    public static int bottomY;
    public static int topX;
    public static int bottomX;
    public static int centerX2;
    public static int centerX;
    public static int centerY;
    public static float[] depth_buffer;

    public static void init(int[] pixels, int width, int height, float[] depth) {
        depth_buffer = depth;
        Rasterizer2D.pixels = pixels;
        Rasterizer2D.width = width;
        Rasterizer2D.height = height;
        Rasterizer2D.set_clip(0, 0, width, height);
    }

    public static void draw_arc(int x, int y, int width, int height, int stroke, int start, int sweep, int color, int alpha, int closure, boolean fill) {
        Graphics2D graphics = SimpleImage.createGraphics(pixels, Rasterizer2D.width, Rasterizer2D.height);
        graphics.setColor(new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha >= 256 || alpha < 0 ? 255 : alpha));
        RenderingHints render = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        render.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHints(render);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (!fill) {
            graphics.setStroke(new BasicStroke(stroke < 1 ? 1 : stroke));
        }
        Arc2D.Double arc = new Arc2D.Double(x + stroke, y + stroke, width, height, start, sweep, closure);
        if (fill) {
            graphics.fill(arc);
        } else {
            graphics.draw(arc);
        }
    }

    public static void drawTransparentGradientBox(int leftX, int topY, int width, int height, int topColour, int bottomColour, int opacity) {
        int gradientProgress = 0;
        int progressPerPixel = 65536 / height;
        if (leftX < topX) {
            width -= topX - leftX;
            leftX = topX;
        }
        if (topY < Rasterizer2D.topY) {
            gradientProgress += (Rasterizer2D.topY - topY) * progressPerPixel;
            height -= Rasterizer2D.topY - topY;
            topY = Rasterizer2D.topY;
        }
        if (leftX + width > bottomX) {
            width = bottomX - leftX;
        }
        if (topY + height > bottomY) {
            height = bottomY - topY;
        }
        int leftOver = Rasterizer2D.width - width;
        int transparency = 256 - opacity;
        int pixelIndex = leftX + topY * Rasterizer2D.width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            int gradient = 65536 - gradientProgress >> 8;
            int inverseGradient = gradientProgress >> 8;
            int gradientColour = ((topColour & 0xFF00FF) * gradient + (bottomColour & 0xFF00FF) * inverseGradient & 0xFF00FF00) + ((topColour & 0xFF00) * gradient + (bottomColour & 0xFF00) * inverseGradient & 0xFF0000) >>> 8;
            int transparentPixel = ((gradientColour & 0xFF00FF) * opacity >> 8 & 0xFF00FF) + ((gradientColour & 0xFF00) * opacity >> 8 & 0xFF00);
            for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
                int backgroundPixel = pixels[pixelIndex];
                backgroundPixel = ((backgroundPixel & 0xFF00FF) * transparency >> 8 & 0xFF00FF) + ((backgroundPixel & 0xFF00) * transparency >> 8 & 0xFF00);
                Rasterizer2D.pixels[pixelIndex++] = transparentPixel + backgroundPixel;
            }
            pixelIndex += leftOver;
            gradientProgress += progressPerPixel;
        }
    }

    public static void set_default_size() {
        topX = 0;
        topY = 0;
        bottomX = width;
        bottomY = height;
        centerX2 = bottomX;
        centerX = bottomX / 2;
    }

    public static void set_clip(int x, int y, int width, int height) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (width > Rasterizer2D.width) {
            width = Rasterizer2D.width;
        }
        if (height > Rasterizer2D.height) {
            height = Rasterizer2D.height;
        }
        topX = x;
        topY = y;
        bottomX = width;
        bottomY = height;
        centerX2 = bottomX;
        centerX = bottomX / 2;
        centerY = bottomY / 2;
    }

    public static void clear() {
        int size = width * height;
        for (int coordinates = 0; coordinates < size; ++coordinates) {
            Rasterizer2D.pixels[coordinates] = 0;
            Rasterizer2D.depth_buffer[coordinates] = Float.MAX_VALUE;
        }
    }

    public static void draw_filled_rect(int x, int y, int width, int height, int color) {
        Rasterizer2D.draw_filled_rect(x, y, width, height, color, 255);
    }

    public static void draw_filled_rect(int leftX, int topY, int width, int height, int rgbColour, int opacity) {
        if (leftX < topX) {
            width -= topX - leftX;
            leftX = topX;
        }
        if (topY < Rasterizer2D.topY) {
            height -= Rasterizer2D.topY - topY;
            topY = Rasterizer2D.topY;
        }
        if (leftX + width > bottomX) {
            width = bottomX - leftX;
        }
        if (topY + height > bottomY) {
            height = bottomY - topY;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int leftOver = Rasterizer2D.width - width;
        int pixelIndex = leftX + topY * Rasterizer2D.width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
                int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
                int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
                int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
                int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
                Rasterizer2D.pixels[pixelIndex++] = transparentColour;
            }
            pixelIndex += leftOver;
        }
    }

    public static void drawPixels(int height, int posY, int posX, int color, int w) {
        if (posX < topX) {
            w -= topX - posX;
            posX = topX;
        }
        if (posY < topY) {
            height -= topY - posY;
            posY = topY;
        }
        if (posX + w > bottomX) {
            w = bottomX - posX;
        }
        if (posY + height > bottomY) {
            height = bottomY - posY;
        }
        int k1 = width - w;
        int l1 = posX + posY * width;
        for (int i2 = -height; i2 < 0; ++i2) {
            for (int j2 = -w; j2 < 0; ++j2) {
                Rasterizer2D.pixels[l1++] = color;
            }
            l1 += k1;
        }
    }

    public static void draw_rect_outline(int x, int y, int width, int height, int rgbColour) {
        Rasterizer2D.draw_horizontal_line(x, y, width, rgbColour);
        Rasterizer2D.draw_horizontal_line(x, y + height - 1, width, rgbColour);
        Rasterizer2D.draw_vertical_line(x, y, height, rgbColour);
        Rasterizer2D.draw_vertical_line(x + width - 1, y, height, rgbColour);
    }

    public static void draw_horizontal_line(int xPosition, int yPosition, int width, int rgbColour) {
        if (yPosition < topY || yPosition >= bottomY) {
            return;
        }
        if (xPosition < topX) {
            width -= topX - xPosition;
            xPosition = topX;
        }
        if (xPosition + width > bottomX) {
            width = bottomX - xPosition;
        }
        int pixelIndex = xPosition + yPosition * Rasterizer2D.width;
        for (int i = 0; i < width; ++i) {
            Rasterizer2D.pixels[pixelIndex + i] = rgbColour;
        }
    }

    public static void drawStroke(int xPos, int yPos, int width, int height, int color, int strokeWidth) {
        Rasterizer2D.drawVerticalStrokeLine(xPos, yPos, height, color, strokeWidth);
        Rasterizer2D.drawVerticalStrokeLine(xPos + width - strokeWidth, yPos, height, color, strokeWidth);
        Rasterizer2D.drawHorizontalStrokeLine(xPos, yPos, width, color, strokeWidth);
        Rasterizer2D.drawHorizontalStrokeLine(xPos, yPos + height - strokeWidth, width, color, strokeWidth);
    }

    public static void drawHorizontalStrokeLine(int xPos, int yPos, int w, int hexColor, int strokeWidth) {
        if (yPos < topY || yPos >= bottomY) {
            return;
        }
        if (xPos < topX) {
            w -= topX - xPos;
            xPos = topX;
        }
        if (xPos + w > bottomX) {
            w = bottomX - xPos;
        }
        int index = xPos + yPos * width;
        int leftWidth = width - w;
        for (int x = 0; x < strokeWidth; ++x) {
            for (int y = 0; y < w; ++y) {
                Rasterizer2D.pixels[index++] = hexColor;
            }
            index += leftWidth;
        }
    }

    public static void drawVerticalStrokeLine(int xPosition, int yPosition, int height, int hexColor, int strokeWidth) {
        if (xPosition < topX || xPosition >= bottomX) {
            return;
        }
        if (yPosition < topY) {
            height -= topY - yPosition;
            yPosition = topY;
        }
        if (yPosition + height > bottomY) {
            height = bottomY - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int x = 0; x < strokeWidth; ++x) {
                Rasterizer2D.pixels[pixelIndex + x + rowIndex * Rasterizer2D.width] = hexColor;
            }
        }
    }

    public static void draw_vertical_line(int xPosition, int yPosition, int height, int rgbColour) {
        if (xPosition < topX || xPosition >= bottomX) {
            return;
        }
        if (yPosition < topY) {
            height -= topY - yPosition;
            yPosition = topY;
        }
        if (yPosition + height > bottomY) {
            height = bottomY - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            Rasterizer2D.pixels[pixelIndex + rowIndex * Rasterizer2D.width] = rgbColour;
        }
    }

    public static void drawHorizontalLine(int x, int y, int length, int color, int alpha) {
        if (y < topY || y >= bottomY) {
            return;
        }
        if (x < topX) {
            length -= topX - x;
            x = topX;
        }
        if (x + length > bottomX) {
            length = bottomX - x;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        for (int j3 = 0; j3 < length; ++j3) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            Rasterizer2D.pixels[i3++] = k3;
        }
    }

    public static void draw_line(int i, int j, int k, int l) {
        if (i < topY || i >= bottomY) {
            return;
        }
        if (l < topX) {
            k -= topX - l;
            l = topX;
        }
        if (l + k > bottomX) {
            k = bottomX - l;
        }
        int i1 = l + i * width;
        for (int j1 = 0; j1 < k; ++j1) {
            Rasterizer2D.pixels[i1 + j1] = j;
        }
    }

    public static void drawAlphaGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < topX) {
            gradientWidth -= topX - x;
            x = topX;
        }
        if (y < topY) {
            k1 += (topY - y) * l1;
            gradientHeight -= topY - y;
            y = topY;
        }
        if (x + gradientWidth > bottomX) {
            gradientWidth = bottomX - x;
        }
        if (y + gradientHeight > bottomY) {
            gradientHeight = bottomY - y;
        }
        int i2 = width - gradientWidth;
        int result_alpha = 256 - alpha;
        int total_pixels = x + y * width;
        for (int k2 = -gradientHeight; k2 < 0; ++k2) {
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            for (int k3 = -gradientWidth; k3 < 0; ++k3) {
                int colored_pixel = pixels[total_pixels];
                colored_pixel = ((colored_pixel & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((colored_pixel & 0xFF00) * result_alpha >> 8 & 0xFF00);
                Rasterizer2D.pixels[total_pixels++] = color + colored_pixel;
            }
            total_pixels += i2;
            k1 += l1;
        }
    }

    public static void drawAlphaBox(int x, int y, int lineWidth, int lineHeight, int color, int alpha) {
        if (y < topY) {
            if (y > topY - lineHeight) {
                lineHeight -= topY - y;
                y += topY - y;
            } else {
                return;
            }
        }
        if (y + lineHeight > bottomY) {
            lineHeight -= y + lineHeight - bottomY;
        }
        if (x < topX) {
            lineWidth -= topX - x;
            x = topX;
        }
        if (x + lineWidth > bottomX) {
            lineWidth = bottomX - x;
        }
        for (int yOff = 0; yOff < lineHeight; ++yOff) {
            int i3 = x + (y + yOff) * width;
            for (int j3 = 0; j3 < lineWidth; ++j3) {
                int j1 = 256 - alpha;
                int k1 = (color >> 16 & 0xFF) * alpha;
                int l1 = (color >> 8 & 0xFF) * alpha;
                int i2 = (color & 0xFF) * alpha;
                int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
                int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
                int l2 = (pixels[i3] & 0xFF) * j1;
                int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
                Rasterizer2D.pixels[i3++] = k3;
            }
        }
    }

    public static void drawTransparentBoxOutline(int leftX, int topY, int width, int height, int rgbColour, int opacity) {
        Rasterizer2D.drawTransparentHorizontalLine(leftX, topY, width, rgbColour, opacity);
        Rasterizer2D.drawTransparentHorizontalLine(leftX, topY + height - 1, width, rgbColour, opacity);
        if (height >= 3) {
            Rasterizer2D.drawTransparentVerticalLine(leftX, topY + 1, height - 2, rgbColour, opacity);
            Rasterizer2D.drawTransparentVerticalLine(leftX + width - 1, topY + 1, height - 2, rgbColour, opacity);
        }
    }

    public static void drawTransparentHorizontalLine(int xPosition, int yPosition, int width, int rgbColour, int opacity) {
        if (yPosition < topY || yPosition >= bottomY) {
            return;
        }
        if (xPosition < topX) {
            width -= topX - xPosition;
            xPosition = topX;
        }
        if (xPosition + width > bottomX) {
            width = bottomX - xPosition;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int pixelIndex = xPosition + yPosition * Rasterizer2D.width;
        for (int i = 0; i < width; ++i) {
            int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
            int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
            int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
            int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
            Rasterizer2D.pixels[pixelIndex++] = transparentColour;
        }
    }

    public static void drawTransparentVerticalLine(int xPosition, int yPosition, int height, int rgbColour, int opacity) {
        if (xPosition < topX || xPosition >= bottomX) {
            return;
        }
        if (yPosition < topY) {
            height -= topY - yPosition;
            yPosition = topY;
        }
        if (yPosition + height > bottomY) {
            height = bottomY - yPosition;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int pixelIndex = xPosition + yPosition * width;
        for (int i = 0; i < height; ++i) {
            int transparentColour;
            int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
            int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
            int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
            Rasterizer2D.pixels[pixelIndex] = transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
            pixelIndex += width;
        }
    }

    public static Graphics2D createGraphics(boolean renderingHints) {
        Graphics2D g2d = Rasterizer2D.createGraphics(pixels, width, height);
        if (renderingHints) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return g2d;
    }

    public static Graphics2D createGraphics(int[] pixels, int width, int height) {
        return new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(width, height), new DataBufferInt(pixels, width * height), null), false, new Hashtable()).createGraphics();
    }

    public static Shape createSector(int x, int y, int r, int angle) {
        return new Arc2D.Double(x, y, r, r, 90.0, -angle, 2);
    }

    public static Shape createCircle(int x, int y, int r) {
        return new Ellipse2D.Double(x, y, r, r);
    }

    public static Shape createRing(Shape sector, Shape innerCircle) {
        Area ring = new Area(sector);
        ring.subtract(new Area(innerCircle));
        return ring;
    }

    public static void drawFilledCircle(int x, int y, int radius, int color, int alpha) {
        int y2;
        int y1 = y - radius;
        if (y1 < 0) {
            y1 = 0;
        }
        if ((y2 = y + radius) >= height) {
            y2 = height - 1;
        }
        int a2 = 256 - alpha;
        int r1 = (color >> 16 & 0xFF) * alpha;
        int g1 = (color >> 8 & 0xFF) * alpha;
        int b1 = (color & 0xFF) * alpha;
        for (int iy = y1; iy <= y2; ++iy) {
            int x2;
            int dy = iy - y;
            int dist = (int)Math.sqrt(radius * radius - dy * dy);
            int x1 = x - dist;
            if (x1 < 0) {
                x1 = 0;
            }
            if ((x2 = x + dist) >= width) {
                x2 = width - 1;
            }
            int pos = x1 + iy * width;
            for (int ix = x1; ix <= x2; ++ix) {
                int r2 = (pixels[pos] >> 16 & 0xFF) * a2;
                int g2 = (pixels[pos] >> 8 & 0xFF) * a2;
                int b2 = (pixels[pos] & 0xFF) * a2;
                Rasterizer2D.pixels[pos++] = (r1 + r2 >> 8 << 16) + (g1 + g2 >> 8 << 8) + (b1 + b2 >> 8);
            }
        }
    }

    public static void drawRectangle(int x, int y, int width, int height, int color, int alpha) {
        Rasterizer2D.drawHorizontalLine(x, y, width, color, alpha);
        Rasterizer2D.drawHorizontalLine(x, y + height - 1, width, color, alpha);
        if (height >= 3) {
            Rasterizer2D.drawVerticalLine(x, y + 1, height - 2, color, alpha);
            Rasterizer2D.drawVerticalLine(x + width - 1, y + 1, height - 2, color, alpha);
        }
    }

    public static void drawVerticalLine(int x, int y, int length, int color, int alpha) {
        if (x < topX || x >= bottomX) {
            return;
        }
        if (y < topY) {
            length -= topY - y;
            y = topY;
        }
        if (y + length > bottomY) {
            length = bottomY - y;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        for (int j3 = 0; j3 < length; ++j3) {
            int k3;
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            Rasterizer2D.pixels[i3] = k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            i3 += width;
        }
    }

    public static void fillRectangle(int x, int y, int w, int h, int color) {
        if (x < topX) {
            w -= topX - x;
            x = topX;
        }
        if (y < topY) {
            h -= topY - y;
            y = topY;
        }
        if (x + w > bottomX) {
            w = bottomX - x;
        }
        if (y + h > bottomY) {
            h = bottomY - y;
        }
        int k1 = width - w;
        int l1 = x + y * width;
        for (int i2 = -h; i2 < 0; ++i2) {
            for (int j2 = -w; j2 < 0; ++j2) {
                Rasterizer2D.pixels[l1++] = color;
            }
            l1 += k1;
        }
    }

    public static void fillRectangle(int x, int y, int w, int h, int color, int alpha) {
        if (x < topX) {
            w -= topX - x;
            x = topX;
        }
        if (y < topY) {
            h -= topY - y;
            y = topY;
        }
        if (x + w > bottomX) {
            w = bottomX - x;
        }
        if (y + h > bottomY) {
            h = bottomY - y;
        }
        int a2 = 256 - alpha;
        int r1 = (color >> 16 & 0xFF) * alpha;
        int g1 = (color >> 8 & 0xFF) * alpha;
        int b1 = (color & 0xFF) * alpha;
        int k3 = width - w;
        int pixel = x + y * width;
        for (int i4 = 0; i4 < h; ++i4) {
            for (int j4 = -w; j4 < 0; ++j4) {
                int r2 = (pixels[pixel] >> 16 & 0xFF) * a2;
                int g2 = (pixels[pixel] >> 8 & 0xFF) * a2;
                int b2 = (pixels[pixel] & 0xFF) * a2;
                int rgb = (r1 + r2 >> 8 << 16) + (g1 + g2 >> 8 << 8) + (b1 + b2 >> 8);
                Rasterizer2D.pixels[pixel++] = rgb;
            }
            pixel += k3;
        }
    }

    public static final void drawAlphaCircle(int x, int y, int radius, int color, int alpha) {
        if (alpha != 0) {
            if (alpha == 256) {
                Rasterizer2D.drawCircle(x, y, radius, color);
            } else {
                int coordinates;
                int diameter_end;
                if (radius < 0) {
                    radius = -radius;
                }
                int opacity = 256 - alpha;
                int source_red = (color >> 16 & 0xFF) * alpha;
                int source_green = (color >> 8 & 0xFF) * alpha;
                int source_blue = (color & 0xFF) * alpha;
                int diameter_start = y - radius;
                if (diameter_start < topY) {
                    diameter_start = topY;
                }
                if ((diameter_end = y + radius + 1) > bottomY) {
                    diameter_end = bottomY;
                }
                int i_26_ = diameter_start;
                int i_27_ = radius * radius;
                int i_28_ = 0;
                int i_29_ = y - i_26_;
                int i_30_ = i_29_ * i_29_;
                int i_31_ = i_30_ - i_29_;
                if (y > diameter_end) {
                    y = diameter_end;
                }
                while (i_26_ < y) {
                    int i_33_;
                    while (i_31_ <= i_27_ || i_30_ <= i_27_) {
                        i_30_ += i_28_ + i_28_;
                        i_31_ += i_28_++ + i_28_;
                    }
                    int i_32_ = x - i_28_ + 1;
                    if (i_32_ < topX) {
                        i_32_ = topX;
                    }
                    if ((i_33_ = x + i_28_) > bottomX) {
                        i_33_ = bottomX;
                    }
                    coordinates = i_32_ + i_26_ * width;
                    for (int i_35_ = i_32_; i_35_ < i_33_; ++i_35_) {
                        int dest_red = (pixels[coordinates] >> 16 & 0xFF) * opacity;
                        int dest_green = (pixels[coordinates] >> 8 & 0xFF) * opacity;
                        int dest_blue = (pixels[coordinates] & 0xFF) * opacity;
                        int dest_color = (source_red + dest_red >> 8 << 16) + (source_green + dest_green >> 8 << 8) + (source_blue + dest_blue >> 8);
                        Rasterizer2D.pixels[coordinates++] = dest_color;
                    }
                    ++i_26_;
                    i_30_ -= i_29_-- + i_29_;
                    i_31_ -= i_29_ + i_29_;
                }
                i_28_ = radius;
                i_29_ = -i_29_;
                i_31_ = i_29_ * i_29_ + i_27_;
                i_30_ = i_31_ - i_28_;
                i_31_ -= i_29_;
                while (i_26_ < diameter_end) {
                    int i_41_;
                    while (i_31_ > i_27_ && i_30_ > i_27_) {
                        i_31_ -= i_28_-- + i_28_;
                        i_30_ -= i_28_ + i_28_;
                    }
                    int i_40_ = x - i_28_;
                    if (i_40_ < topX) {
                        i_40_ = topX;
                    }
                    if ((i_41_ = x + i_28_) > bottomX - 1) {
                        i_41_ = bottomX - 1;
                    }
                    coordinates = i_40_ + i_26_ * width;
                    for (int i_43_ = i_40_; i_43_ <= i_41_; ++i_43_) {
                        int i_44_ = (pixels[coordinates] >> 16 & 0xFF) * opacity;
                        int i_45_ = (pixels[coordinates] >> 8 & 0xFF) * opacity;
                        int i_46_ = (pixels[coordinates] & 0xFF) * opacity;
                        int i_47_ = (source_red + i_44_ >> 8 << 16) + (source_green + i_45_ >> 8 << 8) + (source_blue + i_46_ >> 8);
                        Rasterizer2D.pixels[coordinates++] = i_47_;
                    }
                    ++i_26_;
                    i_31_ += i_29_ + i_29_;
                    i_30_ += i_29_++ + i_29_;
                }
            }
        }
    }

    private static final void setPixel(int x, int y, int color) {
        if (x >= topX && y >= topY && x < bottomX && y < bottomY) {
            Rasterizer2D.pixels[x + y * Rasterizer2D.width] = color;
        }
    }

    private static final void drawCircle(int x, int y, int radius, int color) {
        if (radius == 0) {
            Rasterizer2D.setPixel(x, y, color);
        } else {
            int i_68_;
            int i_67_;
            if (radius < 0) {
                radius = -radius;
            }
            if ((i_67_ = y - radius) < topY) {
                i_67_ = topY;
            }
            if ((i_68_ = y + radius + 1) > bottomY) {
                i_68_ = bottomY;
            }
            int i_69_ = i_67_;
            int i_70_ = radius * radius;
            int i_71_ = 0;
            int i_72_ = y - i_69_;
            int i_73_ = i_72_ * i_72_;
            int i_74_ = i_73_ - i_72_;
            if (y > i_68_) {
                y = i_68_;
            }
            while (i_69_ < y) {
                int i_76_;
                while (i_74_ <= i_70_ || i_73_ <= i_70_) {
                    i_73_ += i_71_ + i_71_;
                    i_74_ += i_71_++ + i_71_;
                }
                int i_75_ = x - i_71_ + 1;
                if (i_75_ < topX) {
                    i_75_ = topX;
                }
                if ((i_76_ = x + i_71_) > bottomX) {
                    i_76_ = bottomX;
                }
                int i_77_ = i_75_ + i_69_ * width;
                for (int i_78_ = i_75_; i_78_ < i_76_; ++i_78_) {
                    Rasterizer2D.pixels[i_77_++] = color;
                }
                ++i_69_;
                i_73_ -= i_72_-- + i_72_;
                i_74_ -= i_72_ + i_72_;
            }
            i_71_ = radius;
            i_72_ = i_69_ - y;
            i_74_ = i_72_ * i_72_ + i_70_;
            i_73_ = i_74_ - i_71_;
            i_74_ -= i_72_;
            while (i_69_ < i_68_) {
                int i_80_;
                while (i_74_ > i_70_ && i_73_ > i_70_) {
                    i_74_ -= i_71_-- + i_71_;
                    i_73_ -= i_71_ + i_71_;
                }
                int i_79_ = x - i_71_;
                if (i_79_ < topX) {
                    i_79_ = topX;
                }
                if ((i_80_ = x + i_71_) > bottomX - 1) {
                    i_80_ = bottomX - 1;
                }
                int i_81_ = i_79_ + i_69_ * width;
                for (int i_82_ = i_79_; i_82_ <= i_80_; ++i_82_) {
                    Rasterizer2D.pixels[i_81_++] = color;
                }
                ++i_69_;
                i_74_ += i_72_ + i_72_;
                i_73_ += i_72_++ + i_72_;
            }
        }
    }

    public static void draw_rectangle_outline(int x, int y, int line_width, int line_height, int color) {
        Rasterizer2D.draw_vertical_line1(x, y, line_width, color);
        Rasterizer2D.draw_vertical_line1(x, line_height + y - 1, line_width, color);
        Rasterizer2D.draw_horizontal_line1(x, y, line_height, color);
        Rasterizer2D.draw_horizontal_line1(x + line_width - 1, y, line_height, color);
    }

    public static void draw_vertical_line1(int x, int y, int line_width, int color) {
        if (y >= topY && y < bottomY) {
            if (x < topX) {
                line_width -= topX - x;
                x = topX;
            }
            if (x + line_width > bottomX) {
                line_width = bottomX - x;
            }
            int coordinates = x + width * y;
            for (int step = 0; step < line_width; ++step) {
                Rasterizer2D.pixels[coordinates + step] = color;
            }
        }
    }

    public static void draw_horizontal_line1(int x, int y, int line_height, int color) {
        if (x >= topX && x < bottomX) {
            if (y < topY) {
                line_height -= topY - y;
                y = topY;
            }
            if (line_height + y > bottomY) {
                line_height = bottomY - y;
            }
            int coordinates = x + width * y;
            for (int step = 0; step < line_height; ++step) {
                Rasterizer2D.pixels[coordinates + step * Rasterizer2D.width] = color;
            }
        }
    }

    public static void draw_line(int x, int y, int line_width, int line_height, int color) {
        line_width -= x;
        if ((line_height -= y) == 0) {
            if (line_width >= 0) {
                Rasterizer2D.draw_vertical_line1(x, y, line_width + 1, color);
            } else {
                Rasterizer2D.draw_vertical_line1(x + line_width, y, -line_width + 1, color);
            }
        } else if (line_width == 0) {
            if (line_height >= 0) {
                Rasterizer2D.draw_horizontal_line1(x, y, line_height + 1, color);
            } else {
                Rasterizer2D.draw_horizontal_line1(x, line_height + y, -line_height + 1, color);
            }
        } else {
            if (line_height + line_width < 0) {
                x += line_width;
                line_width = -line_width;
                y += line_height;
                line_height = -line_height;
            }
            if (line_width > line_height) {
                y <<= 16;
                y += 16384;
                int height_step = (int)Math.floor((double)(line_height <<= 16) / (double)line_width + 0.5);
                line_width += x;
                if (x < topX) {
                    y += height_step * (topX - x);
                    x = topX;
                }
                if (line_width >= bottomX) {
                    line_width = bottomX - 1;
                }
                while (x <= line_width) {
                    int width_step = y >> 16;
                    if (width_step >= topY && width_step < bottomY) {
                        Rasterizer2D.pixels[x + width_step * Rasterizer2D.width] = color;
                    }
                    y += height_step;
                    ++x;
                }
            } else {
                x <<= 16;
                x += 16384;
                int height_step = (int)Math.floor((double)(line_width <<= 16) / (double)line_height + 0.5);
                line_height += y;
                if (y < topY) {
                    x += (topY - y) * height_step;
                    y = topY;
                }
                if (line_height >= bottomY) {
                    line_height = bottomY - 1;
                }
                while (y <= line_height) {
                    int width_step = x >> 16;
                    if (width_step >= topX && width_step < bottomX) {
                        Rasterizer2D.pixels[width_step + Rasterizer2D.width * y] = color;
                    }
                    x += height_step;
                    ++y;
                }
            }
        }
    }

    public static void transparentBox(int i, int j, int k, int l, int i1, int opac) {
        int j3 = 256 - opac;
        if (k < topX) {
            i1 -= topX - k;
            k = topX;
        }
        if (j < topY) {
            i -= topY - j;
            j = topY;
        }
        if (k + i1 > bottomX) {
            i1 = bottomX - k;
        }
        if (j + i > bottomY) {
            i = bottomY - j;
        }
        int k1 = width - i1;
        int l1 = k + j * width;
        for (int i2 = -i; i2 < 0; ++i2) {
            for (int j2 = -i1; j2 < 0; ++j2) {
                int i3 = pixels[l1];
                Rasterizer2D.pixels[l1++] = ((l & 0xFF00FF) * opac + (i3 & 0xFF00FF) * j3 & 0xFF00FF00) + ((l & 0xFF00) * opac + (i3 & 0xFF00) * j3 & 0xFF0000) >> 8;
            }
            l1 += k1;
        }
    }

    public static void fillPixels(int i, int j, int k, int l, int i1) {
        Rasterizer2D.method339(i1, l, j, i);
        Rasterizer2D.method339(i1 + k - 1, l, j, i);
        Rasterizer2D.method341(i1, l, k, i);
        Rasterizer2D.method341(i1, l, k, i + j - 1);
    }

    public static void method339(int i, int j, int k, int l) {
        if (i < topY || i >= bottomY) {
            return;
        }
        if (l < topX) {
            k -= topX - l;
            l = topX;
        }
        if (l + k > bottomX) {
            k = bottomX - l;
        }
        int i1 = l + i * width;
        for (int j1 = 0; j1 < k; ++j1) {
            Rasterizer2D.pixels[i1 + j1] = j;
        }
    }

    public static void method341(int i, int j, int k, int l) {
        if (l < topX || l >= bottomX) {
            return;
        }
        if (i < topY) {
            k -= topY - i;
            i = topY;
        }
        if (i + k > bottomY) {
            k = bottomY - i;
        }
        int j1 = l + i * width;
        for (int k1 = 0; k1 < k; ++k1) {
            Rasterizer2D.pixels[j1 + k1 * Rasterizer2D.width] = j;
        }
    }

    static {
        topY = 0;
        bottomY = 0;
        topX = 0;
        bottomX = 0;
    }
}

