/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.draw;

import com.ornate.cache.Archive;
import com.ornate.cache.graphics.IndexedImage;
import com.ornate.draw.Rasterizer2D;
import com.ornate.scene.SceneGraph;

public final class Rasterizer3D
extends Rasterizer2D {
    private static int scale;
    public static int clipMidX2;
    public static int clipNegativeMidX;
    public static int clipNegativeMidY;
    public static int clipMidY2;
    public static int media_length;
    public static boolean low_detail;
    public static boolean testX;
    public static boolean aBoolean1464;
    private static boolean opaque;
    public static boolean mapped;
    public static int alpha;
    public static int textureInt1;
    public static int textureInt2;
    public static int[] line_offsets;
    private static int texture_indices;
    public static IndexedImage[] tex_images;
    private static boolean[] transparent;
    private static int[] avg_color;
    private static int texel_indices;
    private static int[][][] texel_pool;
    private static int[][][] texel_cache;
    public static int[] cache;
    public static int pos;
    private static int[][] palletes;
    public static int scene_div_factor;
    public static int[] HSL_TO_RGB;
    private static int[] anIntArray1468;
    public static final int[] anIntArray1469;
    public static int[] SINE;
    public static int[] COSINE;
    public static boolean repeatTexture;
    public static boolean forceRepeat;
    public static int fogColor;
    static double brightness;

    public static final int calc_vertex_x(int v_x, int v_z, int cos, int sin) {
        return v_x * cos + sin * v_z >> 16;
    }

    public static final int calc_vertex_z(int v_x, int v_z, int cos, int sin) {
        return cos * v_z - sin * v_x >> 16;
    }

    public static void release() {
        anIntArray1468 = null;
        SINE = null;
        COSINE = null;
        line_offsets = null;
        tex_images = null;
        transparent = null;
        avg_color = null;
        texel_pool = null;
        texel_cache = null;
        cache = null;
        HSL_TO_RGB = null;
        palletes = null;
    }

    public static void set_clip() {
        line_offsets = new int[height];
        for (int j = 0; j < height; ++j) {
            Rasterizer3D.line_offsets[j] = width * j;
        }
        textureInt1 = width / 2;
        textureInt2 = height / 2;
        clipMidX2 = width - textureInt1;
        clipNegativeMidX = -textureInt1;
        clipNegativeMidY = -textureInt2;
        clipMidY2 = height - textureInt2;
    }

    public static void set_clip(int width, int height) {
        line_offsets = new int[height];
        for (int y = 0; y < height; ++y) {
            Rasterizer3D.line_offsets[y] = width * y;
        }
        textureInt1 = width / 2;
        textureInt2 = height / 2;
    }

    public static void reset_texels() {
        texel_pool = null;
        for (int j = 0; j < media_length; ++j) {
            Rasterizer3D.texel_cache[j] = null;
        }
    }

    public static void reset_textures() {
        if (texel_pool == null) {
            int index;
            texel_indices = 20;
            texel_pool = new int[texel_indices][][];
            for (index = 0; index < texel_indices; ++index) {
                Rasterizer3D.texel_pool[index] = new int[][]{new int[16384], new int[4096], new int[1024], new int[256], new int[64], new int[16], new int[4], new int[1]};
            }
            for (index = 0; index < media_length; ++index) {
                Rasterizer3D.texel_cache[index] = null;
            }
        }
    }

    public static void init(Archive archive) {
        texture_indices = 0;
        for (int index = 0; index < media_length; ++index) {
            try {
                Rasterizer3D.tex_images[index] = new IndexedImage(archive, String.valueOf(index), 0);
                if (low_detail && Rasterizer3D.tex_images[index].max_height == 128) {
                    tex_images[index].scale_half();
                } else {
                    tex_images[index].scale_full();
                }
                ++texture_indices;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int set_floor(int id) {
        if (avg_color[id] != 0) {
            return avg_color[id];
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int grayscale = palletes[id].length;
        for (int pixel = 0; pixel < grayscale; ++pixel) {
            r += palletes[id][pixel] >> 16 & 0xFF;
            g += palletes[id][pixel] >> 8 & 0xFF;
            b += palletes[id][pixel] & 0xFF;
        }
        int rgb = (r / grayscale << 16) + (g / grayscale << 8) + b / grayscale;
        if ((rgb = Rasterizer3D.adjust_brightness(rgb, 1.4)) == 0) {
            rgb = 1;
        }
        Rasterizer3D.avg_color[id] = rgb;
        return rgb;
    }

    public static void reset_texel_pos(int id) {
        try {
            if (texel_cache[id] == null) {
                return;
            }
            Rasterizer3D.texel_pool[Rasterizer3D.texel_indices++] = texel_cache[id];
            Rasterizer3D.texel_cache[id] = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int[][] get_texels(int id) {
        int[][] texels;
        ++pos;
        if (texel_cache[id] != null) {
            return texel_cache[id];
        }
        if (texel_indices > 0) {
            texels = texel_pool[--texel_indices];
            Rasterizer3D.texel_pool[Rasterizer3D.texel_indices] = null;
        } else {
            int last = 0;
            int target = -1;
            for (int index = 0; index < texture_indices; ++index) {
                if (texel_cache[index] == null || cache[index] >= last && target != -1) continue;
                last = cache[index];
                target = index;
            }
            texels = texel_cache[target];
            Rasterizer3D.texel_cache[target] = null;
        }
        Rasterizer3D.texel_cache[id] = texels;
        IndexedImage background = tex_images[id];
        int[] palette = palletes[id];
        byte[] palette_color = background.palettePixels;
        if (background.width == 64) {
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    texels[0][x + (y << 7)] = palette[palette_color[(x >> 1) + (y >> 1 << 6)] & 0xFF];
                }
            }
        } else {
            for (int index = 0; index < 16384; ++index) {
                texels[0][index] = palette[palette_color[index] & 0xFF];
            }
        }
        Rasterizer3D.transparent[id] = false;
        for (int pixel_index = 0; pixel_index < 16384; ++pixel_index) {
            int[] nArray = texels[0];
            int n = pixel_index;
            nArray[n] = nArray[n] & 0xF8F8FF;
            int source_color = texels[0][pixel_index];
            if (source_color != 0) continue;
            Rasterizer3D.transparent[id] = true;
        }
        int size = 64;
        for (int level = 1; level < 8; ++level) {
            int[] src = texels[level - 1];
            int[] dst = texels[level];
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    double r = 0.0;
                    double g = 0.0;
                    double b = 0.0;
                    int step = 0;
                    for (int rgb : new int[]{src[x + (y * size << 1) << 1], src[(x + (y * size << 1) << 1) + 1], src[(x + (y * size << 1) << 1) + (size << 1)], src[(x + (y * size << 1) << 1) + (size << 1) + 1]}) {
                        if (rgb == 0) continue;
                        double r_ = (double)(rgb >> 16 & 0xFF) / 255.0;
                        double g_ = (double)(rgb >> 8 & 0xFF) / 255.0;
                        double b_ = (double)(rgb & 0xFF) / 255.0;
                        r += r_ * r_;
                        g += g_ * g_;
                        b += b_ * b_;
                        ++step;
                    }
                    if (step != 0) {
                        int dst_r = Math.round(255.0f * (float)Math.sqrt(r / (double)step));
                        int dst_g = Math.round(255.0f * (float)Math.sqrt(g / (double)step));
                        int dst_b = Math.round(255.0f * (float)Math.sqrt(b / (double)step));
                        dst[x + y * size] = dst_r << 16 | dst_g << 8 | dst_b;
                        continue;
                    }
                    dst[x + y * size] = 0;
                }
            }
            size >>= 1;
        }
        return texels;
    }

    private static int get_texel_pos(int index) {
        int x = (index & 0x7F) >> scale;
        int y = index >> 7 >> scale;
        return x + (y << 7 - scale);
    }

    public static void adjust_brightness(double brightness) {
        Rasterizer3D.adjust_brightness(brightness, 0, 512);
    }

    public static void adjust_brightness(double brightness, int start, int end) {
        brightness += Math.random() * 0.03 - 0.015;
        int size = start * 128;
        for (int step = start; step < end; ++step) {
            double d1 = (double)(step / 8) / 64.0 + 0.0078125;
            double d2 = (double)(step & 7) / 8.0 + 0.0625;
            for (int k1 = 0; k1 < 128; ++k1) {
                double d3;
                double r = d3 = (double)k1 / 128.0;
                double g = d3;
                double b = d3;
                if (d2 != 0.0) {
                    double d7 = d3 < 0.5 ? d3 * (1.0 + d2) : d3 + d2 - d3 * d2;
                    double d8 = 2.0 * d3 - d7;
                    double d9 = d1 + 0.3333333333333333;
                    if (d9 > 1.0) {
                        d9 -= 1.0;
                    }
                    double d10 = d1;
                    double d11 = d1 - 0.3333333333333333;
                    if (d11 < 0.0) {
                        d11 += 1.0;
                    }
                    r = 6.0 * d9 < 1.0 ? d8 + (d7 - d8) * 6.0 * d9 : (2.0 * d9 < 1.0 ? d7 : (3.0 * d9 < 2.0 ? d8 + (d7 - d8) * (0.6666666666666666 - d9) * 6.0 : d8));
                    g = 6.0 * d10 < 1.0 ? d8 + (d7 - d8) * 6.0 * d10 : (2.0 * d10 < 1.0 ? d7 : (3.0 * d10 < 2.0 ? d8 + (d7 - d8) * (0.6666666666666666 - d10) * 6.0 : d8));
                    b = 6.0 * d11 < 1.0 ? d8 + (d7 - d8) * 6.0 * d11 : (2.0 * d11 < 1.0 ? d7 : (3.0 * d11 < 2.0 ? d8 + (d7 - d8) * (0.6666666666666666 - d11) * 6.0 : d8));
                }
                int byteR = (int)(r * 256.0);
                int byteG = (int)(g * 256.0);
                int byteB = (int)(b * 256.0);
                int rgb = (byteR << 16) + (byteG << 8) + byteB;
                if ((rgb = Rasterizer3D.adjust_brightness(rgb, brightness)) == 0) {
                    rgb = 1;
                }
                Rasterizer3D.HSL_TO_RGB[size++] = rgb;
            }
        }
        for (int tex_id = 0; tex_id < media_length; ++tex_id) {
            if (tex_images[tex_id] == null) continue;
            int[] palette = Rasterizer3D.tex_images[tex_id].palette;
            Rasterizer3D.palletes[tex_id] = new int[palette.length];
            for (int colourId = 0; colourId < palette.length; ++colourId) {
                Rasterizer3D.palletes[tex_id][colourId] = Rasterizer3D.adjust_brightness(palette[colourId], brightness);
                if ((palletes[tex_id][colourId] & 0xF8F8FF) != 0 || colourId == 0) continue;
                Rasterizer3D.palletes[tex_id][colourId] = 1;
            }
        }
        for (int textureId = 0; textureId < media_length; ++textureId) {
            Rasterizer3D.reset_texel_pos(textureId);
        }
        Rasterizer3D.brightness = brightness;
    }

    public static int adjust_brightness(int rgb, double intensity) {
        double r = (double)(rgb >> 16) / 256.0;
        double g = (double)(rgb >> 8 & 0xFF) / 256.0;
        double b = (double)(rgb & 0xFF) / 256.0;
        r = Math.pow(r, intensity);
        g = Math.pow(g, intensity);
        b = Math.pow(b, intensity);
        int r_byte = (int)(r * 256.0);
        int g_byte = (int)(g * 256.0);
        int b_byte = (int)(b * 256.0);
        return (r_byte << 16) + (g_byte << 8) + b_byte;
    }

    public static void drawShadedTriangle(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int hsl1, int hsl2, int hsl3, float z_a, float z_b, float z_c) {
        if (z_a < 0.0f || z_b < 0.0f || z_c < 0.0f) {
            return;
        }
        int rgb1 = HSL_TO_RGB[hsl1];
        int rgb2 = HSL_TO_RGB[hsl2];
        int rgb3 = HSL_TO_RGB[hsl3];
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int r3 = rgb3 >> 16 & 0xFF;
        int g3 = rgb3 >> 8 & 0xFF;
        int b3 = rgb3 & 0xFF;
        int a_to_b = 0;
        int dr1 = 0;
        int dg1 = 0;
        int db1 = 0;
        if (y_b != y_a) {
            a_to_b = (x_b - x_a << 16) / (y_b - y_a);
            dr1 = (r2 - r1 << 16) / (y_b - y_a);
            dg1 = (g2 - g1 << 16) / (y_b - y_a);
            db1 = (b2 - b1 << 16) / (y_b - y_a);
        }
        int b_to_c = 0;
        int dr2 = 0;
        int dg2 = 0;
        int db2 = 0;
        if (y_c != y_b) {
            b_to_c = (x_c - x_b << 16) / (y_c - y_b);
            dr2 = (r3 - r2 << 16) / (y_c - y_b);
            dg2 = (g3 - g2 << 16) / (y_c - y_b);
            db2 = (b3 - b2 << 16) / (y_c - y_b);
        }
        int c_to_a = 0;
        int dr3 = 0;
        int dg3 = 0;
        int db3 = 0;
        if (y_c != y_a) {
            c_to_a = (x_a - x_c << 16) / (y_a - y_c);
            dr3 = (r1 - r3 << 16) / (y_a - y_c);
            dg3 = (g1 - g3 << 16) / (y_a - y_c);
            db3 = (b1 - b3 << 16) / (y_a - y_c);
        }
        float b_aX = x_b - x_a;
        float b_aY = y_b - y_a;
        float c_aX = x_c - x_a;
        float c_aY = y_c - y_a;
        float b_aZ = z_b - z_a;
        float c_aZ = z_c - z_a;
        float div = b_aX * c_aY - c_aX * b_aY;
        float depth_slope = (b_aZ * c_aY - c_aZ * b_aY) / div;
        float depth_increment = (c_aZ * b_aX - b_aZ * c_aX) / div;
        if (y_a <= y_b && y_a <= y_c) {
            if (y_a >= bottomY) {
                return;
            }
            if (y_b > bottomY) {
                y_b = bottomY;
            }
            if (y_c > bottomY) {
                y_c = bottomY;
            }
            z_a = z_a - depth_slope * (float)x_a + depth_slope;
            if (y_b < y_c) {
                x_c = x_a <<= 16;
                r3 = r1 <<= 16;
                g3 = g1 <<= 16;
                b3 = b1 <<= 16;
                if (y_a < 0) {
                    x_c -= c_to_a * y_a;
                    x_a -= a_to_b * y_a;
                    r3 -= dr3 * y_a;
                    g3 -= dg3 * y_a;
                    b3 -= db3 * y_a;
                    r1 -= dr1 * y_a;
                    g1 -= dg1 * y_a;
                    b1 -= db1 * y_a;
                    z_a -= depth_increment * (float)y_a;
                    y_a = 0;
                }
                x_b <<= 16;
                r2 <<= 16;
                g2 <<= 16;
                b2 <<= 16;
                if (y_b < 0) {
                    x_b -= b_to_c * y_b;
                    r2 -= dr2 * y_b;
                    g2 -= dg2 * y_b;
                    b2 -= db2 * y_b;
                    y_b = 0;
                }
                if (y_a != y_b && c_to_a < a_to_b || y_a == y_b && c_to_a > b_to_c) {
                    y_c -= y_b;
                    y_b -= y_a;
                    y_a = line_offsets[y_a];
                    while (--y_b >= 0) {
                        Rasterizer3D.drawShadedScanline(pixels, y_a, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_a, depth_slope);
                        x_c += c_to_a;
                        x_a += a_to_b;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        z_a += depth_increment;
                        y_a += width;
                    }
                    while (--y_c >= 0) {
                        Rasterizer3D.drawShadedScanline(pixels, y_a, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_a, depth_slope);
                        x_c += c_to_a;
                        x_b += b_to_c;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        y_a += width;
                        z_a += depth_increment;
                    }
                    return;
                }
                y_c -= y_b;
                y_b -= y_a;
                y_a = line_offsets[y_a];
                while (--y_b >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_a, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_a, depth_slope);
                    x_c += c_to_a;
                    x_a += a_to_b;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z_a += depth_increment;
                    y_a += width;
                }
                while (--y_c >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_a, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_a, depth_slope);
                    x_c += c_to_a;
                    x_b += b_to_c;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y_a += width;
                    z_a += depth_increment;
                }
                return;
            }
            x_b = x_a <<= 16;
            r2 = r1 <<= 16;
            g2 = g1 <<= 16;
            b2 = b1 <<= 16;
            if (y_a < 0) {
                x_b -= c_to_a * y_a;
                x_a -= a_to_b * y_a;
                r2 -= dr3 * y_a;
                g2 -= dg3 * y_a;
                b2 -= db3 * y_a;
                r1 -= dr1 * y_a;
                g1 -= dg1 * y_a;
                b1 -= db1 * y_a;
                z_a -= depth_increment * (float)y_a;
                y_a = 0;
            }
            x_c <<= 16;
            r3 <<= 16;
            g3 <<= 16;
            b3 <<= 16;
            if (y_c < 0) {
                x_c -= b_to_c * y_c;
                r3 -= dr2 * y_c;
                g3 -= dg2 * y_c;
                b3 -= db2 * y_c;
                y_c = 0;
            }
            if (y_a != y_c && c_to_a < a_to_b || y_a == y_c && b_to_c > a_to_b) {
                y_b -= y_c;
                y_c -= y_a;
                y_a = line_offsets[y_a];
                while (--y_c >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_a, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_a, depth_slope);
                    x_b += c_to_a;
                    x_a += a_to_b;
                    r2 += dr3;
                    g2 += dg3;
                    b2 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z_a += depth_increment;
                    y_a += width;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_a, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_a, depth_slope);
                    x_c += b_to_c;
                    x_a += a_to_b;
                    r3 += dr2;
                    g3 += dg2;
                    b3 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y_a += width;
                    z_a += depth_increment;
                }
                return;
            }
            y_b -= y_c;
            y_c -= y_a;
            y_a = line_offsets[y_a];
            while (--y_c >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_a, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_a, depth_slope);
                x_b += c_to_a;
                x_a += a_to_b;
                r2 += dr3;
                g2 += dg3;
                b2 += db3;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z_a += depth_increment;
                y_a += width;
            }
            while (--y_b >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_a, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_a, depth_slope);
                x_c += b_to_c;
                x_a += a_to_b;
                r3 += dr2;
                g3 += dg2;
                b3 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                y_a += width;
                z_a += depth_increment;
            }
            return;
        }
        if (y_b <= y_c) {
            if (y_b >= bottomY) {
                return;
            }
            if (y_c > bottomY) {
                y_c = bottomY;
            }
            if (y_a > bottomY) {
                y_a = bottomY;
            }
            z_b = z_b - depth_slope * (float)x_b + depth_slope;
            if (y_c < y_a) {
                x_a = x_b <<= 16;
                r1 = r2 <<= 16;
                g1 = g2 <<= 16;
                b1 = b2 <<= 16;
                if (y_b < 0) {
                    x_a -= a_to_b * y_b;
                    x_b -= b_to_c * y_b;
                    r1 -= dr1 * y_b;
                    g1 -= dg1 * y_b;
                    b1 -= db1 * y_b;
                    r2 -= dr2 * y_b;
                    g2 -= dg2 * y_b;
                    b2 -= db2 * y_b;
                    z_b -= depth_increment * (float)y_b;
                    y_b = 0;
                }
                x_c <<= 16;
                r3 <<= 16;
                g3 <<= 16;
                b3 <<= 16;
                if (y_c < 0) {
                    x_c -= c_to_a * y_c;
                    r3 -= dr3 * y_c;
                    g3 -= dg3 * y_c;
                    b3 -= db3 * y_c;
                    y_c = 0;
                }
                if (y_b != y_c && a_to_b < b_to_c || y_b == y_c && a_to_b > c_to_a) {
                    y_a -= y_c;
                    y_c -= y_b;
                    y_b = line_offsets[y_b];
                    while (--y_c >= 0) {
                        Rasterizer3D.drawShadedScanline(pixels, y_b, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_b, depth_slope);
                        x_a += a_to_b;
                        x_b += b_to_c;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        z_b += depth_increment;
                        y_b += width;
                    }
                    while (--y_a >= 0) {
                        Rasterizer3D.drawShadedScanline(pixels, y_b, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_b, depth_slope);
                        x_a += a_to_b;
                        x_c += c_to_a;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        y_b += width;
                        z_b += depth_increment;
                    }
                    return;
                }
                y_a -= y_c;
                y_c -= y_b;
                y_b = line_offsets[y_b];
                while (--y_c >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_b, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_b, depth_slope);
                    x_a += a_to_b;
                    x_b += b_to_c;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z_b += depth_increment;
                    y_b += width;
                }
                while (--y_a >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_b, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_b, depth_slope);
                    x_a += a_to_b;
                    x_c += c_to_a;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    y_b += width;
                    z_b += depth_increment;
                }
                return;
            }
            x_c = x_b <<= 16;
            r3 = r2 <<= 16;
            g3 = g2 <<= 16;
            b3 = b2 <<= 16;
            if (y_b < 0) {
                x_c -= a_to_b * y_b;
                x_b -= b_to_c * y_b;
                r3 -= dr1 * y_b;
                g3 -= dg1 * y_b;
                b3 -= db1 * y_b;
                r2 -= dr2 * y_b;
                g2 -= dg2 * y_b;
                b2 -= db2 * y_b;
                z_b -= depth_increment * (float)y_b;
                y_b = 0;
            }
            x_a <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y_a < 0) {
                x_a -= c_to_a * y_a;
                r1 -= dr3 * y_a;
                g1 -= dg3 * y_a;
                b1 -= db3 * y_a;
                y_a = 0;
            }
            if (a_to_b < b_to_c) {
                y_c -= y_a;
                y_a -= y_b;
                y_b = line_offsets[y_b];
                while (--y_a >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_b, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_b, depth_slope);
                    x_c += a_to_b;
                    x_b += b_to_c;
                    r3 += dr1;
                    g3 += dg1;
                    b3 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z_b += depth_increment;
                    y_b += width;
                }
                while (--y_c >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_b, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_b, depth_slope);
                    x_a += c_to_a;
                    x_b += b_to_c;
                    r1 += dr3;
                    g1 += dg3;
                    b1 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y_b += width;
                    z_b += depth_increment;
                }
                return;
            }
            y_c -= y_a;
            y_a -= y_b;
            y_b = line_offsets[y_b];
            while (--y_a >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_b, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_b, depth_slope);
                x_c += a_to_b;
                x_b += b_to_c;
                r3 += dr1;
                g3 += dg1;
                b3 += db1;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                z_b += depth_increment;
                y_b += width;
            }
            while (--y_c >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_b, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_b, depth_slope);
                x_a += c_to_a;
                x_b += b_to_c;
                r1 += dr3;
                g1 += dg3;
                b1 += db3;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                y_b += width;
                z_b += depth_increment;
            }
            return;
        }
        if (y_c >= bottomY) {
            return;
        }
        if (y_a > bottomY) {
            y_a = bottomY;
        }
        if (y_b > bottomY) {
            y_b = bottomY;
        }
        z_c = z_c - depth_slope * (float)x_c + depth_slope;
        if (y_a < y_b) {
            x_b = x_c <<= 16;
            r2 = r3 <<= 16;
            g2 = g3 <<= 16;
            b2 = b3 <<= 16;
            if (y_c < 0) {
                x_b -= b_to_c * y_c;
                x_c -= c_to_a * y_c;
                r2 -= dr2 * y_c;
                g2 -= dg2 * y_c;
                b2 -= db2 * y_c;
                r3 -= dr3 * y_c;
                g3 -= dg3 * y_c;
                b3 -= db3 * y_c;
                z_c -= depth_increment * (float)y_c;
                y_c = 0;
            }
            x_a <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y_a < 0) {
                x_a -= a_to_b * y_a;
                r1 -= dr1 * y_a;
                g1 -= dg1 * y_a;
                b1 -= db1 * y_a;
                y_a = 0;
            }
            if (b_to_c < c_to_a) {
                y_b -= y_a;
                y_a -= y_c;
                y_c = line_offsets[y_c];
                while (--y_a >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_c, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_c, depth_slope);
                    x_b += b_to_c;
                    x_c += c_to_a;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    z_c += depth_increment;
                    y_c += width;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawShadedScanline(pixels, y_c, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_c, depth_slope);
                    x_b += b_to_c;
                    x_a += a_to_b;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y_c += width;
                    z_c += depth_increment;
                }
                return;
            }
            y_b -= y_a;
            y_a -= y_c;
            y_c = line_offsets[y_c];
            while (--y_a >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_c, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_c, depth_slope);
                x_b += b_to_c;
                x_c += c_to_a;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z_c += depth_increment;
                y_c += width;
            }
            while (--y_b >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_c, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_c, depth_slope);
                x_b += b_to_c;
                x_a += a_to_b;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z_c += depth_increment;
                y_c += width;
            }
            return;
        }
        x_a = x_c <<= 16;
        r1 = r3 <<= 16;
        g1 = g3 <<= 16;
        b1 = b3 <<= 16;
        if (y_c < 0) {
            x_a -= b_to_c * y_c;
            x_c -= c_to_a * y_c;
            r1 -= dr2 * y_c;
            g1 -= dg2 * y_c;
            b1 -= db2 * y_c;
            r3 -= dr3 * y_c;
            g3 -= dg3 * y_c;
            b3 -= db3 * y_c;
            z_c -= depth_increment * (float)y_c;
            y_c = 0;
        }
        x_b <<= 16;
        r2 <<= 16;
        g2 <<= 16;
        b2 <<= 16;
        if (y_b < 0) {
            x_b -= a_to_b * y_b;
            r2 -= dr1 * y_b;
            g2 -= dg1 * y_b;
            b2 -= db1 * y_b;
            y_b = 0;
        }
        if (b_to_c < c_to_a) {
            y_a -= y_b;
            y_b -= y_c;
            y_c = line_offsets[y_c];
            while (--y_b >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_c, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_c, depth_slope);
                x_a += b_to_c;
                x_c += c_to_a;
                r1 += dr2;
                g1 += dg2;
                b1 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z_c += depth_increment;
                y_c += width;
            }
            while (--y_a >= 0) {
                Rasterizer3D.drawShadedScanline(pixels, y_c, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_c, depth_slope);
                x_b += a_to_b;
                x_c += c_to_a;
                r2 += dr1;
                g2 += dg1;
                b2 += db1;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z_c += depth_increment;
                y_c += width;
            }
            return;
        }
        y_a -= y_b;
        y_b -= y_c;
        y_c = line_offsets[y_c];
        while (--y_b >= 0) {
            Rasterizer3D.drawShadedScanline(pixels, y_c, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_c, depth_slope);
            x_a += b_to_c;
            x_c += c_to_a;
            r1 += dr2;
            g1 += dg2;
            b1 += db2;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            z_c += depth_increment;
            y_c += width;
        }
        while (--y_a >= 0) {
            Rasterizer3D.drawShadedScanline(pixels, y_c, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_c, depth_slope);
            x_b += a_to_b;
            x_c += c_to_a;
            r2 += dr1;
            g2 += dg1;
            b2 += db1;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            y_c += width;
            z_c += depth_increment;
        }
    }

    public static void drawShadedScanline(int[] dest, int offset, int x1, int x2, int r1, int g1, int b1, int r2, int g2, int b2, float depth, float depth_slope) {
        block8: {
            int n = x2 - x1;
            if (n <= 0) {
                return;
            }
            r2 = (r2 - r1) / n;
            g2 = (g2 - g1) / n;
            b2 = (b2 - b1) / n;
            if (testX) {
                if (x2 > Rasterizer2D.centerX2) {
                    n -= x2 - Rasterizer2D.centerX2;
                    x2 = Rasterizer2D.centerX2;
                }
                if (x1 < 0) {
                    n = x2;
                    r1 -= x1 * r2;
                    g1 -= x1 * g2;
                    b1 -= x1 * b2;
                    x1 = 0;
                }
            }
            if (x1 >= x2) break block8;
            offset += x1;
            depth += depth_slope * (float)x1;
            if (alpha == 0) {
                while (--n >= 0) {
                    dest[offset] = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                    Rasterizer3D.depth_buffer[offset++] = depth;
                    depth += depth_slope;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                }
            } else {
                int a1 = alpha;
                int a2 = 256 - alpha;
                while (--n >= 0) {
                    int rgb = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                    rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
                    int dst = dest[offset];
                    dest[offset] = rgb + ((dst & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dst & 0xFF00) * a1 >> 8 & 0xFF00);
                    Rasterizer3D.depth_buffer[offset] = depth;
                    depth += depth_slope;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                    ++offset;
                }
            }
        }
    }

    public static void drawFlatTriangle1(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int k1, float z_a, float z_b, float z_c) {
        if (z_a < 0.0f || z_b < 0.0f || z_c < 0.0f) {
            return;
        }
        int a_to_b = 0;
        if (y_b != y_a) {
            a_to_b = (x_b - x_a << 16) / (y_b - y_a);
        }
        int b_to_c = 0;
        if (y_c != y_b) {
            b_to_c = (x_c - x_b << 16) / (y_c - y_b);
        }
        int c_to_a = 0;
        if (y_c != y_a) {
            c_to_a = (x_a - x_c << 16) / (y_a - y_c);
        }
        float b_aX = x_b - x_a;
        float b_aY = y_b - y_a;
        float c_aX = x_c - x_a;
        float c_aY = y_c - y_a;
        float b_aZ = z_b - z_a;
        float c_aZ = z_c - z_a;
        float div = b_aX * c_aY - c_aX * b_aY;
        float depth_slope = (b_aZ * c_aY - c_aZ * b_aY) / div;
        float depth_increment = (c_aZ * b_aX - b_aZ * c_aX) / div;
        if (y_a <= y_b && y_a <= y_c) {
            if (y_a >= bottomY) {
                return;
            }
            if (y_b > bottomY) {
                y_b = bottomY;
            }
            if (y_c > bottomY) {
                y_c = bottomY;
            }
            z_a = z_a - depth_slope * (float)x_a + depth_slope;
            if (y_b < y_c) {
                x_c = x_a <<= 16;
                if (y_a < 0) {
                    x_c -= c_to_a * y_a;
                    x_a -= a_to_b * y_a;
                    z_a -= depth_increment * (float)y_a;
                    y_a = 0;
                }
                x_b <<= 16;
                if (y_b < 0) {
                    x_b -= b_to_c * y_b;
                    y_b = 0;
                }
                if (y_a != y_b && c_to_a < a_to_b || y_a == y_b && c_to_a > b_to_c) {
                    y_c -= y_b;
                    y_b -= y_a;
                    y_a = line_offsets[y_a];
                    while (--y_b >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_c >> 16, x_a >> 16, z_a, depth_slope);
                        x_c += c_to_a;
                        x_a += a_to_b;
                        z_a += depth_increment;
                        y_a += width;
                    }
                    while (--y_c >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_c >> 16, x_b >> 16, z_a, depth_slope);
                        x_c += c_to_a;
                        x_b += b_to_c;
                        y_a += width;
                        z_a += depth_increment;
                    }
                    return;
                }
                y_c -= y_b;
                y_b -= y_a;
                y_a = line_offsets[y_a];
                while (--y_b >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_a >> 16, x_c >> 16, z_a, depth_slope);
                    x_c += c_to_a;
                    x_a += a_to_b;
                    z_a += depth_increment;
                    y_a += width;
                }
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_b >> 16, x_c >> 16, z_a, depth_slope);
                    x_c += c_to_a;
                    x_b += b_to_c;
                    y_a += width;
                    z_a += depth_increment;
                }
                return;
            }
            x_b = x_a <<= 16;
            if (y_a < 0) {
                x_b -= c_to_a * y_a;
                x_a -= a_to_b * y_a;
                z_a -= depth_increment * (float)y_a;
                y_a = 0;
            }
            x_c <<= 16;
            if (y_c < 0) {
                x_c -= b_to_c * y_c;
                y_c = 0;
            }
            if (y_a != y_c && c_to_a < a_to_b || y_a == y_c && b_to_c > a_to_b) {
                y_b -= y_c;
                y_c -= y_a;
                y_a = line_offsets[y_a];
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_b >> 16, x_a >> 16, z_a, depth_slope);
                    z_a += depth_increment;
                    x_b += c_to_a;
                    x_a += a_to_b;
                    y_a += width;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_c >> 16, x_a >> 16, z_a, depth_slope);
                    z_a += depth_increment;
                    x_c += b_to_c;
                    x_a += a_to_b;
                    y_a += width;
                }
                return;
            }
            y_b -= y_c;
            y_c -= y_a;
            y_a = line_offsets[y_a];
            while (--y_c >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_a >> 16, x_b >> 16, z_a, depth_slope);
                z_a += depth_increment;
                x_b += c_to_a;
                x_a += a_to_b;
                y_a += width;
            }
            while (--y_b >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_a, k1, x_a >> 16, x_c >> 16, z_a, depth_slope);
                z_a += depth_increment;
                x_c += b_to_c;
                x_a += a_to_b;
                y_a += width;
            }
            return;
        }
        if (y_b <= y_c) {
            if (y_b >= bottomY) {
                return;
            }
            if (y_c > bottomY) {
                y_c = bottomY;
            }
            if (y_a > bottomY) {
                y_a = bottomY;
            }
            z_b = z_b - depth_slope * (float)x_b + depth_slope;
            if (y_c < y_a) {
                x_a = x_b <<= 16;
                if (y_b < 0) {
                    x_a -= a_to_b * y_b;
                    x_b -= b_to_c * y_b;
                    z_b -= depth_increment * (float)y_b;
                    y_b = 0;
                }
                x_c <<= 16;
                if (y_c < 0) {
                    x_c -= c_to_a * y_c;
                    y_c = 0;
                }
                if (y_b != y_c && a_to_b < b_to_c || y_b == y_c && a_to_b > c_to_a) {
                    y_a -= y_c;
                    y_c -= y_b;
                    y_b = line_offsets[y_b];
                    while (--y_c >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_a >> 16, x_b >> 16, z_b, depth_slope);
                        z_b += depth_increment;
                        x_a += a_to_b;
                        x_b += b_to_c;
                        y_b += width;
                    }
                    while (--y_a >= 0) {
                        Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_a >> 16, x_c >> 16, z_b, depth_slope);
                        z_b += depth_increment;
                        x_a += a_to_b;
                        x_c += c_to_a;
                        y_b += width;
                    }
                    return;
                }
                y_a -= y_c;
                y_c -= y_b;
                y_b = line_offsets[y_b];
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_b >> 16, x_a >> 16, z_b, depth_slope);
                    z_b += depth_increment;
                    x_a += a_to_b;
                    x_b += b_to_c;
                    y_b += width;
                }
                while (--y_a >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_c >> 16, x_a >> 16, z_b, depth_slope);
                    z_b += depth_increment;
                    x_a += a_to_b;
                    x_c += c_to_a;
                    y_b += width;
                }
                return;
            }
            x_c = x_b <<= 16;
            if (y_b < 0) {
                x_c -= a_to_b * y_b;
                x_b -= b_to_c * y_b;
                z_b -= depth_increment * (float)y_b;
                y_b = 0;
            }
            x_a <<= 16;
            if (y_a < 0) {
                x_a -= c_to_a * y_a;
                y_a = 0;
            }
            if (a_to_b < b_to_c) {
                y_c -= y_a;
                y_a -= y_b;
                y_b = line_offsets[y_b];
                while (--y_a >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_c >> 16, x_b >> 16, z_b, depth_slope);
                    z_b += depth_increment;
                    x_c += a_to_b;
                    x_b += b_to_c;
                    y_b += width;
                }
                while (--y_c >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_a >> 16, x_b >> 16, z_b, depth_slope);
                    z_b += depth_increment;
                    x_a += c_to_a;
                    x_b += b_to_c;
                    y_b += width;
                }
                return;
            }
            y_c -= y_a;
            y_a -= y_b;
            y_b = line_offsets[y_b];
            while (--y_a >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_b >> 16, x_c >> 16, z_b, depth_slope);
                z_b += depth_increment;
                x_c += a_to_b;
                x_b += b_to_c;
                y_b += width;
            }
            while (--y_c >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_b, k1, x_b >> 16, x_a >> 16, z_b, depth_slope);
                z_b += depth_increment;
                x_a += c_to_a;
                x_b += b_to_c;
                y_b += width;
            }
            return;
        }
        if (y_c >= bottomY) {
            return;
        }
        if (y_a > bottomY) {
            y_a = bottomY;
        }
        if (y_b > bottomY) {
            y_b = bottomY;
        }
        z_c = z_c - depth_slope * (float)x_c + depth_slope;
        if (y_a < y_b) {
            x_b = x_c <<= 16;
            if (y_c < 0) {
                x_b -= b_to_c * y_c;
                x_c -= c_to_a * y_c;
                z_c -= depth_increment * (float)y_c;
                y_c = 0;
            }
            x_a <<= 16;
            if (y_a < 0) {
                x_a -= a_to_b * y_a;
                y_a = 0;
            }
            if (b_to_c < c_to_a) {
                y_b -= y_a;
                y_a -= y_c;
                y_c = line_offsets[y_c];
                while (--y_a >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_b >> 16, x_c >> 16, z_c, depth_slope);
                    z_c += depth_increment;
                    x_b += b_to_c;
                    x_c += c_to_a;
                    y_c += width;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_b >> 16, x_a >> 16, z_c, depth_slope);
                    z_c += depth_increment;
                    x_b += b_to_c;
                    x_a += a_to_b;
                    y_c += width;
                }
                return;
            }
            y_b -= y_a;
            y_a -= y_c;
            y_c = line_offsets[y_c];
            while (--y_a >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_c >> 16, x_b >> 16, z_c, depth_slope);
                z_c += depth_increment;
                x_b += b_to_c;
                x_c += c_to_a;
                y_c += width;
            }
            while (--y_b >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_a >> 16, x_b >> 16, z_c, depth_slope);
                z_c += depth_increment;
                x_b += b_to_c;
                x_a += a_to_b;
                y_c += width;
            }
            return;
        }
        x_a = x_c <<= 16;
        if (y_c < 0) {
            x_a -= b_to_c * y_c;
            x_c -= c_to_a * y_c;
            z_c -= depth_increment * (float)y_c;
            y_c = 0;
        }
        x_b <<= 16;
        if (y_b < 0) {
            x_b -= a_to_b * y_b;
            y_b = 0;
        }
        if (b_to_c < c_to_a) {
            y_a -= y_b;
            y_b -= y_c;
            y_c = line_offsets[y_c];
            while (--y_b >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_a >> 16, x_c >> 16, z_c, depth_slope);
                z_c += depth_increment;
                x_a += b_to_c;
                x_c += c_to_a;
                y_c += width;
            }
            while (--y_a >= 0) {
                Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_b >> 16, x_c >> 16, z_c, depth_slope);
                z_c += depth_increment;
                x_b += a_to_b;
                x_c += c_to_a;
                y_c += width;
            }
            return;
        }
        y_a -= y_b;
        y_b -= y_c;
        y_c = line_offsets[y_c];
        while (--y_b >= 0) {
            Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_c >> 16, x_a >> 16, z_c, depth_slope);
            z_c += depth_increment;
            x_a += b_to_c;
            x_c += c_to_a;
            y_c += width;
        }
        while (--y_a >= 0) {
            Rasterizer3D.drawFlatTexturedScanline(pixels, y_c, k1, x_c >> 16, x_b >> 16, z_c, depth_slope);
            z_c += depth_increment;
            x_b += a_to_b;
            x_c += c_to_a;
            y_c += width;
        }
    }

    private static void drawFlatTexturedScanline(int[] dest, int dest_off, int loops, int start_x, int end_x, float depth, float depth_slope) {
        if (testX) {
            if (end_x > Rasterizer2D.centerX2) {
                end_x = Rasterizer2D.centerX2;
            }
            if (start_x < 0) {
                start_x = 0;
            }
        }
        if (start_x >= end_x) {
            return;
        }
        dest_off += start_x;
        int rgb = end_x - start_x >> 2;
        depth += depth_slope * (float)start_x;
        if (alpha == 0) {
            while (--rgb >= 0) {
                for (int i = 0; i < 4; ++i) {
                    dest[dest_off] = loops;
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                    ++dest_off;
                    depth += depth_slope;
                }
            }
            rgb = end_x - start_x & 3;
            while (--rgb >= 0) {
                dest[dest_off] = loops;
                Rasterizer3D.depth_buffer[dest_off] = depth;
                ++dest_off;
                depth += depth_slope;
            }
            return;
        }
        int dest_alpha = alpha;
        int src_alpha = 256 - alpha;
        loops = ((loops & 0xFF00FF) * src_alpha >> 8 & 0xFF00FF) + ((loops & 0xFF00) * src_alpha >> 8 & 0xFF00);
        while (--rgb >= 0) {
            for (int i = 0; i < 4; ++i) {
                dest[dest_off] = loops + ((dest[dest_off] & 0xFF00FF) * dest_alpha >> 8 & 0xFF00FF) + ((dest[dest_off] & 0xFF00) * dest_alpha >> 8 & 0xFF00);
                Rasterizer3D.depth_buffer[dest_off] = depth;
                ++dest_off;
                depth += depth_slope;
            }
        }
        rgb = end_x - start_x & 3;
        while (--rgb >= 0) {
            dest[dest_off] = loops + ((dest[dest_off] & 0xFF00FF) * dest_alpha >> 8 & 0xFF00FF) + ((dest[dest_off] & 0xFF00) * dest_alpha >> 8 & 0xFF00);
            Rasterizer3D.depth_buffer[dest_off] = depth;
            ++dest_off;
            depth += depth_slope;
        }
    }

    public static void drawTexturedTriangle1(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int k1, int l1, int i2, int Px, int Mx, int Nx, int Pz, int Mz, int Nz, int Py, int My, int Ny, int texture_id, float z_a, float z_b, float z_c) {
        if (z_a < 0.0f || z_b < 0.0f || z_c < 0.0f) {
            return;
        }
        int[] texels = Rasterizer3D.get_texels(texture_id)[scale];
        if (texels == null) {
            Rasterizer3D.drawShadedTriangle(y_a, y_b, y_c, x_a, x_b, x_c, Rasterizer3D.light(texture_id, k1), Rasterizer3D.light(texture_id, l1), Rasterizer3D.light(texture_id, i2), z_a, z_b, z_c);
        } else {
            opaque = !transparent[texture_id];
            Mx = Px - Mx;
            Mz = Pz - Mz;
            My = Py - My;
            int Oa = (Nx -= Px) * Pz - (Nz -= Pz) * Px << (SceneGraph.view_dist == 9 ? 14 : 15);
            int Ha = Nz * Py - (Ny -= Py) * Pz << 8;
            int Va = Ny * Px - Nx * Py << 5;
            int Ob = Mx * Pz - Mz * Px << (SceneGraph.view_dist == 9 ? 14 : 15);
            int Hb = Mz * Py - My * Pz << 8;
            int Vb = My * Px - Mx * Py << 5;
            int Oc = Mz * Nx - Mx * Nz << (SceneGraph.view_dist == 9 ? 14 : 15);
            int Hc = My * Nz - Mz * Ny << 8;
            int Vc = Mx * Ny - My * Nx << 5;
            int a_to_b = 0;
            int grad_a_off = 0;
            if (y_b != y_a) {
                a_to_b = (x_b - x_a << 16) / (y_b - y_a);
                grad_a_off = (l1 - k1 << 16) / (y_b - y_a);
            }
            int b_to_c = 0;
            int grad_b_off = 0;
            if (y_c != y_b) {
                b_to_c = (x_c - x_b << 16) / (y_c - y_b);
                grad_b_off = (i2 - l1 << 16) / (y_c - y_b);
            }
            int c_to_a = 0;
            int grad_c_off = 0;
            if (y_c != y_a) {
                c_to_a = (x_a - x_c << 16) / (y_a - y_c);
                grad_c_off = (k1 - i2 << 16) / (y_a - y_c);
            }
            float b_aX = x_b - x_a;
            float b_aY = y_b - y_a;
            float c_aX = x_c - x_a;
            float c_aY = y_c - y_a;
            float b_aZ = z_b - z_a;
            float c_aZ = z_c - z_a;
            float div = b_aX * c_aY - c_aX * b_aY;
            float depth_slope = (b_aZ * c_aY - c_aZ * b_aY) / div;
            float depth_increment = (c_aZ * b_aX - b_aZ * c_aX) / div;
            if (y_a <= y_b && y_a <= y_c) {
                if (y_a >= bottomY) {
                    return;
                }
                if (y_b > bottomY) {
                    y_b = bottomY;
                }
                if (y_c > bottomY) {
                    y_c = bottomY;
                }
                z_a = z_a - depth_slope * (float)x_a + depth_slope;
                if (y_b < y_c) {
                    x_c = x_a <<= 16;
                    i2 = k1 <<= 16;
                    if (y_a < 0) {
                        x_c -= c_to_a * y_a;
                        x_a -= a_to_b * y_a;
                        z_a -= depth_increment * (float)y_a;
                        i2 -= grad_c_off * y_a;
                        k1 -= grad_a_off * y_a;
                        y_a = 0;
                    }
                    x_b <<= 16;
                    l1 <<= 16;
                    if (y_b < 0) {
                        x_b -= b_to_c * y_b;
                        l1 -= grad_b_off * y_b;
                        y_b = 0;
                    }
                    int k8 = y_a - textureInt2;
                    Oa += Va * k8;
                    Ob += Vb * k8;
                    Oc += Vc * k8;
                    if (y_a != y_b && c_to_a < a_to_b || y_a == y_b && c_to_a > b_to_c) {
                        y_c -= y_b;
                        y_b -= y_a;
                        y_a = line_offsets[y_a];
                        while (--y_b >= 0) {
                            Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_c >> 16, x_a >> 16, i2 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                            x_c += c_to_a;
                            x_a += a_to_b;
                            z_a += depth_increment;
                            i2 += grad_c_off;
                            k1 += grad_a_off;
                            y_a += width;
                            Oa += Va;
                            Ob += Vb;
                            Oc += Vc;
                        }
                        while (--y_c >= 0) {
                            Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_c >> 16, x_b >> 16, i2 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                            x_c += c_to_a;
                            x_b += b_to_c;
                            z_a += depth_increment;
                            i2 += grad_c_off;
                            l1 += grad_b_off;
                            y_a += width;
                            Oa += Va;
                            Ob += Vb;
                            Oc += Vc;
                        }
                        return;
                    }
                    y_c -= y_b;
                    y_b -= y_a;
                    y_a = line_offsets[y_a];
                    while (--y_b >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_a >> 16, x_c >> 16, k1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                        x_c += c_to_a;
                        x_a += a_to_b;
                        z_a += depth_increment;
                        i2 += grad_c_off;
                        k1 += grad_a_off;
                        y_a += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    while (--y_c >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_b >> 16, x_c >> 16, l1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                        x_c += c_to_a;
                        x_b += b_to_c;
                        z_a += depth_increment;
                        i2 += grad_c_off;
                        l1 += grad_b_off;
                        y_a += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    return;
                }
                x_b = x_a <<= 16;
                l1 = k1 <<= 16;
                if (y_a < 0) {
                    x_b -= c_to_a * y_a;
                    x_a -= a_to_b * y_a;
                    z_a -= depth_increment * (float)y_a;
                    l1 -= grad_c_off * y_a;
                    k1 -= grad_a_off * y_a;
                    y_a = 0;
                }
                x_c <<= 16;
                i2 <<= 16;
                if (y_c < 0) {
                    x_c -= b_to_c * y_c;
                    i2 -= grad_b_off * y_c;
                    y_c = 0;
                }
                int l8 = y_a - textureInt2;
                Oa += Va * l8;
                Ob += Vb * l8;
                Oc += Vc * l8;
                if (y_a != y_c && c_to_a < a_to_b || y_a == y_c && b_to_c > a_to_b) {
                    y_b -= y_c;
                    y_c -= y_a;
                    y_a = line_offsets[y_a];
                    while (--y_c >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_b >> 16, x_a >> 16, l1 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                        x_b += c_to_a;
                        x_a += a_to_b;
                        l1 += grad_c_off;
                        k1 += grad_a_off;
                        z_a += depth_increment;
                        y_a += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    while (--y_b >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_c >> 16, x_a >> 16, i2 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                        x_c += b_to_c;
                        x_a += a_to_b;
                        i2 += grad_b_off;
                        k1 += grad_a_off;
                        z_a += depth_increment;
                        y_a += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    return;
                }
                y_b -= y_c;
                y_c -= y_a;
                y_a = line_offsets[y_a];
                while (--y_c >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_a >> 16, x_b >> 16, k1 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                    x_b += c_to_a;
                    x_a += a_to_b;
                    l1 += grad_c_off;
                    k1 += grad_a_off;
                    z_a += depth_increment;
                    y_a += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_a, x_a >> 16, x_c >> 16, k1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_a, depth_slope);
                    x_c += b_to_c;
                    x_a += a_to_b;
                    i2 += grad_b_off;
                    k1 += grad_a_off;
                    z_a += depth_increment;
                    y_a += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                return;
            }
            if (y_b <= y_c) {
                if (y_b >= bottomY) {
                    return;
                }
                if (y_c > bottomY) {
                    y_c = bottomY;
                }
                if (y_a > bottomY) {
                    y_a = bottomY;
                }
                z_b = z_b - depth_slope * (float)x_b + depth_slope;
                if (y_c < y_a) {
                    x_a = x_b <<= 16;
                    k1 = l1 <<= 16;
                    if (y_b < 0) {
                        x_a -= a_to_b * y_b;
                        x_b -= b_to_c * y_b;
                        z_b -= depth_increment * (float)y_b;
                        k1 -= grad_a_off * y_b;
                        l1 -= grad_b_off * y_b;
                        y_b = 0;
                    }
                    x_c <<= 16;
                    i2 <<= 16;
                    if (y_c < 0) {
                        x_c -= c_to_a * y_c;
                        i2 -= grad_c_off * y_c;
                        y_c = 0;
                    }
                    int i9 = y_b - textureInt2;
                    Oa += Va * i9;
                    Ob += Vb * i9;
                    Oc += Vc * i9;
                    if (y_b != y_c && a_to_b < b_to_c || y_b == y_c && a_to_b > c_to_a) {
                        y_a -= y_c;
                        y_c -= y_b;
                        y_b = line_offsets[y_b];
                        while (--y_c >= 0) {
                            Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_a >> 16, x_b >> 16, k1 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                            x_a += a_to_b;
                            x_b += b_to_c;
                            k1 += grad_a_off;
                            l1 += grad_b_off;
                            z_b += depth_increment;
                            y_b += width;
                            Oa += Va;
                            Ob += Vb;
                            Oc += Vc;
                        }
                        while (--y_a >= 0) {
                            Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_a >> 16, x_c >> 16, k1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                            x_a += a_to_b;
                            x_c += c_to_a;
                            k1 += grad_a_off;
                            i2 += grad_c_off;
                            z_b += depth_increment;
                            y_b += width;
                            Oa += Va;
                            Ob += Vb;
                            Oc += Vc;
                        }
                        return;
                    }
                    y_a -= y_c;
                    y_c -= y_b;
                    y_b = line_offsets[y_b];
                    while (--y_c >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_b >> 16, x_a >> 16, l1 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                        x_a += a_to_b;
                        x_b += b_to_c;
                        k1 += grad_a_off;
                        l1 += grad_b_off;
                        z_b += depth_increment;
                        y_b += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    while (--y_a >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_c >> 16, x_a >> 16, i2 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                        x_a += a_to_b;
                        x_c += c_to_a;
                        k1 += grad_a_off;
                        i2 += grad_c_off;
                        z_b += depth_increment;
                        y_b += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    return;
                }
                x_c = x_b <<= 16;
                i2 = l1 <<= 16;
                if (y_b < 0) {
                    x_c -= a_to_b * y_b;
                    x_b -= b_to_c * y_b;
                    z_b -= depth_increment * (float)y_b;
                    i2 -= grad_a_off * y_b;
                    l1 -= grad_b_off * y_b;
                    y_b = 0;
                }
                x_a <<= 16;
                k1 <<= 16;
                if (y_a < 0) {
                    x_a -= c_to_a * y_a;
                    k1 -= grad_c_off * y_a;
                    y_a = 0;
                }
                int j9 = y_b - textureInt2;
                Oa += Va * j9;
                Ob += Vb * j9;
                Oc += Vc * j9;
                if (a_to_b < b_to_c) {
                    y_c -= y_a;
                    y_a -= y_b;
                    y_b = line_offsets[y_b];
                    while (--y_a >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_c >> 16, x_b >> 16, i2 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                        x_c += a_to_b;
                        x_b += b_to_c;
                        i2 += grad_a_off;
                        l1 += grad_b_off;
                        z_b += depth_increment;
                        y_b += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    while (--y_c >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_a >> 16, x_b >> 16, k1 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                        x_a += c_to_a;
                        x_b += b_to_c;
                        k1 += grad_c_off;
                        l1 += grad_b_off;
                        z_b += depth_increment;
                        y_b += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    return;
                }
                y_c -= y_a;
                y_a -= y_b;
                y_b = line_offsets[y_b];
                while (--y_a >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_b >> 16, x_c >> 16, l1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                    x_c += a_to_b;
                    x_b += b_to_c;
                    i2 += grad_a_off;
                    l1 += grad_b_off;
                    z_b += depth_increment;
                    y_b += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                while (--y_c >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_b, x_b >> 16, x_a >> 16, l1 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_b, depth_slope);
                    x_a += c_to_a;
                    x_b += b_to_c;
                    k1 += grad_c_off;
                    l1 += grad_b_off;
                    z_b += depth_increment;
                    y_b += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                return;
            }
            if (y_c >= bottomY) {
                return;
            }
            if (y_a > bottomY) {
                y_a = bottomY;
            }
            if (y_b > bottomY) {
                y_b = bottomY;
            }
            z_c = z_c - depth_slope * (float)x_c + depth_slope;
            if (y_a < y_b) {
                x_b = x_c <<= 16;
                l1 = i2 <<= 16;
                if (y_c < 0) {
                    x_b -= b_to_c * y_c;
                    x_c -= c_to_a * y_c;
                    z_c -= depth_increment * (float)y_c;
                    l1 -= grad_b_off * y_c;
                    i2 -= grad_c_off * y_c;
                    y_c = 0;
                }
                x_a <<= 16;
                k1 <<= 16;
                if (y_a < 0) {
                    x_a -= a_to_b * y_a;
                    k1 -= grad_a_off * y_a;
                    y_a = 0;
                }
                int k9 = y_c - textureInt2;
                Oa += Va * k9;
                Ob += Vb * k9;
                Oc += Vc * k9;
                if (b_to_c < c_to_a) {
                    y_b -= y_a;
                    y_a -= y_c;
                    y_c = line_offsets[y_c];
                    while (--y_a >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_b >> 16, x_c >> 16, l1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                        x_b += b_to_c;
                        x_c += c_to_a;
                        l1 += grad_b_off;
                        i2 += grad_c_off;
                        z_c += depth_increment;
                        y_c += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    while (--y_b >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_b >> 16, x_a >> 16, l1 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                        x_b += b_to_c;
                        x_a += a_to_b;
                        l1 += grad_b_off;
                        k1 += grad_a_off;
                        z_c += depth_increment;
                        y_c += width;
                        Oa += Va;
                        Ob += Vb;
                        Oc += Vc;
                    }
                    return;
                }
                y_b -= y_a;
                y_a -= y_c;
                y_c = line_offsets[y_c];
                while (--y_a >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_c >> 16, x_b >> 16, i2 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                    x_b += b_to_c;
                    x_c += c_to_a;
                    l1 += grad_b_off;
                    i2 += grad_c_off;
                    z_c += depth_increment;
                    y_c += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                while (--y_b >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_a >> 16, x_b >> 16, k1 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                    x_b += b_to_c;
                    x_a += a_to_b;
                    l1 += grad_b_off;
                    k1 += grad_a_off;
                    z_c += depth_increment;
                    y_c += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                return;
            }
            x_a = x_c <<= 16;
            k1 = i2 <<= 16;
            if (y_c < 0) {
                x_a -= b_to_c * y_c;
                x_c -= c_to_a * y_c;
                z_c -= depth_increment * (float)y_c;
                k1 -= grad_b_off * y_c;
                i2 -= grad_c_off * y_c;
                y_c = 0;
            }
            x_b <<= 16;
            l1 <<= 16;
            if (y_b < 0) {
                x_b -= a_to_b * y_b;
                l1 -= grad_a_off * y_b;
                y_b = 0;
            }
            int l9 = y_c - textureInt2;
            Oa += Va * l9;
            Ob += Vb * l9;
            Oc += Vc * l9;
            if (b_to_c < c_to_a) {
                y_a -= y_b;
                y_b -= y_c;
                y_c = line_offsets[y_c];
                while (--y_b >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_a >> 16, x_c >> 16, k1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                    x_a += b_to_c;
                    x_c += c_to_a;
                    k1 += grad_b_off;
                    i2 += grad_c_off;
                    z_c += depth_increment;
                    y_c += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                while (--y_a >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_b >> 16, x_c >> 16, l1 >> 8, i2 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                    x_b += a_to_b;
                    x_c += c_to_a;
                    l1 += grad_a_off;
                    i2 += grad_c_off;
                    z_c += depth_increment;
                    y_c += width;
                    Oa += Va;
                    Ob += Vb;
                    Oc += Vc;
                }
                return;
            }
            y_a -= y_b;
            y_b -= y_c;
            y_c = line_offsets[y_c];
            while (--y_b >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_c >> 16, x_a >> 16, i2 >> 8, k1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                x_a += b_to_c;
                x_c += c_to_a;
                k1 += grad_b_off;
                i2 += grad_c_off;
                z_c += depth_increment;
                y_c += width;
                Oa += Va;
                Ob += Vb;
                Oc += Vc;
            }
            while (--y_a >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y_c, x_c >> 16, x_b >> 16, i2 >> 8, l1 >> 8, Oa, Ob, Oc, Ha, Hb, Hc, z_c, depth_slope);
                x_b += a_to_b;
                x_c += c_to_a;
                l1 += grad_a_off;
                i2 += grad_c_off;
                z_c += depth_increment;
                y_c += width;
                Oa += Va;
                Ob += Vb;
                Oc += Vc;
            }
        }
    }

    public static void drawTexturedScanline(int[] dest, int[] texture, int dest_off, int start_x, int end_x, int shadeValue, int gradient, int l1, int i2, int j2, int k2, int l2, int i3, float depth, float depth_slope) {
        int k3;
        int j3;
        int rgb = 0;
        int loops = 0;
        if (start_x >= end_x) {
            return;
        }
        if (testX) {
            j3 = (gradient - shadeValue) / (end_x - start_x);
            if (end_x > Rasterizer2D.centerX2) {
                end_x = Rasterizer2D.centerX2;
            }
            if (start_x < 0) {
                shadeValue -= start_x * j3;
                start_x = 0;
            }
            if (start_x >= end_x) {
                return;
            }
            k3 = end_x - start_x >> 3;
            j3 <<= 12;
            shadeValue <<= 9;
        } else {
            if (end_x - start_x > 7) {
                k3 = end_x - start_x >> 3;
                j3 = (gradient - shadeValue) * anIntArray1468[k3] >> 6;
            } else {
                k3 = 0;
                j3 = 0;
            }
            shadeValue <<= 9;
        }
        dest_off += start_x;
        depth += depth_slope * (float)start_x;
        if (low_detail) {
            int i4 = 0;
            int k4 = 0;
            int k6 = start_x - textureInt1;
            l1 += (k2 >> 3) * k6;
            i2 += (l2 >> 3) * k6;
            int i5 = (j2 += (i3 >> 3) * k6) >> 12;
            if (i5 != 0) {
                rgb = l1 / i5;
                loops = i2 / i5;
                if (rgb < 0) {
                    rgb = 0;
                } else if (rgb > 4032) {
                    rgb = 4032;
                }
            }
            l1 += k2;
            i2 += l2;
            i5 = (j2 += i3) >> 12;
            if (i5 != 0) {
                i4 = l1 / i5;
                k4 = i2 / i5;
                if (i4 < 7) {
                    i4 = 7;
                } else if (i4 > 4032) {
                    i4 = 4032;
                }
            }
            int i7 = i4 - rgb >> 3;
            int k7 = k4 - loops >> 3;
            rgb += (shadeValue & 0x600000) >> 3;
            int i8 = shadeValue >> 23;
            if (opaque) {
                while (k3-- > 0) {
                    for (int i = 0; i < 8; ++i) {
                        dest[dest_off] = texture[(loops & 0xFC0) + (rgb >> 6)] >>> i8;
                        Rasterizer3D.depth_buffer[dest_off] = depth;
                        ++dest_off;
                        depth += depth_slope;
                        rgb += i7;
                        loops += k7;
                    }
                    rgb = i4;
                    loops = k4;
                    l1 += k2;
                    i2 += l2;
                    int j5 = (j2 += i3) >> 12;
                    if (j5 != 0) {
                        i4 = l1 / j5;
                        k4 = i2 / j5;
                        if (i4 < 7) {
                            i4 = 7;
                        } else if (i4 > 4032) {
                            i4 = 4032;
                        }
                    }
                    i7 = i4 - rgb >> 3;
                    k7 = k4 - loops >> 3;
                    rgb += ((shadeValue += j3) & 0x600000) >> 3;
                    i8 = shadeValue >> 23;
                }
                k3 = end_x - start_x & 7;
                while (k3-- > 0) {
                    dest[dest_off] = texture[(loops & 0xFC0) + (rgb >> 6)] >>> i8;
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                    ++dest_off;
                    depth += depth_slope;
                    rgb += i7;
                    loops += k7;
                }
                return;
            }
            while (k3-- > 0) {
                for (int i = 0; i < 8; ++i) {
                    int k8 = texture[(loops & 0xFC0) + (rgb >> 6)] >>> i8;
                    if (k8 != 0) {
                        dest[dest_off] = k8;
                        Rasterizer3D.depth_buffer[dest_off] = depth;
                    }
                    ++dest_off;
                    depth += depth_slope;
                    rgb += i7;
                    loops += k7;
                }
                rgb = i4;
                loops = k4;
                l1 += k2;
                i2 += l2;
                int k5 = (j2 += i3) >> 12;
                if (k5 != 0) {
                    i4 = l1 / k5;
                    k4 = i2 / k5;
                    if (i4 < 7) {
                        i4 = 7;
                    } else if (i4 > 4032) {
                        i4 = 4032;
                    }
                }
                i7 = i4 - rgb >> 3;
                k7 = k4 - loops >> 3;
                rgb += ((shadeValue += j3) & 0x600000) >> 3;
                i8 = shadeValue >> 23;
            }
            k3 = end_x - start_x & 7;
            while (k3-- > 0) {
                int l8 = texture[(loops & 0xFC0) + (rgb >> 6)] >>> i8;
                if (l8 != 0) {
                    dest[dest_off] = l8;
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                }
                ++dest_off;
                depth += depth_slope;
                rgb += i7;
                loops += k7;
            }
            return;
        }
        int j4 = 0;
        int l4 = 0;
        int l6 = start_x - textureInt1;
        l1 += (k2 >> 3) * l6;
        i2 += (l2 >> 3) * l6;
        int l5 = (j2 += (i3 >> 3) * l6) >> 14;
        if (l5 != 0) {
            rgb = l1 / l5;
            loops = i2 / l5;
            if (rgb < 0) {
                rgb = 0;
            } else if (rgb > 16256) {
                rgb = 16256;
            }
        }
        l1 += k2;
        i2 += l2;
        l5 = (j2 += i3) >> 14;
        if (l5 != 0) {
            j4 = l1 / l5;
            l4 = i2 / l5;
            if (j4 < 7) {
                j4 = 7;
            } else if (j4 > 16256) {
                j4 = 16256;
            }
        }
        int j7 = j4 - rgb >> 3;
        int l7 = l4 - loops >> 3;
        rgb += shadeValue & 0x600000;
        int j8 = shadeValue >> 23;
        if (opaque) {
            while (k3-- > 0) {
                for (int i = 0; i < 8; ++i) {
                    dest[dest_off] = texture[(loops & 0x3F80) + (rgb >> 7)] >>> j8;
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                    depth += depth_slope;
                    ++dest_off;
                    rgb += j7;
                    loops += l7;
                }
                rgb = j4;
                loops = l4;
                l1 += k2;
                i2 += l2;
                int i6 = (j2 += i3) >> 14;
                if (i6 != 0) {
                    j4 = l1 / i6;
                    l4 = i2 / i6;
                    if (j4 < 7) {
                        j4 = 7;
                    } else if (j4 > 16256) {
                        j4 = 16256;
                    }
                }
                j7 = j4 - rgb >> 3;
                l7 = l4 - loops >> 3;
                rgb += (shadeValue += j3) & 0x600000;
                j8 = shadeValue >> 23;
            }
            k3 = end_x - start_x & 7;
            while (k3-- > 0) {
                dest[dest_off] = texture[(loops & 0x3F80) + (rgb >> 7)] >>> j8;
                Rasterizer3D.depth_buffer[dest_off] = depth;
                ++dest_off;
                depth += depth_slope;
                rgb += j7;
                loops += l7;
            }
            return;
        }
        while (k3-- > 0) {
            for (int i = 0; i < 8; ++i) {
                int i9 = texture[(loops & 0x3F80) + (rgb >> 7)] >>> j8;
                if (i9 != 0) {
                    dest[dest_off] = i9;
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                }
                ++dest_off;
                depth += depth_slope;
                rgb += j7;
                loops += l7;
            }
            rgb = j4;
            loops = l4;
            l1 += k2;
            i2 += l2;
            int j6 = (j2 += i3) >> 14;
            if (j6 != 0) {
                j4 = l1 / j6;
                l4 = i2 / j6;
                if (j4 < 7) {
                    j4 = 7;
                } else if (j4 > 16256) {
                    j4 = 16256;
                }
            }
            j7 = j4 - rgb >> 3;
            l7 = l4 - loops >> 3;
            rgb += (shadeValue += j3) & 0x600000;
            j8 = shadeValue >> 23;
        }
        int l3 = end_x - start_x & 7;
        while (l3-- > 0) {
            int j9 = texture[(loops & 0x3F80) + (rgb >> 7)] >>> j8;
            if (j9 != 0) {
                dest[dest_off] = j9;
                Rasterizer3D.depth_buffer[dest_off] = depth;
            }
            depth += depth_slope;
            ++dest_off;
            rgb += j7;
            loops += l7;
        }
    }

    public static void drawDepthTriangle(int x_a, int x_b, int x_c, int y_a, int y_b, int y_c, float z_a, float z_b, float z_c) {
        block65: {
            float depth_increment;
            float depth_slope;
            int c_to_a;
            int b_to_c;
            int a_to_b;
            block66: {
                block64: {
                    a_to_b = 0;
                    if (y_b != y_a) {
                        a_to_b = (x_b - x_a << 16) / (y_b - y_a);
                    }
                    b_to_c = 0;
                    if (y_c != y_b) {
                        b_to_c = (x_c - x_b << 16) / (y_c - y_b);
                    }
                    c_to_a = 0;
                    if (y_c != y_a) {
                        c_to_a = (x_a - x_c << 16) / (y_a - y_c);
                    }
                    float b_aX = x_b - x_a;
                    float b_aY = y_b - y_a;
                    float c_aX = x_c - x_a;
                    float c_aY = y_c - y_a;
                    float b_aZ = z_b - z_a;
                    float c_aZ = z_c - z_a;
                    float div = b_aX * c_aY - c_aX * b_aY;
                    depth_slope = (b_aZ * c_aY - c_aZ * b_aY) / div;
                    depth_increment = (c_aZ * b_aX - b_aZ * c_aX) / div;
                    if (y_a > y_b || y_a > y_c) break block64;
                    if (y_a >= bottomY) break block65;
                    if (y_b > bottomY) {
                        y_b = bottomY;
                    }
                    if (y_c > bottomY) {
                        y_c = bottomY;
                    }
                    z_a = z_a - depth_slope * (float)x_a + depth_slope;
                    if (y_b < y_c) {
                        x_c = x_a <<= 16;
                        if (y_a < 0) {
                            x_c -= c_to_a * y_a;
                            x_a -= a_to_b * y_a;
                            z_a -= depth_increment * (float)y_a;
                            y_a = 0;
                        }
                        x_b <<= 16;
                        if (y_b < 0) {
                            x_b -= b_to_c * y_b;
                            y_b = 0;
                        }
                        if (y_a != y_b && c_to_a < a_to_b || y_a == y_b && c_to_a > b_to_c) {
                            y_c -= y_b;
                            y_b -= y_a;
                            y_a = line_offsets[y_a];
                            while (--y_b >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_c >> 16, x_a >> 16, z_a, depth_slope);
                                x_c += c_to_a;
                                x_a += a_to_b;
                                z_a += depth_increment;
                                y_a += width;
                            }
                            while (--y_c >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_c >> 16, x_b >> 16, z_a, depth_slope);
                                x_c += c_to_a;
                                x_b += b_to_c;
                                z_a += depth_increment;
                                y_a += width;
                            }
                        } else {
                            y_c -= y_b;
                            y_b -= y_a;
                            y_a = line_offsets[y_a];
                            while (--y_b >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_a >> 16, x_c >> 16, z_a, depth_slope);
                                x_c += c_to_a;
                                x_a += a_to_b;
                                z_a += depth_increment;
                                y_a += width;
                            }
                            while (--y_c >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_b >> 16, x_c >> 16, z_a, depth_slope);
                                x_c += c_to_a;
                                x_b += b_to_c;
                                z_a += depth_increment;
                                y_a += width;
                            }
                        }
                    } else {
                        x_b = x_a <<= 16;
                        if (y_a < 0) {
                            x_b -= c_to_a * y_a;
                            x_a -= a_to_b * y_a;
                            z_a -= depth_increment * (float)y_a;
                            y_a = 0;
                        }
                        x_c <<= 16;
                        if (y_c < 0) {
                            x_c -= b_to_c * y_c;
                            y_c = 0;
                        }
                        if (y_a != y_c && c_to_a < a_to_b || y_a == y_c && b_to_c > a_to_b) {
                            y_b -= y_c;
                            y_c -= y_a;
                            y_a = line_offsets[y_a];
                            while (--y_c >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_b >> 16, x_a >> 16, z_a, depth_slope);
                                x_b += c_to_a;
                                x_a += a_to_b;
                                z_a += depth_increment;
                                y_a += width;
                            }
                            while (--y_b >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_c >> 16, x_a >> 16, z_a, depth_slope);
                                x_c += b_to_c;
                                x_a += a_to_b;
                                z_a += depth_increment;
                                y_a += width;
                            }
                        } else {
                            y_b -= y_c;
                            y_c -= y_a;
                            y_a = line_offsets[y_a];
                            while (--y_c >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_a >> 16, x_b >> 16, z_a, depth_slope);
                                x_b += c_to_a;
                                x_a += a_to_b;
                                z_a += depth_increment;
                                y_a += width;
                            }
                            while (--y_b >= 0) {
                                Rasterizer3D.drawDepthTriangleScanline(y_a, x_a >> 16, x_c >> 16, z_a, depth_slope);
                                x_c += b_to_c;
                                x_a += a_to_b;
                                z_a += depth_increment;
                                y_a += width;
                            }
                        }
                    }
                    break block65;
                }
                if (y_b > y_c) break block66;
                if (y_b >= bottomY) break block65;
                if (y_c > bottomY) {
                    y_c = bottomY;
                }
                if (y_a > bottomY) {
                    y_a = bottomY;
                }
                z_b = z_b - depth_slope * (float)x_b + depth_slope;
                if (y_c < y_a) {
                    x_a = x_b <<= 16;
                    if (y_b < 0) {
                        x_a -= a_to_b * y_b;
                        x_b -= b_to_c * y_b;
                        z_b -= depth_increment * (float)y_b;
                        y_b = 0;
                    }
                    x_c <<= 16;
                    if (y_c < 0) {
                        x_c -= c_to_a * y_c;
                        y_c = 0;
                    }
                    if (y_b != y_c && a_to_b < b_to_c || y_b == y_c && a_to_b > c_to_a) {
                        y_a -= y_c;
                        y_c -= y_b;
                        y_b = line_offsets[y_b];
                        while (--y_c >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_a >> 16, x_b >> 16, z_b, depth_slope);
                            x_a += a_to_b;
                            x_b += b_to_c;
                            z_b += depth_increment;
                            y_b += width;
                        }
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_a >> 16, x_c >> 16, z_b, depth_slope);
                            x_a += a_to_b;
                            x_c += c_to_a;
                            z_b += depth_increment;
                            y_b += width;
                        }
                    } else {
                        y_a -= y_c;
                        y_c -= y_b;
                        y_b = line_offsets[y_b];
                        while (--y_c >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_b >> 16, x_a >> 16, z_b, depth_slope);
                            x_a += a_to_b;
                            x_b += b_to_c;
                            z_b += depth_increment;
                            y_b += width;
                        }
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_c >> 16, x_a >> 16, z_b, depth_slope);
                            x_a += a_to_b;
                            x_c += c_to_a;
                            z_b += depth_increment;
                            y_b += width;
                        }
                    }
                } else {
                    x_c = x_b <<= 16;
                    if (y_b < 0) {
                        x_c -= a_to_b * y_b;
                        x_b -= b_to_c * y_b;
                        z_b -= depth_increment * (float)y_b;
                        y_b = 0;
                    }
                    x_a <<= 16;
                    if (y_a < 0) {
                        x_a -= c_to_a * y_a;
                        y_a = 0;
                    }
                    if (a_to_b < b_to_c) {
                        y_c -= y_a;
                        y_a -= y_b;
                        y_b = line_offsets[y_b];
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_c >> 16, x_b >> 16, z_b, depth_slope);
                            x_c += a_to_b;
                            x_b += b_to_c;
                            z_b += depth_increment;
                            y_b += width;
                        }
                        while (--y_c >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_a >> 16, x_b >> 16, z_b, depth_slope);
                            x_a += c_to_a;
                            x_b += b_to_c;
                            z_b += depth_increment;
                            y_b += width;
                        }
                    } else {
                        y_c -= y_a;
                        y_a -= y_b;
                        y_b = line_offsets[y_b];
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_b >> 16, x_c >> 16, z_b, depth_slope);
                            x_c += a_to_b;
                            x_b += b_to_c;
                            z_b += depth_increment;
                            y_b += width;
                        }
                        while (--y_c >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_b, x_b >> 16, x_a >> 16, z_b, depth_slope);
                            x_a += c_to_a;
                            x_b += b_to_c;
                            z_b += depth_increment;
                            y_b += width;
                        }
                    }
                }
                break block65;
            }
            if (y_c < bottomY) {
                if (y_a > bottomY) {
                    y_a = bottomY;
                }
                if (y_b > bottomY) {
                    y_b = bottomY;
                }
                z_c = z_c - depth_slope * (float)x_c + depth_slope;
                if (y_a < y_b) {
                    x_b = x_c <<= 16;
                    if (y_c < 0) {
                        x_b -= b_to_c * y_c;
                        x_c -= c_to_a * y_c;
                        z_c -= depth_increment * (float)y_c;
                        y_c = 0;
                    }
                    x_a <<= 16;
                    if (y_a < 0) {
                        x_a -= a_to_b * y_a;
                        y_a = 0;
                    }
                    if (b_to_c < c_to_a) {
                        y_b -= y_a;
                        y_a -= y_c;
                        y_c = line_offsets[y_c];
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_b >> 16, x_c >> 16, z_c, depth_slope);
                            x_b += b_to_c;
                            x_c += c_to_a;
                            z_c += depth_increment;
                            y_c += width;
                        }
                        while (--y_b >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_b >> 16, x_a >> 16, z_c, depth_slope);
                            x_b += b_to_c;
                            x_a += a_to_b;
                            z_c += depth_increment;
                            y_c += width;
                        }
                    } else {
                        y_b -= y_a;
                        y_a -= y_c;
                        y_c = line_offsets[y_c];
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_c >> 16, x_b >> 16, z_c, depth_slope);
                            x_b += b_to_c;
                            x_c += c_to_a;
                            z_c += depth_increment;
                            y_c += width;
                        }
                        while (--y_b >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_a >> 16, x_b >> 16, z_c, depth_slope);
                            x_b += b_to_c;
                            x_a += a_to_b;
                            z_c += depth_increment;
                            y_c += width;
                        }
                    }
                } else {
                    x_a = x_c <<= 16;
                    if (y_c < 0) {
                        x_a -= b_to_c * y_c;
                        x_c -= c_to_a * y_c;
                        z_c -= depth_increment * (float)y_c;
                        y_c = 0;
                    }
                    x_b <<= 16;
                    if (y_b < 0) {
                        x_b -= a_to_b * y_b;
                        y_b = 0;
                    }
                    if (b_to_c < c_to_a) {
                        y_a -= y_b;
                        y_b -= y_c;
                        y_c = line_offsets[y_c];
                        while (--y_b >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_a >> 16, x_c >> 16, z_c, depth_slope);
                            x_a += b_to_c;
                            x_c += c_to_a;
                            z_c += depth_increment;
                            y_c += width;
                        }
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_b >> 16, x_c >> 16, z_c, depth_slope);
                            x_b += a_to_b;
                            x_c += c_to_a;
                            z_c += depth_increment;
                            y_c += width;
                        }
                    } else {
                        y_a -= y_b;
                        y_b -= y_c;
                        y_c = line_offsets[y_c];
                        while (--y_b >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_c >> 16, x_a >> 16, z_c, depth_slope);
                            x_a += b_to_c;
                            x_c += c_to_a;
                            z_c += depth_increment;
                            y_c += width;
                        }
                        while (--y_a >= 0) {
                            Rasterizer3D.drawDepthTriangleScanline(y_c, x_c >> 16, x_b >> 16, z_c, depth_slope);
                            x_b += a_to_b;
                            x_c += c_to_a;
                            z_c += depth_increment;
                            y_c += width;
                        }
                    }
                }
            }
        }
    }

    private static void drawDepthTriangleScanline(int dest_off, int start_x, int end_x, float depth, float depth_slope) {
        int dbl = depth_buffer.length;
        if (testX) {
            if (end_x > width) {
                end_x = width;
            }
            if (start_x < 0) {
                start_x = 0;
            }
        }
        if (start_x >= end_x) {
            return;
        }
        dest_off += start_x - 1;
        int loops = end_x - start_x >> 2;
        depth += depth_slope * (float)start_x;
        if (alpha == 0) {
            while (--loops >= 0) {
                if (++dest_off >= 0 && dest_off < dbl) {
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                }
                depth += depth_slope;
                if (++dest_off >= 0 && dest_off < dbl) {
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                }
                depth += depth_slope;
                if (++dest_off >= 0 && dest_off < dbl) {
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                }
                depth += depth_slope;
                if (++dest_off >= 0 && dest_off < dbl) {
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                }
                depth += depth_slope;
            }
            loops = end_x - start_x & 3;
            while (--loops >= 0) {
                if (++dest_off >= 0 && dest_off < dbl) {
                    Rasterizer3D.depth_buffer[dest_off] = depth;
                }
                depth += depth_slope;
            }
            return;
        }
        while (--loops >= 0) {
            if (++dest_off >= 0 && dest_off < dbl) {
                Rasterizer3D.depth_buffer[dest_off] = depth;
            }
            depth += depth_slope;
            if (++dest_off >= 0 && dest_off < dbl) {
                Rasterizer3D.depth_buffer[dest_off] = depth;
            }
            depth += depth_slope;
            if (++dest_off >= 0 && dest_off < dbl) {
                Rasterizer3D.depth_buffer[dest_off] = depth;
            }
            depth += depth_slope;
            if (++dest_off >= 0 && dest_off < dbl) {
                Rasterizer3D.depth_buffer[dest_off] = depth;
            }
            depth += depth_slope;
        }
        loops = end_x - start_x & 3;
        while (--loops >= 0) {
            if (++dest_off >= 0 && dest_off < dbl) {
                Rasterizer3D.depth_buffer[dest_off] = depth;
            }
            depth += depth_slope;
        }
    }

    static final int light(int hsl, int light) {
        if ((light = light * (hsl & 0x7F) >> 7) < 2) {
            light = 2;
        } else if (light > 126) {
            light = 126;
        }
        return (hsl & 0xFF80) + light;
    }

    public static final void drawTexturedTriangle(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int hue_a, int hue_b, int hue_c, int viewport_x_a, int viewport_x_b, int viewport_x_c, int viewport_y_a, int viewport_y_b, int viewport_y_c, int viewport_z_a, int viewport_z_b, int viewport_z_c, int texture_id, float depth_a, float depth_b, float depth_c) {
        if (depth_a < 0.0f || depth_b < 0.0f || depth_c < 0.0f) {
            return;
        }
        int[] texels = Rasterizer3D.get_texels(texture_id)[scale];
        if (texels == null) {
            System.out.println("[DEBUG] drawTexturedTriangle() : texels == null");
            int hsl = 0;
            Rasterizer3D.drawShadedTriangle(y_a, y_b, y_c, x_a, x_b, x_c, Rasterizer3D.light(hsl, hue_a), Rasterizer3D.light(hsl, hue_b), Rasterizer3D.light(hsl, hue_c), depth_a, depth_b, depth_c);
        } else {
            int var34;
            opaque = !transparent[texture_id];
            int var22 = x_b - x_a;
            int var24 = y_b - y_a;
            int var25 = x_c - x_a;
            int var36 = y_c - y_a;
            int var35 = hue_b - hue_a;
            int var37 = hue_c - hue_a;
            int var26 = 0;
            if (y_b != y_a) {
                var26 = (x_b - x_a << 14) / (y_b - y_a);
            }
            int var33 = 0;
            if (y_c != y_b) {
                var33 = (x_c - x_b << 14) / (y_c - y_b);
            }
            int var23 = 0;
            if (y_c != y_a) {
                var23 = (x_a - x_c << 14) / (y_a - y_c);
            }
            if ((var34 = var22 * var36 - var25 * var24) != 0) {
                int var27 = (var35 * var36 - var37 * var24 << 9) / var34;
                int var38 = (var37 * var22 - var35 * var25 << 9) / var34;
                viewport_x_b = viewport_x_a - viewport_x_b;
                viewport_y_b = viewport_y_a - viewport_y_b;
                viewport_z_b = viewport_z_a - viewport_z_b;
                int var20 = (viewport_x_c -= viewport_x_a) * viewport_y_a - (viewport_y_c -= viewport_y_a) * viewport_x_a << (SceneGraph.view_dist == 9 ? 14 : 15);
                int var30 = (int)(((long)(viewport_y_c * viewport_z_a - (viewport_z_c -= viewport_z_a) * viewport_y_a) << 3 << 14) / (long)scene_div_factor);
                int var21 = (int)(((long)(viewport_z_c * viewport_x_a - viewport_x_c * viewport_z_a) << 14) / (long)scene_div_factor);
                int var28 = viewport_x_b * viewport_y_a - viewport_y_b * viewport_x_a << (SceneGraph.view_dist == 9 ? 14 : 15);
                int var31 = (int)(((long)(viewport_y_b * viewport_z_a - viewport_z_b * viewport_y_a) << 3 << 14) / (long)scene_div_factor);
                int var39 = (int)(((long)(viewport_z_b * viewport_x_a - viewport_x_b * viewport_z_a) << 14) / (long)scene_div_factor);
                int var29 = viewport_y_b * viewport_x_c - viewport_x_b * viewport_y_c << (SceneGraph.view_dist == 9 ? 14 : 15);
                int var32 = (int)(((long)(viewport_z_b * viewport_y_c - viewport_y_b * viewport_z_c) << 3 << 14) / (long)scene_div_factor);
                int var40 = (int)(((long)(viewport_x_b * viewport_z_c - viewport_z_b * viewport_x_c) << 14) / (long)scene_div_factor);
                float depth_slope = ((depth_b - depth_a) * (float)var36 - (depth_c - depth_a) * (float)var24) / (float)var34;
                float depth_increment = ((depth_c - depth_a) * (float)var22 - (depth_b - depth_a) * (float)var25) / (float)var34;
                if (y_a <= y_b && y_a <= y_c) {
                    if (y_a < bottomY) {
                        if (y_b > bottomY) {
                            y_b = bottomY;
                        }
                        if (y_c > bottomY) {
                            y_c = bottomY;
                        }
                        hue_a = (hue_a << 9) - var27 * x_a + var27;
                        depth_a = depth_a - depth_slope * (float)x_a + depth_slope;
                        if (y_b < y_c) {
                            x_c = x_a <<= 14;
                            if (y_a < 0) {
                                x_c -= var23 * y_a;
                                x_a -= var26 * y_a;
                                hue_a -= var38 * y_a;
                                depth_a -= depth_increment * (float)y_a;
                                y_a = 0;
                            }
                            x_b <<= 14;
                            if (y_b < 0) {
                                x_b -= var33 * y_b;
                                y_b = 0;
                            }
                            int var41 = y_a - textureInt2;
                            var20 += var21 * var41;
                            var28 += var39 * var41;
                            var29 += var40 * var41;
                            if (y_a != y_b && var23 < var26 || y_a == y_b && var23 > var33) {
                                y_c -= y_b;
                                y_b -= y_a;
                                y_a = line_offsets[y_a];
                                while (true) {
                                    if (--y_b < 0) {
                                        while (true) {
                                            if (--y_c < 0) {
                                                return;
                                            }
                                            Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_c >> 14, x_b >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                                            x_c += var23;
                                            x_b += var33;
                                            depth_a += depth_increment;
                                            hue_a += var38;
                                            y_a += width;
                                            var20 += var21;
                                            var28 += var39;
                                            var29 += var40;
                                        }
                                    }
                                    Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_c >> 14, x_a >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                                    x_c += var23;
                                    x_a += var26;
                                    depth_a += depth_increment;
                                    hue_a += var38;
                                    y_a += width;
                                    var20 += var21;
                                    var28 += var39;
                                    var29 += var40;
                                }
                            }
                            y_c -= y_b;
                            y_b -= y_a;
                            y_a = line_offsets[y_a];
                            while (true) {
                                if (--y_b < 0) {
                                    while (true) {
                                        if (--y_c < 0) {
                                            return;
                                        }
                                        Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_b >> 14, x_c >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                                        x_c += var23;
                                        x_b += var33;
                                        depth_a += depth_increment;
                                        hue_a += var38;
                                        y_a += width;
                                        var20 += var21;
                                        var28 += var39;
                                        var29 += var40;
                                    }
                                }
                                Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_a >> 14, x_c >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                                x_c += var23;
                                x_a += var26;
                                depth_a += depth_increment;
                                hue_a += var38;
                                y_a += width;
                                var20 += var21;
                                var28 += var39;
                                var29 += var40;
                            }
                        }
                        x_b = x_a <<= 14;
                        if (y_a < 0) {
                            x_b -= var23 * y_a;
                            x_a -= var26 * y_a;
                            depth_a -= depth_increment * (float)y_a;
                            hue_a -= var38 * y_a;
                            y_a = 0;
                        }
                        x_c <<= 14;
                        if (y_c < 0) {
                            x_c -= var33 * y_c;
                            y_c = 0;
                        }
                        int var41 = y_a - textureInt2;
                        var20 += var21 * var41;
                        var28 += var39 * var41;
                        var29 += var40 * var41;
                        if (y_a != y_c && var23 < var26 || y_a == y_c && var33 > var26) {
                            y_b -= y_c;
                            y_c -= y_a;
                            y_a = line_offsets[y_a];
                            while (true) {
                                if (--y_c < 0) {
                                    while (true) {
                                        if (--y_b < 0) {
                                            return;
                                        }
                                        Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_c >> 14, x_a >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                                        x_c += var33;
                                        x_a += var26;
                                        depth_a += depth_increment;
                                        hue_a += var38;
                                        y_a += width;
                                        var20 += var21;
                                        var28 += var39;
                                        var29 += var40;
                                    }
                                }
                                Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_b >> 14, x_a >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                                x_b += var23;
                                x_a += var26;
                                depth_a += depth_increment;
                                hue_a += var38;
                                y_a += width;
                                var20 += var21;
                                var28 += var39;
                                var29 += var40;
                            }
                        }
                        y_b -= y_c;
                        y_c -= y_a;
                        y_a = line_offsets[y_a];
                        while (true) {
                            if (--y_c < 0) {
                                while (true) {
                                    if (--y_b < 0) {
                                        return;
                                    }
                                    Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_a >> 14, x_c >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                                    x_c += var33;
                                    x_a += var26;
                                    depth_a += depth_increment;
                                    hue_a += var38;
                                    y_a += width;
                                    var20 += var21;
                                    var28 += var39;
                                    var29 += var40;
                                }
                            }
                            Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_a, x_a >> 14, x_b >> 14, hue_a, var27, var20, var28, var29, var30, var31, var32, depth_a, depth_slope);
                            x_b += var23;
                            x_a += var26;
                            depth_a += depth_increment;
                            hue_a += var38;
                            y_a += width;
                            var20 += var21;
                            var28 += var39;
                            var29 += var40;
                        }
                    }
                } else if (y_b <= y_c) {
                    if (y_b < bottomY) {
                        if (y_c > bottomY) {
                            y_c = bottomY;
                        }
                        if (y_a > bottomY) {
                            y_a = bottomY;
                        }
                        hue_b = (hue_b << 9) - var27 * x_b + var27;
                        depth_b = depth_b - depth_slope * (float)x_b + depth_slope;
                        if (y_c < y_a) {
                            x_a = x_b <<= 14;
                            if (y_b < 0) {
                                x_a -= var26 * y_b;
                                x_b -= var33 * y_b;
                                depth_b -= depth_increment * (float)y_b;
                                hue_b -= var38 * y_b;
                                y_b = 0;
                            }
                            x_c <<= 14;
                            if (y_c < 0) {
                                x_c -= var23 * y_c;
                                y_c = 0;
                            }
                            int var41 = y_b - textureInt2;
                            var20 += var21 * var41;
                            var28 += var39 * var41;
                            var29 += var40 * var41;
                            if (y_b != y_c && var26 < var33 || y_b == y_c && var26 > var23) {
                                y_a -= y_c;
                                y_c -= y_b;
                                y_b = line_offsets[y_b];
                                while (true) {
                                    if (--y_c < 0) {
                                        while (true) {
                                            if (--y_a < 0) {
                                                return;
                                            }
                                            Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_a >> 14, x_c >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                                            x_a += var26;
                                            x_c += var23;
                                            depth_b += depth_increment;
                                            hue_b += var38;
                                            y_b += width;
                                            var20 += var21;
                                            var28 += var39;
                                            var29 += var40;
                                        }
                                    }
                                    Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_a >> 14, x_b >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                                    x_a += var26;
                                    x_b += var33;
                                    depth_b += depth_increment;
                                    hue_b += var38;
                                    y_b += width;
                                    var20 += var21;
                                    var28 += var39;
                                    var29 += var40;
                                }
                            }
                            y_a -= y_c;
                            y_c -= y_b;
                            y_b = line_offsets[y_b];
                            while (true) {
                                if (--y_c < 0) {
                                    while (true) {
                                        if (--y_a < 0) {
                                            return;
                                        }
                                        Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_c >> 14, x_a >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                                        x_a += var26;
                                        x_c += var23;
                                        depth_b += depth_increment;
                                        hue_b += var38;
                                        y_b += width;
                                        var20 += var21;
                                        var28 += var39;
                                        var29 += var40;
                                    }
                                }
                                Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_b >> 14, x_a >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                                x_a += var26;
                                x_b += var33;
                                depth_b += depth_increment;
                                hue_b += var38;
                                y_b += width;
                                var20 += var21;
                                var28 += var39;
                                var29 += var40;
                            }
                        }
                        x_c = x_b <<= 14;
                        if (y_b < 0) {
                            x_c -= var26 * y_b;
                            x_b -= var33 * y_b;
                            depth_b -= depth_increment * (float)y_b;
                            hue_b -= var38 * y_b;
                            y_b = 0;
                        }
                        x_a <<= 14;
                        if (y_a < 0) {
                            x_a -= var23 * y_a;
                            y_a = 0;
                        }
                        int var41 = y_b - textureInt2;
                        var20 += var21 * var41;
                        var28 += var39 * var41;
                        var29 += var40 * var41;
                        if (var26 < var33) {
                            y_c -= y_a;
                            y_a -= y_b;
                            y_b = line_offsets[y_b];
                            while (true) {
                                if (--y_a < 0) {
                                    while (true) {
                                        if (--y_c < 0) {
                                            return;
                                        }
                                        Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_a >> 14, x_b >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                                        x_a += var23;
                                        x_b += var33;
                                        depth_b += depth_increment;
                                        hue_b += var38;
                                        y_b += width;
                                        var20 += var21;
                                        var28 += var39;
                                        var29 += var40;
                                    }
                                }
                                Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_c >> 14, x_b >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                                x_c += var26;
                                x_b += var33;
                                depth_b += depth_increment;
                                hue_b += var38;
                                y_b += width;
                                var20 += var21;
                                var28 += var39;
                                var29 += var40;
                            }
                        }
                        y_c -= y_a;
                        y_a -= y_b;
                        y_b = line_offsets[y_b];
                        while (true) {
                            if (--y_a < 0) {
                                while (true) {
                                    if (--y_c < 0) {
                                        return;
                                    }
                                    Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_b >> 14, x_a >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                                    x_a += var23;
                                    x_b += var33;
                                    depth_b += depth_increment;
                                    hue_b += var38;
                                    y_b += width;
                                    var20 += var21;
                                    var28 += var39;
                                    var29 += var40;
                                }
                            }
                            Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_b, x_b >> 14, x_c >> 14, hue_b, var27, var20, var28, var29, var30, var31, var32, depth_b, depth_slope);
                            x_c += var26;
                            x_b += var33;
                            depth_b += depth_increment;
                            hue_b += var38;
                            y_b += width;
                            var20 += var21;
                            var28 += var39;
                            var29 += var40;
                        }
                    }
                } else if (y_c < bottomY) {
                    if (y_a > bottomY) {
                        y_a = bottomY;
                    }
                    if (y_b > bottomY) {
                        y_b = bottomY;
                    }
                    depth_c = depth_c - depth_slope * (float)x_c + depth_slope;
                    hue_c = (hue_c << 9) - var27 * x_c + var27;
                    if (y_a < y_b) {
                        x_b = x_c <<= 14;
                        if (y_c < 0) {
                            x_b -= var33 * y_c;
                            x_c -= var23 * y_c;
                            depth_c -= depth_increment * (float)y_c;
                            hue_c -= var38 * y_c;
                            y_c = 0;
                        }
                        x_a <<= 14;
                        if (y_a < 0) {
                            x_a -= var26 * y_a;
                            y_a = 0;
                        }
                        int var41 = y_c - textureInt2;
                        var20 += var21 * var41;
                        var28 += var39 * var41;
                        var29 += var40 * var41;
                        if (var33 < var23) {
                            y_b -= y_a;
                            y_a -= y_c;
                            y_c = line_offsets[y_c];
                            while (true) {
                                if (--y_a < 0) {
                                    while (true) {
                                        if (--y_b < 0) {
                                            return;
                                        }
                                        Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_b >> 14, x_a >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                                        x_b += var33;
                                        x_a += var26;
                                        depth_c += depth_increment;
                                        hue_c += var38;
                                        y_c += width;
                                        var20 += var21;
                                        var28 += var39;
                                        var29 += var40;
                                    }
                                }
                                Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_b >> 14, x_c >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                                x_b += var33;
                                x_c += var23;
                                depth_c += depth_increment;
                                hue_c += var38;
                                y_c += width;
                                var20 += var21;
                                var28 += var39;
                                var29 += var40;
                            }
                        }
                        y_b -= y_a;
                        y_a -= y_c;
                        y_c = line_offsets[y_c];
                        while (true) {
                            if (--y_a < 0) {
                                while (true) {
                                    if (--y_b < 0) {
                                        return;
                                    }
                                    Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_a >> 14, x_b >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                                    x_b += var33;
                                    x_a += var26;
                                    depth_c += depth_increment;
                                    hue_c += var38;
                                    y_c += width;
                                    var20 += var21;
                                    var28 += var39;
                                    var29 += var40;
                                }
                            }
                            Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_c >> 14, x_b >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                            x_b += var33;
                            x_c += var23;
                            depth_c += depth_increment;
                            hue_c += var38;
                            y_c += width;
                            var20 += var21;
                            var28 += var39;
                            var29 += var40;
                        }
                    }
                    x_a = x_c <<= 14;
                    if (y_c < 0) {
                        x_a -= var33 * y_c;
                        x_c -= var23 * y_c;
                        depth_c -= depth_increment * (float)y_c;
                        hue_c -= var38 * y_c;
                        y_c = 0;
                    }
                    x_b <<= 14;
                    if (y_b < 0) {
                        x_b -= var26 * y_b;
                        y_b = 0;
                    }
                    int var41 = y_c - textureInt2;
                    var20 += var21 * var41;
                    var28 += var39 * var41;
                    var29 += var40 * var41;
                    if (var33 < var23) {
                        y_a -= y_b;
                        y_b -= y_c;
                        y_c = line_offsets[y_c];
                        while (true) {
                            if (--y_b < 0) {
                                while (true) {
                                    if (--y_a < 0) {
                                        return;
                                    }
                                    Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_b >> 14, x_c >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                                    x_b += var26;
                                    x_c += var23;
                                    depth_c += depth_increment;
                                    hue_c += var38;
                                    y_c += width;
                                    var20 += var21;
                                    var28 += var39;
                                    var29 += var40;
                                }
                            }
                            Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_a >> 14, x_c >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                            x_a += var33;
                            x_c += var23;
                            depth_c += depth_increment;
                            hue_c += var38;
                            y_c += width;
                            var20 += var21;
                            var28 += var39;
                            var29 += var40;
                        }
                    }
                    y_a -= y_b;
                    y_b -= y_c;
                    y_c = line_offsets[y_c];
                    while (true) {
                        if (--y_b < 0) {
                            while (true) {
                                if (--y_a < 0) {
                                    return;
                                }
                                Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_c >> 14, x_b >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                                x_b += var26;
                                x_c += var23;
                                depth_c += depth_increment;
                                hue_c += var38;
                                y_c += width;
                                var20 += var21;
                                var28 += var39;
                                var29 += var40;
                            }
                        }
                        Rasterizer3D.draw_textured_scanline(pixels, texels, 0, 0, y_c, x_c >> 14, x_a >> 14, hue_c, var27, var20, var28, var29, var30, var31, var32, depth_c, depth_slope);
                        x_a += var33;
                        x_c += var23;
                        depth_c += depth_increment;
                        hue_c += var38;
                        y_c += width;
                        var20 += var21;
                        var28 += var39;
                        var29 += var40;
                    }
                }
            }
        }
    }

    static final void draw_textured_scanline(int[] dest, int[] texel_map, int offsets, int src, int dest_offset, int start_x, int end_x, int shade, int gradient, int var9, int var10, int var11, int var12, int var13, int var14, float depth, float depth_slope) {
        if (start_x >= end_x) {
            return;
        }
        if (testX) {
            if (end_x > Rasterizer2D.centerX2) {
                end_x = Rasterizer2D.centerX2;
            }
            if (start_x < 0) {
                start_x = 0;
            }
            if (start_x >= end_x) {
                return;
            }
        }
        if (start_x < end_x) {
            dest_offset += start_x;
            depth += depth_slope * (float)start_x;
            shade += gradient * start_x;
            int var22 = end_x - start_x;
            if (low_detail) {
                int var23;
                int var15;
                int loops;
                int rgb;
                int center_offset = start_x - textureInt1;
                var9 += (var12 >> 3) * center_offset;
                var10 += (var13 >> 3) * center_offset;
                int var21 = (var11 += (var14 >> 3) * center_offset) >> 12;
                if (var21 != 0) {
                    rgb = var9 / var21;
                    loops = var10 / var21;
                    if (rgb < 0) {
                        rgb = 0;
                    } else if (rgb > 4032) {
                        rgb = 4032;
                    }
                } else {
                    rgb = 0;
                    loops = 0;
                }
                var9 += var12;
                var10 += var13;
                var21 = (var11 += var14) >> 12;
                if (var21 != 0) {
                    var15 = var9 / var21;
                    var23 = var10 / var21;
                    if (var15 < 0) {
                        var15 = 0;
                    } else if (var15 > 4032) {
                        var15 = 4032;
                    }
                } else {
                    var15 = 0;
                    var23 = 0;
                }
                offsets = (rgb << 20) + loops;
                int var18 = (var15 - rgb >> 3 << 20) + (var23 - loops >> 3);
                var22 >>= 3;
                gradient <<= 3;
                int var16 = shade >> 8;
                if (opaque) {
                    if (var22 > 0) {
                        do {
                            src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            depth += depth_slope;
                            rgb = var15;
                            loops = var23;
                            var9 += var12;
                            var10 += var13;
                            var21 = (var11 += var14) >> 12;
                            if (var21 != 0) {
                                var15 = var9 / var21;
                                var23 = var10 / var21;
                                if (var15 < 0) {
                                    var15 = 0;
                                } else if (var15 > 4032) {
                                    var15 = 4032;
                                }
                            } else {
                                var15 = 0;
                                var23 = 0;
                            }
                            offsets = (rgb << 20) + loops;
                            var18 = (var15 - rgb >> 3 << 20) + (var23 - loops >> 3);
                            var16 = (shade += gradient) >> 8;
                        } while (--var22 > 0);
                    }
                    if ((var22 = end_x - start_x & 7) > 0) {
                        do {
                            src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0xFC0) + (offsets >>> 26))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth;
                            depth += depth_slope;
                            offsets += var18;
                        } while (--var22 > 0);
                    }
                } else {
                    if (var22 > 0) {
                        do {
                            if ((src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            rgb = var15;
                            loops = var23;
                            var9 += var12;
                            var10 += var13;
                            var21 = (var11 += var14) >> 12;
                            if (var21 != 0) {
                                var15 = var9 / var21;
                                var23 = var10 / var21;
                                if (var15 < 0) {
                                    var15 = 0;
                                } else if (var15 > 4032) {
                                    var15 = 4032;
                                }
                            } else {
                                var15 = 0;
                                var23 = 0;
                            }
                            offsets = (rgb << 20) + loops;
                            var18 = (var15 - rgb >> 3 << 20) + (var23 - loops >> 3);
                            var16 = (shade += gradient) >> 8;
                        } while (--var22 > 0);
                    }
                    if ((var22 = end_x - start_x & 7) > 0) {
                        do {
                            if ((src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0xFC0) + (offsets >>> 26))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            offsets += var18;
                        } while (--var22 > 0);
                    }
                }
            } else {
                int var23;
                int var15;
                int loops;
                int rgb;
                int center_offset = start_x - textureInt1;
                var9 += (var12 >> 3) * center_offset;
                var10 += (var13 >> 3) * center_offset;
                int var21 = (var11 += (var14 >> 3) * center_offset) >> 14;
                if (var21 != 0) {
                    rgb = var9 / var21;
                    loops = var10 / var21;
                    if (rgb < 0) {
                        rgb = 0;
                    } else if (rgb > 16256) {
                        rgb = 16256;
                    }
                } else {
                    rgb = 0;
                    loops = 0;
                }
                var9 += var12;
                var10 += var13;
                var21 = (var11 += var14) >> 14;
                if (var21 != 0) {
                    var15 = var9 / var21;
                    var23 = var10 / var21;
                    if (var15 < 0) {
                        var15 = 0;
                    } else if (var15 > 16256) {
                        var15 = 16256;
                    }
                } else {
                    var15 = 0;
                    var23 = 0;
                }
                offsets = (rgb << 18) + loops;
                int var18 = (var15 - rgb >> 3 << 18) + (var23 - loops >> 3);
                var22 >>= 3;
                gradient <<= 3;
                int var16 = shade >> 8;
                if (opaque) {
                    if (var22 > 0) {
                        do {
                            src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth += depth_slope;
                            depth += depth_slope;
                            rgb = var15;
                            loops = var23;
                            var9 += var12;
                            var10 += var13;
                            var21 = (var11 += var14) >> 14;
                            if (var21 != 0) {
                                var15 = var9 / var21;
                                var23 = var10 / var21;
                                if (var15 < 0) {
                                    var15 = 0;
                                } else if (var15 > 16256) {
                                    var15 = 16256;
                                }
                            } else {
                                var15 = 0;
                                var23 = 0;
                            }
                            offsets = (rgb << 18) + loops;
                            var18 = (var15 - rgb >> 3 << 18) + (var23 - loops >> 3);
                            var16 = (shade += gradient) >> 8;
                        } while (--var22 > 0);
                    }
                    if ((var22 = end_x - start_x & 7) > 0) {
                        do {
                            src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0x3F80) + (offsets >>> 25))];
                            dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                            Rasterizer3D.depth_buffer[dest_offset++] = depth;
                            depth += depth_slope;
                            offsets += var18;
                        } while (--var22 > 0);
                    }
                } else {
                    if (var22 > 0) {
                        do {
                            if ((src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            if ((src = texel_map[Rasterizer3D.get_texel_pos(((offsets += var18) & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            rgb = var15;
                            loops = var23;
                            var9 += var12;
                            var10 += var13;
                            var21 = (var11 += var14) >> 14;
                            if (var21 != 0) {
                                var15 = var9 / var21;
                                var23 = var10 / var21;
                                if (var15 < 0) {
                                    var15 = 0;
                                } else if (var15 > 16256) {
                                    var15 = 16256;
                                }
                            } else {
                                var15 = 0;
                                var23 = 0;
                            }
                            offsets = (rgb << 18) + loops;
                            var18 = (var15 - rgb >> 3 << 18) + (var23 - loops >> 3);
                            var16 = (shade += gradient) >> 8;
                        } while (--var22 > 0);
                    }
                    if ((var22 = end_x - start_x & 7) > 0) {
                        do {
                            if ((src = texel_map[Rasterizer3D.get_texel_pos((offsets & 0x3F80) + (offsets >>> 25))]) != 0) {
                                dest[dest_offset] = ((src & 0xFF00FF) * var16 & 0xFF00FF00) + ((src & 0xFF00) * var16 & 0xFF0000) >> 8;
                                Rasterizer3D.depth_buffer[dest_offset] = depth;
                            }
                            depth += depth_slope;
                            ++dest_offset;
                            offsets += var18;
                        } while (--var22 > 0);
                    }
                }
            }
        }
    }

    public static final void drawFlatTriangle(int var0, int var1, int var2, int var3, int var4, int var5, int var6, float z_a, float z_b, float z_c) {
        int var7 = 0;
        if (var1 != var0) {
            var7 = (var4 - var3 << 14) / (var1 - var0);
        }
        int var9 = 0;
        if (var2 != var1) {
            var9 = (var5 - var4 << 14) / (var2 - var1);
        }
        int var8 = 0;
        if (var2 != var0) {
            var8 = (var3 - var5 << 14) / (var0 - var2);
        }
        if (var0 <= var1 && var0 <= var2) {
            if (var0 < bottomY) {
                if (var1 > bottomY) {
                    var1 = bottomY;
                }
                if (var2 > bottomY) {
                    var2 = bottomY;
                }
                if (var1 < var2) {
                    var5 = var3 <<= 14;
                    if (var0 < 0) {
                        var5 -= var8 * var0;
                        var3 -= var7 * var0;
                        var0 = 0;
                    }
                    var4 <<= 14;
                    if (var1 < 0) {
                        var4 -= var9 * var1;
                        var1 = 0;
                    }
                    if (!(var0 != var1 && var8 < var7 || var0 == var1 && var8 > var9)) {
                        var2 -= var1;
                        var1 -= var0;
                        var0 = line_offsets[var0];
                        while (true) {
                            if (--var1 < 0) {
                                while (true) {
                                    if (--var2 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.method976(pixels, var0, var6, 0, var4 >> 14, var5 >> 14);
                                    var5 += var8;
                                    var4 += var9;
                                    var0 += width;
                                }
                            }
                            Rasterizer3D.method976(pixels, var0, var6, 0, var3 >> 14, var5 >> 14);
                            var5 += var8;
                            var3 += var7;
                            var0 += width;
                        }
                    }
                    var2 -= var1;
                    var1 -= var0;
                    var0 = line_offsets[var0];
                    while (true) {
                        if (--var1 < 0) {
                            while (true) {
                                if (--var2 < 0) {
                                    return;
                                }
                                Rasterizer3D.method976(pixels, var0, var6, 0, var5 >> 14, var4 >> 14);
                                var5 += var8;
                                var4 += var9;
                                var0 += width;
                            }
                        }
                        Rasterizer3D.method976(pixels, var0, var6, 0, var5 >> 14, var3 >> 14);
                        var5 += var8;
                        var3 += var7;
                        var0 += width;
                    }
                }
                var4 = var3 <<= 14;
                if (var0 < 0) {
                    var4 -= var8 * var0;
                    var3 -= var7 * var0;
                    var0 = 0;
                }
                var5 <<= 14;
                if (var2 < 0) {
                    var5 -= var9 * var2;
                    var2 = 0;
                }
                if (var0 != var2 && var8 < var7 || var0 == var2 && var9 > var7) {
                    var1 -= var2;
                    var2 -= var0;
                    var0 = line_offsets[var0];
                    while (true) {
                        if (--var2 < 0) {
                            while (true) {
                                if (--var1 < 0) {
                                    return;
                                }
                                Rasterizer3D.method976(pixels, var0, var6, 0, var5 >> 14, var3 >> 14);
                                var5 += var9;
                                var3 += var7;
                                var0 += width;
                            }
                        }
                        Rasterizer3D.method976(pixels, var0, var6, 0, var4 >> 14, var3 >> 14);
                        var4 += var8;
                        var3 += var7;
                        var0 += width;
                    }
                }
                var1 -= var2;
                var2 -= var0;
                var0 = line_offsets[var0];
                while (true) {
                    if (--var2 < 0) {
                        while (true) {
                            if (--var1 < 0) {
                                return;
                            }
                            Rasterizer3D.method976(pixels, var0, var6, 0, var3 >> 14, var5 >> 14);
                            var5 += var9;
                            var3 += var7;
                            var0 += width;
                        }
                    }
                    Rasterizer3D.method976(pixels, var0, var6, 0, var3 >> 14, var4 >> 14);
                    var4 += var8;
                    var3 += var7;
                    var0 += width;
                }
            }
        } else if (var1 <= var2) {
            if (var1 < bottomY) {
                if (var2 > bottomY) {
                    var2 = bottomY;
                }
                if (var0 > bottomY) {
                    var0 = bottomY;
                }
                if (var2 < var0) {
                    var3 = var4 <<= 14;
                    if (var1 < 0) {
                        var3 -= var7 * var1;
                        var4 -= var9 * var1;
                        var1 = 0;
                    }
                    var5 <<= 14;
                    if (var2 < 0) {
                        var5 -= var8 * var2;
                        var2 = 0;
                    }
                    if (!(var1 != var2 && var7 < var9 || var1 == var2 && var7 > var8)) {
                        var0 -= var2;
                        var2 -= var1;
                        var1 = line_offsets[var1];
                        while (true) {
                            if (--var2 < 0) {
                                while (true) {
                                    if (--var0 < 0) {
                                        return;
                                    }
                                    Rasterizer3D.method976(pixels, var1, var6, 0, var5 >> 14, var3 >> 14);
                                    var3 += var7;
                                    var5 += var8;
                                    var1 += width;
                                }
                            }
                            Rasterizer3D.method976(pixels, var1, var6, 0, var4 >> 14, var3 >> 14);
                            var3 += var7;
                            var4 += var9;
                            var1 += width;
                        }
                    }
                    var0 -= var2;
                    var2 -= var1;
                    var1 = line_offsets[var1];
                    while (true) {
                        if (--var2 < 0) {
                            while (true) {
                                if (--var0 < 0) {
                                    return;
                                }
                                Rasterizer3D.method976(pixels, var1, var6, 0, var3 >> 14, var5 >> 14);
                                var3 += var7;
                                var5 += var8;
                                var1 += width;
                            }
                        }
                        Rasterizer3D.method976(pixels, var1, var6, 0, var3 >> 14, var4 >> 14);
                        var3 += var7;
                        var4 += var9;
                        var1 += width;
                    }
                }
                var5 = var4 <<= 14;
                if (var1 < 0) {
                    var5 -= var7 * var1;
                    var4 -= var9 * var1;
                    var1 = 0;
                }
                var3 <<= 14;
                if (var0 < 0) {
                    var3 -= var8 * var0;
                    var0 = 0;
                }
                if (var7 < var9) {
                    var2 -= var0;
                    var0 -= var1;
                    var1 = line_offsets[var1];
                    while (true) {
                        if (--var0 < 0) {
                            while (true) {
                                if (--var2 < 0) {
                                    return;
                                }
                                Rasterizer3D.method976(pixels, var1, var6, 0, var3 >> 14, var4 >> 14);
                                var3 += var8;
                                var4 += var9;
                                var1 += width;
                            }
                        }
                        Rasterizer3D.method976(pixels, var1, var6, 0, var5 >> 14, var4 >> 14);
                        var5 += var7;
                        var4 += var9;
                        var1 += width;
                    }
                }
                var2 -= var0;
                var0 -= var1;
                var1 = line_offsets[var1];
                while (true) {
                    if (--var0 < 0) {
                        while (true) {
                            if (--var2 < 0) {
                                return;
                            }
                            Rasterizer3D.method976(pixels, var1, var6, 0, var4 >> 14, var3 >> 14);
                            var3 += var8;
                            var4 += var9;
                            var1 += width;
                        }
                    }
                    Rasterizer3D.method976(pixels, var1, var6, 0, var4 >> 14, var5 >> 14);
                    var5 += var7;
                    var4 += var9;
                    var1 += width;
                }
            }
        } else if (var2 < bottomY) {
            if (var0 > bottomY) {
                var0 = bottomY;
            }
            if (var1 > bottomY) {
                var1 = bottomY;
            }
            if (var0 < var1) {
                var4 = var5 <<= 14;
                if (var2 < 0) {
                    var4 -= var9 * var2;
                    var5 -= var8 * var2;
                    var2 = 0;
                }
                var3 <<= 14;
                if (var0 < 0) {
                    var3 -= var7 * var0;
                    var0 = 0;
                }
                if (var9 < var8) {
                    var1 -= var0;
                    var0 -= var2;
                    var2 = line_offsets[var2];
                    while (true) {
                        if (--var0 < 0) {
                            while (true) {
                                if (--var1 < 0) {
                                    return;
                                }
                                Rasterizer3D.method976(pixels, var2, var6, 0, var4 >> 14, var3 >> 14);
                                var4 += var9;
                                var3 += var7;
                                var2 += width;
                            }
                        }
                        Rasterizer3D.method976(pixels, var2, var6, 0, var4 >> 14, var5 >> 14);
                        var4 += var9;
                        var5 += var8;
                        var2 += width;
                    }
                }
                var1 -= var0;
                var0 -= var2;
                var2 = line_offsets[var2];
                while (true) {
                    if (--var0 < 0) {
                        while (true) {
                            if (--var1 < 0) {
                                return;
                            }
                            Rasterizer3D.method976(pixels, var2, var6, 0, var3 >> 14, var4 >> 14);
                            var4 += var9;
                            var3 += var7;
                            var2 += width;
                        }
                    }
                    Rasterizer3D.method976(pixels, var2, var6, 0, var5 >> 14, var4 >> 14);
                    var4 += var9;
                    var5 += var8;
                    var2 += width;
                }
            }
            var3 = var5 <<= 14;
            if (var2 < 0) {
                var3 -= var9 * var2;
                var5 -= var8 * var2;
                var2 = 0;
            }
            var4 <<= 14;
            if (var1 < 0) {
                var4 -= var7 * var1;
                var1 = 0;
            }
            if (var9 < var8) {
                var0 -= var1;
                var1 -= var2;
                var2 = line_offsets[var2];
                while (true) {
                    if (--var1 < 0) {
                        while (true) {
                            if (--var0 < 0) {
                                return;
                            }
                            Rasterizer3D.method976(pixels, var2, var6, 0, var4 >> 14, var5 >> 14);
                            var4 += var7;
                            var5 += var8;
                            var2 += width;
                        }
                    }
                    Rasterizer3D.method976(pixels, var2, var6, 0, var3 >> 14, var5 >> 14);
                    var3 += var9;
                    var5 += var8;
                    var2 += width;
                }
            }
            var0 -= var1;
            var1 -= var2;
            var2 = line_offsets[var2];
            while (true) {
                if (--var1 < 0) {
                    while (true) {
                        if (--var0 < 0) {
                            return;
                        }
                        Rasterizer3D.method976(pixels, var2, var6, 0, var5 >> 14, var4 >> 14);
                        var4 += var7;
                        var5 += var8;
                        var2 += width;
                    }
                }
                Rasterizer3D.method976(pixels, var2, var6, 0, var5 >> 14, var3 >> 14);
                var3 += var9;
                var5 += var8;
                var2 += width;
            }
        }
    }

    static final void method976(int[] var0, int var1, int var2, int var3, int var4, int var5) {
        if (testX) {
            if (var5 > Rasterizer2D.centerX2) {
                var5 = Rasterizer2D.centerX2;
            }
            if (var4 < 0) {
                var4 = 0;
            }
        }
        if (var4 < var5) {
            var1 += var4;
            var3 = var5 - var4 >> 2;
            if (alpha != 0) {
                if (alpha == 254) {
                    while (true) {
                        if (--var3 < 0) {
                            var3 = var5 - var4 & 3;
                            while (true) {
                                if (--var3 < 0) {
                                    return;
                                }
                                var0[var1++] = var0[var1];
                            }
                        }
                        var0[var1++] = var0[var1];
                        var0[var1++] = var0[var1];
                        var0[var1++] = var0[var1];
                        var0[var1++] = var0[var1];
                    }
                }
                int var6 = alpha;
                int var8 = 256 - alpha;
                var2 = ((var2 & 0xFF00FF) * var8 >> 8 & 0xFF00FF) + ((var2 & 0xFF00) * var8 >> 8 & 0xFF00);
                while (true) {
                    int var7;
                    if (--var3 < 0) {
                        var3 = var5 - var4 & 3;
                        while (true) {
                            if (--var3 < 0) {
                                return;
                            }
                            var7 = var0[var1];
                            var0[var1++] = var2 + ((var7 & 0xFF00FF) * var6 >> 8 & 0xFF00FF) + ((var7 & 0xFF00) * var6 >> 8 & 0xFF00);
                        }
                    }
                    var7 = var0[var1];
                    var0[var1++] = var2 + ((var7 & 0xFF00FF) * var6 >> 8 & 0xFF00FF) + ((var7 & 0xFF00) * var6 >> 8 & 0xFF00);
                    var7 = var0[var1];
                    var0[var1++] = var2 + ((var7 & 0xFF00FF) * var6 >> 8 & 0xFF00FF) + ((var7 & 0xFF00) * var6 >> 8 & 0xFF00);
                    var7 = var0[var1];
                    var0[var1++] = var2 + ((var7 & 0xFF00FF) * var6 >> 8 & 0xFF00FF) + ((var7 & 0xFF00) * var6 >> 8 & 0xFF00);
                    var7 = var0[var1];
                    var0[var1++] = var2 + ((var7 & 0xFF00FF) * var6 >> 8 & 0xFF00FF) + ((var7 & 0xFF00) * var6 >> 8 & 0xFF00);
                }
            }
            while (true) {
                if (--var3 < 0) {
                    var3 = var5 - var4 & 3;
                    while (true) {
                        if (--var3 < 0) {
                            return;
                        }
                        var0[var1++] = var2;
                    }
                }
                var0[var1++] = var2;
                var0[var1++] = var2;
                var0[var1++] = var2;
                var0[var1++] = var2;
            }
        }
    }

    public static void drawGouraudTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int hsl1, int hsl2, int hsl3, float z1, float z2, float z3, int bufferOffset) {
        int rgb1 = HSL_TO_RGB[hsl1];
        int rgb2 = HSL_TO_RGB[hsl2];
        int rgb3 = HSL_TO_RGB[hsl3];
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int r3 = rgb3 >> 16 & 0xFF;
        int g3 = rgb3 >> 8 & 0xFF;
        int b3 = rgb3 & 0xFF;
        int dx1 = 0;
        int dr1 = 0;
        int dg1 = 0;
        int db1 = 0;
        if (y2 != y1) {
            dx1 = (x2 - x1 << 16) / (y2 - y1);
            dr1 = (r2 - r1 << 16) / (y2 - y1);
            dg1 = (g2 - g1 << 16) / (y2 - y1);
            db1 = (b2 - b1 << 16) / (y2 - y1);
        }
        int dx2 = 0;
        int dr2 = 0;
        int dg2 = 0;
        int db2 = 0;
        if (y3 != y2) {
            dx2 = (x3 - x2 << 16) / (y3 - y2);
            dr2 = (r3 - r2 << 16) / (y3 - y2);
            dg2 = (g3 - g2 << 16) / (y3 - y2);
            db2 = (b3 - b2 << 16) / (y3 - y2);
        }
        int dx3 = 0;
        int dr3 = 0;
        int dg3 = 0;
        int db3 = 0;
        if (y3 != y1) {
            dx3 = (x1 - x3 << 16) / (y1 - y3);
            dr3 = (r1 - r3 << 16) / (y1 - y3);
            dg3 = (g1 - g3 << 16) / (y1 - y3);
            db3 = (b1 - b3 << 16) / (y1 - y3);
        }
        float x21 = x2 - x1;
        float y32 = y2 - y1;
        float x31 = x3 - x1;
        float y31 = y3 - y1;
        float z21 = z2 - z1;
        float z31 = z3 - z1;
        float div = x21 * y31 - x31 * y32;
        float depthSlope = (z21 * y31 - z31 * y32) / div;
        float depthScale = (z31 * x21 - z21 * x31) / div;
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= bottomY) {
                return;
            }
            if (y2 > bottomY) {
                y2 = bottomY;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            z1 = z1 - depthSlope * (float)x1 + depthSlope;
            if (y2 < y3) {
                x3 = x1 <<= 16;
                r3 = r1 <<= 16;
                g3 = g1 <<= 16;
                b3 = b1 <<= 16;
                if (y1 < 0) {
                    x3 -= dx3 * y1;
                    x1 -= dx1 * y1;
                    r3 -= dr3 * y1;
                    g3 -= dg3 * y1;
                    b3 -= db3 * y1;
                    r1 -= dr1 * y1;
                    g1 -= dg1 * y1;
                    b1 -= db1 * y1;
                    z1 -= depthScale * (float)y1;
                    y1 = 0;
                }
                x2 <<= 16;
                r2 <<= 16;
                g2 <<= 16;
                b2 <<= 16;
                if (y2 < 0) {
                    x2 -= dx2 * y2;
                    r2 -= dr2 * y2;
                    g2 -= dg2 * y2;
                    b2 -= db2 * y2;
                    y2 = 0;
                }
                if (y1 != y2 && dx3 < dx1 || y1 == y2 && dx3 > dx2) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = line_offsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer3D.drawGouraudScanline(pixels, y1, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z1, depthSlope, bufferOffset);
                        x3 += dx3;
                        x1 += dx1;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        z1 += depthScale;
                        y1 += width;
                    }
                    while (--y3 >= 0) {
                        Rasterizer3D.drawGouraudScanline(pixels, y1, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z1, depthSlope, bufferOffset);
                        x3 += dx3;
                        x2 += dx2;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        y1 += width;
                        z1 += depthScale;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = line_offsets[y1];
                while (--y2 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y1, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z1, depthSlope, bufferOffset);
                    x3 += dx3;
                    x1 += dx1;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z1 += depthScale;
                    y1 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y1, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z1, depthSlope, bufferOffset);
                    x3 += dx3;
                    x2 += dx2;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y1 += width;
                    z1 += depthScale;
                }
                return;
            }
            x2 = x1 <<= 16;
            r2 = r1 <<= 16;
            g2 = g1 <<= 16;
            b2 = b1 <<= 16;
            if (y1 < 0) {
                x2 -= dx3 * y1;
                x1 -= dx1 * y1;
                r2 -= dr3 * y1;
                g2 -= dg3 * y1;
                b2 -= db3 * y1;
                r1 -= dr1 * y1;
                g1 -= dg1 * y1;
                b1 -= db1 * y1;
                z1 -= depthScale * (float)y1;
                y1 = 0;
            }
            x3 <<= 16;
            r3 <<= 16;
            g3 <<= 16;
            b3 <<= 16;
            if (y3 < 0) {
                x3 -= dx2 * y3;
                r3 -= dr2 * y3;
                g3 -= dg2 * y3;
                b3 -= db2 * y3;
                y3 = 0;
            }
            if (y1 != y3 && dx3 < dx1 || y1 == y3 && dx2 > dx1) {
                y2 -= y3;
                y3 -= y1;
                y1 = line_offsets[y1];
                while (--y3 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y1, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z1, depthSlope, bufferOffset);
                    x2 += dx3;
                    x1 += dx1;
                    r2 += dr3;
                    g2 += dg3;
                    b2 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z1 += depthScale;
                    y1 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y1, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z1, depthSlope, bufferOffset);
                    x3 += dx2;
                    x1 += dx1;
                    r3 += dr2;
                    g3 += dg2;
                    b3 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y1 += width;
                    z1 += depthScale;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = line_offsets[y1];
            while (--y3 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y1, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z1, depthSlope, bufferOffset);
                x2 += dx3;
                x1 += dx1;
                r2 += dr3;
                g2 += dg3;
                b2 += db3;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z1 += depthScale;
                y1 += width;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y1, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z1, depthSlope, bufferOffset);
                x3 += dx2;
                x1 += dx1;
                r3 += dr2;
                g3 += dg2;
                b3 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                y1 += width;
                z1 += depthScale;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= bottomY) {
                return;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            if (y1 > bottomY) {
                y1 = bottomY;
            }
            z2 = z2 - depthSlope * (float)x2 + depthSlope;
            if (y3 < y1) {
                x1 = x2 <<= 16;
                r1 = r2 <<= 16;
                g1 = g2 <<= 16;
                b1 = b2 <<= 16;
                if (y2 < 0) {
                    x1 -= dx1 * y2;
                    x2 -= dx2 * y2;
                    r1 -= dr1 * y2;
                    g1 -= dg1 * y2;
                    b1 -= db1 * y2;
                    r2 -= dr2 * y2;
                    g2 -= dg2 * y2;
                    b2 -= db2 * y2;
                    z2 -= depthScale * (float)y2;
                    y2 = 0;
                }
                x3 <<= 16;
                r3 <<= 16;
                g3 <<= 16;
                b3 <<= 16;
                if (y3 < 0) {
                    x3 -= dx3 * y3;
                    r3 -= dr3 * y3;
                    g3 -= dg3 * y3;
                    b3 -= db3 * y3;
                    y3 = 0;
                }
                if (y2 != y3 && dx1 < dx2 || y2 == y3 && dx1 > dx3) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = line_offsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer3D.drawGouraudScanline(pixels, y2, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z2, depthSlope, bufferOffset);
                        x1 += dx1;
                        x2 += dx2;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        z2 += depthScale;
                        y2 += width;
                    }
                    while (--y1 >= 0) {
                        Rasterizer3D.drawGouraudScanline(pixels, y2, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z2, depthSlope, bufferOffset);
                        x1 += dx1;
                        x3 += dx3;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        y2 += width;
                        z2 += depthScale;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = line_offsets[y2];
                while (--y3 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y2, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z2, depthSlope, bufferOffset);
                    x1 += dx1;
                    x2 += dx2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z2 += depthScale;
                    y2 += width;
                }
                while (--y1 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y2, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z2, depthSlope, bufferOffset);
                    x1 += dx1;
                    x3 += dx3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    y2 += width;
                    z2 += depthScale;
                }
                return;
            }
            x3 = x2 <<= 16;
            r3 = r2 <<= 16;
            g3 = g2 <<= 16;
            b3 = b2 <<= 16;
            if (y2 < 0) {
                x3 -= dx1 * y2;
                x2 -= dx2 * y2;
                r3 -= dr1 * y2;
                g3 -= dg1 * y2;
                b3 -= db1 * y2;
                r2 -= dr2 * y2;
                g2 -= dg2 * y2;
                b2 -= db2 * y2;
                z2 -= depthScale * (float)y2;
                y2 = 0;
            }
            x1 <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y1 < 0) {
                x1 -= dx3 * y1;
                r1 -= dr3 * y1;
                g1 -= dg3 * y1;
                b1 -= db3 * y1;
                y1 = 0;
            }
            if (dx1 < dx2) {
                y3 -= y1;
                y1 -= y2;
                y2 = line_offsets[y2];
                while (--y1 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y2, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z2, depthSlope, bufferOffset);
                    x3 += dx1;
                    x2 += dx2;
                    r3 += dr1;
                    g3 += dg1;
                    b3 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z2 += depthScale;
                    y2 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y2, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z2, depthSlope, bufferOffset);
                    x1 += dx3;
                    x2 += dx2;
                    r1 += dr3;
                    g1 += dg3;
                    b1 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y2 += width;
                    z2 += depthScale;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = line_offsets[y2];
            while (--y1 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y2, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z2, depthSlope, bufferOffset);
                x3 += dx1;
                x2 += dx2;
                r3 += dr1;
                g3 += dg1;
                b3 += db1;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                z2 += depthScale;
                y2 += width;
            }
            while (--y3 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y2, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z2, depthSlope, bufferOffset);
                x1 += dx3;
                x2 += dx2;
                r1 += dr3;
                g1 += dg3;
                b1 += db3;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                y2 += width;
                z2 += depthScale;
            }
            return;
        }
        if (y3 >= bottomY) {
            return;
        }
        if (y1 > bottomY) {
            y1 = bottomY;
        }
        if (y2 > bottomY) {
            y2 = bottomY;
        }
        z3 = z3 - depthSlope * (float)x3 + depthSlope;
        if (y1 < y2) {
            x2 = x3 <<= 16;
            r2 = r3 <<= 16;
            g2 = g3 <<= 16;
            b2 = b3 <<= 16;
            if (y3 < 0) {
                x2 -= dx2 * y3;
                x3 -= dx3 * y3;
                r2 -= dr2 * y3;
                g2 -= dg2 * y3;
                b2 -= db2 * y3;
                r3 -= dr3 * y3;
                g3 -= dg3 * y3;
                b3 -= db3 * y3;
                z3 -= depthScale * (float)y3;
                y3 = 0;
            }
            x1 <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y1 < 0) {
                x1 -= dx1 * y1;
                r1 -= dr1 * y1;
                g1 -= dg1 * y1;
                b1 -= db1 * y1;
                y1 = 0;
            }
            if (dx2 < dx3) {
                y2 -= y1;
                y1 -= y3;
                y3 = line_offsets[y3];
                while (--y1 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y3, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z3, depthSlope, bufferOffset);
                    x2 += dx2;
                    x3 += dx3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    z3 += depthScale;
                    y3 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawGouraudScanline(pixels, y3, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z3, depthSlope, bufferOffset);
                    x2 += dx2;
                    x1 += dx1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y3 += width;
                    z3 += depthScale;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = line_offsets[y3];
            while (--y1 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y3, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z3, depthSlope, bufferOffset);
                x2 += dx2;
                x3 += dx3;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z3 += depthScale;
                y3 += width;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y3, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z3, depthSlope, bufferOffset);
                x2 += dx2;
                x1 += dx1;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z3 += depthScale;
                y3 += width;
            }
            return;
        }
        x1 = x3 <<= 16;
        r1 = r3 <<= 16;
        g1 = g3 <<= 16;
        b1 = b3 <<= 16;
        if (y3 < 0) {
            x1 -= dx2 * y3;
            x3 -= dx3 * y3;
            r1 -= dr2 * y3;
            g1 -= dg2 * y3;
            b1 -= db2 * y3;
            r3 -= dr3 * y3;
            g3 -= dg3 * y3;
            b3 -= db3 * y3;
            z3 -= depthScale * (float)y3;
            y3 = 0;
        }
        x2 <<= 16;
        r2 <<= 16;
        g2 <<= 16;
        b2 <<= 16;
        if (y2 < 0) {
            x2 -= dx1 * y2;
            r2 -= dr1 * y2;
            g2 -= dg1 * y2;
            b2 -= db1 * y2;
            y2 = 0;
        }
        if (dx2 < dx3) {
            y1 -= y2;
            y2 -= y3;
            y3 = line_offsets[y3];
            while (--y2 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y3, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z3, depthSlope, bufferOffset);
                x1 += dx2;
                x3 += dx3;
                r1 += dr2;
                g1 += dg2;
                b1 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z3 += depthScale;
                y3 += width;
            }
            while (--y1 >= 0) {
                Rasterizer3D.drawGouraudScanline(pixels, y3, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z3, depthSlope, bufferOffset);
                x2 += dx1;
                x3 += dx3;
                r2 += dr1;
                g2 += dg1;
                b2 += db1;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z3 += depthScale;
                y3 += width;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = line_offsets[y3];
        while (--y2 >= 0) {
            Rasterizer3D.drawGouraudScanline(pixels, y3, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z3, depthSlope, bufferOffset);
            x1 += dx2;
            x3 += dx3;
            r1 += dr2;
            g1 += dg2;
            b1 += db2;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            z3 += depthScale;
            y3 += width;
        }
        while (--y1 >= 0) {
            Rasterizer3D.drawGouraudScanline(pixels, y3, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z3, depthSlope, bufferOffset);
            x2 += dx1;
            x3 += dx3;
            r2 += dr1;
            g2 += dg1;
            b2 += db1;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            y3 += width;
            z3 += depthScale;
        }
    }

    public static void drawGouraudScanline(int[] dest, int offset, int x1, int x2, int r1, int g1, int b1, int r2, int g2, int b2, float z1, float z2, int bufferOffset) {
        block10: {
            int n = x2 - x1;
            if (n <= 0) {
                return;
            }
            r2 = (r2 - r1) / n;
            g2 = (g2 - g1) / n;
            b2 = (b2 - b1) / n;
            if (testX) {
                if (x2 > Rasterizer2D.centerX2) {
                    n -= x2 - Rasterizer2D.centerX2;
                    x2 = Rasterizer2D.centerX2;
                }
                if (x1 < 0) {
                    n = x2;
                    r1 -= x1 * r2;
                    g1 -= x1 * g2;
                    b1 -= x1 * b2;
                    x1 = 0;
                }
            }
            if (x1 >= x2) break block10;
            offset += x1;
            z1 += z2 * (float)x1;
            if (alpha == 0) {
                while (--n >= 0) {
                    if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                        dest[offset] = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                        Rasterizer3D.depth_buffer[offset] = z1;
                    }
                    z1 += z2;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                    ++offset;
                }
            } else {
                int a1 = alpha;
                int a2 = 256 - alpha;
                while (--n >= 0) {
                    if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                        int rgb = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                        rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
                        int dst = dest[offset];
                        dest[offset] = rgb + ((dst & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dst & 0xFF00) * a1 >> 8 & 0xFF00);
                        Rasterizer3D.depth_buffer[offset] = z1;
                    }
                    ++offset;
                    z1 += z2;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                }
            }
        }
    }

    public static void drawFlatTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int rgb, float z1, float z2, float z3, int bufferOffset) {
        int dx1 = 0;
        if (y2 != y1) {
            dx1 = (x2 - x1 << 16) / (y2 - y1);
        }
        int dx2 = 0;
        if (y3 != y2) {
            dx2 = (x3 - x2 << 16) / (y3 - y2);
        }
        int dx3 = 0;
        if (y3 != y1) {
            dx3 = (x1 - x3 << 16) / (y1 - y3);
        }
        float x21 = x2 - x1;
        float y32 = y2 - y1;
        float x31 = x3 - x1;
        float y31 = y3 - y1;
        float z21 = z2 - z1;
        float z31 = z3 - z1;
        float div = x21 * y31 - x31 * y32;
        float depthSlope = (z21 * y31 - z31 * y32) / div;
        float depthScale = (z31 * x21 - z21 * x31) / div;
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= bottomY) {
                return;
            }
            if (y2 > bottomY) {
                y2 = bottomY;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            z1 = z1 - depthSlope * (float)x1 + depthSlope;
            if (y2 < y3) {
                x3 = x1 <<= 16;
                if (y1 < 0) {
                    x3 -= dx3 * y1;
                    x1 -= dx1 * y1;
                    z1 -= depthScale * (float)y1;
                    y1 = 0;
                }
                x2 <<= 16;
                if (y2 < 0) {
                    x2 -= dx2 * y2;
                    y2 = 0;
                }
                if (y1 != y2 && dx3 < dx1 || y1 == y2 && dx3 > dx2) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = line_offsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x3 >> 16, x1 >> 16, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += dx3;
                        x1 += dx1;
                        y1 += width;
                    }
                    while (--y3 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x3 >> 16, x2 >> 16, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += dx3;
                        x2 += dx2;
                        y1 += width;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = line_offsets[y1];
                while (--y2 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x1 >> 16, x3 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += dx3;
                    x1 += dx1;
                    y1 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x2 >> 16, x3 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += dx3;
                    x2 += dx2;
                    y1 += width;
                }
                return;
            }
            x2 = x1 <<= 16;
            if (y1 < 0) {
                x2 -= dx3 * y1;
                x1 -= dx1 * y1;
                z1 -= depthScale * (float)y1;
                y1 = 0;
            }
            x3 <<= 16;
            if (y3 < 0) {
                x3 -= dx2 * y3;
                y3 = 0;
            }
            if (y1 != y3 && dx3 < dx1 || y1 == y3 && dx2 > dx1) {
                y2 -= y3;
                y3 -= y1;
                y1 = line_offsets[y1];
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x2 >> 16, x1 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x2 += dx3;
                    x1 += dx1;
                    y1 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x3 >> 16, x1 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += dx2;
                    x1 += dx1;
                    y1 += width;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = line_offsets[y1];
            while (--y3 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x1 >> 16, x2 >> 16, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x2 += dx3;
                x1 += dx1;
                y1 += width;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x1 >> 16, x3 >> 16, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x3 += dx2;
                x1 += dx1;
                y1 += width;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= bottomY) {
                return;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            if (y1 > bottomY) {
                y1 = bottomY;
            }
            z2 = z2 - depthSlope * (float)x2 + depthSlope;
            if (y3 < y1) {
                x1 = x2 <<= 16;
                if (y2 < 0) {
                    x1 -= dx1 * y2;
                    x2 -= dx2 * y2;
                    z2 -= depthScale * (float)y2;
                    y2 = 0;
                }
                x3 <<= 16;
                if (y3 < 0) {
                    x3 -= dx3 * y3;
                    y3 = 0;
                }
                if (y2 != y3 && dx1 < dx2 || y2 == y3 && dx1 > dx3) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = line_offsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x1 >> 16, x2 >> 16, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += dx1;
                        x2 += dx2;
                        y2 += width;
                    }
                    while (--y1 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x1 >> 16, x3 >> 16, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += dx1;
                        x3 += dx3;
                        y2 += width;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = line_offsets[y2];
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x2 >> 16, x1 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += dx1;
                    x2 += dx2;
                    y2 += width;
                }
                while (--y1 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x3 >> 16, x1 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += dx1;
                    x3 += dx3;
                    y2 += width;
                }
                return;
            }
            x3 = x2 <<= 16;
            if (y2 < 0) {
                x3 -= dx1 * y2;
                x2 -= dx2 * y2;
                z2 -= depthScale * (float)y2;
                y2 = 0;
            }
            x1 <<= 16;
            if (y1 < 0) {
                x1 -= dx3 * y1;
                y1 = 0;
            }
            if (dx1 < dx2) {
                y3 -= y1;
                y1 -= y2;
                y2 = line_offsets[y2];
                while (--y1 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x3 >> 16, x2 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x3 += dx1;
                    x2 += dx2;
                    y2 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x1 >> 16, x2 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += dx3;
                    x2 += dx2;
                    y2 += width;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = line_offsets[y2];
            while (--y1 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x2 >> 16, x3 >> 16, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x3 += dx1;
                x2 += dx2;
                y2 += width;
            }
            while (--y3 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x2 >> 16, x1 >> 16, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x1 += dx3;
                x2 += dx2;
                y2 += width;
            }
            return;
        }
        if (y3 >= bottomY) {
            return;
        }
        if (y1 > bottomY) {
            y1 = bottomY;
        }
        if (y2 > bottomY) {
            y2 = bottomY;
        }
        z3 = z3 - depthSlope * (float)x3 + depthSlope;
        if (y1 < y2) {
            x2 = x3 <<= 16;
            if (y3 < 0) {
                x2 -= dx2 * y3;
                x3 -= dx3 * y3;
                z3 -= depthScale * (float)y3;
                y3 = 0;
            }
            x1 <<= 16;
            if (y1 < 0) {
                x1 -= dx1 * y1;
                y1 = 0;
            }
            if (dx2 < dx3) {
                y2 -= y1;
                y1 -= y3;
                y3 = line_offsets[y3];
                while (--y1 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x2 >> 16, x3 >> 16, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += dx2;
                    x3 += dx3;
                    y3 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x2 >> 16, x1 >> 16, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += dx2;
                    x1 += dx1;
                    y3 += width;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = line_offsets[y3];
            while (--y1 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x3 >> 16, x2 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += dx2;
                x3 += dx3;
                y3 += width;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x1 >> 16, x2 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += dx2;
                x1 += dx1;
                y3 += width;
            }
            return;
        }
        x1 = x3 <<= 16;
        if (y3 < 0) {
            x1 -= dx2 * y3;
            x3 -= dx3 * y3;
            z3 -= depthScale * (float)y3;
            y3 = 0;
        }
        x2 <<= 16;
        if (y2 < 0) {
            x2 -= dx1 * y2;
            y2 = 0;
        }
        if (dx2 < dx3) {
            y1 -= y2;
            y2 -= y3;
            y3 = line_offsets[y3];
            while (--y2 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x1 >> 16, x3 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x1 += dx2;
                x3 += dx3;
                y3 += width;
            }
            while (--y1 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x2 >> 16, x3 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += dx1;
                x3 += dx3;
                y3 += width;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = line_offsets[y3];
        while (--y2 >= 0) {
            Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x3 >> 16, x1 >> 16, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x1 += dx2;
            x3 += dx3;
            y3 += width;
        }
        while (--y1 >= 0) {
            Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x3 >> 16, x2 >> 16, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x2 += dx1;
            x3 += dx3;
            y3 += width;
        }
    }

    private static void drawFlatScanline(int[] dest, int offset, int rgb, int x1, int x2, float z1, float z2, int bufferOffset) {
        if (x1 >= x2) {
            return;
        }
        if (testX) {
            if (x2 > Rasterizer2D.centerX2) {
                x2 = Rasterizer2D.centerX2;
            }
            if (x1 < 0) {
                x1 = 0;
            }
        }
        if (x1 >= x2) {
            return;
        }
        offset += x1;
        z1 += z2 * (float)x1;
        int n = x2 - x1;
        if (alpha == 0) {
            while (--n >= 0) {
                if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                    dest[offset] = rgb;
                    Rasterizer3D.depth_buffer[offset] = z1;
                }
                z1 += z2;
                ++offset;
            }
        } else {
            int a1 = alpha;
            int a2 = 256 - alpha;
            rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
            while (--n >= 0) {
                if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                    dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                    Rasterizer3D.depth_buffer[offset] = z1;
                }
                z1 += z2;
                ++offset;
            }
        }
    }

    public static void drawTexturedTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int c1, int c2, int c3, int tx1, int tx2, int tx3, int ty1, int ty2, int ty3, int tz1, int tz2, int tz3, int tex, float z1, float z2, float z3, int bufferOffset) {
        c1 = tex == 1 ? c1 << 1 : 127 - c1 << 1;
        c2 = tex == 1 ? c2 << 1 : 127 - c2 << 1;
        c3 = tex == 1 ? c3 << 1 : 127 - c3 << 1;
        int[] texels = Rasterizer3D.get_texels(tex)[scale];
        opaque = !transparent[tex];
        tx2 = tx1 - tx2;
        ty2 = ty1 - ty2;
        tz2 = tz1 - tz2;
        int l4 = (tx3 -= tx1) * ty1 - (ty3 -= ty1) * tx1 << (SceneGraph.view_dist == 9 ? 14 : 15);
        int i5 = ty3 * tz1 - (tz3 -= tz1) * ty1 << 8;
        int j5 = tz3 * tx1 - tx3 * tz1 << 5;
        int k5 = tx2 * ty1 - ty2 * tx1 << (SceneGraph.view_dist == 9 ? 14 : 15);
        int l5 = ty2 * tz1 - tz2 * ty1 << 8;
        int i6 = tz2 * tx1 - tx2 * tz1 << 5;
        int j6 = ty2 * tx3 - tx2 * ty3 << (SceneGraph.view_dist == 9 ? 14 : 15);
        int k6 = tz2 * ty3 - ty2 * tz3 << 8;
        int l6 = tx2 * tz3 - tz2 * tx3 << 5;
        int i7 = 0;
        int j7 = 0;
        if (y2 != y1) {
            i7 = (x2 - x1 << 16) / (y2 - y1);
            j7 = (c2 - c1 << 16) / (y2 - y1);
        }
        int k7 = 0;
        int l7 = 0;
        if (y3 != y2) {
            k7 = (x3 - x2 << 16) / (y3 - y2);
            l7 = (c3 - c2 << 16) / (y3 - y2);
        }
        int i8 = 0;
        int j8 = 0;
        if (y3 != y1) {
            i8 = (x1 - x3 << 16) / (y1 - y3);
            j8 = (c1 - c3 << 16) / (y1 - y3);
        }
        float x21 = x2 - x1;
        float y32 = y2 - y1;
        float x31 = x3 - x1;
        float y31 = y3 - y1;
        float z21 = z2 - z1;
        float z31 = z3 - z1;
        float div = x21 * y31 - x31 * y32;
        float depthSlope = (z21 * y31 - z31 * y32) / div;
        float depthScale = (z31 * x21 - z21 * x31) / div;
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= bottomY) {
                return;
            }
            if (y2 > bottomY) {
                y2 = bottomY;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            z1 = z1 - depthSlope * (float)x1 + depthSlope;
            if (y2 < y3) {
                x3 = x1 <<= 16;
                c3 = c1 <<= 16;
                if (y1 < 0) {
                    x3 -= i8 * y1;
                    x1 -= i7 * y1;
                    z1 -= depthScale * (float)y1;
                    c3 -= j8 * y1;
                    c1 -= j7 * y1;
                    y1 = 0;
                }
                x2 <<= 16;
                c2 <<= 16;
                if (y2 < 0) {
                    x2 -= k7 * y2;
                    c2 -= l7 * y2;
                    y2 = 0;
                }
                int k8 = y1 - textureInt2;
                l4 += j5 * k8;
                k5 += i6 * k8;
                j6 += l6 * k8;
                if (y1 != y2 && i8 < i7 || y1 == y2 && i8 > k7) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = line_offsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += i8;
                        x1 += i7;
                        c3 += j8;
                        c1 += j7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y3 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += i8;
                        x2 += k7;
                        c3 += j8;
                        c2 += l7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = line_offsets[y1];
                while (--y2 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += i8;
                    x1 += i7;
                    c3 += j8;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += i8;
                    x2 += k7;
                    c3 += j8;
                    c2 += l7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x2 = x1 <<= 16;
            c2 = c1 <<= 16;
            if (y1 < 0) {
                x2 -= i8 * y1;
                z1 -= depthScale * (float)y1;
                x1 -= i7 * y1;
                c2 -= j8 * y1;
                c1 -= j7 * y1;
                y1 = 0;
            }
            x3 <<= 16;
            c3 <<= 16;
            if (y3 < 0) {
                x3 -= k7 * y3;
                c3 -= l7 * y3;
                y3 = 0;
            }
            int l8 = y1 - textureInt2;
            l4 += j5 * l8;
            k5 += i6 * l8;
            j6 += l6 * l8;
            if (y1 != y3 && i8 < i7 || y1 == y3 && k7 > i7) {
                y2 -= y3;
                y3 -= y1;
                y1 = line_offsets[y1];
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x2 += i8;
                    x1 += i7;
                    c2 += j8;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += k7;
                    x1 += i7;
                    c3 += l7;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = line_offsets[y1];
            while (--y3 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x2 += i8;
                x1 += i7;
                c2 += j8;
                c1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y1, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x3 += k7;
                x1 += i7;
                c3 += l7;
                c1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= bottomY) {
                return;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            if (y1 > bottomY) {
                y1 = bottomY;
            }
            z2 = z2 - depthSlope * (float)x2 + depthSlope;
            if (y3 < y1) {
                x1 = x2 <<= 16;
                c1 = c2 <<= 16;
                if (y2 < 0) {
                    x1 -= i7 * y2;
                    x2 -= k7 * y2;
                    z2 -= depthScale * (float)y2;
                    c1 -= j7 * y2;
                    c2 -= l7 * y2;
                    y2 = 0;
                }
                x3 <<= 16;
                c3 <<= 16;
                if (y3 < 0) {
                    x3 -= i8 * y3;
                    c3 -= j8 * y3;
                    y3 = 0;
                }
                int i9 = y2 - textureInt2;
                l4 += j5 * i9;
                k5 += i6 * i9;
                j6 += l6 * i9;
                if (y2 != y3 && i7 < k7 || y2 == y3 && i7 > i8) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = line_offsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += i7;
                        x2 += k7;
                        c1 += j7;
                        c2 += l7;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y1 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += i7;
                        x3 += i8;
                        c1 += j7;
                        c3 += j8;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = line_offsets[y2];
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += i7;
                    x2 += k7;
                    c1 += j7;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y1 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += i7;
                    x3 += i8;
                    c1 += j7;
                    c3 += j8;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x3 = x2 <<= 16;
            c3 = c2 <<= 16;
            if (y2 < 0) {
                x3 -= i7 * y2;
                z2 -= depthScale * (float)y2;
                x2 -= k7 * y2;
                c3 -= j7 * y2;
                c2 -= l7 * y2;
                y2 = 0;
            }
            x1 <<= 16;
            c1 <<= 16;
            if (y1 < 0) {
                x1 -= i8 * y1;
                c1 -= j8 * y1;
                y1 = 0;
            }
            int j9 = y2 - textureInt2;
            l4 += j5 * j9;
            k5 += i6 * j9;
            j6 += l6 * j9;
            if (i7 < k7) {
                y3 -= y1;
                y1 -= y2;
                y2 = line_offsets[y2];
                while (--y1 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x3 += i7;
                    x2 += k7;
                    c3 += j7;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += i8;
                    x2 += k7;
                    c1 += j8;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = line_offsets[y2];
            while (--y1 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x3 += i7;
                x2 += k7;
                c3 += j7;
                c2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y3 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y2, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x1 += i8;
                x2 += k7;
                c1 += j8;
                c2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y3 >= bottomY) {
            return;
        }
        if (y1 > bottomY) {
            y1 = bottomY;
        }
        if (y2 > bottomY) {
            y2 = bottomY;
        }
        z3 = z3 - depthSlope * (float)x3 + depthSlope;
        if (y1 < y2) {
            x2 = x3 <<= 16;
            c2 = c3 <<= 16;
            if (y3 < 0) {
                x2 -= k7 * y3;
                x3 -= i8 * y3;
                z3 -= depthScale * (float)y3;
                c2 -= l7 * y3;
                c3 -= j8 * y3;
                y3 = 0;
            }
            x1 <<= 16;
            c1 <<= 16;
            if (y1 < 0) {
                x1 -= i7 * y1;
                c1 -= j7 * y1;
                y1 = 0;
            }
            int k9 = y3 - textureInt2;
            l4 += j5 * k9;
            k5 += i6 * k9;
            j6 += l6 * k9;
            if (k7 < i8) {
                y2 -= y1;
                y1 -= y3;
                y3 = line_offsets[y3];
                while (--y1 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += k7;
                    x3 += i8;
                    c2 += l7;
                    c3 += j8;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += k7;
                    x1 += i7;
                    c2 += l7;
                    c1 += j7;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = line_offsets[y3];
            while (--y1 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += k7;
                x3 += i8;
                c2 += l7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += k7;
                x1 += i7;
                c2 += l7;
                c1 += j7;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        x1 = x3 <<= 16;
        c1 = c3 <<= 16;
        if (y3 < 0) {
            x1 -= k7 * y3;
            x3 -= i8 * y3;
            z3 -= depthScale * (float)y3;
            c1 -= l7 * y3;
            c3 -= j8 * y3;
            y3 = 0;
        }
        x2 <<= 16;
        c2 <<= 16;
        if (y2 < 0) {
            x2 -= i7 * y2;
            c2 -= j7 * y2;
            y2 = 0;
        }
        int l9 = y3 - textureInt2;
        l4 += j5 * l9;
        k5 += i6 * l9;
        j6 += l6 * l9;
        if (k7 < i8) {
            y1 -= y2;
            y2 -= y3;
            y3 = line_offsets[y3];
            while (--y2 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x1 += k7;
                x3 += i8;
                c1 += l7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y1 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += i7;
                x3 += i8;
                c2 += j7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = line_offsets[y3];
        while (--y2 >= 0) {
            Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x1 += k7;
            x3 += i8;
            c1 += l7;
            c3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
        while (--y1 >= 0) {
            Rasterizer3D.drawTexturedScanline(pixels, texels, y3, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x2 += i7;
            x3 += i8;
            c2 += j7;
            c3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
    }

    private static void drawTexturedScanline(int[] dest, int[] src, int offset, int x1, int x2, int hsl1, int hsl2, int t1, int t2, int t3, int t4, int t5, int t6, float z1, float z2, int bufferOffset) {
        int darken = 0;
        int srcPos = 0;
        if (x1 >= x2) {
            return;
        }
        int dl = (hsl2 - hsl1) / (x2 - x1);
        if (testX) {
            if (x2 > Rasterizer2D.centerX2) {
                x2 = Rasterizer2D.centerX2;
            }
            if (x1 < 0) {
                hsl1 -= x1 * dl;
                x1 = 0;
            }
        }
        if (x1 >= x2) {
            return;
        }
        int n = x2 - x1 >> 3;
        offset += x1;
        z1 += z2 * (float)x1;
        int j4 = 0;
        int l4 = 0;
        int l6 = x1 - textureInt1;
        t1 += (t4 >> 3) * l6;
        t2 += (t5 >> 3) * l6;
        int l5 = (t3 += (t6 >> 3) * l6) >> 14;
        if (l5 != 0) {
            darken = t1 / l5;
            srcPos = t2 / l5;
            if (darken < 0) {
                darken = 0;
            } else if (darken > 16256) {
                darken = 16256;
            }
        }
        t1 += t4;
        t2 += t5;
        l5 = (t3 += t6) >> 14;
        if (l5 != 0) {
            j4 = t1 / l5;
            l4 = t2 / l5;
            if (j4 < 7) {
                j4 = 7;
            } else if (j4 > 16256) {
                j4 = 16256;
            }
        }
        int j7 = j4 - darken >> 3;
        int l7 = l4 - srcPos >> 3;
        if (opaque) {
            int l;
            int rgb;
            while (n-- > 0) {
                for (int x = 0; x < 8; ++x) {
                    rgb = src[(srcPos & 0x3F80) + (darken >> 7)];
                    l = hsl1 >> 16;
                    if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                        dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                        Rasterizer3D.depth_buffer[offset] = z1;
                    }
                    ++offset;
                    z1 += z2;
                    darken += j7;
                    srcPos += l7;
                    hsl1 += dl;
                }
                t1 += t4;
                t2 += t5;
                int i6 = (t3 += t6) >> 14;
                if (i6 != 0) {
                    j4 = t1 / i6;
                    l4 = t2 / i6;
                    if (j4 < 7) {
                        j4 = 7;
                    } else if (j4 > 16256) {
                        j4 = 16256;
                    }
                }
                j7 = j4 - darken >> 3;
                l7 = l4 - srcPos >> 3;
                hsl1 += dl;
            }
            n = x2 - x1 & 7;
            while (n-- > 0) {
                rgb = src[(srcPos & 0x3F80) + (darken >> 7)];
                l = hsl1 >> 16;
                if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer3D.depth_buffer[offset] = z1;
                }
                z1 += z2;
                ++offset;
                darken += j7;
                srcPos += l7;
                hsl1 += dl;
            }
            return;
        }
        while (n-- > 0) {
            for (int x = 0; x < 8; ++x) {
                int i9 = src[(srcPos & 0x3F80) + (darken >> 7)];
                if (i9 != 0) {
                    int l = hsl1 >> 16;
                    if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                        dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                        Rasterizer3D.depth_buffer[offset] = z1;
                    }
                }
                z1 += z2;
                ++offset;
                darken += j7;
                srcPos += l7;
                hsl1 += dl;
            }
            t1 += t4;
            t2 += t5;
            int j6 = (t3 += t6) >> 14;
            if (j6 != 0) {
                j4 = t1 / j6;
                l4 = t2 / j6;
                if (j4 < 7) {
                    j4 = 7;
                } else if (j4 > 16256) {
                    j4 = 16256;
                }
            }
            j7 = j4 - darken >> 3;
            l7 = l4 - srcPos >> 3;
            hsl1 += dl;
        }
        int l3 = x2 - x1 & 7;
        while (l3-- > 0) {
            int j9 = src[(srcPos & 0x3F80) + (darken >> 7)];
            if (j9 != 0) {
                int l = hsl1 >> 16;
                if (!mapped || z1 < depth_buffer[offset] || z1 < depth_buffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((j9 & 0xFF00FF) * l & 0xFF00FF00) + ((j9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer3D.depth_buffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            darken += j7;
            srcPos += l7;
            hsl1 += dl;
        }
    }

    public static void drawShadedTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int hsl1, int hsl2, int hsl3) {
        Rasterizer3D.drawShadedTriangle(y1, y2, y3, x1, x2, x3, hsl1, hsl2, hsl3, 0.0f, 0.0f, 0.0f);
    }

    private static void drawGouraudScanline(int[] dest, int offset, int x1, int x2, int hsl1, int hsl2) {
        if (aBoolean1464) {
            int k;
            int l1;
            if (testX) {
                l1 = x2 - x1 > 3 ? (hsl2 - hsl1) / (x2 - x1) : 0;
                if (x2 > Rasterizer2D.centerX2) {
                    x2 = Rasterizer2D.centerX2;
                }
                if (x1 < 0) {
                    hsl1 -= x1 * l1;
                    x1 = 0;
                }
                if (x1 >= x2) {
                    return;
                }
                offset += x1;
                k = x2 - x1 >> 2;
                l1 <<= 2;
            } else {
                if (x1 >= x2) {
                    return;
                }
                offset += x1;
                k = x2 - x1 >> 2;
                l1 = k > 0 ? (hsl2 - hsl1) * anIntArray1468[k] >> 15 : 0;
            }
            if (alpha == 0) {
                int j;
                while (--k >= 0) {
                    j = HSL_TO_RGB[hsl1 >> 8];
                    hsl1 += l1;
                    dest[offset] = j;
                    dest[++offset] = j;
                    dest[++offset] = j;
                    dest[++offset] = j;
                    ++offset;
                }
                k = x2 - x1 & 3;
                if (k > 0) {
                    j = HSL_TO_RGB[hsl1 >> 8];
                    do {
                        dest[offset] = j;
                        ++offset;
                    } while (--k > 0);
                    return;
                }
            } else {
                int j;
                int a1 = alpha;
                int a2 = 256 - alpha;
                while (--k >= 0) {
                    j = HSL_TO_RGB[hsl1 >> 8];
                    hsl1 += l1;
                    j = ((j & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((j & 0xFF00) * a2 >> 8 & 0xFF00);
                    dest[offset] = j + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                    dest[++offset] = j + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                    dest[++offset] = j + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                    dest[++offset] = j + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                    ++offset;
                }
                k = x2 - x1 & 3;
                if (k > 0) {
                    j = HSL_TO_RGB[hsl1 >> 8];
                    j = ((j & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((j & 0xFF00) * a2 >> 8 & 0xFF00);
                    do {
                        dest[offset] = j + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                        ++offset;
                    } while (--k > 0);
                }
            }
            return;
        }
        if (x1 >= x2) {
            return;
        }
        int i2 = (hsl2 - hsl1) / (x2 - x1);
        if (testX) {
            if (x2 > Rasterizer2D.centerX2) {
                x2 = Rasterizer2D.centerX2;
            }
            if (x1 < 0) {
                hsl1 -= x1 * i2;
                x1 = 0;
            }
            if (x1 >= x2) {
                return;
            }
        }
        offset += x1;
        int k = x2 - x1;
        if (alpha == 0) {
            do {
                dest[offset] = HSL_TO_RGB[hsl1 >> 8];
                ++offset;
                hsl1 += i2;
            } while (--k > 0);
            return;
        }
        int a1 = alpha;
        int a2 = 256 - alpha;
        do {
            int j = HSL_TO_RGB[hsl1 >> 8];
            hsl1 += i2;
            j = ((j & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((j & 0xFF00) * a2 >> 8 & 0xFF00);
            dest[offset] = j + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
            ++offset;
        } while (--k > 0);
    }

    public static void drawTexturedTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int c1, int c2, int c3, int tx1, int tx2, int tx3, int ty1, int ty2, int ty3, int tz1, int tz2, int tz3, int tex) {
        c1 = 127 - c1 << 1;
        c2 = 127 - c2 << 1;
        c3 = 127 - c3 << 1;
        int[] ai = Rasterizer3D.get_texels(tex)[scale];
        opaque = !transparent[tex];
        tx2 = tx1 - tx2;
        ty2 = ty1 - ty2;
        tz2 = tz1 - tz2;
        int l4 = (tx3 -= tx1) * ty1 - (ty3 -= ty1) * tx1 << (SceneGraph.view_dist == 9 ? 14 : 15);
        int i5 = ty3 * tz1 - (tz3 -= tz1) * ty1 << 8;
        int j5 = tz3 * tx1 - tx3 * tz1 << 5;
        int k5 = tx2 * ty1 - ty2 * tx1 << (SceneGraph.view_dist == 9 ? 14 : 15);
        int l5 = ty2 * tz1 - tz2 * ty1 << 8;
        int i6 = tz2 * tx1 - tx2 * tz1 << 5;
        int j6 = ty2 * tx3 - tx2 * ty3 << (SceneGraph.view_dist == 9 ? 14 : 15);
        int k6 = tz2 * ty3 - ty2 * tz3 << 8;
        int l6 = tx2 * tz3 - tz2 * tx3 << 5;
        int i7 = 0;
        int j7 = 0;
        if (y2 != y1) {
            i7 = (x2 - x1 << 16) / (y2 - y1);
            j7 = (c2 - c1 << 16) / (y2 - y1);
        }
        int k7 = 0;
        int l7 = 0;
        if (y3 != y2) {
            k7 = (x3 - x2 << 16) / (y3 - y2);
            l7 = (c3 - c2 << 16) / (y3 - y2);
        }
        int i8 = 0;
        int j8 = 0;
        if (y3 != y1) {
            i8 = (x1 - x3 << 16) / (y1 - y3);
            j8 = (c1 - c3 << 16) / (y1 - y3);
        }
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= bottomY) {
                return;
            }
            if (y2 > bottomY) {
                y2 = bottomY;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            if (y2 < y3) {
                x3 = x1 <<= 16;
                c3 = c1 <<= 16;
                if (y1 < 0) {
                    x3 -= i8 * y1;
                    x1 -= i7 * y1;
                    c3 -= j8 * y1;
                    c1 -= j7 * y1;
                    y1 = 0;
                }
                x2 <<= 16;
                c2 <<= 16;
                if (y2 < 0) {
                    x2 -= k7 * y2;
                    c2 -= l7 * y2;
                    y2 = 0;
                }
                int k8 = y1 - textureInt2;
                l4 += j5 * k8;
                k5 += i6 * k8;
                j6 += l6 * k8;
                if (y1 != y2 && i8 < i7 || y1 == y2 && i8 > k7) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = line_offsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6);
                        x3 += i8;
                        x1 += i7;
                        c3 += j8;
                        c1 += j7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y3 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6);
                        x3 += i8;
                        x2 += k7;
                        c3 += j8;
                        c2 += l7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = line_offsets[y1];
                while (--y2 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6);
                    x3 += i8;
                    x1 += i7;
                    c3 += j8;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6);
                    x3 += i8;
                    x2 += k7;
                    c3 += j8;
                    c2 += l7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x2 = x1 <<= 16;
            c2 = c1 <<= 16;
            if (y1 < 0) {
                x2 -= i8 * y1;
                x1 -= i7 * y1;
                c2 -= j8 * y1;
                c1 -= j7 * y1;
                y1 = 0;
            }
            x3 <<= 16;
            c3 <<= 16;
            if (y3 < 0) {
                x3 -= k7 * y3;
                c3 -= l7 * y3;
                y3 = 0;
            }
            int l8 = y1 - textureInt2;
            l4 += j5 * l8;
            k5 += i6 * l8;
            j6 += l6 * l8;
            if (y1 != y3 && i8 < i7 || y1 == y3 && k7 > i7) {
                y2 -= y3;
                y3 -= y1;
                y1 = line_offsets[y1];
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6);
                    x2 += i8;
                    x1 += i7;
                    c2 += j8;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6);
                    x3 += k7;
                    x1 += i7;
                    c3 += l7;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = line_offsets[y1];
            while (--y3 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6);
                x2 += i8;
                x1 += i7;
                c2 += j8;
                c1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y1, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6);
                x3 += k7;
                x1 += i7;
                c3 += l7;
                c1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= bottomY) {
                return;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            if (y1 > bottomY) {
                y1 = bottomY;
            }
            if (y3 < y1) {
                x1 = x2 <<= 16;
                c1 = c2 <<= 16;
                if (y2 < 0) {
                    x1 -= i7 * y2;
                    x2 -= k7 * y2;
                    c1 -= j7 * y2;
                    c2 -= l7 * y2;
                    y2 = 0;
                }
                x3 <<= 16;
                c3 <<= 16;
                if (y3 < 0) {
                    x3 -= i8 * y3;
                    c3 -= j8 * y3;
                    y3 = 0;
                }
                int i9 = y2 - textureInt2;
                l4 += j5 * i9;
                k5 += i6 * i9;
                j6 += l6 * i9;
                if (y2 != y3 && i7 < k7 || y2 == y3 && i7 > i8) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = line_offsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6);
                        x1 += i7;
                        x2 += k7;
                        c1 += j7;
                        c2 += l7;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y1 >= 0) {
                        Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6);
                        x1 += i7;
                        x3 += i8;
                        c1 += j7;
                        c3 += j8;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = line_offsets[y2];
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6);
                    x1 += i7;
                    x2 += k7;
                    c1 += j7;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y1 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6);
                    x1 += i7;
                    x3 += i8;
                    c1 += j7;
                    c3 += j8;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x3 = x2 <<= 16;
            c3 = c2 <<= 16;
            if (y2 < 0) {
                x3 -= i7 * y2;
                x2 -= k7 * y2;
                c3 -= j7 * y2;
                c2 -= l7 * y2;
                y2 = 0;
            }
            x1 <<= 16;
            c1 <<= 16;
            if (y1 < 0) {
                x1 -= i8 * y1;
                c1 -= j8 * y1;
                y1 = 0;
            }
            int j9 = y2 - textureInt2;
            l4 += j5 * j9;
            k5 += i6 * j9;
            j6 += l6 * j9;
            if (i7 < k7) {
                y3 -= y1;
                y1 -= y2;
                y2 = line_offsets[y2];
                while (--y1 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6);
                    x3 += i7;
                    x2 += k7;
                    c3 += j7;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6);
                    x1 += i8;
                    x2 += k7;
                    c1 += j8;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = line_offsets[y2];
            while (--y1 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6);
                x3 += i7;
                x2 += k7;
                c3 += j7;
                c2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y3 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y2, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6);
                x1 += i8;
                x2 += k7;
                c1 += j8;
                c2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y3 >= bottomY) {
            return;
        }
        if (y1 > bottomY) {
            y1 = bottomY;
        }
        if (y2 > bottomY) {
            y2 = bottomY;
        }
        if (y1 < y2) {
            x2 = x3 <<= 16;
            c2 = c3 <<= 16;
            if (y3 < 0) {
                x2 -= k7 * y3;
                x3 -= i8 * y3;
                c2 -= l7 * y3;
                c3 -= j8 * y3;
                y3 = 0;
            }
            x1 <<= 16;
            c1 <<= 16;
            if (y1 < 0) {
                x1 -= i7 * y1;
                c1 -= j7 * y1;
                y1 = 0;
            }
            int k9 = y3 - textureInt2;
            l4 += j5 * k9;
            k5 += i6 * k9;
            j6 += l6 * k9;
            if (k7 < i8) {
                y2 -= y1;
                y1 -= y3;
                y3 = line_offsets[y3];
                while (--y1 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6);
                    x2 += k7;
                    x3 += i8;
                    c2 += l7;
                    c3 += j8;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6);
                    x2 += k7;
                    x1 += i7;
                    c2 += l7;
                    c1 += j7;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = line_offsets[y3];
            while (--y1 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6);
                x2 += k7;
                x3 += i8;
                c2 += l7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6);
                x2 += k7;
                x1 += i7;
                c2 += l7;
                c1 += j7;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        x1 = x3 <<= 16;
        c1 = c3 <<= 16;
        if (y3 < 0) {
            x1 -= k7 * y3;
            x3 -= i8 * y3;
            c1 -= l7 * y3;
            c3 -= j8 * y3;
            y3 = 0;
        }
        x2 <<= 16;
        c2 <<= 16;
        if (y2 < 0) {
            x2 -= i7 * y2;
            c2 -= j7 * y2;
            y2 = 0;
        }
        int l9 = y3 - textureInt2;
        l4 += j5 * l9;
        k5 += i6 * l9;
        j6 += l6 * l9;
        if (k7 < i8) {
            y1 -= y2;
            y2 -= y3;
            y3 = line_offsets[y3];
            while (--y2 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6);
                x1 += k7;
                x3 += i8;
                c1 += l7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y1 >= 0) {
                Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6);
                x2 += i7;
                x3 += i8;
                c2 += j7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = line_offsets[y3];
        while (--y2 >= 0) {
            Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6);
            x1 += k7;
            x3 += i8;
            c1 += l7;
            c3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
        while (--y1 >= 0) {
            Rasterizer3D.drawTexturedScanline(pixels, ai, y3, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6);
            x2 += i7;
            x3 += i8;
            c2 += j7;
            c3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
    }

    private static void drawTexturedScanline(int[] raster, int[] texels, int k, int x1, int x2, int l1, int l2, int a1, int i2, int verticalC, int k2, int a2, int i3) {
        int uA = 0;
        int vA = 0;
        if (x1 >= x2) {
            return;
        }
        int dl = (l2 - l1) / (x2 - x1);
        if (testX) {
            if (x2 > Rasterizer2D.centerX2) {
                x2 = Rasterizer2D.centerX2;
            }
            if (x1 < 0) {
                l1 -= x1 * dl;
                x1 = 0;
            }
        }
        if (x1 >= x2) {
            return;
        }
        int n = x2 - x1 >> 3;
        k += x1;
        if (low_detail) {
            int l;
            int i4 = 0;
            int k4 = 0;
            int k6 = x1 - textureInt1;
            a1 += (k2 >> 3) * k6;
            i2 += (a2 >> 3) * k6;
            int c = (verticalC += (i3 >> 3) * k6) >> 12;
            if (c != 0) {
                uA = a1 / c;
                vA = i2 / c;
                if (!repeatTexture) {
                    if (uA < 0) {
                        uA = 0;
                    } else if (uA > 4032) {
                        uA = 4032;
                    }
                }
            }
            a1 += k2;
            i2 += a2;
            c = (verticalC += i3) >> 12;
            if (c != 0) {
                i4 = a1 / c;
                k4 = i2 / c;
                if (!repeatTexture) {
                    if (i4 < 7) {
                        i4 = 7;
                    } else if (i4 > 4032) {
                        i4 = 4032;
                    }
                }
            }
            int i7 = i4 - uA >> 3;
            int k7 = k4 - vA >> 3;
            if (opaque) {
                int l3;
                int rgb;
                while (n-- > 0) {
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : (vA & 0xFC0) + (uA >> 6))];
                    l3 = l1 >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                    l3 = (l1 += dl) >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                    l3 = (l1 += dl) >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                    l3 = (l1 += dl) >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                    l3 = (l1 += dl) >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                    l3 = (l1 += dl) >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                    l3 = (l1 += dl) >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                    l3 = (l1 += dl) >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    uA += i7;
                    vA += k7;
                    l1 += dl;
                    a1 += k2;
                    i2 += a2;
                    int j5 = (verticalC += i3) >> 12;
                    if (j5 != 0) {
                        i4 = a1 / j5;
                        k4 = i2 / j5;
                        if (!repeatTexture) {
                            if (i4 < 7) {
                                i4 = 7;
                            } else if (i4 > 4032) {
                                i4 = 4032;
                            }
                        }
                    }
                    i7 = i4 - uA >> 3;
                    k7 = k4 - vA >> 3;
                    l1 += dl;
                }
                n = x2 - x1 & 7;
                while (n-- > 0) {
                    rgb = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : (vA & 0xFC0) + (uA >> 6))];
                    l3 = l1 >> 16;
                    raster[k++] = ((rgb & 0xFF00FF) * l3 & 0xFF00FF00) + ((rgb & 0xFF00) * l3 & 0xFF0000) >> 8;
                    uA += i7;
                    vA += k7;
                    l1 += dl;
                }
                return;
            }
            while (n-- > 0) {
                int k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : (vA & 0xFC0) + (uA >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                l1 += dl;
                k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                l1 += dl;
                k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                l1 += dl;
                k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                l1 += dl;
                k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                l1 += dl;
                k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                l1 += dl;
                k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                l1 += dl;
                k8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : ((vA += k7) & 0xFC0) + ((uA += i7) >> 6))];
                if (k8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((k8 & 0xFF00FF) * l & 0xFF00FF00) + ((k8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                uA += i7;
                vA += k7;
                l1 += dl;
                a1 += k2;
                i2 += a2;
                int k5 = (verticalC += i3) >> 12;
                if (k5 != 0) {
                    i4 = a1 / k5;
                    k4 = i2 / k5;
                    if (i4 < 7) {
                        i4 = 7;
                    } else if (i4 > 4032) {
                        i4 = 4032;
                    }
                }
                i7 = i4 - uA >> 3;
                k7 = k4 - vA >> 3;
                l1 += dl;
            }
            n = x2 - x1 & 7;
            while (n-- > 0) {
                int l8 = texels[(vA & 0xFC0) + (uA >> 6) & (repeatTexture ? 4095 : (vA & 0xFC0) + (uA >> 6))];
                if (l8 != 0) {
                    l = l1 >> 16;
                    raster[k] = ((l8 & 0xFF00FF) * l & 0xFF00FF00) + ((l8 & 0xFF00) * l & 0xFF0000) >> 8;
                }
                ++k;
                uA += i7;
                vA += k7;
                l1 += dl;
            }
            return;
        }
        int j4 = 0;
        int l4 = 0;
        int l6 = x1 - textureInt1;
        a1 += (k2 >> 3) * l6;
        i2 += (a2 >> 3) * l6;
        int l5 = (verticalC += (i3 >> 3) * l6) >> 14;
        if (l5 != 0) {
            uA = a1 / l5;
            vA = i2 / l5;
            if (!repeatTexture) {
                if (uA < 0) {
                    uA = 0;
                } else if (uA > 16256) {
                    uA = 16256;
                }
            }
        }
        a1 += k2;
        i2 += a2;
        l5 = (verticalC += i3) >> 14;
        if (l5 != 0) {
            j4 = a1 / l5;
            l4 = i2 / l5;
            if (!repeatTexture) {
                if (j4 < 7) {
                    j4 = 7;
                } else if (j4 > 16256) {
                    j4 = 16256;
                }
            }
        }
        int j7 = j4 - uA >> 3;
        int l7 = l4 - vA >> 3;
        if (opaque) {
            int l;
            int rgb;
            while (n-- > 0) {
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : (vA & 0x3F80) + (uA >> 7))];
                l = l1 >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
                l = (l1 += dl) >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
                l = (l1 += dl) >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
                l = (l1 += dl) >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
                l = (l1 += dl) >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
                l = (l1 += dl) >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
                l = (l1 += dl) >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
                l = (l1 += dl) >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                uA += j7;
                vA += l7;
                l1 += dl;
                a1 += k2;
                i2 += a2;
                int i6 = (verticalC += i3) >> 14;
                if (i6 != 0) {
                    j4 = a1 / i6;
                    l4 = i2 / i6;
                    if (!repeatTexture) {
                        if (j4 < 7) {
                            j4 = 7;
                        } else if (j4 > 16256) {
                            j4 = 16256;
                        }
                    }
                }
                j7 = j4 - uA >> 3;
                l7 = l4 - vA >> 3;
                l1 += dl;
            }
            n = x2 - x1 & 7;
            while (n-- > 0) {
                rgb = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : (vA & 0x3F80) + (uA >> 7))];
                l = l1 >> 16;
                raster[k++] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                uA += j7;
                vA += l7;
                l1 += dl;
            }
            return;
        }
        while (n-- > 0) {
            int l;
            int i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : (vA & 0x3F80) + (uA >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            l1 += dl;
            i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            l1 += dl;
            i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            l1 += dl;
            i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            l1 += dl;
            i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            l1 += dl;
            i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            l1 += dl;
            i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            l1 += dl;
            i9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : ((vA += l7) & 0x3F80) + ((uA += j7) >> 7))];
            if (i9 != 0) {
                l = l1 >> 16;
                raster[k] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            uA += j7;
            vA += l7;
            l1 += dl;
            a1 += k2;
            i2 += a2;
            int j6 = (verticalC += i3) >> 14;
            if (j6 != 0) {
                j4 = a1 / j6;
                l4 = i2 / j6;
                if (!repeatTexture) {
                    if (j4 < 7) {
                        j4 = 7;
                    } else if (j4 > 16256) {
                        j4 = 16256;
                    }
                }
            }
            j7 = j4 - uA >> 3;
            l7 = l4 - vA >> 3;
            l1 += dl;
        }
        int l3 = x2 - x1 & 7;
        while (l3-- > 0) {
            int j9 = texels[(vA & 0x3F80) + (uA >> 7) & (repeatTexture ? 16383 : (vA & 0x3F80) + (uA >> 7))];
            if (j9 != 0) {
                int l = l1 >> 16;
                raster[k] = ((j9 & 0xFF00FF) * l & 0xFF00FF00) + ((j9 & 0xFF00) * l & 0xFF0000) >> 8;
            }
            ++k;
            uA += j7;
            vA += l7;
            l1 += dl;
        }
    }

    private static void drawFlatScanline(int[] dest, int offset, int rgb, int x1, int x2) {
        if (testX) {
            if (x2 > Rasterizer2D.centerX2) {
                x2 = Rasterizer2D.centerX2;
            }
            if (x1 < 0) {
                x1 = 0;
            }
        }
        if (x1 >= x2) {
            return;
        }
        offset += x1;
        int pos = x2 - x1 >> 2;
        if (alpha == 0) {
            while (--pos >= 0) {
                for (int i = 0; i < 4; ++i) {
                    dest[offset] = rgb;
                    ++offset;
                }
            }
            pos = x2 - x1 & 3;
            while (--pos >= 0) {
                dest[offset] = rgb;
                ++offset;
            }
            return;
        }
        int a1 = alpha;
        int a2 = 256 - alpha;
        rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
        while (--pos >= 0) {
            for (int i = 0; i < 4; ++i) {
                dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                ++offset;
            }
        }
        pos = x2 - x1 & 3;
        while (--pos >= 0) {
            dest[offset++] = rgb + ((dest[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
        }
    }

    public static void drawFlatTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int rgb) {
        int a_to_b = 0;
        if (y2 != y1) {
            a_to_b = (x2 - x1 << 16) / (y2 - y1);
        }
        int b_to_c = 0;
        if (y3 != y2) {
            b_to_c = (x3 - x2 << 16) / (y3 - y2);
        }
        int c_to_a = 0;
        if (y3 != y1) {
            c_to_a = (x1 - x3 << 16) / (y1 - y3);
        }
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= bottomY) {
                return;
            }
            if (y2 > bottomY) {
                y2 = bottomY;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            if (y2 < y3) {
                x3 = x1 <<= 16;
                if (y1 < 0) {
                    x3 -= c_to_a * y1;
                    x1 -= a_to_b * y1;
                    y1 = 0;
                }
                x2 <<= 16;
                if (y2 < 0) {
                    x2 -= b_to_c * y2;
                    y2 = 0;
                }
                if (y1 != y2 && c_to_a < a_to_b || y1 == y2 && c_to_a > b_to_c) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = line_offsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x3 >> 16, x1 >> 16);
                        x3 += c_to_a;
                        x1 += a_to_b;
                        y1 += width;
                    }
                    while (--y3 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x3 >> 16, x2 >> 16);
                        x3 += c_to_a;
                        x2 += b_to_c;
                        y1 += width;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = line_offsets[y1];
                while (--y2 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x1 >> 16, x3 >> 16);
                    x3 += c_to_a;
                    x1 += a_to_b;
                    y1 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x2 >> 16, x3 >> 16);
                    x3 += c_to_a;
                    x2 += b_to_c;
                    y1 += width;
                }
                return;
            }
            x2 = x1 <<= 16;
            if (y1 < 0) {
                x2 -= c_to_a * y1;
                x1 -= a_to_b * y1;
                y1 = 0;
            }
            x3 <<= 16;
            if (y3 < 0) {
                x3 -= b_to_c * y3;
                y3 = 0;
            }
            if (y1 != y3 && c_to_a < a_to_b || y1 == y3 && b_to_c > a_to_b) {
                y2 -= y3;
                y3 -= y1;
                y1 = line_offsets[y1];
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x2 >> 16, x1 >> 16);
                    x2 += c_to_a;
                    x1 += a_to_b;
                    y1 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x3 >> 16, x1 >> 16);
                    x3 += b_to_c;
                    x1 += a_to_b;
                    y1 += width;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = line_offsets[y1];
            while (--y3 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x1 >> 16, x2 >> 16);
                x2 += c_to_a;
                x1 += a_to_b;
                y1 += width;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y1, rgb, x1 >> 16, x3 >> 16);
                x3 += b_to_c;
                x1 += a_to_b;
                y1 += width;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= bottomY) {
                return;
            }
            if (y3 > bottomY) {
                y3 = bottomY;
            }
            if (y1 > bottomY) {
                y1 = bottomY;
            }
            if (y3 < y1) {
                x1 = x2 <<= 16;
                if (y2 < 0) {
                    x1 -= a_to_b * y2;
                    x2 -= b_to_c * y2;
                    y2 = 0;
                }
                x3 <<= 16;
                if (y3 < 0) {
                    x3 -= c_to_a * y3;
                    y3 = 0;
                }
                if (y2 != y3 && a_to_b < b_to_c || y2 == y3 && a_to_b > c_to_a) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = line_offsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x1 >> 16, x2 >> 16);
                        x1 += a_to_b;
                        x2 += b_to_c;
                        y2 += width;
                    }
                    while (--y1 >= 0) {
                        Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x1 >> 16, x3 >> 16);
                        x1 += a_to_b;
                        x3 += c_to_a;
                        y2 += width;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = line_offsets[y2];
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x2 >> 16, x1 >> 16);
                    x1 += a_to_b;
                    x2 += b_to_c;
                    y2 += width;
                }
                while (--y1 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x3 >> 16, x1 >> 16);
                    x1 += a_to_b;
                    x3 += c_to_a;
                    y2 += width;
                }
                return;
            }
            x3 = x2 <<= 16;
            if (y2 < 0) {
                x3 -= a_to_b * y2;
                x2 -= b_to_c * y2;
                y2 = 0;
            }
            x1 <<= 16;
            if (y1 < 0) {
                x1 -= c_to_a * y1;
                y1 = 0;
            }
            if (a_to_b < b_to_c) {
                y3 -= y1;
                y1 -= y2;
                y2 = line_offsets[y2];
                while (--y1 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x3 >> 16, x2 >> 16);
                    x3 += a_to_b;
                    x2 += b_to_c;
                    y2 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x1 >> 16, x2 >> 16);
                    x1 += c_to_a;
                    x2 += b_to_c;
                    y2 += width;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = line_offsets[y2];
            while (--y1 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x2 >> 16, x3 >> 16);
                x3 += a_to_b;
                x2 += b_to_c;
                y2 += width;
            }
            while (--y3 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y2, rgb, x2 >> 16, x1 >> 16);
                x1 += c_to_a;
                x2 += b_to_c;
                y2 += width;
            }
            return;
        }
        if (y3 >= bottomY) {
            return;
        }
        if (y1 > bottomY) {
            y1 = bottomY;
        }
        if (y2 > bottomY) {
            y2 = bottomY;
        }
        if (y1 < y2) {
            x2 = x3 <<= 16;
            if (y3 < 0) {
                x2 -= b_to_c * y3;
                x3 -= c_to_a * y3;
                y3 = 0;
            }
            x1 <<= 16;
            if (y1 < 0) {
                x1 -= a_to_b * y1;
                y1 = 0;
            }
            if (b_to_c < c_to_a) {
                y2 -= y1;
                y1 -= y3;
                y3 = line_offsets[y3];
                while (--y1 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x2 >> 16, x3 >> 16);
                    x2 += b_to_c;
                    x3 += c_to_a;
                    y3 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x2 >> 16, x1 >> 16);
                    x2 += b_to_c;
                    x1 += a_to_b;
                    y3 += width;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = line_offsets[y3];
            while (--y1 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x3 >> 16, x2 >> 16);
                x2 += b_to_c;
                x3 += c_to_a;
                y3 += width;
            }
            while (--y2 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x1 >> 16, x2 >> 16);
                x2 += b_to_c;
                x1 += a_to_b;
                y3 += width;
            }
            return;
        }
        x1 = x3 <<= 16;
        if (y3 < 0) {
            x1 -= b_to_c * y3;
            x3 -= c_to_a * y3;
            y3 = 0;
        }
        x2 <<= 16;
        if (y2 < 0) {
            x2 -= a_to_b * y2;
            y2 = 0;
        }
        if (b_to_c < c_to_a) {
            y1 -= y2;
            y2 -= y3;
            y3 = line_offsets[y3];
            while (--y2 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x1 >> 16, x3 >> 16);
                x1 += b_to_c;
                x3 += c_to_a;
                y3 += width;
            }
            while (--y1 >= 0) {
                Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x2 >> 16, x3 >> 16);
                x2 += a_to_b;
                x3 += c_to_a;
                y3 += width;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = line_offsets[y3];
        while (--y2 >= 0) {
            Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x3 >> 16, x1 >> 16);
            x1 += b_to_c;
            x3 += c_to_a;
            y3 += width;
        }
        while (--y1 >= 0) {
            Rasterizer3D.drawFlatScanline(pixels, y3, rgb, x3 >> 16, x2 >> 16);
            x2 += a_to_b;
            x3 += c_to_a;
            y3 += width;
        }
    }

    public static void drawFog(int begin, int end) {
        for (int depth = depth_buffer.length - 1; depth >= 0; --depth) {
            if (depth_buffer[depth] >= (float)end) {
                Rasterizer3D.pixels[depth] = fogColor;
                continue;
            }
            if (!(depth_buffer[depth] >= (float)begin)) continue;
            int alpha = (int)(depth_buffer[depth] - (float)begin) / 3;
            int src = ((fogColor & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((fogColor & 0xFF00) * alpha >> 8 & 0xFF00);
            alpha = 256 - alpha;
            int dst = pixels[depth];
            dst = ((dst & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((dst & 0xFF00) * alpha >> 8 & 0xFF00);
            Rasterizer3D.pixels[depth] = src + dst;
        }
    }

    public double getBrightness() {
        return brightness;
    }

    static {
        int index;
        media_length = 123;
        low_detail = false;
        aBoolean1464 = true;
        mapped = true;
        tex_images = new IndexedImage[media_length];
        transparent = new boolean[media_length];
        avg_color = new int[media_length];
        texel_cache = new int[media_length][][];
        cache = new int[media_length];
        palletes = new int[media_length][];
        HSL_TO_RGB = new int[65536];
        scene_div_factor = 512;
        anIntArray1468 = new int[512];
        anIntArray1469 = new int[2048];
        SINE = new int[2048];
        COSINE = new int[2048];
        for (index = 1; index < 512; ++index) {
            Rasterizer3D.anIntArray1468[index] = 32768 / index;
        }
        for (index = 1; index < 2048; ++index) {
            Rasterizer3D.anIntArray1469[index] = 65536 / index;
        }
        for (index = 0; index < 2048; ++index) {
            Rasterizer3D.SINE[index] = (int)(65536.0 * Math.sin((double)index * 0.0030679615));
            Rasterizer3D.COSINE[index] = (int)(65536.0 * Math.cos((double)index * 0.0030679615));
        }
        repeatTexture = false;
        forceRepeat = false;
        fogColor = 13156520;
    }
}

