/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.entity;

import com.ornate.Client;
import com.ornate.cache.anim.Sequence;
import com.ornate.entity.Renderable;

public class Entity
extends Renderable {
    public int index = -1;
    public final int[] waypoint_x = new int[10];
    public final int[] waypoint_y = new int[10];
    public int engaged_entity_id = -1;
    public int step_tracker;
    public int rotation = 32;
    public int running_animation_id = -1;
    public String entity_message;
    public int height = 200;
    public int turn_direction;
    public int idle_animation_id = -1;
    public int standing_turn_animation_id = -1;
    public int textColour;
    public final int[] damage_dealt = new int[15];
    public final int[] damage_marker = new int[15];
    public final int[] damage_cycle = new int[15];
    public int queued_animation_id = -1;
    public int queued_animation_frame;
    public int queued_animation_duration;
    public int graphic_id = -1;
    public int current_animation_id;
    public int current_animation_time_remaining;
    public int graphic_cycle;
    public int graphic_height;
    public int waypoint_index;
    public int animation = -1;
    public int current_animation_frame;
    public int current_animation_duration;
    public int animation_delay;
    public int animation_loops;
    public int textEffect;
    public int game_tick_status = -1000;
    public int current_hitpoints;
    public int maximum_hitpoints;
    public int message_cycle = 100;
    public int time;
    public int faceX;
    public int faceY;
    public int occupied_tiles = 1;
    public boolean dynamic = false;
    public int remaining_steps;
    public int initialX;
    public int destinationX;
    public int initialY;
    public int destinationY;
    public int initiate_movement;
    public int cease_movement;
    public int direction;
    public int world_x;
    public int world_y;
    public int current_rotation;
    public final boolean[] waypoint_traveled = new boolean[10];
    public int walk_animation_id = -1;
    public int turn_around_animation_id = -1;
    public int pivot_right_animation_id = -1;
    public int pivot_left_animation_id = -1;
    public int next_animation_frame;
    public int next_graphic_frame;
    public int next_idle_frame;

    public final void setPos(int x, int y, boolean flag) {
        if (this.animation != -1 && Sequence.cache[this.animation].priority == 1) {
            this.animation = -1;
        }
        if (!flag) {
            int dx = x - this.waypoint_x[0];
            int dy = y - this.waypoint_y[0];
            if (dx >= -8 && dx <= 8 && dy >= -8 && dy <= 8) {
                if (this.waypoint_index < 9) {
                    ++this.waypoint_index;
                }
                for (int i1 = this.waypoint_index; i1 > 0; --i1) {
                    this.waypoint_x[i1] = this.waypoint_x[i1 - 1];
                    this.waypoint_y[i1] = this.waypoint_y[i1 - 1];
                    this.waypoint_traveled[i1] = this.waypoint_traveled[i1 - 1];
                }
                this.waypoint_x[0] = x;
                this.waypoint_y[0] = y;
                this.waypoint_traveled[0] = false;
                return;
            }
        }
        this.waypoint_index = 0;
        this.remaining_steps = 0;
        this.step_tracker = 0;
        this.waypoint_x[0] = x;
        this.waypoint_y[0] = y;
        this.world_x = this.waypoint_x[0] * 128 + this.occupied_tiles * 64;
        this.world_y = this.waypoint_y[0] * 128 + this.occupied_tiles * 64;
    }

    public final void resetPath() {
        this.waypoint_index = 0;
        this.remaining_steps = 0;
    }

    public final void updateHitData(int hitType, int hitDamage, int currentTime) {
        for (int hitPtr = 0; hitPtr < 4; ++hitPtr) {
            if (this.damage_cycle[hitPtr] > currentTime) continue;
            this.damage_dealt[hitPtr] = hitDamage;
            this.damage_marker[hitPtr] = hitType;
            this.damage_cycle[hitPtr] = currentTime + 70;
            return;
        }
    }

    public void refreshEntityPosition() {
        int remaining = this.initiate_movement - Client.game_tick;
        int tempX = this.initialX * 128 + this.occupied_tiles * 64;
        int tempY = this.initialY * 128 + this.occupied_tiles * 64;
        this.world_x += (tempX - this.world_x) / remaining;
        this.world_y += (tempY - this.world_y) / remaining;
        this.step_tracker = 0;
        if (this.direction == 0) {
            this.turn_direction = 1024;
        }
        if (this.direction == 1) {
            this.turn_direction = 1536;
        }
        if (this.direction == 2) {
            this.turn_direction = 0;
        }
        if (this.direction == 3) {
            this.turn_direction = 512;
        }
    }

    public void refreshEntityFaceDirection() {
        if (this.cease_movement == Client.game_tick || this.animation == -1 || this.animation_delay != 0 || this.current_animation_duration + 1 > Sequence.cache[this.animation].get_length(this.current_animation_frame)) {
            int remaining = this.cease_movement - this.initiate_movement;
            int elapsed = Client.game_tick - this.initiate_movement;
            int initialX = this.initialX * 128 + this.occupied_tiles * 64;
            int initialY = this.initialY * 128 + this.occupied_tiles * 64;
            int endX = this.destinationX * 128 + this.occupied_tiles * 64;
            int endY = this.destinationY * 128 + this.occupied_tiles * 64;
            this.world_x = (initialX * (remaining - elapsed) + endX * elapsed) / remaining;
            this.world_y = (initialY * (remaining - elapsed) + endY * elapsed) / remaining;
        }
        this.step_tracker = 0;
        if (this.direction == 0) {
            this.turn_direction = 1024;
        }
        if (this.direction == 1) {
            this.turn_direction = 1536;
        }
        if (this.direction == 2) {
            this.turn_direction = 0;
        }
        if (this.direction == 3) {
            this.turn_direction = 512;
        }
        this.current_rotation = this.turn_direction;
    }

    public void getDegreesToTurn() {
        this.queued_animation_id = this.idle_animation_id;
        if (this.waypoint_index == 0) {
            this.step_tracker = 0;
            return;
        }
        if (this.animation > Sequence.cache.length) {
            this.animation = -1;
            return;
        }
        if (this.animation != -1 && this.animation_delay == 0) {
            Sequence seq = Sequence.cache[this.animation];
            if (this.remaining_steps > 0 && seq.precedenceAnimating == 0) {
                ++this.step_tracker;
                return;
            }
            if (this.remaining_steps <= 0 && seq.priority == 0) {
                ++this.step_tracker;
                return;
            }
        }
        int tempX = this.world_x;
        int tempY = this.world_y;
        int nextX = this.waypoint_x[this.waypoint_index - 1] * 128 + this.occupied_tiles * 64;
        int nextY = this.waypoint_y[this.waypoint_index - 1] * 128 + this.occupied_tiles * 64;
        if (nextX - tempX > 256 || nextX - tempX < -256 || nextY - tempY > 256 || nextY - tempY < -256) {
            this.world_x = nextX;
            this.world_y = nextY;
            return;
        }
        this.turn_direction = tempX < nextX ? (tempY < nextY ? 1280 : (tempY > nextY ? 1792 : 1536)) : (tempX > nextX ? (tempY < nextY ? 768 : (tempY > nextY ? 256 : 512)) : (tempY < nextY ? 1024 : 0));
        int rotation = this.turn_direction - this.current_rotation & 0x7FF;
        if (rotation > 1024) {
            rotation -= 2048;
        }
        int animation = this.turn_around_animation_id;
        if (rotation >= -256 && rotation <= 256) {
            animation = this.walk_animation_id;
        } else if (rotation >= 256 && rotation < 768) {
            animation = this.pivot_left_animation_id;
        } else if (rotation >= -768 && rotation <= -256) {
            animation = this.pivot_right_animation_id;
        }
        if (animation == -1) {
            animation = this.walk_animation_id;
        }
        this.queued_animation_id = animation;
        int positionDelta = 4;
        if (this.current_rotation != this.turn_direction && this.engaged_entity_id == -1 && rotation != 0) {
            positionDelta = 2;
        }
        if (this.waypoint_index > 2) {
            positionDelta = 6;
        }
        if (this.waypoint_index > 3) {
            positionDelta = 8;
        }
        if (this.step_tracker > 0 && this.waypoint_index > 1) {
            positionDelta = 8;
            --this.step_tracker;
        }
        if (this.waypoint_traveled[this.waypoint_index - 1]) {
            positionDelta <<= 1;
        }
        if (positionDelta >= 8 && this.queued_animation_id == this.walk_animation_id && this.running_animation_id != -1) {
            this.queued_animation_id = this.running_animation_id;
        }
        if (tempX < nextX) {
            this.world_x += positionDelta;
            if (this.world_x > nextX) {
                this.world_x = nextX;
            }
        } else if (tempX > nextX) {
            this.world_x -= positionDelta;
            if (this.world_x < nextX) {
                this.world_x = nextX;
            }
        }
        if (tempY < nextY) {
            this.world_y += positionDelta;
            if (this.world_y > nextY) {
                this.world_y = nextY;
            }
        } else if (tempY > nextY) {
            this.world_y -= positionDelta;
            if (this.world_y < nextY) {
                this.world_y = nextY;
            }
        }
        if (this.world_x == nextX && this.world_y == nextY) {
            --this.waypoint_index;
            if (this.remaining_steps > 0) {
                --this.remaining_steps;
            }
        }
    }

    public final void moveInDir(boolean run, int direction) {
        int x = this.waypoint_x[0];
        int y = this.waypoint_y[0];
        if (direction == 0) {
            --x;
            ++y;
        }
        if (direction == 1) {
            ++y;
        }
        if (direction == 2) {
            ++x;
            ++y;
        }
        if (direction == 3) {
            --x;
        }
        if (direction == 4) {
            ++x;
        }
        if (direction == 5) {
            --x;
            --y;
        }
        if (direction == 6) {
            --y;
        }
        if (direction == 7) {
            ++x;
            --y;
        }
        if (this.animation != -1 && Sequence.cache[this.animation].priority == 1) {
            this.animation = -1;
        }
        if (this.waypoint_index < 9) {
            ++this.waypoint_index;
        }
        for (int l = this.waypoint_index; l > 0; --l) {
            this.waypoint_x[l] = this.waypoint_x[l - 1];
            this.waypoint_y[l] = this.waypoint_y[l - 1];
            this.waypoint_traveled[l] = this.waypoint_traveled[l - 1];
        }
        this.waypoint_x[0] = x;
        this.waypoint_y[0] = y;
        this.waypoint_traveled[0] = run;
    }

    public boolean visible() {
        return false;
    }
}

