/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.entity;

import com.ornate.Client;
import com.ornate.cache.anim.Animation;
import com.ornate.cache.anim.Sequence;
import com.ornate.cache.anim.SpotAnimation;
import com.ornate.cache.def.NpcDefinition;
import com.ornate.entity.Entity;
import com.ornate.entity.model.Model;

public final class Npc
extends Entity {
    public NpcDefinition desc;
    public int headIcon = -1;
    public int ownerIndex = -1;

    public boolean showActions() {
        if (this.ownerIndex == -1) {
            return true;
        }
        return Client.singleton.localPlayerIndex == this.ownerIndex;
    }

    public int getHeadIcon() {
        if (this.headIcon == -1 && this.desc != null) {
            return this.desc.headIconPrayer;
        }
        return this.headIcon;
    }

    private Model get_animated_model() {
        int current_frame = -1;
        int animation = -1;
        if (this.animation >= 0 && this.animation_delay == 0) {
            Sequence seq = Sequence.cache[this.animation];
            current_frame = seq.primary_frame[this.current_animation_frame];
            if (this.queued_animation_id >= 0 && this.queued_animation_id != this.idle_animation_id) {
                animation = Sequence.cache[this.queued_animation_id].primary_frame[this.queued_animation_frame];
            }
            return this.desc.get_animated_model(animation, current_frame, Sequence.cache[this.animation].interleaveOrder);
        }
        if (this.queued_animation_id >= 0) {
            Sequence seq = Sequence.cache[this.queued_animation_id];
            current_frame = seq.primary_frame[this.queued_animation_frame];
        }
        return this.desc.get_animated_model(animation, current_frame, null);
    }

    @Override
    public Model getRotatedModel() {
        SpotAnimation anim;
        Model model;
        if (this.desc == null) {
            return null;
        }
        Model animated = this.get_animated_model();
        if (animated == null) {
            return null;
        }
        this.height = animated.modelHeight;
        if (this.graphic_id != -1 && this.current_animation_id != -1 && (model = (anim = SpotAnimation.cache[this.graphic_id]).get_model()) != null) {
            int frame = anim.seq.primary_frame[this.current_animation_id];
            Model graphic = new Model(true, Animation.validate(frame), false, model);
            graphic.translate(0, -this.graphic_height, 0);
            graphic.skin();
            graphic.interpolate(frame);
            graphic.face_skin = null;
            graphic.vertex_skin = null;
            if (anim.model_scale_x != 128 || anim.model_scale_y != 128) {
                graphic.scale(anim.model_scale_x, anim.model_scale_x, anim.model_scale_y);
            }
            graphic.light(64 + anim.ambient, 850 + anim.contrast, -30, -50, -30, true);
            Model[] build = new Model[]{animated, graphic};
            animated = new Model(build);
        }
        if (this.desc.size == 1) {
            animated.within_tile = true;
        }
        return animated;
    }

    @Override
    public boolean visible() {
        return this.desc != null;
    }
}

