/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.entity;

import com.ornate.Client;
import com.ornate.cache.anim.Animation;
import com.ornate.cache.anim.Sequence;
import com.ornate.cache.anim.SpotAnimation;
import com.ornate.cache.def.ItemDefinition;
import com.ornate.cache.def.NpcDefinition;
import com.ornate.collection.ReferenceCache;
import com.ornate.entity.Entity;
import com.ornate.entity.model.IdentityKit;
import com.ornate.entity.model.Model;
import com.ornate.io.Buffer;

public final class Player
extends Entity {
    public int rights;
    public int donatorRights;
    private long key = -1L;
    public NpcDefinition npcDefinition;
    public boolean reference_pose = false;
    public final int[] appearanceColors = new int[5];
    public int team_id;
    private int gender;
    public String username;
    public String displayName;
    public static ReferenceCache model_cache = new ReferenceCache(260);
    public int combat_level;
    public int overhead_icon;
    public int skull_icon;
    public int hint_arrow_icon;
    public int transform_delay;
    public int transform_duration;
    public int height;
    public boolean visible = false;
    public int x_offset;
    public int z_offset;
    public int y_offset;
    public Model transformed_model;
    public final int[] equipment = new int[12];
    private long appearance_offset;
    public int transform_width;
    public int transform_height;
    public int transform_width_offset;
    public int transform_height_offset;
    public int skill_level;
    public String title = "";
    public String titleColor = "";

    @Override
    public Model getRotatedModel() {
        if (!this.visible) {
            return null;
        }
        Model player = this.get_animated_model();
        if (player == null) {
            return null;
        }
        ((Entity)this).height = player.modelHeight;
        player.within_tile = true;
        if (this.reference_pose) {
            return player;
        }
        if (this.graphic_id != -1 && this.current_animation_id != -1) {
            SpotAnimation anim = SpotAnimation.cache[this.graphic_id];
            Model model = anim.get_model();
            if (model != null) {
                Model graphic = new Model(false, Animation.validate(this.current_animation_id), false, model);
                graphic.translate(0, -this.graphic_height, 0);
                graphic.skin();
                graphic.interpolate(anim.seq.primary_frame[this.current_animation_id]);
                graphic.face_skin = null;
                graphic.vertex_skin = null;
                if (anim.model_scale_x != 128 || anim.model_scale_y != 128) {
                    graphic.scale(anim.model_scale_x, anim.model_scale_x, anim.model_scale_y);
                }
                if (anim.src_texture != null) {
                    for (int index = 0; index < anim.src_texture.length; ++index) {
                        graphic.retexture(anim.src_texture[index], anim.dst_texture[index]);
                    }
                }
                graphic.light(64 + anim.ambient, 850 + anim.contrast, -30, -50, -30, true, true);
                Model[] merged = new Model[]{player, graphic};
                player = new Model(merged);
            } else {
                return null;
            }
        }
        if (this.transformed_model != null) {
            if (Client.game_tick >= this.transform_duration) {
                this.transformed_model = null;
            }
            if (Client.game_tick >= this.transform_delay && Client.game_tick < this.transform_duration) {
                Model model = this.transformed_model;
                model.translate(this.x_offset - this.world_x, this.z_offset - this.height, this.y_offset - this.world_y);
                if (this.turn_direction == 512) {
                    model.rotate_90();
                    model.rotate_90();
                    model.rotate_90();
                } else if (this.turn_direction == 1024) {
                    model.rotate_90();
                    model.rotate_90();
                } else if (this.turn_direction == 1536) {
                    model.rotate_90();
                }
                Model[] merged = new Model[]{player, model};
                player = new Model(merged);
                if (this.turn_direction == 512) {
                    model.rotate_90();
                } else if (this.turn_direction == 1024) {
                    model.rotate_90();
                    model.rotate_90();
                } else if (this.turn_direction == 1536) {
                    model.rotate_90();
                    model.rotate_90();
                    model.rotate_90();
                }
                model.translate(this.world_x - this.x_offset, this.height - this.z_offset, this.world_y - this.y_offset);
            }
        }
        player.within_tile = true;
        return player;
    }

    public void update(Buffer buffer) {
        int index;
        buffer.pos = 0;
        this.title = buffer.readString();
        this.titleColor = buffer.readString();
        this.gender = buffer.readUByte();
        this.overhead_icon = buffer.readUByte();
        this.skull_icon = buffer.readUByte();
        this.hint_arrow_icon = buffer.readUByte();
        this.npcDefinition = null;
        this.team_id = 0;
        for (int bodyPart = 0; bodyPart < 12; ++bodyPart) {
            int team_cape;
            int reset = buffer.readUByte();
            if (reset == 0) {
                this.equipment[bodyPart] = 0;
                continue;
            }
            int id = buffer.readUByte();
            this.equipment[bodyPart] = (reset << 8) + id;
            if (bodyPart == 0 && this.equipment[0] == 65535) {
                this.npcDefinition = NpcDefinition.get(buffer.readUShort());
                break;
            }
            if (this.equipment[bodyPart] < 512 || this.equipment[bodyPart] - 512 >= ItemDefinition.length || (team_cape = ItemDefinition.get((int)(this.equipment[bodyPart] - 512)).team) == 0) continue;
            this.team_id = team_cape;
        }
        for (index = 0; index < 5; ++index) {
            int color = buffer.readUByte();
            if (color < 0 || color >= Client.APPEARANCE_COLORS[index].length) {
                color = 0;
            }
            this.appearanceColors[index] = color;
        }
        this.idle_animation_id = buffer.readUShort();
        if (this.idle_animation_id == 65535) {
            this.idle_animation_id = -1;
        }
        this.standing_turn_animation_id = buffer.readUShort();
        if (this.standing_turn_animation_id == 65535) {
            this.standing_turn_animation_id = -1;
        }
        this.walk_animation_id = buffer.readUShort();
        if (this.walk_animation_id == 65535) {
            this.walk_animation_id = -1;
        }
        this.turn_around_animation_id = buffer.readUShort();
        if (this.turn_around_animation_id == 65535) {
            this.turn_around_animation_id = -1;
        }
        this.pivot_right_animation_id = buffer.readUShort();
        if (this.pivot_right_animation_id == 65535) {
            this.pivot_right_animation_id = -1;
        }
        this.pivot_left_animation_id = buffer.readUShort();
        if (this.pivot_left_animation_id == 65535) {
            this.pivot_left_animation_id = -1;
        }
        this.running_animation_id = buffer.readUShort();
        if (this.running_animation_id == 65535) {
            this.running_animation_id = -1;
        }
        this.username = buffer.readString();
        this.displayName = buffer.readString();
        this.combat_level = buffer.readUByte();
        this.rights = buffer.readUByte();
        this.donatorRights = buffer.readUByte();
        this.visible = true;
        this.appearance_offset = 0L;
        for (index = 0; index < 12; ++index) {
            this.appearance_offset <<= 4;
            if (this.equipment[index] < 256) continue;
            this.appearance_offset += (long)(this.equipment[index] - 256);
        }
        if (this.equipment[0] >= 256) {
            this.appearance_offset += (long)(this.equipment[0] - 256 >> 4);
        }
        if (this.equipment[1] >= 256) {
            this.appearance_offset += (long)(this.equipment[1] - 256 >> 8);
        }
        for (index = 0; index < 5; ++index) {
            this.appearance_offset <<= 3;
            this.appearance_offset += (long)this.appearanceColors[index];
        }
        this.appearance_offset <<= 1;
        this.appearance_offset += (long)this.gender;
    }

    public Model get_animated_model() {
        Sequence seq;
        long offset = this.appearance_offset;
        int current_frame = -1;
        int next_frame = -1;
        int animation = -1;
        int shield_delta = -1;
        int weapon_delta = -1;
        if (this.npcDefinition != null) {
            if (this.animation >= 0 && this.animation_delay == 0) {
                Sequence seq2 = Sequence.cache[this.animation];
                current_frame = seq2.primary_frame[this.current_animation_frame];
            }
            return this.npcDefinition.get_animated_model(-1, current_frame, null);
        }
        if (this.animation >= 0 && this.animation_delay == 0) {
            seq = Sequence.cache[this.animation];
            current_frame = seq.primary_frame[this.current_animation_frame];
            if (this.queued_animation_id >= 0 && this.queued_animation_id != this.idle_animation_id) {
                animation = Sequence.cache[this.queued_animation_id].primary_frame[this.queued_animation_frame];
            }
            if (seq.leftHandItem >= 0) {
                shield_delta = seq.leftHandItem;
                offset += (long)(shield_delta - this.equipment[5] << 40);
            }
            if (seq.rightHandItem >= 0) {
                weapon_delta = seq.rightHandItem;
                offset += (long)(weapon_delta - this.equipment[3] << 48);
            }
        } else if (this.queued_animation_id >= 0) {
            seq = Sequence.cache[this.queued_animation_id];
            current_frame = seq.primary_frame[this.queued_animation_frame];
        }
        Model model = (Model)model_cache.get(offset);
        if (model == null) {
            boolean cached = false;
            for (int index = 0; index < 12; ++index) {
                int appearance = this.equipment[index];
                if (weapon_delta >= 0 && index == 3) {
                    appearance = weapon_delta;
                }
                if (shield_delta >= 0 && index == 5) {
                    appearance = shield_delta;
                }
                if (appearance >= 256 && appearance < 512 && !IdentityKit.cache[appearance - 256].body_cached()) {
                    cached = true;
                }
                if (appearance < 512 || ItemDefinition.get(appearance - 512).equipped_model_cached(this.gender)) continue;
                cached = true;
            }
            if (cached) {
                if (this.key != -1L) {
                    model = (Model)model_cache.get(this.key);
                }
                if (model == null) {
                    return null;
                }
            }
        }
        if (model == null) {
            int index;
            Model[] character = new Model[12];
            int equipped = 0;
            for (index = 0; index < 12; ++index) {
                Model items;
                Model idk;
                int appearance = this.equipment[index];
                if (weapon_delta >= 0 && index == 3) {
                    appearance = weapon_delta;
                }
                if (shield_delta >= 0 && index == 5) {
                    appearance = shield_delta;
                }
                if (appearance >= 256 && appearance < 512 && (idk = IdentityKit.cache[appearance - 256].get_body()) != null) {
                    character[equipped++] = idk;
                }
                if (appearance < 512 || (items = ItemDefinition.get(appearance - 512).get_equipped_model(this.gender)) == null) continue;
                character[equipped++] = items;
            }
            model = new Model(equipped, character, true);
            for (index = 0; index < 5; ++index) {
                if (this.appearanceColors[index] == 0) continue;
                model.recolor(Client.APPEARANCE_COLORS[index][0], Client.APPEARANCE_COLORS[index][this.appearanceColors[index]]);
                if (index != 1) continue;
                model.recolor(Client.SHIRT_SECONDARY_COLORS[0], Client.SHIRT_SECONDARY_COLORS[this.appearanceColors[index]]);
            }
            model.skin();
            model.light(64, 850, -30, -50, -30, true, true);
            model_cache.put(model, offset);
            this.key = offset;
        }
        if (this.reference_pose) {
            return model;
        }
        Model animated = Model.EMPTY_MODEL;
        animated.replace(model, Animation.validate(current_frame) & Animation.validate(animation));
        if (current_frame != -1 && animation != -1) {
            animated.mix(Sequence.cache[this.animation].interleaveOrder, animation, current_frame);
        } else if (current_frame != -1) {
            animated.interpolate(current_frame);
        }
        animated.calc_diagonals();
        animated.face_skin = null;
        animated.vertex_skin = null;
        return animated;
    }

    public Model get_dialogue_model() {
        if (!this.visible) {
            return null;
        }
        if (this.npcDefinition != null) {
            return this.npcDefinition.get_dialogue_model();
        }
        boolean cached = false;
        for (int index = 0; index < 12; ++index) {
            int appearance = this.equipment[index];
            if (appearance >= 256 && appearance < 512 && !IdentityKit.cache[appearance - 256].headLoaded()) {
                cached = true;
            }
            if (appearance < 512 || ItemDefinition.get(appearance - 512).dialogue_model_cached(this.gender)) continue;
            cached = true;
        }
        if (cached) {
            return null;
        }
        Model[] character = new Model[12];
        int equipped = 0;
        for (int index = 0; index < 12; ++index) {
            Model items;
            Model idk;
            int appearance = this.equipment[index];
            if (appearance >= 256 && appearance < 512 && (idk = IdentityKit.cache[appearance - 256].get_head()) != null) {
                character[equipped++] = idk;
            }
            if (appearance < 512 || (items = ItemDefinition.get(appearance - 512).get_equipped_dialogue_model(this.gender)) == null) continue;
            character[equipped++] = items;
        }
        Model model = new Model(equipped, character, true);
        for (int index = 0; index < 5; ++index) {
            if (this.appearanceColors[index] == 0) continue;
            model.recolor(Client.APPEARANCE_COLORS[index][0], Client.APPEARANCE_COLORS[index][this.appearanceColors[index]]);
            if (index != 1) continue;
            model.recolor(Client.SHIRT_SECONDARY_COLORS[0], Client.SHIRT_SECONDARY_COLORS[this.appearanceColors[index]]);
        }
        return model;
    }

    @Override
    public boolean visible() {
        return this.visible;
    }

    public String getTitle(boolean rightClick) {
        if (this.title.length() > 0) {
            if (rightClick) {
                return this.titleColor + this.title + " <col=ffffff>";
            }
            return this.titleColor + this.title + " <col=0>";
        }
        return "";
    }
}

