/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.entity.model;

import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.entity.model.Model;
import com.ornate.io.Buffer;
import com.ornate.util.FileUtils;

public final class IdentityKit {
    public static int length;
    public static IdentityKit[] cache;
    public int bodyPartId = -1;
    private int[] bodyModels;
    private final short[] originalColors = new short[6];
    private final short[] replacementColors = new short[6];
    private final int[] headModels = new int[]{-1, -1, -1, -1, -1};
    public boolean validStyle;

    private IdentityKit() {
    }

    public static void init(Archive archive) {
        Buffer buffer = new Buffer(ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/identity_kit/idk.dat") : archive.get("idk.dat"));
        length = buffer.readUShort();
        System.out.printf("Loaded %d identities loading OSRS version %d and SUB version %d%n", length, 204, 2);
        if (cache == null) {
            cache = new IdentityKit[length];
        }
        for (int id = 0; id < length; ++id) {
            if (cache[id] == null) {
                IdentityKit.cache[id] = new IdentityKit();
            }
            IdentityKit kit = cache[id];
            kit.decode(buffer);
            kit.originalColors[0] = -10304;
            kit.replacementColors[0] = 6798;
        }
    }

    private void decode(Buffer buffer) {
        int opcode;
        while ((opcode = buffer.readUByte()) != 0) {
            if (opcode == 1) {
                this.bodyPartId = buffer.readUByte();
                continue;
            }
            if (opcode == 2) {
                int count = buffer.readUByte();
                this.bodyModels = new int[count];
                for (int part = 0; part < count; ++part) {
                    this.bodyModels[part] = buffer.readUShort();
                }
                continue;
            }
            if (opcode == 3) {
                this.validStyle = true;
                continue;
            }
            if (opcode >= 40 && opcode < 50) {
                this.originalColors[opcode - 40] = (short)buffer.readUShort();
                continue;
            }
            if (opcode >= 50 && opcode < 60) {
                this.replacementColors[opcode - 50] = (short)buffer.readUShort();
                continue;
            }
            if (opcode >= 60 && opcode < 70) {
                this.headModels[opcode - 60] = buffer.readUShort();
                continue;
            }
            System.out.println("Error unrecognised config code: " + opcode);
        }
    }

    public boolean body_cached() {
        if (this.bodyModels == null) {
            return true;
        }
        boolean ready = true;
        for (int part = 0; part < this.bodyModels.length; ++part) {
            if (Model.cached(this.bodyModels[part])) continue;
            ready = false;
        }
        return ready;
    }

    public Model get_body() {
        if (this.bodyModels == null) {
            return null;
        }
        Model[] models = new Model[this.bodyModels.length];
        for (int part = 0; part < this.bodyModels.length; ++part) {
            models[part] = Model.get(this.bodyModels[part]);
        }
        Model model = models.length == 1 ? models[0] : new Model(models.length, models, true);
        for (int part = 0; part < 6 && this.originalColors[part] != 0; ++part) {
            model.recolor(this.originalColors[part], this.replacementColors[part]);
        }
        return model;
    }

    public boolean headLoaded() {
        boolean ready = true;
        for (int part = 0; part < 5; ++part) {
            if (this.headModels[part] == -1 || Model.cached(this.headModels[part])) continue;
            ready = false;
        }
        return ready;
    }

    public Model get_head() {
        Model[] models = new Model[5];
        int count = 0;
        for (int part = 0; part < 5; ++part) {
            if (this.headModels[part] == -1) continue;
            models[count++] = Model.get(this.headModels[part]);
        }
        Model model = new Model(count, models, true);
        for (int part = 0; part < 6 && this.originalColors[part] != 0; ++part) {
            model.recolor(this.originalColors[part], this.replacementColors[part]);
        }
        return model;
    }
}

