/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.entity.model;

import com.ornate.cache.anim.Animation;
import com.ornate.cache.anim.Skins;
import com.ornate.draw.Rasterizer2D;
import com.ornate.draw.Rasterizer3D;
import com.ornate.entity.Renderable;
import com.ornate.entity.model.ModelHeader;
import com.ornate.entity.model.ModelLoader;
import com.ornate.entity.model.Vertex;
import com.ornate.io.Buffer;
import com.ornate.net.requester.Provider;
import com.ornate.scene.SceneGraph;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Model
extends Renderable {
    public static int anInt1620;
    public static Model EMPTY_MODEL;
    public static boolean obj_exists;
    public static int anInt1685;
    public static int anInt1686;
    public static int anInt1687;
    public static long[] anIntArray1688;
    public static int[] SINE;
    public static int[] COSINE;
    static ModelHeader[] header;
    static Provider resourceProvider;
    static boolean[] hasAnEdgeToRestrict;
    static boolean[] outOfReach;
    static int[] projected_vertex_x;
    static int[] projected_vertex_y;
    static int[] projected_vertex_z;
    static int[] camera_vertex_x;
    static int[] camera_vertex_y;
    static int[] camera_vertex_z;
    static int[] depthListIndices;
    static int[][] faceLists;
    static int[] anIntArray1673;
    static int[][] anIntArrayArray1674;
    static int[] anIntArray1675;
    static int[] anIntArray1676;
    static int[] anIntArray1677;
    static int[] anIntArray1678;
    static int[] anIntArray1679;
    static int[] anIntArray1680;
    static int xAnimOffset;
    static int yAnimOffset;
    static int zAnimOffset;
    static int[] modelIntArray3;
    static int[] modelIntArray4;
    private static int[] anIntArray1622;
    private static int[] anIntArray1623;
    private static int[] anIntArray1624;
    private static int[] anIntArray1625;
    public int[] face_material;
    public byte[] face_texture;
    public byte[] texture_map;
    public int vertices;
    public int[] vertex_x;
    public int[] vertex_y;
    public int[] vertex_z;
    public int faces;
    public int[] triangle_edge_a;
    public int[] triangle_edge_b;
    public int[] triangle_edge_c;
    public int[] faceHslA;
    public int[] faceHslB;
    public int[] faceHslC;
    public int[] render_type;
    public byte[] face_render_priorities;
    public int[] face_alpha;
    public int[] face_color;
    public byte face_priority = 0;
    public int texture_faces;
    public int[] triangle_texture_edge_a;
    public int[] triangle_texture_edge_b;
    public int[] triangle_texture_edge_c;
    public int min_x;
    public int max_x;
    public int max_z;
    public int min_z;
    public int diagonal_2D;
    public int max_y;
    public int scene_depth;
    public int diagonal_3D;
    public int obj_height;
    public int[] bone_skin;
    public int[] muscle_skin;
    public int[][] vertex_skin;
    public int[][] face_skin;
    public boolean within_tile;
    public Vertex[] gouraud_vertex;
    private boolean aBoolean1618;
    private static final Set<Integer> repeatedTextureModels;
    private static final Set<Integer> isHigherRevModel;
    public boolean[] repeatTexture;
    public int[][] animayaGroups;
    public int[][] animayaScales;
    public static final int VIEW_DISTANCE = 3500;
    public int field1944;
    public int field1947;
    public int field1963;
    public int field1948;
    public int field1946;
    public int field1924;
    public int bufferOffset;
    public int uvBufferOffset;

    private static void addAllHigherRevModels(int ... values) {
        for (int value : values) {
            isHigherRevModel.add(value);
        }
    }

    private static void addAll(int ... values) {
        for (int value : values) {
            repeatedTextureModels.add(value);
        }
    }

    private Model(int modelId) {
        byte[] is = Model.header[modelId].data;
        if (isHigherRevModel.contains(modelId)) {
            ModelLoader.read622Model(this, is, modelId);
        } else if (is[is.length - 1] == -3 && is[is.length - 2] == -1) {
            ModelLoader.decodeType3(this, is);
        } else if (is[is.length - 1] == -2 && is[is.length - 2] == -1) {
            ModelLoader.decodeType2(this, is);
        } else if (is[is.length - 1] == -1 && is[is.length - 2] == -1) {
            ModelLoader.decodeType1(this, is);
        } else {
            ModelLoader.decodeOldFormat(this, is);
        }
        this.repeatTexture = new boolean[this.faces];
        if (repeatedTextureModels.contains(modelId)) {
            Arrays.fill(this.repeatTexture, true);
        }
    }

    private Model(boolean flag) {
        this.aBoolean1618 = true;
        this.within_tile = false;
        if (!flag) {
            this.aBoolean1618 = !this.aBoolean1618;
        }
    }

    public Model(int length, Model[] model_segments, boolean preset) {
        try {
            Model build;
            int segment_index;
            this.aBoolean1618 = true;
            this.within_tile = false;
            ++anInt1620;
            boolean render_type_flag = false;
            boolean priority_flag = false;
            boolean alpha_flag = false;
            boolean muscle_skin_flag = false;
            boolean color_flag = false;
            boolean texture_flag = false;
            boolean coordinate_flag = false;
            this.vertices = 0;
            this.faces = 0;
            this.texture_faces = 0;
            this.face_priority = (byte)-1;
            for (segment_index = 0; segment_index < length; ++segment_index) {
                build = model_segments[segment_index];
                if (build == null) continue;
                this.vertices += build.vertices;
                this.faces += build.faces;
                this.texture_faces += build.texture_faces;
                if (build.face_render_priorities != null) {
                    priority_flag = true;
                } else {
                    if (this.face_priority == -1) {
                        this.face_priority = build.face_priority;
                    }
                    if (this.face_priority != build.face_priority) {
                        priority_flag = true;
                    }
                }
                render_type_flag |= build.render_type != null;
                alpha_flag |= build.face_alpha != null;
                muscle_skin_flag |= build.muscle_skin != null;
                color_flag |= build.face_color != null;
                texture_flag |= build.face_material != null;
                coordinate_flag |= build.face_texture != null;
            }
            this.vertex_x = new int[this.vertices];
            this.vertex_y = new int[this.vertices];
            this.vertex_z = new int[this.vertices];
            this.bone_skin = new int[this.vertices];
            this.triangle_edge_a = new int[this.faces];
            this.triangle_edge_b = new int[this.faces];
            this.triangle_edge_c = new int[this.faces];
            this.repeatTexture = new boolean[this.faces];
            if (color_flag) {
                this.face_color = new int[this.faces];
                this.repeatTexture = new boolean[this.faces];
            }
            if (render_type_flag) {
                this.render_type = new int[this.faces];
            }
            if (priority_flag) {
                this.face_render_priorities = new byte[this.faces];
            }
            if (alpha_flag) {
                this.face_alpha = new int[this.faces];
            }
            if (muscle_skin_flag) {
                this.muscle_skin = new int[this.faces];
            }
            if (texture_flag) {
                this.face_material = new int[this.faces];
            }
            if (coordinate_flag) {
                this.face_texture = new byte[this.faces];
            }
            if (this.texture_faces > 0) {
                this.texture_map = new byte[this.texture_faces];
                this.triangle_texture_edge_a = new int[this.texture_faces];
                this.triangle_texture_edge_b = new int[this.texture_faces];
                this.triangle_texture_edge_c = new int[this.texture_faces];
            }
            this.vertices = 0;
            this.faces = 0;
            this.texture_faces = 0;
            for (segment_index = 0; segment_index < length; ++segment_index) {
                build = model_segments[segment_index];
                if (build == null) continue;
                for (int face = 0; face < build.faces; ++face) {
                    if (render_type_flag && build.render_type != null) {
                        this.render_type[this.faces] = build.render_type[face];
                    }
                    if (priority_flag) {
                        this.face_render_priorities[this.faces] = build.face_render_priorities == null ? build.face_priority : build.face_render_priorities[face];
                    }
                    if (alpha_flag && build.face_alpha != null) {
                        this.face_alpha[this.faces] = build.face_alpha[face];
                    }
                    if (muscle_skin_flag && build.muscle_skin != null) {
                        this.muscle_skin[this.faces] = build.muscle_skin[face];
                    }
                    if (texture_flag) {
                        this.face_material[this.faces] = build.face_material != null ? build.face_material[face] : -1;
                    }
                    if (coordinate_flag) {
                        this.face_texture[this.faces] = build.face_texture != null && build.face_texture[face] != -1 ? (int)(build.face_texture[face] + this.texture_faces) : -1;
                    }
                    if (color_flag && build.face_color != null) {
                        this.face_color[this.faces] = build.face_color[face];
                    }
                    this.repeatTexture[this.faces] = build.repeatTexture[face];
                    this.triangle_edge_a[this.faces] = this.method465(build, build.triangle_edge_a[face]);
                    this.triangle_edge_b[this.faces] = this.method465(build, build.triangle_edge_b[face]);
                    this.triangle_edge_c[this.faces] = this.method465(build, build.triangle_edge_c[face]);
                    ++this.faces;
                }
                for (int texture_edge = 0; texture_edge < build.texture_faces; ++texture_edge) {
                    this.texture_map[this.texture_faces] = build.texture_map[texture_edge];
                    byte opcode = this.texture_map[this.texture_faces];
                    if (opcode == 0) {
                        this.triangle_texture_edge_a[this.texture_faces] = (short)this.method465(build, build.triangle_texture_edge_a[texture_edge]);
                        this.triangle_texture_edge_b[this.texture_faces] = (short)this.method465(build, build.triangle_texture_edge_b[texture_edge]);
                        this.triangle_texture_edge_c[this.texture_faces] = (short)this.method465(build, build.triangle_texture_edge_c[texture_edge]);
                    }
                    if (opcode >= 1 && opcode <= 3) {
                        this.triangle_texture_edge_a[this.texture_faces] = build.triangle_texture_edge_a[texture_edge];
                        this.triangle_texture_edge_b[this.texture_faces] = build.triangle_texture_edge_b[texture_edge];
                        this.triangle_texture_edge_c[this.texture_faces] = build.triangle_texture_edge_c[texture_edge];
                    }
                    if (opcode == 2) {
                        // empty if block
                    }
                    ++this.texture_faces;
                }
                if (preset) continue;
                ++this.texture_faces;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public Model(Model[] amodel) {
        int i = 2;
        this.aBoolean1618 = true;
        this.within_tile = false;
        ++anInt1620;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        boolean texture_flag = false;
        boolean coordinate_flag = false;
        this.vertices = 0;
        this.faces = 0;
        this.texture_faces = 0;
        this.face_priority = (byte)-1;
        for (int k = 0; k < i; ++k) {
            Model model = amodel[k];
            if (model == null) continue;
            this.vertices += model.vertices;
            this.faces += model.faces;
            this.texture_faces += model.texture_faces;
            flag1 |= model.render_type != null;
            if (model.face_render_priorities != null) {
                flag2 = true;
            } else {
                if (this.face_priority == -1) {
                    this.face_priority = model.face_priority;
                }
                if (this.face_priority != model.face_priority) {
                    flag2 = true;
                }
            }
            flag3 |= model.face_alpha != null;
            flag4 |= model.face_color != null;
            texture_flag |= model.face_material != null;
            coordinate_flag |= model.face_texture != null;
        }
        this.vertex_x = new int[this.vertices];
        this.vertex_y = new int[this.vertices];
        this.vertex_z = new int[this.vertices];
        this.triangle_edge_a = new int[this.faces];
        this.triangle_edge_b = new int[this.faces];
        this.triangle_edge_c = new int[this.faces];
        this.faceHslA = new int[this.faces];
        this.faceHslB = new int[this.faces];
        this.faceHslC = new int[this.faces];
        this.triangle_texture_edge_a = new int[this.texture_faces];
        this.triangle_texture_edge_b = new int[this.texture_faces];
        this.triangle_texture_edge_c = new int[this.texture_faces];
        if (flag1) {
            this.render_type = new int[this.faces];
        }
        if (flag2) {
            this.face_render_priorities = new byte[this.faces];
        }
        if (flag3) {
            this.face_alpha = new int[this.faces];
        }
        if (flag4) {
            this.face_color = new int[this.faces];
            this.repeatTexture = new boolean[this.faces];
        }
        if (texture_flag) {
            this.face_material = new int[this.faces];
        }
        if (coordinate_flag) {
            this.face_texture = new byte[this.faces];
        }
        this.vertices = 0;
        this.faces = 0;
        this.texture_faces = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < i; ++j1) {
            Model model_1 = amodel[j1];
            if (model_1 == null) continue;
            int k1 = this.vertices;
            for (int l1 = 0; l1 < model_1.vertices; ++l1) {
                int x = model_1.vertex_x[l1];
                int y = model_1.vertex_y[l1];
                int z = model_1.vertex_z[l1];
                this.vertex_x[this.vertices] = x;
                this.vertex_y[this.vertices] = y;
                this.vertex_z[this.vertices] = z;
                ++this.vertices;
            }
            for (int uid = 0; uid < model_1.faces; ++uid) {
                this.triangle_edge_a[this.faces] = model_1.triangle_edge_a[uid] + k1;
                this.triangle_edge_b[this.faces] = model_1.triangle_edge_b[uid] + k1;
                this.triangle_edge_c[this.faces] = model_1.triangle_edge_c[uid] + k1;
                this.faceHslA[this.faces] = model_1.faceHslA[uid];
                this.faceHslB[this.faces] = model_1.faceHslB[uid];
                this.faceHslC[this.faces] = model_1.faceHslC[uid];
                if (flag1) {
                    if (model_1.render_type == null) {
                        this.render_type[this.faces] = 0;
                    } else {
                        int j2 = model_1.render_type[uid];
                        if ((j2 & 2) == 2) {
                            j2 += i1 << 2;
                        }
                        this.render_type[this.faces] = j2;
                    }
                }
                if (flag2) {
                    this.face_render_priorities[this.faces] = model_1.face_render_priorities == null ? model_1.face_priority : model_1.face_render_priorities[uid];
                }
                if (flag3) {
                    this.face_alpha[this.faces] = model_1.face_alpha == null ? 0 : model_1.face_alpha[uid];
                }
                if (flag4 && model_1.face_color != null) {
                    this.face_color[this.faces] = model_1.face_color[uid];
                    this.repeatTexture[this.faces] = model_1.repeatTexture[uid];
                }
                if (texture_flag) {
                    this.face_material[this.faces] = model_1.face_material != null ? model_1.face_material[this.faces] : -1;
                }
                if (coordinate_flag) {
                    this.face_texture[this.faces] = model_1.face_texture != null && model_1.face_texture[this.faces] != -1 ? (int)(model_1.face_texture[this.faces] + this.texture_faces) : -1;
                }
                ++this.faces;
            }
            for (int k2 = 0; k2 < model_1.texture_faces; ++k2) {
                this.triangle_texture_edge_a[this.texture_faces] = (short)(model_1.triangle_texture_edge_a[k2] + k1);
                this.triangle_texture_edge_b[this.texture_faces] = (short)(model_1.triangle_texture_edge_b[k2] + k1);
                this.triangle_texture_edge_c[this.texture_faces] = (short)(model_1.triangle_texture_edge_c[k2] + k1);
                ++this.texture_faces;
            }
            i1 += model_1.texture_faces;
        }
        this.calc_diagonals();
    }

    public Model(boolean color_flag, boolean alpha_flag, boolean animated, Model model) {
        this(color_flag, alpha_flag, animated, false, model);
    }

    public Model(boolean color_flag, boolean alpha_flag, boolean animated, boolean texture_flag, Model model) {
        int face;
        this.aBoolean1618 = true;
        this.within_tile = false;
        ++anInt1620;
        this.vertices = model.vertices;
        this.faces = model.faces;
        this.texture_faces = model.texture_faces;
        if (animated) {
            this.vertex_x = model.vertex_x;
            this.vertex_y = model.vertex_y;
            this.vertex_z = model.vertex_z;
        } else {
            this.vertex_x = new int[this.vertices];
            this.vertex_y = new int[this.vertices];
            this.vertex_z = new int[this.vertices];
            for (int point = 0; point < this.vertices; ++point) {
                this.vertex_x[point] = model.vertex_x[point];
                this.vertex_y[point] = model.vertex_y[point];
                this.vertex_z[point] = model.vertex_z[point];
            }
        }
        if (color_flag) {
            this.face_color = model.face_color;
            this.repeatTexture = model.repeatTexture;
        } else {
            this.face_color = new int[this.faces];
            this.repeatTexture = new boolean[this.faces];
            for (face = 0; face < this.faces; ++face) {
                this.face_color[face] = model.face_color[face];
                this.repeatTexture[face] = model.repeatTexture[face];
            }
        }
        if (!texture_flag && model.face_material != null) {
            this.face_material = new int[this.faces];
            for (face = 0; face < this.faces; ++face) {
                this.face_material[face] = model.face_material[face];
            }
        } else {
            this.face_material = model.face_material;
        }
        if (alpha_flag) {
            this.face_alpha = model.face_alpha;
        } else {
            this.face_alpha = new int[this.faces];
            if (model.face_alpha == null) {
                for (int l = 0; l < this.faces; ++l) {
                    this.face_alpha[l] = 0;
                }
            } else {
                for (int i1 = 0; i1 < this.faces; ++i1) {
                    this.face_alpha[i1] = model.face_alpha[i1];
                }
            }
        }
        this.bone_skin = model.bone_skin;
        this.muscle_skin = model.muscle_skin;
        this.render_type = model.render_type;
        this.triangle_edge_a = model.triangle_edge_a;
        this.triangle_edge_b = model.triangle_edge_b;
        this.triangle_edge_c = model.triangle_edge_c;
        this.face_render_priorities = model.face_render_priorities;
        this.face_texture = model.face_texture;
        this.texture_map = model.texture_map;
        this.face_priority = model.face_priority;
        this.triangle_texture_edge_a = model.triangle_texture_edge_a;
        this.triangle_texture_edge_b = model.triangle_texture_edge_b;
        this.triangle_texture_edge_c = model.triangle_texture_edge_c;
    }

    public Model(boolean adjust_elevation, boolean gouraud_shading, Model model) {
        int point;
        this.aBoolean1618 = true;
        this.within_tile = false;
        ++anInt1620;
        this.vertices = model.vertices;
        this.faces = model.faces;
        this.texture_faces = model.texture_faces;
        if (adjust_elevation) {
            this.vertex_y = new int[this.vertices];
            for (point = 0; point < this.vertices; ++point) {
                this.vertex_y[point] = model.vertex_y[point];
            }
        } else {
            this.vertex_y = model.vertex_y;
        }
        if (gouraud_shading) {
            int face;
            this.faceHslA = new int[this.faces];
            this.faceHslB = new int[this.faces];
            this.faceHslC = new int[this.faces];
            for (face = 0; face < this.faces; ++face) {
                this.faceHslA[face] = model.faceHslA[face];
                this.faceHslB[face] = model.faceHslB[face];
                this.faceHslC[face] = model.faceHslC[face];
            }
            this.render_type = new int[this.faces];
            if (model.render_type == null) {
                for (face = 0; face < this.faces; ++face) {
                    this.render_type[face] = 0;
                }
            } else {
                for (face = 0; face < this.faces; ++face) {
                    this.render_type[face] = model.render_type[face];
                }
            }
            this.normals = new Vertex[this.vertices];
            for (point = 0; point < this.vertices; ++point) {
                Vertex class33 = this.normals[point] = new Vertex();
                Vertex class33_1 = model.normals[point];
                class33.x = class33_1.x;
                class33.y = class33_1.y;
                class33.z = class33_1.z;
                class33.magnitude = class33_1.magnitude;
            }
            this.gouraud_vertex = model.gouraud_vertex;
        } else {
            this.faceHslA = model.faceHslA;
            this.faceHslB = model.faceHslB;
            this.faceHslC = model.faceHslC;
            this.render_type = model.render_type;
        }
        this.vertex_x = model.vertex_x;
        this.vertex_z = model.vertex_z;
        this.triangle_edge_a = model.triangle_edge_a;
        this.triangle_edge_b = model.triangle_edge_b;
        this.triangle_edge_c = model.triangle_edge_c;
        this.face_render_priorities = model.face_render_priorities;
        this.face_alpha = model.face_alpha;
        this.face_texture = model.face_texture;
        this.face_color = model.face_color;
        this.repeatTexture = model.repeatTexture;
        this.face_material = model.face_material;
        this.face_priority = model.face_priority;
        this.texture_map = model.texture_map;
        this.triangle_texture_edge_a = model.triangle_texture_edge_a;
        this.triangle_texture_edge_b = model.triangle_texture_edge_b;
        this.triangle_texture_edge_c = model.triangle_texture_edge_c;
        this.modelHeight = model.modelHeight;
        this.diagonal_2D = model.diagonal_2D;
        this.diagonal_3D = model.diagonal_3D;
        this.scene_depth = model.scene_depth;
        this.min_x = model.min_x;
        this.max_z = model.max_z;
        this.min_z = model.min_z;
        this.max_x = model.max_x;
    }

    public static void clear() {
        header = null;
        hasAnEdgeToRestrict = null;
        outOfReach = null;
        projected_vertex_y = null;
        projected_vertex_z = null;
        camera_vertex_x = null;
        camera_vertex_y = null;
        camera_vertex_z = null;
        depthListIndices = null;
        faceLists = null;
        anIntArray1673 = null;
        anIntArrayArray1674 = null;
        anIntArray1675 = null;
        anIntArray1676 = null;
        anIntArray1677 = null;
        SINE = null;
        COSINE = null;
        modelIntArray3 = null;
        modelIntArray4 = null;
    }

    public static void method460(byte[] abyte0, int j) {
        try {
            int l2;
            if (abyte0 == null) {
                ModelHeader class21 = Model.header[j] = new ModelHeader();
                class21.vertices = 0;
                class21.faces = 0;
                class21.texture_faces = 0;
                return;
            }
            Buffer stream = new Buffer(abyte0);
            stream.pos = abyte0.length - 18;
            ModelHeader class21_1 = Model.header[j] = new ModelHeader();
            class21_1.data = abyte0;
            class21_1.vertices = stream.readUShort();
            class21_1.faces = stream.readUShort();
            class21_1.texture_faces = stream.readUByte();
            int k = stream.readUByte();
            int l = stream.readUByte();
            int i1 = stream.readUByte();
            int j1 = stream.readUByte();
            int k1 = stream.readUByte();
            int l1 = stream.readUShort();
            int uid = stream.readUShort();
            int j2 = stream.readUShort();
            int k2 = stream.readUShort();
            class21_1.vertex_offset = l2 = 0;
            class21_1.face_offset = l2 += class21_1.vertices;
            class21_1.face_pri_offset = l2 += class21_1.faces;
            if (l == 255) {
                l2 += class21_1.faces;
            } else {
                class21_1.face_pri_offset = -l - 1;
            }
            class21_1.muscle_offset = l2;
            if (j1 == 1) {
                l2 += class21_1.faces;
            } else {
                class21_1.muscle_offset = -1;
            }
            class21_1.render_type_offset = l2;
            if (k == 1) {
                l2 += class21_1.faces;
            } else {
                class21_1.muscle_offset = -1;
            }
            class21_1.bones_offset = l2;
            if (k1 == 1) {
                l2 += class21_1.vertices;
            } else {
                class21_1.bones_offset = -1;
            }
            class21_1.alpha_offset = l2;
            if (i1 == 1) {
                l2 += class21_1.faces;
            } else {
                class21_1.alpha_offset = -1;
            }
            class21_1.points_offset = l2;
            class21_1.color_id = l2 += k2;
            class21_1.texture_id = l2 += class21_1.faces * 2;
            class21_1.vertex_x_offset = l2 += class21_1.texture_faces * 6;
            class21_1.vertex_y_offset = l2 += l1;
            class21_1.vertex_z_offset = l2 += uid;
            l2 += j2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void method459(int id, Provider onDemandFetcherParent) {
        header = new ModelHeader[90000];
        resourceProvider = onDemandFetcherParent;
    }

    public static void method461(int file) {
        Model.header[file] = null;
    }

    public static Model get(int file) {
        if (header == null) {
            return null;
        }
        ModelHeader class21 = header[file];
        if (class21 == null) {
            resourceProvider.provide(file);
            return null;
        }
        return new Model(file);
    }

    public static boolean cached(int file) {
        if (header == null) {
            return false;
        }
        ModelHeader class21 = header[file];
        if (class21 == null) {
            resourceProvider.provide(file);
            return false;
        }
        return true;
    }

    public void replace(Model model, boolean alpha_flag) {
        this.vertices = model.vertices;
        this.faces = model.faces;
        this.texture_faces = model.texture_faces;
        if (anIntArray1622.length < this.vertices) {
            anIntArray1622 = new int[this.vertices + 10000];
            anIntArray1623 = new int[this.vertices + 10000];
            anIntArray1624 = new int[this.vertices + 10000];
        }
        this.vertex_x = anIntArray1622;
        this.vertex_y = anIntArray1623;
        this.vertex_z = anIntArray1624;
        for (int point = 0; point < this.vertices; ++point) {
            this.vertex_x[point] = model.vertex_x[point];
            this.vertex_y[point] = model.vertex_y[point];
            this.vertex_z[point] = model.vertex_z[point];
        }
        if (alpha_flag) {
            this.face_alpha = model.face_alpha;
        } else {
            int face;
            if (anIntArray1625.length < this.faces) {
                anIntArray1625 = new int[this.faces + 100];
            }
            this.face_alpha = anIntArray1625;
            if (model.face_alpha == null) {
                for (face = 0; face < this.faces; ++face) {
                    this.face_alpha[face] = 0;
                }
            } else {
                for (face = 0; face < this.faces; ++face) {
                    this.face_alpha[face] = model.face_alpha[face];
                }
            }
        }
        this.render_type = model.render_type;
        this.face_color = model.face_color;
        this.repeatTexture = model.repeatTexture;
        this.face_render_priorities = model.face_render_priorities;
        this.face_priority = model.face_priority;
        this.face_skin = model.face_skin;
        this.vertex_skin = model.vertex_skin;
        this.triangle_edge_a = model.triangle_edge_a;
        this.triangle_edge_b = model.triangle_edge_b;
        this.triangle_edge_c = model.triangle_edge_c;
        this.faceHslA = model.faceHslA;
        this.faceHslB = model.faceHslB;
        this.faceHslC = model.faceHslC;
        this.triangle_texture_edge_a = model.triangle_texture_edge_a;
        this.triangle_texture_edge_b = model.triangle_texture_edge_b;
        this.triangle_texture_edge_c = model.triangle_texture_edge_c;
        this.face_texture = model.face_texture;
        this.texture_map = model.texture_map;
        this.face_material = model.face_material;
    }

    public void convertNPCTexture(int originalId, int targetId) {
        int assigned = 0;
        this.texture_faces = this.faces;
        this.triangle_texture_edge_a = new int[this.faces];
        this.triangle_texture_edge_b = new int[this.faces];
        this.triangle_texture_edge_c = new int[this.faces];
        for (int i = 0; i < this.faces; ++i) {
            if (this.face_color[i] != originalId) continue;
            this.face_color[i] = targetId;
            this.triangle_texture_edge_a[assigned] = this.triangle_edge_a[i];
            this.triangle_texture_edge_b[assigned] = this.triangle_edge_b[i];
            this.triangle_texture_edge_c[assigned] = this.triangle_edge_c[i];
            ++assigned;
        }
    }

    private final int method465(Model model, int face) {
        int vertex = -1;
        int x = model.vertex_x[face];
        int y = model.vertex_y[face];
        int z = model.vertex_z[face];
        for (int index = 0; index < this.vertices; ++index) {
            if (x != this.vertex_x[index] || y != this.vertex_y[index] || z != this.vertex_z[index]) continue;
            vertex = index;
            break;
        }
        if (vertex == -1) {
            this.vertex_x[this.vertices] = x;
            this.vertex_y[this.vertices] = y;
            this.vertex_z[this.vertices] = z;
            if (model.bone_skin != null) {
                this.bone_skin[this.vertices] = model.bone_skin[face];
            }
            vertex = this.vertices++;
        }
        return vertex;
    }

    public void calc_diagonals() {
        this.modelHeight = 0;
        this.diagonal_2D = 0;
        this.max_y = 0;
        for (int i = 0; i < this.vertices; ++i) {
            int i1;
            int j = this.vertex_x[i];
            int k = this.vertex_y[i];
            int l = this.vertex_z[i];
            if (-k > this.modelHeight) {
                this.modelHeight = -k;
            }
            if (k > this.max_y) {
                this.max_y = k;
            }
            if ((i1 = j * j + l * l) <= this.diagonal_2D) continue;
            this.diagonal_2D = i1;
        }
        this.diagonal_2D = (int)(Math.sqrt(this.diagonal_2D) + 0.99);
        this.diagonal_3D = (int)(Math.sqrt(this.diagonal_2D * this.diagonal_2D + this.modelHeight * this.modelHeight) + 0.99);
        this.scene_depth = this.diagonal_3D + (int)(Math.sqrt(this.diagonal_2D * this.diagonal_2D + this.max_y * this.max_y) + 0.99);
    }

    public void computeSphericalBounds() {
        this.modelHeight = 0;
        this.max_y = 0;
        for (int i = 0; i < this.vertices; ++i) {
            int j = this.vertex_y[i];
            if (-j > this.modelHeight) {
                this.modelHeight = -j;
            }
            if (j <= this.max_y) continue;
            this.max_y = j;
        }
        this.diagonal_3D = (int)(Math.sqrt(this.diagonal_2D * this.diagonal_2D + this.modelHeight * this.modelHeight) + 0.99);
        this.scene_depth = this.diagonal_3D + (int)(Math.sqrt(this.diagonal_2D * this.diagonal_2D + this.max_y * this.max_y) + 0.99);
    }

    public void calculateVertexData(int i) {
        this.modelHeight = 0;
        this.diagonal_2D = 0;
        this.max_y = 0;
        this.min_x = 999999;
        this.max_x = -999999;
        this.max_z = -99999;
        this.min_z = 99999;
        for (int j = 0; j < this.vertices; ++j) {
            int j1;
            int k = this.vertex_x[j];
            int l = this.vertex_y[j];
            int i1 = this.vertex_z[j];
            if (k < this.min_x) {
                this.min_x = k;
            }
            if (k > this.max_x) {
                this.max_x = k;
            }
            if (i1 < this.min_z) {
                this.min_z = i1;
            }
            if (i1 > this.max_z) {
                this.max_z = i1;
            }
            if (-l > this.modelHeight) {
                this.modelHeight = -l;
            }
            if (l > this.max_y) {
                this.max_y = l;
            }
            if ((j1 = k * k + i1 * i1) <= this.diagonal_2D) continue;
            this.diagonal_2D = j1;
        }
        this.diagonal_2D = (int)Math.sqrt(this.diagonal_2D);
        this.diagonal_3D = (int)Math.sqrt(this.diagonal_2D * this.diagonal_2D + this.modelHeight * this.modelHeight);
        if (i != 21073) {
            return;
        }
        this.scene_depth = this.diagonal_3D + (int)Math.sqrt(this.diagonal_2D * this.diagonal_2D + this.max_y * this.max_y);
    }

    public void scale2(int i) {
        for (int i1 = 0; i1 < this.vertices; ++i1) {
            this.vertex_x[i1] = this.vertex_x[i1] / i;
            this.vertex_y[i1] = this.vertex_y[i1] / i;
            this.vertex_z[i1] = this.vertex_z[i1] / i;
        }
    }

    public void scale2(int i, int j, int k) {
        for (int i1 = 0; i1 < this.vertices; ++i1) {
            this.vertex_x[i1] = this.vertex_x[i1] * i >> 7;
            this.vertex_y[i1] = this.vertex_y[i1] * j >> 7;
            this.vertex_z[i1] = this.vertex_z[i1] * k >> 7;
        }
    }

    public void skin() {
        if (this.bone_skin != null) {
            int[] ai = new int[256];
            int j = 0;
            for (int l = 0; l < this.vertices; ++l) {
                int j1;
                int n = j1 = this.bone_skin[l];
                ai[n] = ai[n] + 1;
                if (j1 <= j) continue;
                j = j1;
            }
            this.vertex_skin = new int[j + 1][];
            for (int k1 = 0; k1 <= j; ++k1) {
                this.vertex_skin[k1] = new int[ai[k1]];
                ai[k1] = 0;
            }
            int j2 = 0;
            while (j2 < this.vertices) {
                int l2;
                int n = l2 = this.bone_skin[j2];
                int n2 = ai[n];
                ai[n] = n2 + 1;
                this.vertex_skin[l2][n2] = j2++;
            }
            this.bone_skin = null;
        }
        if (this.muscle_skin != null) {
            int[] ai1 = new int[256];
            int k = 0;
            for (int i1 = 0; i1 < this.faces; ++i1) {
                int l1;
                int n = l1 = this.muscle_skin[i1];
                ai1[n] = ai1[n] + 1;
                if (l1 <= k) continue;
                k = l1;
            }
            this.face_skin = new int[k + 1][];
            for (int uid = 0; uid <= k; ++uid) {
                this.face_skin[uid] = new int[ai1[uid]];
                ai1[uid] = 0;
            }
            int k2 = 0;
            while (k2 < this.faces) {
                int i3;
                int n = i3 = this.muscle_skin[k2];
                int n3 = ai1[n];
                ai1[n] = n3 + 1;
                this.face_skin[i3][n3] = k2++;
            }
            this.muscle_skin = null;
        }
    }

    private void transform(int animationType, int[] skin, int x, int y, int z) {
        int i1 = skin.length;
        if (animationType == 0) {
            int j1 = 0;
            xAnimOffset = 0;
            yAnimOffset = 0;
            zAnimOffset = 0;
            for (int k2 = 0; k2 < i1; ++k2) {
                int l3 = skin[k2];
                if (l3 >= this.vertex_skin.length) continue;
                int[] ai5 = this.vertex_skin[l3];
                for (int i5 = 0; i5 < ai5.length; ++i5) {
                    int j6 = ai5[i5];
                    xAnimOffset += this.vertex_x[j6];
                    yAnimOffset += this.vertex_y[j6];
                    zAnimOffset += this.vertex_z[j6];
                    ++j1;
                }
            }
            if (j1 > 0) {
                xAnimOffset = xAnimOffset / j1 + x;
                yAnimOffset = yAnimOffset / j1 + y;
                zAnimOffset = zAnimOffset / j1 + z;
                return;
            }
            xAnimOffset = x;
            yAnimOffset = y;
            zAnimOffset = z;
            return;
        }
        if (animationType == 1) {
            for (int k1 = 0; k1 < i1; ++k1) {
                int l2 = skin[k1];
                if (l2 >= this.vertex_skin.length) continue;
                int[] ai1 = this.vertex_skin[l2];
                for (int i4 = 0; i4 < ai1.length; ++i4) {
                    int j5;
                    int n = j5 = ai1[i4];
                    this.vertex_x[n] = this.vertex_x[n] + x;
                    int n2 = j5;
                    this.vertex_y[n2] = this.vertex_y[n2] + y;
                    int n3 = j5;
                    this.vertex_z[n3] = this.vertex_z[n3] + z;
                }
            }
            return;
        }
        if (animationType == 2) {
            for (int l1 = 0; l1 < i1; ++l1) {
                int i3 = skin[l1];
                if (i3 >= this.vertex_skin.length) continue;
                int[] ai2 = this.vertex_skin[i3];
                for (int j4 = 0; j4 < ai2.length; ++j4) {
                    int k5;
                    int n = k5 = ai2[j4];
                    this.vertex_x[n] = this.vertex_x[n] - xAnimOffset;
                    int n4 = k5;
                    this.vertex_y[n4] = this.vertex_y[n4] - yAnimOffset;
                    int n5 = k5;
                    this.vertex_z[n5] = this.vertex_z[n5] - zAnimOffset;
                    int k6 = (x & 0xFF) * 8;
                    int l6 = (y & 0xFF) * 8;
                    int i7 = (z & 0xFF) * 8;
                    if (i7 != 0) {
                        int j7 = SINE[i7];
                        int i8 = COSINE[i7];
                        int l8 = this.vertex_y[k5] * j7 + this.vertex_x[k5] * i8 >> 16;
                        this.vertex_y[k5] = this.vertex_y[k5] * i8 - this.vertex_x[k5] * j7 >> 16;
                        this.vertex_x[k5] = l8;
                    }
                    if (k6 != 0) {
                        int k7 = SINE[k6];
                        int j8 = COSINE[k6];
                        int i9 = this.vertex_y[k5] * j8 - this.vertex_z[k5] * k7 >> 16;
                        this.vertex_z[k5] = this.vertex_y[k5] * k7 + this.vertex_z[k5] * j8 >> 16;
                        this.vertex_y[k5] = i9;
                    }
                    if (l6 != 0) {
                        int l7 = SINE[l6];
                        int k8 = COSINE[l6];
                        int j9 = this.vertex_z[k5] * l7 + this.vertex_x[k5] * k8 >> 16;
                        this.vertex_z[k5] = this.vertex_z[k5] * k8 - this.vertex_x[k5] * l7 >> 16;
                        this.vertex_x[k5] = j9;
                    }
                    int n6 = k5;
                    this.vertex_x[n6] = this.vertex_x[n6] + xAnimOffset;
                    int n7 = k5;
                    this.vertex_y[n7] = this.vertex_y[n7] + yAnimOffset;
                    int n8 = k5;
                    this.vertex_z[n8] = this.vertex_z[n8] + zAnimOffset;
                }
            }
            return;
        }
        if (animationType == 3) {
            for (int i2 = 0; i2 < i1; ++i2) {
                int j3 = skin[i2];
                if (j3 >= this.vertex_skin.length) continue;
                int[] ai3 = this.vertex_skin[j3];
                for (int k4 = 0; k4 < ai3.length; ++k4) {
                    int l5;
                    int n = l5 = ai3[k4];
                    this.vertex_x[n] = this.vertex_x[n] - xAnimOffset;
                    int n9 = l5;
                    this.vertex_y[n9] = this.vertex_y[n9] - yAnimOffset;
                    int n10 = l5;
                    this.vertex_z[n10] = this.vertex_z[n10] - zAnimOffset;
                    this.vertex_x[l5] = this.vertex_x[l5] * x / 128;
                    this.vertex_y[l5] = this.vertex_y[l5] * y / 128;
                    this.vertex_z[l5] = this.vertex_z[l5] * z / 128;
                    int n11 = l5;
                    this.vertex_x[n11] = this.vertex_x[n11] + xAnimOffset;
                    int n12 = l5;
                    this.vertex_y[n12] = this.vertex_y[n12] + yAnimOffset;
                    int n13 = l5;
                    this.vertex_z[n13] = this.vertex_z[n13] + zAnimOffset;
                }
            }
            return;
        }
        if (animationType == 5 && this.face_skin != null && this.face_alpha != null) {
            for (int j2 = 0; j2 < i1; ++j2) {
                int k3 = skin[j2];
                if (k3 >= this.face_skin.length) continue;
                int[] ai4 = this.face_skin[k3];
                for (int l4 = 0; l4 < ai4.length; ++l4) {
                    int i6;
                    int n = i6 = ai4[l4];
                    this.face_alpha[n] = this.face_alpha[n] + x * 8;
                    if (this.face_alpha[i6] < 0) {
                        this.face_alpha[i6] = 0;
                    }
                    if (this.face_alpha[i6] <= 255) continue;
                    this.face_alpha[i6] = 255;
                }
            }
        }
    }

    private void transformSkin(int animationType, int[] skin, int x, int y, int z) {
        int i1 = skin.length;
        if (animationType == 0) {
            int j1 = 0;
            xAnimOffset = 0;
            yAnimOffset = 0;
            zAnimOffset = 0;
            for (int k2 = 0; k2 < i1; ++k2) {
                int l3 = skin[k2];
                if (l3 >= this.vertex_skin.length) continue;
                int[] ai5 = this.vertex_skin[l3];
                for (int i5 = 0; i5 < ai5.length; ++i5) {
                    int j6 = ai5[i5];
                    xAnimOffset += this.vertex_x[j6];
                    yAnimOffset += this.vertex_y[j6];
                    zAnimOffset += this.vertex_z[j6];
                    ++j1;
                }
            }
            if (j1 > 0) {
                xAnimOffset = xAnimOffset / j1 + x;
                yAnimOffset = yAnimOffset / j1 + y;
                zAnimOffset = zAnimOffset / j1 + z;
                return;
            }
            xAnimOffset = x;
            yAnimOffset = y;
            zAnimOffset = z;
            return;
        }
        if (animationType == 1) {
            for (int k1 = 0; k1 < i1; ++k1) {
                int l2 = skin[k1];
                if (l2 >= this.vertex_skin.length) continue;
                int[] ai1 = this.vertex_skin[l2];
                for (int i4 = 0; i4 < ai1.length; ++i4) {
                    int j5;
                    int n = j5 = ai1[i4];
                    this.vertex_x[n] = this.vertex_x[n] + x;
                    int n2 = j5;
                    this.vertex_y[n2] = this.vertex_y[n2] + y;
                    int n3 = j5;
                    this.vertex_z[n3] = this.vertex_z[n3] + z;
                }
            }
            return;
        }
        if (animationType == 2) {
            for (int l1 = 0; l1 < i1; ++l1) {
                int i3 = skin[l1];
                if (i3 >= this.vertex_skin.length) continue;
                int[] auid = this.vertex_skin[i3];
                for (int j4 = 0; j4 < auid.length; ++j4) {
                    int k5;
                    int n = k5 = auid[j4];
                    this.vertex_x[n] = this.vertex_x[n] - xAnimOffset;
                    int n4 = k5;
                    this.vertex_y[n4] = this.vertex_y[n4] - yAnimOffset;
                    int n5 = k5;
                    this.vertex_z[n5] = this.vertex_z[n5] - zAnimOffset;
                    int k6 = (x & 0xFF) * 8;
                    int l6 = (y & 0xFF) * 8;
                    int i7 = (z & 0xFF) * 8;
                    if (i7 != 0) {
                        int j7 = SINE[i7];
                        int i8 = COSINE[i7];
                        int l8 = this.vertex_y[k5] * j7 + this.vertex_x[k5] * i8 >> 16;
                        this.vertex_y[k5] = this.vertex_y[k5] * i8 - this.vertex_x[k5] * j7 >> 16;
                        this.vertex_x[k5] = l8;
                    }
                    if (k6 != 0) {
                        int k7 = SINE[k6];
                        int j8 = COSINE[k6];
                        int i9 = this.vertex_y[k5] * j8 - this.vertex_z[k5] * k7 >> 16;
                        this.vertex_z[k5] = this.vertex_y[k5] * k7 + this.vertex_z[k5] * j8 >> 16;
                        this.vertex_y[k5] = i9;
                    }
                    if (l6 != 0) {
                        int l7 = SINE[l6];
                        int k8 = COSINE[l6];
                        int j9 = this.vertex_z[k5] * l7 + this.vertex_x[k5] * k8 >> 16;
                        this.vertex_z[k5] = this.vertex_z[k5] * k8 - this.vertex_x[k5] * l7 >> 16;
                        this.vertex_x[k5] = j9;
                    }
                    int n6 = k5;
                    this.vertex_x[n6] = this.vertex_x[n6] + xAnimOffset;
                    int n7 = k5;
                    this.vertex_y[n7] = this.vertex_y[n7] + yAnimOffset;
                    int n8 = k5;
                    this.vertex_z[n8] = this.vertex_z[n8] + zAnimOffset;
                }
            }
            return;
        }
        if (animationType == 3) {
            for (int uid = 0; uid < i1; ++uid) {
                int j3 = skin[uid];
                if (j3 >= this.vertex_skin.length) continue;
                int[] ai3 = this.vertex_skin[j3];
                for (int k4 = 0; k4 < ai3.length; ++k4) {
                    int l5;
                    int n = l5 = ai3[k4];
                    this.vertex_x[n] = this.vertex_x[n] - xAnimOffset;
                    int n9 = l5;
                    this.vertex_y[n9] = this.vertex_y[n9] - yAnimOffset;
                    int n10 = l5;
                    this.vertex_z[n10] = this.vertex_z[n10] - zAnimOffset;
                    this.vertex_x[l5] = this.vertex_x[l5] * x / 128;
                    this.vertex_y[l5] = this.vertex_y[l5] * y / 128;
                    this.vertex_z[l5] = this.vertex_z[l5] * z / 128;
                    int n11 = l5;
                    this.vertex_x[n11] = this.vertex_x[n11] + xAnimOffset;
                    int n12 = l5;
                    this.vertex_y[n12] = this.vertex_y[n12] + yAnimOffset;
                    int n13 = l5;
                    this.vertex_z[n13] = this.vertex_z[n13] + zAnimOffset;
                }
            }
            return;
        }
        if (animationType == 5 && this.face_skin != null && this.face_alpha != null) {
            for (int j2 = 0; j2 < i1; ++j2) {
                int k3 = skin[j2];
                if (k3 >= this.face_skin.length) continue;
                int[] ai4 = this.face_skin[k3];
                for (int l4 = 0; l4 < ai4.length; ++l4) {
                    int i6;
                    int n = i6 = ai4[l4];
                    this.face_alpha[n] = this.face_alpha[n] + x * 8;
                    if (this.face_alpha[i6] < 0) {
                        this.face_alpha[i6] = 0;
                    }
                    if (this.face_alpha[i6] <= 255) continue;
                    this.face_alpha[i6] = 255;
                }
            }
        }
    }

    public void interpolate(int frameId) {
        if (this.vertex_skin == null) {
            return;
        }
        if (frameId == -1) {
            return;
        }
        Animation frame = Animation.get(frameId);
        if (frame == null) {
            return;
        }
        Skins skin = frame.base;
        xAnimOffset = 0;
        yAnimOffset = 0;
        zAnimOffset = 0;
        for (int index = 0; index < frame.transformationCount; ++index) {
            int pos = frame.transformationIndices[index];
            this.transform(skin.transformationType[pos], skin.skinList[pos], frame.transformX[index], frame.transformY[index], frame.transformZ[index]);
        }
    }

    public void mix(int[] label, int idle, int current) {
        int condition;
        int index;
        if (current == -1) {
            return;
        }
        if (label == null || idle == -1) {
            this.interpolate(current);
            return;
        }
        Animation anim = Animation.get(current);
        if (anim == null) {
            return;
        }
        Animation skin = Animation.get(idle);
        if (skin == null) {
            this.interpolate(current);
            return;
        }
        Skins list = anim.base;
        xAnimOffset = 0;
        yAnimOffset = 0;
        zAnimOffset = 0;
        int id = 0;
        int table = label[id++];
        for (index = 0; index < anim.transformationCount; ++index) {
            condition = anim.transformationIndices[index];
            while (condition > table) {
                table = label[id++];
            }
            if (condition == table && list.transformationType[condition] != 0) continue;
            this.transform(list.transformationType[condition], list.skinList[condition], anim.transformX[index], anim.transformY[index], anim.transformZ[index]);
        }
        xAnimOffset = 0;
        yAnimOffset = 0;
        zAnimOffset = 0;
        id = 0;
        table = label[id++];
        for (index = 0; index < skin.transformationCount; ++index) {
            condition = skin.transformationIndices[index];
            while (condition > table) {
                table = label[id++];
            }
            if (condition != table && list.transformationType[condition] != 0) continue;
            this.transform(list.transformationType[condition], list.skinList[condition], skin.transformX[index], skin.transformY[index], skin.transformZ[index]);
        }
    }

    public void rotate_90() {
        for (int point = 0; point < this.vertices; ++point) {
            int k = this.vertex_x[point];
            this.vertex_x[point] = this.vertex_z[point];
            this.vertex_z[point] = -k;
        }
    }

    public void leanOverX(int i) {
        int k = SINE[i];
        int l = COSINE[i];
        for (int point = 0; point < this.vertices; ++point) {
            int j1 = this.vertex_y[point] * l - this.vertex_z[point] * k >> 16;
            this.vertex_z[point] = this.vertex_y[point] * k + this.vertex_z[point] * l >> 16;
            this.vertex_y[point] = j1;
        }
    }

    public void translate(int x, int y, int z) {
        int point = 0;
        while (point < this.vertices) {
            int n = point;
            this.vertex_x[n] = this.vertex_x[n] + x;
            int n2 = point;
            this.vertex_y[n2] = this.vertex_y[n2] + y;
            int n3 = point++;
            this.vertex_z[n3] = this.vertex_z[n3] + z;
        }
    }

    public void recolor(int found, int replace) {
        if (this.face_color != null) {
            for (int face = 0; face < this.faces; ++face) {
                if (this.face_color[face] != (short)found) continue;
                this.face_color[face] = (short)replace;
            }
        }
    }

    public void retexture(short found, short replace) {
        if (this.face_material != null) {
            for (int face = 0; face < this.faces; ++face) {
                if (this.face_material[face] != found) continue;
                this.face_material[face] = replace;
            }
        }
    }

    public void filterTriangles() {
        for (int triangleId = 0; triangleId < this.faces; ++triangleId) {
            int l = this.triangle_edge_a[triangleId];
            int k1 = this.triangle_edge_b[triangleId];
            int j2_ = this.triangle_edge_c[triangleId];
            boolean b = true;
            for (int triId = 0; triId < this.faces; ++triId) {
                if (triId == triangleId) continue;
                if (this.triangle_edge_a[triId] == l) {
                    b = false;
                    break;
                }
                if (this.triangle_edge_b[triId] == k1) {
                    b = false;
                    break;
                }
                if (this.triangle_edge_c[triId] != j2_) continue;
                b = false;
                break;
            }
            if (!b || this.render_type == null) continue;
            this.face_alpha[triangleId] = 255;
        }
    }

    public void color_to_texture(Model model, short src, short dst, boolean debug) {
        if (model.face_color != null && model != null) {
            int face;
            if (model.render_type == null) {
                model.render_type = new int[model.faces];
                for (face = 0; face < this.faces; ++face) {
                    model.render_type[face] = model.face_color[face] == src ? 2 : 0;
                }
            } else {
                for (face = 0; face < this.faces; ++face) {
                    model.render_type[face] = model.face_color[face] == src ? 2 : 0;
                }
            }
            this.render_type = model.render_type;
            if (model.face_material == null) {
                model.face_material = new int[model.faces];
                for (face = 0; face < this.faces; ++face) {
                    if (model.face_color[face] != src) continue;
                    model.face_material[face] = dst;
                }
            } else {
                for (face = 0; face < this.faces; ++face) {
                    if (model.face_color[face] != src) continue;
                    model.face_material[face] = dst;
                }
            }
            this.face_material = model.face_material;
            if (model.face_texture == null) {
                model.face_texture = new byte[model.faces];
            }
            this.texture_map = new byte[model.faces];
            this.triangle_texture_edge_a = new int[model.faces];
            this.triangle_texture_edge_b = new int[model.faces];
            this.triangle_texture_edge_c = new int[model.faces];
            for (face = 0; face < model.faces; ++face) {
                if (model.face_color[face] == src) {
                    model.face_texture[face] = 2;
                    model.face_color[face] = 127;
                    model.texture_map[face] = 1;
                    ++model.texture_faces;
                }
                if (model.face_color[face] == 127 || src != -1) continue;
                this.render_type[face] = 0;
                this.face_material[face] = -1;
            }
            for (face = 0; face < model.texture_faces; ++face) {
                model.triangle_texture_edge_a[face] = (short)model.triangle_edge_a[face];
                model.triangle_texture_edge_b[face] = (short)model.triangle_edge_b[face];
                model.triangle_texture_edge_c[face] = (short)model.triangle_edge_c[face];
            }
        }
    }

    public void invert() {
        for (int index = 0; index < this.vertices; ++index) {
            this.vertex_z[index] = -this.vertex_z[index];
        }
        for (int face = 0; face < this.faces; ++face) {
            int l = this.triangle_edge_a[face];
            this.triangle_edge_a[face] = this.triangle_edge_c[face];
            this.triangle_edge_c[face] = l;
        }
    }

    public void scale(int i, int j, int l) {
        for (int index = 0; index < this.vertices; ++index) {
            this.vertex_x[index] = this.vertex_x[index] * i / 128;
            this.vertex_y[index] = this.vertex_y[index] * l / 128;
            this.vertex_z[index] = this.vertex_z[index] * j / 128;
        }
    }

    public void light(int i, int j, int k, int l, int i1, boolean flag) {
        this.light(i, j, k, l, i1, flag, false);
    }

    public void light(int i, int j, int k, int l, int i1, boolean flag, boolean player) {
        int j1 = (int)Math.sqrt(k * k + l * l + i1 * i1);
        int k1 = j * j1 >> 8;
        this.faceHslA = new int[this.faces];
        this.faceHslB = new int[this.faces];
        this.faceHslC = new int[this.faces];
        if (this.normals == null) {
            this.normals = new Vertex[this.vertices];
            for (int index = 0; index < this.vertices; ++index) {
                this.normals[index] = new Vertex();
            }
        }
        for (int face = 0; face < this.faces; ++face) {
            int j5;
            int j2 = this.triangle_edge_a[face];
            int l2 = this.triangle_edge_b[face];
            int i3 = this.triangle_edge_c[face];
            int j3 = this.vertex_x[l2] - this.vertex_x[j2];
            int k3 = this.vertex_y[l2] - this.vertex_y[j2];
            int l3 = this.vertex_z[l2] - this.vertex_z[j2];
            int i4 = this.vertex_x[i3] - this.vertex_x[j2];
            int j4 = this.vertex_y[i3] - this.vertex_y[j2];
            int k4 = this.vertex_z[i3] - this.vertex_z[j2];
            int l4 = k3 * k4 - j4 * l3;
            int i5 = l3 * i4 - k4 * j3;
            for (j5 = j3 * j4 - i4 * k3; l4 > 8192 || i5 > 8192 || j5 > 8192 || l4 < -8192 || i5 < -8192 || j5 < -8192; l4 >>= 1, i5 >>= 1, j5 >>= 1) {
            }
            int k5 = (int)Math.sqrt(l4 * l4 + i5 * i5 + j5 * j5);
            if (k5 <= 0) {
                k5 = 1;
            }
            l4 = l4 * 256 / k5;
            i5 = i5 * 256 / k5;
            j5 = j5 * 256 / k5;
            int type = this.render_type != null ? this.render_type[face] : 0;
            int texture_id = this.face_material == null ? -1 : this.face_material[face];
            if (this.render_type == null || (this.render_type[face] & 1) == 0) {
                Vertex class33_2 = this.normals[j2];
                class33_2.x += l4;
                class33_2.y += i5;
                class33_2.z += j5;
                ++class33_2.magnitude;
                class33_2 = this.normals[l2];
                class33_2.x += l4;
                class33_2.y += i5;
                class33_2.z += j5;
                ++class33_2.magnitude;
                class33_2 = this.normals[i3];
                class33_2.x += l4;
                class33_2.y += i5;
                class33_2.z += j5;
                ++class33_2.magnitude;
                continue;
            }
            if (texture_id != -1) {
                type = 2;
            }
            int light = i + (k * l4 + l * i5 + i1 * j5) / (k1 + k1 / 2);
            this.faceHslA[face] = Model.method481(this.face_color[face], light, type);
        }
        if (flag) {
            this.method480(i, k1, k, l, i1, player);
            this.calc_diagonals();
        } else {
            this.gouraud_vertex = new Vertex[this.vertices];
            for (int point = 0; point < this.vertices; ++point) {
                Vertex class33 = this.normals[point];
                Vertex class33_1 = this.gouraud_vertex[point] = new Vertex();
                class33_1.x = class33.x;
                class33_1.y = class33.y;
                class33_1.z = class33.z;
                class33_1.magnitude = class33.magnitude;
            }
            this.calculateVertexData(21073);
        }
    }

    public final void doShading(int i, int j, int k, int l, int i1) {
        this.method480(i, j, k, l, i1, false);
    }

    public final void method480(int i, int j, int k, int l, int i1, boolean player) {
        for (int j1 = 0; j1 < this.faces; ++j1) {
            int light;
            Vertex vertex;
            int hsl;
            int type;
            int texture_id;
            int k1 = this.triangle_edge_a[j1];
            int i2 = this.triangle_edge_b[j1];
            int j2 = this.triangle_edge_c[j1];
            if (this.face_material == null) {
                texture_id = -1;
            } else {
                texture_id = this.face_material[j1];
                if (player) {
                    if (this.face_alpha != null && this.face_color != null) {
                        if (this.face_color[j1] == 0 && this.face_render_priorities[j1] == 0 && this.render_type != null && this.render_type[j1] == 2 && this.face_material[j1] == -1) {
                            this.face_alpha[j1] = 255;
                        }
                    } else if (this.face_alpha == null && this.face_color[j1] == 0 && this.face_render_priorities[j1] == 0 && this.face_material[j1] == -1) {
                        this.face_alpha = new int[this.faces];
                        if (this.render_type != null && this.render_type[j1] == 2) {
                            this.face_alpha[j1] = 255;
                        }
                    }
                }
            }
            if (this.render_type == null) {
                type = texture_id != -1 ? 2 : 1;
                hsl = this.face_color[j1] & 0xFFFF;
                vertex = this.normals[k1];
                light = i + (k * vertex.x + l * vertex.y + i1 * vertex.z) / (j * vertex.magnitude);
                this.faceHslA[j1] = Model.method481(hsl, light, type);
                vertex = this.normals[i2];
                light = i + (k * vertex.x + l * vertex.y + i1 * vertex.z) / (j * vertex.magnitude);
                this.faceHslB[j1] = Model.method481(hsl, light, type);
                vertex = this.normals[j2];
                light = i + (k * vertex.x + l * vertex.y + i1 * vertex.z) / (j * vertex.magnitude);
                this.faceHslC[j1] = Model.method481(hsl, light, type);
                continue;
            }
            if ((this.render_type[j1] & 1) != 0) continue;
            type = this.render_type[j1];
            if (texture_id != -1) {
                type = 2;
            }
            hsl = this.face_color[j1] & 0xFFFF;
            vertex = this.normals[k1];
            light = i + (k * vertex.x + l * vertex.y + i1 * vertex.z) / (j * vertex.magnitude);
            this.faceHslA[j1] = Model.method481(hsl, light, type);
            vertex = this.normals[i2];
            light = i + (k * vertex.x + l * vertex.y + i1 * vertex.z) / (j * vertex.magnitude);
            this.faceHslB[j1] = Model.method481(hsl, light, type);
            vertex = this.normals[j2];
            light = i + (k * vertex.x + l * vertex.y + i1 * vertex.z) / (j * vertex.magnitude);
            this.faceHslC[j1] = Model.method481(hsl, light, type);
        }
        this.normals = null;
        this.gouraud_vertex = null;
        this.bone_skin = null;
        this.muscle_skin = null;
        this.face_color = null;
    }

    public static final int method481(int i, int j, int k) {
        if (i == 65535) {
            return 0;
        }
        if ((k & 2) == 2) {
            if (j < 0) {
                j = 0;
            } else if (j > 127) {
                j = 127;
            }
            j = 127 - j;
            return j;
        }
        if ((j = j * (i & 0x7F) >> 7) < 2) {
            j = 2;
        } else if (j > 126) {
            j = 126;
        }
        return (i & 0xFF80) + j;
    }

    public final void render_2D(int roll, int yaw, int pitch, int start_x, int start_y, int zoom) {
        int depth = 0;
        int center_x = Rasterizer3D.textureInt1;
        int center_y = Rasterizer3D.textureInt2;
        int depth_sin = SINE[depth];
        int depth_cos = COSINE[depth];
        int roll_sin = SINE[roll];
        int roll_cos = COSINE[roll];
        int yaw_sin = SINE[yaw];
        int yaw_cos = COSINE[yaw];
        int pitch_sin = SINE[pitch];
        int pitch_cos = COSINE[pitch];
        int position = start_y * pitch_sin + zoom * pitch_cos >> 16;
        for (int index = 0; index < this.vertices; ++index) {
            int x = this.vertex_x[index];
            int y = this.vertex_y[index];
            int z = this.vertex_z[index];
            if (yaw != 0) {
                int rotated_x = y * yaw_sin + x * yaw_cos >> 16;
                y = y * yaw_cos - x * yaw_sin >> 16;
                x = rotated_x;
            }
            if (depth != 0) {
                int rotated_y = y * depth_cos - z * depth_sin >> 16;
                z = y * depth_sin + z * depth_cos >> 16;
                y = rotated_y;
            }
            if (roll != 0) {
                int rotated_z = z * roll_sin + x * roll_cos >> 16;
                z = z * roll_cos - x * roll_sin >> 16;
                x = rotated_z;
            }
            int y_offset = (y += start_y) * pitch_cos - (z += zoom) * pitch_sin >> 16;
            z = y * pitch_sin + z * pitch_cos >> 16;
            y = y_offset;
            Model.projected_vertex_z[index] = z - position;
            Model.projected_vertex_x[index] = center_x + ((x += start_x) << 9) / z;
            Model.projected_vertex_y[index] = center_y + (y << 9) / z;
            if (this.texture_faces <= 0) continue;
            Model.camera_vertex_x[index] = x;
            Model.camera_vertex_y[index] = y;
            Model.camera_vertex_z[index] = z;
        }
        try {
            this.method483(false, false, 0L);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
            System.out.println("Could not rotate and project item!");
        }
    }

    @Override
    public final void renderAtPoint(int rotation, int sineYCurve, int cosineYCurve, int sineXCurve, int cosineXCurve, int distanceX, int distanceZ, int distanceY, long uid) {
        int j2 = distanceY * cosineXCurve - distanceX * sineXCurve >> 16;
        int zFar = distanceZ * sineYCurve + j2 * cosineYCurve >> 16;
        int l2 = this.diagonal_2D * cosineYCurve >> 16;
        int zNear = zFar + l2;
        if (zNear <= 50 || zFar >= 6500) {
            return;
        }
        int j3 = distanceY * sineXCurve + distanceX * cosineXCurve >> 16;
        int k3 = j3 - this.diagonal_2D << SceneGraph.view_dist;
        if (k3 / zNear >= Rasterizer2D.centerX) {
            return;
        }
        int l3 = j3 + this.diagonal_2D << SceneGraph.view_dist;
        if (l3 / zNear <= -Rasterizer2D.centerX) {
            return;
        }
        int i4 = distanceZ * cosineYCurve - j2 * sineYCurve >> 16;
        int j4 = this.diagonal_2D * sineYCurve >> 16;
        int k4 = i4 + j4 << SceneGraph.view_dist;
        if (k4 / zNear <= -Rasterizer2D.centerY) {
            return;
        }
        int l4 = j4 + (this.modelHeight * cosineYCurve >> 16);
        int i5 = i4 - l4 << SceneGraph.view_dist;
        if (i5 / zNear >= Rasterizer2D.centerY) {
            return;
        }
        int j5 = l2 + (this.modelHeight * sineYCurve >> 16);
        boolean flag = false;
        if (zFar - j5 <= 50) {
            flag = true;
        }
        boolean flag1 = false;
        if (uid > 0L && obj_exists) {
            int obj_height_offset = zFar - l4;
            if (obj_height_offset <= 50) {
                obj_height_offset = 50;
            }
            if (j3 > 0) {
                k3 /= zNear;
                l3 /= obj_height_offset;
            } else {
                l3 /= zNear;
                k3 /= obj_height_offset;
            }
            if (i4 > 0) {
                i5 /= zNear;
                k4 /= obj_height_offset;
            } else {
                k4 /= zNear;
                i5 /= obj_height_offset;
            }
            int mouse_x = anInt1685 - Rasterizer3D.textureInt1;
            int mouse_y = anInt1686 - Rasterizer3D.textureInt2;
            if (mouse_x > k3 && mouse_x < l3 && mouse_y > i5 && mouse_y < k4) {
                if (this.within_tile) {
                    Model.anIntArray1688[Model.anInt1687++] = uid;
                } else {
                    flag1 = true;
                }
            }
        }
        int center_x = Rasterizer3D.textureInt1;
        int center_y = Rasterizer3D.textureInt2;
        int sine_x = 0;
        int cosine_x = 0;
        if (rotation != 0) {
            sine_x = SINE[rotation];
            cosine_x = COSINE[rotation];
        }
        for (int index = 0; index < this.vertices; ++index) {
            int raster_x = this.vertex_x[index];
            int raster_y = this.vertex_y[index];
            int raster_z = this.vertex_z[index];
            if (rotation != 0) {
                int rotated_x = raster_z * sine_x + raster_x * cosine_x >> 16;
                raster_z = raster_z * cosine_x - raster_x * sine_x >> 16;
                raster_x = rotated_x;
            }
            int position = (raster_z += distanceY) * sineXCurve + (raster_x += distanceX) * cosineXCurve >> 16;
            raster_z = raster_z * cosineXCurve - raster_x * sineXCurve >> 16;
            raster_x = position;
            position = (raster_y += distanceZ) * cosineYCurve - raster_z * sineYCurve >> 16;
            raster_z = raster_y * sineYCurve + raster_z * cosineYCurve >> 16;
            raster_y = position;
            Model.projected_vertex_z[index] = raster_z - zFar;
            if (raster_z >= 50) {
                Model.projected_vertex_x[index] = center_x + (raster_x << SceneGraph.view_dist) / raster_z;
                Model.projected_vertex_y[index] = center_y + (raster_y << SceneGraph.view_dist) / raster_z;
            } else {
                Model.projected_vertex_x[index] = -5000;
                flag = true;
            }
            if (!flag && this.texture_faces <= 0) continue;
            Model.camera_vertex_x[index] = raster_x;
            Model.camera_vertex_y[index] = raster_y;
            Model.camera_vertex_z[index] = raster_z;
        }
        try {
            this.method483(flag, flag1, uid);
            return;
        }
        catch (Exception _ex) {
            return;
        }
    }

    private void method483(boolean flag, boolean flag1, long uid) {
        for (int j = 0; j < this.scene_depth; ++j) {
            Model.depthListIndices[j] = 0;
        }
        for (int face = 0; face < this.faces; ++face) {
            int k5;
            if (this.render_type != null && this.render_type[face] == -1) continue;
            int a = this.triangle_edge_a[face];
            int b = this.triangle_edge_b[face];
            int c = this.triangle_edge_c[face];
            int x_a = projected_vertex_x[a];
            int x_b = projected_vertex_x[b];
            int x_c = projected_vertex_x[c];
            if (flag && (x_a == -5000 || x_b == -5000 || x_c == -5000)) {
                int j5;
                Model.outOfReach[face] = true;
                int n = j5 = (projected_vertex_z[a] + projected_vertex_z[b] + projected_vertex_z[c]) / 3 + this.diagonal_3D;
                int n2 = depthListIndices[n];
                depthListIndices[n] = n2 + 1;
                Model.faceLists[j5][n2] = face;
                continue;
            }
            if (flag1 && this.entered_clickbox(anInt1685, anInt1686, projected_vertex_y[a], projected_vertex_y[b], projected_vertex_y[c], x_a, x_b, x_c)) {
                Model.anIntArray1688[Model.anInt1687++] = uid;
                flag1 = false;
            }
            if ((x_a - x_b) * (projected_vertex_y[c] - projected_vertex_y[b]) - (projected_vertex_y[a] - projected_vertex_y[b]) * (x_c - x_b) <= 0) continue;
            Model.outOfReach[face] = false;
            Model.hasAnEdgeToRestrict[face] = x_a < 0 || x_b < 0 || x_c < 0 || x_a > Rasterizer2D.centerX2 || x_b > Rasterizer2D.centerX2 || x_c > Rasterizer2D.centerX2;
            int n = k5 = (projected_vertex_z[a] + projected_vertex_z[b] + projected_vertex_z[c]) / 3 + this.diagonal_3D;
            int n3 = depthListIndices[n];
            depthListIndices[n] = n3 + 1;
            Model.faceLists[k5][n3] = face;
        }
        if (this.face_render_priorities == null) {
            for (int i1 = this.scene_depth - 1; i1 >= 0; --i1) {
                int l1 = depthListIndices[i1];
                if (l1 <= 0) continue;
                int[] ai = faceLists[i1];
                for (int j3 = 0; j3 < l1; ++j3) {
                    this.rasterize(ai[j3]);
                }
            }
            return;
        }
        for (int j1 = 0; j1 < 12; ++j1) {
            Model.anIntArray1673[j1] = 0;
            Model.anIntArray1677[j1] = 0;
        }
        for (int i2 = this.scene_depth - 1; i2 >= 0; --i2) {
            int k2 = depthListIndices[i2];
            if (k2 <= 0) continue;
            int[] ai1 = faceLists[i2];
            for (int i4 = 0; i4 < k2; ++i4) {
                byte l5;
                int l4 = ai1[i4];
                byte by = l5 = this.face_render_priorities[l4];
                anIntArray1673[by] = anIntArray1673[by] + 1;
                Model.anIntArrayArray1674[l5][j6] = l4;
                if (l5 < 10) {
                    byte by2 = l5;
                    anIntArray1677[by2] = anIntArray1677[by2] + i2;
                    continue;
                }
                if (l5 == 10) {
                    Model.anIntArray1675[j6] = i2;
                    continue;
                }
                Model.anIntArray1676[j6] = i2;
            }
        }
        int l2 = 0;
        if (anIntArray1673[1] > 0 || anIntArray1673[2] > 0) {
            l2 = (anIntArray1677[1] + anIntArray1677[2]) / (anIntArray1673[1] + anIntArray1673[2]);
        }
        int k3 = 0;
        if (anIntArray1673[3] > 0 || anIntArray1673[4] > 0) {
            k3 = (anIntArray1677[3] + anIntArray1677[4]) / (anIntArray1673[3] + anIntArray1673[4]);
        }
        int j4 = 0;
        if (anIntArray1673[6] > 0 || anIntArray1673[8] > 0) {
            j4 = (anIntArray1677[6] + anIntArray1677[8]) / (anIntArray1673[6] + anIntArray1673[8]);
        }
        int i6 = 0;
        int k6 = anIntArray1673[10];
        int[] auid = anIntArrayArray1674[10];
        int[] ai3 = anIntArray1675;
        if (i6 == k6) {
            i6 = 0;
            k6 = anIntArray1673[11];
            auid = anIntArrayArray1674[11];
            ai3 = anIntArray1676;
        }
        int i5 = i6 < k6 ? ai3[i6] : -1000;
        for (int l6 = 0; l6 < 10; ++l6) {
            while (l6 == 0 && i5 > l2) {
                this.rasterize(auid[i6++]);
                if (i6 == k6 && auid != anIntArrayArray1674[11]) {
                    i6 = 0;
                    k6 = anIntArray1673[11];
                    auid = anIntArrayArray1674[11];
                    ai3 = anIntArray1676;
                }
                if (i6 < k6) {
                    i5 = ai3[i6];
                    continue;
                }
                i5 = -1000;
            }
            while (l6 == 3 && i5 > k3) {
                this.rasterize(auid[i6++]);
                if (i6 == k6 && auid != anIntArrayArray1674[11]) {
                    i6 = 0;
                    k6 = anIntArray1673[11];
                    auid = anIntArrayArray1674[11];
                    ai3 = anIntArray1676;
                }
                if (i6 < k6) {
                    i5 = ai3[i6];
                    continue;
                }
                i5 = -1000;
            }
            while (l6 == 5 && i5 > j4) {
                this.rasterize(auid[i6++]);
                if (i6 == k6 && auid != anIntArrayArray1674[11]) {
                    i6 = 0;
                    k6 = anIntArray1673[11];
                    auid = anIntArrayArray1674[11];
                    ai3 = anIntArray1676;
                }
                if (i6 < k6) {
                    i5 = ai3[i6];
                    continue;
                }
                i5 = -1000;
            }
            int i7 = anIntArray1673[l6];
            int[] ai4 = anIntArrayArray1674[l6];
            for (int j7 = 0; j7 < i7; ++j7) {
                this.rasterize(ai4[j7]);
            }
        }
        while (i5 != -1000) {
            this.rasterize(auid[i6++]);
            if (i6 == k6 && auid != anIntArrayArray1674[11]) {
                i6 = 0;
                auid = anIntArrayArray1674[11];
                k6 = anIntArray1673[11];
                ai3 = anIntArray1676;
            }
            if (i6 < k6) {
                i5 = ai3[i6];
                continue;
            }
            i5 = -1000;
        }
    }

    private final void rasterize(int face) {
        if (outOfReach[face]) {
            this.method485(face);
            return;
        }
        int j = this.triangle_edge_a[face];
        int k = this.triangle_edge_b[face];
        int l = this.triangle_edge_c[face];
        Rasterizer3D.testX = hasAnEdgeToRestrict[face];
        Rasterizer3D.alpha = this.face_alpha == null ? 0 : this.face_alpha[face] & 0xFF;
        int type = this.render_type == null ? 0 : this.render_type[face] & 3;
        Rasterizer3D.repeatTexture = !Rasterizer3D.forceRepeat ? (this.repeatTexture == null ? false : this.repeatTexture[face]) : true;
        if (this.face_material != null && this.face_material[face] != -1) {
            int texture_a = j;
            int texture_b = k;
            int texture_c = l;
            if (this.face_texture != null && this.face_texture[face] != -1) {
                int coordinate = this.face_texture[face] & 0xFF;
                texture_a = this.triangle_texture_edge_a[coordinate];
                texture_b = this.triangle_texture_edge_b[coordinate];
                texture_c = this.triangle_texture_edge_c[coordinate];
            }
            if (this.faceHslC[face] == -1 || type == 3) {
                Rasterizer3D.drawTexturedTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], this.faceHslA[face], this.faceHslA[face], this.faceHslA[face], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[face]);
            } else {
                Rasterizer3D.drawTexturedTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], this.faceHslA[face], this.faceHslB[face], this.faceHslC[face], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[face]);
            }
        } else {
            if (type == 0) {
                Rasterizer3D.drawShadedTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], this.faceHslA[face], this.faceHslB[face], this.faceHslC[face]);
                return;
            }
            if (type == 1) {
                Rasterizer3D.drawFlatTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], modelIntArray3[this.faceHslA[face]]);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void method485(int i) {
        int coordinate;
        int j = Rasterizer3D.textureInt1;
        int k = Rasterizer3D.textureInt2;
        int l = 0;
        int i1 = this.triangle_edge_a[i];
        int j1 = this.triangle_edge_b[i];
        int k1 = this.triangle_edge_c[i];
        int l1 = camera_vertex_z[i1];
        int uid = camera_vertex_z[j1];
        int j2 = camera_vertex_z[k1];
        if (l1 >= 50) {
            Model.anIntArray1678[l] = projected_vertex_x[i1];
            Model.anIntArray1679[l] = projected_vertex_y[i1];
            Model.anIntArray1680[l++] = this.faceHslA[i];
        } else {
            int k2 = camera_vertex_x[i1];
            int k3 = camera_vertex_y[i1];
            int k4 = this.faceHslA[i];
            if (j2 >= 50) {
                int k5 = (50 - l1) * modelIntArray4[j2 - l1];
                Model.anIntArray1678[l] = j + (k2 + ((camera_vertex_x[k1] - k2) * k5 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1679[l] = k + (k3 + ((camera_vertex_y[k1] - k3) * k5 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1680[l++] = k4 + ((this.faceHslC[i] - k4) * k5 >> 16);
            }
            if (uid >= 50) {
                int l5 = (50 - l1) * modelIntArray4[uid - l1];
                Model.anIntArray1678[l] = j + (k2 + ((camera_vertex_x[j1] - k2) * l5 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1679[l] = k + (k3 + ((camera_vertex_y[j1] - k3) * l5 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1680[l++] = k4 + ((this.faceHslB[i] - k4) * l5 >> 16);
            }
        }
        if (uid >= 50) {
            Model.anIntArray1678[l] = projected_vertex_x[j1];
            Model.anIntArray1679[l] = projected_vertex_y[j1];
            Model.anIntArray1680[l++] = this.faceHslB[i];
        } else {
            int l2 = camera_vertex_x[j1];
            int l3 = camera_vertex_y[j1];
            int l4 = this.faceHslB[i];
            if (l1 >= 50) {
                int i6 = (50 - uid) * modelIntArray4[l1 - uid];
                Model.anIntArray1678[l] = j + (l2 + ((camera_vertex_x[i1] - l2) * i6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1679[l] = k + (l3 + ((camera_vertex_y[i1] - l3) * i6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1680[l++] = l4 + ((this.faceHslA[i] - l4) * i6 >> 16);
            }
            if (j2 >= 50) {
                int j6 = (50 - uid) * modelIntArray4[j2 - uid];
                Model.anIntArray1678[l] = j + (l2 + ((camera_vertex_x[k1] - l2) * j6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1679[l] = k + (l3 + ((camera_vertex_y[k1] - l3) * j6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1680[l++] = l4 + ((this.faceHslC[i] - l4) * j6 >> 16);
            }
        }
        if (j2 >= 50) {
            Model.anIntArray1678[l] = projected_vertex_x[k1];
            Model.anIntArray1679[l] = projected_vertex_y[k1];
            Model.anIntArray1680[l++] = this.faceHslC[i];
        } else {
            int i3 = camera_vertex_x[k1];
            int i4 = camera_vertex_y[k1];
            int i5 = this.faceHslC[i];
            if (uid >= 50) {
                int k6 = (50 - j2) * modelIntArray4[uid - j2];
                Model.anIntArray1678[l] = j + (i3 + ((camera_vertex_x[j1] - i3) * k6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1679[l] = k + (i4 + ((camera_vertex_y[j1] - i4) * k6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1680[l++] = i5 + ((this.faceHslB[i] - i5) * k6 >> 16);
            }
            if (l1 >= 50) {
                int l6 = (50 - j2) * modelIntArray4[l1 - j2];
                Model.anIntArray1678[l] = j + (i3 + ((camera_vertex_x[i1] - i3) * l6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1679[l] = k + (i4 + ((camera_vertex_y[i1] - i4) * l6 >> 16) << SceneGraph.view_dist) / 50;
                Model.anIntArray1680[l++] = i5 + ((this.faceHslA[i] - i5) * l6 >> 16);
            }
        }
        int j3 = anIntArray1678[0];
        int j4 = anIntArray1678[1];
        int j5 = anIntArray1678[2];
        int i7 = anIntArray1679[0];
        int j7 = anIntArray1679[1];
        int k7 = anIntArray1679[2];
        if ((j3 - j4) * (k7 - j7) - (i7 - j7) * (j5 - j4) <= 0) return;
        Rasterizer3D.testX = false;
        int texture_a = i1;
        int texture_b = j1;
        int texture_c = k1;
        if (l == 3) {
            if (j3 < 0 || j4 < 0 || j5 < 0 || j3 > Rasterizer2D.centerX2 || j4 > Rasterizer2D.centerX2 || j5 > Rasterizer2D.centerX2) {
                Rasterizer3D.testX = true;
            }
            int l7 = this.render_type == null ? 0 : this.render_type[i] & 3;
            if (this.face_material != null && this.face_material[i] != -1) {
                if (this.face_texture != null && this.face_texture[i] != -1) {
                    coordinate = this.face_texture[i] & 0xFF;
                    texture_a = this.triangle_texture_edge_a[coordinate];
                    texture_b = this.triangle_texture_edge_b[coordinate];
                    texture_c = this.triangle_texture_edge_c[coordinate];
                }
                if (this.faceHslC[i] == -1) {
                    Rasterizer3D.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, this.faceHslA[i], this.faceHslA[i], this.faceHslA[i], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[i]);
                } else {
                    Rasterizer3D.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[i]);
                }
            } else if (l7 == 0) {
                Rasterizer3D.drawShadedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2]);
            } else if (l7 == 1) {
                Rasterizer3D.drawFlatTriangle(i7, j7, k7, j3, j4, j5, modelIntArray3[this.faceHslA[i]]);
            }
        }
        if (l != 4) return;
        if (j3 < 0 || j4 < 0 || j5 < 0 || j3 > Rasterizer2D.centerX2 || j4 > Rasterizer2D.centerX2 || j5 > Rasterizer2D.centerX2 || anIntArray1678[3] < 0 || anIntArray1678[3] > Rasterizer2D.centerX2) {
            Rasterizer3D.testX = true;
        }
        int type = this.render_type == null ? 0 : this.render_type[i] & 3;
        if (this.face_material != null && this.face_material[i] != -1) {
            if (this.face_texture != null && this.face_texture[i] != -1) {
                coordinate = this.face_texture[i] & 0xFF;
                texture_a = this.triangle_texture_edge_a[coordinate];
                texture_b = this.triangle_texture_edge_b[coordinate];
                texture_c = this.triangle_texture_edge_c[coordinate];
            }
            if (this.faceHslC[i] == -1) {
                Rasterizer3D.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, this.faceHslA[i], this.faceHslA[i], this.faceHslA[i], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[i]);
                Rasterizer3D.drawTexturedTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], this.faceHslA[i], this.faceHslA[i], this.faceHslA[i], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[i]);
                return;
            }
            Rasterizer3D.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[i]);
            Rasterizer3D.drawTexturedTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], anIntArray1680[0], anIntArray1680[2], anIntArray1680[3], camera_vertex_x[texture_a], camera_vertex_x[texture_b], camera_vertex_x[texture_c], camera_vertex_y[texture_a], camera_vertex_y[texture_b], camera_vertex_y[texture_c], camera_vertex_z[texture_a], camera_vertex_z[texture_b], camera_vertex_z[texture_c], this.face_material[i]);
            return;
        }
        if (type == 0) {
            Rasterizer3D.drawShadedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2]);
            Rasterizer3D.drawShadedTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], anIntArray1680[0], anIntArray1680[2], anIntArray1680[3]);
            return;
        }
        if (type != 1) return;
        int l8 = modelIntArray3[this.faceHslA[i]];
        Rasterizer3D.drawFlatTriangle(i7, j7, k7, j3, j4, j5, l8);
        Rasterizer3D.drawFlatTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], l8);
    }

    private final boolean entered_clickbox(int mouse_x, int mouse_y, int y_a, int y_b, int y_c, int x_a, int x_b, int x_c) {
        if (mouse_y < y_a && mouse_y < y_b && mouse_y < y_c) {
            return false;
        }
        if (mouse_y > y_a && mouse_y > y_b && mouse_y > y_c) {
            return false;
        }
        if (mouse_x < x_a && mouse_x < x_b && mouse_x < x_c) {
            return false;
        }
        return mouse_x <= x_a || mouse_x <= x_b || mouse_x <= x_c;
    }

    public void method2593(int orientation) {
        int min_x = 0;
        int min_y = 0;
        int min_z = 0;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        int cos = COSINE[orientation];
        int sin = SINE[orientation];
        for (int point = 0; point < this.vertices; ++point) {
            int v_x = Rasterizer3D.calc_vertex_x(this.vertex_x[point], this.vertex_z[point], cos, sin);
            int v_y = this.vertex_y[point];
            int v_z = Rasterizer3D.calc_vertex_z(this.vertex_x[point], this.vertex_z[point], cos, sin);
            if (v_x < min_x) {
                min_x = v_x;
            }
            if (v_x > max_x) {
                max_x = v_x;
            }
            if (v_y < min_y) {
                min_y = v_y;
            }
            if (v_y > max_y) {
                max_y = v_y;
            }
            if (v_z < min_z) {
                min_z = v_z;
            }
            if (v_z <= max_z) continue;
            max_z = v_z;
        }
        this.field1944 = (max_x + min_x) / 2;
        this.field1963 = (max_y + min_y) / 2;
        this.field1946 = (max_z + min_z) / 2;
        this.field1947 = (max_x - min_x + 1) / 2;
        this.field1948 = (max_y - min_y + 1) / 2;
        this.field1924 = (max_z - min_z + 1) / 2;
        if (this.field1947 < 32) {
            this.field1947 = 32;
        }
        if (this.field1924 < 32) {
            this.field1924 = 32;
        }
        if (this.within_tile) {
            this.field1947 += 8;
            this.field1924 += 8;
        }
    }

    public int getBufferOffset() {
        return this.bufferOffset;
    }

    public void setBufferOffset(int bufferOffset) {
        this.bufferOffset = bufferOffset;
    }

    public int getUvBufferOffset() {
        return this.uvBufferOffset;
    }

    public void setUvBufferOffset(int uvBufferOffset) {
        this.uvBufferOffset = uvBufferOffset;
    }

    public float[][] getFaceTextureUCoordinates() {
        return new float[0][];
    }

    public float[][] getFaceTextureVCoordinates() {
        return new float[0][];
    }

    public void completelyRecolor(int j) {
        for (int k = 0; k < this.faces; ++k) {
            this.face_color[k] = (short)j;
        }
    }

    public void shadingRecolor(int j) {
        j += 100;
        int kcolor = 0;
        for (int k = 0; k < this.faces; ++k) {
            kcolor = this.face_color[k];
            if (k + j < 0) continue;
            this.face_color[k] = (short)(kcolor + j);
        }
    }

    public void shadingRecolor2(int j) {
        for (int k = 0; k < this.faces; ++k) {
            if (k + j < 0) continue;
            this.face_color[k] = (short)(k + j);
        }
    }

    public void shadingRecolor4(int j) {
        for (int k = 0; k < this.faces; ++k) {
            if (j == 222) {
                System.out.println("k = " + this.face_color[k]);
            }
            if (this.face_color[k] == 65535 || k + j < 0) continue;
            int n = k;
            this.face_color[n] = this.face_color[n] + j;
        }
    }

    public void shadingRecolor3(int j) {
        for (int k = 0; k < this.faces; ++k) {
            int lastcolor = 1;
            if (this.face_color[k] + j >= 10000 && this.face_color[k] + j <= 90000) {
                this.face_color[k] = (short)(k + j + lastcolor);
            }
            ++lastcolor;
        }
    }

    public void modelRecoloring(int i, int j) {
        for (int k = 0; k < this.faces; ++k) {
            if (this.face_color[k] != i) continue;
            this.face_color[k] = (short)j;
        }
    }

    static {
        int[] higherRevModelList;
        int[] array;
        EMPTY_MODEL = new Model(true);
        anIntArray1688 = new long[1000];
        hasAnEdgeToRestrict = new boolean[6500];
        outOfReach = new boolean[6500];
        projected_vertex_x = new int[6500];
        projected_vertex_y = new int[6500];
        projected_vertex_z = new int[6500];
        camera_vertex_x = new int[6500];
        camera_vertex_y = new int[6500];
        camera_vertex_z = new int[6500];
        depthListIndices = new int[1600];
        faceLists = new int[1600][512];
        anIntArray1673 = new int[12];
        anIntArrayArray1674 = new int[12][2000];
        anIntArray1675 = new int[2000];
        anIntArray1676 = new int[2000];
        anIntArray1677 = new int[12];
        anIntArray1678 = new int[10];
        anIntArray1679 = new int[10];
        anIntArray1680 = new int[10];
        anIntArray1622 = new int[6500];
        anIntArray1623 = new int[6500];
        anIntArray1624 = new int[6500];
        anIntArray1625 = new int[6500];
        SINE = Rasterizer3D.SINE;
        COSINE = Rasterizer3D.COSINE;
        modelIntArray3 = Rasterizer3D.HSL_TO_RGB;
        modelIntArray4 = Rasterizer3D.anIntArray1469;
        repeatedTextureModels = new HashSet<Integer>();
        isHigherRevModel = new HashSet<Integer>();
        for (int id : array = new int[]{55553, 55554, 55555, 55556, 55557, 55558, 55559, 55560, 55561, 55562, 55563, 55564, 55565, 55566, 55567, 55568, 55569, 55570, 55571, 55572, 55573, 55574, 55575, 55576, 55577, 55578, 55579, 55580, 55581, 55582, 55583, 55584, 55585, 55586, 55587, 55588, 55589, 55590, 55591, 55592, 55593, 55594, 55595, 55596, 55597, 55598, 55599, 55600, 55601, 55602, 55603, 55604, 55605, 55606, 55608, 55609, 55610, 55611, 55612, 55613, 55614, 55615, 55616, 55617, 55618, 55619, 55620, 55621, 55622, 55623, 55624, 55625, 55626, 55627, 55628, 55629, 55630, 55631, 55643, 55644, 55645, 55646, 55647, 55648, 55649, 55650, 55651, 55652, 55653, 55654, 55655, 55656, 55657, 55658, 55659, 55560, 55661, 55662, 55663, 55664, 55673, 55678, 55679, 55680, 55681, 55682, 55683, 55684, 55685, 55686, 55687, 55688, 55689, 55690, 55691, 55692, 55693, 55694, 55695, 55696, 55697, 55752, 55753, 55754, 55755, 55756, 55757, 55758, 55759, 55760, 55761, 55762, 55763, 55764, 55765, 55766, 55767, 55768, 55769, 55770, 55771, 55772, 55773, 55774, 55775, 55776, 55777, 55778, 55779, 55780, 55781, 55782, 55783, 55784, 55785, 55786, 55787, 55788, 55789, 55790, 55791, 55792, 55793, 55794, 55795, 55796, 55797, 55798, 55799, 55800, 55801, 55802, 55803, 55804, 55805, 55806, 55807, 55808, 55809, 55810, 55811, 55812, 55813, 55814, 55815, 55816, 55817, 55818, 55819, 55820, 55821, 55822, 55823, 55824, 55825, 55826, 55827, 55828, 55829, 55830, 55831, 55832, 55833, 55834, 55835, 55836, 55837, 55838, 55839, 55840, 55841, 55842, 55843, 55844, 55845, 55709, 55710, 55711, 55712, 55713, 55714, 55715, 55716, 55717, 55718, 55719, 55720, 55721, 55722, 55723, 55724, 55725, 55726, 55727, 55728, 55729, 55730, 55731, 55732, 55733, 55734, 55735, 55736, 55737, 55738, 55739, 55740, 55741, 55742, 55854, 55855, 55856, 55857, 55858, 55859, 55860, 55861, 55862, 55863, 55864, 55865, 55866, 55867, 55868, 55869, 55870, 55874, 55875, 55876, 55877, 55878, 55879, 55880, 55881, 55882, 55883, 55884, 55891, 55892, 55893, 55852, 55853, 55698, 55699, 55700, 55701, 55702, 55703, 55704, 55705, 55706, 55707, 55708, 55748, 55749, 55820, 55821, 55822, 55823, 55824, 55825, 55826, 55827, 55894, 55895, 55896, 55897, 55898, 55900, 55901, 55902, 55903, 55904, 55905, 55906, 55907, 55908, 55910, 55911, 55912, 55913, 55914, 55967, 55968, 55969, 55970, 55971, 55972, 55973, 55974, 55975, 55976, 55977, 55978, 55979, 55980, 55981, 55982, 55983, 55984, 55985, 55986, 55987, 55988}) {
            Model.addAll(id);
        }
        for (int id : higherRevModelList = new int[]{54331, 56307, 54204, 56237, 54286, 56294, 54197, 56252, 54367, 56286, 11047, 11309, 61727, 61729, 61731, 61732, 61764, 61812, 48465, 48512, 48513, 57780, 57784, 60831, 59615, 62692, 62750, 70000, 70001, 50778, 50779, 50780, 50782, 50783, 50785, 50788, 50789, 50791, 50792, 50793, 50794, 50797, 50799, 50800, 50802, 50804, 50806, 50809, 50812, 50813, 50815, 50816, 50817, 50818, 50819, 48589, 60776, 62797}) {
            Model.addAllHigherRevModels(id);
        }
    }
}

