/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.io;

import com.ornate.collection.Cacheable;
import com.ornate.net.IsaacCipher;
import java.math.BigInteger;

public final class Buffer
extends Cacheable {
    private static final int[] BIT_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    public static final BigInteger RSA_MODULUS = new BigInteger("131409501542646890473421187351592645202876910715283031445708554322032707707649791604685616593680318619733794036379235220188001221437267862925531863675607742394687835827374685954437825783807190283337943749605737918856262761566146702087468587898515768996741636870321689974105378482179138088453912399137944888201");
    public static final BigInteger RSA_EXPONENT = new BigInteger("65537");
    private IsaacCipher cipher;
    public byte[] payload;
    public int pos;
    public int bitPosition;

    public String readStrings() {
        int i = this.pos;
        while (this.payload[this.pos++] != 10) {
        }
        return new String(this.payload, i, this.pos - i - 1);
    }

    public void skip(int offset) {
        this.pos += offset;
    }

    public void setOffset(int offset) {
        this.pos = offset;
    }

    public Buffer(byte[] payload) {
        this.payload = payload;
        this.pos = 0;
    }

    public static Buffer create(int size, IsaacCipher cipher) {
        Buffer stream_1 = new Buffer(new byte[size]);
        stream_1.payload = new byte[size];
        stream_1.cipher = cipher;
        return stream_1;
    }

    public int readUnsignedIntSmartShortCompat() {
        int var1 = 0;
        int var2 = this.readUSmart();
        while (var2 == Short.MAX_VALUE) {
            var1 += Short.MAX_VALUE;
            var2 = this.readUSmart();
        }
        return var1 += var2;
    }

    public int readUSmart() {
        int peek = this.payload[this.pos] & 0xFF;
        return peek < 128 ? this.readUnsignedByte() : this.readUShort() - 32768;
    }

    public final int readUTriByte() {
        this.pos += 3;
        return (0xFF & this.payload[this.pos - 3] << 16) + (0xFF & this.payload[this.pos - 2] << 8) + (0xFF & this.payload[this.pos - 1]);
    }

    public final int readUTriByte(int i) {
        this.pos += 3;
        return (0xFF & this.payload[this.pos - 3] << 16) + (0xFF & this.payload[this.pos - 2] << 8) + (0xFF & this.payload[this.pos - 1]);
    }

    public int readUSmart2() {
        int baseVal = 0;
        int lastVal = 0;
        while ((lastVal = this.readUSmart()) == Short.MAX_VALUE) {
            baseVal += Short.MAX_VALUE;
        }
        return baseVal + lastVal;
    }

    public String readNewString() {
        int i = this.pos;
        while (this.payload[this.pos++] != 0) {
        }
        return new String(this.payload, i, this.pos - i - 1);
    }

    public void writeOpcode(int i) {
        this.payload[this.pos++] = (byte)(i + this.cipher.value());
    }

    public void writeByte(int value) {
        this.payload[this.pos++] = (byte)value;
    }

    public int writeWordBigEndian(int value) {
        this.payload[this.pos++] = (byte)value;
        return (byte)value;
    }

    public void writeShort(int value) {
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)value;
    }

    public void writeTriByte(int value) {
        this.payload[this.pos++] = (byte)(value >> 16);
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)value;
    }

    public void writeInt(int value) {
        this.payload[this.pos++] = (byte)(value >> 24);
        this.payload[this.pos++] = (byte)(value >> 16);
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)value;
    }

    public void writeLEInt(int value) {
        this.payload[this.pos++] = (byte)value;
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)(value >> 16);
        this.payload[this.pos++] = (byte)(value >> 24);
    }

    public void writeLong(long value) {
        try {
            this.payload[this.pos++] = (byte)(value >> 56);
            this.payload[this.pos++] = (byte)(value >> 48);
            this.payload[this.pos++] = (byte)(value >> 40);
            this.payload[this.pos++] = (byte)(value >> 32);
            this.payload[this.pos++] = (byte)(value >> 24);
            this.payload[this.pos++] = (byte)(value >> 16);
            this.payload[this.pos++] = (byte)(value >> 8);
            this.payload[this.pos++] = (byte)value;
        }
        catch (RuntimeException runtimeexception) {
            System.out.println("14395, 5, " + value + ", " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public void writeString(String text) {
        System.arraycopy(text.getBytes(), 0, this.payload, this.pos, text.length());
        this.pos += text.length();
        this.payload[this.pos++] = 10;
    }

    public void writeBytes(byte[] data, int offset, int length) {
        for (int index = length; index < length + offset; ++index) {
            this.payload[this.pos++] = data[index];
        }
    }

    public void writeBytes(byte[] data) {
        for (byte b : data) {
            this.writeByte(b);
        }
    }

    public void writeByteAtPosition(int value) {
        this.payload[this.pos - value - 1] = (byte)value;
    }

    public int method440() {
        this.pos += 4;
        return ((this.payload[this.pos - 3] & 0xFF) << 24) + ((this.payload[this.pos - 4] & 0xFF) << 16) + ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
    }

    public int readUnsignedByte() {
        return this.payload[this.pos++] & 0xFF;
    }

    public int readShort2() {
        this.pos += 2;
        int i = ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
        if (i > Short.MAX_VALUE) {
            i -= 65537;
        }
        return i;
    }

    public byte readSignedByte() {
        return this.payload[this.pos++];
    }

    public int readUShort() {
        this.pos += 2;
        return ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readSignedShort() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readShort() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
        if (value > 60000) {
            value = -65535 + value;
        }
        return value;
    }

    public int readTriByte() {
        this.pos += 3;
        return ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readInt() {
        this.pos += 4;
        return ((this.payload[this.pos - 4] & 0xFF) << 24) + ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int read24Int() {
        this.pos += 3;
        return ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readMedium() {
        this.pos += 3;
        return ((this.payload[this.pos - 3] & 0xFF) << 16) + (this.payload[this.pos - 1] & 0xFF) + ((this.payload[this.pos - 2] & 0xFF) << 8);
    }

    public long readLong() {
        long msi = (long)this.readInt() & 0xFFFFFFFFL;
        long lsi = (long)this.readInt() & 0xFFFFFFFFL;
        return (msi << 32) + lsi;
    }

    public String readString() {
        int index = this.pos;
        while (this.payload[this.pos++] != 10) {
        }
        return new String(this.payload, index, this.pos - index - 1);
    }

    public byte[] readBytes() {
        int index = this.pos;
        while (this.payload[this.pos++] != 10) {
        }
        byte[] data = new byte[this.pos - index - 1];
        System.arraycopy(this.payload, index, data, index - index, this.pos - 1 - index);
        return data;
    }

    public void readBytes(int offset, int length, byte[] data) {
        for (int index = length; index < length + offset; ++index) {
            data[index] = this.payload[this.pos++];
        }
    }

    public void initBitAccess() {
        this.bitPosition = this.pos * 8;
    }

    public int readBits(int amount) {
        int byteOffset = this.bitPosition >> 3;
        int bitOffset = 8 - (this.bitPosition & 7);
        int value = 0;
        this.bitPosition += amount;
        while (amount > bitOffset) {
            value += (this.payload[byteOffset++] & BIT_MASKS[bitOffset]) << amount - bitOffset;
            amount -= bitOffset;
            bitOffset = 8;
        }
        value = amount == bitOffset ? (value += this.payload[byteOffset] & BIT_MASKS[bitOffset]) : (value += this.payload[byteOffset] >> bitOffset - amount & BIT_MASKS[amount]);
        return value;
    }

    public void disableBitAccess() {
        this.pos = (this.bitPosition + 7) / 8;
    }

    public int readSignedSmart() {
        int value = this.payload[this.pos] & 0xFF;
        if (value < 128) {
            return this.readUnsignedByte() - 64;
        }
        return this.readUShort() - 49152;
    }

    public int getSmart() {
        try {
            if (this.pos >= this.payload.length) {
                return this.payload[this.payload.length - 1] & 0xFF;
            }
            int value = this.payload[this.pos] & 0xFF;
            if (value < 128) {
                return this.readUnsignedByte();
            }
            return this.readUShort() - 32768;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.readUShort() - 32768;
        }
    }

    public void encodeRSA(BigInteger exponent, BigInteger modulus) {
        int length = this.pos;
        this.pos = 0;
        byte[] buffer = new byte[length];
        this.readBytes(length, 0, buffer);
        byte[] rsa = buffer;
        rsa = new BigInteger(buffer).modPow(exponent, modulus).toByteArray();
        this.pos = 0;
        this.writeByte(rsa.length);
        this.writeBytes(rsa, rsa.length, 0);
    }

    public void writeNegatedByte(int value) {
        this.payload[this.pos++] = (byte)(-value);
    }

    public void writeByteS(int value) {
        this.payload[this.pos++] = (byte)(128 - value);
    }

    public int readUByteA() {
        return this.payload[this.pos++] - 128 & 0xFF;
    }

    public int readNegUByte() {
        return -this.payload[this.pos++] & 0xFF;
    }

    public int readUByte() {
        return this.payload[this.pos++] & 0xFF;
    }

    public int readUByteS() {
        return 128 - this.payload[this.pos++] & 0xFF;
    }

    public byte readNegByte() {
        return -this.payload[this.pos++];
    }

    public byte readByteS() {
        return (byte)(128 - this.payload[this.pos++]);
    }

    public void writeLEShort(int value) {
        this.payload[this.pos++] = (byte)value;
        this.payload[this.pos++] = (byte)(value >> 8);
    }

    public void writeShortA(int value) {
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)(value + 128);
    }

    public void writeLEShortA(int value) {
        this.payload[this.pos++] = (byte)(value + 128);
        this.payload[this.pos++] = (byte)(value >> 8);
    }

    public int readLEUShort() {
        this.pos += 2;
        return ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
    }

    public int readUShortA() {
        this.pos += 2;
        return ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] - 128 & 0xFF);
    }

    public int readLEUShortA() {
        this.pos += 2;
        return ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] - 128 & 0xFF);
    }

    public int readLEShort() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readLEShortA() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] - 128 & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readIntLittleEndian() {
        this.pos += 4;
        return ((this.payload[this.pos - 4] & 0xFF) << 24) + ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readMEInt() {
        this.pos += 4;
        return ((this.payload[this.pos - 2] & 0xFF) << 24) + ((this.payload[this.pos - 1] & 0xFF) << 16) + ((this.payload[this.pos - 4] & 0xFF) << 8) + (this.payload[this.pos - 3] & 0xFF);
    }

    public int readIMEInt() {
        this.pos += 4;
        return ((this.payload[this.pos - 3] & 0xFF) << 24) + ((this.payload[this.pos - 4] & 0xFF) << 16) + ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
    }

    public void writeReverseDataA(byte[] data, int length, int offset) {
        for (int index = length + offset - 1; index >= length; --index) {
            this.payload[this.pos++] = (byte)(data[index] + 128);
        }
    }

    public void readReverseData(byte[] data, int offset, int length) {
        for (int index = length + offset - 1; index >= length; --index) {
            data[index] = this.payload[this.pos++];
        }
    }

    public void getBytes(int len, int off, byte[] dest) {
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.payload[this.pos++];
        }
    }

    public void resetPosition() {
        this.pos = 0;
    }

    public void encryptRSAContent() {
        int cachedPosition = this.pos;
        this.pos = 0;
        byte[] decodeBuffer = new byte[cachedPosition];
        this.getBytes(cachedPosition, 0, decodeBuffer);
        BigInteger decodedBigInteger = new BigInteger(decodeBuffer);
        BigInteger encodedBigInteger = decodedBigInteger.modPow(RSA_EXPONENT, RSA_MODULUS);
        byte[] encodedBuffer = encodedBigInteger.toByteArray();
        this.pos = 0;
        this.writeByte(encodedBuffer.length);
        this.writeBytes(encodedBuffer, encodedBuffer.length, 0);
    }
}

