/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.io;

public class PacketBuilder {
    private final int opcode;
    private final int size;
    private int position;
    private byte[] buffer;

    public PacketBuilder(int opcode, int size) {
        this.opcode = opcode;
        this.size = size;
        this.position = 0;
        this.buffer = new byte[2000];
    }

    public PacketBuilder putByte(int i) {
        this.buffer[this.position++] = (byte)i;
        return this;
    }

    public void putBytes(int i) {
        this.buffer[this.position - i - 1] = (byte)i;
    }

    public PacketBuilder putSignedByteMin(int j) {
        this.buffer[this.position++] = (byte)(128 - j);
        return this;
    }

    public PacketBuilder writeReverseDataA(int i, byte[] abyte0, int j) {
        for (int k = i + j - 1; k >= i; --k) {
            this.buffer[this.position++] = (byte)(abyte0[k] + 128);
        }
        return this;
    }

    public PacketBuilder putLong(long value) {
        try {
            this.buffer[this.position++] = (byte)(value >> 56);
            this.buffer[this.position++] = (byte)(value >> 48);
            this.buffer[this.position++] = (byte)(value >> 40);
            this.buffer[this.position++] = (byte)(value >> 32);
            this.buffer[this.position++] = (byte)(value >> 24);
            this.buffer[this.position++] = (byte)(value >> 16);
            this.buffer[this.position++] = (byte)(value >> 8);
            this.buffer[this.position++] = (byte)value;
        }
        catch (RuntimeException runtimeexception) {
            throw new RuntimeException();
        }
        return this;
    }

    public PacketBuilder putShort(int value) {
        this.buffer[this.position++] = (byte)(value >> 8);
        this.buffer[this.position++] = (byte)value;
        return this;
    }

    public PacketBuilder putString(String s) {
        System.arraycopy(s.getBytes(), 0, this.buffer, this.position, s.length());
        this.position += s.length();
        this.buffer[this.position++] = 10;
        return this;
    }

    public PacketBuilder putVariableSizeByte(int size) {
        this.buffer[this.position - size - 1] = (byte)size;
        return this;
    }

    public PacketBuilder putBytes(byte[] tmp, int len, int off) {
        for (int i = off; i < off + len; ++i) {
            this.buffer[this.position++] = tmp[i];
        }
        return this;
    }

    public PacketBuilder putDWordBigEndian(int value) {
        this.buffer[this.position++] = (byte)(value >> 16);
        this.buffer[this.position++] = (byte)(value >> 8);
        this.buffer[this.position++] = (byte)value;
        return this;
    }

    public PacketBuilder putInt(int i) {
        this.buffer[this.position++] = (byte)(i >> 24);
        this.buffer[this.position++] = (byte)(i >> 16);
        this.buffer[this.position++] = (byte)(i >> 8);
        this.buffer[this.position++] = (byte)i;
        return this;
    }

    public PacketBuilder putUnsignedWordBigEndian(int i) {
        this.buffer[this.position++] = (byte)i;
        this.buffer[this.position++] = (byte)(i >> 8);
        return this;
    }

    public PacketBuilder putUnsignedWordA(int j) {
        this.buffer[this.position++] = (byte)(j >> 8);
        this.buffer[this.position++] = (byte)(j + 128);
        return this;
    }

    public PacketBuilder putSignedBigEndian(int j) {
        this.buffer[this.position++] = (byte)(j + 128);
        this.buffer[this.position++] = (byte)(j >> 8);
        return this;
    }

    public PacketBuilder putByteC(int i) {
        this.buffer[this.position++] = (byte)(-i);
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int size() {
        return this.size;
    }
}

