/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.io;

import com.ornate.Client;
import com.ornate.io.Buffer;
import com.ornate.net.IsaacCipher;
import com.ornate.util.ChatMessageCodec;

public class PacketSender {
    private final Buffer buffer;

    public PacketSender(IsaacCipher cipher) {
        this.buffer = Buffer.create(40000, cipher);
    }

    public void sendEmptyPacket() {
        this.buffer.writeOpcode(0);
    }

    public void writeOptionMenuPacket(int childId, int identifier, int optionType) {
        this.buffer.writeOpcode(172);
        this.buffer.writeInt(childId);
        this.buffer.writeByte(identifier);
        this.buffer.writeByte(optionType);
    }

    public void sendTestPacket(long test) {
        this.buffer.writeOpcode(255);
        this.buffer.writeLong(test);
    }

    public void sendFriendAddition(String friend) {
        this.buffer.writeOpcode(188);
        this.buffer.writeByte(friend.length() + 1);
        this.buffer.writeString(friend);
    }

    public void sendFriendDeletion(String friendDisplay) {
        this.buffer.writeOpcode(215);
        this.buffer.writeByte(friendDisplay.length() + 1);
        this.buffer.writeString(friendDisplay);
    }

    public void sendIgnoreAddition(String ignore) {
        this.buffer.writeOpcode(133);
        this.buffer.writeByte(ignore.length() + 1);
        this.buffer.writeString(ignore);
    }

    public void sendIgnoreDeletion(String ignore) {
        this.buffer.writeOpcode(74);
        this.buffer.writeByte(ignore.length() + 1);
        this.buffer.writeString(ignore);
    }

    public void sendPrivateMessage(String player, String message) {
        this.buffer.writeOpcode(126);
        this.buffer.writeByte(0);
        int savedPosition = this.buffer.pos;
        this.buffer.writeString(player);
        ChatMessageCodec.encode(message, this.buffer);
        this.buffer.writeByteAtPosition(this.buffer.pos - savedPosition);
    }

    public void sendClanChatMessage(String message) {
        this.buffer.writeOpcode(104);
        this.buffer.writeByte(message.length() + 1);
        this.buffer.writeString(message);
    }

    public void sendChatMessage(int colour, int effect, String message) {
        this.buffer.writeOpcode(4);
        this.buffer.writeByte(0);
        int savedPosition = this.buffer.pos;
        this.buffer.writeByteS(colour);
        this.buffer.writeByteS(effect);
        Client.singleton.chatBuffer.pos = 0;
        ChatMessageCodec.encode(message, Client.singleton.chatBuffer);
        this.buffer.writeReverseDataA(Client.singleton.chatBuffer.payload, 0, Client.singleton.chatBuffer.pos);
        this.buffer.writeByteAtPosition(this.buffer.pos - savedPosition);
    }

    public void sendAttackNPC(int npcIndex) {
        this.buffer.writeOpcode(72);
        this.buffer.writeShortA(npcIndex);
    }

    public void sendAttackPlayer(int playerIndex) {
        this.buffer.writeOpcode(153);
        this.buffer.writeLEShort(playerIndex);
    }

    public void sendChatboxDuel(int playerIndex) {
        this.buffer.writeOpcode(128);
        this.buffer.writeShort(playerIndex);
    }

    public void sendChatboxTrade(int playerIndex) {
        this.buffer.writeOpcode(139);
        this.buffer.writeLEShort(playerIndex);
    }

    public void sendMinimapFlagClear() {
        this.buffer.writeOpcode(78);
    }

    public void sendButtonClick(int buttonId) {
        this.buffer.writeOpcode(185);
        this.buffer.writeInt(buttonId);
    }

    public void sendButtonAction(int buttonId, int actionIndex) {
        this.buffer.writeOpcode(186);
        this.buffer.writeInt(buttonId);
        this.buffer.writeByte(actionIndex);
    }

    public void sendTeleportSelection(int teleportType, int teleportIndex) {
        this.buffer.writeOpcode(183);
        this.buffer.writeByte(teleportType);
        this.buffer.writeByte(teleportIndex);
    }

    public void sendClientFocus(boolean focused) {
        this.buffer.writeOpcode(3);
        this.buffer.writeByte(focused ? 1 : 0);
    }

    public void sendInterfaceClear() {
        this.buffer.writeOpcode(130);
    }

    public void sendCommand(String command) {
        this.buffer.writeOpcode(103);
        this.buffer.writeByte(command.length() + 1);
        this.buffer.writeString(command);
    }

    public void sendCreationMenuAction(int itemId, int amount) {
        this.buffer.writeOpcode(166);
        this.buffer.writeInt(itemId);
        this.buffer.writeByte(amount);
    }

    public void sendDropItem(int itemId, int interfaceId, int slot) {
        this.buffer.writeOpcode(87);
        this.buffer.writeShortA(itemId);
        this.buffer.writeShort(interfaceId);
        this.buffer.writeShortA(slot);
    }

    public void sendEnteredSyntax(String syntax) {
        if (syntax.length() > 96) {
            syntax = syntax.substring(0, 95);
        }
        this.buffer.writeOpcode(60);
        this.buffer.writeByte(syntax.length() + 1);
        this.buffer.writeString(syntax);
    }

    public void sendEnteredAmount(long amount, int inputDialogStateId) {
        this.buffer.writeOpcode(208);
        this.buffer.writeLong(amount);
        this.buffer.writeByte(inputDialogStateId);
    }

    public void sendEquipItem(int itemId, int slot, int interfaceId) {
        this.buffer.writeOpcode(41);
        this.buffer.writeShort(itemId);
        this.buffer.writeShortA(slot);
        this.buffer.writeShortA(interfaceId);
    }

    public void sendExamineItem(int itemId, int interfaceId) {
        this.buffer.writeOpcode(2);
        this.buffer.writeShort(itemId);
        this.buffer.writeInt(interfaceId);
    }

    public void sendExamineNPC(int npcId) {
        this.buffer.writeOpcode(6);
        this.buffer.writeShort(npcId);
    }

    public void sendRegionChange() {
        this.buffer.writeOpcode(210);
        this.buffer.writeInt(1057001181);
    }

    public void sendFinalizedRegionChange() {
        this.buffer.writeOpcode(121);
    }

    public void sendFollowPlayer(int playerIndex) {
        this.buffer.writeOpcode(73);
        this.buffer.writeLEShort(playerIndex);
    }

    public void sendTradePlayer(int playerIndex) {
        this.buffer.writeOpcode(139);
        this.buffer.writeLEShort(playerIndex);
    }

    public void sendItemContainerOption1(int interfaceId, int slot, int itemId) {
        this.buffer.writeOpcode(145);
        this.buffer.writeInt(interfaceId);
        this.buffer.writeShortA(slot);
        this.buffer.writeShortA(itemId);
    }

    public void sendItemContainerOption2(int interfaceId, int itemId, int slot) {
        this.buffer.writeOpcode(117);
        this.buffer.writeInt(interfaceId);
        this.buffer.writeLEShortA(itemId);
        this.buffer.writeLEShort(slot);
    }

    public void sendItemContainerOption3(int interfaceId, int itemId, int slot) {
        this.buffer.writeOpcode(43);
        this.buffer.writeInt(interfaceId);
        this.buffer.writeShortA(itemId);
        this.buffer.writeShortA(slot);
    }

    public void sendItemContainerOption4(int slot, int interfaceId, int itemId) {
        this.buffer.writeOpcode(129);
        this.buffer.writeShortA(slot);
        this.buffer.writeInt(interfaceId);
        this.buffer.writeShortA(itemId);
    }

    public void sendItemContainerOption5(int interfaceId, int slot, int itemId) {
        this.buffer.writeOpcode(135);
        this.buffer.writeInt(interfaceId);
        this.buffer.writeLEShort(slot);
        this.buffer.writeLEShort(itemId);
    }

    public void sendItemContainerSlotSwap(int interfaceId, int dummy, int fromSlot, int toSlot) {
        this.buffer.writeOpcode(214);
        this.buffer.writeInt(interfaceId);
        this.buffer.writeNegatedByte(dummy);
        this.buffer.writeLEShortA(fromSlot);
        this.buffer.writeLEShort(toSlot);
    }

    public void sendUseItemOnGroundItem(int interfaceId, int itemId, int groundItemId, int y, int dummy, int x) {
        this.buffer.writeOpcode(25);
        this.buffer.writeLEShort(interfaceId);
        this.buffer.writeShortA(itemId);
        this.buffer.writeShort(groundItemId);
        this.buffer.writeShortA(y);
        this.buffer.writeLEShortA(dummy);
        this.buffer.writeShort(x);
    }

    public void sendUseItemOnItem(int slot, int anInt1283, int itemId, int anInt1284, int anInt1285, int interfaceId) {
        this.buffer.writeOpcode(53);
        this.buffer.writeShort(slot);
        this.buffer.writeShortA(anInt1283);
        this.buffer.writeLEShortA(itemId);
        this.buffer.writeShort(anInt1284);
        this.buffer.writeLEShort(anInt1285);
        this.buffer.writeShort(interfaceId);
    }

    public void sendUseItemOnNPC(int npcId, int npcIndex, int itemSlot, int anInt1284) {
        this.buffer.writeOpcode(57);
        this.buffer.writeShortA(npcId);
        this.buffer.writeShortA(npcIndex);
        this.buffer.writeLEShort(itemSlot);
        this.buffer.writeShortA(anInt1284);
    }

    public void sendUseItemOnObject(int interfaceId, int objectId, int objectY, int itemSlot, int objectX, int itemId) {
        this.buffer.writeOpcode(192);
        this.buffer.writeShort(interfaceId);
        this.buffer.writeShort(objectId);
        this.buffer.writeLEShortA(objectY);
        this.buffer.writeLEShort(itemSlot);
        this.buffer.writeLEShortA(objectX);
        this.buffer.writeShort(itemId);
    }

    public void sendUseItemOnPlayer(int interfaceId, int playerIndex, int itemId, int itemSlot) {
        this.buffer.writeOpcode(14);
        this.buffer.writeShortA(interfaceId);
        this.buffer.writeShort(playerIndex);
        this.buffer.writeShort(itemId);
        this.buffer.writeLEShort(itemSlot);
    }

    public void sendUseMagicOnGroundItem(int groundItemX, int groundItemId, int groundItemY, int spellId) {
        this.buffer.writeOpcode(181);
        this.buffer.writeLEShort(groundItemX);
        this.buffer.writeShort(groundItemId);
        this.buffer.writeLEShort(groundItemY);
        this.buffer.writeShortA(spellId);
    }

    public void sendUseMagicOnItem(int itemSlot, int itemId, int interfaceId, int spellId) {
        this.buffer.writeOpcode(237);
        this.buffer.writeShort(itemSlot);
        this.buffer.writeShortA(itemId);
        this.buffer.writeShort(interfaceId);
        this.buffer.writeShortA(spellId);
    }

    public void sendUseMagicOnNPC(int npcIndex, int spellId) {
        this.buffer.writeOpcode(131);
        this.buffer.writeLEShortA(npcIndex);
        this.buffer.writeShortA(spellId);
    }

    public void sendUseMagicOnPlayer(int playerIndex, int selectedSpellId) {
        this.buffer.writeOpcode(249);
        this.buffer.writeShortA(playerIndex);
        this.buffer.writeLEShort(selectedSpellId);
    }

    public void sendItemOption1(int interfaceId, int slot, int itemId) {
        this.buffer.writeOpcode(122);
        this.buffer.writeShort(interfaceId);
        this.buffer.writeShort(slot);
        this.buffer.writeShort(itemId);
    }

    public void sendItemOption2(int interfaceId, int slot, int itemId) {
        this.buffer.writeOpcode(75);
        this.buffer.writeLEShortA(interfaceId);
        this.buffer.writeLEShort(slot);
        this.buffer.writeShortA(itemId);
    }

    public void sendItemOption3(int itemId, int slot, int interfaceId) {
        this.buffer.writeOpcode(16);
        this.buffer.writeShortA(itemId);
        this.buffer.writeLEShortA(slot);
        this.buffer.writeLEShortA(interfaceId);
    }

    public void sendNextDialogue(int interfaceId) {
        this.buffer.writeOpcode(40);
        this.buffer.writeShort(interfaceId);
    }

    public void sendNPCOption1(int npcIndex) {
        this.buffer.writeOpcode(155);
        this.buffer.writeLEShort(npcIndex);
    }

    public void sendNPCOption2(int npcIndex) {
        this.buffer.writeOpcode(17);
        this.buffer.writeLEShortA(npcIndex);
    }

    public void sendNPCOption3(int npcIndex) {
        this.buffer.writeOpcode(21);
        this.buffer.writeShort(npcIndex);
    }

    public void sendNPCOption4(int npcIndex) {
        this.buffer.writeOpcode(18);
        this.buffer.writeLEShort(npcIndex);
    }

    public void sendObjectOption1(int x, int id, int y) {
        this.buffer.writeOpcode(132);
        this.buffer.writeLEShortA(x);
        this.buffer.writeInt(id);
        this.buffer.writeShortA(y);
    }

    public void sendObjectOption2(int id, int y, int x) {
        this.buffer.writeOpcode(252);
        this.buffer.writeLEShortA(x);
        this.buffer.writeInt(id);
        this.buffer.writeShortA(y);
    }

    public void sendObjectOption3(int x, int y, int id) {
        this.buffer.writeOpcode(70);
        this.buffer.writeLEShort(x);
        this.buffer.writeShort(y);
        this.buffer.writeInt(id);
    }

    public void sendObjectOption4(int x, int id, int y) {
        this.buffer.writeOpcode(228);
        this.buffer.writeLEShortA(x);
        this.buffer.writeInt(id);
        this.buffer.writeLEShortA(y);
    }

    public void sendPlayerOption1(int playerIndex) {
        this.buffer.writeOpcode(128);
        this.buffer.writeShort(playerIndex);
    }

    public void sendPlayerInactive() {
        this.buffer.writeOpcode(202);
    }

    public void sendPickupItem(int y, int itemId, int x) {
        this.buffer.writeOpcode(236);
        this.buffer.writeLEShort(y);
        this.buffer.writeShort(itemId);
        this.buffer.writeLEShort(x);
    }

    public void sendGroundItemOption1(int val1, int nodeId, int val2) {
        this.buffer.writeOpcode(235);
        this.buffer.writeLEShort(val1);
        this.buffer.writeShort(nodeId);
        this.buffer.writeLEShort(val2);
    }

    public void sendGambleRequest(int playerIndex) {
        this.buffer.writeOpcode(127);
        this.buffer.writeShort(playerIndex);
    }

    public void sendString(int identifier, String text) {
        text = identifier + "," + (String)text;
        this.buffer.writeOpcode(134);
        this.buffer.writeByte(((String)text).length() + 1);
        this.buffer.writeString((String)text);
    }

    public void clan(int button, int identifier) {
        this.buffer.writeOpcode(216);
        this.buffer.writeInt(button);
        this.buffer.writeInt(identifier);
    }

    public void sendGroupInvite(int playerIndex) {
        this.buffer.writeOpcode(125);
        this.buffer.writeShort(playerIndex);
    }

    public void sendSpecialAttackToggle(int interfaceId) {
        this.buffer.writeOpcode(184);
        this.buffer.writeInt(interfaceId);
    }

    public void sendAppearanceChange(boolean isMale, int[] appearance, int[] colours) {
        this.buffer.writeOpcode(101);
        this.buffer.writeByte(isMale ? 0 : 1);
        for (int i1 = 0; i1 < 7; ++i1) {
            this.buffer.writeByte(appearance[i1]);
        }
        for (int l1 = 0; l1 < 5; ++l1) {
            this.buffer.writeByte(colours[l1]);
        }
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void sendChatConfigurations(int publicChatMode, int privateChatMode, int tradeMode, int clanChatMode) {
        this.buffer.writeOpcode(95);
        this.buffer.writeByte(publicChatMode);
        this.buffer.writeByte(privateChatMode);
        this.buffer.writeByte(tradeMode);
        this.buffer.writeByte(clanChatMode);
    }

    public void sendWidgetChange(int slot) {
        this.buffer.writeOpcode(177);
        this.buffer.writeByte(slot);
    }

    public void sendConfirm(int state, int value) {
        this.buffer.writeOpcode(213);
        this.buffer.writeByte(state);
        this.buffer.writeInt(value);
    }

    public void sendKeyboardAction(int action) {
        this.buffer.writeOpcode(201);
        this.buffer.writeByte(action);
    }

    public void withdrawAllButOneAction(int slot, int interfaceId, int itemid) {
        this.buffer.writeOpcode(140);
        this.buffer.writeShortA(slot);
        this.buffer.writeShort(interfaceId);
        this.buffer.writeShortA(itemid);
    }

    public void withdrawModifiableX(int slot, int interfaceId, int itemId, int amount) {
        this.buffer.writeOpcode(141);
        this.buffer.writeShortA(slot);
        this.buffer.writeShort(interfaceId);
        this.buffer.writeShortA(itemId);
        this.buffer.writeInt(amount);
    }

    public void inputField(int textLength, int component, String text) {
        this.buffer.writeOpcode(142);
        this.buffer.writeByte(textLength);
        this.buffer.writeInt(component);
        this.buffer.writeString(text);
    }
}

