/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.io.jaggrab;

import com.ornate.Client;
import com.ornate.io.Buffer;
import com.ornate.io.jaggrab.JagGrabConstants;
import com.ornate.sign.SignLink;
import com.ornate.util.FileUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.CRC32;

public class JagGrab
extends JagGrabConstants {
    public static final int TITLE_CRC = 1;
    public static final int CONFIG_CRC = 2;
    public static final int INTERFACE_CRC = 3;
    public static final int MEDIA_CRC = 4;
    public static final int UPDATE_CRC = 5;
    public static final int TEXTURES_CRC = 6;
    public static final int CHAT_CRC = 7;
    public static final int SOUNDS_CRC = 8;
    public static final int TOTAL_ARCHIVE_CRCS = 9;
    public static final int[] CRCs = new int[9 + PRELOAD_FILES.length];
    public static CRC32 CRC = new CRC32();
    private static int failedAttempts;
    private static int delay;
    public static Socket socket;

    public static void onStart() {
        JagGrab.requestCrcs();
        for (int i = 0; i < PRELOAD_FILES.length; ++i) {
            JagGrab.requestPreload(i, PRELOAD_FILES[i]);
        }
    }

    public static void requestCrcs() {
        while (!JagGrab.crcsLoaded() && !Client.singleton.exitRequested) {
            try (DataInputStream in = JagGrab.openJagGrabRequest("crc");){
                Client.singleton.draw_loadup(20, "Requesting CRCs..");
                Buffer buffer = new Buffer(JagGrab.getBuffer(in));
                for (int index = 0; index < CRCs.length; ++index) {
                    JagGrab.CRCs[index] = buffer.readInt();
                }
                int expected = buffer.readInt();
                int calculated = 1234;
                for (int index = 0; index < CRCs.length; ++index) {
                    calculated = (calculated << 1) + CRCs[index];
                }
                if (expected != calculated) {
                    JagGrab.resetCrcs();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JagGrab.resetCrcs();
            }
            if (JagGrab.crcsLoaded()) continue;
            JagGrab.error("CRC");
        }
    }

    private static void requestPreload(int i, String fileName) {
        boolean exists = false;
        byte[] buffer = null;
        File file = new File(SignLink.findCacheDir() + fileName);
        if (file.exists() && !file.isDirectory()) {
            exists = true;
            buffer = FileUtils.readFile(SignLink.findCacheDir() + fileName);
        }
        if (buffer != null && !JagGrab.compareCrc(buffer, CRCs[9 + i])) {
            buffer = null;
        }
        if (buffer != null) {
            return;
        }
        while (buffer == null && !Client.singleton.exitRequested) {
            Client.singleton.draw_loadup(20, "Requesting " + fileName);
            try (DataInputStream in = JagGrab.openJagGrabRequest("preload/" + fileName);){
                buffer = JagGrab.getBuffer(in);
                if (buffer != null && !JagGrab.compareCrc(buffer, CRCs[9 + i])) {
                    buffer = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (buffer != null) continue;
            JagGrab.error("Preload");
        }
        if (buffer != null && !exists) {
            try {
                FileUtils.writeFile(buffer, file.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void error(String error) {
        ++failedAttempts;
        for (int remaining = delay; remaining > 0; --remaining) {
            if (failedAttempts >= 10) {
                Client.singleton.draw_loadup(10, "Game updated - please reload page");
                remaining = 10;
            } else {
                Client.singleton.draw_loadup(10, error + " Error - Retrying in " + remaining + " seconds.");
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((delay *= 2) > 60) {
            delay = 60;
        }
        failedAttempts = 0;
        delay = 2;
    }

    public static byte[] getBuffer(DataInputStream in) throws IOException {
        int size = in.readInt();
        if (size <= 0) {
            return null;
        }
        byte[] data = new byte[size];
        in.readFully(data, 0, size);
        return data;
    }

    public static DataInputStream openJagGrabRequest(String filePath) throws IOException {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            socket = null;
        }
        socket = Client.singleton.openSocket(43598);
        socket.setSoTimeout(10000);
        InputStream inputstream = socket.getInputStream();
        OutputStream outputstream = socket.getOutputStream();
        byte[] filePathB = filePath.getBytes();
        byte[] payload = new byte[1 + filePathB.length];
        payload[0] = 1;
        for (int i = 0; i < filePathB.length; ++i) {
            payload[i + 1] = filePathB[i];
        }
        outputstream.write(payload);
        return new DataInputStream(inputstream);
    }

    public static boolean compareCrc(byte[] buffer, int expectedCrc) {
        CRC.reset();
        CRC.update(buffer);
        int crc = (int)CRC.getValue();
        return crc == expectedCrc;
    }

    private static boolean crcsLoaded() {
        for (int i = 0; i < CRCs.length; ++i) {
            if (CRCs[i] != -1) continue;
            return false;
        }
        return true;
    }

    private static void resetCrcs() {
        for (int i = 0; i < CRCs.length; ++i) {
            JagGrab.CRCs[i] = -1;
        }
    }

    static {
        delay = 5;
        JagGrab.resetCrcs();
    }
}

