/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.net;

public final class IsaacCipher {
    private int count;
    private final int[] results;
    private final int[] memory = new int[256];
    private int accumulator;
    private int prev;
    private int counter;

    public IsaacCipher(int[] seed) {
        this.results = new int[256];
        System.arraycopy(seed, 0, this.results, 0, seed.length);
        this.init();
    }

    public int value() {
        if (this.count-- == 0) {
            this.isaac();
            this.count = 255;
        }
        return this.results[this.count];
    }

    private void isaac() {
        this.prev += ++this.counter;
        for (int size = 0; size < 256; ++size) {
            int k;
            int pos = this.memory[size];
            if ((size & 3) == 0) {
                this.accumulator ^= this.accumulator << 13;
            } else if ((size & 3) == 1) {
                this.accumulator ^= this.accumulator >>> 6;
            } else if ((size & 3) == 2) {
                this.accumulator ^= this.accumulator << 2;
            } else if ((size & 3) == 3) {
                this.accumulator ^= this.accumulator >>> 16;
            }
            this.accumulator += this.memory[size + 128 & 0xFF];
            this.memory[size] = k = this.memory[(pos & 0x3FC) >> 2] + this.accumulator + this.prev;
            this.results[size] = this.prev = this.memory[(k >> 8 & 0x3FC) >> 2] + pos;
        }
    }

    private void init() {
        int pos;
        int g = -1640531527;
        int f = -1640531527;
        int e = -1640531527;
        int d = -1640531527;
        int c = -1640531527;
        int b = -1640531527;
        int a = -1640531527;
        int h = -1640531527;
        for (pos = 0; pos < 4; ++pos) {
            c += (h ^= a << 11);
            a += b;
            d += (a ^= b >>> 2);
            b += c;
            e += (b ^= c << 8);
            c += d;
            f += (c ^= d >>> 16);
            d += e;
            g += (d ^= e << 10);
            e += f;
            h += (e ^= f >>> 4);
            f += g;
            a += (f ^= g << 8);
            g += h;
            b += (g ^= h >>> 9);
            h += a;
        }
        for (pos = 0; pos < 256; pos += 8) {
            h += this.results[pos];
            a += this.results[pos + 1];
            b += this.results[pos + 2];
            c += this.results[pos + 3];
            d += this.results[pos + 4];
            e += this.results[pos + 5];
            f += this.results[pos + 6];
            g += this.results[pos + 7];
            c += (h ^= a << 11);
            a += b;
            d += (a ^= b >>> 2);
            b += c;
            e += (b ^= c << 8);
            c += d;
            f += (c ^= d >>> 16);
            d += e;
            g += (d ^= e << 10);
            e += f;
            h += (e ^= f >>> 4);
            f += g;
            a += (f ^= g << 8);
            g += h;
            b += (g ^= h >>> 9);
            this.memory[pos] = h += a;
            this.memory[pos + 1] = a;
            this.memory[pos + 2] = b;
            this.memory[pos + 3] = c;
            this.memory[pos + 4] = d;
            this.memory[pos + 5] = e;
            this.memory[pos + 6] = f;
            this.memory[pos + 7] = g;
        }
        for (int size = 0; size < 256; size += 8) {
            h += this.memory[size];
            a += this.memory[size + 1];
            b += this.memory[size + 2];
            c += this.memory[size + 3];
            d += this.memory[size + 4];
            e += this.memory[size + 5];
            f += this.memory[size + 6];
            g += this.memory[size + 7];
            c += (h ^= a << 11);
            a += b;
            d += (a ^= b >>> 2);
            b += c;
            e += (b ^= c << 8);
            c += d;
            f += (c ^= d >>> 16);
            d += e;
            g += (d ^= e << 10);
            e += f;
            h += (e ^= f >>> 4);
            f += g;
            a += (f ^= g << 8);
            g += h;
            b += (g ^= h >>> 9);
            this.memory[size] = h += a;
            this.memory[size + 1] = a;
            this.memory[size + 2] = b;
            this.memory[size + 3] = c;
            this.memory[size + 4] = d;
            this.memory[size + 5] = e;
            this.memory[size + 6] = f;
            this.memory[size + 7] = g;
        }
        this.isaac();
        this.count = 256;
    }
}

