/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.net.requester;

import com.ornate.Client;
import com.ornate.ClientConstants;
import com.ornate.cache.Archive;
import com.ornate.collection.Queue;
import com.ornate.collection.RSDeque;
import com.ornate.io.Buffer;
import com.ornate.net.requester.Provider;
import com.ornate.net.requester.Resource;
import com.ornate.sign.SignLink;
import com.ornate.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;

public final class ResourceProvider
extends Provider
implements Runnable {
    private int totalFiles;
    private final RSDeque requested;
    private int maximumPriority;
    public String loadingMessage = "";
    private int deadTime;
    private long lastRequestTime;
    private int[] landscapes;
    private final byte[] payload;
    public int tick;
    private final byte[][] fileStatus;
    private Client clientInstance;
    private final RSDeque extras;
    private int completedSize;
    private int remainingData;
    private int[] musicPriorities;
    public int errors;
    private int[] mapFiles;
    private int filesLoaded;
    private boolean running = true;
    private OutputStream outputStream;
    private int[] membersArea;
    private boolean expectingData = false;
    private final RSDeque complete;
    private final byte[] gzipInputBuffer;
    private int[] anIntArray1360;
    private final Queue requests;
    private InputStream inputStream;
    private Socket socket;
    private final int[][] versions;
    private int uncompletedCount;
    private int completedCount;
    private final RSDeque unrequested;
    private Resource current;
    private final RSDeque mandatoryRequests;
    private int[] areas;
    private byte[] modelIndices;
    private int idleTime;
    private final CRC32 crc32;
    public String currentDownload = "";
    public int[] file_amounts = new int[4];
    private final String[] crcNames = new String[]{"model_crc", "anim_crc", "midi_crc", "map_crc"};
    private final int[][] crcs = new int[this.crcNames.length][];
    private boolean debugCheapHaxValues = false;
    int[] cheapHaxValues = new int[]{3627, 3628, 3655, 3656, 3625, 3626, 3629, 3630, 4071, 4072, 5253, 1816, 1817, 3653, 3654, 4067, 4068, 3639, 3640, 1976, 1977, 3571, 3572, 5129, 5130, 2066, 2067, 3545, 3546, 3559, 3560, 3569, 3570, 3551, 3552, 3579, 3580, 3575, 3576, 1766, 1767, 3547, 3548, 3682, 3683, 3696, 3697, 3692, 3693, 4013, 4079, 4080, 4082, 3996, 4083, 4084, 4075, 4076, 3664, 3993, 3994, 3995, 4077, 4078, 4073, 4074, 4011, 4012, 3998, 3999, 4081};

    private String forId(int type) {
        switch (type) {
            case 1: {
                return "Model";
            }
            case 2: {
                return "Animation";
            }
            case 3: {
                return "Sound";
            }
            case 4: {
                return "Map";
            }
        }
        return "";
    }

    public ResourceProvider() {
        this.requested = new RSDeque();
        this.payload = new byte[500];
        this.fileStatus = new byte[4][];
        this.extras = new RSDeque();
        this.complete = new RSDeque();
        this.gzipInputBuffer = new byte[465000];
        this.requests = new Queue();
        this.versions = new int[4][];
        this.unrequested = new RSDeque();
        this.mandatoryRequests = new RSDeque();
        this.crc32 = new CRC32();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respond() {
        try {
            int available = this.inputStream.available();
            if (this.remainingData == 0 && available >= 10) {
                this.expectingData = true;
                for (int skip = 0; skip < 10; skip += this.inputStream.read(this.payload, skip, 10 - skip)) {
                }
                int type = this.payload[0] & 0xFF;
                int file = ((this.payload[1] & 0xFF) << 16) + ((this.payload[2] & 0xFF) << 8) + (this.payload[3] & 0xFF);
                int length = ((this.payload[4] & 0xFF) << 32) + ((this.payload[5] & 0xFF) << 16) + ((this.payload[6] & 0xFF) << 8) + (this.payload[7] & 0xFF);
                int sector = ((this.payload[8] & 0xFF) << 8) + (this.payload[9] & 0xFF);
                this.current = null;
                Resource resource = (Resource)this.requested.reverseGetFirst();
                while (resource != null) {
                    if (resource.dataType == type && resource.ID == file) {
                        this.current = resource;
                    }
                    if (this.current != null) {
                        resource.loopCycle = 0;
                    }
                    resource = (Resource)this.requested.reverseGetNext();
                }
                if (this.current != null) {
                    this.currentDownload = "Downloading " + this.forId(this.current.dataType + 1) + " " + this.current.ID;
                    this.idleTime = 0;
                    if (length == 0) {
                        SignLink.reporterror("Rej: " + type + "," + file);
                        this.current.buffer = null;
                        if (this.current.incomplete) {
                            RSDeque rSDeque = this.complete;
                            synchronized (rSDeque) {
                                this.complete.insertHead(this.current);
                            }
                        } else {
                            this.current.unlink();
                        }
                        this.current = null;
                    } else {
                        if (this.current.buffer == null && sector == 0) {
                            this.current.buffer = new byte[length];
                        }
                        if (this.current.buffer == null && sector != 0) {
                            throw new IOException("missing start of file");
                        }
                    }
                }
                this.completedSize = sector * 500;
                this.remainingData = 500;
                if (this.remainingData > length - sector * 500) {
                    this.remainingData = length - sector * 500;
                }
            }
            if (this.remainingData > 0 && available >= this.remainingData) {
                this.expectingData = true;
                byte[] data = this.payload;
                int read = 0;
                if (this.current != null) {
                    data = this.current.buffer;
                    read = this.completedSize;
                }
                for (int skip = 0; skip < this.remainingData; skip += this.inputStream.read(data, skip + read, this.remainingData - skip)) {
                }
                if (this.remainingData + this.completedSize >= data.length && this.current != null) {
                    if (this.clientInstance.indices[0] != null) {
                        this.clientInstance.indices[this.current.dataType + 1].writeFile(data.length, data, this.current.ID);
                    }
                    if (!this.current.incomplete && this.current.dataType == 3) {
                        this.current.incomplete = true;
                        this.current.dataType = 93;
                    }
                    if (this.current.incomplete) {
                        RSDeque rSDeque = this.complete;
                        synchronized (rSDeque) {
                            this.complete.insertHead(this.current);
                        }
                    } else {
                        this.current.unlink();
                    }
                }
                this.remainingData = 0;
            }
        }
        catch (IOException ex) {
            try {
                this.socket.close();
            }
            catch (Exception _ex) {
                _ex.printStackTrace();
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
            this.remainingData = 0;
        }
    }

    public void initialize(Archive archive, Client client) {
        for (int i = 0; i < this.crcNames.length; ++i) {
            byte[] crc_file = archive.get(this.crcNames[i]);
            int length = 0;
            if (crc_file == null) continue;
            length = crc_file.length / 4;
            Buffer crcStream = new Buffer(crc_file);
            this.crcs[i] = new int[length];
            this.fileStatus[i] = new byte[length];
            for (int ptr = 0; ptr < length; ++ptr) {
                this.crcs[i][ptr] = crcStream.readInt();
            }
        }
        byte[] data = ClientConstants.LOAD_OSRS_DATA_FROM_CACHE_DIR ? FileUtils.read(ClientConstants.DATA_DIR + "/maps/map_index") : archive.get("map_index");
        Buffer stream = new Buffer(data);
        int j1 = stream.readUShort();
        this.areas = new int[j1];
        this.mapFiles = new int[j1];
        this.landscapes = new int[j1];
        this.file_amounts[3] = j1;
        for (int i2 = 0; i2 < j1; ++i2) {
            this.areas[i2] = stream.readUShort();
            this.mapFiles[i2] = stream.readUShort();
            this.landscapes[i2] = stream.readUShort();
            int finalI2 = i2;
            if (!this.debugCheapHaxValues || !Arrays.stream(this.cheapHaxValues).anyMatch(id -> id == this.mapFiles[finalI2])) continue;
            System.out.println("Area: " + this.areas[i2]);
        }
        System.out.println(String.format("Loaded %d maps loading OSRS version %d and SUB version %d", this.file_amounts[3], 204, 2));
        data = archive.get("midi_index");
        stream = new Buffer(data);
        this.file_amounts[2] = j1 = data.length;
        this.musicPriorities = new int[j1];
        for (int k2 = 0; k2 < j1; ++k2) {
            this.musicPriorities[k2] = stream.readUByte();
        }
        System.out.println(String.format("Loaded %d sounds loading OSRS version %d and SUB version %d", this.file_amounts[2], 204, 2));
        data = archive.get("model_index");
        this.file_amounts[1] = data.length;
        data = archive.get("anim_index");
        this.file_amounts[0] = data.length;
        System.out.println(String.format("Loaded %d models loading OSRS version %d and SUB version %d", this.file_amounts[0], 204, 2));
        this.clientInstance = client;
        this.running = true;
        this.clientInstance.startRunnable(this, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remaining() {
        Queue queue = this.requests;
        synchronized (queue) {
            return this.requests.size();
        }
    }

    public void disable() {
        this.running = false;
    }

    public void preloadMaps(boolean members) {
        for (int area = 0; area < this.areas.length; ++area) {
            if (!members && this.membersArea[area] == 0) continue;
            this.requestExtra((byte)2, 3, this.landscapes[area]);
            this.requestExtra((byte)2, 3, this.mapFiles[area]);
        }
    }

    public int getVersionCount(int index) {
        return this.versions[index].length;
    }

    private void request(Resource resource) {
    }

    public int getAnimCount() {
        return 33568;
    }

    public int getModelCount() {
        return 120000;
    }

    @Override
    public final void provide(int file) {
        this.provide(0, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provide(int type, int file) {
        if (type < 0 || file < 0) {
            return;
        }
        Queue queue = this.requests;
        synchronized (queue) {
            Resource resource = (Resource)this.requests.reverseGetFirst();
            while (resource != null) {
                if (resource.dataType == type && resource.ID == file) {
                    return;
                }
                resource = (Resource)this.requests.reverseGetNext();
            }
            resource = new Resource();
            resource.dataType = type;
            resource.ID = file;
            resource.incomplete = true;
            RSDeque rSDeque = this.mandatoryRequests;
            synchronized (rSDeque) {
                this.mandatoryRequests.insertHead(resource);
            }
            this.requests.insertHead(resource);
        }
    }

    public int getModelIndex(int i) {
        return this.modelIndices[i] & 0xFF;
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                ++this.tick;
                int sleepTime = 20;
                if (this.maximumPriority == 0 && this.clientInstance.indices[0] != null) {
                    sleepTime = 50;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.expectingData = true;
                for (int index = 0; index < 100 && this.expectingData; ++index) {
                    this.expectingData = false;
                    this.loadMandatory();
                    this.requestMandatory();
                    if (this.uncompletedCount == 0 && index >= 5) break;
                    this.passive_request();
                    if (this.inputStream == null) continue;
                    this.respond();
                }
                boolean idle = false;
                Resource resource = (Resource)this.requested.reverseGetFirst();
                while (resource != null) {
                    if (resource.incomplete) {
                        idle = true;
                        ++resource.loopCycle;
                        if (resource.loopCycle > 50) {
                            resource.loopCycle = 0;
                            this.request(resource);
                        }
                    }
                    resource = (Resource)this.requested.reverseGetNext();
                }
                if (!idle) {
                    resource = (Resource)this.requested.reverseGetFirst();
                    while (resource != null) {
                        idle = true;
                        ++resource.loopCycle;
                        if (resource.loopCycle > 50) {
                            resource.loopCycle = 0;
                            this.request(resource);
                        }
                        resource = (Resource)this.requested.reverseGetNext();
                    }
                }
                if (idle) {
                    ++this.idleTime;
                    if (this.idleTime <= 750) continue;
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.socket = null;
                    this.inputStream = null;
                    this.outputStream = null;
                    this.remainingData = 0;
                    continue;
                }
                this.idleTime = 0;
                this.loadingMessage = "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SignLink.reporterror("od_ex " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passive_request(int type, int file) {
        if (this.clientInstance.indices[0] == null) {
            return;
        }
        if (this.maximumPriority == 0) {
            return;
        }
        Resource resource = new Resource();
        resource.dataType = file;
        resource.ID = type;
        resource.incomplete = false;
        RSDeque rSDeque = this.extras;
        synchronized (rSDeque) {
            this.extras.insertHead(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource next() {
        Resource resource;
        Object object = this.complete;
        synchronized (object) {
            resource = (Resource)this.complete.popHead();
        }
        if (resource == null) {
            return null;
        }
        object = this.requests;
        synchronized (object) {
            resource.unlinkCacheable();
        }
        if (resource.buffer == null) {
            return resource;
        }
        int read = 0;
        try {
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(resource.buffer));
            while (true) {
                if (read == this.gzipInputBuffer.length) {
                    throw new RuntimeException("buffer overflow!");
                }
                int in = gis.read(this.gzipInputBuffer, read, this.gzipInputBuffer.length - read);
                if (in != -1) {
                    read += in;
                    continue;
                }
                break;
            }
        }
        catch (IOException _ex) {
            System.err.println("Failed to unzip model [" + resource.ID + "] type = " + resource.dataType);
            _ex.printStackTrace();
            return null;
        }
        resource.buffer = new byte[read];
        System.arraycopy(this.gzipInputBuffer, 0, resource.buffer, 0, read);
        return resource;
    }

    public int getMapIdForRegions(int landscapeOrObject, int regionY, int regionX) {
        int code = (regionX << 8) + regionY;
        for (int area = 0; area < this.areas.length; ++area) {
            if (this.areas[area] != code) continue;
            if (landscapeOrObject == 0) {
                return this.mapFiles[area] > 9999 ? -1 : this.mapFiles[area];
            }
            return this.landscapes[area] > 9999 ? -1 : this.landscapes[area];
        }
        int regionId = (regionX << 8) + regionY;
        for (int j1 = 0; j1 < this.areas.length; ++j1) {
            if (this.areas[j1] != regionId) continue;
            if (landscapeOrObject == 0) {
                if (this.mapFiles[j1] >= 3700 && this.mapFiles[j1] <= 3840) {
                    return this.mapFiles[j1];
                }
                for (int cheapHax : this.mapFiles) {
                    if (this.mapFiles[j1] != cheapHax) continue;
                    return this.mapFiles[j1];
                }
                return this.mapFiles[j1] > 3535 ? -1 : this.mapFiles[j1];
            }
            if (this.landscapes[j1] >= 3700 && this.landscapes[j1] <= 3840) {
                return this.landscapes[j1];
            }
            for (int cheapHax : this.cheapHaxValues) {
                if (this.landscapes[j1] != cheapHax) continue;
                return this.landscapes[j1];
            }
            return this.landscapes[j1] > 3535 ? -1 : this.landscapes[j1];
        }
        return -1;
    }

    public void requestExtra(byte priority, int type, int file) {
        if (this.clientInstance.indices[0] == null) {
            return;
        }
        byte[] data = this.clientInstance.indices[type + 1].decompress(file);
        if (this.crcMatches(this.crcs[type][file], data)) {
            return;
        }
        this.fileStatus[type][file] = priority;
        if (priority > this.maximumPriority) {
            this.maximumPriority = priority;
        }
        ++this.totalFiles;
    }

    public boolean landscapePresent(int landscape) {
        for (int index = 0; index < this.areas.length; ++index) {
            if (this.landscapes[index] != landscape) continue;
            return true;
        }
        return false;
    }

    private void requestMandatory() {
        Resource request;
        this.uncompletedCount = 0;
        this.completedCount = 0;
        Resource resource = (Resource)this.requested.reverseGetFirst();
        while (resource != null) {
            if (resource.incomplete) {
                ++this.uncompletedCount;
                if (!ClientConstants.JAGCACHED_ENABLED) {
                    System.err.println("Error: model is incomplete or missing  [ type = " + resource.dataType + "]  [id = " + resource.ID + "]");
                }
            } else {
                ++this.completedCount;
            }
            resource = (Resource)this.requested.reverseGetNext();
        }
        while (this.uncompletedCount < 10 && (request = (Resource)this.unrequested.popHead()) != null) {
            try {
                if (this.fileStatus[request.dataType][request.ID] != 0) {
                    ++this.filesLoaded;
                }
                this.fileStatus[request.dataType][request.ID] = 0;
                this.requested.insertHead(request);
                ++this.uncompletedCount;
                this.request(request);
                this.expectingData = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExtras() {
        RSDeque rSDeque = this.extras;
        synchronized (rSDeque) {
            this.extras.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMandatory() {
        Resource resource;
        RSDeque rSDeque = this.mandatoryRequests;
        synchronized (rSDeque) {
            resource = (Resource)this.mandatoryRequests.popHead();
        }
        while (resource != null) {
            this.expectingData = true;
            byte[] data = null;
            if (this.clientInstance.indices[0] != null) {
                data = this.clientInstance.indices[resource.dataType + 1].decompress(resource.ID);
            }
            if (ClientConstants.JAGCACHED_ENABLED && !this.crcMatches(this.crcs[resource.dataType][resource.ID], data)) {
                data = null;
            }
            RSDeque rSDeque2 = this.mandatoryRequests;
            synchronized (rSDeque2) {
                if (data == null) {
                    this.unrequested.insertHead(resource);
                } else {
                    resource.buffer = data;
                    RSDeque rSDeque3 = this.complete;
                    synchronized (rSDeque3) {
                        this.complete.insertHead(resource);
                    }
                }
                resource = (Resource)this.mandatoryRequests.popHead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passive_request() {
        while (this.uncompletedCount == 0 && this.completedCount < 10 && this.maximumPriority != 0) {
            Resource resource;
            RSDeque rSDeque = this.extras;
            synchronized (rSDeque) {
                resource = (Resource)this.extras.popHead();
            }
            while (resource != null) {
                if (this.fileStatus[resource.dataType][resource.ID] != 0) {
                    this.fileStatus[resource.dataType][resource.ID] = 0;
                    this.requested.insertHead(resource);
                    this.request(resource);
                    this.expectingData = true;
                    if (this.filesLoaded < this.totalFiles) {
                        ++this.filesLoaded;
                    }
                    this.loadingMessage = "Loading extra files - " + this.filesLoaded * 100 / this.totalFiles + "%";
                    ++this.completedCount;
                    if (this.completedCount == 10) {
                        return;
                    }
                }
                rSDeque = this.extras;
                synchronized (rSDeque) {
                    resource = (Resource)this.extras.popHead();
                }
            }
            for (int type = 0; type < 4; ++type) {
                byte[] data = this.fileStatus[type];
                int size = data.length;
                for (int file = 0; file < size; ++file) {
                    if (data[file] != this.maximumPriority) continue;
                    data[file] = 0;
                    Resource newResource = new Resource();
                    newResource.dataType = type;
                    newResource.ID = file;
                    newResource.incomplete = false;
                    this.requested.insertHead(newResource);
                    this.request(newResource);
                    this.expectingData = true;
                    if (this.filesLoaded < this.totalFiles) {
                        ++this.filesLoaded;
                    }
                    this.loadingMessage = "Loading extra files - " + this.filesLoaded * 100 / this.totalFiles + "%";
                    ++this.completedCount;
                    if (this.completedCount != 10) continue;
                    return;
                }
            }
            --this.maximumPriority;
        }
    }

    public boolean highPriorityMusic(int file) {
        return this.musicPriorities[file] == 1;
    }

    private boolean crcMatches(int expectedValue, byte[] crcData) {
        if (crcData == null || crcData.length < 2) {
            return false;
        }
        int length = crcData.length - 2;
        this.crc32.reset();
        this.crc32.update(crcData, 0, length);
        int crcValue = (int)this.crc32.getValue();
        return crcValue == expectedValue;
    }

    public void writeAll() {
        for (int i = 0; i < this.crcs.length; ++i) {
            this.writeChecksumList(i);
            this.writeVersionList(i);
        }
    }

    public int getChecksum(int type, int id) {
        int crc = -1;
        byte[] data = this.clientInstance.indices[type + 1].decompress(id);
        if (data != null) {
            int length = data.length - 2;
            this.crc32.reset();
            this.crc32.update(data, 0, length);
            crc = (int)this.crc32.getValue();
        }
        return crc;
    }

    public int getVersion(int type, int id) {
        int version = -1;
        byte[] data = this.clientInstance.indices[type + 1].decompress(id);
        if (data != null) {
            int length = data.length - 2;
            version = ((data[length] & 0xFF) << 8) + (data[length + 1] & 0xFF);
        }
        return version;
    }

    public void writeChecksumList(int type) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(SignLink.findCacheDir() + type + "_crc.dat"));
            int total = 0;
            int index = 0;
            while ((long)index < this.clientInstance.indices[type + 1].getFileCount()) {
                out.writeInt(this.getChecksum(type, index));
                ++total;
                ++index;
            }
            System.out.println(type + "-" + total);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeVersionList(int type) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(SignLink.findCacheDir() + type + "_version.dat"));
            int index = 0;
            while ((long)index < this.clientInstance.indices[type + 1].getFileCount()) {
                out.writeShort(this.getVersion(type, index));
                ++index;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

