/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.scene;

public final class CollisionMap {
    private static final int BLOCKED_TILE = 0x200000;
    private final int inset_x;
    private final int inset_y;
    private final int width;
    private final int height;
    public final int[][] adjacencies;

    public CollisionMap() {
        this.inset_x = 0;
        this.inset_y = 0;
        this.width = 104;
        this.height = 104;
        this.adjacencies = new int[this.width][this.height];
        this.init();
    }

    public void init() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.adjacencies[x][y] = x == 0 || y == 0 || x == this.width - 1 || y == this.height - 1 ? 0xFFFFFF : 0x1000000;
            }
        }
    }

    public void mark_wall(int y, int orientation, int x, int group, boolean walkable) {
        x -= this.inset_x;
        y -= this.inset_y;
        if (group == 0) {
            if (orientation == 0) {
                this.set(x, y, 128);
                this.set(x - 1, y, 8);
            }
            if (orientation == 1) {
                this.set(x, y, 2);
                this.set(x, y + 1, 32);
            }
            if (orientation == 2) {
                this.set(x, y, 8);
                this.set(x + 1, y, 128);
            }
            if (orientation == 3) {
                this.set(x, y, 32);
                this.set(x, y - 1, 2);
            }
        }
        if (group == 1 || group == 3) {
            if (orientation == 0) {
                this.set(x, y, 1);
                this.set(x - 1, y + 1, 16);
            }
            if (orientation == 1) {
                this.set(x, y, 4);
                this.set(x + 1, y + 1, 64);
            }
            if (orientation == 2) {
                this.set(x, y, 16);
                this.set(x + 1, y - 1, 1);
            }
            if (orientation == 3) {
                this.set(x, y, 64);
                this.set(x - 1, y - 1, 4);
            }
        }
        if (group == 2) {
            if (orientation == 0) {
                this.set(x, y, 130);
                this.set(x - 1, y, 8);
                this.set(x, y + 1, 32);
            }
            if (orientation == 1) {
                this.set(x, y, 10);
                this.set(x, y + 1, 32);
                this.set(x + 1, y, 128);
            }
            if (orientation == 2) {
                this.set(x, y, 40);
                this.set(x + 1, y, 128);
                this.set(x, y - 1, 2);
            }
            if (orientation == 3) {
                this.set(x, y, 160);
                this.set(x, y - 1, 2);
                this.set(x - 1, y, 8);
            }
        }
        if (walkable) {
            if (group == 0) {
                if (orientation == 0) {
                    this.set(x, y, 65536);
                    this.set(x - 1, y, 4096);
                }
                if (orientation == 1) {
                    this.set(x, y, 1024);
                    this.set(x, y + 1, 16384);
                }
                if (orientation == 2) {
                    this.set(x, y, 4096);
                    this.set(x + 1, y, 65536);
                }
                if (orientation == 3) {
                    this.set(x, y, 16384);
                    this.set(x, y - 1, 1024);
                }
            }
            if (group == 1 || group == 3) {
                if (orientation == 0) {
                    this.set(x, y, 512);
                    this.set(x - 1, y + 1, 8192);
                }
                if (orientation == 1) {
                    this.set(x, y, 2048);
                    this.set(x + 1, y + 1, 32768);
                }
                if (orientation == 2) {
                    this.set(x, y, 8192);
                    this.set(x + 1, y - 1, 512);
                }
                if (orientation == 3) {
                    this.set(x, y, 32768);
                    this.set(x - 1, y - 1, 2048);
                }
            }
            if (group == 2) {
                if (orientation == 0) {
                    this.set(x, y, 66560);
                    this.set(x - 1, y, 4096);
                    this.set(x, y + 1, 16384);
                }
                if (orientation == 1) {
                    this.set(x, y, 5120);
                    this.set(x, y + 1, 16384);
                    this.set(x + 1, y, 65536);
                }
                if (orientation == 2) {
                    this.set(x, y, 20480);
                    this.set(x + 1, y, 65536);
                    this.set(x, y - 1, 1024);
                }
                if (orientation == 3) {
                    this.set(x, y, 81920);
                    this.set(x, y - 1, 1024);
                    this.set(x - 1, y, 4096);
                }
            }
        }
    }

    public void mark_interactive_obj(boolean walkable, int width, int height, int x, int y, int orientation) {
        int flag = 256;
        if (walkable) {
            flag += 131072;
        }
        x -= this.inset_x;
        y -= this.inset_y;
        if (orientation == 1 || orientation == 3) {
            int pos = width;
            width = height;
            height = pos;
        }
        for (int x_pos = x; x_pos < x + width; ++x_pos) {
            if (x_pos < 0 || x_pos >= this.width) continue;
            for (int y_pos = y; y_pos < y + height; ++y_pos) {
                if (y_pos < 0 || y_pos >= this.height) continue;
                this.set(x_pos, y_pos, flag);
            }
        }
    }

    public void set_solid_flag(int x, int y) {
        int[] nArray = this.adjacencies[x -= this.inset_x];
        int n = y -= this.inset_y;
        nArray[n] = nArray[n] | 0x200000;
    }

    private void set(int x, int y, int flag) {
        int[] nArray = this.adjacencies[x];
        int n = y;
        nArray[n] = nArray[n] | flag;
    }

    public void clear_wall(int orientation, int type, boolean walkable, int x, int y) {
        x -= this.inset_x;
        y -= this.inset_y;
        if (type == 0) {
            if (orientation == 0) {
                this.unset(128, x, y);
                this.unset(8, x - 1, y);
            }
            if (orientation == 1) {
                this.unset(2, x, y);
                this.unset(32, x, y + 1);
            }
            if (orientation == 2) {
                this.unset(8, x, y);
                this.unset(128, x + 1, y);
            }
            if (orientation == 3) {
                this.unset(32, x, y);
                this.unset(2, x, y - 1);
            }
        }
        if (type == 1 || type == 3) {
            if (orientation == 0) {
                this.unset(1, x, y);
                this.unset(16, x - 1, y + 1);
            }
            if (orientation == 1) {
                this.unset(4, x, y);
                this.unset(64, x + 1, y + 1);
            }
            if (orientation == 2) {
                this.unset(16, x, y);
                this.unset(1, x + 1, y - 1);
            }
            if (orientation == 3) {
                this.unset(64, x, y);
                this.unset(4, x - 1, y - 1);
            }
        }
        if (type == 2) {
            if (orientation == 0) {
                this.unset(130, x, y);
                this.unset(8, x - 1, y);
                this.unset(32, x, y + 1);
            }
            if (orientation == 1) {
                this.unset(10, x, y);
                this.unset(32, x, y + 1);
                this.unset(128, x + 1, y);
            }
            if (orientation == 2) {
                this.unset(40, x, y);
                this.unset(128, x + 1, y);
                this.unset(2, x, y - 1);
            }
            if (orientation == 3) {
                this.unset(160, x, y);
                this.unset(2, x, y - 1);
                this.unset(8, x - 1, y);
            }
        }
        if (walkable) {
            if (type == 0) {
                if (orientation == 0) {
                    this.unset(65536, x, y);
                    this.unset(4096, x - 1, y);
                }
                if (orientation == 1) {
                    this.unset(1024, x, y);
                    this.unset(16384, x, y + 1);
                }
                if (orientation == 2) {
                    this.unset(4096, x, y);
                    this.unset(65536, x + 1, y);
                }
                if (orientation == 3) {
                    this.unset(16384, x, y);
                    this.unset(1024, x, y - 1);
                }
            }
            if (type == 1 || type == 3) {
                if (orientation == 0) {
                    this.unset(512, x, y);
                    this.unset(8192, x - 1, y + 1);
                }
                if (orientation == 1) {
                    this.unset(2048, x, y);
                    this.unset(32768, x + 1, y + 1);
                }
                if (orientation == 2) {
                    this.unset(8192, x, y);
                    this.unset(512, x + 1, y - 1);
                }
                if (orientation == 3) {
                    this.unset(32768, x, y);
                    this.unset(2048, x - 1, y - 1);
                }
            }
            if (type == 2) {
                if (orientation == 0) {
                    this.unset(66560, x, y);
                    this.unset(4096, x - 1, y);
                    this.unset(16384, x, y + 1);
                }
                if (orientation == 1) {
                    this.unset(5120, x, y);
                    this.unset(16384, x, y + 1);
                    this.unset(65536, x + 1, y);
                }
                if (orientation == 2) {
                    this.unset(20480, x, y);
                    this.unset(65536, x + 1, y);
                    this.unset(1024, x, y - 1);
                }
                if (orientation == 3) {
                    this.unset(81920, x, y);
                    this.unset(1024, x, y - 1);
                    this.unset(4096, x - 1, y);
                }
            }
        }
    }

    public void clear_interactive_obj(int orientation, int width, int x, int y, int height, boolean walkable) {
        int flag = 256;
        if (walkable) {
            flag += 131072;
        }
        x -= this.inset_x;
        y -= this.inset_y;
        if (orientation == 1 || orientation == 3) {
            int pos = width;
            width = height;
            height = pos;
        }
        for (int x_pos = x; x_pos < x + width; ++x_pos) {
            if (x_pos < 0 || x_pos >= this.width) continue;
            for (int y_pos = y; y_pos < y + height; ++y_pos) {
                if (y_pos < 0 || y_pos >= this.height) continue;
                this.unset(flag, x_pos, y_pos);
            }
        }
    }

    private void unset(int flag, int x, int k) {
        int[] nArray = this.adjacencies[x];
        int n = k;
        nArray[n] = nArray[n] & 0xFFFFFF - flag;
    }

    public void clear_ground_decor(int y, int x) {
        int[] nArray = this.adjacencies[x -= this.inset_x];
        int n = y -= this.inset_y;
        nArray[n] = nArray[n] & 0xDFFFFF;
    }

    public boolean obstruction_wall(int travel_x, int x, int y, int obstruction_orientation, int obstruction_type, int travel_y) {
        if (x == travel_x && y == travel_y) {
            return true;
        }
        x -= this.inset_x;
        y -= this.inset_y;
        travel_x -= this.inset_x;
        travel_y -= this.inset_y;
        if (obstruction_type == 0) {
            if (obstruction_orientation == 0) {
                if (x == travel_x - 1 && y == travel_y) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 1) {
                if (x == travel_x && y == travel_y + 1) {
                    return true;
                }
                if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280180) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 2) {
                if (x == travel_x + 1 && y == travel_y) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 3) {
                if (x == travel_x && y == travel_y - 1) {
                    return true;
                }
                if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280180) == 0) {
                    return true;
                }
            }
        }
        if (obstruction_type == 2) {
            if (obstruction_orientation == 0) {
                if (x == travel_x - 1 && y == travel_y) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1) {
                    return true;
                }
                if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280180) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 1) {
                if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1) {
                    return true;
                }
                if (x == travel_x + 1 && y == travel_y) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 2) {
                if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == travel_x + 1 && y == travel_y) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1) {
                    return true;
                }
            } else if (obstruction_orientation == 3) {
                if (x == travel_x - 1 && y == travel_y) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x1280180) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1) {
                    return true;
                }
            }
        }
        if (obstruction_type == 9) {
            if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x20) == 0) {
                return true;
            }
            if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 2) == 0) {
                return true;
            }
            if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 8) == 0) {
                return true;
            }
            if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x80) == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean obstruction_decor(int travel_x, int travel_y, int y, int obstruction_type, int obstruction_orientation, int x) {
        if (x == travel_x && y == travel_y) {
            return true;
        }
        x -= this.inset_x;
        y -= this.inset_y;
        travel_x -= this.inset_x;
        travel_y -= this.inset_y;
        if (obstruction_type == 6 || obstruction_type == 7) {
            if (obstruction_type == 7) {
                obstruction_orientation = obstruction_orientation + 2 & 3;
            }
            if (obstruction_orientation == 0) {
                if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x80) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 2) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 1) {
                if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 8) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 2) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 2) {
                if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 8) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x20) == 0) {
                    return true;
                }
            } else if (obstruction_orientation == 3) {
                if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x80) == 0) {
                    return true;
                }
                if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x20) == 0) {
                    return true;
                }
            }
        }
        if (obstruction_type == 8) {
            if (x == travel_x && y == travel_y + 1 && (this.adjacencies[x][y] & 0x20) == 0) {
                return true;
            }
            if (x == travel_x && y == travel_y - 1 && (this.adjacencies[x][y] & 2) == 0) {
                return true;
            }
            if (x == travel_x - 1 && y == travel_y && (this.adjacencies[x][y] & 8) == 0) {
                return true;
            }
            if (x == travel_x + 1 && y == travel_y && (this.adjacencies[x][y] & 0x80) == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean obstruction(int travel_y, int travel_x, int x, int obstruction_height, int orientation, int width, int y) {
        int distance_x = travel_x + width - 1;
        int distance_y = travel_y + obstruction_height - 1;
        if (x >= travel_x && x <= distance_x && y >= travel_y && y <= distance_y) {
            return true;
        }
        if (x == travel_x - 1 && y >= travel_y && y <= distance_y && (this.adjacencies[x - this.inset_x][y - this.inset_y] & 8) == 0 && (orientation & 8) == 0) {
            return true;
        }
        if (x == distance_x + 1 && y >= travel_y && y <= distance_y && (this.adjacencies[x - this.inset_x][y - this.inset_y] & 0x80) == 0 && (orientation & 2) == 0) {
            return true;
        }
        return y == travel_y - 1 && x >= travel_x && x <= distance_x && (this.adjacencies[x - this.inset_x][y - this.inset_y] & 2) == 0 && (orientation & 4) == 0 || y == distance_y + 1 && x >= travel_x && x <= distance_x && (this.adjacencies[x - this.inset_x][y - this.inset_y] & 0x20) == 0 && (orientation & 1) == 0;
    }
}

