/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.scene;

import com.ornate.Client;
import com.ornate.cache.anim.Sequence;
import com.ornate.cache.config.VariableBits;
import com.ornate.cache.def.ObjectDefinition;
import com.ornate.entity.Renderable;
import com.ornate.entity.model.Model;

public final class SceneObject
extends Renderable {
    private int animation_frame;
    private final int[] configs;
    private final int varbit_id;
    private final int config_id;
    private final int cos_y;
    private final int sin_y;
    private final int cos_x;
    private final int sin_x;
    private Sequence seq;
    private int cycle_delay;
    private final int object_id;
    private final int click_type;
    private final int orientation;

    private ObjectDefinition get_configs() {
        int index = -1;
        if (this.varbit_id != -1) {
            try {
                VariableBits varBit = VariableBits.cache[this.varbit_id];
                int setting = varBit.configId;
                int low_varbit = varBit.leastSignificantBit;
                int high_varbit = varBit.mostSignificantBit;
                int bit_mask = Client.BIT_MASKS[high_varbit - low_varbit];
                index = Client.singleton.settings[setting] >> low_varbit & bit_mask;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.config_id != -1 && this.config_id < Client.singleton.settings.length) {
            index = Client.singleton.settings[this.config_id];
        }
        int var = index >= 0 && index < this.configs.length ? this.configs[index] : this.configs[this.configs.length - 1];
        return var != -1 ? ObjectDefinition.get(var) : null;
    }

    @Override
    public Model getRotatedModel() {
        ObjectDefinition def;
        int animation_id = -1;
        if (this.seq != null) {
            int step = Client.game_tick - this.cycle_delay;
            if (step > 100 && this.seq.frameStep > 0) {
                step = 100;
            }
            while (step > this.seq.get_length(this.animation_frame)) {
                step -= this.seq.get_length(this.animation_frame);
                ++this.animation_frame;
                if (this.animation_frame < this.seq.frames) continue;
                this.animation_frame -= this.seq.frameStep;
                if (this.animation_frame >= 0 && this.animation_frame < this.seq.frames) continue;
                this.seq = null;
                break;
            }
            this.cycle_delay = Client.game_tick - step;
            if (this.seq != null) {
                animation_id = this.seq.primary_frame[this.animation_frame];
            }
        }
        if ((def = this.configs != null ? this.get_configs() : ObjectDefinition.get(this.object_id)) == null) {
            return null;
        }
        return def.get_object(this.click_type, this.orientation, this.cos_y, this.sin_y, this.cos_x, this.sin_x, animation_id);
    }

    public SceneObject(int id, int orientation, int click_type, int sin_y, int cos_x, int cos_y, int sin_x, int animation_id, boolean flag) {
        this.object_id = id;
        this.click_type = click_type;
        this.orientation = orientation;
        this.cos_y = cos_y;
        this.sin_y = sin_y;
        this.cos_x = cos_x;
        this.sin_x = sin_x;
        if (animation_id != -1) {
            this.seq = Sequence.cache[animation_id];
            this.animation_frame = 0;
            this.cycle_delay = Client.game_tick;
            if (flag && this.seq.frameStep != -1) {
                this.animation_frame = (int)(Math.random() * (double)this.seq.frames);
                this.cycle_delay -= (int)(Math.random() * (double)this.seq.get_length(this.animation_frame));
            }
        }
        ObjectDefinition def = ObjectDefinition.get(this.object_id);
        this.varbit_id = def.varbit_id;
        this.config_id = def.varp_id;
        this.configs = def.configs;
    }
}

