/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.scene;

import com.ornate.cache.anim.Animation;
import com.ornate.cache.anim.SpotAnimation;
import com.ornate.entity.Renderable;
import com.ornate.entity.model.Model;

public final class StaticObject
extends Renderable {
    public final int z;
    public final int x;
    public final int y;
    public final int height;
    public final int cycle;
    public boolean expired = false;
    private final SpotAnimation graphics;
    private int flow;
    private int duration;

    public StaticObject(int z, int cycle, int offset, int id, int height, int y, int x) {
        this.graphics = SpotAnimation.cache[id];
        this.z = z;
        this.x = x;
        this.y = y;
        this.height = height;
        this.cycle = cycle + offset;
        this.expired = false;
    }

    @Override
    public Model getRotatedModel() {
        Model model = this.graphics.get_model();
        if (model == null) {
            return null;
        }
        int frame = this.graphics.seq.primary_frame[this.flow];
        Model animated_model = new Model(true, Animation.validate(frame), false, model);
        if (!this.expired) {
            animated_model.skin();
            animated_model.interpolate(frame);
            animated_model.face_skin = null;
            animated_model.vertex_skin = null;
        }
        if (this.graphics.model_scale_x != 128 || this.graphics.model_scale_y != 128) {
            animated_model.scale(this.graphics.model_scale_x, this.graphics.model_scale_x, this.graphics.model_scale_y);
        }
        if (this.graphics.rotation != 0) {
            if (this.graphics.rotation == 90) {
                animated_model.rotate_90();
            }
            if (this.graphics.rotation == 180) {
                animated_model.rotate_90();
                animated_model.rotate_90();
            }
            if (this.graphics.rotation == 270) {
                animated_model.rotate_90();
                animated_model.rotate_90();
                animated_model.rotate_90();
            }
        }
        animated_model.light(64 + this.graphics.ambient, 850 + this.graphics.contrast, -30, -50, -30, true);
        return animated_model;
    }

    public void step(int length) {
        this.duration += length;
        while (this.duration > this.graphics.seq.get_length(this.flow)) {
            this.duration -= this.graphics.seq.get_length(this.flow) + 1;
            ++this.flow;
            if (this.flow < this.graphics.seq.frames || this.flow >= 0 && this.flow < this.graphics.seq.frames) continue;
            this.flow = 0;
            this.expired = true;
        }
    }
}

