/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.sign;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class SignLink
implements Runnable {
    public static final int clientversion = 317;
    public static int storeid = 32;
    public static RandomAccessFile cache_dat = null;
    public static final RandomAccessFile[] indices = new RandomAccessFile[5];
    public static boolean sunjava;
    private static boolean active;
    private static int threadLiveId;
    private static InetAddress socketAddress;
    private static int socketRequest;
    private static Socket socket;
    private static int threadreqpri;
    private static Runnable threadreq;
    private static String dnsreq;
    public static String dns;
    private static String urlRequest;
    private static DataInputStream urlStream;
    private static int savelen;
    private static String savereq;
    private static byte[] savebuf;
    private static boolean play;
    private static int midipos;
    public static String midi;
    public static int midiVolume;
    public static int fadeMidi;
    private static boolean waveplay;
    private static int wavepos;
    public static int wavevol;
    public static boolean reporterror;
    public static String errorName;
    public static Sequencer music;
    public static Sequence sequence;
    public static Synthesizer synthesizer;

    private SignLink() {
    }

    public static void startpriv(InetAddress inetaddress) {
        threadLiveId = (int)(Math.random() * 9.9999999E7);
        if (active) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception _ex) {
                _ex.printStackTrace();
            }
            active = false;
        }
        socketRequest = 0;
        threadreq = null;
        dnsreq = null;
        savereq = null;
        urlRequest = null;
        socketAddress = inetaddress;
        Thread thread = new Thread(new SignLink());
        thread.setName("AtlasClientSignLinkStartPrivThread");
        thread.setDaemon(true);
        thread.start();
        while (!active) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception _ex) {
                _ex.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        active = true;
        String directory = SignLink.findCacheDir();
        try {
            cache_dat = new RandomAccessFile(directory + "main_file_cache.dat", "rw");
            for (int index = 0; index < 5; ++index) {
                SignLink.indices[index] = new RandomAccessFile(directory + "main_file_cache.idx" + index, "rw");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int i = threadLiveId;
        while (threadLiveId == i) {
            if (socketRequest != 0) {
                try {
                    socket = new Socket(socketAddress, socketRequest);
                }
                catch (Exception _ex) {
                    _ex.printStackTrace();
                    socket = null;
                }
                socketRequest = 0;
            } else if (threadreq != null) {
                Thread thread = new Thread(threadreq);
                thread.setName("AtlasClientSignLinkThreadReqThread");
                thread.setDaemon(true);
                thread.start();
                thread.setPriority(threadreqpri);
                threadreq = null;
            } else if (dnsreq != null) {
                try {
                    dns = InetAddress.getByName(dnsreq).getHostName();
                }
                catch (Exception _ex) {
                    _ex.printStackTrace();
                    dns = "unknown";
                }
                dnsreq = null;
            } else if (savereq != null) {
                if (savebuf != null) {
                    try {
                        FileOutputStream fileoutputstream = new FileOutputStream(directory + savereq);
                        fileoutputstream.write(savebuf, 0, savelen);
                        fileoutputstream.close();
                    }
                    catch (Exception _ex) {
                        _ex.printStackTrace();
                    }
                }
                if (waveplay) {
                    String wave = directory + savereq;
                    waveplay = false;
                    AudioInputStream audioInputStream = null;
                    try {
                        audioInputStream = AudioSystem.getAudioInputStream(new File(wave));
                    }
                    catch (IOException | UnsupportedAudioFileException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    AudioFormat format = audioInputStream.getFormat();
                    SourceDataLine auline = null;
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                    try {
                        auline = (SourceDataLine)AudioSystem.getLine(info);
                        auline.open(format);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (play) {
                    midi = directory + savereq;
                    try {
                        if (music != null) {
                            music.stop();
                            music.close();
                        }
                        this.playMidi(midi);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    play = false;
                }
                savereq = null;
            } else if (urlRequest != null) {
                try {
                    System.out.println("urlstream");
                }
                catch (Exception _ex) {
                    urlStream = null;
                }
                urlRequest = null;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception _ex) {
                _ex.printStackTrace();
            }
        }
    }

    public static String findCacheDir() {
        String cacheName;
        String separator;
        String home = System.getProperty("user.home");
        String cacheDir = home + (separator = System.getProperty("file.separator")) + (cacheName = ".OrnatePs/") + separator;
        File file = new File(cacheDir);
        if (file.exists() || file.mkdir()) {
            return cacheDir;
        }
        return null;
    }

    public static String findDataDir() {
        String dataName;
        String separator;
        String home = System.getProperty("user.home");
        String cacheDir = home + (separator = System.getProperty("file.separator")) + (dataName = ".OrnatePs-data/") + separator;
        File file = new File(cacheDir);
        if (file.exists() || file.mkdir()) {
            return cacheDir;
        }
        return null;
    }

    private void playMidi(String location) {
        music = null;
        synthesizer = null;
        sequence = null;
        File midiFile = new File(location);
        try {
            sequence = MidiSystem.getSequence(midiFile);
            music = MidiSystem.getSequencer();
            music.open();
            music.setSequence(sequence);
        }
        catch (Exception e) {
            System.err.println("Problem loading MIDI file.");
            e.printStackTrace();
            return;
        }
        if (music instanceof Synthesizer) {
            synthesizer = (Synthesizer)((Object)music);
        } else {
            try {
                synthesizer = MidiSystem.getSynthesizer();
                synthesizer.open();
                if (synthesizer.getDefaultSoundbank() == null) {
                    music.getTransmitter().setReceiver(MidiSystem.getReceiver());
                } else {
                    music.getTransmitter().setReceiver(synthesizer.getReceiver());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        music.setLoopCount(-1);
        music.start();
    }

    public static void setVolume(int value) {
        int CHANGE_VOLUME = 7;
        midiVolume = value;
        if (synthesizer.getDefaultSoundbank() == null) {
            try {
                ShortMessage volumeMessage = new ShortMessage();
                for (int i = 0; i < 16; ++i) {
                    volumeMessage.setMessage(176, i, CHANGE_VOLUME, midiVolume);
                    volumeMessage.setMessage(176, i, 39, midiVolume);
                    MidiSystem.getReceiver().send(volumeMessage, -1L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            MidiChannel[] channels = synthesizer.getChannels();
            for (int c = 0; channels != null && c < channels.length; ++c) {
                channels[c].controlChange(CHANGE_VOLUME, midiVolume);
                channels[c].controlChange(39, midiVolume);
            }
        }
    }

    public static synchronized boolean saveWave(byte[] abyte0, int i) {
        if (i > 2000000) {
            return false;
        }
        if (savereq != null) {
            return false;
        }
        wavepos = (wavepos + 1) % 5;
        savelen = i;
        savebuf = abyte0;
        waveplay = true;
        savereq = "sound" + wavepos + ".wav";
        return true;
    }

    public static synchronized boolean replayWave() {
        if (savereq != null) {
            return false;
        }
        savebuf = null;
        waveplay = true;
        savereq = "sound" + wavepos + ".wav";
        return true;
    }

    public static synchronized void saveMidi(byte[] abyte0, int i) {
        if (i > 2000000) {
            return;
        }
        if (savereq == null) {
            midipos = (midipos + 1) % 5;
            savelen = i;
            savebuf = abyte0;
            play = true;
            savereq = "jingle" + midipos + ".mid";
        }
    }

    public static synchronized Socket openSocket(int port) throws IOException {
        socketRequest = port;
        while (socketRequest != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (socket == null) {
            throw new IOException("could not open socket");
        }
        return socket;
    }

    public static synchronized DataInputStream openUrl(String url) throws IOException {
        urlRequest = url;
        while (urlRequest != null) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (urlStream == null) {
            throw new IOException("could not open: " + url);
        }
        return urlStream;
    }

    public static synchronized void dnslookup(String s) {
        dns = s;
        dnsreq = s;
    }

    public static synchronized void startthread(Runnable runnable, int i) {
        threadreqpri = i;
        threadreq = runnable;
    }

    public static synchronized boolean wavesave(byte[] abyte0, int i) {
        if (i > 2000000) {
            return false;
        }
        if (savereq != null) {
            return false;
        }
        wavepos = (wavepos + 1) % 5;
        savelen = i;
        savebuf = abyte0;
        waveplay = true;
        savereq = "sound" + wavepos + ".wav";
        return true;
    }

    public static synchronized boolean wavereplay() {
        if (savereq != null) {
            return false;
        }
        savebuf = null;
        waveplay = true;
        savereq = "sound" + wavepos + ".wav";
        return true;
    }

    public static String indexLocation(int cacheIndex, int index) {
        return SignLink.findCacheDir() + "index" + cacheIndex + "/" + (String)(index != -1 ? index + ".gz" : "");
    }

    public static void reporterror(String s) {
        System.err.println("Error: " + s);
    }

    public static void setError(String error) {
        errorName = error;
    }

    static {
        socket = null;
        threadreqpri = 1;
        threadreq = null;
        dnsreq = null;
        dns = null;
        urlRequest = null;
        urlStream = null;
        savereq = null;
        savebuf = null;
        midi = null;
        reporterror = true;
        errorName = "";
        music = null;
        sequence = null;
        synthesizer = null;
    }
}

