/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.sound;

import com.ornate.io.Buffer;

final class Envelope {
    private int segments;
    private int[] durations;
    private int[] peaks;
    int start;
    int end;
    int form;
    private int threshold;
    private int segmentIndex;
    private int step;
    private int amplitude;
    private int ticks;

    Envelope() {
    }

    public void decode(Buffer stream) {
        this.form = stream.readUByte();
        this.start = stream.readInt();
        this.end = stream.readInt();
        this.decodeSegments(stream);
    }

    public void decodeSegments(Buffer stream) {
        this.segments = stream.readUByte();
        this.durations = new int[this.segments];
        this.peaks = new int[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            this.durations[i] = stream.readUShort();
            this.peaks[i] = stream.readUShort();
        }
    }

    void reset() {
        this.threshold = 0;
        this.segmentIndex = 0;
        this.step = 0;
        this.amplitude = 0;
        this.ticks = 0;
    }

    int step(int period) {
        if (this.ticks >= this.threshold) {
            this.amplitude = this.peaks[this.segmentIndex++] << 15;
            if (this.segmentIndex >= this.segments) {
                this.segmentIndex = this.segments - 1;
            }
            this.threshold = (int)((double)this.durations[this.segmentIndex] / 65536.0 * (double)period);
            if (this.threshold > this.ticks) {
                this.step = ((this.peaks[this.segmentIndex] << 15) - this.amplitude) / (this.threshold - this.ticks);
            }
        }
        this.amplitude += this.step;
        ++this.ticks;
        return this.amplitude - this.step >> 15;
    }
}

