/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.sound;

import com.ornate.io.Buffer;
import com.ornate.sound.Envelope;

final class Filter {
    final int[] pairs = new int[2];
    private final int[][][] phases = new int[2][2][4];
    private final int[][][] magnitudes = new int[2][2][4];
    private final int[] unity = new int[2];
    private static final float[][] minimisedCoefficients = new float[2][8];
    static final int[][] coefficients = new int[2][8];
    private static float forwardMinimisedCoefficientMultiplier;
    static int forwardMultiplier;

    private float interpolateMagnitude(int direction, int pair, float step) {
        float magnitude = (float)this.magnitudes[direction][0][pair] + step * (float)(this.magnitudes[direction][1][pair] - this.magnitudes[direction][0][pair]);
        return 1.0f - (float)Math.pow(10.0, -(magnitude *= 0.001525879f) / 20.0f);
    }

    private float normalise(float exponent) {
        float f1 = 32.7032f * (float)Math.pow(2.0, exponent);
        return f1 * 3.141593f / 11025.0f;
    }

    private float interpolatePhase(int direction, int pair, float step) {
        float phase = (float)this.phases[direction][0][pair] + step * (float)(this.phases[direction][1][pair] - this.phases[direction][0][pair]);
        return this.normalise(phase *= 1.220703E-4f);
    }

    public int compute(int direction, float step) {
        int pair;
        if (direction == 0) {
            float unity = (float)this.unity[0] + (float)(this.unity[1] - this.unity[0]) * step;
            forwardMinimisedCoefficientMultiplier = (float)Math.pow(0.1, (unity *= 0.003051758f) / 20.0f);
            forwardMultiplier = (int)(forwardMinimisedCoefficientMultiplier * 65536.0f);
        }
        if (this.pairs[direction] == 0) {
            return 0;
        }
        float initialMagnitude = this.interpolateMagnitude(direction, 0, step);
        Filter.minimisedCoefficients[direction][0] = -2.0f * initialMagnitude * (float)Math.cos(this.interpolatePhase(direction, 0, step));
        Filter.minimisedCoefficients[direction][1] = initialMagnitude * initialMagnitude;
        for (pair = 1; pair < this.pairs[direction]; ++pair) {
            float magnitude = this.interpolateMagnitude(direction, pair, step);
            float f4 = -2.0f * magnitude * (float)Math.cos(this.interpolatePhase(direction, pair, step));
            float f5 = magnitude * magnitude;
            Filter.minimisedCoefficients[direction][pair * 2 + 1] = minimisedCoefficients[direction][pair * 2 - 1] * f5;
            Filter.minimisedCoefficients[direction][pair * 2] = minimisedCoefficients[direction][pair * 2 - 1] * f4 + minimisedCoefficients[direction][pair * 2 - 2] * f5;
            for (int j1 = pair * 2 - 1; j1 >= 2; --j1) {
                float[] fArray = minimisedCoefficients[direction];
                int n = j1;
                fArray[n] = fArray[n] + (minimisedCoefficients[direction][j1 - 1] * f4 + minimisedCoefficients[direction][j1 - 2] * f5);
            }
            float[] fArray = minimisedCoefficients[direction];
            fArray[1] = fArray[1] + (minimisedCoefficients[direction][0] * f4 + f5);
            float[] fArray2 = minimisedCoefficients[direction];
            fArray2[0] = fArray2[0] + f4;
        }
        if (direction == 0) {
            int l = 0;
            while (l < this.pairs[0] * 2) {
                float[] fArray = minimisedCoefficients[0];
                int n = l++;
                fArray[n] = fArray[n] * forwardMinimisedCoefficientMultiplier;
            }
        }
        for (pair = 0; pair < this.pairs[direction] * 2; ++pair) {
            Filter.coefficients[direction][pair] = (int)(minimisedCoefficients[direction][pair] * 65536.0f);
        }
        return this.pairs[direction] * 2;
    }

    public void decode(Buffer stream, Envelope soundEnveleope) {
        int count = stream.readUByte();
        this.pairs[0] = count >> 4;
        this.pairs[1] = count & 0xF;
        if (count != 0) {
            this.unity[0] = stream.readUShort();
            this.unity[1] = stream.readUShort();
            int migration = stream.readUByte();
            for (int k = 0; k < 2; ++k) {
                for (int l = 0; l < this.pairs[k]; ++l) {
                    this.phases[k][0][l] = stream.readUShort();
                    this.magnitudes[k][0][l] = stream.readUShort();
                }
            }
            for (int direction = 0; direction < 2; ++direction) {
                for (int pair = 0; pair < this.pairs[direction]; ++pair) {
                    if ((migration & 1 << direction * 4 << pair) != 0) {
                        this.phases[direction][1][pair] = stream.readUShort();
                        this.magnitudes[direction][1][pair] = stream.readUShort();
                        continue;
                    }
                    this.phases[direction][1][pair] = this.phases[direction][0][pair];
                    this.magnitudes[direction][1][pair] = this.magnitudes[direction][0][pair];
                }
            }
            if (migration != 0 || this.unity[1] != this.unity[0]) {
                soundEnveleope.decodeSegments(stream);
            }
        } else {
            this.unity[1] = 0;
            this.unity[0] = 0;
        }
    }
}

